---
head.title: 'Native Docker Health Checks for Laravel - Docker PHP - Server Side Up'
description: 'Stop guessing if Laravel is up and running. Our health checks have you covered to ensure Laravel is running properly. It supports HTTP checks, Laravel Horizon, Reverb, Scheduler, and Queue.'
layout: docs
---

# Native Docker Health Checks for Laravel
::lead-p
Dialing in health checks are very important for ensuring your application is running smoothly and that you're able to deploy updates without any downtime. This guide will explain how our health checks work and how you can use them to your advantage.
::

## What are Health Checks?

Health checks are a way to check the status of your application. Whenever a container is started, a health check is performed. If the health check fails, the container will be restarted or marked as unhealthy. Health checks are very important for rolling updates and ensuring your application can start up in order if you have services that depend on each other.

## Our Health Checks
We offer a number of health check commands, specifically for Laravel. You can find these commands are prefixed with `healthcheck-` and are located in [`/usr/local/bin`](https://github.com/serversideup/docker-php/tree/main/src/common/usr/local/bin). The examples below show how to use these health checks in your `docker-compose.yml` file, but you can also use them in other environments.

## Default Health Check Settings
By default, our Dockerfiles ship with the following health check commands:

| Variation | Health Check Command |
| --------- | -------------------- |
| `cli`     | (none)               |
| `fpm`     | [`php-fpm-healthcheck`](https://github.com/renatomefi/php-fpm-healthcheck) |
| `fpm-apache`     | `curl --insecure --silent --location --show-error --fail http://localhost:8080$HEALTHCHECK_PATH` |
| `fpm-nginx` | `curl --insecure --silent --location --show-error --fail http://localhost:8080$HEALTHCHECK_PATH` |

::note
Notice how `fpm-apache` and `fpm-nginx` have a `$HEALTHCHECK_PATH` variable? This is because you can specify a path for the health check to validate.
::

## Changing the Health Check Path
By default, you can see our [Environment Variable Specification](/docs/reference/environment-variable-specification) shows the `HEALTHCHECK_PATH` variable is set to `/healthcheck`.

**This only validates that FPM-NGINX or FPM-APACHE are running and ready to accept connections. It does not validate that Laravel is running or healthy.**

If you are using Laravel, [modern versions of Laravel will ship with a `/up` route](https://laravel.com/docs/11.x/deployment#the-health-route) that you can use to validate that Laravel is running and healthy.

You can even create your own custom path in your application if you want. As long as the path returns a 200 status code, the health check will be successful.

## Advanced Laravel Services
Since it is good practice to use the same Docker image for all our services, we also make additional health checks for Laravel's advanced services. If you're looking for rolling updates with zero downtime, it's very important to use these health checks.

### Laravel Horizon
We utilize the `artisan horizon:status` command to check the status of Laravel Horizon. This is a command native to Laravel Horizon and is used to determine if the Horizon process is running.

To run this command automatically, you can call our health check command in your `docker-compose.yml` file.

::code-panel
---
label: Using Healthcheck with Laravel Horizon
---
```yaml
healthcheck:
  test: ["CMD", "healthcheck-horizon"]
```
::

[See a full example of configuring Laravel Horizon →](/docs/laravel/laravel-horizon)

### Laravel Reverb
We use `pgrep` to check if the `reverb:start` command is running. This ensures the Reverb process is running and ready to accept connections.

To run this command automatically, you can call our health check command in your `docker-compose.yml` file.

::code-panel
---
label: Using Healthcheck with Laravel Reverb
---
```yaml
healthcheck:
  test: ["CMD", "healthcheck-reverb"]
```
::

[See a full example of configuring Laravel Reverb →](/docs/laravel/laravel-reverb)

### Laravel Scheduler
We use `pgrep` to check if the `schedule:work` command is running. This ensures the scheduler process is running.

To run this command automatically, you can call our health check command in your `docker-compose.yml` file.

::code-panel
---
label: Using Healthcheck with Laravel Scheduler
---
```yaml
healthcheck:
  test: ["CMD", "healthcheck-schedule"]
```
::

[See a full example of configuring Laravel Scheduler →](/docs/laravel/laravel-task-scheduler)

### Laravel Queue
We use `pgrep` to check if the `queue:work` command is running. This ensures the queue process is running.

To run this command automatically, you can call our health check command in your `docker-compose.yml` file.

::code-panel
---
label: Using Healthcheck with Laravel Queue
---
```yaml
healthcheck:
  test: ["CMD", "healthcheck-queue"]
```
::

[See a full example of configuring Laravel Queue →](/docs/laravel/laravel-queue)
