---
head.title: 'Migrating from official PHP Docker images - Docker PHP - Server Side Up'
description: 'Learn how easy it is to move from the official PHP docker images to serversideup/php.'
layout: docs
---
# Migrating from the official PHP images
::lead-p
`serversideup/php` is based on the official PHP images, so you can be confident in changing the base image for your application. Simply prepend `serversideup/` to the image name and you're ready to go. 🚀
::

## Changing the base image
We follow the same naming convention as the official PHP images, so you can easily switch to our images by changing the base image in your `Dockerfile` or `docker-compose.yml` file.

For example: If you're running `php:8.4-cli-alpine`, you can simply change it to `serversideup/php:8.4-cli-alpine` and you're ready to go. It's that easy!

## Before making the change
We encourage you to get familiar with our [default configurations](/docs/getting-started/default-configurations) and [environment variable specifications](/docs/reference/environment-variable-specification) before making the switch. We've improved the developer experience in a number of ways, so be sure you're evaluating how certain customizations are provided by default and that you're not duplicating conflicting customizations.

The best place to get this information is with the following pages:
- [Default Configurations](/docs/getting-started/default-configurations)
- [Environment Variable Specifications](/docs/reference/environment-variable-specification)

## Older versions of PHP
If you do run into a situation where an image tag is not found, it's likely because we may need to add that tag to our system. This is more common in older versions of PHP. We support [active versions of PHP](https://www.php.net/supported-versions.php), but also provide images for 7.4 and 8.0 for those who need it. We *strongly encourage* you to run a supported version of PHP. We only offer these older versions to help you containerize and migrate your application to a newer version of PHP.

If you are missing an image tag, you can [open a Discussion on GitHub](https://github.com/serversideup/docker-php/discussions/new?category=general) and we'll evaluate if we can get that added for you.

To learn more how we tag our images, see our [installation guide](/docs/getting-started/installation).