---
head.title: 'Contributing - Docker PHP - Server Side Up'
description: 'Learn how you can make a difference and contribute to the Docker PHP project.'
layout: docs
---

# Contributing
Thanks for your interest in contributing to this project! Please use read this entire guide before submitting a pull request.

## Improve the docs
All our docs are located under `/docs`. Contributing is very easy and is documented under `/docs/README.md`.

[Learn how to contribute to the docs](https://github.com/serversideup/docker-php/tree/main/docs)

## Project dependencies
You must have these installed on your system.
* Docker (container system): https://www.docker.com/products/docker-desktop

## How things work
1. All files are stored in the `/src` folder
1. GitHub Actions will automatically build and deploy the images

## Running things locally
To run a build, simply run `./scripts/dev.sh` (with Docker Desktop running). This will show you a help menu with all the available options.

::code-panel
---
label: "Example: Building a Unit image running PHP 8.2.12 on Debian Bookworm"
---
```bash
bash scripts/dev.sh --variation unit --version 8.2.12 --os bookworm
```
::

This will build `serversideup/php:8.2.12-unit-bookworm` locally on your machine for testing and inspection.

### Published Beta Images
We also have beta images that are published from the [`release/v3.0`](https://github.com/serversideup/docker-php/tree/release/v3.0) branch (or the "main" branch once v3.0 is released).

#### Debian Variations
| ⚙️ Variation | 🚀 Version |
| ------------ | ---------- |
| cli          | <span class="not-prose mb-1 block">[![serversideup/php:beta-8.4-cli](https://img.shields.io/docker/image-size/serversideup/php/beta-8.4-cli?label=serversideup%2Fphp%3Abeta-8.4-cli)](https://hub.docker.com/r/serversideup/php/?name=beta-8.4-cli&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.3-cli](https://img.shields.io/docker/image-size/serversideup/php/beta-8.3-cli?label=serversideup%2Fphp%3Abeta-8.3-cli)](https://hub.docker.com/r/serversideup/php/?name=beta-8.3-cli&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.2-cli](https://img.shields.io/docker/image-size/serversideup/php/beta-8.2-cli?label=serversideup%2Fphp%3Abeta-8.2-cli)](https://hub.docker.com/r/serversideup/php/?name=beta-8.2-cli&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.1-cli](https://img.shields.io/docker/image-size/serversideup/php/beta-8.1-cli?label=serversideup%2Fphp%3Abeta-8.1-cli)](https://hub.docker.com/r/serversideup/php/?name=beta-8.1-cli&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.0-cli](https://img.shields.io/docker/image-size/serversideup/php/beta-8.0-cli?label=serversideup%2Fphp%3Abeta-8.0-cli)](https://hub.docker.com/r/serversideup/php/?name=beta-8.0-cli&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-7.4-cli](https://img.shields.io/docker/image-size/serversideup/php/beta-7.4-cli?label=serversideup%2Fphp%3Abeta-7.4-cli)](https://hub.docker.com/r/serversideup/php/?name=beta-7.4-cli&page=1&ordering=-name) |
| fpm          |  <span class="not-prose mb-1 block">[![serversideup/php:beta-8.4-fpm](https://img.shields.io/docker/image-size/serversideup/php/beta-8.4-fpm?label=serversideup%2Fphp%3Abeta-8.4-fpm)](https://hub.docker.com/r/serversideup/php/?name=beta-8.4-fpm&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.3-fpm](https://img.shields.io/docker/image-size/serversideup/php/beta-8.3-fpm?label=serversideup%2Fphp%3Abeta-8.3-fpm)](https://hub.docker.com/r/serversideup/php/?name=beta-8.3-fpm&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.2-fpm](https://img.shields.io/docker/image-size/serversideup/php/beta-8.2-fpm?label=serversideup%2Fphp%3Abeta-8.2-fpm)](https://hub.docker.com/r/serversideup/php/?name=beta-8.2-fpm&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.1-fpm](https://img.shields.io/docker/image-size/serversideup/php/beta-8.1-fpm?label=serversideup%2Fphp%3Abeta-8.1-fpm)](https://hub.docker.com/r/serversideup/php/?name=beta-8.1-fpm&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.0-fpm](https://img.shields.io/docker/image-size/serversideup/php/beta-8.0-fpm?label=serversideup%2Fphp%3Abeta-8.0-fpm)](https://hub.docker.com/r/serversideup/php/?name=beta-8.0-fpm&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-7.4-fpm](https://img.shields.io/docker/image-size/serversideup/php/beta-7.4-fpm?label=serversideup%2Fphp%3Abeta-7.4-fpm)](https://hub.docker.com/r/serversideup/php/?name=beta-7.4-fpm&page=1&ordering=-name) |
| fpm-apache   |  <span class="not-prose mb-1 block">[![serversideup/php:beta-8.4-fpm-apache](https://img.shields.io/docker/image-size/serversideup/php/beta-8.4-fpm-apache?label=serversideup%2Fphp%3Abeta-8.4-fpm-apache)](https://hub.docker.com/r/serversideup/php/?name=beta-8.4-fpm-apache&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.3-fpm-apache](https://img.shields.io/docker/image-size/serversideup/php/beta-8.3-fpm-apache?label=serversideup%2Fphp%3Abeta-8.3-fpm-apache)](https://hub.docker.com/r/serversideup/php/?name=beta-8.3-fpm-apache&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.2-fpm-apache](https://img.shields.io/docker/image-size/serversideup/php/beta-8.2-fpm-apache?label=serversideup%2Fphp%3Abeta-8.2-fpm-apache)](https://hub.docker.com/r/serversideup/php/?name=beta-8.2-fpm-apache&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.1-fpm-apache](https://img.shields.io/docker/image-size/serversideup/php/beta-8.1-fpm-apache?label=serversideup%2Fphp%3Abeta-8.1-fpm-apache)](https://hub.docker.com/r/serversideup/php/?name=beta-8.1-fpm-apache&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.0-fpm-apache](https://img.shields.io/docker/image-size/serversideup/php/beta-8.0-fpm-apache?label=serversideup%2Fphp%3Abeta-8.0-fpm-apache)](https://hub.docker.com/r/serversideup/php/?name=beta-8.0-fpm-apache&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-7.4-fpm-apache](https://img.shields.io/docker/image-size/serversideup/php/beta-7.4-fpm-apache?label=serversideup%2Fphp%3Abeta-7.4-fpm-apache)](https://hub.docker.com/r/serversideup/php/?name=beta-7.4-fpm-apache&page=1&ordering=-name) |
| fpm-nginx    |  <span class="not-prose mb-1 block">[![serversideup/php:beta-8.4-fpm-nginx](https://img.shields.io/docker/image-size/serversideup/php/beta-8.4-fpm-nginx?label=serversideup%2Fphp%3Abeta-8.4-fpm-nginx)](https://hub.docker.com/r/serversideup/php/?name=beta-8.4-fpm-nginx&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.3-fpm-nginx](https://img.shields.io/docker/image-size/serversideup/php/beta-8.3-fpm-nginx?label=serversideup%2Fphp%3Abeta-8.3-fpm-nginx)](https://hub.docker.com/r/serversideup/php/?name=beta-8.3-fpm-nginx&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.2-fpm-nginx](https://img.shields.io/docker/image-size/serversideup/php/beta-8.2-fpm-nginx?label=serversideup%2Fphp%3Abeta-8.2-fpm-nginx)](https://hub.docker.com/r/serversideup/php/?name=beta-8.2-fpm-nginx&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.1-fpm-nginx](https://img.shields.io/docker/image-size/serversideup/php/beta-8.1-fpm-nginx?label=serversideup%2Fphp%3Abeta-8.1-fpm-nginx)](https://hub.docker.com/r/serversideup/php/?name=beta-8.1-fpm-nginx&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.0-fpm-nginx](https://img.shields.io/docker/image-size/serversideup/php/beta-8.0-fpm-nginx?label=serversideup%2Fphp%3Abeta-8.0-fpm-nginx)](https://hub.docker.com/r/serversideup/php/?name=beta-8.0-fpm-nginx&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-7.4-fpm-nginx](https://img.shields.io/docker/image-size/serversideup/php/beta-7.4-fpm-nginx?label=serversideup%2Fphp%3Abeta-7.4-fpm-nginx)](https://hub.docker.com/r/serversideup/php/?name=beta-7.4-fpm-nginx&page=1&ordering=-name) |
| unit    |  <span class="not-prose mb-1 block">[![serversideup/php:beta-8.4-unit](https://img.shields.io/docker/image-size/serversideup/php/beta-8.4-unit?label=serversideup%2Fphp%3Abeta-8.4-unit)](https://hub.docker.com/r/serversideup/php/?name=beta-8.4-unit&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.3-unit](https://img.shields.io/docker/image-size/serversideup/php/beta-8.3-unit?label=serversideup%2Fphp%3Abeta-8.3-unit)](https://hub.docker.com/r/serversideup/php/?name=beta-8.3-unit&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.2-unit](https://img.shields.io/docker/image-size/serversideup/php/beta-8.2-unit?label=serversideup%2Fphp%3Abeta-8.2-unit)](https://hub.docker.com/r/serversideup/php/?name=beta-8.2-unit&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.1-unit](https://img.shields.io/docker/image-size/serversideup/php/beta-8.1-unit?label=serversideup%2Fphp%3Abeta-8.1-unit)](https://hub.docker.com/r/serversideup/php/?name=beta-8.1-unit&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.0-unit](https://img.shields.io/docker/image-size/serversideup/php/beta-8.0-unit?label=serversideup%2Fphp%3Abeta-8.0-unit)](https://hub.docker.com/r/serversideup/php/?name=beta-8.0-unit&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-7.4-unit](https://img.shields.io/docker/image-size/serversideup/php/beta-7.4-unit?label=serversideup%2Fphp%3Abeta-7.4-unit)](https://hub.docker.com/r/serversideup/php/?name=beta-7.4-unit&page=1&ordering=-name) |

#### Alpine Variations
To see the size difference between Debian and Alpine, here is a list of our Alpine versions:

| ⚙️ Variation | 🚀 Version |
| ------------ | ---------- |
| cli          | <span class="not-prose mb-1 block">[![serversideup/php:beta-8.4-cli-alpine](https://img.shields.io/docker/image-size/serversideup/php/beta-8.4-cli-alpine?label=serversideup%2Fphp%3Abeta-8.4-cli-alpine)](https://hub.docker.com/r/serversideup/php/?name=beta-8.4-cli-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.3-cli-alpine](https://img.shields.io/docker/image-size/serversideup/php/beta-8.3-cli-alpine?label=serversideup%2Fphp%3Abeta-8.3-cli-alpine)](https://hub.docker.com/r/serversideup/php/?name=beta-8.3-cli-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.2-cli-alpine](https://img.shields.io/docker/image-size/serversideup/php/beta-8.2-cli-alpine?label=serversideup%2Fphp%3Abeta-8.2-cli-alpine)](https://hub.docker.com/r/serversideup/php/?name=beta-8.2-cli-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.1-cli-alpine](https://img.shields.io/docker/image-size/serversideup/php/beta-8.1-cli-alpine?label=serversideup%2Fphp%3Abeta-8.1-cli-alpine)](https://hub.docker.com/r/serversideup/php/?name=beta-8.1-cli-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.0-cli-alpine](https://img.shields.io/docker/image-size/serversideup/php/beta-8.0-cli-alpine?label=serversideup%2Fphp%3Abeta-8.0-cli-alpine)](https://hub.docker.com/r/serversideup/php/?name=beta-8.0-cli-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-7.4-cli-alpine](https://img.shields.io/docker/image-size/serversideup/php/beta-7.4-cli-alpine?label=serversideup%2Fphp%3Abeta-7.4-cli-alpine)](https://hub.docker.com/r/serversideup/php/?name=beta-7.4-cli-alpine&page=1&ordering=-name) |
| fpm          |  <span class="not-prose mb-1 block">[![serversideup/php:beta-8.4-fpm-alpine](https://img.shields.io/docker/image-size/serversideup/php/beta-8.4-fpm-alpine?label=serversideup%2Fphp%3Abeta-8.4-fpm-alpine)](https://hub.docker.com/r/serversideup/php/?name=beta-8.4-fpm-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.3-fpm-alpine](https://img.shields.io/docker/image-size/serversideup/php/beta-8.3-fpm-alpine?label=serversideup%2Fphp%3Abeta-8.3-fpm-alpine)](https://hub.docker.com/r/serversideup/php/?name=beta-8.3-fpm-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.2-fpm-alpine](https://img.shields.io/docker/image-size/serversideup/php/beta-8.2-fpm-alpine?label=serversideup%2Fphp%3Abeta-8.2-fpm-alpine)](https://hub.docker.com/r/serversideup/php/?name=beta-8.2-fpm-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.1-fpm-alpine](https://img.shields.io/docker/image-size/serversideup/php/beta-8.1-fpm-alpine?label=serversideup%2Fphp%3Abeta-8.1-fpm-alpine)](https://hub.docker.com/r/serversideup/php/?name=beta-8.1-fpm-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.0-fpm-alpine](https://img.shields.io/docker/image-size/serversideup/php/beta-8.0-fpm-alpine?label=serversideup%2Fphp%3Abeta-8.0-fpm-alpine)](https://hub.docker.com/r/serversideup/php/?name=beta-8.0-fpm-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-7.4-fpm-alpine](https://img.shields.io/docker/image-size/serversideup/php/beta-7.4-fpm-alpine?label=serversideup%2Fphp%3Abeta-7.4-fpm-alpine)](https://hub.docker.com/r/serversideup/php/?name=beta-7.4-fpm-alpine&page=1&ordering=-name) |
| fpm-apache   |  <span class="not-prose mb-1 block">[![serversideup/php:beta-8.4-fpm-apache-alpine](https://img.shields.io/docker/image-size/serversideup/php/beta-8.4-fpm-apache-alpine?label=serversideup%2Fphp%3Abeta-8.4-fpm-apache-alpine)](https://hub.docker.com/r/serversideup/php/?name=beta-8.4-fpm-apache-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.3-fpm-apache-alpine](https://img.shields.io/docker/image-size/serversideup/php/beta-8.3-fpm-apache-alpine?label=serversideup%2Fphp%3Abeta-8.3-fpm-apache-alpine)](https://hub.docker.com/r/serversideup/php/?name=beta-8.3-fpm-apache-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.2-fpm-apache-alpine](https://img.shields.io/docker/image-size/serversideup/php/beta-8.2-fpm-apache-alpine?label=serversideup%2Fphp%3Abeta-8.2-fpm-apache-alpine)](https://hub.docker.com/r/serversideup/php/?name=beta-8.2-fpm-apache-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.1-fpm-apache-alpine](https://img.shields.io/docker/image-size/serversideup/php/beta-8.1-fpm-apache-alpine?label=serversideup%2Fphp%3Abeta-8.1-fpm-apache-alpine)](https://hub.docker.com/r/serversideup/php/?name=beta-8.1-fpm-apache-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.0-fpm-apache-alpine](https://img.shields.io/docker/image-size/serversideup/php/beta-8.0-fpm-apache-alpine?label=serversideup%2Fphp%3Abeta-8.0-fpm-apache-alpine)](https://hub.docker.com/r/serversideup/php/?name=beta-8.0-fpm-apache-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-7.4-fpm-apache-alpine](https://img.shields.io/docker/image-size/serversideup/php/beta-7.4-fpm-apache-alpine?label=serversideup%2Fphp%3Abeta-7.4-fpm-apache-alpine)](https://hub.docker.com/r/serversideup/php/?name=beta-7.4-fpm-apache-alpine&page=1&ordering=-name) |
| fpm-nginx    |  <span class="not-prose mb-1 block">[![serversideup/php:beta-8.4-fpm-nginx-alpine](https://img.shields.io/docker/image-size/serversideup/php/beta-8.4-fpm-nginx-alpine?label=serversideup%2Fphp%3Abeta-8.4-fpm-nginx-alpine)](https://hub.docker.com/r/serversideup/php/?name=beta-8.4-fpm-nginx-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.3-fpm-nginx-alpine](https://img.shields.io/docker/image-size/serversideup/php/beta-8.3-fpm-nginx-alpine?label=serversideup%2Fphp%3Abeta-8.3-fpm-nginx-alpine)](https://hub.docker.com/r/serversideup/php/?name=beta-8.3-fpm-nginx-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.2-fpm-nginx-alpine](https://img.shields.io/docker/image-size/serversideup/php/beta-8.2-fpm-nginx-alpine?label=serversideup%2Fphp%3Abeta-8.2-fpm-nginx-alpine)](https://hub.docker.com/r/serversideup/php/?name=beta-8.2-fpm-nginx-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.1-fpm-nginx-alpine](https://img.shields.io/docker/image-size/serversideup/php/beta-8.1-fpm-nginx-alpine?label=serversideup%2Fphp%3Abeta-8.1-fpm-nginx-alpine)](https://hub.docker.com/r/serversideup/php/?name=beta-8.1-fpm-nginx-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-8.0-fpm-nginx-alpine](https://img.shields.io/docker/image-size/serversideup/php/beta-8.0-fpm-nginx-alpine?label=serversideup%2Fphp%3Abeta-8.0-fpm-nginx-alpine)](https://hub.docker.com/r/serversideup/php/?name=beta-8.0-fpm-nginx-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:beta-7.4-fpm-nginx-alpine](https://img.shields.io/docker/image-size/serversideup/php/beta-7.4-fpm-nginx-alpine?label=serversideup%2Fphp%3Abeta-7.4-fpm-nginx-alpine)](https://hub.docker.com/r/serversideup/php/?name=beta-7.4-fpm-nginx-alpine&page=1&ordering=-name) |
| unit    |  ⚠️ Unit does not have an Alpine version. [See the known issue →](https://github.com/serversideup/docker-php/issues/233) |

#### Running a test web server:
Sometimes you need to just run a test web server locally to see if your changes work. Below is a good example on how to quickly do this.

::code-panel
---
label: "Example: Run a simple container for testing"
---
```bash
docker run --rm -v $(pwd):/var/www/html -p 80:8080 -p 443:8443 serversideup/php:8.4-fpm-nginx
```
::

## How PHP Versions are selected for distribution
We use the official PHP versions as our base image. To identify which versions should be built, we use a file called `scripts/conf/php-versions-base-config.yml` to explicitly select what versions should be built and any special rules/settings for each version (like base OS, default versions, etc).

We then use a `scripts/get-php-versions.sh` script to download the [latest active releases from PHP](https://www.php.net/releases/active.php) and merge them into a final file called `scripts/conf/php-versions.yml`.

The `php-versions.yml` file will include all final versions for tagging and building.

We generate our tags with a file called `scripts/assemble-docker-tags.sh` which handles all the advanced logic of compiling our tags together.

All the scripts above are designed to run locally and in GitHub Actions. Feel free to execute these scripts to see the help menus and how they work.

## GitHub Actions
We use GitHub Actions exclusively to publish all of our releases. If the image exists from DockerHub or GitHub Packages, it will never be published from a local machine.

See `.github/workflows/action_publish-beta-images.yml` for an example of how we publish our beta images.

## Helping out
If you're really eager to help out, here are a few places to get started:
- Help answer questions on [our GitHub Discussions](https://github.com/serversideup/docker-php/discussions) and [our Discord](https://serversideup.net/discord)
- Chime in on [issues labeled "Help Wanted"](https://github.com/serversideup/docker-php/issues?q=is%3Aissue+is%3Aopen+label%3A%22%F0%9F%99%8F+Help+Wanted%22)
- [Open a feature request](https://github.com/serversideup/docker-php/discussions/66) and tell us how we can improve
- Run performance tests and share your results
- Say good things and tag us on X (formerly Twitter): [@serversideup](https://x.com/serversideup), [@danpastori](https://x.com/danpastori), [@jaydrogers](https://x.com/jaydrogers)
