---
head.title: 'Upgrade Guide - Docker PHP - Server Side Up'
description: 'Learn where you can run your servers and still have control of your data.'
layout: docs
---

# Choosing a host
We get asked where we host our infrastructure. Our biggest principle is: **your infrastructure should be able to run anywhere.**

We believe privacy and control is the #1 priority when it comes to hosting infrastructure. We try to avoid the "big clouds" as much as possible because we're not comfortable that all 3 major players practice data mining of users and their products usually contain some sort of "vendor-lock".

We run all our production servers on the latest LTS release of Ubuntu Server. The hosts we use are below. Some may be affiliate links that kick a few bucks at no extra cost to you, but they do not affect our recommendations at all. 

### [Hetzner](https://hetzner.cloud/?ref=lhLUIrkdUPhl)
**Our current favorite.** Your mind will be blown for the specs you get for the prices. They are based in Europe, but have US datacenters too. We're running full out SaaS products for $5 USD a month. 🤯

### [Vultr](https://vultr.grsm.io/create)
Excellent performance and value. Lots of data center options too.

### [Digital Ocean](https://m.do.co/c/f3bad4b927ca)
Lots of developer love here. Not the best performing servers, but they do have a lot of awesome products!

## Benchmarks
If you're shopping for a host, [check out the benchmarks we've ran →](https://521dimensions.notion.site/Benchmark-Results-for-Self-hosted-Gitlab-Server-c6eca7c5f16d4bb8aeb989174fc58ffe)

## Can I run this on another host?
Sure! It all depends what platform you want to use, but if it supports Docker images, you likely can run it. These images are designed to give you freedom no matter where you want to run them.