---
head.title: 'Upgrade Guide - Docker PHP - Server Side Up'
description: 'Learn how the serversideup/php Docker images are built and how to upgrade.'
layout: docs
---

# Upgrading
If you do not select a specific patch version, then you will receive automatic PHP updates.

For example, you can select your version based on the different version numbers:
- Major Version (example: `8` will give you the latest 8.x version)
- Minor Version (example: `8.4` will give you the latest 8.4.x version)
- Patch Version (example: `8.4.1` will always stay at the 8.4.1 version)

If you use `latest`, you will always get the latest stable version of the CLI variation of PHP. For the best stability in production environments, you may want to pin to a specific patch version (example: `8.4.1`).

## Release process
All source code is merged into the `main` branch, which automatically build our "beta" images.

After testing the images internally and from other community members, we will [publish a release on GitHub](https://github.com/serversideup/docker-php/releases) with a detailed changelog.

## Updating the Docker images on your own
If you You and simply run `apt-get update && apt-get upgrade` within your own image, but still want the image to receive other operating system updates, you will need to run the following commands on your build.

Any updates that you apply have a risk of breaking other things inside the container. Be sure to have a good testing process in place before applying updates to your production environment.

::code-panel
---
label: Example Dockerfile with manual updates for Debian
---
```dockerfile
FROM serversideup/php:8.4.1-fpm-nginx

RUN apt-get update \
    && apt-get upgrade -y \
    && apt-get clean \
    && rm -rf /var/lib/apt/lists/* /tmp/* /var/tmp/* /usr/share/doc/*
```
::

If you're running an Alpine-based image, you can use the following commands:

::code-panel
---
label: Example Dockerfile with manual updates for Alpine
---
```dockerfile
FROM serversideup/php:8.4.1-fpm-nginx-alpine

RUN apk update \
    && apk upgrade \
    && rm -rf /var/cache/apk/*
```
::

## Subscribe to repository updates
Regardless if you are choosing to use automatic updates or manual updates, it is highly advised to subscribe to our releases. You can do this through the "Watch" button on our [GitHub](https://github.com/serversideup/docker-php).

![Watch Repository](/images/docs/watch-repo.png)
