---
head.title: 'Installation - Docker PHP - Server Side Up'
description: 'Learn how to get started with serversideup/php Docker Images.'
layout: docs
---

# Default Configurations
::lead-p
`serversideup/php` is configured for real-world deployments right out of the box. This saves you many hours so you can launch faster than ever.
::

## Production-ready and optimized for Laravel & WordPress
All values are defaulted to improve security and performance. We also spent the time to carefully review official documentation and include packages that are required specifically for Laravel and WordPress.

## Unprivileged by Default
All images default to running as the OS-native `www-data` user.

::note
The `www-data` UID/GID is different between Debian (`33:33`) and Alpine (`82:82`). We left these values alone to make these images as native as possible. If you switch between Debian and Alpine, you may need to adjust file permissions in your Docker image and volume mounts.
::

Since these images are not privileged, that means they are not running on ports less than 1024:

| **Variation** | **Default Ports** |
|---------------|-------------------|
| cli | (none) |
| fpm | 9000 |
| fpm-nginx | HTTP: 8080, HTTPS: 8443 |
| fpm-apache | HTTP: 8080, HTTPS: 8443 |
| unit | HTTP: 8080, HTTPS: 8443 |

### How do I run these services on ports 80 and/or 443?
Almost everyone will want to run these services on ports 80 and 443. If you have an advanced setup, you can use a reverse proxy like Caddy or Traefik to handle the SSL termination and forward the traffic to the container on the non-privileged port.

Or you can simply use Docker's port mapping feature to map the container port to the host port. For example, to run the `fpm-nginx` variation on port 80 and 443, you can run the following command:

::code-panel
---
label: Run FPM NGINX on port 80 and 443
---
```bash
docker run -p 80:8080 -p 443:8443 serversideup/php:8.4-fpm-nginx
```
::

## Default Environment Variables
We allow the ability to customize the behavior of PHP with environment variables. Be sure to review our production-ready default values on our [environment variable specification](/docs/reference/environment-variable-specification) page.

## Default PHP INI Settings
We provide a default PHP ini that come with the suggested and hardened settings for running PHP in production. This file is located at `/usr/local/etc/php/conf.d/serversideup-docker-php.ini`.

To customize the PHP ini settings, read our [Changing Common PHP Settings](/docs/customizing-the-image/changing-common-php-settings) guide.

## Default PHP Extensions
The following extensions are installed by default:

| **Extension** | **Description** | **Why we included it** |
|---------------|-----------------|------------------------|
| [opcache](https://www.php.net/manual/en/book.opcache.php) | The Zend OPcache provides faster PHP execution through opcode caching and optimization. | This is a must-have for PHP performance.<br /><br />⚠️ OPcache is disabled by default but can easily be enabled with [`PHP_OPCACHE_ENABLE=1`](/docs/reference/environment-variable-specification).|
| [mysqli](https://www.php.net/manual/en/book.mysqli.php) | The "MySQL Improved" extension is an older extension for connecting to MySQL 4.1 and above. | **Enabled for fpm-apache only**. This is a legacy MySQL connector required for WordPress.|
| [pcntl](https://www.php.net/manual/en/intro.pcntl.php) | Process Control support in PHP implements the Unix style of process creation, program execution, signal handling and process termination. | This is required for [Laravel queues and Laravel Horizon](https://laravel.com/docs/10.x/queues#timeout)|
| [pdo_mysql](https://www.php.net/manual/en/ref.pdo-mysql.php) | The MySQL PDO extension allows you to connect to MySQL databases. | MySQL and MariaDB databases are very popular. |
| [pdo_pgsql](https://www.php.net/manual/en/ref.pdo-pgsql.php) | The PostgreSQL PDO extension allows you to connect to PostgreSQL databases. | PostgreSQL databases are very popular. |
| [redis](https://www.php.net/manual/en/book.redis.php) | The Redis extension allows you to connect to Redis databases. | Redis is very popular for caching and it's also required for [Laravel Horizon](https://laravel.com/docs/10.x/horizon). Our tests concluded adding this package only added 2MB to the image size. |
| [zip](https://www.php.net/manual/en/book.zip.php) | The Zip extension allows you to create and extract zip files. | We included this for the popularity of apps working with ZIP files. This package is also required if you're working with attachments on [Laravel Dusk](https://laravel.com/docs/10.x/dusk#attaching-files). |

The official PHP images are already providing the following extensions:
- ctype
- curl
- dom
- fileinfo
- filter
- hash
- mbstring
- openssl
- pcre
- session
- tokenizer
- xml

## Default Operating System Packages
The following packages are installed by default:

| **Package** | **Description** | **Image variations** | **Why we included it** |
|-------------|-----------------|----------------------|------------------------|
| `libfcgi-bin`<br/>(Debian)<br/>`fcgi`<br/>(Alpine) | FastCGI is a protocol for interfacing interactive programs with a web server. | *-fpm <br/> *-fpm-nginx <br/> *-fpm-apache | This is required for the webserver to interface with PHP-FPM and the [`php-fpm-healthcheck`](https://github.com/renatomefi/php-fpm-healthcheck) project.  |
| `gettext-base` (Debian) <br/> `gettext` (Alpine) | GNU gettext is a framework for translating user interfaces. | *-fpm-nginx <br/> *-fpm-apache | This is required for the `envsubst` command. We use this command to process templates on container initialization. |
| `procps` (Debian) | The procps package contains programs for monitoring your system and its processes. | * (Debian images) | This is required for `pgrep` so we can use that for our native health checks. |
| `shadow` | Shadow is required for the `usermod` command. | *-alpine | This is required to change the UID and GID of the `www-data` user in `docker-php-serversideup-set-id`. |

## Health Checks
By default, all health checks for web servers (Apache, Unit, NGINX, etc.) are located at `/healthcheck`. You should receive an `OK` response if the container is healthy.

For our `fpm` variation, we use the [`php-fpm-healthcheck`](https://github.com/renatomefi/php-fpm-healthcheck) script to verify the health of PHP-FPM. This script is located at `/usr/local/bin/php-fpm-healthcheck`.

The `cli` variation does not have a health check because it doesn't really make sense to have one. Would love to discuss more if you feel different.

## Default Entrypoint Scripts
We created an entrypoint script that scans the `entrypoint.d` directory for other shell scripts to execute before the main container process starts. All scripts are executed in alphabetical order so you can have full control over what script execution order.

We also provide a few default scripts to help you get started.

| **Script Name** | **Description** | **Image variations** |
|------------|-----------------|----------------------|
| `0-container-info.sh` | Shows basic execution information, such as Docker User, UID, GID, etc. | all |
| `1-log-output-level.sh` | Sets PHP log output level to match `LOG_OUTPUT_LEVEL` | all |
| `10-init-unit.sh` | Processes Unit templates, configures SSL (if enabled), and prepares NGINX Unit for launch | unit |
| `10-init-webserver-config.sh` | Processes web server configuration templates, configures SSL (if enabled), and prepares web server for launch | *-nginx <br/> *-apache |
| `50-laravel-automations.sh` | If `AUTORUN_ENABLED` is set to true, and a Laravel installation is detected, the following commands will automatically execute on container start: <br/> - `php artisan config:cache` <br/> - `php artisan route:cache` <br/> - `php artisan view:cache` <br/> - `php artisan event:cache` <br/> - `php artisan migrate --force` | all |

## Disabling Default Entrypoint Scripts
If you want full control to customize your image, all default entrypoint scripts can be disabled by setting `DISABLE_DEFAULT_CONFIG` to `true`.
