---
head.title: 'Installation - Docker PHP - Server Side Up'
description: 'Learn how to get started with serversideup/php Docker Images.'
layout: docs
---

# Installation
::lead-p
`serversideup/php` is compatible with any container orchestrator that supports Docker images (Kubernetes, Docker Swarm, Docker Compose, HashiCorp Nomad, etc.).
::

::lead-p
All images are hosted on [DockerHub](https://hub.docker.com/r/serversideup/php) and [GitHub Packages](https://github.com/serversideup/docker-php/pkgs/container/php)  for free. Containers default to running Debian, but Alpine images are also available.
::

## Our most popular images
All images are intelligently tagged with the PHP version and variation. This allows you to easily select the right image for your use case. 

If you do not specify a variation, it will default to `cli` and the latest supported Debian release for that variation.

Our most popular tags include:
| ⚙️ Variation | 🚀 Version |
| ------------ | ---------- |
| cli          | <span class="font-bold text-white">Debian Based</span><span class="not-prose mb-1 block">[![serversideup/php:8.4-cli](https://img.shields.io/docker/image-size/serversideup/php/8.4-cli?label=serversideup%2Fphp%3A8.4-cli)](https://hub.docker.com/r/serversideup/php/tags?name=8.4-cli&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.3-cli](https://img.shields.io/docker/image-size/serversideup/php/8.3-cli?label=serversideup%2Fphp%3A8.3-cli)](https://hub.docker.com/r/serversideup/php/tags?name=8.3-cli&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.2-cli](https://img.shields.io/docker/image-size/serversideup/php/8.2-cli?label=serversideup%2Fphp%3A8.2-cli)](https://hub.docker.com/r/serversideup/php/tags?name=8.2-cli&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.1-cli](https://img.shields.io/docker/image-size/serversideup/php/8.1-cli?label=serversideup%2Fphp%3A8.1-cli)](https://hub.docker.com/r/serversideup/php/tags?name=8.1-cli&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.0-cli](https://img.shields.io/docker/image-size/serversideup/php/8.0-cli?label=serversideup%2Fphp%3A8.0-cli)](https://hub.docker.com/r/serversideup/php/tags?name=8.0-cli&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:7.4-cli](https://img.shields.io/docker/image-size/serversideup/php/7.4-cli?label=serversideup%2Fphp%3A7.4-cli)](https://hub.docker.com/r/serversideup/php/tags?name=7.4-cli&page=1&ordering=-name)</span><br><span class="font-bold text-white">Alpine Based</span><span class="not-prose mb-1 block">[![serversideup/php:8.4-cli-alpine](https://img.shields.io/docker/image-size/serversideup/php/8.4-cli-alpine?label=serversideup%2Fphp%3A8.4-cli-alpine)](https://hub.docker.com/r/serversideup/php/tags?name=8.4-cli-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.3-cli-alpine](https://img.shields.io/docker/image-size/serversideup/php/8.3-cli-alpine?label=serversideup%2Fphp%3A8.3-cli-alpine)](https://hub.docker.com/r/serversideup/php/tags?name=8.3-cli-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.2-cli-alpine](https://img.shields.io/docker/image-size/serversideup/php/8.2-cli-alpine?label=serversideup%2Fphp%3A8.2-cli-alpine)](https://hub.docker.com/r/serversideup/php/tags?name=8.2-cli-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.1-cli-alpine](https://img.shields.io/docker/image-size/serversideup/php/8.1-cli-alpine?label=serversideup%2Fphp%3A8.1-cli-alpine)](https://hub.docker.com/r/serversideup/php/tags?name=8.1-cli-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.0-cli-alpine](https://img.shields.io/docker/image-size/serversideup/php/8.0-cli-alpine?label=serversideup%2Fphp%3A8.0-cli-alpine)](https://hub.docker.com/r/serversideup/php/tags?name=8.0-cli-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:7.4-cli-alpine](https://img.shields.io/docker/image-size/serversideup/php/7.4-cli-alpine?label=serversideup%2Fphp%3A7.4-cli-alpine)](https://hub.docker.com/r/serversideup/php/tags?name=7.4-cli-alpine&page=1&ordering=-name)</span> |
| fpm          | <span class="font-bold text-white">Debian Based</span><span class="not-prose mb-1 block">[![serversideup/php:8.4-fpm](https://img.shields.io/docker/image-size/serversideup/php/8.4-fpm?label=serversideup%2Fphp%3A8.4-fpm)](https://hub.docker.com/r/serversideup/php/tags?name=8.4-fpm&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.3-fpm](https://img.shields.io/docker/image-size/serversideup/php/8.3-fpm?label=serversideup%2Fphp%3A8.3-fpm)](https://hub.docker.com/r/serversideup/php/tags?name=8.3-fpm&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.2-fpm](https://img.shields.io/docker/image-size/serversideup/php/8.2-fpm?label=serversideup%2Fphp%3A8.2-fpm)](https://hub.docker.com/r/serversideup/php/tags?name=8.2-fpm&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.1-fpm](https://img.shields.io/docker/image-size/serversideup/php/8.1-fpm?label=serversideup%2Fphp%3A8.1-fpm)](https://hub.docker.com/r/serversideup/php/tags?name=8.1-fpm&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.0-fpm](https://img.shields.io/docker/image-size/serversideup/php/8.0-fpm?label=serversideup%2Fphp%3A8.0-fpm)](https://hub.docker.com/r/serversideup/php/tags?name=8.0-fpm&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:7.4-fpm](https://img.shields.io/docker/image-size/serversideup/php/7.4-fpm?label=serversideup%2Fphp%3A7.4-fpm)](https://hub.docker.com/r/serversideup/php/tags?name=7.4-fpm&page=1&ordering=-name)</span><br><span class="font-bold text-white">Alpine Based</span><span class="not-prose mb-1 block">[![serversideup/php:8.4-fpm-alpine](https://img.shields.io/docker/image-size/serversideup/php/8.4-fpm-alpine?label=serversideup%2Fphp%3A8.4-fpm-alpine)](https://hub.docker.com/r/serversideup/php/tags?name=8.4-fpm-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.3-fpm-alpine](https://img.shields.io/docker/image-size/serversideup/php/8.3-fpm-alpine?label=serversideup%2Fphp%3A8.3-fpm-alpine)](https://hub.docker.com/r/serversideup/php/tags?name=8.3-fpm-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.2-fpm-alpine](https://img.shields.io/docker/image-size/serversideup/php/8.2-fpm-alpine?label=serversideup%2Fphp%3A8.2-fpm-alpine)](https://hub.docker.com/r/serversideup/php/tags?name=8.2-fpm-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.1-fpm-alpine](https://img.shields.io/docker/image-size/serversideup/php/8.1-fpm-alpine?label=serversideup%2Fphp%3A8.1-fpm-alpine)](https://hub.docker.com/r/serversideup/php/tags?name=8.1-fpm-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.0-fpm-alpine](https://img.shields.io/docker/image-size/serversideup/php/8.0-fpm-alpine?label=serversideup%2Fphp%3A8.0-fpm-alpine)](https://hub.docker.com/r/serversideup/php/tags?name=8.0-fpm-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:7.4-fpm-alpine](https://img.shields.io/docker/image-size/serversideup/php/7.4-fpm-alpine?label=serversideup%2Fphp%3A7.4-fpm-alpine)](https://hub.docker.com/r/serversideup/php/tags?name=7.4-fpm-alpine&page=1&ordering=-name)</span> |
| fpm-apache   | <span class="font-bold text-white">Debian Based</span><span class="not-prose mb-1 block">[![serversideup/php:8.4-fpm-apache](https://img.shields.io/docker/image-size/serversideup/php/8.4-fpm-apache?label=serversideup%2Fphp%3A8.4-fpm-apache)](https://hub.docker.com/r/serversideup/php/tags?name=8.4-fpm-apache&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.3-fpm-apache](https://img.shields.io/docker/image-size/serversideup/php/8.3-fpm-apache?label=serversideup%2Fphp%3A8.3-fpm-apache)](https://hub.docker.com/r/serversideup/php/tags?name=8.3-fpm-apache&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.2-fpm-apache](https://img.shields.io/docker/image-size/serversideup/php/8.2-fpm-apache?label=serversideup%2Fphp%3A8.2-fpm-apache)](https://hub.docker.com/r/serversideup/php/tags?name=8.2-fpm-apache&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.1-fpm-apache](https://img.shields.io/docker/image-size/serversideup/php/8.1-fpm-apache?label=serversideup%2Fphp%3A8.1-fpm-apache)](https://hub.docker.com/r/serversideup/php/tags?name=8.1-fpm-apache&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.0-fpm-apache](https://img.shields.io/docker/image-size/serversideup/php/8.0-fpm-apache?label=serversideup%2Fphp%3A8.0-fpm-apache)](https://hub.docker.com/r/serversideup/php/tags?name=8.0-fpm-apache&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:7.4-fpm-apache](https://img.shields.io/docker/image-size/serversideup/php/7.4-fpm-apache?label=serversideup%2Fphp%3A7.4-fpm-apache)](https://hub.docker.com/r/serversideup/php/tags?name=7.4-fpm-apache&page=1&ordering=-name)</span> |
| fpm-nginx    | <span class="font-bold text-white">Debian Based</span><span class="not-prose mb-1 block">[![serversideup/php:8.4-fpm-nginx](https://img.shields.io/docker/image-size/serversideup/php/8.4-fpm-nginx?label=serversideup%2Fphp%3A8.4-fpm-nginx)](https://hub.docker.com/r/serversideup/php/tags?name=8.4-fpm-nginx&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.3-fpm-nginx](https://img.shields.io/docker/image-size/serversideup/php/8.3-fpm-nginx?label=serversideup%2Fphp%3A8.3-fpm-nginx)](https://hub.docker.com/r/serversideup/php/tags?name=8.3-fpm-nginx&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.2-fpm-nginx](https://img.shields.io/docker/image-size/serversideup/php/8.2-fpm-nginx?label=serversideup%2Fphp%3A8.2-fpm-nginx)](https://hub.docker.com/r/serversideup/php/tags?name=8.2-fpm-nginx&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.1-fpm-nginx](https://img.shields.io/docker/image-size/serversideup/php/8.1-fpm-nginx?label=serversideup%2Fphp%3A8.1-fpm-nginx)](https://hub.docker.com/r/serversideup/php/tags?name=8.1-fpm-nginx&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.0-fpm-nginx](https://img.shields.io/docker/image-size/serversideup/php/8.0-fpm-nginx?label=serversideup%2Fphp%3A8.0-fpm-nginx)](https://hub.docker.com/r/serversideup/php/tags?name=8.0-fpm-nginx&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:7.4-fpm-nginx](https://img.shields.io/docker/image-size/serversideup/php/7.4-fpm-nginx?label=serversideup%2Fphp%3A7.4-fpm-nginx)](https://hub.docker.com/r/serversideup/php/tags?name=7.4-fpm-nginx&page=1&ordering=-name)</span><br><span class="font-bold text-white">Alpine Based</span><span class="not-prose mb-1 block">[![serversideup/php:8.4-fpm-nginx-alpine](https://img.shields.io/docker/image-size/serversideup/php/8.4-fpm-nginx-alpine?label=serversideup%2Fphp%3A8.4-fpm-nginx-alpine)](https://hub.docker.com/r/serversideup/php/tags?name=8.4-fpm-nginx-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.3-fpm-nginx-alpine](https://img.shields.io/docker/image-size/serversideup/php/8.3-fpm-nginx-alpine?label=serversideup%2Fphp%3A8.3-fpm-nginx-alpine)](https://hub.docker.com/r/serversideup/php/tags?name=8.3-fpm-nginx-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.2-fpm-nginx-alpine](https://img.shields.io/docker/image-size/serversideup/php/8.2-fpm-nginx-alpine?label=serversideup%2Fphp%3A8.2-fpm-nginx-alpine)](https://hub.docker.com/r/serversideup/php/tags?name=8.2-fpm-nginx-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.1-fpm-nginx-alpine](https://img.shields.io/docker/image-size/serversideup/php/8.1-fpm-nginx-alpine?label=serversideup%2Fphp%3A8.1-fpm-nginx-alpine)](https://hub.docker.com/r/serversideup/php/tags?name=8.1-fpm-nginx-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.0-fpm-nginx-alpine](https://img.shields.io/docker/image-size/serversideup/php/8.0-fpm-nginx-alpine?label=serversideup%2Fphp%3A8.0-fpm-nginx-alpine)](https://hub.docker.com/r/serversideup/php/tags?name=8.0-fpm-nginx-alpine&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:7.4-fpm-nginx-alpine](https://img.shields.io/docker/image-size/serversideup/php/7.4-fpm-nginx-alpine?label=serversideup%2Fphp%3A7.4-fpm-nginx-alpine)](https://hub.docker.com/r/serversideup/php/tags?name=7.4-fpm-nginx-alpine&page=1&ordering=-name)</span> |
| unit         | <span class="font-bold text-white">Debian Based</span><span class="not-prose mb-1 block">[![serversideup/php:8.4-unit](https://img.shields.io/docker/image-size/serversideup/php/8.4-unit?label=serversideup%2Fphp%3A8.4-unit)](https://hub.docker.com/r/serversideup/php/tags?name=8.4-unit&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.3-unit](https://img.shields.io/docker/image-size/serversideup/php/8.3-unit?label=serversideup%2Fphp%3A8.3-unit)](https://hub.docker.com/r/serversideup/php/tags?name=8.3-unit&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.2-unit](https://img.shields.io/docker/image-size/serversideup/php/8.2-unit?label=serversideup%2Fphp%3A8.2-unit)](https://hub.docker.com/r/serversideup/php/tags?name=8.2-unit&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.1-unit](https://img.shields.io/docker/image-size/serversideup/php/8.1-unit?label=serversideup%2Fphp%3A8.1-unit)](https://hub.docker.com/r/serversideup/php/tags?name=8.1-unit&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:8.0-unit](https://img.shields.io/docker/image-size/serversideup/php/8.0-unit?label=serversideup%2Fphp%3A8.0-unit)](https://hub.docker.com/r/serversideup/php/tags?name=8.0-unit&page=1&ordering=-name)</span><span class="not-prose mb-1 block">[![serversideup/php:7.4-unit](https://img.shields.io/docker/image-size/serversideup/php/7.4-unit?label=serversideup%2Fphp%3A7.4-unit)](https://hub.docker.com/r/serversideup/php/tags?name=7.4-unit&page=1&ordering=-name)</span> |

## Selecting the right variation
There are 4 main variations.

### CLI
If you need to run a quick command with something like `composer` or use PHP to run a CLI program only, this might be a great option for you.

### FPM
The `fpm` variation is great for people who need to run a PHP "backend" if they already have a proxy serving static content. If you're using FPM only, that means you're probably at a larger scale.

### FPM-Apache
The `fpm-apache` variation is meant for users who want to run something like WordPress with Docker. Apache is configured to be a "reverse proxy", which will serve any static content with Apache and serve any PHP requests with PHP-FPM. Since there are two processes required to run this variation, we use [S6 Overlay](/docs/guide/using-s6-overlay) to ensure the container health is accurate.

[Learn more about using Docker with WordPress →](/docs/guide/using-wordpress-with-docker)

### FPM-NGINX
The `fpm-nginx` variation is great for people who want to run Laravel applications or similar. This allows you to serve static content quickly with NGINX but also pass PHP requests to PHP-FPM. Similar to PHP-Apache, there are two processes required to run this variation. We use S6 Overlay to ensure the container health is accurate.

[Learn more about S6 Overlay →](/docs/guide/using-s6-overlay)

### Unit
The `unit` variation is for NGINX Unit, which is a modern approach to delivering containerized web applications. Instead of relying on the complexities of two processes running NGINX + PHP-FPM, Unit replaces both the NGINX Web Server and PHP-FPM to run everything under one process. Unit is open source and maintained by the NGINX Unit team. 

[Learn more about Unit →](https://unit.nginx.org/)

## Selecting the version of PHP
Selecting the best version of PHP is highly dependent on your use case. In a perfect world, running the latest version of PHP will give you the latest and greatest, but it all depends on the libraries that your application uses.

For example, if you're running a WordPress site with a ton of different plugins, they may be using libraries that do not yet support the latest version of PHP. Be sure to evaluate your dependencies and test your application before deploying to production.

All versions + variations are tagged by:
- Major Version (example: `8` will give you the latest 8.x version)
- Minor Version (example: `8.3` will give you the latest 8.3.x version)
- Patch Version (example: `8.3.2` will always stay at the 8.3.2 version)

If you use `latest`, you will always get the latest stable version of the CLI variation of PHP running the latest version of Debian. For the best stability in production environments, you may want to pin to a specific patch version (example: `8.3.2`).

::code-panel
---
label: The Full Image Tag Standard
---
```bash
{{registry-url}}/serversideup/php:{{release-prefix}}-{{php-version}}-{{variation-name}}-{{operating-system}}-{{github-release-version}}
```
::

### Few examples

::code-panel
---
label: Latest version of 8.3.x running FPM + NGINX from GitHub Packages
---
```bash
ghcr.io/serversideup/php:8.3-fpm-nginx
```
::

::code-panel
---
label: PHP 8.1.16, running FPM + Apache on Alpine from DockerHub, locked into our v3.0.0 GitHub Release
---
```bash
serversideup/php:8.1.16-fpm-apache-alpine-v3.0.0
```
::

In this example, we can lock into the `v3.0.0` release of our image. This is useful if you want to ensure there are no automatic changes that could break your CI process. [View our releases →](https://github.com/serversideup/docker-php/releases)

::code-panel
---
label: Latest beta version (of this repository, not PHP) running PHP CLI 8.x
---
```bash
serversideup/php:beta-8
```
::

## Viewing all available images & tags
All our images are available on DockerHub and GitHub Packages (ghcr.io). You can use their built-in search functions to browse through our entire collection of Docker Images:
- [View on Docker Hub →](https://hub.docker.com/r/serversideup/php)
- [View on GitHub Packages →](https://github.com/serversideup/docker-php/pkgs/container/php)

## Downloading an image
In the simplest form of using the image, you can simply pull it down.

::code-panel
---
label: Pull an image with Docker
---
```bash
docker pull serversideup/php:8.3-fpm-nginx
```
::

If you'd like to explore the image a little bit more, you can run `bash` on the image and view the structure of everything.

::code-panel
---
label: Explore the image with Bash
---
```bash
docker run --rm --name php -it serversideup/php:8.3-fpm-nginx bash
```
::

## Running with a container orchestrator
`serversideup/php` is compatible with any container orchestrator that supports Docker images. Learn more below on how to use this image with the orchestrator of your choice.

::orchestrators
::