---
head.title: 'These images vs others - Docker PHP - Server Side Up'
description: 'Learn the important differences between serversideup/php and other PHP images.'
layout: docs
---

# These images vs others

| | **Official PHP Images** |**serversideup/php** |
|-------------------------|-------------------------|---------------------|
| Base Operating System | Debian, Alpine | Debian, Alpine |
| PHP Compilation | PHP Source Code | PHP Source Code (based on official PHP images) |
| Run PHP, pinned to the minor version | ✅ | ✅ |
| Multi-arch support | ✅ | ✅ |
| Init System | Docker CMD | Docker CMD or [S6-Overlay](https://github.com/just-containers/s6-overlay) |
| Published Registry| DockerHub | [DockerHub](https://hub.docker.com/r/serversideup/php), [GitHub Packages](https://github.com/serversideup/docker-php/pkgs/container/php) |
| Unprivileged by default | ❌ | ✅ |
| Variable-first configuration | ❌ | ✅ |
| Includes `composer` | ❌ | ✅ |
| Includes [`install-php-extensions`](https://github.com/mlocati/docker-php-extension-installer) | ❌ | ✅ |
| Production-Ready by default| ❌ | ✅ |
| Built-in security optimizations | ❌ | ✅ |
| Optimized for Laravel & WordPress| ❌ | ✅ |
| NGINX + FPM variation| ❌ | ✅ |
| NGINX Unit variation| ❌ | ✅ |
| Native health checks | ❌ | ✅ |

## Unprivileged by Default
We believe in the principle of least privilege. Our images run as an unprivileged user by default. This means that if your application is compromised, the attacker will have a harder time escalating their privileges to the root user.

Running unprivileged images also improves compatibility of running your containers in a Kubernetes environment, where running as root is not allowed.

## Variable-first Configuration
Our design philosophy is built all around simplicity. The process of customizing the behavior of PHP is as simple as setting an environment variable. We took every common configuration option and set it up so you can change these values in a simple method, defaulting every single option to production-ready values.

See our [environment variable specifications](/docs/reference/environment-variable-specification) for more information.

## Optimized for Laravel & WordPress
We did the hard work of customizing the official PHP image and giving you everything to get started with running PHP's most popular frameworks in seconds. We also hardened the images to help protect your PHP application from common attacks.

## Production-ready
We believe images should be ready for production and able to live in the open and wild Internet. We took our years of experience and tweaked these images to be performant and secure as possible. Having these values published online allows others to review, contribute, and improve the images -- giving you the best security and performance possible.

## What is "S6 Overlay?"
[S6 Overlay](https://github.com/just-containers/s6-overlay) is a process supervisor designed for containerization from the ground up. It's a modern alternative to [Supervisor (aka Supervisord)](https://supervisord.org/). We only use this in our `serversideup/php:*-fpm-apache` and `serversideup/php:*-fpm-nginx` images, as they require two processes to run a service.

[Learn more about S6 Overlay →](/docs/guide/using-s6-overlay)