#pragma once

#include "sx/sx.h"

typedef struct { uint32_t id; } rizz_input_device;
typedef struct { uint32_t id; } rizz_input_listener;
typedef uint32_t rizz_input_userkey;

typedef enum rizz_input_device_type {
    RIZZ_INPUT_DEVICETYPE_MOUSE,
    RIZZ_INPUT_DEVICETYPE_KEYBOARD,
    RIZZ_INPUT_DEVICETYPE_PAD,
    RIZZ_INPUT_DEVICETYPE_TOUCH,
    RIZZ_INPUT_DEVICETYPE_BUILTIN
} rizz_input_device_type;

typedef enum rizz_input_mouse_btn {
    RIZZ_INPUT_MOUSEBUTTON_0 = 0,
    RIZZ_INPUT_MOUSEBUTTON_LEFT = RIZZ_INPUT_MOUSEBUTTON_0,
    RIZZ_INPUT_MOUSEBUTTON_1,
    RIZZ_INPUT_MOUSEBUTTON_MIDDLE = RIZZ_INPUT_MOUSEBUTTON_1,
    RIZZ_INPUT_MOUSEBUTTON_2,
    RIZZ_INPUT_MOUSEBUTTON_RIGHT = RIZZ_INPUT_MOUSEBUTTON_2,
    RIZZ_INPUT_MOUSEBUTTON_3,
    RIZZ_INPUT_MOUSEBUTTON_WHEELUP = RIZZ_INPUT_MOUSEBUTTON_3,
    RIZZ_INPUT_MOUSEBUTTON_4,
    RIZZ_INPUT_MOUSEBUTTON_WHEELDOWN = RIZZ_INPUT_MOUSEBUTTON_4,
    RIZZ_INPUT_MOUSEBUTTON_5,
    RIZZ_INPUT_MOUSEBUTTON_6,
    RIZZ_INPUT_MOUSEBUTTON_7,
    RIZZ_INPUT_MOUSEBUTTON_8,
    RIZZ_INPUT_MOUSEBUTTON_9,
    RIZZ_INPUT_MOUSEBUTTON_10,
    RIZZ_INPUT_MOUSEBUTTON_11,
    RIZZ_INPUT_MOUSEBUTTON_12,
    RIZZ_INPUT_MOUSEBUTTON_13,
    RIZZ_INPUT_MOUSEBUTTON_14,
    RIZZ_INPUT_MOUSEBUTTON_15,
    RIZZ_INPUT_MOUSEBUTTON_16,
    RIZZ_INPUT_MOUSEBUTTON_17,
    RIZZ_INPUT_MOUSEBUTTON_18,
    RIZZ_INPUT_MOUSEBUTTON_19,
    RIZZ_INPUT_MOUSEBUTTON_20,
    RIZZ_INPUT_MOUSEBUTTON_MAX = RIZZ_INPUT_MOUSEBUTTON_20,
    _RIZZ_INPUT_MOUSEBUTTON_COUNT,
    RIZZ_INPUT_MOUSEAXIS_X = _RIZZ_INPUT_MOUSEBUTTON_COUNT,
    RIZZ_INPUT_MOUSEAXIS_Y,
    _RIZZ_INPUT_MOUSEAXIS_COUNT = 2
} rizz_input_mouse_btn;

typedef enum rizz_input_kbkey {
    RIZZ_INPUT_KBKEY_ESCAPE,
    RIZZ_INPUT_KBKEY_F1,
    RIZZ_INPUT_KBKEY_F2,
    RIZZ_INPUT_KBKEY_F3,
    RIZZ_INPUT_KBKEY_F4,
    RIZZ_INPUT_KBKEY_F5,
    RIZZ_INPUT_KBKEY_F6,
    RIZZ_INPUT_KBKEY_F7,
    RIZZ_INPUT_KBKEY_F8,
    RIZZ_INPUT_KBKEY_F9,
    RIZZ_INPUT_KBKEY_F10,
    RIZZ_INPUT_KBKEY_F11,
    RIZZ_INPUT_KBKEY_F12,
    RIZZ_INPUT_KBKEY_F13,
    RIZZ_INPUT_KBKEY_F14,
    RIZZ_INPUT_KBKEY_F15,
    RIZZ_INPUT_KBKEY_F16,
    RIZZ_INPUT_KBKEY_F17,
    RIZZ_INPUT_KBKEY_F18,
    RIZZ_INPUT_KBKEY_F19,
    RIZZ_INPUT_KBKEY_PRINT,
    RIZZ_INPUT_KBKEY_SCROLLLOCK,
    RIZZ_INPUT_KBKEY_BREAK,

    RIZZ_INPUT_KBKEY_SPACE = 0x0020,

    RIZZ_INPUT_KBKEY_APOSTROPHE = 0x0027,
    RIZZ_INPUT_KBKEY_COMMA = 0x002c,
    RIZZ_INPUT_KBKEY_MINUS = 0x002d,
    RIZZ_INPUT_KBKEY_PERIOD = 0x002e,
    RIZZ_INPUT_KBKEY_SLASH = 0x002f,

    RIZZ_INPUT_KBKEY_0 = 0x0030,
    RIZZ_INPUT_KBKEY_1 = 0x0031,
    RIZZ_INPUT_KBKEY_2 = 0x0032,
    RIZZ_INPUT_KBKEY_3 = 0x0033,
    RIZZ_INPUT_KBKEY_4 = 0x0034,
    RIZZ_INPUT_KBKEY_5 = 0x0035,
    RIZZ_INPUT_KBKEY_6 = 0x0036,
    RIZZ_INPUT_KBKEY_7 = 0x0037,
    RIZZ_INPUT_KBKEY_8 = 0x0038,
    RIZZ_INPUT_KBKEY_9 = 0x0039,

    RIZZ_INPUT_KBKEY_SEMICOLON = 0x003b,
    RIZZ_INPUT_KBKEY_LESS = 0x003c,
    RIZZ_INPUT_KBKEY_EQUAL = 0x003d,

    RIZZ_INPUT_KBKEY_A = 0x0041,
    RIZZ_INPUT_KBKEY_B = 0x0042,
    RIZZ_INPUT_KBKEY_C = 0x0043,
    RIZZ_INPUT_KBKEY_D = 0x0044,
    RIZZ_INPUT_KBKEY_E = 0x0045,
    RIZZ_INPUT_KBKEY_F = 0x0046,
    RIZZ_INPUT_KBKEY_G = 0x0047,
    RIZZ_INPUT_KBKEY_H = 0x0048,
    RIZZ_INPUT_KBKEY_I = 0x0049,
    RIZZ_INPUT_KBKEY_J = 0x004a,
    RIZZ_INPUT_KBKEY_K = 0x004b,
    RIZZ_INPUT_KBKEY_L = 0x004c,
    RIZZ_INPUT_KBKEY_M = 0x004d,
    RIZZ_INPUT_KBKEY_N = 0x004e,
    RIZZ_INPUT_KBKEY_O = 0x004f,
    RIZZ_INPUT_KBKEY_P = 0x0050,
    RIZZ_INPUT_KBKEY_Q = 0x0051,
    RIZZ_INPUT_KBKEY_R = 0x0052,
    RIZZ_INPUT_KBKEY_S = 0x0053,
    RIZZ_INPUT_KBKEY_T = 0x0054,
    RIZZ_INPUT_KBKEY_U = 0x0055,
    RIZZ_INPUT_KBKEY_V = 0x0056,
    RIZZ_INPUT_KBKEY_W = 0x0057,
    RIZZ_INPUT_KBKEY_X = 0x0058,
    RIZZ_INPUT_KBKEY_Y = 0x0059,
    RIZZ_INPUT_KBKEY_Z = 0x005a,

    RIZZ_INPUT_KBKEY_BRACKETLEFT = 0x005b,
    RIZZ_INPUT_KBKEY_BACKSLASH = 0x005c,
    RIZZ_INPUT_KBKEY_BRACKETRIGHT = 0x005d,

    RIZZ_INPUT_KBKEY_GRAVE = 0x0060,

    RIZZ_INPUT_KBKEY_LEFT,
    RIZZ_INPUT_KBKEY_RIGHT,
    RIZZ_INPUT_KBKEY_UP,
    RIZZ_INPUT_KBKEY_DOWN,
    RIZZ_INPUT_KBKEY_INSERT,
    RIZZ_INPUT_KBKEY_HOME,
    RIZZ_INPUT_KBKEY_DELETE,
    RIZZ_INPUT_KBKEY_END,
    RIZZ_INPUT_KBKEY_PAGEUP,
    RIZZ_INPUT_KBKEY_PAGEDOWN,

    RIZZ_INPUT_KBKEY_NUMLOCK,
    RIZZ_INPUT_KBKEY_KPEQUAL,
    RIZZ_INPUT_KBKEY_KPDIVIDE,
    RIZZ_INPUT_KBKEY_KPMULTIPLY,
    RIZZ_INPUT_KBKEY_KPSUBTRACT,
    RIZZ_INPUT_KBKEY_KPADD,
    RIZZ_INPUT_KBKEY_KPENTER,
    RIZZ_INPUT_KBKEY_KPINSERT,      // 0
    RIZZ_INPUT_KBKEY_KPEND,         // 1
    RIZZ_INPUT_KBKEY_KPDOWN,        // 2
    RIZZ_INPUT_KBKEY_KPPAGEDOWN,    // 3
    RIZZ_INPUT_KBKEY_KPLEFT,        // 4
    RIZZ_INPUT_KBKEY_KPBEGIN,       // 5
    RIZZ_INPUT_KBKEY_KPRIGHT,       // 6
    RIZZ_INPUT_KBKEY_KPHOME,        // 7
    RIZZ_INPUT_KBKEY_KPUP,          // 8
    RIZZ_INPUT_KBKEY_KPPAGEUP,      // 9
    RIZZ_INPUT_KBKEY_KPDELETE,      // ,

    RIZZ_INPUT_KBKEY_BACKSPACE,
    RIZZ_INPUT_KBKEY_TAB,
    RIZZ_INPUT_KBKEY_RETURN,
    RIZZ_INPUT_KBKEY_CAPSLOCK,
    RIZZ_INPUT_KBKEY_SHIFTL,
    RIZZ_INPUT_KBKEY_CTRLL,
    RIZZ_INPUT_KBKEY_SUPERL,
    RIZZ_INPUT_KBKEY_ALTL,
    RIZZ_INPUT_KBKEY_ALTR,
    RIZZ_INPUT_KBKEY_SUPERR,
    RIZZ_INPUT_KBKEY_MENU,
    RIZZ_INPUT_KBKEY_CTRLR,
    RIZZ_INPUT_KBKEY_SHIFTR,

    RIZZ_INPUT_KBKEY_BACK,
    RIZZ_INPUT_KBKEY_SOFTLEFT,
    RIZZ_INPUT_KBKEY_SOFTRIGHT,
    RIZZ_INPUT_KBKEY_CALL,
    RIZZ_INPUT_KBKEY_ENDCALL,
    RIZZ_INPUT_KBKEY_STAR,
    RIZZ_INPUT_KBKEY_POUND,
    RIZZ_INPUT_KBKEY_DPADCENTER,
    RIZZ_INPUT_KBKEY_VOLUMEUP,
    RIZZ_INPUT_KBKEY_VOLUMEDOWN,
    RIZZ_INPUT_KBKEY_POWER,
    RIZZ_INPUT_KBKEY_CAMERA,
    RIZZ_INPUT_KBKEY_CLEAR,
    RIZZ_INPUT_KBKEY_SYMBOL,
    RIZZ_INPUT_KBKEY_EXPLORER,
    RIZZ_INPUT_KBKEY_ENVELOPE,
    RIZZ_INPUT_KBKEY_EQUALS,
    RIZZ_INPUT_KBKEY_AT,
    RIZZ_INPUT_KBKEY_HEADSETHOOK,
    RIZZ_INPUT_KBKEY_FOCUS,
    RIZZ_INPUT_KBKEY_PLUS,
    RIZZ_INPUT_KBKEY_NOTIFICATION,
    RIZZ_INPUT_KBKEY_SEARCH,
    RIZZ_INPUT_KBKEY_MEDIAPLAYPAUSE,
    RIZZ_INPUT_KBKEY_MEDIASTOP,
    RIZZ_INPUT_KBKEY_MEDIANEXT,
    RIZZ_INPUT_KBKEY_MEDIAPREVIOUS,
    RIZZ_INPUT_KBKEY_MEDIAREWIND,
    RIZZ_INPUT_KBKEY_MEDIAFASTFORWARD,
    RIZZ_INPUT_KBKEY_MUTE,
    RIZZ_INPUT_KBKEY_PICTSYMBOLS,
    RIZZ_INPUT_KBKEY_SWITCHCHARSET,

    RIZZ_INPUT_KBKEY_FORWARD,
    RIZZ_INPUT_KBKEY_EXTRA1,
    RIZZ_INPUT_KBKEY_EXTRA2,
    RIZZ_INPUT_KBKEY_EXTRA3,
    RIZZ_INPUT_KBKEY_EXTRA4,
    RIZZ_INPUT_KBKEY_EXTRA5,
    RIZZ_INPUT_KBKEY_EXTRA6,
    RIZZ_INPUT_KBKEY_FN,

    RIZZ_INPUT_KBKEY_CIRCUMFLEX,
    RIZZ_INPUT_KBKEY_SSHARP,
    RIZZ_INPUT_KBKEY_ACUTE,
    RIZZ_INPUT_KBKEY_ALTGR,
    RIZZ_INPUT_KBKEY_NUMBERSIGN,
    RIZZ_INPUT_KBKEY_UDIAERESIS,
    RIZZ_INPUT_KBKEY_ADIAERESIS,
    RIZZ_INPUT_KBKEY_ODIAERESIS,
    RIZZ_INPUT_KBKEY_SECTION,
    RIZZ_INPUT_KBKEY_ARING,
    RIZZ_INPUT_KBKEY_DIAERESIS,
    RIZZ_INPUT_KBKEY_TWOSUPERIOR,
    RIZZ_INPUT_KBKEY_RIGHTPARENTHESIS,
    RIZZ_INPUT_KBKEY_DOLLAR,
    RIZZ_INPUT_KBKEY_UGRAVE,
    RIZZ_INPUT_KBKEY_ASTERISK,
    RIZZ_INPUT_KBKEY_COLON,
    RIZZ_INPUT_KBKEY_EXCLAM,

    RIZZ_INPUT_KBKEY_BRACELEFT,
    RIZZ_INPUT_KBKEY_BRACERIGHT,
    RIZZ_INPUT_KBKEY_SYSRQ,

    _RIZZ_INPUT_KBKEY_COUNT
} rizz_input_kbkey;

typedef enum rizz_input_touch_btn {
    RIZZ_INPUT_TOUCHBUTTON_0DOWN,
    RIZZ_INPUT_TOUCHBUTTON_0X,
    RIZZ_INPUT_TOUCHBUTTON_0Y,
    RIZZ_INPUT_TOUCHBUTTON_0PRESSURE,
    RIZZ_INPUT_TOUCHBUTTON_1DOWN,
    RIZZ_INPUT_TOUCHBUTTON_1X,
    RIZZ_INPUT_TOUCHBUTTON_1Y,
    RIZZ_INPUT_TOUCHBUTTON_1PRESSURE,
    RIZZ_INPUT_TOUCHBUTTON_2DOWN,
    RIZZ_INPUT_TOUCHBUTTON_2X,
    RIZZ_INPUT_TOUCHBUTTON_2Y,
    RIZZ_INPUT_TOUCHBUTTON_2PRESSURE,
    RIZZ_INPUT_TOUCHBUTTON_3DOWN,
    RIZZ_INPUT_TOUCHBUTTON_3X,
    RIZZ_INPUT_TOUCHBUTTON_3Y,
    RIZZ_INPUT_TOUCHBUTTON_3PRESSURE,
    RIZZ_INPUT_TOUCHBUTTON_4DOWN,
    RIZZ_INPUT_TOUCHBUTTON_4X,
    RIZZ_INPUT_TOUCHBUTTON_4Y,
    RIZZ_INPUT_TOUCHBUTTON_4PRESSURE,
    RIZZ_INPUT_TOUCHBUTTON_5DOWN,
    RIZZ_INPUT_TOUCHBUTTON_5X,
    RIZZ_INPUT_TOUCHBUTTON_5Y,
    RIZZ_INPUT_TOUCHBUTTON_5PRESSURE,
    RIZZ_INPUT_TOUCHBUTTON_6DOWN,
    RIZZ_INPUT_TOUCHBUTTON_6X,
    RIZZ_INPUT_TOUCHBUTTON_6Y,
    RIZZ_INPUT_TOUCHBUTTON_6PRESSURE,
    RIZZ_INPUT_TOUCHBUTTON_7DOWN,
    RIZZ_INPUT_TOUCHBUTTON_7X,
    RIZZ_INPUT_TOUCHBUTTON_7Y,
    RIZZ_INPUT_TOUCHBUTTON_7PRESSURE,
    RIZZ_INPUT_TOUCHBUTTON_COUNT_
} rizz_input_touch_btn;

typedef enum rizz_input_pad_btn {
    RIZZ_INPUT_PADBUTTON_LEFTSTICKX,
    RIZZ_INPUT_PADBUTTON_LEFTSTICKY,
    RIZZ_INPUT_PADBUTTON_RIGHTSTICKX,
    RIZZ_INPUT_PADBUTTON_RIGHTSTICKY,
    RIZZ_INPUT_PADBUTTON_AXIS4,    // L2/Left trigger
    RIZZ_INPUT_PADBUTTON_AXIS5,    // R2/Right trigger
    RIZZ_INPUT_PADBUTTON_AXIS6,
    RIZZ_INPUT_PADBUTTON_AXIS7,
    RIZZ_INPUT_PADBUTTON_AXIS8,
    RIZZ_INPUT_PADBUTTON_AXIS9,
    RIZZ_INPUT_PADBUTTON_AXIS10,
    RIZZ_INPUT_PADBUTTON_AXIS11,
    RIZZ_INPUT_PADBUTTON_AXIS12,
    RIZZ_INPUT_PADBUTTON_AXIS13,
    RIZZ_INPUT_PADBUTTON_AXIS14,
    RIZZ_INPUT_PADBUTTON_AXIS15,
    RIZZ_INPUT_PADBUTTON_AXIS16,
    RIZZ_INPUT_PADBUTTON_AXIS17,
    RIZZ_INPUT_PADBUTTON_AXIS18,
    RIZZ_INPUT_PADBUTTON_AXIS19,
    RIZZ_INPUT_PADBUTTON_AXIS20,
    RIZZ_INPUT_PADBUTTON_AXIS21,
    RIZZ_INPUT_PADBUTTON_AXIS22,
    RIZZ_INPUT_PADBUTTON_AXIS23,
    RIZZ_INPUT_PADBUTTON_AXIS24,
    RIZZ_INPUT_PADBUTTON_AXIS25,
    RIZZ_INPUT_PADBUTTON_AXIS26,
    RIZZ_INPUT_PADBUTTON_AXIS27,
    RIZZ_INPUT_PADBUTTON_AXIS28,
    RIZZ_INPUT_PADBUTTON_AXIS29,
    RIZZ_INPUT_PADBUTTON_AXIS30,
    RIZZ_INPUT_PADBUTTON_AXIS31,
    RIZZ_INPUT_PADBUTTON_ACCELERATIONX,
    RIZZ_INPUT_PADBUTTON_ACCELERATIONY,
    RIZZ_INPUT_PADBUTTON_ACCELERATIONZ,
    RIZZ_INPUT_PADBUTTON_GRAVITYX,
    RIZZ_INPUT_PADBUTTON_GRAVITYY,
    RIZZ_INPUT_PADBUTTON_GRAVITYZ,
    RIZZ_INPUT_PADBUTTON_GYROSCOPEX,
    RIZZ_INPUT_PADBUTTON_GYROSCOPEY,
    RIZZ_INPUT_PADBUTTON_GYROSCOPEZ,
    RIZZ_INPUT_PADBUTTON_MAGNETICFIELDX,
    RIZZ_INPUT_PADBUTTON_MAGNETICFIELDY,
    RIZZ_INPUT_PADBUTTON_MAGNETICFIELDZ,
    RIZZ_INPUT_PADBUTTON_START,
    _RIZZ_INPUT_PADBUTTON_AXISCOUNT = RIZZ_INPUT_PADBUTTON_START,
    RIZZ_INPUT_PADBUTTON_SELECT,
    RIZZ_INPUT_PADBUTTON_LEFT,
    RIZZ_INPUT_PADBUTTON_RIGHT,
    RIZZ_INPUT_PADBUTTON_UP,
    RIZZ_INPUT_PADBUTTON_DOWN,
    RIZZ_INPUT_PADBUTTON_A,    // Cross
    RIZZ_INPUT_PADBUTTON_B,    // Circle
    RIZZ_INPUT_PADBUTTON_X,    // Square
    RIZZ_INPUT_PADBUTTON_Y,    // Triangle
    RIZZ_INPUT_PADBUTTON_L1,
    RIZZ_INPUT_PADBUTTON_R1,
    RIZZ_INPUT_PADBUTTON_L2,
    RIZZ_INPUT_PADBUTTON_R2,
    RIZZ_INPUT_PADBUTTON_L3,      // Left thumb
    RIZZ_INPUT_PADBUTTON_R3,      // Right thumb
    RIZZ_INPUT_PADBUTTON_HOME,    // PS button
    RIZZ_INPUT_PADBUTTON_17,
    RIZZ_INPUT_PADBUTTON_18,
    RIZZ_INPUT_PADBUTTON_19,
    RIZZ_INPUT_PADBUTTON_20,
    RIZZ_INPUT_PADBUTTON_21,
    RIZZ_INPUT_PADBUTTON_22,
    RIZZ_INPUT_PADBUTTON_23,
    RIZZ_INPUT_PADBUTTON_24,
    RIZZ_INPUT_PADBUTTON_25,
    RIZZ_INPUT_PADBUTTON_26,
    RIZZ_INPUT_PADBUTTON_27,
    RIZZ_INPUT_PADBUTTON_28,
    RIZZ_INPUT_PADBUTTON_29,
    RIZZ_INPUT_PADBUTTON_30,
    RIZZ_INPUT_PADBUTTON_31,
    _RIZZ_INPUT_PADBUTTON_MAX,
    _RIZZ_INPUT_PADBUTTON_COUNT = _RIZZ_INPUT_PADBUTTON_MAX - _RIZZ_INPUT_PADBUTTON_AXISCOUNT
} rizz_input_pad_btn;

typedef enum rizz_input_builtin_btn {
    RIZZ_INPUT_BUILTINBUTTON_ACCELERATIONX,
    RIZZ_INPUT_BUILTINBUTTON_ACCELERATIONY,
    RIZZ_INPUT_BUILTINBUTTON_ACCELERATIONZ,
    RIZZ_INPUT_BUILTINBUTTON_GRAVITYX,
    RIZZ_INPUT_BUILTINBUTTON_GRAVITYY,
    RIZZ_INPUT_BUILTINBUTTON_GRAVITYZ,
    RIZZ_INPUT_BUILTINBUTTON_GYROSCOPEX,
    RIZZ_INPUT_BUILTINBUTTON_GYROSCOPEY,
    RIZZ_INPUT_BUILTINBUTTON_GYROSCOPEZ,
    RIZZ_INPUT_BUILTINBUTTON_MAGNETICFIELDX,
    RIZZ_INPUT_BUILTINBUTTON_MAGNETICFIELDY,
    RIZZ_INPUT_BUILTINBUTTON_MAGNETICFIELDZ,
    RIZZ_INPUT_BUILTINBUTTON_COUNT_
} rizz_input_builtin_btn;

typedef enum rizz_input_userkey_policy {
    RIZZ_INPUT_USERKEYPOLICY_FIRST_DOWN,    // The first device buttons that is down
    RIZZ_INPUT_USERKEYPOLICY_MAX,       // The maximum of all device button states is the result.
    RIZZ_INPUT_USERKEYPOLICY_MIN,       // The minimum of all device button states is the result.
    RIZZ_INPUT_USERKEYPOLICY_AVERAGE    // The average of all device button states is the result.
} rizz_input_userkey_policy;

// note: return true from any of these functions to pass them to the next listener (lower priority)
typedef struct rizz_input_callbacks {
    bool (*on_bool)(rizz_input_device device, int device_key, bool old_value, bool new_value, void* user);
    bool (*on_float)(rizz_input_device device, int device_key, float old_value, float new_value, void* user);
} rizz_input_callbacks;

typedef struct rizz_api_input {
    rizz_input_device (*create_device)(rizz_input_device_type type);

    void (*map_bool)(rizz_input_device device, int device_key, rizz_input_userkey key);
    void (*map_float)(rizz_input_device device, int device_key, rizz_input_userkey key,
                      float min_val, float max_val,
                      float (*filter_cb)(float const value, void* user), void* filter_user_ptr);
    void (*unmap)(rizz_input_userkey key);
    void (*clear_mappings)();

    bool (*device_avail)(rizz_input_device device);

    bool (*get_bool)(rizz_input_userkey key);
    bool (*get_bool_pressed)(rizz_input_userkey key);
    bool (*get_bool_released)(rizz_input_userkey key);
    bool (*get_bool_previous)(rizz_input_userkey key);

    bool (*get_bool_raw)(rizz_input_device device, int device_key);
    bool (*get_bool_pressed_raw)(rizz_input_device device, int device_key);
    bool (*get_bool_released_raw)(rizz_input_device device, int device_key);
    bool (*get_bool_previous_raw)(rizz_input_device device, int device_key);

    float (*get_float)(rizz_input_userkey key);
    float (*get_float_previous)(rizz_input_userkey key);
    float (*get_float_delta)(rizz_input_userkey key);

    float (*get_float_raw)(rizz_input_device device, int device_key);
    float (*get_float_previous_raw)(rizz_input_device device, int device_key);
    float (*get_float_delta_raw)(rizz_input_device device, int device_key);

    void (*set_dead_zone)(rizz_input_userkey key, float zone);
    void (*set_userkey_policy)(rizz_input_userkey key, rizz_input_userkey_policy policy);

    void (*show_debugger)(bool* p_open);

    rizz_input_listener (*register_listener)(const rizz_input_callbacks* callbacks, void* user, int priority);
    void (*unregister_listener)(rizz_input_listener listener_id);

} rizz_api_input;