---
title: 用 Claude3.5 从零写扫雷游戏-增加扫雷颜色主题
date: '2024-12-19 20:00:00'
tags: ['claude', 'minesweeper']
keywords: ['Claude3.5 辅助前端', '扫雷游戏开发', '在线扫雷游戏']
description: 借助 Claude3.5 为扫雷游戏增加主题切换功能，包括主题配置文件的创建、渲染逻辑的修改以及 UI 组件的添加。分享在开发过程中遇到的问题和解决方案，比如暗黑模式下的边框颜色优化、主题切换不生效的调试过程等。同时展示了如何利用 Claude3.5 快速设计和实现多个美观的主题方案，突出了 AI 在提升开发效率方面的优势。
---

这是用 Claude3.5 从零写扫雷游戏的第三篇，前两篇分别是：

1. [用 Claude3.5 从零写扫雷游戏-基本功能篇](https://gallery.selfboot.cn/zh/blog/minesweeper)
2. [用 Claude3.5 从零写扫雷游戏-实现蜂窝地图](https://gallery.selfboot.cn/zh/blog/minesweeper2)

我们的扫雷游戏目前功能比较齐全，并且也支持了蜂窝地图，也陆续有不少朋友开始玩。不过美中不足的是，目前扫雷样式太单调，只是模拟经典扫雷的样式。我想要各种扫雷颜色主题，想要七彩斑斓的扫雷界面，Claude3.5 能帮我实现吗？

当然可以，实现速度和效果也还是超我预期的，先来看这里不同主题效果，可以在[扫雷页面](https://gallery.selfboot.cn/zh/games/minesweeper)实际体验：

![Claude3.5 扫雷各种主题图](https://slefboot-1251736664.file.myqcloud.com/20241219_ai_gallery_minesweeper_themes.png)

## Claude3.5 支持不同主题

其实在前面实现这里扫雷的时候，已经把逻辑和扫雷渲染分开了，所以这里增加主题很方便。直接提示 Claude3.5 我想支持不同的主题，帮我实现。

于是在渲染的时候，本来写死主题颜色的地方，现在都改成从配置读。因为这里没有用 composer，所以主题配置文件 `themes.js` 代码虽然有输出，不过需要自己创建文件，然后 Apply 上去。

这里 UI 组件也需要相应的改动，需要增加一个选择主题的下拉框组件，然后选择主题颜色后能重新渲染。我的项目中其他页面有不少下拉选择框，为了保持样式统一，之前我已经抽离出来了一个单独的组件 CustomListbox 放在 `app/components/ListBox` 文件中了。

在这种稍微大点的项目中，**如果想在某次改动中用到一些独立的组件或者基础的库，目前还是需要明确提出来，并且引用文件**。这样 Claude3.5 才能找到对应的文件，然后根据这里的组件来适配。

Claude3.5 的整体改动看起来还是很合理的，**不过一旦改动的行数多了点，就必须人工去检查和调整**。

## Claude3.5 修改主题 bug

上面修改主题后，实际运行起来就发现了不少问题。比如主题中有写死的颜色，并没有全部走主题的配置颜色。这种直接指出来给 Claude3.5 修改即可，提示词也很简单：

> 这里为啥还有写死的颜色？ 要改用主题的颜色才对
>
> // Draw highlight point  
> const highlightRadius = radius * 0.35;  
> this.ctx.fillStyle = "#FFFFFF";  

改动很简单，在主题中增加一个高光颜色配置，然后使用配置的即可。不过我这里没有用 composer，它只改了我提出的这个经典扫雷样式的。蜂窝扫雷模式的样式没有改，还需要再提醒。

另外还有其他地方也有写死颜色的，Claude3.5 不会一起改掉，都需要去提醒，还是略显麻烦。不过现在想想，当时其实可以改下提示词，**让它找到渲染时候所有写死颜色的地方，都改成从配置读，这样应该也是可以的**。

上面这种小问题还好改，不过有些就需要人去发现，然后给出优化思路了。比如**目前的颜色配置，导致暗黑模式下，已经揭开的格子之间的边框也是黑色，没有区分度，看不出来边界了**。

Claude3.5 知道调整暗黑模式下的边框颜色，但是它给的颜色对比度还是不够好，我自己试着换了几个颜色，然后选了个效果好的颜色。改动如下：

```javascript
dark: {
    name: "dark",
    cellBackground: "#424242",
    revealedBackground: "#303030",
    borderBright: "#626262",
    borderDark: "#212121",
    numberColors: ["", "#4FC3F7", "#81C784", "#E57373", "#64B5F6", "#BA68C8", "#4DB6AC", "#F06292", "#FFB74D"],
    mineColor: "#E0E0E0",
    flagColor: "#EF5350",
    explodedBackground: "#D32F2F",
    outerBackground: "#424242",
    mineHighlight: "#AAAAAA",
    // revealedBorder: "#505050"  // Claude选择的已揭开格子的边框颜色，使用较浅的灰色
    revealedBorder: "#767676",    // 这里是人工选的颜色，更有对比度些
}
```

这里都是些小问题，其实 **Claude3.5 在稍微复杂点的代码上改动时，经常会有这种小问题，需要人工去检查和调整**。

这里还有个坑，点切换主题后并没生效，还是最开始的主题颜色。**这里因为自己没啥思路，就直接追问 Claude3.5，它给出了各种猜测尝试，然而试了后发现都不行**。

看来只靠 AI 不行了，还是得自己动手。于是在一些核心路径上加了日志，**发现切换主题后，用来初始化渲染组件的主题名字和配置中的不一样**，导致只能用默认的主题样式。

这里也介绍下项目的背景，我的实现中，为了大家进来页面就看到自己的配置。在每次修改配置后会保存到浏览器本地，下次加载同一个页面，会尝试从本地读取配置，然后初始化配置。同时，页面为了实现国际化支持，选择下拉框中的 value 是需要经过 i18n 翻译的。

在**增加了这些复杂度**之后，导致这里 Claude3.5 生成的代码，在下拉框中读到的主题名字其实是翻译前的主题名字。比如 dark 主题，这里拿到的主题名是 “dark_theme”。

定位到问题后，**直接把这里的排查结论告诉 Claude3.5，它还是能很快给出正确的修复方案**。其实就算定位到问题，我自己对前端 js 也不是很熟，要是我来改的话，还得去看看怎么实现，可能要花点时间。**而现在有 AI 辅助，我只用专注于定位问题，AI 会帮我完成代码的修改**。

## Claude3.5 增加更多扫雷主题

一个主题搞好了后，我接着想增加更多主题。**如果没 AI 辅助，要人工增加扫雷主题的话，难免要自己去思考每个地方的配色，然后一个个添加，费事费力**。有了 Claude3.5 后，简直太方便了，它**最擅长这种依葫芦画瓢的任务**了。

只用简单的提示词：

> 这里我想增加一个绿色的主题，帮我设置好各种颜色，让整体棋盘美观大方

当然这里在 Cursor 中提示的时候，我**加上了代码文件 themes.js 作为引用文件**，这样方便 Claude3.5 找到对应位置。Claude3.5 给的主题配置如下，不得不说，这里配色整体搭配上我已经很满意了。

```javascript
green: {
    name: "green",
    cellBackground: "#A8D5BA",
    revealedBackground: "#E8F5E9",
    borderBright: "#C8E6C9",
    borderDark: "#2E7D32",
    revealedBorder: "#81C784",
    numberColors: [
      "", // 0 - No color
      "#1B5E20", // 1 - Dark green
      "#0277BD", // 2 - Blue
      //...
    ],
    mineColor: "#1B5E20",
    mineHighlight: "#FFFFFF",
    flagColor: "#D32F2F",
    explodedBackground: "#EF5350",
    outerBackground: "#A8D5BA",
},
```

不过这里增加主题后，还是得继续提醒他修改 ui 组件，支持新的主题。然后后面增加主题就方便多了，接着提示：

> 帮我再增加一个黄色的主题

于是新的主题又有了。哈哈，其实后面我也不知道有啥颜色主题可以用了，就直接问它

> 扫雷还有啥比较好的颜色主题，帮我想几个

然后帮我生成了海洋、日落、森林三个主题：

- Ocean（海洋主题）：使用清爽的蓝色系，给人清凉、平静的感觉，适合长时间游戏，不会视觉疲劳
- Sunset（日落主题）：温暖的橙色调，营造黄昏、温馨的氛围，数字颜色选用深色系，确保可读性
- Forest（森林）主题：深沉的绿色系，给人自然、沉稳的感觉，比之前的绿色主题更深邃

不过森林主题和我前面的绿色有点类似，这里就没要了。

## Claude3.5 效率工具总结

通过这次给扫雷游戏增加主题的过程，再次体会到了 Claude3.5 作为效率工具的强大之处：

1. **快速实现基础功能**：从零开始实现主题切换功能时，Claude3.5 能快速生成主题配置文件、修改渲染逻辑，以及添加 UI 组件，大大减少了开发时间。

2. **辅助调试修复**：虽然在复杂改动中 Claude3.5 可能会有一些小问题，但当我们定位到具体问题后（比如主题切换不生效的问题），它能迅速给出准确的修复方案，让我们可以专注于问题定位而不是代码实现。

3. **创意设计助手**：在设计新主题时，Claude3.5 展现出了极强的创意能力。它不仅能根据要求（如"绿色主题"）生成协调的配色方案，还能主动建议新的主题创意（如海洋、日落主题），每个主题都考虑到了美观性和实用性。

4. **重复性工作效率高**：在添加多个主题的过程中，Claude3.5 展现出了极高的效率。它能够快速复制已有模式并作出恰当调整，确保新主题既保持一致性又各具特色。

总的来说，Claude3.5 在这次主题开发中扮演了开发助手、创意顾问和调试帮手的多重角色。虽然在一些复杂场景下仍需要人工介入和判断，但它确实大大提升了开发效率，让整个开发过程更加顺畅和有趣。