---
title: Markdown 样式示例
date: '2024-08-12'
tags: ['示例']
keywords: ['自定义博客', '样式示例']
description: 本站博客支持 markdown 样式，这里是支持的样式展示。可以使用标题，强调，列表，链接，图片，引用，代码，表格，水平线等 markdown 语法。
---

这是一篇用 Markdown 编写的演示文章。你可以使用 Markdown 语法来编写和格式化你的文章。

## 标题

```markdown
# 这是一级标题
## 这是二级标题
### 这是三级标题
#### 这是四级标题
##### 这是五级标题
###### 这是六级标题
```

## 强调

```markdown
**这个文本将会是加粗的**
__这个文本也会是加粗的__
```

**这个文本将会是加粗的**  
__这个文本也会是加粗的__

## 列表

### 无序列表

```markdown
- 项目 1
- 项目 2
  - 项目 2a
  - 项目 2b
```

项目列表

- 项目 1
- 项目 2
  - 项目 2a
  - 项目 2b

### 有序列表
    
```markdown
1. 项目 1
2. 项目 2
3. 项目 3
```

有序列表

1. 项目 1
2. 项目 2
3. 项目 3

## 链接

```markdown
[GitHub](http://github.com)
```

[GitHub](http://github.com)

## 图片

```markdown
![图片](https://slefboot-1251736664.file.myqcloud.com/20240808_leveldb_source_bloom_filter_visualization.png/webp1600)
```

![图片](https://slefboot-1251736664.file.myqcloud.com/20240808_leveldb_source_bloom_filter_visualization.png/webp1600)

## 引用

```
> 这是一个引用
```

> 这是一个引用
> - 这是引用中的一个列表
> - 这是引用中的列表
> 
> 正常内容

## 代码

```markdown
行内 `代码`
```

行内 `代码` 在这里。

### 代码块

```python
def hello():
    print('Hello, World!')
```

## 表格

```markdown
| 表头 1 | 表头 2 |
| ------ | ------ |
| 单元格 1 | 单元格 2 |
| 单元格 3 | 单元格 4 |
```

表格: 

| 表头 1 | 表头 2 |
| ------ | ------ |
| 单元格 1 | 单元格 2 |
| 单元格 3 | 单元格 4 |


## 水平线

```markdown
---
```

---

水平线上下的内容将被视为不同的段落。