---
title: Markdown Style Demo
date: '2024-08-12'
tags: ['demo']
keywords: ['custom blog', 'markdown style example']
description: This blog supports markdown style, here is the supported style display. You can use markdown syntax such as title, emphasis, list, link, image, quote, code, table, horizontal rule, etc.
---

This is a demo post written in markdown. You can use markdown syntax to write and format your posts.

## Headers

```markdown
# This is an H1
## This is an H2
### This is an H3
#### This is an H4
##### This is an H5
###### This is an H6
```

## Emphasis

```markdown
**This text will be bold**
__This will also be bold__
```

**This text will be bold**  
__This will also be bold__

## Lists

### Unordered

```markdown
- Item 1
- Item 2
  - Item 2a
  - Item 2b
```

- Item 1
- Item 2
  - Item 2a
  - Item 2b

### Ordered
    
```markdown
1. Item 1
2. Item 2
3. Item 3
```

1. Item 1
2. Item 2
3. Item 3

## Links

```markdown
[GitHub](http://github.com)
```

[GitHub](http://github.com)

## Images

```markdown
![Image](https://slefboot-1251736664.file.myqcloud.com/20240808_leveldb_source_bloom_filter_visualization.png/webp1600)
```

![Image](https://slefboot-1251736664.file.myqcloud.com/20240808_leveldb_source_bloom_filter_visualization.png/webp1600)

## Blockquotes

```markdown
> This is a blockquote
```

> This is a blockquote
> - This is a list in a blockquote
> - This is another list in a blockquote
> - This is a nested list in a blockquote
> 
> This is another nested list in a blockquote

## Code

```markdown
Inline `code`
```

Inline `code` is here.

### Code Block

```python
def hello():
    print('Hello, World!')
```

## Tables

```markdown
| Header 1 | Header 2 |
| -------- | -------- |
| Cell 1   | Cell 2   |
| Cell 3   | Cell 4   |
```

Table: 

| Header 1 | Header 2 |
| -------- | -------- |
| Cell 1   | Cell 2   |
| Cell 3   | Cell 4   |


## Horizontal Rules

```markdown
---
```

---

Lines above and below the horizontal rule will be treated as separate paragraphs.