﻿namespace GHelper.Peripherals.Mouse.Models
{
    //P307
    public class TUFM4Air : AsusMouse
    {
        public TUFM4Air() : base(0x0B05, 0x1A03, "mi_00", false)
        {
        }

        public override int DPIProfileCount()
        {
            return 4;
        }

        public override string GetDisplayName()
        {
            return "TUF GAMING M4 Air";
        }


        public override PollingRate[] SupportedPollingrates()
        {
            return new PollingRate[] {
                PollingRate.PR125Hz,
                PollingRate.PR250Hz,
                PollingRate.PR500Hz,
                PollingRate.PR1000Hz
            };
        }

        public override int ProfileCount()
        {
            return 3;
        }
        public override int MaxDPI()
        {
            return 16_000;
        }

        public override bool HasLiftOffSetting()
        {
            return true;
        }

        public override bool HasAngleSnapping()
        {
            return true;
        }

        public override bool HasAngleTuning()
        {
            return false;
        }

        public override bool HasBattery()
        {
            return false;
        }

        public override int DPIIncrements()
        {
            return 100;
        }
    }

}
