﻿using GHelper.Helpers;
using System.IO.Compression;

namespace GHelper.Display
{
    public static class ColorProfileHelper
    {
        public static string? GetProfileUrl(string model)
        {
            byte[] data = Convert.FromBase64String("aHR0cHM6Ly9kbGNkbi1yb2dib3hidTEuYXN1cy5jb20vcHViL0FTVVMvQVBTZXJ2aWNlL0dhbWluZy9TWVMvUk9HUy8=");
            string baseUrl = System.Text.Encoding.UTF8.GetString(data);

            var profiles = new Dictionary<string, string>()
            {
                {"FA_Series", "2177-APOR41-de476ec68578c865e886ef6872aa56ee.zip"},
                {"FA401UI", "19767-N39QWK-05990dae2bf601e9db8b998bfad49f57.zip"},
                {"FA401UU", "19768-K9LFCV-5224d6f68051d884a3adaa588e6300c3.zip"},
                {"FA401UV", "19769-8MSQD6-d06ff0a176407b4eaeed468a3bff2bc1.zip"},
                {"FA401WI", "19937-J3GRCD-e37d8c1557b9f11d8fb493a78b50fe2d.zip"},
                {"FA401WU", "19938-5PIL7F-a3c8522c89e03fc25e2f7290ee5c5f22.zip"},
                {"FA401WV", "19939-KIX4CK-3462e49f2c6388228b427b85332538b7.zip"},
                {"FA506IC", "7822-ZGQ1KC-bc80be3be7ca585bef60f526b6461c86.zip"},
                {"FA506ICB", "13914-2HYCD7-95fabfe5669a204620517f0158c0cea1.zip"},
                {"FA506IE", "7828-57N8GH-9fe07a7e4ebde12a8d4682d3ffa66fe4.zip"},
                {"FA506IEB", "14661-ZYWH5T-3b45ebeb7fca81d98796d5960e11226c.zip"},
                {"FA506IH", "3407-VZBOUN-8a12385fa46e077010677d330e9320d5.zip"},
                {"FA506IHR", "7823-15HGA0-44d621a3c0f0dd2c407f67d262871be0.zip"},
                {"FA506IHRB", "19343-MBMUPH-190cdb28402ba8efd3e11561c9b2eeb9.zip"},
                {"FA506II", "3410-9ZXQO2-aa08794537699c5dbfcca49b63fb7f8d.zip"},
                {"FA506IM", "7824-EKKW9A-21c7e073a81fc868b78e605b17290839.zip"},
                {"FA506IR", "7825-G6XND9-c16ea7e98b58e878c61d1071b100ee60.zip"},
                {"FA506IU", "3413-AMCR39-2a8b889a8810da4e8692f87e1ae3ea2c.zip"},
                {"FA506IV", "3415-VA0CJ6-266febe84bcecc5ed89fdc286f444ce2.zip"},
                {"FA506NC", "18359-BM2XCN-3ca9de427310b05afa92dcbe1babf947.zip"},
                {"FA506NCR", "19230-KJ866Z-1980e6f6a843b6b31111e38973fa1cda.zip"},
                {"FA506NF", "18361-CU7H6I-55beba8445b9aa0fe9cbeb8ec9a47ccf.zip"},
                {"FA506NFR", "19231-GARR16-f7052f6be62ddce2048ebcd6ba808563.zip"},
                {"FA506QC", "7829-LBYY5U-b14343c260b738563b69ad0e4f4b88d1.zip"},
                {"FA506QE", "7827-75P3DP-b664f4da04e77ed1faa722bf0c781d82.zip"},
                {"FA506QM", "9440-87VQKP-48357026f1f3099cfed1161a320587f0.zip"},
                {"FA506QR", "7830-KO7FQ6-618480f72c2e68bafc594b5323a5d13c.zip"},
                {"FA507NI", "14451-N6AX9R-0bc8e15be5cf889c755aaa7052f6fee8.zip"},
                {"FA507NJ", "14454-QXKHOE-d28f2eb001f9b7ce0582cbe33961a6ad.zip"},
                {"FA507NU", "14452-EZXLVF-c64dd3d7efede78df653b029888d9d04.zip"},
                {"FA507NUR", "19358-JYO79G-f8bc53beeadfdfef80dc6a4eb85c69e2.zip"},
                {"FA507NV", "14453-VC333P-41549f64788d59c9711eccec892fa8c1.zip"},
                {"FA507NVR", "19359-YWEAES-37feeb146db89c3549bac528d67ae209.zip"},
                {"FA507RC", "11448-0TRT8V-7712eb9302300dd82815027efbbe4787.zip"},
                {"FA507RE", "11449-ONC7VG-a7ac70468292336f63532c21204d69d4.zip"},
                {"FA507RF", "14311-X72FIU-66bf16069a82bdf2cc09f8b92cb25c67.zip"},
                {"FA507RH", "11453-W4B8H4-e1645d3ce1e0216a30246ad6a84c3819.zip"},
                {"FA507RM", "11452-ZGHOOO-f3bddf2fddd3c027568646bc5afe3c7d.zip"},
                {"FA507RR", "11450-UU8KFV-2c718d16687fa3b038e625f504ccd13f.zip"},
                {"FA507RW", "11451-XHL0SH-c2702d2047b7b93636cc1372caf25a75.zip"},
                {"FA507UI", "17850-4J1GCV-c30e3d47aa82df4e3f0754888903c5dd.zip"},
                {"FA507UU", "17851-PIGBD6-45227ab485302ec2cca63f0bbb71d473.zip"},
                {"FA507UV", "17852-T32MPT-a2fd989758365b8a04e4dc5bbb146af1.zip"},
                {"FA507XI", "14817-A522MM-fad14cb28f00b94735eb55c2b3b7b892.zip"},
                {"FA507XJ", "14820-8RT0TF-9d341fae2a290494206deb5fcf1fd427.zip"},
                {"FA507XU", "14818-3PA2GD-2d1e2d035309ec7282a1c47e27f7c7fd.zip"},
                {"FA507XV", "14819-ET4L73-daf905274776ae9c92a7b74e687dc63d.zip"},
                {"FA607NU", "20567-VB45RR-ceeec88490fec992f2f8948ece38952e.zip"},
                {"FA607NUR", "20570-XEDISK-5e1220f6a19492a3e6319697497deaa3.zip"},
                {"FA607PI", "19157-PL5PW6-2fde4880a46a6b7357d96eaa7a4ec946.zip"},
                {"FA607PU", "19158-AWQ1FA-f1ed2d008bef71741a9b09b35730b9e7.zip"},
                {"FA607PV", "19159-V6UKPP-92f56a3aa89b834d1ab12f229a8ae1a7.zip"},
                {"FA607RC", "10190-XHDRTQ-0e6c248e3dab6bb07e052edd963c5218.zip"},
                {"FA607RE", "10194-AF495K-23a4d74be5132e4babc64bb13237a12b.zip"},
                {"FA607RH", "10191-9BS333-c6deb5f9fd5a37d446d2722da54c0ec3.zip"},
                {"FA607RM", "10195-4U5EEF-cf98d168cacdd5a60782e881a9c143be.zip"},
                {"FA607RR", "10193-FYX2N7-730c76e49ef71a6164804eafd2621dab.zip"},
                {"FA607RW", "10192-UFOOP3-f52a50dac189ffa96560f73e04c53a6c.zip"},
                {"FA608WI", "20103-UE0O65-d6707b2a2f666d671d728661c981883a.zip"},
                {"FA608WU", "20102-IQVJL2-edc900ffe25635856729d26dbeac272f.zip"},
                {"FA608WV", "20104-EE3Q5U-a7695b4d1668b1a8dda2576f64bffad2.zip"},
                {"FA617NS", "20225-0J8FEF-cb6ef3732560ed38542d5047e78596f0.zip"},
                {"FA617NSR", "20226-B5TAVP-f153443e85ccad055fa12d58eec69c5c.zip"},
                {"FA617NT", "20224-YN6NKP-1d0e927ae5c1bb7d15e36b63176460e2.zip"},
                {"FA617NTR", "20227-KL8UNI-2b4063b7a52b142fb75e9136570afbf9.zip"},
                {"FA617XS", "15968-Y9NFXN-cb420fe6e177fc1cf675e9d42a6fd0ea.zip"},
                {"FA617XT", "15969-UKYP5L-ad54051ebbad4b17693b65f5bceda799.zip"},
                {"FA706IC", "5215-5J3H5Y-d2cdc2f5e03d68e5e5e562581a77c8e6.zip"},
                {"FA706IE", "8827-43DTPG-ba6be621f7d0dda88e5391164cbc7a74.zip"},
                {"FA706IH", "2610-2EJ0EQ-245d43d7bd14bb3e664fa96e9f5a690e.zip"},
                {"FA706IHR", "8828-XBJAQU-5d8064b0fb63ca7866ee4cf821ece676.zip"},
                {"FA706II", "2611-HO3IK9-2fb972a395137c940151723b01e9b9cb.zip"},
                {"FA706IM", "8829-GWFKN5-5ab773eb09bfb3099137fae3c7d547c1.zip"},
                {"FA706IR", "8825-63J2NY-2496ecf21b5fa71e65671531b670cdac.zip"},
                {"FA706IU", "2608-EI64MF-64c35bda7789e6e71298e22d793b78d4.zip"},
                {"FA706NF", "18362-1V7Z1Z-0bc79f01bdfadc5b39342fba622a5b8d.zip"},
                {"FA706NFR", "19232-FE6TXN-d062445db610ce901453145ebc518efe.zip"},
                {"FA706QC", "8826-032S4E-868933565b1a7d762bda8cafc1e77458.zip"},
                {"FA706QE", "8824-KZNJL9-9d827f4973d4c9787ff050dc1bf35eef.zip"},
                {"FA706QM", "8830-6NX7U4-b7bbfe663aa954534d33d2f822181728.zip"},
                {"FA706QR", "8823-RXSLAC-a2720365e842af1dd826920fb447fba5.zip"},
                {"FA707NI", "14455-19J6WZ-10282c6083ee018a614e75bc809ecf1f.zip"},
                {"FA707NJ", "14457-BGJD0K-d963ff94009c9a2a5b99606eac711a95.zip"},
                {"FA707NU", "14456-VAZ4LS-1d798d3873c55e9d10b43a3f2b12cd15.zip"},
                {"FA707NUR", "20568-IPF4CY-f7bd11b80ffa20b77b75e6a89213db48.zip"},
                {"FA707NV", "14458-7G8B40-08117ddb45ed3c6978aa4ad60e3d2c96.zip"},
                {"FA707NVR", "20569-1MFNC4-e41979f29c26628eacf1e9067dd3544d.zip"},
                {"FA707RC", "10196-81D3O0-94ccf4d908c9bcb44f8f9092ef9fa2e2.zip"},
                {"FA707RE", "10200-AUS9AW-7f366055be2ae2b4c659aa9590bb4d5e.zip"},
                {"FA707RF", "14312-6KGU80-09ba6d3e3b490c3d1dce3d16df62cd8a.zip"},
                {"FA707RH", "10197-BB5746-a958ff2eeedcfd1753c2e7151c0a3f96.zip"},
                {"FA707RM", "10198-TBWO12-e35e49d79fcc03c5cc84b5b40c222e80.zip"},
                {"FA707RR", "10199-LILM59-05448f5e429c6c4be7b531d0b6aa2319.zip"},
                {"FA707RW", "10201-0KXC4K-3dca8e95a9e676a1010efc79becde228.zip"},
                {"FA707XI", "14821-JO8WIQ-77921f1a7a523fe5674f39f10e66f4a3.zip"},
                {"FA707XIN", "14822-7W7Q8W-e2e50358e878b092fc888e8e70575985.zip"},
                {"FA707XJ", "14823-MX6CGK-0d0862cd441f96a72b1c8baeaa8aa3b4.zip"},
                {"FA707XU", "14824-O2LZZA-f0ea2bf54bbc4fd4e7391048f4a083e4.zip"},
                {"FA707XV", "14825-DUSKD1-7d0a055d869a7366105380c44788724b.zip"},
                {"FA808WI", "19512-TZ3G4D-60c6849ce49cca1d2177f31ead77df5a.zip"},
                {"FA808WU", "19510-ASGCD8-0558641c1b976b901c52d1d72f0bddd7.zip"},
                {"FA808WV", "19511-QDVPAJ-f3990996e7a9c0d472b46af286d529f1.zip"},
                {"FX_Series", "2174-J1XJKV-bd932ade5eebb0b2f1a36eac85bc5c7d.zip"},
                {"FX505DD", "3439-CJLCNE-3df3a90619c571de2917a35a402fe6cb.zip"},
                {"FX505DT", "3427-H77L9I-2f3f50fbbb1dc4ac6e703b2820acb491.zip"},
                {"FX505DU", "3426-9P4PXL-7e640e1e38c6395bc5455bdf838ea83d.zip"},
                {"FX505DV", "3425-31OQ2O-3ab11acfb17dca8f339fe0b8a4efa33d.zip"},
                {"FX505DY", "162-H1YFBE-1e5c82e28fa35559e5f7a6aa934d7405.zip"},
                {"FX505GT", "3423-8CCGEQ-a72ef69d8d5aab7bfd3eb34e2a55cd48.zip"},
                {"FX505GU", "3424-9J0I5H-1c209ee72d9f7ba2caa559fddd9f5fdc.zip"},
                {"FX506HC", "7821-BDCXZM-23e718ce9f58cbef286e77c7d97752d0.zip"},
                {"FX506HCB", "8452-QZYXAU-9385f6b96812173b12dcf23934d2729d.zip"},
                {"FX506HE", "7831-C0XU6K-16e393308545bf5fa327997b33edeba9.zip"},
                {"FX506HEB", "8453-42FVNT-a7c6b122bb1f2e16340c016d09b43c13.zip"},
                {"FX506HF", "14511-KKQA1F-9129e79baf1215ce451e791b51fee304.zip"},
                {"FX506HHR", "7832-KJD4ZK-d6e5fcf84caf94be5b312d6233876322.zip"},
                {"FX506HM", "7833-2EVLVM-3082377bce59838bf06bd09c3c9911fe.zip"},
                {"FX506HMB", "8454-32DRJH-818506f55eef4d13839ea8e8d8765534.zip"},
                {"FX506LH", "10917-Y6JJC7-4596433cf10a71242d9a9255c2b31458.zip"},
                {"FX506LHB", "16838-WYAR19-d3f87642f6cf12ec77e231b7d405fa61.zip"},
                {"FX506LI", "4428-Y7KRBX-df2c328780c4506a2cb2279ddf84ca58.zip"},
                {"FX506LU", "4429-34SZ6D-2df0b447ff1dcf6d887cad5c679331de.zip"},
                {"FX507VI", "14064-MTRMKH-169de48f4b0b3035315106bde1a1020f.zip"},
                {"FX507VI4", "14065-9VTCNA-b5e0ac043ffd3e3ffab879f6401b2e07.zip"},
                {"FX507VJ", "14066-W5FPY3-89180f515ba2c785b1f87c895e09cee9.zip"},
                {"FX507VJ4", "14067-DKVRHI-bc0fa5ec61259e31536356ec67d27cb5.zip"},
                {"FX507VU", "14071-EEJKDG-95e42e7c6ebaea33206a1de566588ae8.zip"},
                {"FX507VU4", "14069-1JAF2A-4d328ede6adf0796924734da3e04a18f.zip"},
                {"FX507VV", "14068-QO62TU-b6aadf3d84f816a42f111649bb1381ae.zip"},
                {"FX507VV4", "14070-WHB99Q-57b4d0c8f9405038db3e298f72474505.zip"},
                {"FX507ZC", "11454-8DEVNS-3503e698cf0b56b387bf65ebd0169786.zip"},
                {"FX507ZC4", "13785-D9YTVH-2fb9db83c6f04518f230d1d453373e5d.zip"},
                {"FX507ZE", "11459-DKP456-c8d8862da76207dc0a3bf2642b98632d.zip"},
                {"FX507ZE4", "13786-3YM16F-fa4c0a13c74e6c1253d464bbb035cbc3.zip"},
                {"FX507ZH", "11455-OQI6ZD-866eb458d7ab9ac51cb88966b2c4acf1.zip"},
                {"FX507ZI4", "14056-D01K4S-bb2cfa4d564b8a6834c78d675aebdd1c.zip"},
                {"FX507ZJ4", "14057-YY0XRG-4f7570dee1902f2012b812d50b0d2334.zip"},
                {"FX507ZM", "11456-OM12KU-7c91b2d14b093dc2eef17a555e14ada3.zip"},
                {"FX507ZR", "11458-P8RTC8-2b3802527c98749fb68397f35c6bb86b.zip"},
                {"FX507ZU4", "14058-9ZYS4E-7e244d3e7dc3641d602130563c1c84b7.zip"},
                {"FX507ZV4", "14059-VBGCNK-0314facaf02290da1a75d1b00455cb3a.zip"},
                {"FX507ZW", "11457-4F1FOO-5f24a98f90735cedf1ad9fb5ac90adbf.zip"},
                {"FX516PC", "7788-GJYPET-06cf200d5b8fb92c807de03796535e80.zip"},
                {"FX516PE", "7789-WIT1BW-b32fd9546ac9ac5b6878a3f46c30247c.zip"},
                {"FX516PH", "7237-G94WZH-30c10f820dcdf03cc661fd9b73c2927a.zip"},
                {"FX516PM", "7790-OG0DVJ-e7ad44e2fa38eb4256e09a62a744659a.zip"},
                {"FX516PR", "7791-LJ7RQ7-36c58a0b55aeb5c3782302fd58139815.zip"},
                {"FX517ZC", "13757-QJDW9D-ab71bd2ecf24d182bf32fbd931b24e58.zip"},
                {"FX517ZE", "13758-75WLCE-fac3186e372a6e0e422d3d78de1addb3.zip"},
                {"FX517ZH", "11461-A4BH34-2464f8a583b064ab2bdb336dc13d8b2e.zip"},
                {"FX517ZM", "13759-694BOG-7b8f61a1d8a387715721fd2b8e0bd766.zip"},
                {"FX517ZR", "11463-MCHEWS-7a732705aea49eb663fe1e8930c463de.zip"},
                {"FX517ZW", "11464-S41ORA-d99633ecf421ba4ab73800bc9ebf2e5b.zip"},
                {"FX607JI", "19085-6NMHTY-9137eab4a853f284c0ac1f8890735c7b.zip"},
                {"FX607JIR", "19088-H9SUHL-c75a1547f17e7c69e0a870425d3592b8.zip"},
                {"FX607JU", "19086-N1S5J4-c4fc8458bcbefa107fc1c2e1dbe44255.zip"},
                {"FX607JUR", "19087-ZBS95F-bc3055487fdc07870c12341042a37222.zip"},
                {"FX607JV", "19089-LLP8ZE-c52cc4765390eba2eae3c798a367df25.zip"},
                {"FX607JVR", "19090-XQYJEH-a5aaa078def637077c4d1d3a619ae198.zip"},
                {"FX607VB", "20704-FGKI8R-ac8a18cb35a009bcdb6d18ec7537879a.zip"},
                {"FX607VF", "20706-OMC7L2-e66289430eb7decd16fe4c6353edb8c4.zip"},
                {"FX607VI", "14072-0Z0LX5-c3145816b5c9b045a3e829e194425624.zip"},
                {"FX607VJ", "14073-H1KA78-95472184994955393ebf635af4a55c71.zip"},
                {"FX607VU", "20707-N1HJ0V-31f1da0a565763c625714c39b7bb5bae.zip"},
                {"FX607VUR", "20705-ON83H2-dd9e78d43fb57f06d0e8ef0d9d1e849e.zip"},
                {"FX607VV", "14075-BX4NJX-a9e24be091f08e6cc3885397f143bdc5.zip"},
                {"FX607ZC", "9267-SQXQMT-edf1ee77d7f276d9b2f14fbe80e86459.zip"},
                {"FX607ZE", "9268-MI06A0-5f60b76f497adb2c80dc5d34e7ca00ef.zip"},
                {"FX607ZH", "9266-75PO51-12f649be993639c1ff986129977bc516.zip"},
                {"FX607ZM", "9269-MEPP17-baf25a9abae3ae712da40dc6c4f2de22.zip"},
                {"FX607ZR", "9285-7B20C5-9a0ee909d954eda9fd9f334a6b76bdda.zip"},
                {"FX607ZW", "9265-9H05OM-5b2735efc15db9c49302451b728338a8.zip"},
                {"FX617ZC", "9263-3PLDC1-74d554f08fac5b1689c7dbb581fc97c4.zip"},
                {"FX617ZE", "9264-9L5V7F-203b8f8a48d47470aef80dd42bbef60b.zip"},
                {"FX617ZH", "9261-DIXTFE-b20887acff77b59a80e62088caf695f3.zip"},
                {"FX617ZM", "9262-OXO77E-8476443cfd885a718b915731b9807bc0.zip"},
                {"FX617ZR", "9286-VA9VXJ-8c69c08b5812b00656142d93cb5a5013.zip"},
                {"FX617ZW", "9260-O8UGYN-9678cab288d9b85ec59961647ca94ff7.zip"},
                {"FX705DY", "163-N6IM0Z-3bee0b29abd2d6b419ba322661d64a6a.zip"},
                {"FX706HC", "8834-3HMY7W-fb49a16bc9cda208a3acf5f2ea32fc63.zip"},
                {"FX706HCB", "8835-FHPH4O-319d35ab96a1eef3b5ae7fefde106cf2.zip"},
                {"FX706HE", "8833-SW8GIL-71ae2ebbdb18ec3380cf682be0ca32a3.zip"},
                {"FX706HEB", "8836-SUE4HH-55876358bbe39f53ea2010c8f66e9093.zip"},
                {"FX706HF", "17052-8B8C18-0c762fb15cd6367d08c954ce5e01f497.zip"},
                {"FX706HHR", "7837-S711RT-ed9d8a61e80895a6403dda19ac873f62.zip"},
                {"FX706HM", "8832-O7W1D2-853dd8eb62665c369cd2c3b716a53b80.zip"},
                {"FX706HMB", "8831-NKXZ56-437ac6d56280dd0734f9f56db3ba6a6f.zip"},
                {"FX707VI", "14076-C4CQ2E-0771f0ec46072ac38a7dbb8829783298.zip"},
                {"FX707VI4", "14078-UXPPY2-ffe538cd58da15c780e6263c2818f995.zip"},
                {"FX707VJ", "14077-6KB0BJ-af4fae81000b0143477091deaca569da.zip"},
                {"FX707VJ4", "14080-YBM0VD-bef842b5fcc1b49cb054cfb1eb3d2258.zip"},
                {"FX707VU", "14081-I8JRY3-2ab8a5dcab2033a19de169e424da1530.zip"},
                {"FX707VU4", "14079-TALDGM-c7d6c6820a223967463a76152e178af4.zip"},
                {"FX707VV", "14082-2UYJNX-a21d4e4e856e8a4fe52b30593705d818.zip"},
                {"FX707VV4", "14083-79JC8K-74d96cb066ded2d86255755fdc1f3167.zip"},
                {"FX707ZC", "9278-7TRFVL-9a0693a78d8d69a265cb7101314dd055.zip"},
                {"FX707ZC4", "13358-EPBJ9S-035eca4acee4db9814f693f4aeef0147.zip"},
                {"FX707ZE", "9279-QYJXB7-17ff65bda614791358426882d48be6fe.zip"},
                {"FX707ZE4", "13357-V3LZL7-64a1ecac6b4657e98a422cd5657cc89b.zip"},
                {"FX707ZH", "9280-62FAFQ-3193a4215440ecbe7fece9091fad6205.zip"},
                {"FX707ZI4", "14060-EEB7IW-e716f0f9a1f8f91e5ae93d902de96385.zip"},
                {"FX707ZJ4", "14061-T7UBPM-91f62b48749f5ed42e3c3d1f2b8bb645.zip"},
                {"FX707ZM", "9281-YKO83G-ff6a896b4e055cc6500470636cf9e1ad.zip"},
                {"FX707ZR", "9284-GYDQK8-bfdc718699fb7030b0f133402933e12f.zip"},
                {"FX707ZU4", "14062-52EB12-8a85d0170af52dfbaf216b98085015d0.zip"},
                {"FX707ZV4", "14063-R6EM57-62ad692f855e33bb05aaae1823207415.zip"},
                {"FX707ZW", "9282-E6GYQU-5f673e25b2ef5e57c78e36668e9c5e9f.zip"},
                {"G_Series", "2176-RS8S2K-e815e5e0be51e1bd76674cd3826cbfec.zip"},
                {"G512LH", "3312-AM98EE-e9a32238fa66ffe8683ff0a34019f216.zip"},
                {"G512LI", "3310-9MDL49-daee5dd162a699f60f2bb68a3cba7ef7.zip"},
                {"G512LU", "4150-SX012C-b6e7d21b645495f57b2fb7bd9734e839.zip"},
                {"G512LV", "4151-LUEHCJ-f145d1dd67079a3739a564cb04eaa6ff.zip"},
                {"G512LW", "4152-4IMGHN-f0a946d2f21860039a9181b17ca1f1be.zip"},
                {"G512LWS", "4153-IZDAY7-3cc48027800d6d123db4f584a5a2e4a4.zip"},
                {"G513IC", "7233-I1XU1L-57f580817efeb347c2e64b467b569d48.zip"},
                {"G513IE", "7232-7C4QK2-effb8e534fc4639d7fd72e957e1a13fc.zip"},
                {"G513IH", "7231-YGY2HL-ef7e448a0e3b2502219c74c2f8a26a72.zip"},
                {"G513IM", "7883-JSH1ET-04fb928a7fe54481b8156627d30451ce.zip"},
                {"G513IR", "7884-DB01TN-5bdc2457c9a42ad9c0b1ab82139beeac.zip"},
                {"G513QC", "7228-I73APA-79e1e7f9582bdc44f510d651e909250b.zip"},
                {"G513QE", "7227-9J3H2Y-d222e0119fef169bbe0f20f754743ca7.zip"},
                {"G513QH", "7226-MUU2SQ-05a65cada4f1c986b7b2c5e2cf7ea796.zip"},
                {"G513QM", "7882-2FWOWK-ca956a4c309edb8cd9d9c24178ec3912.zip"},
                {"G513QR", "7885-4VL6WK-6a21c044bb2d69f55febdb6ffcd5b7d8.zip"},
                {"G513QY", "7881-S6R4GZ-5832d1de6fc107509803927e4a52ebf7.zip"},
                {"G513RC", "14513-WMQ0GS-4018fc7459d96efec72f15f724c33062.zip"},
                {"G513RE", "14516-VXJYUR-fbaadee0ba8dea2a24282b2be882d571.zip"},
                {"G513RH", "11732-8ODACG-845738811f5dcaee76c7ba113ed0c8bd.zip"},
                {"G513RM", "11735-UXEJT9-03457f6d6350f0a860fe6386de27a659.zip"},
                {"G513RS", "11733-9SABRD-3a4c8dee5ff96668dc9ff509d626e17e.zip"},
                {"G513RW", "11737-VS9IFQ-b9c6657578263ac3ab1062b32ab599bb.zip"},
                {"G513RX", "11736-CHOX6M-ca19a5d6e7153102c3825f8b3371b4d7.zip"},
                {"G531GD", "3698-YSDO31-352980933199182c587573ecf056711b.zip"},
                {"G531GT", "3697-OYLYLQ-4916a89afb3a6964cb2b0ddd8dc45fe1.zip"},
                {"G531GU", "744-S7QQP3-8572157fa95e0eb235f29df0227d5064.zip"},
                {"G532LU", "4146-NF3MBY-79c262fe416eb469fdff811d501233c9.zip"},
                {"G532LV", "4147-F6P59K-328b1796ee854653a1470be865e06d0e.zip"},
                {"G532LW", "4148-KUJ0SA-affcc286138b433b9b051dffc8158672.zip"},
                {"G532LWS", "4149-RDJKG0-c5f4470225e184cdbc34b9b41c9e2666.zip"},
                {"G533QM", "7880-VL41LZ-ea6868a4918e7a2571a169b0b20d53de.zip"},
                {"G533QR", "7879-3915UU-cec5ce6e895bc9acf0367b1ae69d7d01.zip"},
                {"G533QS", "7878-SLEHTN-4844d16bf258768105873010c17398ea.zip"},
                {"G533ZC", "11725-BVSBSP-1f91feb49662e4f4257a27ea081db4ac.zip"},
                {"G533ZE", "11730-DEG4Q9-3d77f3901752747e449fdaa5467a250b.zip"},
                {"G533ZM", "11726-01FCGK-180459312539e4c38def3c7323a60494.zip"},
                {"G533ZS", "11728-KGTOE8-4fe0474fc6e8944dbdcf726bad1a7db1.zip"},
                {"G533ZW", "11727-98BKOJ-93e373e64e92c21ff018ba6c66a9de9d.zip"},
                {"G533ZX", "11729-XNFMPR-e0aad4e4d4956dba8629f419b1f86026.zip"},
                {"G614JF", "14496-NAATJZ-a3847e890e57aa749645b854b28ead79.zip"},
                {"G614JI", "14168-4VTU0U-37decb2df809672eccf1156769eda929.zip"},
                {"G614JIR", "19126-IMXGO5-4cce9f45ad28fa60d016f8d212c50b10.zip"},
                {"G614JJ", "14497-P0D5PL-abe178509e0316da9ee56b24e15d0384.zip"},
                {"G614JU", "14498-5D71EB-2300be03087494ee34356470ca022b7c.zip"},
                {"G614JV", "14500-SPJCAL-a8e2e223857c334ba4c20c8122151bb7.zip"},
                {"G614JVR", "19129-EA1WB4-4666564ee013c4df53be44bcdd20bec0.zip"},
                {"G614JZ", "18199-P9WWOH-093d361358629a2bddd5bff7b5fb7a5f.zip"},
                {"G634JY", "14163-JLRBOO-8ea519425efe56cc144e38d22cebd3f0.zip"},
                {"G634JYR", "19130-MUAT65-0eced7ca55a61cc41341faa3a48d34f3.zip"},
                {"G634JZ", "15827-MSW5I1-0f39e92313e54afe3e35f5636dc37fd5.zip"},
                {"G634JZR", "17891-O7PAGL-5c6e6d059ff7bc1b9245fdf8a8066263.zip"},
                {"G703GX", "105-NMT9XG-76a0810ddf16ee376fa049bd179377fc.zip"},
                {"G712LU", "3364-3GYELH-a0f545d6a2f5ca2516e91f0495f98110.zip"},
                {"G712LV", "3365-UYDEWV-6675727e4e0588b95d9faa2df69b1972.zip"},
                {"G712LW", "3366-OK41IE-fc01da1e3d6217e6bce24f3237b5631e.zip"},
                {"G712LWS", "3367-N1B9F6-72dd79495de9b660a8b120579c708623.zip"},
                {"G713IC", "14187-GKTF5N-c602fb66b48f86aa2ab7b14367dba7b0.zip"},
                {"G713IE", "11023-PVEVI5-bfa9a58633213b87629c5117030d54f2.zip"},
                {"G713IH", "6317-I3AGUT-a0a1e3b68265d7bd3a2a1657afa0cfb6.zip"},
                {"G713IM", "7890-IC1UIL-85b242f2f61aef5cd16166178b6a1adc.zip"},
                {"G713IR", "7891-832AOR-104e408922a3f0c4e8d97d03dd000083.zip"},
                {"G713PI", "14527-XK0JY1-ffe9b04acfd36ebcf3b1331577515b8c.zip"},
                {"G713PU", "14528-AC10R7-ee30e2f76e16c16db44758ac911e9d61.zip"},
                {"G713PV", "14530-3ONUVM-abf27eca2271dcdfd150acdf6cc26800.zip"},
                {"G713PVN", "14529-YMPI29-b958f3ae6ad8118997c16c87d9840fb9.zip"},
                {"G713QC", "5496-KAW7ZL-7a45d99d71ba375d79d047a015c27c2a.zip"},
                {"G713QE", "5497-T7QUN2-f5c00e128ed96b9727dcdfb4d857dbb7.zip"},
                {"G713QH", "6316-ANOUE8-9b18e7d3aeaeb5cc4520be09df860617.zip"},
                {"G713QM", "7892-JCIYF7-acf05d6b34e417efed385e84dc079677.zip"},
                {"G713QR", "7888-XIBCC9-d2e608529ce49f0daf90bf3d81cbd69e.zip"},
                {"G713QY", "7889-FH9X9W-5c4d00f5506924fc9f29e1c190b1bf51.zip"},
                {"G713RC", "14514-8R6TFS-eb95e08804622256fc5be85a1f14301c.zip"},
                {"G713RE", "14515-LTB9LQ-a6a522a9d63083e0366d13f40af54ebf.zip"},
                {"G713RH", "11305-VO5JTS-7cb1b763f054da29ce2ba1e08c897a60.zip"},
                {"G713RM", "11309-GX2AYR-5b172b743c185242080b08dd7e2b7fc7.zip"},
                {"G713RS", "11306-E1A3OM-37679d1dfc144d892325420d784f5d8e.zip"},
                {"G713RW", "11308-IPZSAB-6c8827c63a27cee6257c755bf0bd9c41.zip"},
                {"G713RX", "11307-JGFO1D-cff83a2f34e3c0ed755ed63c20d2905d.zip"},
                {"G732LU", "3368-C89MVD-1ecb4a036b697bd4bd027d2bd160d219.zip"},
                {"G732LV", "3369-TI19K6-56ca5eb37397117c97e0bae42e82b2b4.zip"},
                {"G732LW", "3370-HLPSUS-9c7615d0220bde50de5ecd4c7e51182c.zip"},
                {"G732LWS", "3371-B4CG89-c22a9f4deb49d6e1e921ebd5a0cab685.zip"},
                {"G732LXS", "3372-OJEP07-c0e21f578660bec502aec19a3645b067.zip"},
                {"G733CM", "11332-V8B7E9-2a7f61f88106051be62b57250ed33eaf.zip"},
                {"G733CW", "11334-MQ3PJE-f03f2950247ac635dda1b30245d220aa.zip"},
                {"G733CX", "11333-XS984I-d48bb5ee3416d47fa203090bc8bce04d.zip"},
                {"G733PY", "14531-B4NFUU-4ec97a54081ea4b713975fd1ab7c1b80.zip"},
                {"G733PYV", "15178-1CIVEB-5a9d09a4d22d6361992c7cd6ca27fb41.zip"},
                {"G733PZ", "14532-4UUM5E-296ee92ca5416a8c59bffd6f101feaa5.zip"},
                {"G733PZV", "15179-EDHNHX-ce69d260b1e8077d8d522d3b4326322c.zip"},
                {"G733QM", "7893-OW1O2I-a2dcb8ff88cae20c7086bac8d9312dbc.zip"},
                {"G733QR", "7887-OA7Z12-bc86110ff0d1f359d9230fca8bbabe51.zip"},
                {"G733QS", "7886-V9PIMC-27ca6272c2b093264d88a32f1093a4fe.zip"},
                {"G733QSA", "5501-LX7POZ-9289c2079bdb48e2fdd76d7981fb0e5d.zip"},
                {"G733ZC", "10077-J3XTHP-525deb09f2ada7dc36dc82772f7a9cce.zip"},
                {"G733ZE", "10079-KAW34P-16c4b5e812e10019f21b4d7f879acfaf.zip"},
                {"G733ZM", "10078-K6B3CR-63dd00f6ecc3eb61e92439ef5caaea17.zip"},
                {"G733ZS", "10081-VM2AN1-517b1e41388f12048ec3a88c780f1d65.zip"},
                {"G733ZW", "10080-HY42QH-aa285046069cfe113953b91f1a28d101.zip"},
                {"G733ZX", "10082-JS5F1Y-41bccc831aec7bf1c0a59a309bc607c7.zip"},
                {"G814JI", "18243-BAU912-671afb033d3b1c44f9852ff608910f42.zip"},
                {"G814JIR", "19802-1CGBPH-f1d31bab157b36d109e1e10591d49f4b.zip"},
                {"G814JU", "18193-Y5GMF0-843cee9ed982a3d5aba21e99efbc396c.zip"},
                {"G814JV", "18194-9Q537I-c5c2ca782d26dcd5346c110767347903.zip"},
                {"G814JVR", "19801-JK7M4V-617e0c975bf6e2a6f67802d825fa6aa4.zip"},
                {"G814JZ", "18195-V98WBX-19d4c2e52916bf9c96fcaed6f1d9bdda.zip"},
                {"G834JY", "15954-HAV3KR-d219c43750d485279e12cf76f5b2569b.zip"},
                {"G834JYR", "19121-GX7FZU-7c449cf7db0033db75da0f4a464ee4d9.zip"},
                {"G834JZ", "15953-C7XC62-a987058c0a26fa3c929b300d099296a5.zip"},
                {"G834JZR", "19122-CAYURL-f71108b839d923ae92f3f83451ddfa69.zip"},
                {"GA401IC", "5864-KC8TTP-082f9a62dda322ccaed82ff3e3466bf8.zip"},
                {"GA401IE", "5866-JO8504-dde5402bdecafc1cef55a7dc3d6167ec.zip"},
                {"GA401IHR", "5865-7DV6TB-9833a54c7334dc3aef1b9e99f56b9e95.zip"},
                {"GA401QC", "5129-PY283Y-ac372208c57a7f558db6c169cd50d091.zip"},
                {"GA401QE", "5130-C2G5CO-8ea0eb1ca537d77d19bad13dee55294c.zip"},
                {"GA401QH", "5124-QQ97GA-bbde59c5235d8b72b78059b95e8a23a2.zip"},
                {"GA401QM", "4922-222SBA-340a82b955a5f57ff39f6d2d08af365b.zip"},
                {"GA402NF", "14160-ORONGT-ca84f0561683e1a07548d0cb7e42c275.zip"},
                {"GA402NI", "14159-SDCMA5-300bd29af08b0f5d1527a375f8c326f2.zip"},
                {"GA402NJ", "14158-O7H0GR-10db546f9901ac02d3ce8d5a28cb4772.zip"},
                {"GA402NU", "14157-QJ4W59-69222faad499f94b4d96f7d85504930d.zip"},
                {"GA402NV", "14156-ZKGYBE-ae1ac3947eb8684cabc0cd45f8d4c67e.zip"},
                {"GA402NY", "14155-AL3KZU-17ac9e4b88c03ebaf983134f76f9a4b2.zip"},
                {"GA402NZ", "14154-SY6J4X-7d8416a09b51e32f856f3353173ccc70.zip"},
                {"GA402RI", "10145-9W1623-272e082c57c6e41074b2cace72adc92e.zip"},
                {"GA402RJ", "10146-IY7ENY-f6d2d25b5b6b21616ceddc4e9aefa656.zip"},
                {"GA402RK", "10151-7RPIER-2588aa83188168f8375ed9bab7bb67d2.zip"},
                {"GA402RQ", "10147-9NQMQH-7ff3944c376e91b26c0a1c18122a4262.zip"},
                {"GA402RU", "10149-3F10IX-43c96d30b6702261c3cf85467857eec9.zip"},
                {"GA402RW", "10150-5H5ISD-1badfa856f0ec8d15d9d5832a8d54fc9.zip"},
                {"GA402RX", "10148-QFCU8O-704d371255ae8a72737f5f8eca75eb9d.zip"},
                {"GA402XI", "14899-86ZX57-5940ed56b182781334ca2856f6ba0b9e.zip"},
                {"GA402XJ", "14901-MDIR3C-5022331539bb187bf041a7e3ab0a46bf.zip"},
                {"GA402XU", "14900-KYCOC7-361bb364d26ff834d6bd716d14f70006.zip"},
                {"GA402XV", "14902-EL34M9-731ba1cc0d27d2db9a79d872673e7958.zip"},
                {"GA402XY", "14903-ICC56W-0456739d8ba5ee543dfba99eb6ad217a.zip"},
                {"GA402XZ", "14904-B3K2NR-928b7272790e7da0079c549cd4885d5d.zip"},
                {"GA403UI", "19112-NB8TJ1-e1de0121e30431cc5520ea6eccb6e46f.zip"},
                {"GA403UU", "19113-C86SAH-4338dac48ad593c4079515b7599b8943.zip"},
                {"GA403UV", "19114-6KR0FP-4740ed98a2ca06bc26c363de380a037d.zip"},
                {"GA502II", "3554-REAPZQ-5f94c7ecd52ae2cad50aaac4341bec7b.zip"},
                {"GA502IU", "3555-15UWZ4-d1cd040265773efd61bdfd146140a990.zip"},
                {"GA502IV", "3556-ULLH3K-1f56134e43e1ffa353256fbeb9840d3f.zip"},
                {"GA503IC", "7457-RENJRP-5b833a2bd8e1e13ec41f0acf7ef04fd0.zip"},
                {"GA503IE", "7465-QO1Q0F-663f0c9501e649bcb0069413f3081a49.zip"},
                {"GA503IH", "7458-D6CHF3-4c6b83cb3efc11713fddd9c41cfd127c.zip"},
                {"GA503IM", "7741-F8GHPK-63e17aca55a11e838b1079eb0c6bea16.zip"},
                {"GA503QC", "7459-308BEA-bcf2604511112df5fa810faa9cdece89.zip"},
                {"GA503QE", "7464-4T2J1D-3920997d2f44d3b40dffd6ba9f028075.zip"},
                {"GA503QM", "7739-BSD39S-f9858fd4a68ff8ef60b8abf2cda92dd7.zip"},
                {"GA503QN", "7740-QT19P2-33054dbe06ae3baa435a44ce529eddb5.zip"},
                {"GA503QR", "7738-QVCIRY-4e612ff997f11448c77068e39ee0681e.zip"},
                {"GA503QS", "7737-B5L4LD-4400a4ddc94eebefb0678fb281b63fa0.zip"},
                {"GA503RJ", "10630-MSC4Q2-f16f1ef2847069e50aad62083836b220.zip"},
                {"GA503RK", "10631-VXWRAN-b2a1aa499bf33f1f9bd3d80e31dd9d69.zip"},
                {"GA503RM", "12054-38JGOX-35e7b1afb150daea1eab90ae97f0da7b.zip"},
                {"GA503RR", "10632-IOY3C0-bf16d1028f572ede9dd8e1a2fd632ae5.zip"},
                {"GA503RS", "11745-689QTC-6c441a7161a34b871918fce5997c4e2e.zip"},
                {"GA503RW", "12055-SG6VTH-91cc5782da63cf3dcc16804a47db25a2.zip"},
                {"GA503RX", "12056-MR9J0D-b7dad63f751d2e53aeee479524986bdd.zip"},
                {"GA605WI", "20014-K4K912-2a2e5a66fac3cc97fb13394a189bd75e.zip"},
                {"GA605WU", "20015-HJM11B-a724c1fe216b73c0b3b24475047f4615.zip"},
                {"GA605WV", "20016-BWVQPK-01624c1cdd5a3c05252bad472fab1240.zip"},
                {"GL_Series", "2167-P7ELNB-44d357ee720a0c48c2eb37eee785316c.zip"},
                {"GL503GE", "57-YI7HPS-9ed36ba45ff6398f3648a44ced4e5e61.zip"},
                {"GL504GM", "58-JOZ3S5-998677afd41375cb8fd60ace8d11a788.zip"},
                {"GL504GS", "59-KS4SJK-b1c9807c7d7dc847fa895516b3b9a8cb.zip"},
                {"GL504GV", "167-OX51EF-b8b5c713bff267d315e0255370956e75.zip"},
                {"GL504GW", "168-NMGNB6-1f6d79b87d077c235c57d4505ce802e7.zip"},
                {"GL703GE", "60-M0UOZ3-1474ef8209bf010de4c6e6ae94ce351d.zip"},
                {"GL703GM", "61-WJGLV3-b8005e077aa4825799459412849e346c.zip"},
                {"GL703GS", "62-HU12J1-a88023229e3a2dbc5fc1aca1b07e4d76.zip"},
                {"GL704GV", "106-3IHGVF-5d15db39c04a44e3503d3536d4f0c132.zip"},
                {"GL704GW", "107-NZ7VZL-cae8497c2eb8479f4808d2b61e7c8e70.zip"},
                {"GM_Series", "2169-K05CUW-841a5508c96649de28d613e32dfb7fcf.zip"},
                {"GM501GM", "63-3CL0UZ-eee6728dd2517d6e3af581f1caef0114.zip"},
                {"GM501GS", "64-GH66XC-5e69efa00bbe486efd897414ed329545.zip"},
                {"GU_Series", "2170-FYLCER-f45e5d5e38121b7bfe275b780e739a8e.zip"},
                {"GU501GM", "65-LSRZXK-658dc6e1c89a7787201ec7c74eebf2d5.zip"},
                {"GU502DU", "4004-T40IY1-74f962c9d9d27544c964bdb347074472.zip"},
                {"GU603HE", "11674-VGXXML-41035c5f9dbf4e0b64a74eb3f89d95e4.zip"},
                {"GU603HM", "11676-GO5KVF-581b4f49e0e12d9d6654ab2c1db9ab11.zip"},
                {"GU603HR", "11675-AZPXHF-48a9979ce428acfcc57c4e295f8a9840.zip"},
                {"GU603VI", "14579-CUHZFU-ea9e6cf216e1359b0f3e300e137720f7.zip"},
                {"GU603VJ", "14580-18G1FP-4456270d80c37a0597b3bfc559222f64.zip"},
                {"GU603VQ", "14581-8YY8TX-e7aa10a20a41245500f40841b2298a42.zip"},
                {"GU603VU", "14582-9I3GQS-564dd1ba9ee37dc03bef022bd2e29049.zip"},
                {"GU603VV", "14583-XH4I69-879293a1a305dc952afb15b481722e09.zip"},
                {"GU603ZE", "9817-3EENL9-3187794df7ec8ddef2fe04d0787eff63.zip"},
                {"GU603ZEB", "9818-KOP3C1-11ab717fddedafb9066b362d8da5af85.zip"},
                {"GU603ZI", "14431-H4XZCU-1c907d4e22bbd5000a6c81cfc2e1dae4.zip"},
                {"GU603ZJ", "14432-Y5HC6R-b50edb7a5ad9469b89c35e5cd9fc114f.zip"},
                {"GU603ZM", "9819-718DH0-30bf094253e5178aba765436bb8b150f.zip"},
                {"GU603ZQ", "14434-3KPJU7-211e518352b0660babc4816fa5dd80bd.zip"},
                {"GU603ZR", "9820-LIQ8FP-6a60aee97d7028e7ea63bd2ab6c2b099.zip"},
                {"GU603ZU", "14435-2ZW8FL-65ab99a80fe08d8d088d8fdc998076f4.zip"},
                {"GU603ZV", "14433-FEY59U-cd0508e779a6b3874a61668f39ff78e0.zip"},
                {"GU603ZW", "9822-3R2PGP-f2d24c6931e733a5e0e41dc8560b80cc.zip"},
                {"GU603ZX", "9821-AQYG62-f42f167ec7b4f4fe003f05b1c1c61d58.zip"},
                {"GU604VI", "14284-R38BM3-e2591bfa2582ce68b2c8aba63beac5e3.zip"},
                {"GU604VY", "14282-78N7V4-25e76896744c53317fa41a80788a2241.zip"},
                {"GU604VZ", "14283-U4JX5C-f31dff75d52f48ceca0102fd1bc76e31.zip"},
                {"GU605MI", "19271-93QRMU-eab4115ee09fb9bbd86facec08a822a1.zip"},
                {"GU605MU", "19272-RDZDEJ-4380e52eab6a3742613c2f694a19da1e.zip"},
                {"GU605MV", "19274-1T9PKS-d05273f430d255ad1779cf6a7eb57db3.zip"},
                {"GU605MY", "19273-F4A493-2bc9083d99e7827b4580311d34f8998b.zip"},
                {"GU605MZ", "19275-52DG5X-1072d6f4fdc5b9cbb304da7146f05a79.zip"},
                {"GV301QC", "5128-RN42GR-9a6049e7adabd1ff2aeed24293fe03a8.zip"},
                {"GV301QCZ", "6778-152PHS-7a9ad124aef1059471542dfc8912ed7b.zip"},
                {"GV301QE", "5125-PD15GR-9a7f72cbf5bd97d283464d8e407f0231.zip"},
                {"GV301QEZ", "6780-N3Y08B-222db095847d99663a575be36fbcf410.zip"},
                {"GV301QH", "5077-0BEYRT-ff8e30857ab4af017381f5703b39abed.zip"},
                {"GV301QHZ", "6779-9XZE32-329974b938dff4baf3097e3d745839eb.zip"},
                {"GV301RA", "10272-1B7YAA-45e3697377ff2e7dd68c57f5919eecd2.zip"},
                {"GV301RC", "10273-UJ0Q76-53bdfe00929ccf3f594f813ba235438b.zip"},
                {"GV301RE", "10274-1J3P7N-42dabc435e4daa40d4be2fa482624321.zip"},
                {"GV302NA", "14663-N4C4U4-1654950fbc1fad0e37a016c4a1e8a934.zip"},
                {"GV302NF", "14668-GMKBGC-1bd7957eb1a688f8eb0e6fb85395b839.zip"},
                {"GV302NI", "14664-ZQXAM8-1dec6b07c9589698c8cccdbc3a3211a6.zip"},
                {"GV302NJ", "14667-OFKJGT-60db594b4af90c481212ee31ffa96d38.zip"},
                {"GV302NU", "14666-6M0N3K-3d08325f6c4b3fcacf53a2f863a0e6c5.zip"},
                {"GV302NV", "14665-DWLIIQ-9b3b8b0aaca3a071f82cbb30fbbe2fd1.zip"},
                {"GV302XA", "14934-AU5P0J-1873c4e95dadcf72b1fad550108a0eb5.zip"},
                {"GV302XF", "14935-D5PHI6-aa9715b2328c499c8cd72b4958ba6641.zip"},
                {"GV302XI", "14936-CHYX8S-f5fe72833a34f1f002dae6789f2760fe.zip"},
                {"GV302XJ", "14937-LMH57E-651161fb27c3ef9904e15fc42e5d8352.zip"},
                {"GV302XU", "14938-4DXJJV-82feb9f0156bb914ccbde2de6d59ad14.zip"},
                {"GV302XV", "14939-KLW56G-32ffda0b7ee35bbe4ca5789da7210cc9.zip"},
                {"GV601RA", "11078-109U4J-33e9d7342819b8a7a534632df659e509.zip"},
                {"GV601RE", "11079-U5MUWC-8c22738f13a798376733fead5f091a4b.zip"},
                {"GV601RM", "11082-XN5PLH-5c405808680f6bfc36c5069bcd5dc366.zip"},
                {"GV601RW", "11081-FK9JFY-b82e25b8f9bcd2ad1d3ae23c7cb327d0.zip"},
                {"GV601RX", "11080-45B7E2-b64fdbf32877dc996b4efe274ff51f41.zip"},
                {"GV601VI", "14446-JS3QXL-72327a76c47c2ffdeaad392197a4b2ce.zip"},
                {"GV601VJ", "14448-TIX8CU-ed84b2ee1d92d2f38a891ed1c684eddf.zip"},
                {"GV601VQ", "14447-7C8UIX-13cc4d4632406ca5976358a4080f26af.zip"},
                {"GV601VU", "14450-0SP39K-8071216d3c679d013fffe57eca9f790c.zip"},
                {"GV601VV", "14449-QZS5FH-6a7771cbbf9bcc641a5418f250ef3b43.zip"},
                {"GX_Series", "2171-LHV7R6-bf1d918fd26714f10c3f3de990e30a1b.zip"},
                {"GX501GI", "66-U9BQN2-9a12abd42e07169ec6ebf4d4a6d2c148.zip"},
                {"GX502LWS", "3552-YRITSK-6f08012703e7718be25477f20ccd4d7e.zip"},
                {"GX502LXS", "3553-3ACO9T-20757861512ff920da316c949249b62d.zip"},
                {"GX531GM", "67-ER25S2-71ec74e4e8d14fc9c6cc8608d1616e5f.zip"},
                {"GX531GS", "68-V9PHXL-3cabb33363337795287458e3b10114f8.zip"},
                {"GX531GV", "108-VCV90K-00cec46bd49df326109c060367eaa57c.zip"},
                {"GX531GW", "109-0GH5PV-ce1ff55527d5da0b547df776af887276.zip"},
                {"GX531GX", "110-A0TZ36-4cf1c1cdeee6e0e27567e317444c62cb.zip"},
                {"GX550LWS", "3671-DEEX56-d93255f509e16f740c71e8c358e8ff36.zip"},
                {"GX550LXS", "3672-O3V2FT-6572c1aa661e3f406ce6e840075d81ab.zip"},
                {"GX551QM", "8108-47QAG6-7d57f542a91fca797f6bad910af5b864.zip"},
                {"GX551QR", "8109-ADSI6K-87224022e84f6a6c0ed2820cc4642a66.zip"},
                {"GX551QS", "8110-NLPALF-6ec9938f67229be071cdb8c436303734.zip"},
                {"GX650PI", "14591-ODJA1G-23aaf98034a279ae87f93f67db9b3b95.zip"},
                {"GX650PU", "14592-A6IJIM-e847943987f3cf4f1d0278fe1d5ee984.zip"},
                {"GX650PV", "14595-XKP10A-e14bb5df924255dc965bb975e1d64434.zip"},
                {"GX650PY", "14593-KC9ZMM-6e519dbcdd0139ed1d8e7649e407d8a8.zip"},
                {"GX650PZ", "14594-AETGOJ-4ba96caa5ae0ee68d8b457e0fbc03a17.zip"},
                {"GX650RM", "11320-E8SQ6M-5673cb197e000111c0d406b1156d44af.zip"},
                {"GX650RS", "11321-UEO888-cbff96301261591d9130980fcc5950e5.zip"},
                {"GX650RW", "11322-YIN6KH-2a804a1dd4da59662e6746f83d636452.zip"},
                {"GX650RX", "11323-64AK0P-9929933ff3fda3dcabfef096d7242a7c.zip"},
                {"GX701GV", "166-EI8VY0-1568b74c5bbf22297720b548ce6bcefa.zip"},
                {"GX701GW", "165-C6KON3-9b95db9f024e457420793b4915749fbd.zip"},
                {"GX701GX", "164-I4CRXM-b5e8ddc68c884eda5cf4676dd2683624.zip"},
                {"GX701LV", "3309-DPFMBZ-ffda0b00117a5f1c69a091158b631bbe.zip"},
                {"GX701LWS", "3308-PQVG48-ad364af358f946382f840c969c73d49b.zip"},
                {"GX701LXS", "3307-AY5DMD-681ac8295b6f98fda4c66b891f19be4d.zip"},
                {"GX703HM", "7962-KBDQY2-ff82594ee47f5c1058bc2115b6a74841.zip"},
                {"GX703HMD", "7963-A3TM3L-5f39a856e3f694e9db1ed5a5410baa39.zip"},
                {"GX703HR", "7967-5LQ4FV-7b6af6e1dc3a6c0786bec0ec084ee5c2.zip"},
                {"GX703HRD", "7964-TFYJ6L-4bec23647da2f9bc8403d060635dbdda.zip"},
                {"GX703HS", "7965-3HSRRO-c1869c30564e2db44a97c1e8953093b9.zip"},
                {"GX703HSD", "7966-9CCDGL-96f0c0f9e1e50ee66894e7b168e59cc3.zip"},
                {"GZ_Series", "2172-Z8OHBD-393c5060aaa27883e2fcbebc7e53997e.zip"},
                {"GZ301VF", "13604-50UADT-4df87ac6eab6ac261647875d727db9d4.zip"},
                {"GZ301VFC", "13787-WB73LI-b148b7cf3c90bc90fca4938bfc6fbbe5.zip"},
                {"GZ301VI", "13601-DPC6YI-17ac748ec814ec3152ad973f3a0cff4b.zip"},
                {"GZ301VIC", "13790-Z6V8RW-7a4f735f65c545158c7ba715694aa3c7.zip"},
                {"GZ301VJ", "13600-UNQHZ7-e7d0cbf757eeed28dba9295b517ef835.zip"},
                {"GZ301VJC", "13788-QVWJWQ-a13027f81094f94eea1d86152fe69ba9.zip"},
                {"GZ301VQ", "13789-K6I7SO-4a8594363610c383e39940ff135c0d7e.zip"},
                {"GZ301VQC", "13791-DBRKCU-a10ec3e290c5dc93bbb45f52c714a9b8.zip"},
                {"GZ301VU", "13602-6JQ2BK-4353d6c0b83589477ff4570b49258217.zip"},
                {"GZ301VUC", "13792-009F1L-4ee6b0014eca72c7d0217219ebe9e365.zip"},
                {"GZ301VV", "13603-OOLT27-8788c068fdad2a64da9925a5411b30af.zip"},
                {"GZ301VVC", "13793-8DIIWY-72aca4ea0f1db6c991b3e24da5a7907c.zip"},
                {"GZ301ZA", "10139-YXT5A7-521746c1b4991657abc37999a318219e.zip"},
                {"GZ301ZC", "10140-QA59M0-be0cf751aba85c98832f4a0f16456330.zip"},
                {"GZ301ZE", "10141-P1OXLB-318b5c3601e0d5c55d3b4307eba08ab2.zip"},
                {"GZ301ZH", "10142-ELMX6M-f9c50110ca0a763bf4b6d1e9dd9e3afa.zip"},
                {"NR2301L", "14736-3DM4T5-41c1b0b5c2d726da7c66e0c39ea08017.zip"},
                {"RC71L", "17126-IIDPFS-718c077a118724bb0045b35e30d5ac4e.zip"},
                {"RC71X", "15182-KWVC62-c754d9ea39f9160df7e21e4538ce60df.zip"},
                {"RC72LA", "19770-DOSUSI-85f700513af330af6e20fcfdabaeb87f.zip"},
            };

            if (profiles.ContainsKey(model))
            {
                return baseUrl + profiles[model];
            }
            else
            {
                return null;
            }
        }

        public static bool ProfileExists()
        {
            (string bios, string model) = AppConfig.GetBiosAndModel();
            return (GetProfileUrl(model) is not null);
        }

        public static async Task InstallProfile()
        {
            ProcessHelper.RunAsAdmin();

            (string bios, string model) = AppConfig.GetBiosAndModel();
            string? profileUrl = GetProfileUrl(model);

            if (profileUrl == null)
            {
                Logger.WriteLine($"No ICC Profile found for {model}");
                return;
            }

            await DownloadAndExtractZip(profileUrl, VisualControl.GetGameVisualPath());
        }

        static async Task DownloadAndExtractZip(string zipUrl, string extractPath)
        {
            using (HttpClient client = new HttpClient())
            {
                try
                {
                    Logger.WriteLine($"Getting: {zipUrl}");
                    byte[] zipData = await client.GetByteArrayAsync(zipUrl);

                    Directory.CreateDirectory(extractPath);

                    string tempZipPath = Path.Combine(extractPath, "temp.zip");
                    await File.WriteAllBytesAsync(tempZipPath, zipData);

                    ZipFile.ExtractToDirectory(tempZipPath, extractPath, true);

                    File.Delete(tempZipPath);
                }
                catch (Exception ex)
                {
                    Logger.WriteLine($"Error: {ex.Message}");
                }
            }
        }

    }
}
