//
//     Generated by class-dump 3.5 (64 bit).
//
//     class-dump is Copyright (C) 1997-1998, 2000-2001, 2004-2013 by Steve Nygard.
//

@import Foundation;
@import IOBluetooth;

struct IOBluetoothHCIEventNotificationMessage;
typedef struct IOBluetoothHCIEventNotificationMessage * IOBluetoothHCIEventNotificationMessageRef;

NS_ASSUME_NONNULL_BEGIN

@protocol IOBluetoothHostControllerDelegate

@optional

- (void)BluetoothHCIEventNotificationMessage:(IOBluetoothHostController*)controller
                       inNotificationMessage:(IOBluetoothHCIEventNotificationMessageRef)message;

@end

@interface IOBluetoothHostController (PrivateAPI)

+ (void)initialize;
+ (id)getPropertyObjectFromIOServiceNamed:(const char *)arg1 forKey:(id)arg2;
+ (id)defaultController;
+ (id)controllers;
+ (void)enableNotifications;
@property id delegate; // @synthesize delegate=_delegate;
- (void)BluetoothHostControllerSetupCompleted;
- (void)sendInquiryResultToDelegate:(struct IOBluetoothHCIEventNotificationMessage *)arg1;
- (void)processRawEventData:(const void *)arg1 dataSize:(unsigned long long)arg2;
- (void)asyncHCIEventNotificationWithRef:(struct OpaqueIOBluetoothNotificationRef *)arg1 subClass:(unsigned int)arg2 data:(const void *)arg3 dataSize:(unsigned long long)arg4;
- (void)stopHCIEventListener;
- (id)getDeviceForHCIRequestID:(unsigned int)arg1 removeIfFound:(BOOL)arg2;
- (void)addDeviceToOutstandingRequests:(id)arg1 forHCIRequestID:(unsigned int)arg2;
- (int)BluetoothHCILETrackSensor:(struct BluetoothDeviceAddress *)arg1 addressType:(unsigned char)arg2 timeoutValue:(unsigned char)arg3 outLEextOpcode:(char *)arg4;
- (int)BluetoothHCILEExtendedDuplicateFilter:(char *)arg1 outAction:(unsigned char)arg2;
- (int)BluetoothHCILEAdvPacketPacketFilterServiceUUIDClear:(struct BluetoothDeviceAddress *)arg1 addressType:(unsigned char)arg2 outLEextOpcode:(char *)arg3 outAction:(char *)arg4;
- (int)BluetoothHCILEAdvPacketPacketFilterServiceUUIDWrite:(struct BluetoothDeviceAddress *)arg1 addressType:(unsigned char)arg2 logicalType:(unsigned char)arg3 outLEextOpcode:(char *)arg4 outAction:(char *)arg5 UUID:(char *)arg6;
- (int)BluetoothHCIBroadcomTagLEA:(unsigned long long)arg1 connectionHandle:(unsigned short)arg2 input:(BOOL)arg3 channel:(BOOL)arg4;
- (int)BluetoothHCILEScanRSSIThresholdWrite:(unsigned char)arg1 rssiThresdhold:(BOOL)arg2 outAction:(char *)arg3;
- (int)BluetoothHCILEScanRSSIThresholdRead:(char *)arg1 outMode:(char *)arg2 outRSSIThreshold:(char *)arg3;
- (int)BluetoothHCILEAdvPacketContentFilterFeatureSectionClear:(struct BluetoothDeviceAddress *)arg1 addressType:(unsigned char)arg2 outLEextOpcode:(char *)arg3 outAction:(char *)arg4;
- (int)BluetoothHCILEAdvPacketContentFilterFeatureSectionRead:(struct BluetoothDeviceAddress *)arg1 addressType:(unsigned char)arg2 outLEextOpcode:(char *)arg3 outAction:(char *)arg4 outFeatureSelection:(unsigned int *)arg5 outLogicalType:(char *)arg6;
- (int)BluetoothHCILEAdvPacketContentFilterFeatureSectionWrite:(struct BluetoothDeviceAddress *)arg1 addressType:(unsigned char)arg2 featureSelection:(unsigned int)arg3 logicalType:(unsigned char)arg4 outLEextOpcode:(char *)arg5 outAction:(char *)arg6;
- (int)BluetoothHCILEBroadcomReadIRKList:(unsigned char)arg1 outLEextOpcode:(char *)arg2 outIRKListIndex:(char *)arg3 outIRK:(char *)arg4 outAddressType:(char *)arg5 outAddress:(struct BluetoothDeviceAddress *)arg6 outResolvedPrivateAddress:(struct BluetoothDeviceAddress *)arg7;
- (int)BluetoothHCILEBroadcomClearIRKList:(char *)arg1 outIRKListAvailableSpace:(char *)arg2;
- (int)BluetoothHCILEBroadcomRemoveIRKFromList:(unsigned char)arg1 address:(struct BluetoothDeviceAddress *)arg2 outLEextOpcode:(char *)arg3 outIRKListAvailableSpace:(char *)arg4;
- (int)BluetoothHCILEBroadcomAddIRKToList:(char *)arg1 addressType:(unsigned char)arg2 address:(struct BluetoothDeviceAddress *)arg3 outLEextOpcode:(char *)arg4 outIRKListAvailableSpace:(char *)arg5;
- (int)BluetoothHCILEBroadcomEnableCustomerSpecificFeatures:(unsigned int)arg1 outLEextOpcode:(char *)arg2;
- (int)readVerboseConfigVersionInfo:(char *)arg1 outTargetID:(char *)arg2 outBaseline:(unsigned short *)arg3 outBuild:(unsigned short *)arg4;
- (int)superPeekPoke:(unsigned char)arg1 address:(unsigned int)arg2 outValue:(unsigned int *)arg3;
- (int)removeHIDEmulationDevice:(struct BluetoothDeviceAddress)arg1;
- (int)readHIDEmulationDevices;
- (int)addHIDEmulationDevice:(struct BluetoothDeviceAddress)arg1 classOfDevice:(unsigned int)arg2 linkKey:(struct BluetoothKey)arg3;
- (int)triStateEnabled:(BOOL)arg1;
- (int)startTransmitTest:(struct BluetoothDeviceAddress *)arg1 hoppingMode:(unsigned char)arg2 frequency:(unsigned char)arg3 modulationType:(unsigned char)arg4 logicalChannel:(unsigned char)arg5 packetType:(unsigned char)arg6 packetLength:(unsigned short)arg7 transmitPower:(unsigned char)arg8 transmitPowerdBm:(unsigned char)arg9 transmitPowerTableIndex:(unsigned char)arg10;
- (int)startReceiveTest:(struct BluetoothDeviceAddress *)arg1 reportPeriod:(unsigned short)arg2 frequency:(unsigned char)arg3 modulationType:(unsigned char)arg4 logicalChannel:(unsigned char)arg5 packetType:(unsigned char)arg6 packetLength:(unsigned short)arg7;
- (int)setTransmitPowerForDevice:(id)arg1 toLevel:(unsigned char)arg2;
- (int)readRawRSSIForDevice:(id)arg1;
- (int)BluetoothHCIBroadcomSetProximityTrigger:(unsigned char)arg1 inEnableAwayTrigger:(unsigned char)arg2;
- (int)BluetoothHCIBroadcomSetProximityTable:(const struct BluetoothDeviceAddress *)arg1 inPowerSteps:(unsigned char)arg2 inAwayTriggerValues:(struct BluetoothBroadcomRSSITriggerValue *)arg3 inPresentTriggerValues:(struct BluetoothBroadcomRSSITriggerValue *)arg4;
- (int)BluetoothHCIBroadcomReadRetransmissionStatus:(unsigned char)arg1 inConnectionHandle:(unsigned short)arg2 inNotificationEnable:(unsigned char)arg3 inNotificationThreshold:(unsigned char)arg4 outConnectionHandle:(unsigned short *)arg5 outRetransmissionCounter:(unsigned int *)arg6 outRetransmissionPercentage:(char *)arg7;
- (int)BluetoothHCIBroadcomIncreaseDecreasePowerLevel:(const struct BluetoothDeviceAddress *)arg1 increase:(unsigned char)arg2;
- (int)BluetoothHCIBroadcomTurnOFFDynamicPowerControl:(unsigned char)arg1 inDeviceAddress:(const struct BluetoothDeviceAddress *)arg2;
- (int)BluetoothHCIBroadcomChangeLNAGainCoexsECI:(unsigned char)arg1;
- (int)BluetoothHCIBroadcomSetUSBAutoResume:(unsigned short)arg1;
- (int)BluetoothHCIBroadcomIgnoreUSBReset:(char *)arg1;
- (int)BluetoothHCIBroadcomGetEDRACLConnectionStats;
- (int)BluetoothHCIBroadcomResetBasicRateACLConnectionStats;
- (int)BluetoothHCIBroadcomGetBasicRateACLConnectionStats;
- (int)BluetoothHCIBroadcomBFCIsConnectionTBFCSuspended:(unsigned short)arg1 outBFCConnectionInfo:(struct BluetoothBroadcomBFCConnectionTBFCSuspendedInfo *)arg2;
- (int)BluetoothHCIBroadcomReadLocalFirmwareInfo:(unsigned char)arg1 outLocalFirmwareInfo:(struct BluetoothBroadcomLocalFirmwareInfo *)arg2;
- (int)BluetoothHCIBroadcomSetEventMask:(const struct BluetoothBroadcomSetEventMask *)arg1;
- (int)BluetoothHCIBroadcomBFCCreateConnection:(const struct BluetoothDeviceAddress *)arg1 inPacketType:(unsigned short)arg2 outConnectionCompleteResults:(struct BluetoothHCIEventConnectionCompleteResults *)arg3;
- (int)BluetoothHCIBroadcomBFCReadScanEnable:(char *)arg1;
- (int)BluetoothHCIBroadcomBFCWriteScanEnable:(unsigned char)arg1;
- (int)BluetoothHCIBroadcomBFCReadRemoteBPCSFeatures:(unsigned short)arg1 outBPCSFeatures:(struct BluetoothBroadcomBFCRemoteBPCSFeatures *)arg2;
- (int)BluetoothHCIBroadcomSetTransmitPower:(unsigned short)arg1 inPower:(BOOL)arg2;
- (int)BluetoothHCIBroadcomBFCSetParams:(struct BluetoothBroadcomBFCParams *)arg1;
- (int)BluetoothHCIBroadcomBFCReadParams:(struct BluetoothBroadcomBFCParams *)arg1;
- (int)BluetoothHCIBroadcomBFCResume:(unsigned short)arg1 inDeviceAddress:(const struct BluetoothDeviceAddress *)arg2 inBFCResume:(struct BluetoothBroadcomBFCReconnectData *)arg3;
- (int)BluetoothHCIBroadcomBFCSuspend:(unsigned short)arg1;
- (int)BluetoothHCIBroadcomReadRawRSSI:(unsigned short)arg1 outRSSI:(char *)arg2;
- (int)BluetoothHCIAtherosReadRawRSSI:(const struct BluetoothDeviceAddress *)arg1 outRSSI:(char *)arg2;
- (int)BluetoothHCICSRReadRawRSSI:(unsigned short)arg1 outRSSI:(char *)arg2;
- (BOOL)isLEASupported;
- (BOOL)pairedDeviceSupportTBFCPage;
- (BOOL)tbfcPageSupported;
- (BOOL)tbfcSupported;
- (BOOL)concurrentCreateConnectionSupported;
- (struct BluetoothHCISupportedFeatures)supportedFeatures;
- (id)cachedDeviceAddressString;
- (id)cachedDeviceAddress;
- (unsigned char)cachedHCIVersion;
- (BOOL)lowEnergySupported;
- (int)setPowerState:(int)arg1;
@property(readonly) int powerState;
- (BOOL)powerChangeSupported;
- (int)BluetoothHCILETestEnd:(unsigned short *)arg1;
- (int)BluetoothHCILETransmitterTest:(unsigned char)arg1 lengthOfTestData:(unsigned char)arg2 packetPayload:(unsigned char)arg3;
- (int)BluetoothHCILEReceiverTest:(unsigned char)arg1;
- (int)BluetoothHCILEReadSupportedStates:(unsigned long long *)arg1;
- (int)BluetoothHCILELongTermKeyRequestNegativeReply:(unsigned short)arg1;
- (int)BluetoothHCILELongTermKeyRequestReply:(unsigned short)arg1 longTermKey:(char *)arg2;
- (int)BluetoothHCILEStartEncryption:(unsigned short)arg1 randomNumber:(unsigned long long)arg2 encryptedDiversifier:(unsigned short)arg3 longTermKey:(char *)arg4;
- (int)BluetoothHCILERand:(unsigned long long *)arg1;
- (int)BluetoothHCILEEncrypt:(char *)arg1 plaintextData:(char *)arg2 encryptedData:(char *)arg3;
- (int)BluetoothHCILEReadRemoteUsedFeatures:(unsigned short)arg1;
- (int)BluetoothHCILEReadChannelMap:(unsigned short)arg1 channelMap:(unsigned long long *)arg2;
- (int)BluetoothHCILESetHostChannelClassification:(unsigned long long)arg1;
- (int)BluetoothHCILEConnectionUpdate:(unsigned short)arg1 connectionIntervalMin:(unsigned short)arg2 connectionIntervalMax:(unsigned short)arg3 connectionLatency:(unsigned short)arg4 supervisionTimeout:(unsigned short)arg5 minimumCELength:(unsigned short)arg6 maximumCELength:(unsigned short)arg7;
- (int)BluetoothHCILERemoveDeviceFromWhiteList:(unsigned char)arg1 address:(const struct BluetoothDeviceAddress *)arg2;
- (int)BluetoothHCILEAddDeviceToWhiteList:(unsigned char)arg1 address:(const struct BluetoothDeviceAddress *)arg2;
- (int)BluetoothHCILEClearWhiteList;
- (int)BluetoothHCILEReadWhiteListSize:(char *)arg1;
- (int)BluetoothHCILECreateConnectionCancel;
- (int)BluetoothHCILECreateConnection:(unsigned short)arg1 LEScanWindow:(unsigned short)arg2 initiatorFilterPolicy:(unsigned char)arg3 peerAddressType:(unsigned char)arg4 peerAddress:(struct BluetoothDeviceAddress *)arg5 ownAddressType:(unsigned char)arg6 connectionIntervalMin:(unsigned short)arg7 connectionIntervalMax:(unsigned short)arg8 connectionLatency:(unsigned short)arg9 supervisionTimeout:(unsigned short)arg10 minimumCELength:(unsigned short)arg11 maximumCELength:(unsigned short)arg12;
- (int)BluetoothHCILESetScanEnable:(unsigned char)arg1 filterDuplicates:(unsigned char)arg2;
- (int)BluetoothHCILESetScanParameters:(unsigned char)arg1 LEScanInterval:(unsigned short)arg2 LEScanWindow:(unsigned short)arg3 ownAddressType:(unsigned char)arg4 scanningFilterPolicy:(unsigned char)arg5;
- (int)BluetoothHCILESetAdvertiseEnable:(unsigned char)arg1;
- (int)BluetoothHCILESetScanResponseData:(unsigned char)arg1 scanResponseData:(char *)arg2;
- (int)BluetoothHCILESetAdvertisingData:(unsigned char)arg1 advertsingData:(char *)arg2;
- (int)BluetoothHCILEReadAdvertisingChannelTxPower:(char *)arg1;
- (int)BluetoothHCILESetAdvertisingParameters:(unsigned short)arg1 advertisingIntervalMax:(unsigned short)arg2 advertisingType:(unsigned char)arg3 ownAddressType:(unsigned char)arg4 directAddressType:(unsigned char)arg5 directAddress:(struct BluetoothDeviceAddress *)arg6 advertisingChannelMap:(unsigned char)arg7 advertisingFilterPolicy:(unsigned char)arg8;
- (int)BluetoothHCILESetRandomAddress:(struct BluetoothDeviceAddress *)arg1;
- (int)BluetoothHCILEReadLocalSupportedFeatures:(unsigned long long *)arg1;
- (int)BluetoothHCILEReadBufferSize:(unsigned short *)arg1 totalNumberLEDataPackets:(char *)arg2;
- (int)BluetoothHCILESetEventMask:(unsigned long long)arg1;
- (void)BluetoothHCIEventNotification:(const struct IOBluetoothHCIEventNotificationMessage *)arg1;
- (int)BluetoothHCIWriteSimplePairingDebugMode:(unsigned char)arg1;
- (int)BluetoothHCIEnableDeviceUnderTestMode;
- (int)BluetoothHCIWriteLoopbackMode:(unsigned char)arg1;
- (int)BluetoothHCIReadLoopbackMode:(char *)arg1;
- (int)BluetoothHCIReadClock:(unsigned short)arg1 inWhichClock:(unsigned char)arg2 outReadClockInfo:(struct BluetoothReadClockInfo *)arg3;
- (int)BluetoothHCIReadAFHChannelMap:(unsigned short)arg1 outAFHMode:(char *)arg2 outAFHChannelMap:(unsigned char [10])arg3;
- (int)BluetoothHCIReadRSSI:(unsigned short)arg1 outRSSI:(char *)arg2;
- (int)BluetoothHCIReadLinkQuality:(unsigned short)arg1 outLinkQuality:(char *)arg2;
- (int)BluetoothHCIResetFailedContactCounter:(unsigned short)arg1;
- (int)BluetoothHCIReadFailedContactCounter:(unsigned short)arg1 outFailedContactCounter:(unsigned short *)arg2;
- (int)BluetoothHCIReadDeviceAddress:(struct BluetoothDeviceAddress *)arg1;
- (int)BluetoothHCIReadBufferSize:(unsigned short *)arg1 outHCSynchronousDataPacketLength:(char *)arg2 outHCTotalNumACLDataPackets:(unsigned short *)arg3 outHCTotalNumSynchronousDataPackets:(unsigned short *)arg4;
- (int)BluetoothHCIReadLocalExtendedFeatures:(unsigned char)arg1 outMaximumPageNumber:(char *)arg2 outExtendedLMPFeatures:(struct BluetoothHCISupportedFeatures *)arg3;
- (int)BluetoothHCIReadLocalSupportedFeatures:(struct BluetoothHCISupportedFeatures *)arg1;
- (int)BluetoothHCIReadLocalSupportedCommands:(struct BluetoothHCISupportedCommands *)arg1;
- (int)BluetoothHCIReadLocalVersionInformation:(char *)arg1 outHCIRevision:(unsigned short *)arg2 outLMPVersion:(char *)arg3 outManufacturerName:(unsigned short *)arg4 outLMPSubversion:(unsigned short *)arg5;
- (int)BluetoothHCIWriteLEHostSupported:(unsigned char)arg1 simultaneousLEHost:(unsigned char)arg2;
- (int)BluetoothHCIReadLEHostSupported:(char *)arg1 simultaneousLEHost:(char *)arg2;
- (int)BluetoothHCIEnhancedFlush:(unsigned short)arg1 inPacketType:(unsigned char)arg2 outConnectionHandle:(unsigned short *)arg3;
- (int)BluetoothHCIWriteDefaultErroneousDataReporting:(unsigned char)arg1;
- (int)BluetoothHCIReadDefaultErroneousDataReporting:(char *)arg1;
- (int)BluetoothHCISendKeypressNotification:(const struct BluetoothDeviceAddress *)arg1 inNotificationType:(unsigned char)arg2;
- (int)BluetoothHCIWriteInquiryTransmitPowerLevel:(BOOL)arg1;
- (int)BluetoothHCIReadInquiryResponseTransmitPowerLevel:(char *)arg1;
- (int)BluetoothHCIReadLocalOOBData:(struct BluetoothHCISimplePairingOOBData *)arg1 outR:(struct BluetoothHCISimplePairingOOBData *)arg2;
- (int)BluetoothHCIWriteSimplePairingMode:(unsigned char)arg1;
- (int)BluetoothHCIReadSimplePairingMode:(char *)arg1;
- (int)BluetoothHCIRefreshEncryptionKey:(unsigned short)arg1 outRefreshEncryptionKeyResults:(struct BluetoothHCIEventEncryptionKeyRefreshCompleteResults *)arg2;
- (int)BluetoothHCIWriteExtendedInquiryResponse:(unsigned char)arg1 inExtendedInquiryResponse:(const struct BluetoothHCIExtendedInquiryResponse *)arg2;
- (int)BluetoothHCIReadExtendedInquiryResponse:(char *)arg1 outExtendedInquiryResponse:(struct BluetoothHCIExtendedInquiryResponse *)arg2;
- (int)BluetoothHCIWriteAFHChannelAssessmentMode:(unsigned char)arg1;
- (int)BluetoothHCIReadAFHChannelAssessmentMode:(char *)arg1;
- (int)BluetoothHCIWritePageScanType:(unsigned char)arg1;
- (int)BluetoothHCIReadPageScanType:(char *)arg1;
- (int)BluetoothHCIWriteInquiryMode:(unsigned char)arg1;
- (int)BluetoothHCIReadInquiryMode:(char *)arg1;
- (int)BluetoothHCIWriteInquiryScanType:(unsigned char)arg1;
- (int)BluetoothHCIReadInquiryScanType:(char *)arg1;
- (int)BluetoothHCISetAFHHostChannelClassification:(const struct BluetoothAFHHostChannelClassification *)arg1;
- (int)BluetoothHCIWriteCurrentIACLAP:(const struct BluetoothHCICurrentInquiryAccessCodes *)arg1;
- (int)BluetoothHCIReadCurrentIACLAP:(struct BluetoothHCICurrentInquiryAccessCodes *)arg1;
- (int)BluetoothHCIReadNumberOfSupportedIAC:(char *)arg1;
- (int)BluetoothHCIWriteLinkSupervisionTimeout:(unsigned short)arg1 inLinkSupervisionTimeout:(unsigned short)arg2;
- (int)BluetoothHCIReadLinkSupervisionTimeout:(unsigned short)arg1 outLinkSupervisionTimeout:(unsigned short *)arg2;
- (int)BluetoothHCIHostNumberOfCompletedPackets:(unsigned char)arg1 inHandle:(const unsigned short *)arg2 inHostNumOfCompletedPackets:(const unsigned short *)arg3;
- (int)BluetoothHCIHostBufferSize:(unsigned short)arg1 inHostSynchronousDataPacketLength:(unsigned char)arg2 inHostTotalNumACLDataPackets:(unsigned short)arg3 inHostTotalNumSynchronousDataPackets:(unsigned short)arg4;
- (int)BluetoothHCISetControllerToHostFlowControl:(unsigned char)arg1;
- (int)BluetoothHCIWriteSynchronousFlowControlEnable:(unsigned char)arg1;
- (int)BluetoothHCIReadSynchronousFlowControlEnable:(char *)arg1;
- (int)BluetoothHCIReadTransmitPowerLevel:(unsigned short)arg1 inType:(unsigned char)arg2 outTransmitPowerLevel:(char *)arg3;
- (int)BluetoothHCIWriteHoldModeActivity:(unsigned char)arg1;
- (int)BluetoothHCIReadHoldModeActivity:(char *)arg1;
- (int)BluetoothHCIWriteNumBroadcastRetransmissions:(unsigned char)arg1;
- (int)BluetoothHCIReadNumBroadcastRetransmissions:(char *)arg1;
- (int)BluetoothHCIWriteAutomaticFlushTimeout:(unsigned short)arg1 inFlushTimeout:(unsigned short)arg2;
- (int)BluetoothHCIReadAutomaticFlushTimeout:(unsigned short)arg1 outFlushTimeout:(unsigned short *)arg2;
- (int)BluetoothHCIWriteVoiceSetting:(unsigned short)arg1;
- (int)BluetoothHCIReadVoiceSetting:(unsigned short *)arg1;
- (int)BluetoothHCIWriteClassOfDevice:(unsigned int)arg1;
- (int)BluetoothHCIReadClassOfDevice:(unsigned int *)arg1;
- (int)BluetoothHCIWriteAuthenticationEnable:(unsigned char)arg1;
- (int)BluetoothHCIReadAuthenticationEnable:(char *)arg1;
- (int)BluetoothHCIWriteInquiryScanActivity:(unsigned short)arg1 inInquiryScanWindow:(unsigned short)arg2;
- (int)BluetoothHCIReadInquiryScanActivity:(unsigned short *)arg1 outInquiryScanWindow:(unsigned short *)arg2;
- (int)BluetoothHCIWritePageScanActivity:(unsigned short)arg1 inPageScanWindow:(unsigned short)arg2;
- (int)BluetoothHCIReadPageScanActivity:(unsigned short *)arg1 outPageScanWindow:(unsigned short *)arg2;
- (int)BluetoothHCIWriteScanEnable:(unsigned char)arg1;
- (int)BluetoothHCIReadScanEnable:(char *)arg1;
- (int)BluetoothHCIWritePageTimeout:(unsigned short)arg1;
- (int)BluetoothHCIReadPageTimeout:(unsigned short *)arg1;
- (int)BluetoothHCIWriteConnectionAcceptTimeout:(unsigned short)arg1;
- (int)BluetoothHCIReadConnectionAcceptTimeout:(unsigned short *)arg1;
- (int)BluetoothHCIReadLocalName:(unsigned char [256])arg1;
- (int)BluetoothHCIWriteLocalName:(unsigned char [256])arg1;
- (int)BluetoothHCIDeleteStoredLinkKey:(const struct BluetoothDeviceAddress *)arg1 inDeleteAllFlag:(unsigned char)arg2 outNumKeysDeleted:(unsigned short *)arg3;
- (int)BluetoothHCIWriteStoredLinkKey:(unsigned int)arg1 inDeviceAddress:(const struct BluetoothDeviceAddress *)arg2 inLinkKey:(const struct BluetoothKey *)arg3 outNumKeysWritten:(char *)arg4;
- (int)BluetoothHCIReadStoredLinkKey:(const struct BluetoothDeviceAddress *)arg1 inReadAllFlag:(unsigned char)arg2 outStoredLinkKeysInfo:(struct BluetoothHCIStoredLinkKeysInfo *)arg3;
- (int)BluetoothHCICreateNewUnitKey;
- (int)BluetoothHCIWritePINType:(unsigned char)arg1;
- (int)BluetoothHCIReadPINType:(char *)arg1;
- (int)BluetoothHCIFlush:(unsigned short)arg1;
- (int)BluetoothHCISetEventFilter:(unsigned char)arg1 inFilterConditionType:(unsigned char)arg2 inCondition:(struct BluetoothEventFilterCondition *)arg3;
- (int)BluetoothHCIReset;
- (int)BluetoothHCISetEventMask:(const struct BluetoothSetEventMask *)arg1;
- (int)BluetoothHCISniffSubrating:(unsigned short)arg1 inMaximumLatency:(unsigned short)arg2 inMinimumRemoteTimeout:(unsigned short)arg3 inMinimumLocalTimeout:(unsigned short)arg4 outConnectionHandle:(unsigned short *)arg5;
- (int)BluetoothHCIFlowSpecification:(struct BluetoothHCIEventFlowSpecificationData *)arg1 outFlowSpecificationCompleteResults:(struct BluetoothHCIEventFlowSpecificationData *)arg2;
- (int)BluetoothHCIWriteDefaultLinkPolicySettings:(unsigned short)arg1;
- (int)BluetoothHCIReadDefaultLinkPolicySettings:(unsigned short *)arg1;
- (int)BluetoothHCIWriteLinkPolicySettings:(unsigned short)arg1 inLinkPolicySettings:(unsigned short)arg2;
- (int)BluetoothHCIReadLinkPolicySettings:(unsigned short)arg1 outLinkPolicySettings:(unsigned short *)arg2;
- (int)BluetoothHCISwitchRole:(const struct BluetoothDeviceAddress *)arg1 inRole:(unsigned char)arg2 outRoleChangeResults:(struct BluetoothHCIEventRoleChangeResults *)arg3;
- (int)BluetoothHCIRoleDiscovery:(unsigned short)arg1 outCurrentRole:(char *)arg2;
- (int)BluetoothHCIQoSSetup:(unsigned short)arg1 inFlags:(unsigned char)arg2 inServiceType:(unsigned char)arg3 inTokenRate:(unsigned int)arg4 inPeakBandwidth:(unsigned int)arg5 inLatency:(unsigned int)arg6 inDelayVariation:(unsigned int)arg7 outQoSSetupCompleteResults:(struct BluetoothHCIEventQoSSetupCompleteResults *)arg8;
- (int)BluetoothHCIExitParkState:(unsigned short)arg1 outModeChangeResults:(struct BluetoothHCIEventModeChangeResults *)arg2;
- (int)BluetoothHCIParkState:(unsigned short)arg1 inBeaconMaxInterval:(unsigned short)arg2 inBeaconMinInterval:(unsigned short)arg3 outModeChangeResults:(struct BluetoothHCIEventModeChangeResults *)arg4;
- (int)BluetoothHCIExitSniffMode:(unsigned short)arg1 outModeChangeResults:(struct BluetoothHCIEventModeChangeResults *)arg2;
- (int)BluetoothHCISniffMode:(unsigned short)arg1 inSniffMaxInterval:(unsigned short)arg2 inSniffMinInterval:(unsigned short)arg3 inSniffAttempt:(unsigned short)arg4 inSniffTimeout:(unsigned short)arg5 outModeChangeResults:(struct BluetoothHCIEventModeChangeResults *)arg6;
- (int)BluetoothHCIHoldMode:(unsigned short)arg1 inHoldModeMaxInterval:(unsigned short)arg2 inHoldModeMinInterval:(unsigned short)arg3 outModeChangeResults:(struct BluetoothHCIEventModeChangeResults *)arg4;
- (int)BluetoothHCIIOCapabilityRequestNegativeReply:(const struct BluetoothDeviceAddress *)arg1 inReason:(unsigned char)arg2;
- (int)BluetoothHCIRemoteOOBDataRequestNegativeReply:(const struct BluetoothDeviceAddress *)arg1;
- (int)BluetoothHCIRemoteOOBDataRequestReply:(const struct BluetoothDeviceAddress *)arg1 inC:(const struct BluetoothHCISimplePairingOOBData *)arg2 inR:(const struct BluetoothHCISimplePairingOOBData *)arg3;
- (int)BluetoothHCIUserPasskeyRequestNegativeReply:(const struct BluetoothDeviceAddress *)arg1;
- (int)BluetoothHCIUserPasskeyRequestReply:(const struct BluetoothDeviceAddress *)arg1 inNumericValue:(unsigned int)arg2;
- (int)BluetoothHCIUserConfirmationRequestNegativeReply:(const struct BluetoothDeviceAddress *)arg1;
- (int)BluetoothHCIUserConfirmationRequestReply:(const struct BluetoothDeviceAddress *)arg1;
- (int)BluetoothHCIIOCapabilityRequestReply:(const struct BluetoothDeviceAddress *)arg1 inIOCapability:(unsigned char)arg2 inOOBDataPresent:(unsigned char)arg3 inAuthenticationRequirements:(unsigned char)arg4;
- (int)BluetoothHCIRejectSynchronousConnectionRequest:(const struct BluetoothDeviceAddress *)arg1 inReason:(unsigned char)arg2 outSynchronousConnectionCompleteResults:(struct BluetoothHCIEventSynchronousConnectionCompleteResults *)arg3;
- (int)BluetoothHCIAcceptSynchronousConnectionRequest:(const struct BluetoothDeviceAddress *)arg1 inTransmitBandwidth:(unsigned int)arg2 inReceiveBandwidth:(unsigned int)arg3 inMaxLatency:(unsigned short)arg4 inContentFormat:(unsigned short)arg5 inRetransmissionEffort:(unsigned char)arg6 inPacketType:(unsigned short)arg7 outSynchronousConnectionCompleteResults:(struct BluetoothHCIEventSynchronousConnectionCompleteResults *)arg8;
- (int)BluetoothHCISetupSynchronousConnection:(unsigned short)arg1 inTransmitBandwidth:(unsigned int)arg2 inReceiveBandwidth:(unsigned int)arg3 inMaxLatency:(unsigned short)arg4 inVoiceSetting:(unsigned short)arg5 inRetransmissionEffort:(unsigned char)arg6 inPacketType:(unsigned short)arg7 outSynchronousConnectionCompleteResults:(struct BluetoothHCIEventSynchronousConnectionCompleteResults *)arg8;
- (int)BluetoothHCIReadLMPHandle:(unsigned short)arg1 outReadLMPHandleResults:(struct BluetoothHCIReadLMPHandleResults *)arg2;
- (int)BluetoothHCIReadClockOffset:(unsigned short)arg1 outReadClockOffsetCompleteResults:(unsigned short *)arg2;
- (int)BluetoothHCIReadRemoteVersionInformation:(unsigned short)arg1 outReadRemoteVersionInformationCompleteResults:(struct BluetoothHCIEventReadRemoteVersionInfoResults *)arg2;
- (int)BluetoothHCIReadRemoteExtendedFeatures:(unsigned short)arg1 inPageNumber:(unsigned char)arg2 outReadRemoteExtendedFeaturesCompleteResults:(struct BluetoothHCIEventReadRemoteExtendedFeaturesResults *)arg3;
- (int)BluetoothHCIReadRemoteSupportedFeatures:(unsigned short)arg1 outReadRemoteSupportedFeaturesCompleteResults:(struct BluetoothHCIEventReadRemoteSupportedFeaturesResults *)arg2;
- (int)BluetoothHCIRemoteNameRequestCancel:(const struct BluetoothDeviceAddress *)arg1;
- (int)BluetoothHCIRemoteNameRequest:(const struct BluetoothDeviceAddress *)arg1 inPageScanRepetitionMode:(unsigned char)arg2 inReserved:(unsigned char)arg3 inClockOffset:(unsigned short)arg4 outRemoteNameRequestCompleteResults:(struct BluetoothHCIEventRemoteNameRequestResults *)arg5;
- (int)BluetoothHCIMasterLinkKey:(unsigned char)arg1 outMasterLinkKeyCompleteResults:(struct BluetoothHCIEventMasterLinkKeyCompleteResults *)arg2;
- (int)BluetoothHCIChangeConnectionLinkKey:(unsigned short)arg1 outChangeConnectionLinkKeyCompleteResults:(struct BluetoothHCIEventChangeConnectionLinkKeyCompleteResults *)arg2;
- (int)BluetoothHCISetConnectionEncryption:(unsigned short)arg1 inEncryptionEnable:(unsigned char)arg2 outEncryptionChangeResults:(struct BluetoothHCIEventEncryptionChangeResults *)arg3;
- (int)BluetoothHCIAuthenticationRequested:(unsigned short)arg1 outAuthenticationCompleteResults:(struct BluetoothHCIEventAuthenticationCompleteResults *)arg2;
- (int)BluetoothHCIChangeConnectionPacketType:(unsigned short)arg1 inPacketType:(unsigned short)arg2 outConnectionPacketTypeChangedResults:(struct BluetoothHCIEventConnectionPacketTypeResults *)arg3;
- (int)BluetoothHCIPINCodeRequestNegativeReply:(const struct BluetoothDeviceAddress *)arg1;
- (int)BluetoothHCIPINCodeRequestReply:(const struct BluetoothDeviceAddress *)arg1 inPINCodeLength:(unsigned long long)arg2 inPINCode:(const struct BluetoothPINCode *)arg3;
- (int)BluetoothHCILinkKeyRequestNegativeReply:(const struct BluetoothDeviceAddress *)arg1;
- (int)BluetoothHCILinkKeyRequestReply:(const struct BluetoothDeviceAddress *)arg1 inLinkKey:(const struct BluetoothKey *)arg2;
- (int)BluetoothHCIRejectConnectionRequest:(const struct BluetoothDeviceAddress *)arg1 inReason:(unsigned char)arg2 outConnectionCompleteResults:(struct BluetoothHCIEventConnectionCompleteResults *)arg3;
- (int)BluetoothHCIAcceptConnectionRequest:(const struct BluetoothDeviceAddress *)arg1 inRole:(unsigned char)arg2 outConnectionCompleteResults:(struct BluetoothHCIEventConnectionCompleteResults *)arg3;
- (int)BluetoothHCICreateConnectionCancel:(const struct BluetoothDeviceAddress *)arg1;
- (int)BluetoothHCIDisconnect:(unsigned short)arg1 inReason:(unsigned char)arg2 outDisconnectionCompleteResults:(struct BluetoothHCIEventDisconnectionCompleteResults *)arg3;
- (int)BluetoothHCICreateConnection:(const struct BluetoothDeviceAddress *)arg1 inPacketType:(unsigned short)arg2 inPageScanRepetitionMode:(unsigned char)arg3 inReserved:(unsigned char)arg4 inClockOffset:(unsigned short)arg5 inAllowRoleSwitch:(unsigned char)arg6 outConnectionCompleteResults:(struct BluetoothHCIEventConnectionCompleteResults *)arg7;
- (int)BluetoothHCIExitPeriodicInquiryMode;
- (int)BluetoothHCIPeriodicInquiryMode:(unsigned char)arg1 inMinPeriodLength:(unsigned char)arg2 inLAP:(unsigned int)arg3 inInquiryLength:(unsigned char)arg4 inNumResponses:(unsigned char)arg5 outInquiryResults:(struct BluetoothHCIInquiryResults *)arg6;
- (int)BluetoothHCIInquiryCancel;
- (int)BluetoothHCIInquiry:(unsigned int)arg1 inInquiryLength:(unsigned char)arg2 inNumResponses:(unsigned char)arg3 outInquiryResults:(struct BluetoothHCIInquiryResults *)arg4;
- (void)releaseRequest:(unsigned int)arg1;
- (unsigned int)requestWithTimeout:(int)arg1 isSynchronous:(BOOL)arg2 device:(id)arg3;
- (int)setClassOfDevice:(unsigned int)arg1 forTimeInterval:(double)arg2;
- (unsigned int)classOfDevice;
- (unsigned short)USBVendorID;
- (unsigned short)USBProductID;
- (int)configState;
- (unsigned int)featureFlags;
- (int)getAddress:(struct BluetoothDeviceAddress *)arg1;
- (id)nameAsString;
- (id)addressAsString;
- (int)setProperty:(id)arg1 forKey:(id)arg2;
- (int)enableRemoteWake:(BOOL)arg1;
- (int)softwareVersion:(struct NumVersion *)arg1 firmwareVersion:(struct BluetoothHCIVersionInfo *)arg2;
- (int)getControllerManufacturerName;
- (int)getDiagnosticInfo;
- (BOOL)isReady;
- (void)finalize;
- (void)dealloc;
- (id)init;

@end

#pragma mark - Private IOBluetooth Functions

struct IOBluetoothHCIDispatchParams {
    uint64_t args[7];
    uint64_t sizes[7];
    uint64_t index;
};

struct BluetoothHCIUserClientNotificationDataInfo {
    unsigned long long _field1;
    unsigned long long _field2;
    struct BluetoothHCIRequestCallbackInfo _field3;
    unsigned int parameterSize;
    unsigned int _field5;
    unsigned short opcode;
    unsigned char _field7;
    unsigned char _field8;
    unsigned char _field9;
    unsigned char _field10;
    unsigned char _field11;
    unsigned char _field12;
};

struct IOBluetoothHCIEventNotificationMessage {
    struct BluetoothHCIUserClientNotificationDataInfo dataInfo;
    void *eventParameterBytes;
};

int BluetoothHCIRequestCreate(uint32_t *request, int timeout, void* arg3, size_t arg4);

int BluetoothHCIRequestDelete(uint32_t request);

int BluetoothHCISendRawCommand(uint32_t request,
                               void *commandData,
                               size_t commmandSize);

int BluetoothHCISendRawACLData(void *commandData,
                               size_t commandSize,
                               uint32_t handle,
                               uint32_t request);

int BluetoothHCIDispatchUserClientRoutine(struct IOBluetoothHCIDispatchParams *arguments,
                                          unsigned char *returnValue,
                                          size_t *returnValueSize);

#pragma mark - Helper Methods

/**
 Data object for notification message.
 */
static inline NSData * IOBluetoothHCIEventParameterData(IOBluetoothHCIEventNotificationMessageRef message)
//__attribute__((swift_name("getter:IOBluetoothHCIEventNotificationMessageRef.eventParameterData(self:)")))
{
    size_t size = message->dataInfo.parameterSize;
    NSData *data = [NSData dataWithBytes:&message->eventParameterBytes length:size];
    return data;
}

NS_ASSUME_NONNULL_END
