Publications
------------

* **Master Thesis** (07/2018)
  
  *InternalBlue* was initially developed and documented in the
[Masterthesis](internalblue_thesis_dennis_mantz.pdf) by Dennis Mantz.
Afterwards the development was continued by SEEMOO. It was awarded with the [CAST Förderpreis](https://www.cysec.tu-darmstadt.de/cysec/start_news_details_136448.en.jsp).

* **MRMCD Talk** (09/2018)

  The basic framework for Nexus 5 / BCM4339 was presented at the MRMCD Conference
2018 in Darmstadt. The talk was also [recorded](https://media.ccc.de/v/2018-154-internalblue-a-deep-dive-into-bluetooth-controller-firmware) and includes an overview of the framework as well as
two demo usages at the end (Following a **Secure Simple Pairing procedure in
Wireshark** and implementing a **proof of concept for CVE-2018-5383**).


* **35C3 Talk** (12/2018)

  More extensions were [presented](https://media.ccc.de/v/35c3-9498-dissecting_broadcom_bluetooth) at 35C3 2018 in Leipzig. New features include 
creating connections to non-discoverable devices. Moreover, we gave a **demo of
CVE-2018-19860**, which can crash Bluetooth on several Broadcom chips. This talk
was also recorded and gives a more high level overview.

* **TROOPERS Talk** (03/2019)

* **WiSec Paper** (05/2019)

  Our WiSec paper [Inside Job: Diagnosing Bluetooth Lower Layers Using Off-the-Shelf Devices](https://arxiv.org/abs/1905.00634) on reversing the
  Broadcom Bluetooth diagnostics protocol was accepted, demonstrated and got the replicability label.

* **MobiSys Paper** (06/2019)

  Our MobiSys paper [InternalBlue - Bluetooth Binary Patching and Experimentation Framework
](https://arxiv.org/abs/1905.00631) on the complete *InternalBlue* ecosystem got accepted.


* **REcon Talk** (06/2019)

  We gave a talk at REcon, [Reversing and Exploiting Broadcom Bluetooth](https://cfp.recon.cx/reconmtl2019/talk/EQTRGU/).
  It provides a first intuition on how to do binary patching in C with Nexmon to change Bluetooth functionality.

* **MRMCD Talk** (09/2019)

  Our talk [Playing with Bluetooth](https://media.ccc.de/v/2019-185-playing-with-bluetooth) focuses on new device support
  within *InternalBlue* and the Patchram state of various devices.

* **Bachelor Thesis** (12/2019)
  
  *InternalBlue* was ported to macOS as part of Davide Toldo's [Bachelor Thesis](macos_bluetooth_stack_thesis_davide_toldo.pdf), in which he explores how the Bluetooth stack works in macOS and how it is possible to send and receive HCI and ACL packets through unofficial APIs.
  
* **36C3 Talk** (12/2019)
  
  The rather generic talk [All wireless communication stacks are equally broken](https://media.ccc.de/v/36c3-10531-all_wireless_communication_stacks_are_equally_broken)
  points out a couple of new research directions and new Bluetooth projects coming up.

* **EWSN Paper & Demo** (02/2020)

  We did some work on improving blacklisting performance of BLE data connections. Currently in a separate *blacklisting* branch.

* **CiderSecCon Talk** (03/2020)

  TROOPERS was canceled, but we did a stream of a talk that was recorded on [YouTube](https://www.youtube.com/watch?v=Nx2ZDLaJ1-0&t=4920).

* **Easterhegg Talks** (04/2020)

  Easterhegg was canceled, but we streamed via DiVOC. The recordings for the talks about
  [Random Number Generators](https://media.ccc.de/v/DiVOC-6-finding_eastereggs_in_broadcom_s_bluetooth_random_number_generator)
  and [Frankenstein](https://media.ccc.de/v/DiVOC-7-no_poc_no_fix_a_sad_story_about_bluetooth_security) are online.

* **WiSec Paper** (07/2020)

  We looked into Apple's Bluetooth ecosystem, especially MagicPairing, which secures AirPods.
  For more details, read our paper [MagicPairing: Apple's Take on Securing Bluetooth Peripherals](https://arxiv.org/abs/2005.07255).
  
* **Binary Analysis Research Workshop Paper** (01/2021)

  We built a tool that can diff raw firmware and benchmarked it on Broadcom/Cypress chips.
  The source code is on the [Polypyus](https://github.com/seemoo-lab/polypyus) GitHub page.
  There's also a [video](https://www.youtube.com/watch?v=kQS0pGs7bsM) and a [paper](https://www.ndss-symposium.org/wp-content/uploads/bar2021_23004_paper.pdf).
  
* **WiSec Paper** (07/2021)

  New paper demonstrating that all major operating systems don't show warnings if Bluetooth
  keys break due to MitM attacks, presented at WiSec. Also see [PoC](keychange.md) scripts.
  
* **WiSec Tutorial** (07/2021)

  [Tutorial](https://sites.nyuad.nyu.edu/wisec21/tutorials/) revisiting the current state of InternalBlue. Basically an update from the REcon 2019
  talk, but with more recent explanations, bypassing anti-patching, and explanations on all
  the operating system specific hooks.
