Firmware Versions
=================

A list of known firmware versions can be found below.
However, we only have firmware information on a subset of these.
Results are based on real-world testing, this list is very incomplete.
If you know more versions, input is appreciated :)



Vendor | Version | SubVersion | Firmware    | Devices | Firmware Build Date
-------| ------- | ---------- | ----------- | ------- | ----------
0x000f |    0x04 |     0x4217 | BCM4329B1   | iPhone 4, Nexus One, iPod touch (A1367)
0x000f |    0x04 |     0x21d0 | BCM2046A2   | iMac 27" late 2009 | 2007
0x000f |    0x04 |     0x422a | BCM4331     | MacBook Pro early 2011
0x000f |    0x04 |     0x4203 |             | HP ProBook 6550b and 6450b
0x000f |    0x05 |     0x4203 | BCM2034B    | Thinkpad T420
0x000f |    0x05 |     0x610d |             | iPad A1395
0x000f |    0x05 |     0x240c | BCM20733    | Magic Keyboard
0x000f |    0x06 |     0x220e | BCM20702A1  | Asus USB Bluetooth dongle, HP Elitebook 820 G2 | ~Feb 2010
0x000f |    0x06 |     0x229b | BCM20702A3  | MacBook Pro 13" mid 2012 (A1278)
0x000f |    0x06 |     0x4103 | BCM4330B1   | iPhone 4s
0x000f |    0x06 |     0x410d |             | BlackBerry Q5
0x000f |    0x06 |     0x4196 | BCM20702B0  | MacBook Pro mid 2014, iMac (Retina 5k, 27", ultimo 2014), MacBook Air 2017 13"
0x000f |    0x06 |     0x6109 |             | Samsung Galaxy Note 10.1 2014 WiFi (SM-P600) 
0x000f |    0x07 |     0x220f | BCM20736S   | Equiva Radiator Thermostat CC-RT-BLE-EQ
0x000f |    0x07 |     0x2203 | BCM43342    | iPhone 5s
0x000f |    0x07 |     0x2209 | BCM43430A1  | Raspberry Pi 3 and Zero W | Jun 2 2014
0x000f |    0x07 |     0x230f | BCM4356A2   | Xperia Z5
0x000f |    0x07 |     0x410d | BCM4334     | iPhone 5 (A1429)
0x000f |    0x07 |     0x4606 | BCM4324     | iPad Air (A1474)
0x000f |    0x07 |     0x6109 | BCM4335C0 (BCM4339) | Nexus 5, Xperia Z3 Compact, Samsung Galaxy Note 3, LG G4 (LG-h815) | Dec 11 2012
0x0131 |    0x08 |     0x1200 |             | Philips Sonicare (Cypress SoC CY8C4247LQI-BL483, not sure if compatible)
0x000f |    0x08 |     0x21a1 |             | MacBook Pro Retina 13" early 2015 
0x000f |    0x08 |     0x21a6 | BCM20703A1  | MacBook Pro early 2015
0x000f |    0x08 |     0x21a7 | BCM20703A1  | MacBook Pro early 2015 (with security fix)
0x000f |    0x08 |     0x21a8 | BCM20703A1  | MacBook Pro early 2015 (with security fix, 10.14.6)
0x000f |    0x08 |     0x21a8 | BCM20703A1  | MacBook Pro early 2015 (with security fix, 10.15.4)
0x000f |    0x08 |     0x220b | CYW20706    | CYW920706 Evaluation Kit, same ROM as MacBook Pro 2016 | Oct 22 2015 
0x000f |    0x08 |     0x220b | BCM20707    | Fitbit Ionic 
0x000f |    0x08 |     0x2230 | BCM20703A2  | MacBook Pro 2016 (A1707) | Oct 22 2015
0x000f |    0x08 |     0x2246 | BCM20703A2  | MacBook Pro 2016 | Oct 22 2015
0x000f |    0x08 |     0x2247 | BCM20703A2  | MacBook Pro 2016 (with security fix) | Oct 22 2015
0x000f |    0x08 |     0x224b | BCM20703A2  | MacBook Pro 2016, 2017, iMac 2017 Retina 5k | Oct 22 2015
0x000f |    0x08 |     0x224c | BCM20703A2  | MacBook Pro 15" 2017 (A1707) | Oct 22 2015
0x000f |    0x08 |     0x240f | BCM4358A3   | Nexus 6P, Samsung Galaxy S6, Samsung Galaxy S6 edge | Oct 23 2014 
0x000f |    0x08 |     0x4109 | BCM4345B0   | iPhone 6 (Tempranillo) | Jul 15 2013
0x000f |    0x08 |     0x430a |             | iPad Pro 2016 (MLMW2FD/A)
0x000f |    0x08 |     0x6103 | BCM4355C0   | iPhone 7 A1778 (Elsa) | Sep 14 2015
0x000f |    0x08 |     0x6106 |             | Samsung Galaxy S7, Huawei P20
0x000f |    0x08 |     0x617e | BCM4350     | MacBook Pro 2017 (Retina 12", 13"), MacBook Pro (13", 2016) | May 28 2013
0x000f |    0x08 |     0x6119 | BCM4345C0   | Raspberry Pi 3+, Honor 8, Xperia X | Aug 19 2014
0x000f |    0x08 |     0x6206 | BCM4345C1   | iPhone SE (Hans), iPod Touch 7th Generation (MVJ72FD/A) | Jan 27 2015
0x000f |    0x09 |     0x102f | BCM4355     | MacBook Air 2019 13" Retina | Mar 7 2017
0x000f |    0x09 |     0x112e | BCM4364B0   | iMac Retina 4K 21.5"/27" 2019 macOS Mojave 10.14.6 | Aug 21 2015
0x000f |    0x09 |     0x112f | BCM4364B0   | MacBook Pro 2019 13" 4x Thunderbold | Aug 21 2015
0x000f |    0x09 |     0x103f | BCM4364     | iMac Pro 2017
0x000f |    0x09 |     0x2023 | BCM4377B3   | MacBook Pro 2019 13" 2x Thunderbold (Formosa) | Feb 28 2018
0x000f |    0x09 |     0x203f | BCM4364     | MacBook Pro (13", 2018)
0x000f |    0x09 |     0x2040 |             | Apple Watch Series 3
0x000f |    0x09 |     0x2043 | BCM4346B0   | MacBook Pro 2019 15"
0x0131 |    0x09 |     0x220c | CYW20819A1  | ULP BLE/BR/EDR Bluetooth 5 Wireless MCU Evaluation Kit CYW920819EVB-02 | May 22 2018
0x000f |    0x09 |     0x411a | BCM4347B0 (BCM4361B0) | Samsung Galaxy S8 | Jun 3 2016
0x0131 |    0x09 |     0x4208 | CYW20735B1  | BLE/BR Bluetooth 5.0 Evaluation Kit CYW920735Q60EVB-01 | Jan 18 2018
0x000f |    0x09 |     0x4208 | BCM4375B1   | Samsung Galaxy S10e, Samsung Galaxy S10, Samsung Galaxy S10+, Samsung Galaxy Note 10/10+, Samsung Galaxy S20  (local version is 0x1111) | April 13 2018
0x000f |    0x09 |     0x420e | BCM4347B1   | iPhone 8, XR, X | Oct 11 2016
0x0131 |    0x09 |     0x420e | CYW20739B1  | Bluetooth 5.0 BLE Evaluation Kit CYW920719Q40EVB-01 | Jan 17 2017
0x000f |    0x09 |     0x4307 | BCM4377B2   | iPhone XS (Aladdin), iPhone Xs Max (Genie), iPad Pro 11" 3E149FD/A, iPad Pro 11" 3E148FD/A, iPad Pro 12.9" 3rd gen 3D941FD/A, iPad mini 5th gen 3F559FD/A, iPad Air 3rd gen 3F561FD/A
0x000f |    0x09 |     0x4309 |             | Samsung Galaxy Note 9, Samsung Galaxy S9, S9+
0x0131 |    0x09 |     0x6119 | BCM4345C0   | Raspberry Pi 3+/4 --- *with Bluetooth 5 patches, same ROM as 3+* | Aug 19 2014
0x000f |    0x09 |     0x6214 | BCM4355C1   | iPad 6th gen 3D575FD/A, iPad 6th gen MRJN2FD/A, iPad 6th gen MR7J2FD/A A1893 (FigaroA)
0x000f |    0x0a |     0x4228 | BCM4378B1   | iPhone 11 (Hei), iPhone 11 Pro (Moana), iPhone 11 Pro Max (Tala) --- *announce BT 5.1 over the air but are BT 5* | Oct 25 2018
0x000f |    0x0b |     0x6308 | BCM4387C2   | iPhone 12 | Oct 29 2019




Matching of vendor and version number see list of [Bluetooth versions](https://www.bluetooth.com/specifications/assigned-numbers/link-manager) and [company identifiers](https://www.bluetooth.com/specifications/assigned-numbers/company-identifiers).

There are more popular devices with Broadcom chips, i.e. many Lenovos, Acers, Sonys, Toshibas, HPs, Azurewares, ... see [this list](https://github.com/winterheart/broadcom-bt-firmware/blob/master/DEVICES.md), but we did not see these in the wild yet and do not know their LMP subversion.  


Intentional Security Fix
------------------------

Broadcom started breaking *InternalBlue* support on purpose on recent chips to increase security.
On a Samsung Galaxy S10 with March 2020 patch level as well as on an iPhone 7 and 8 with iOS 13.4.1,
the `Write_RAM` HCI command is no longer available. It results in error code 12 if not used in 
download minidriver mode during driver initialization by the operating system. 


Known Issues
------------

There is a couple of issues causing trouble running *InternalBlue*, which are related to certain firmware versions.

* BCM4335C0
  * Diagnostic messages lack behind by one. If you send `diag c1` you will not get a response. Followed by `diag c2` you will get a response for `c1`, and so on. This issue is independent from the Android driver patch, i.e. a Nexus 6P works perfectly with the same LineageOS 14.1 patch that causes this issue on a Nexus 5. 
* BCM4358A3 (Nexus 6P + Samsung Galaxy S6), and iPhone 7 firmware:
  * `Launch_RAM` crashes the firmware if it received another HCI command within the next ~6 seconds. When patching and launching scripts, close the Bluetooth overview from the operating system to prevent scanning and hope that nothing else interacts with this. 
* CYW20735B1
  * `Launch_RAM` works in principle, but threading seems to be broken if the executed code generates other HCI events.
  A hook at `0xB0316` is a nice spot to implement a function that generates HCI events and can be called via the HCI command `0xfc19`.
  The general solution seems to be `self.internalblue.patchRom(0x3d32e, "\x70\x47\x70\x47")` respectively `patch -a 0x3d32e --asm bx lr`, which fixes that the baud rate is set to a wrong value during `Launch_RAM`.
  * Same issue exists for CYW20719, CYW20819
  
Firmware Version and Build Date
-------------------------------

Broadcom internally uses different firmware versions than chip names. For example, the *BCM4339* chip in the *Nexus 5* 
is internally called *BCM4335C0*. It is known to be a revision of the older *BCM4335* chip.

On newer chips, the build information is located in the beginning of the stack. To see it, simply enter

    hd 0x200400
   