---
name: Bug report
about: Create a report to help us improve PhASAR
title: ''
labels: ''
assignees: ''

---

<!-- Let's begin with a checklist:
Replace the empty checkboxes [ ] below with checked ones [x] accordingly. -->

  - [ ] I have searched open and closed issues for duplicates
  - [ ] I made sure that I am not using an old project version (DO: pull PhASAR, update git submodules, rebuild the project and check if the bug is still there)

----------------------------------------

### Bug description
Describe here the issue that you are experiencing.

### Steps to reproduce
  - using hyphens as bullet points
  - list the steps
  - that reproduce the bug
  - e.g. cli arguments and flags

**Actual result:** Describe here what happens after you run the steps above (i.e. the buggy behavior)

**Expected result:** Describe here what should happen after you run the steps above (i.e. what would be the correct behavior)

### Context (Environment)

<!-- Enter which commits you have checked out. -->

  - **phasar:** \[commit-id]
  - **googletest:** \[commit-id]
  - **json:** \[commit-id]
  - **json-schema-validator** \[commit-id]

<!-- Which operating system are you using? -->

**Operating System:**
  - [ ] Linux
  - [ ] Windows
  - [ ] macOS

<!-- Which build-* script are you using for the build? -->

**Build Type:**
  - [ ] cmake
  - [ ] bootstrap.sh
  - [ ] custom build

### Possible solution

We are happy to discuss possible solutions to this problem, especially if it originates from a design flaw.

### Example files

<!--
If possible, please attach an example file (e.g. source code) that triggers
the bug.
You can upload a file by clicking on the link below this input field
or you can drag and drop files below.

NOTE: If you want to upload a file with an unsupported file type
(e.g. a .cpp or .ll file), you have to attach ".txt" to the file name.
-->

**Files:**
