---

# Front Matter (YAML)
author: "jane.doe@kaishi.fr (Jane Doe)" ## L'auteur de la page. (max 64 caractères)
banner_alt: "Mur carrelé vert et noir" ## L'alternative texte de la bannière du site.
banner_height: "398" ## La hauteur de la bannière du site.
banner_width: "1440" ## La largeur de la bannière du site.
banner: "https://kura.pro/stock/images/banners/patrick-fore-850jTF12RSQ.webp" ## La bannière du site.
cdn: "https://kura.pro" ## Le CDN du site.
changefreq: "weekly" ## La fréquence de changement du site.
charset: "utf-8" ## Le jeu de caractères du site. (par défaut : utf-8)
cname: "kaishi.fr" ## La valeur CNAME du site. (Requise uniquement pour la page index.)
copyright: "Copyright © 2023-2025 Kaishi. Tous droits réservés." ## Le copyright du site.
date: "January 01, 2025"
description: "Tout ce dont vous avez besoin pour créer un site web époustouflant." ## La description du site. (max 160 caractères)
download: "" ## L'URL de téléchargement pour le produit.
format-detection: "telephone=no" ## La détection de format du site.
hreflang: "en" ## La langue hreflang du site. (par défaut : en-gb)
icon: "https://kura.pro/kaishi/images/logos/kaishi.svg" ## L'icône du site au format SVG.
id: "https://kaishi.fr" ## L'ID du site.
image_alt: "Logo de Kaishi, un modèle de démarrage pour sites statiques" ## Le texte alternatif de l'image du site.
image_height: "630" ## La hauteur de l'image du site.
image_width: "1200" ## La largeur de l'image du site.
image: "https://kura.pro/kaishi/images/banners/banner-kaishi.webp" ## L'image principale du site au format SVG.
keywords: "modèles de démarrage Kaishi, générateur de sites statiques Shokunin, générateur de sites statiques, modèles de démarrage, bootstrap, bootstrap css, bootstrap javascript, politique de sécurité de contenu, balises méta open graph, barre de navigation responsive, balises méta schema.org" ## Les mots-clés du site. (max 160 caractères)
language: "en-GB" ## La langue du site. (par défaut : en-GB)
layout: "post" ## La mise en page du site.
locale: "en_GB" ## La locale du site.
logo_alt: "Logo de Kaishi, un modèle de démarrage pour sites statiques" ## Le texte alternatif du logo du site.
logo_height: "33" ## La hauteur du logo du site.
logo_width: "100" ## La largeur du logo du site.
logo: "https://kura.pro/kaishi/images/logos/kaishi.svg" ## Le logo du site au format SVG.
name: "Kaishi" ## Le nom du site. (max 64 caractères)
permalink: "https://kaishi.fr/features" ## L'URL du site.
rating: "general" ## L'évaluation du site.
referrer: "no-referrer" ## Le référent du site.
revisit-after: "7 days" ## Le délai de revisite du site.
robots: "index, follow" ## Les robots du site.
short_name: "kaishi" ## Le nom court du site. (max 12 caractères)
subtitle: "Créez des sites incroyables avec un minimum d'effort grâce aux modèles de démarrage Kaishi" ## Le sous-titre de la page. (max 64 caractères)
tags: "modèles de démarrage Kaishi, générateur de sites statiques Shokunin, générateur de sites statiques, modèles de démarrage, bootstrap, bootstrap css, bootstrap javascript, politique de sécurité de contenu, balises méta open graph, barre de navigation responsive, balises méta schema.org" ## Les tags du site. (max 160 caractères)
theme-color: "214, 171, 133" ## La couleur du thème du site.
title: "Articles" ## Le titre de la page. (max 64 caractères)
url: "https://kaishi.fr" ## L'URL du site.
viewport: "width=device-width, initial-scale=1, shrink-to-fit=no" ## Le viewport du site.

# News - Les métadonnées SiteMap News (YAML)
news_genres: "Blog" ## Les genres du site. (PressRelease|Satire|Blog|OpEd|Opinion|UserGenerated)
news_keywords: "modèles de démarrage Kaishi, générateur de sites statiques Shokunin, générateur de sites statiques, modèles de démarrage, bootstrap, bootstrap css, bootstrap javascript, politique de sécurité de contenu, balises méta open graph, barre de navigation responsive, balises méta schema.org" ## Les mots-clés du site. (séparés par des virgules, max 10 mots-clés)
news_language: "en" ## La langue du site. (par défaut : en)
news_image_loc: "https://kura.pro/stock/images/banners/bernardo-lorena-ponte-cEp2Tow6XKk.webp" ## L'URL de l'image du site.
news_loc: "https://kaishi.fr" ## L'URL du site.
news_publication_date: "Wed, 01 Jan 2025 01:01:01 GMT" ## La date de publication du site.
news_publication_name: "Kaishi" ## Le nom de la publication de nouvelles du site.
news_title: "Articles" ## Le titre de la page. (max 64 caractères)

# RSS - Le flux RSS (YAML)
atom_link: https://kaishi.fr/rss.xml
category: "Technologie"
docs: https://validator.w3.org/feed/docs/rss2.html
generator: "Shokunin SSG (version 0.0.32)"
item_description: Flux RSS pour le site
item_guid: https://kaishi.fr/rss.xml
item_link: https://kaishi.fr/rss.xml
item_pub_date: "Wed, 01 Jan 2025 01:01:01 GMT"
item_title: "RSS"
last_build_date: "Wed, 01 Jan 2025 01:01:01 GMT"
managing_editor: jane.doe@kaishi.fr (Jane Doe)
pub_date: "Wed, 01 Jan 2025 01:01:01 GMT"
ttl: "60"
type: "site web"
webmaster: jane.doe@kaishi.fr

# Apple - Les métadonnées Apple (YAML)
apple_mobile_web_app_orientations: "portrait" ## Les orientations des applications mobiles Apple pour la page.
apple_touch_icon_sizes: "192x192" ## Les tailles des icônes tactiles Apple pour la page.
apple-mobile-web-app-capable: "yes" ## Indique si l'application mobile web Apple est compatible avec la page.
apple-mobile-web-app-status-bar-inset: "black" ## L'encart de la barre de statut Apple mobile web de la page.
apple-mobile-web-app-status-bar-style: "black-translucent" ## Le style de la barre de statut Apple mobile web de la page.
apple-mobile-web-app-title: "Kaishi" ## Le titre Apple mobile web de la page.
apple-touch-fullscreen: "yes" ## Indique si la page supporte le plein écran Apple tactile.

# MS Application - Les métadonnées MS Application (YAML)
msapplication-navbutton-color: "rgb(0,102,204)"

# Twitter Card - Les métadonnées Twitter Card (YAML)
twitter_card: "summary" ## Le type de carte Twitter.
twitter_creator: "janedoe" ## Le créateur de la carte Twitter.
twitter_description: "Tout ce dont vous avez besoin pour créer un site web époustouflant." ## La description de la carte Twitter.
twitter_image: "https://kura.pro/kaishi/images/logos/kaishi.svg" ## L'image de la carte Twitter.
twitter_image_alt: "Logo de Kaishi, un modèle de démarrage pour sites statiques" ## L'alternative texte de l'image de la carte Twitter.
twitter_site: "janedoe" ## Le site Twitter associé.
twitter_title: "Kaishi, un modèle de démarrage pour générateur de sites statiques Shokunin" ## Le titre de la carte Twitter.
twitter_url: "https://kaishi.fr" ## L'URL de la carte Twitter.

# Humans.txt - Les métadonnées Humans.txt (YAML)
author_website: "https://kura.pro" ## Le site web de l'auteur de la page.
author_twitter: "@wwdseb" ## Le compte Twitter de l'auteur de la page.
author_location: "Londres, Royaume-Uni" ## La localisation de l'auteur de la page.
thanks: "Merci pour votre lecture !" ## Les remerciements de la page.
site_last_updated: "2025-01-01" ## La dernière mise à jour du site.
site_standards: "HTML5, CSS3, RSS, Atom, JSON, XML, YAML, Markdown, TOML" ## Les standards du site.
site_components: "Kaishi, Kaishi Builder, Kaishi CLI, Kaishi Templates, Kaishi Themes" ## Les composants du site.
site_software: "Shokunin, Rust" ## Les logiciels utilisés par le site.

---

## Modèles de Démarrage

Tous les modèles de démarrage, qu'il s'agisse de pages ou de sites web, sont construits à partir de zéro en utilisant les mêmes principes et fonctionnalités. Cela signifie que vous pouvez facilement les combiner pour créer vos propres mises en page et contenus personnalisés.

### Pages

Commencez avec Shokunin en utilisant l'un de nos modèles de démarrage pour créer votre site web ou application web. Nos modèles sont conçus pour être flexibles et faciles à modifier.

#### Fonctionnalités des Modèles

- **Design Responsive** : Tous les modèles sont entièrement adaptatifs, garantissant une belle apparence sur tous les appareils.
- **Composants Modulaires** : Les modèles sont construits avec des composants modulaires, ce qui les rend faciles à personnaliser.
- **Esthétique Moderne** : Chaque modèle est conçu en suivant les dernières tendances du design.

#### Premiers Pas

Pour commencer, sélectionnez un modèle adapté aux besoins de votre projet. Personnalisez-le avec votre contenu, style et fonctionnalités.

1. **Choisissez un Modèle** : Parcourez notre collection et choisissez un point de départ.
2. **Personnalisez** : Modifiez la mise en page, ajoutez votre contenu et ajustez les styles.
3. **Lancez** : Déployez votre nouveau site web ou application web au monde entier.

### Sites Web

Créer un site web à partir de zéro peut être une tâche intimidante, mais nos modèles de démarrage rendent cela simple et direct.

![Nature éclatante][00]

### Pourquoi Utiliser Nos Modèles ?

- **Rapidité** : Accélérez votre développement grâce à des designs préconçus.
- **Qualité** : Des modèles de haute qualité, bien testés, garantissent une fiabilité accrue.
- **Support** : Notre équipe est là pour vous aider en cas de questions ou de problèmes.

### Personnalisation

Personnalisez les modèles pour répondre à vos besoins spécifiques. Les possibilités sont infinies !

#### Conseils pour la Personnalisation

- **Comprendre la Structure** : Familiarisez-vous avec la structure et les composants du modèle.
- **Expérimentez** : N'ayez pas peur d'expérimenter avec différentes mises en page et styles.
- **Retours** : Demandez des retours sur vos designs et améliorez-les en fonction des commentaires reçus.

## Conclusion

Avec notre gamme de modèles de démarrage, vous disposez d'une base solide pour créer quelque chose d'unique et adapté à vos besoins spécifiques. Plongez et commencez à créer !

[00]: https://kura.pro/stock/images/banners/johannes-plenio-6XUA5KQ9-1k.webp
