# Contributing to `Shokunin Static Site Generator (SSG)`

Welcome! We're thrilled that you're interested in contributing to the `Shokunin Static Site Generator (SSG)` library. Whether you're looking to evangelize, submit feedback, or contribute code, we appreciate your involvement in making `Shokunin Static Site Generator (SSG)` a better tool for everyone. Here's how you can get started.

## Evangelize

One of the simplest ways to help us out is by spreading the word about shokunin. We believe that a bigger, more involved community makes for a better framework, and that better frameworks make the world a better place. If you know people who might benefit from using shokunin, please let them know!

## How to Contribute

If you're interested in making a more direct contribution, there are several ways you can help us improve shokunin. Here are some guidelines for submitting feedback, bug reports, and code contributions.

### Feedback

Your feedback is incredibly valuable to us, and we're always looking for ways to make shokunin better. If you have ideas, suggestions, or questions about shokunin, we'd love to hear them. Here's how you can provide feedback:

- Click [here][2] to submit a new feedback.
- Use a descriptive title that clearly summarizes your feedback.
- Provide a detailed description of the issue or suggestion.
- Be patient while we review and respond to your feedback.

### Bug Reports

If you encounter a bug while using shokunin, please let us know so we can fix it. Here's how you can submit a bug report:

- Click [here][2] to submit a new issue.
- Use a descriptive title that clearly summarizes the bug.
- Provide a detailed description of the issue, including steps to reproduce it.
- Be patient while we review and respond to your bug report.

### Code Contributions

If you're interested in contributing code to shokunin, we're excited to have your help! Here's what you need to know:

#### Feature Requests

If you have an idea for a new feature or improvement, we'd love to hear it. Here's how you can contribute code for a new feature to shokunin:

- Fork the repo.
- Clone the shokunin[1] repo by running:
  `git clone https://github.com/sebastienrousseau/shokunin`
- Edit files in the `src/` folder. The `src/` folder contains the source code for shokunin.
- Submit a pull request, and we'll review and merge your changes if they fit with our vision for shokunin.

#### Submitting Code

If you've identified a bug or have a specific code improvement in mind, we welcome your pull requests. Here's how to submit your code changes:

- Fork the repo.
- Clone the shokunin repo by running:
  `git clone https://github.com/sebastienrousseau/shokunin`
- Edit files in the `src/` folder. The `src/` folder contains the source code for shokunin.
- Submit a pull request, and we'll review and merge your changes if they fit with our vision for shokunin.

We hope that this guide has been helpful in explaining how you can contribute to shokunin. Thank you for your interest and involvement in our project!

[1]: https://github.com/sebastienrousseau/shokunin
[2]: https://github.com/sebastienrousseau/shokunin/issues/new
