<?php
/**
 * SharingLinksApi
 * PHP version 7.4
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Account Operations - User
 *
 * The official SeaTable API Reference (OpenAPI 3.0).
 *
 * The version of the OpenAPI document: 5.0
 * Generated by: https://openapi-generator.tech
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SeaTable\Client\User;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use SeaTable\Client\ApiException;
use SeaTable\Client\Configuration;
use SeaTable\Client\HeaderSelector;
use SeaTable\Client\ObjectSerializer;

/**
 * SharingLinksApi Class Doc Comment
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class SharingLinksApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createBaseExternalLink' => [
            'multipart/form-data',
        ],
        'createInviteLink' => [
            'multipart/form-data',
        ],
        'createViewExternalLink' => [
            'multipart/form-data',
        ],
        'deleteExternalLink' => [
            'application/json',
        ],
        'deleteInviteLink' => [
            'application/json',
        ],
        'deleteViewExternalLink' => [
            'application/json',
        ],
        'listBaseExternalLinks' => [
            'application/json',
        ],
        'listViewExternalLinks' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createBaseExternalLink
     *
     * Create Base External Link
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $password password (optional)
     * @param  int $expire_days Add expiration period in days. Optional. (optional)
     * @param  string $token An optional custom token of the generated link. For example, it&#39;ll appear as \\\&quot;https&lt;span&gt;://cloud.seatable.io/dtable/view-external-links/custom/example/\\\&quot;. If not given, SeaTable will give a random token to the link. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBaseExternalLink'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function createBaseExternalLink($workspace_id, $base_name, $password = null, $expire_days = null, $token = null, string $contentType = self::contentTypes['createBaseExternalLink'][0])
    {
        list($response) = $this->createBaseExternalLinkWithHttpInfo($workspace_id, $base_name, $password, $expire_days, $token, $contentType);
        return $response;
    }

    /**
     * Operation createBaseExternalLinkWithHttpInfo
     *
     * Create Base External Link
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $password (optional)
     * @param  int $expire_days Add expiration period in days. Optional. (optional)
     * @param  string $token An optional custom token of the generated link. For example, it&#39;ll appear as \\\&quot;https&lt;span&gt;://cloud.seatable.io/dtable/view-external-links/custom/example/\\\&quot;. If not given, SeaTable will give a random token to the link. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBaseExternalLink'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBaseExternalLinkWithHttpInfo($workspace_id, $base_name, $password = null, $expire_days = null, $token = null, string $contentType = self::contentTypes['createBaseExternalLink'][0])
    {
        $request = $this->createBaseExternalLinkRequest($workspace_id, $base_name, $password, $expire_days, $token, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createBaseExternalLinkAsync
     *
     * Create Base External Link
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $password (optional)
     * @param  int $expire_days Add expiration period in days. Optional. (optional)
     * @param  string $token An optional custom token of the generated link. For example, it&#39;ll appear as \\\&quot;https&lt;span&gt;://cloud.seatable.io/dtable/view-external-links/custom/example/\\\&quot;. If not given, SeaTable will give a random token to the link. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBaseExternalLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBaseExternalLinkAsync($workspace_id, $base_name, $password = null, $expire_days = null, $token = null, string $contentType = self::contentTypes['createBaseExternalLink'][0])
    {
        return $this->createBaseExternalLinkAsyncWithHttpInfo($workspace_id, $base_name, $password, $expire_days, $token, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createBaseExternalLinkAsyncWithHttpInfo
     *
     * Create Base External Link
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $password (optional)
     * @param  int $expire_days Add expiration period in days. Optional. (optional)
     * @param  string $token An optional custom token of the generated link. For example, it&#39;ll appear as \\\&quot;https&lt;span&gt;://cloud.seatable.io/dtable/view-external-links/custom/example/\\\&quot;. If not given, SeaTable will give a random token to the link. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBaseExternalLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBaseExternalLinkAsyncWithHttpInfo($workspace_id, $base_name, $password = null, $expire_days = null, $token = null, string $contentType = self::contentTypes['createBaseExternalLink'][0])
    {
        $returnType = 'object';
        $request = $this->createBaseExternalLinkRequest($workspace_id, $base_name, $password, $expire_days, $token, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBaseExternalLink'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $password (optional)
     * @param  int $expire_days Add expiration period in days. Optional. (optional)
     * @param  string $token An optional custom token of the generated link. For example, it&#39;ll appear as \\\&quot;https&lt;span&gt;://cloud.seatable.io/dtable/view-external-links/custom/example/\\\&quot;. If not given, SeaTable will give a random token to the link. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createBaseExternalLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createBaseExternalLinkRequest($workspace_id, $base_name, $password = null, $expire_days = null, $token = null, string $contentType = self::contentTypes['createBaseExternalLink'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling createBaseExternalLink'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling SharingLinksApi.createBaseExternalLink, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling createBaseExternalLink'
            );
        }





        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/external-links/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }

        // form params
        if ($password !== null) {
            $formParams['password'] = ObjectSerializer::toFormValue($password);
        }
        // form params
        if ($expire_days !== null) {
            $formParams['expire_days'] = ObjectSerializer::toFormValue($expire_days);
        }
        // form params
        if ($token !== null) {
            $formParams['token'] = ObjectSerializer::toFormValue($token);
        }

        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createInviteLink
     *
     * Create Invite Link
     *
     * @param  string $table_name The name of the table. (optional)
     * @param  string $workspace_id The workspace ID where your base is. (optional)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $password password (optional)
     * @param  int $expire_days Add expiration period in days. Optional. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInviteLink'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function createInviteLink($table_name = null, $workspace_id = null, $permission = null, $password = null, $expire_days = null, string $contentType = self::contentTypes['createInviteLink'][0])
    {
        list($response) = $this->createInviteLinkWithHttpInfo($table_name, $workspace_id, $permission, $password, $expire_days, $contentType);
        return $response;
    }

    /**
     * Operation createInviteLinkWithHttpInfo
     *
     * Create Invite Link
     *
     * @param  string $table_name The name of the table. (optional)
     * @param  string $workspace_id The workspace ID where your base is. (optional)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $password (optional)
     * @param  int $expire_days Add expiration period in days. Optional. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInviteLink'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function createInviteLinkWithHttpInfo($table_name = null, $workspace_id = null, $permission = null, $password = null, $expire_days = null, string $contentType = self::contentTypes['createInviteLink'][0])
    {
        $request = $this->createInviteLinkRequest($table_name, $workspace_id, $permission, $password, $expire_days, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createInviteLinkAsync
     *
     * Create Invite Link
     *
     * @param  string $table_name The name of the table. (optional)
     * @param  string $workspace_id The workspace ID where your base is. (optional)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $password (optional)
     * @param  int $expire_days Add expiration period in days. Optional. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInviteLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInviteLinkAsync($table_name = null, $workspace_id = null, $permission = null, $password = null, $expire_days = null, string $contentType = self::contentTypes['createInviteLink'][0])
    {
        return $this->createInviteLinkAsyncWithHttpInfo($table_name, $workspace_id, $permission, $password, $expire_days, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createInviteLinkAsyncWithHttpInfo
     *
     * Create Invite Link
     *
     * @param  string $table_name The name of the table. (optional)
     * @param  string $workspace_id The workspace ID where your base is. (optional)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $password (optional)
     * @param  int $expire_days Add expiration period in days. Optional. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInviteLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createInviteLinkAsyncWithHttpInfo($table_name = null, $workspace_id = null, $permission = null, $password = null, $expire_days = null, string $contentType = self::contentTypes['createInviteLink'][0])
    {
        $returnType = 'object';
        $request = $this->createInviteLinkRequest($table_name, $workspace_id, $permission, $password, $expire_days, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createInviteLink'
     *
     * @param  string $table_name The name of the table. (optional)
     * @param  string $workspace_id The workspace ID where your base is. (optional)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $password (optional)
     * @param  int $expire_days Add expiration period in days. Optional. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createInviteLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createInviteLinkRequest($table_name = null, $workspace_id = null, $permission = null, $password = null, $expire_days = null, string $contentType = self::contentTypes['createInviteLink'][0])
    {







        $resourcePath = '/api/v2.1/dtables/invite-links/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;




        // form params
        if ($table_name !== null) {
            $formParams['table_name'] = ObjectSerializer::toFormValue($table_name);
        }
        // form params
        if ($workspace_id !== null) {
            $formParams['workspace_id'] = ObjectSerializer::toFormValue($workspace_id);
        }
        // form params
        if ($permission !== null) {
            $formParams['permission'] = ObjectSerializer::toFormValue($permission);
        }
        // form params
        if ($password !== null) {
            $formParams['password'] = ObjectSerializer::toFormValue($password);
        }
        // form params
        if ($expire_days !== null) {
            $formParams['expire_days'] = ObjectSerializer::toFormValue($expire_days);
        }

        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createViewExternalLink
     *
     * Create View External Link
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $table_id table_id (optional)
     * @param  string $view_id view_id (optional)
     * @param  string $token An optional custom token of the generated link. For example, it&#39;ll appear as \\\&quot;https&lt;span&gt;://cloud.seatable.io/dtable/view-external-links/custom/example/\\\&quot;. If not given, SeaTable will give a random token to the link. (optional)
     * @param  string $password password (optional)
     * @param  int $expire_days Add expiration period in days. Optional. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createViewExternalLink'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function createViewExternalLink($workspace_id, $base_name, $table_id = null, $view_id = null, $token = null, $password = null, $expire_days = null, string $contentType = self::contentTypes['createViewExternalLink'][0])
    {
        list($response) = $this->createViewExternalLinkWithHttpInfo($workspace_id, $base_name, $table_id, $view_id, $token, $password, $expire_days, $contentType);
        return $response;
    }

    /**
     * Operation createViewExternalLinkWithHttpInfo
     *
     * Create View External Link
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $table_id (optional)
     * @param  string $view_id (optional)
     * @param  string $token An optional custom token of the generated link. For example, it&#39;ll appear as \\\&quot;https&lt;span&gt;://cloud.seatable.io/dtable/view-external-links/custom/example/\\\&quot;. If not given, SeaTable will give a random token to the link. (optional)
     * @param  string $password (optional)
     * @param  int $expire_days Add expiration period in days. Optional. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createViewExternalLink'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function createViewExternalLinkWithHttpInfo($workspace_id, $base_name, $table_id = null, $view_id = null, $token = null, $password = null, $expire_days = null, string $contentType = self::contentTypes['createViewExternalLink'][0])
    {
        $request = $this->createViewExternalLinkRequest($workspace_id, $base_name, $table_id, $view_id, $token, $password, $expire_days, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createViewExternalLinkAsync
     *
     * Create View External Link
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $table_id (optional)
     * @param  string $view_id (optional)
     * @param  string $token An optional custom token of the generated link. For example, it&#39;ll appear as \\\&quot;https&lt;span&gt;://cloud.seatable.io/dtable/view-external-links/custom/example/\\\&quot;. If not given, SeaTable will give a random token to the link. (optional)
     * @param  string $password (optional)
     * @param  int $expire_days Add expiration period in days. Optional. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createViewExternalLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createViewExternalLinkAsync($workspace_id, $base_name, $table_id = null, $view_id = null, $token = null, $password = null, $expire_days = null, string $contentType = self::contentTypes['createViewExternalLink'][0])
    {
        return $this->createViewExternalLinkAsyncWithHttpInfo($workspace_id, $base_name, $table_id, $view_id, $token, $password, $expire_days, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createViewExternalLinkAsyncWithHttpInfo
     *
     * Create View External Link
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $table_id (optional)
     * @param  string $view_id (optional)
     * @param  string $token An optional custom token of the generated link. For example, it&#39;ll appear as \\\&quot;https&lt;span&gt;://cloud.seatable.io/dtable/view-external-links/custom/example/\\\&quot;. If not given, SeaTable will give a random token to the link. (optional)
     * @param  string $password (optional)
     * @param  int $expire_days Add expiration period in days. Optional. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createViewExternalLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createViewExternalLinkAsyncWithHttpInfo($workspace_id, $base_name, $table_id = null, $view_id = null, $token = null, $password = null, $expire_days = null, string $contentType = self::contentTypes['createViewExternalLink'][0])
    {
        $returnType = 'object';
        $request = $this->createViewExternalLinkRequest($workspace_id, $base_name, $table_id, $view_id, $token, $password, $expire_days, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createViewExternalLink'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $table_id (optional)
     * @param  string $view_id (optional)
     * @param  string $token An optional custom token of the generated link. For example, it&#39;ll appear as \\\&quot;https&lt;span&gt;://cloud.seatable.io/dtable/view-external-links/custom/example/\\\&quot;. If not given, SeaTable will give a random token to the link. (optional)
     * @param  string $password (optional)
     * @param  int $expire_days Add expiration period in days. Optional. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createViewExternalLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createViewExternalLinkRequest($workspace_id, $base_name, $table_id = null, $view_id = null, $token = null, $password = null, $expire_days = null, string $contentType = self::contentTypes['createViewExternalLink'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling createViewExternalLink'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling SharingLinksApi.createViewExternalLink, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling createViewExternalLink'
            );
        }







        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/view-external-links/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }

        // form params
        if ($table_id !== null) {
            $formParams['table_id'] = ObjectSerializer::toFormValue($table_id);
        }
        // form params
        if ($view_id !== null) {
            $formParams['view_id'] = ObjectSerializer::toFormValue($view_id);
        }
        // form params
        if ($token !== null) {
            $formParams['token'] = ObjectSerializer::toFormValue($token);
        }
        // form params
        if ($password !== null) {
            $formParams['password'] = ObjectSerializer::toFormValue($password);
        }
        // form params
        if ($expire_days !== null) {
            $formParams['expire_days'] = ObjectSerializer::toFormValue($expire_days);
        }

        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteExternalLink
     *
     * Delete External Link
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $external_link_token external_link_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteExternalLink'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function deleteExternalLink($workspace_id, $base_name, $external_link_token, string $contentType = self::contentTypes['deleteExternalLink'][0])
    {
        list($response) = $this->deleteExternalLinkWithHttpInfo($workspace_id, $base_name, $external_link_token, $contentType);
        return $response;
    }

    /**
     * Operation deleteExternalLinkWithHttpInfo
     *
     * Delete External Link
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $external_link_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteExternalLink'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteExternalLinkWithHttpInfo($workspace_id, $base_name, $external_link_token, string $contentType = self::contentTypes['deleteExternalLink'][0])
    {
        $request = $this->deleteExternalLinkRequest($workspace_id, $base_name, $external_link_token, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteExternalLinkAsync
     *
     * Delete External Link
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $external_link_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteExternalLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteExternalLinkAsync($workspace_id, $base_name, $external_link_token, string $contentType = self::contentTypes['deleteExternalLink'][0])
    {
        return $this->deleteExternalLinkAsyncWithHttpInfo($workspace_id, $base_name, $external_link_token, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteExternalLinkAsyncWithHttpInfo
     *
     * Delete External Link
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $external_link_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteExternalLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteExternalLinkAsyncWithHttpInfo($workspace_id, $base_name, $external_link_token, string $contentType = self::contentTypes['deleteExternalLink'][0])
    {
        $returnType = 'object';
        $request = $this->deleteExternalLinkRequest($workspace_id, $base_name, $external_link_token, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteExternalLink'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $external_link_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteExternalLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteExternalLinkRequest($workspace_id, $base_name, $external_link_token, string $contentType = self::contentTypes['deleteExternalLink'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling deleteExternalLink'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling SharingLinksApi.deleteExternalLink, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling deleteExternalLink'
            );
        }

        // verify the required parameter 'external_link_token' is set
        if ($external_link_token === null || (is_array($external_link_token) && count($external_link_token) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_link_token when calling deleteExternalLink'
            );
        }


        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/external-links/{external_link_token}/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }
        // path params
        if ($external_link_token !== null) {
            $resourcePath = str_replace(
                '{' . 'external_link_token' . '}',
                ObjectSerializer::toPathValue($external_link_token),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteInviteLink
     *
     * Delete Invite Link
     *
     * @param  string $invite_link_token invite_link_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInviteLink'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function deleteInviteLink($invite_link_token, string $contentType = self::contentTypes['deleteInviteLink'][0])
    {
        list($response) = $this->deleteInviteLinkWithHttpInfo($invite_link_token, $contentType);
        return $response;
    }

    /**
     * Operation deleteInviteLinkWithHttpInfo
     *
     * Delete Invite Link
     *
     * @param  string $invite_link_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInviteLink'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteInviteLinkWithHttpInfo($invite_link_token, string $contentType = self::contentTypes['deleteInviteLink'][0])
    {
        $request = $this->deleteInviteLinkRequest($invite_link_token, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteInviteLinkAsync
     *
     * Delete Invite Link
     *
     * @param  string $invite_link_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInviteLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteInviteLinkAsync($invite_link_token, string $contentType = self::contentTypes['deleteInviteLink'][0])
    {
        return $this->deleteInviteLinkAsyncWithHttpInfo($invite_link_token, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteInviteLinkAsyncWithHttpInfo
     *
     * Delete Invite Link
     *
     * @param  string $invite_link_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInviteLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteInviteLinkAsyncWithHttpInfo($invite_link_token, string $contentType = self::contentTypes['deleteInviteLink'][0])
    {
        $returnType = 'object';
        $request = $this->deleteInviteLinkRequest($invite_link_token, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteInviteLink'
     *
     * @param  string $invite_link_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteInviteLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteInviteLinkRequest($invite_link_token, string $contentType = self::contentTypes['deleteInviteLink'][0])
    {

        // verify the required parameter 'invite_link_token' is set
        if ($invite_link_token === null || (is_array($invite_link_token) && count($invite_link_token) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $invite_link_token when calling deleteInviteLink'
            );
        }
        if (!preg_match("/^[0-9a-f]{20}$/", $invite_link_token)) {
            throw new \InvalidArgumentException("invalid value for \"invite_link_token\" when calling SharingLinksApi.deleteInviteLink, must conform to the pattern /^[0-9a-f]{20}$/.");
        }
        

        $resourcePath = '/api/v2.1/dtables/invite-links/{invite_link_token}/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($invite_link_token !== null) {
            $resourcePath = str_replace(
                '{' . 'invite_link_token' . '}',
                ObjectSerializer::toPathValue($invite_link_token),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteViewExternalLink
     *
     * Delete View External Link
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $view_external_link_token view_external_link_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteViewExternalLink'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function deleteViewExternalLink($workspace_id, $base_name, $view_external_link_token, string $contentType = self::contentTypes['deleteViewExternalLink'][0])
    {
        list($response) = $this->deleteViewExternalLinkWithHttpInfo($workspace_id, $base_name, $view_external_link_token, $contentType);
        return $response;
    }

    /**
     * Operation deleteViewExternalLinkWithHttpInfo
     *
     * Delete View External Link
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $view_external_link_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteViewExternalLink'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteViewExternalLinkWithHttpInfo($workspace_id, $base_name, $view_external_link_token, string $contentType = self::contentTypes['deleteViewExternalLink'][0])
    {
        $request = $this->deleteViewExternalLinkRequest($workspace_id, $base_name, $view_external_link_token, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteViewExternalLinkAsync
     *
     * Delete View External Link
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $view_external_link_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteViewExternalLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteViewExternalLinkAsync($workspace_id, $base_name, $view_external_link_token, string $contentType = self::contentTypes['deleteViewExternalLink'][0])
    {
        return $this->deleteViewExternalLinkAsyncWithHttpInfo($workspace_id, $base_name, $view_external_link_token, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteViewExternalLinkAsyncWithHttpInfo
     *
     * Delete View External Link
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $view_external_link_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteViewExternalLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteViewExternalLinkAsyncWithHttpInfo($workspace_id, $base_name, $view_external_link_token, string $contentType = self::contentTypes['deleteViewExternalLink'][0])
    {
        $returnType = 'object';
        $request = $this->deleteViewExternalLinkRequest($workspace_id, $base_name, $view_external_link_token, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteViewExternalLink'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $view_external_link_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteViewExternalLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteViewExternalLinkRequest($workspace_id, $base_name, $view_external_link_token, string $contentType = self::contentTypes['deleteViewExternalLink'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling deleteViewExternalLink'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling SharingLinksApi.deleteViewExternalLink, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling deleteViewExternalLink'
            );
        }

        // verify the required parameter 'view_external_link_token' is set
        if ($view_external_link_token === null || (is_array($view_external_link_token) && count($view_external_link_token) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $view_external_link_token when calling deleteViewExternalLink'
            );
        }
        if (!preg_match("/^[0-9a-f]{20}$/", $view_external_link_token)) {
            throw new \InvalidArgumentException("invalid value for \"view_external_link_token\" when calling SharingLinksApi.deleteViewExternalLink, must conform to the pattern /^[0-9a-f]{20}$/.");
        }
        

        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/view-external-links/{view_external_link_token}/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }
        // path params
        if ($view_external_link_token !== null) {
            $resourcePath = str_replace(
                '{' . 'view_external_link_token' . '}',
                ObjectSerializer::toPathValue($view_external_link_token),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listBaseExternalLinks
     *
     * List Base External Links
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listBaseExternalLinks'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function listBaseExternalLinks($workspace_id, $base_name, string $contentType = self::contentTypes['listBaseExternalLinks'][0])
    {
        list($response) = $this->listBaseExternalLinksWithHttpInfo($workspace_id, $base_name, $contentType);
        return $response;
    }

    /**
     * Operation listBaseExternalLinksWithHttpInfo
     *
     * List Base External Links
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listBaseExternalLinks'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function listBaseExternalLinksWithHttpInfo($workspace_id, $base_name, string $contentType = self::contentTypes['listBaseExternalLinks'][0])
    {
        $request = $this->listBaseExternalLinksRequest($workspace_id, $base_name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listBaseExternalLinksAsync
     *
     * List Base External Links
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listBaseExternalLinks'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listBaseExternalLinksAsync($workspace_id, $base_name, string $contentType = self::contentTypes['listBaseExternalLinks'][0])
    {
        return $this->listBaseExternalLinksAsyncWithHttpInfo($workspace_id, $base_name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listBaseExternalLinksAsyncWithHttpInfo
     *
     * List Base External Links
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listBaseExternalLinks'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listBaseExternalLinksAsyncWithHttpInfo($workspace_id, $base_name, string $contentType = self::contentTypes['listBaseExternalLinks'][0])
    {
        $returnType = 'object';
        $request = $this->listBaseExternalLinksRequest($workspace_id, $base_name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listBaseExternalLinks'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listBaseExternalLinks'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listBaseExternalLinksRequest($workspace_id, $base_name, string $contentType = self::contentTypes['listBaseExternalLinks'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling listBaseExternalLinks'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling SharingLinksApi.listBaseExternalLinks, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling listBaseExternalLinks'
            );
        }


        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/external-links/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listViewExternalLinks
     *
     * List View External Links
     *
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $view_id id of view, string (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listViewExternalLinks'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function listViewExternalLinks($table_id, $view_id, $workspace_id, $base_name, string $contentType = self::contentTypes['listViewExternalLinks'][0])
    {
        list($response) = $this->listViewExternalLinksWithHttpInfo($table_id, $view_id, $workspace_id, $base_name, $contentType);
        return $response;
    }

    /**
     * Operation listViewExternalLinksWithHttpInfo
     *
     * List View External Links
     *
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $view_id id of view, string (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listViewExternalLinks'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function listViewExternalLinksWithHttpInfo($table_id, $view_id, $workspace_id, $base_name, string $contentType = self::contentTypes['listViewExternalLinks'][0])
    {
        $request = $this->listViewExternalLinksRequest($table_id, $view_id, $workspace_id, $base_name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listViewExternalLinksAsync
     *
     * List View External Links
     *
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $view_id id of view, string (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listViewExternalLinks'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listViewExternalLinksAsync($table_id, $view_id, $workspace_id, $base_name, string $contentType = self::contentTypes['listViewExternalLinks'][0])
    {
        return $this->listViewExternalLinksAsyncWithHttpInfo($table_id, $view_id, $workspace_id, $base_name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listViewExternalLinksAsyncWithHttpInfo
     *
     * List View External Links
     *
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $view_id id of view, string (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listViewExternalLinks'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listViewExternalLinksAsyncWithHttpInfo($table_id, $view_id, $workspace_id, $base_name, string $contentType = self::contentTypes['listViewExternalLinks'][0])
    {
        $returnType = 'object';
        $request = $this->listViewExternalLinksRequest($table_id, $view_id, $workspace_id, $base_name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listViewExternalLinks'
     *
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $view_id id of view, string (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listViewExternalLinks'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listViewExternalLinksRequest($table_id, $view_id, $workspace_id, $base_name, string $contentType = self::contentTypes['listViewExternalLinks'][0])
    {

        // verify the required parameter 'table_id' is set
        if ($table_id === null || (is_array($table_id) && count($table_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id when calling listViewExternalLinks'
            );
        }
        if (!preg_match("/^[A-Za-z0-9]{4}$/", $table_id)) {
            throw new \InvalidArgumentException("invalid value for \"table_id\" when calling SharingLinksApi.listViewExternalLinks, must conform to the pattern /^[A-Za-z0-9]{4}$/.");
        }
        
        // verify the required parameter 'view_id' is set
        if ($view_id === null || (is_array($view_id) && count($view_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $view_id when calling listViewExternalLinks'
            );
        }

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling listViewExternalLinks'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling SharingLinksApi.listViewExternalLinks, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling listViewExternalLinks'
            );
        }


        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/view-external-links/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $table_id,
            'table_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $view_id,
            'view_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
