<?php
/**
 * SharingApi
 * PHP version 7.4
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Account Operations - User
 *
 * The official SeaTable API Reference (OpenAPI 3.0).
 *
 * The version of the OpenAPI document: 5.0
 * Generated by: https://openapi-generator.tech
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SeaTable\Client\User;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use SeaTable\Client\ApiException;
use SeaTable\Client\Configuration;
use SeaTable\Client\HeaderSelector;
use SeaTable\Client\ObjectSerializer;

/**
 * SharingApi Class Doc Comment
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class SharingApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createGroupShare' => [
            'multipart/form-data',
        ],
        'createGroupViewShare' => [
            'multipart/form-data',
        ],
        'createUserShare' => [
            'application/x-www-form-urlencoded',
        ],
        'createUserViewShare' => [
            'application/x-www-form-urlencoded',
        ],
        'deleteGroupAllViewShare' => [
            'application/json',
        ],
        'deleteGroupShare' => [
            'application/json',
        ],
        'deleteGroupViewShare' => [
            'application/json',
        ],
        'deleteUserAllViewShare' => [
            'application/json',
        ],
        'deleteUserShare' => [
            'application/json',
        ],
        'deleteUserViewShare' => [
            'application/json',
        ],
        'leaveSharedView' => [
            'application/json',
        ],
        'listCollaboratorsAsUser' => [
            'application/json',
        ],
        'listGroupShares' => [
            'application/json',
        ],
        'listGroupViewShares' => [
            'application/json',
        ],
        'listMyGroupShares' => [
            'application/json',
        ],
        'listMyGroupViewShares' => [
            'application/json',
        ],
        'listMyShares' => [
            'application/json',
        ],
        'listMyUserViewShares' => [
            'application/json',
        ],
        'listUserShares' => [
            'application/json',
        ],
        'listUserViewShares' => [
            'application/json',
        ],
        'updateGroupShare' => [
            'multipart/form-data',
        ],
        'updateGroupViewShare' => [
            'application/x-www-form-urlencoded',
        ],
        'updateUserShare' => [
            'application/x-www-form-urlencoded',
        ],
        'updateUserViewShare' => [
            'application/x-www-form-urlencoded',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createGroupShare
     *
     * Create Group Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $group_id The ID of the group. (optional)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createGroupShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function createGroupShare($workspace_id, $base_name, $group_id = null, $permission = null, string $contentType = self::contentTypes['createGroupShare'][0])
    {
        list($response) = $this->createGroupShareWithHttpInfo($workspace_id, $base_name, $group_id, $permission, $contentType);
        return $response;
    }

    /**
     * Operation createGroupShareWithHttpInfo
     *
     * Create Group Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $group_id The ID of the group. (optional)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createGroupShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function createGroupShareWithHttpInfo($workspace_id, $base_name, $group_id = null, $permission = null, string $contentType = self::contentTypes['createGroupShare'][0])
    {
        $request = $this->createGroupShareRequest($workspace_id, $base_name, $group_id, $permission, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createGroupShareAsync
     *
     * Create Group Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $group_id The ID of the group. (optional)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createGroupShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createGroupShareAsync($workspace_id, $base_name, $group_id = null, $permission = null, string $contentType = self::contentTypes['createGroupShare'][0])
    {
        return $this->createGroupShareAsyncWithHttpInfo($workspace_id, $base_name, $group_id, $permission, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createGroupShareAsyncWithHttpInfo
     *
     * Create Group Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $group_id The ID of the group. (optional)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createGroupShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createGroupShareAsyncWithHttpInfo($workspace_id, $base_name, $group_id = null, $permission = null, string $contentType = self::contentTypes['createGroupShare'][0])
    {
        $returnType = 'object';
        $request = $this->createGroupShareRequest($workspace_id, $base_name, $group_id, $permission, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createGroupShare'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $group_id The ID of the group. (optional)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createGroupShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createGroupShareRequest($workspace_id, $base_name, $group_id = null, $permission = null, string $contentType = self::contentTypes['createGroupShare'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling createGroupShare'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling SharingApi.createGroupShare, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling createGroupShare'
            );
        }




        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/group-shares/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }

        // form params
        if ($group_id !== null) {
            $formParams['group_id'] = ObjectSerializer::toFormValue($group_id);
        }
        // form params
        if ($permission !== null) {
            $formParams['permission'] = ObjectSerializer::toFormValue($permission);
        }

        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createGroupViewShare
     *
     * Create Group View Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $table_id table_id (optional)
     * @param  string $view_id view_id (optional)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $to_group_id The ID of the group. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createGroupViewShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function createGroupViewShare($workspace_id, $base_name, $table_id = null, $view_id = null, $permission = null, $to_group_id = null, string $contentType = self::contentTypes['createGroupViewShare'][0])
    {
        list($response) = $this->createGroupViewShareWithHttpInfo($workspace_id, $base_name, $table_id, $view_id, $permission, $to_group_id, $contentType);
        return $response;
    }

    /**
     * Operation createGroupViewShareWithHttpInfo
     *
     * Create Group View Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $table_id (optional)
     * @param  string $view_id (optional)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $to_group_id The ID of the group. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createGroupViewShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function createGroupViewShareWithHttpInfo($workspace_id, $base_name, $table_id = null, $view_id = null, $permission = null, $to_group_id = null, string $contentType = self::contentTypes['createGroupViewShare'][0])
    {
        $request = $this->createGroupViewShareRequest($workspace_id, $base_name, $table_id, $view_id, $permission, $to_group_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createGroupViewShareAsync
     *
     * Create Group View Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $table_id (optional)
     * @param  string $view_id (optional)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $to_group_id The ID of the group. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createGroupViewShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createGroupViewShareAsync($workspace_id, $base_name, $table_id = null, $view_id = null, $permission = null, $to_group_id = null, string $contentType = self::contentTypes['createGroupViewShare'][0])
    {
        return $this->createGroupViewShareAsyncWithHttpInfo($workspace_id, $base_name, $table_id, $view_id, $permission, $to_group_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createGroupViewShareAsyncWithHttpInfo
     *
     * Create Group View Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $table_id (optional)
     * @param  string $view_id (optional)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $to_group_id The ID of the group. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createGroupViewShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createGroupViewShareAsyncWithHttpInfo($workspace_id, $base_name, $table_id = null, $view_id = null, $permission = null, $to_group_id = null, string $contentType = self::contentTypes['createGroupViewShare'][0])
    {
        $returnType = 'object';
        $request = $this->createGroupViewShareRequest($workspace_id, $base_name, $table_id, $view_id, $permission, $to_group_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createGroupViewShare'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $table_id (optional)
     * @param  string $view_id (optional)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $to_group_id The ID of the group. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createGroupViewShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createGroupViewShareRequest($workspace_id, $base_name, $table_id = null, $view_id = null, $permission = null, $to_group_id = null, string $contentType = self::contentTypes['createGroupViewShare'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling createGroupViewShare'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling SharingApi.createGroupViewShare, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling createGroupViewShare'
            );
        }






        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/group-view-shares/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }

        // form params
        if ($table_id !== null) {
            $formParams['table_id'] = ObjectSerializer::toFormValue($table_id);
        }
        // form params
        if ($view_id !== null) {
            $formParams['view_id'] = ObjectSerializer::toFormValue($view_id);
        }
        // form params
        if ($permission !== null) {
            $formParams['permission'] = ObjectSerializer::toFormValue($permission);
        }
        // form params
        if ($to_group_id !== null) {
            $formParams['to_group_id'] = ObjectSerializer::toFormValue($to_group_id);
        }

        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createUserShare
     *
     * Create User Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $email The user ID ending with @auth.local (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createUserShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function createUserShare($workspace_id, $base_name, $permission = null, $email = null, string $contentType = self::contentTypes['createUserShare'][0])
    {
        list($response) = $this->createUserShareWithHttpInfo($workspace_id, $base_name, $permission, $email, $contentType);
        return $response;
    }

    /**
     * Operation createUserShareWithHttpInfo
     *
     * Create User Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $email The user ID ending with @auth.local (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createUserShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function createUserShareWithHttpInfo($workspace_id, $base_name, $permission = null, $email = null, string $contentType = self::contentTypes['createUserShare'][0])
    {
        $request = $this->createUserShareRequest($workspace_id, $base_name, $permission, $email, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 201:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createUserShareAsync
     *
     * Create User Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $email The user ID ending with @auth.local (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createUserShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createUserShareAsync($workspace_id, $base_name, $permission = null, $email = null, string $contentType = self::contentTypes['createUserShare'][0])
    {
        return $this->createUserShareAsyncWithHttpInfo($workspace_id, $base_name, $permission, $email, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createUserShareAsyncWithHttpInfo
     *
     * Create User Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $email The user ID ending with @auth.local (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createUserShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createUserShareAsyncWithHttpInfo($workspace_id, $base_name, $permission = null, $email = null, string $contentType = self::contentTypes['createUserShare'][0])
    {
        $returnType = 'object';
        $request = $this->createUserShareRequest($workspace_id, $base_name, $permission, $email, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createUserShare'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $email The user ID ending with @auth.local (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createUserShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createUserShareRequest($workspace_id, $base_name, $permission = null, $email = null, string $contentType = self::contentTypes['createUserShare'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling createUserShare'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling SharingApi.createUserShare, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling createUserShare'
            );
        }




        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/share/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }

        // form params
        if ($permission !== null) {
            $formParams['permission'] = ObjectSerializer::toFormValue($permission);
        }
        // form params
        if ($email !== null) {
            $formParams['email'] = ObjectSerializer::toFormValue($email);
        }

        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createUserViewShare
     *
     * Create User View Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $to_user The user ID ending with @auth.local (optional)
     * @param  string $table_id table_id (optional)
     * @param  string $view_id view_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createUserViewShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function createUserViewShare($workspace_id, $base_name, $permission = null, $to_user = null, $table_id = null, $view_id = null, string $contentType = self::contentTypes['createUserViewShare'][0])
    {
        list($response) = $this->createUserViewShareWithHttpInfo($workspace_id, $base_name, $permission, $to_user, $table_id, $view_id, $contentType);
        return $response;
    }

    /**
     * Operation createUserViewShareWithHttpInfo
     *
     * Create User View Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $to_user The user ID ending with @auth.local (optional)
     * @param  string $table_id (optional)
     * @param  string $view_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createUserViewShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function createUserViewShareWithHttpInfo($workspace_id, $base_name, $permission = null, $to_user = null, $table_id = null, $view_id = null, string $contentType = self::contentTypes['createUserViewShare'][0])
    {
        $request = $this->createUserViewShareRequest($workspace_id, $base_name, $permission, $to_user, $table_id, $view_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createUserViewShareAsync
     *
     * Create User View Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $to_user The user ID ending with @auth.local (optional)
     * @param  string $table_id (optional)
     * @param  string $view_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createUserViewShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createUserViewShareAsync($workspace_id, $base_name, $permission = null, $to_user = null, $table_id = null, $view_id = null, string $contentType = self::contentTypes['createUserViewShare'][0])
    {
        return $this->createUserViewShareAsyncWithHttpInfo($workspace_id, $base_name, $permission, $to_user, $table_id, $view_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createUserViewShareAsyncWithHttpInfo
     *
     * Create User View Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $to_user The user ID ending with @auth.local (optional)
     * @param  string $table_id (optional)
     * @param  string $view_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createUserViewShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createUserViewShareAsyncWithHttpInfo($workspace_id, $base_name, $permission = null, $to_user = null, $table_id = null, $view_id = null, string $contentType = self::contentTypes['createUserViewShare'][0])
    {
        $returnType = 'object';
        $request = $this->createUserViewShareRequest($workspace_id, $base_name, $permission, $to_user, $table_id, $view_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createUserViewShare'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $to_user The user ID ending with @auth.local (optional)
     * @param  string $table_id (optional)
     * @param  string $view_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createUserViewShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createUserViewShareRequest($workspace_id, $base_name, $permission = null, $to_user = null, $table_id = null, $view_id = null, string $contentType = self::contentTypes['createUserViewShare'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling createUserViewShare'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling SharingApi.createUserViewShare, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling createUserViewShare'
            );
        }






        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/user-view-shares/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }

        // form params
        if ($permission !== null) {
            $formParams['permission'] = ObjectSerializer::toFormValue($permission);
        }
        // form params
        if ($to_user !== null) {
            $formParams['to_user'] = ObjectSerializer::toFormValue($to_user);
        }
        // form params
        if ($table_id !== null) {
            $formParams['table_id'] = ObjectSerializer::toFormValue($table_id);
        }
        // form params
        if ($view_id !== null) {
            $formParams['view_id'] = ObjectSerializer::toFormValue($view_id);
        }

        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteGroupAllViewShare
     *
     * Delete Group View Share
     *
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $view_id id of view, string (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupAllViewShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function deleteGroupAllViewShare($table_id, $view_id, $workspace_id, $base_name, string $contentType = self::contentTypes['deleteGroupAllViewShare'][0])
    {
        list($response) = $this->deleteGroupAllViewShareWithHttpInfo($table_id, $view_id, $workspace_id, $base_name, $contentType);
        return $response;
    }

    /**
     * Operation deleteGroupAllViewShareWithHttpInfo
     *
     * Delete Group View Share
     *
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $view_id id of view, string (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupAllViewShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteGroupAllViewShareWithHttpInfo($table_id, $view_id, $workspace_id, $base_name, string $contentType = self::contentTypes['deleteGroupAllViewShare'][0])
    {
        $request = $this->deleteGroupAllViewShareRequest($table_id, $view_id, $workspace_id, $base_name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteGroupAllViewShareAsync
     *
     * Delete Group View Share
     *
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $view_id id of view, string (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupAllViewShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupAllViewShareAsync($table_id, $view_id, $workspace_id, $base_name, string $contentType = self::contentTypes['deleteGroupAllViewShare'][0])
    {
        return $this->deleteGroupAllViewShareAsyncWithHttpInfo($table_id, $view_id, $workspace_id, $base_name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteGroupAllViewShareAsyncWithHttpInfo
     *
     * Delete Group View Share
     *
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $view_id id of view, string (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupAllViewShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupAllViewShareAsyncWithHttpInfo($table_id, $view_id, $workspace_id, $base_name, string $contentType = self::contentTypes['deleteGroupAllViewShare'][0])
    {
        $returnType = 'object';
        $request = $this->deleteGroupAllViewShareRequest($table_id, $view_id, $workspace_id, $base_name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteGroupAllViewShare'
     *
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $view_id id of view, string (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupAllViewShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteGroupAllViewShareRequest($table_id, $view_id, $workspace_id, $base_name, string $contentType = self::contentTypes['deleteGroupAllViewShare'][0])
    {

        // verify the required parameter 'table_id' is set
        if ($table_id === null || (is_array($table_id) && count($table_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id when calling deleteGroupAllViewShare'
            );
        }
        if (!preg_match("/^[A-Za-z0-9]{4}$/", $table_id)) {
            throw new \InvalidArgumentException("invalid value for \"table_id\" when calling SharingApi.deleteGroupAllViewShare, must conform to the pattern /^[A-Za-z0-9]{4}$/.");
        }
        
        // verify the required parameter 'view_id' is set
        if ($view_id === null || (is_array($view_id) && count($view_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $view_id when calling deleteGroupAllViewShare'
            );
        }

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling deleteGroupAllViewShare'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling SharingApi.deleteGroupAllViewShare, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling deleteGroupAllViewShare'
            );
        }


        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/group-view-shares/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $table_id,
            'table_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $view_id,
            'view_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteGroupShare
     *
     * Delete Group Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $group_id group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function deleteGroupShare($workspace_id, $base_name, $group_id, string $contentType = self::contentTypes['deleteGroupShare'][0])
    {
        list($response) = $this->deleteGroupShareWithHttpInfo($workspace_id, $base_name, $group_id, $contentType);
        return $response;
    }

    /**
     * Operation deleteGroupShareWithHttpInfo
     *
     * Delete Group Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteGroupShareWithHttpInfo($workspace_id, $base_name, $group_id, string $contentType = self::contentTypes['deleteGroupShare'][0])
    {
        $request = $this->deleteGroupShareRequest($workspace_id, $base_name, $group_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteGroupShareAsync
     *
     * Delete Group Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupShareAsync($workspace_id, $base_name, $group_id, string $contentType = self::contentTypes['deleteGroupShare'][0])
    {
        return $this->deleteGroupShareAsyncWithHttpInfo($workspace_id, $base_name, $group_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteGroupShareAsyncWithHttpInfo
     *
     * Delete Group Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupShareAsyncWithHttpInfo($workspace_id, $base_name, $group_id, string $contentType = self::contentTypes['deleteGroupShare'][0])
    {
        $returnType = 'object';
        $request = $this->deleteGroupShareRequest($workspace_id, $base_name, $group_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteGroupShare'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $group_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteGroupShareRequest($workspace_id, $base_name, $group_id, string $contentType = self::contentTypes['deleteGroupShare'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling deleteGroupShare'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling SharingApi.deleteGroupShare, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling deleteGroupShare'
            );
        }

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling deleteGroupShare'
            );
        }
        if ($group_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$group_id" when calling SharingApi.deleteGroupShare, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/group-shares/{group_id}/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }
        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'group_id' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteGroupViewShare
     *
     * Delete Group View Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $group_view_share_id group_view_share_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupViewShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function deleteGroupViewShare($workspace_id, $base_name, $group_view_share_id, string $contentType = self::contentTypes['deleteGroupViewShare'][0])
    {
        list($response) = $this->deleteGroupViewShareWithHttpInfo($workspace_id, $base_name, $group_view_share_id, $contentType);
        return $response;
    }

    /**
     * Operation deleteGroupViewShareWithHttpInfo
     *
     * Delete Group View Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $group_view_share_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupViewShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteGroupViewShareWithHttpInfo($workspace_id, $base_name, $group_view_share_id, string $contentType = self::contentTypes['deleteGroupViewShare'][0])
    {
        $request = $this->deleteGroupViewShareRequest($workspace_id, $base_name, $group_view_share_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteGroupViewShareAsync
     *
     * Delete Group View Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $group_view_share_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupViewShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupViewShareAsync($workspace_id, $base_name, $group_view_share_id, string $contentType = self::contentTypes['deleteGroupViewShare'][0])
    {
        return $this->deleteGroupViewShareAsyncWithHttpInfo($workspace_id, $base_name, $group_view_share_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteGroupViewShareAsyncWithHttpInfo
     *
     * Delete Group View Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $group_view_share_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupViewShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteGroupViewShareAsyncWithHttpInfo($workspace_id, $base_name, $group_view_share_id, string $contentType = self::contentTypes['deleteGroupViewShare'][0])
    {
        $returnType = 'object';
        $request = $this->deleteGroupViewShareRequest($workspace_id, $base_name, $group_view_share_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteGroupViewShare'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $group_view_share_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteGroupViewShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteGroupViewShareRequest($workspace_id, $base_name, $group_view_share_id, string $contentType = self::contentTypes['deleteGroupViewShare'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling deleteGroupViewShare'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling SharingApi.deleteGroupViewShare, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling deleteGroupViewShare'
            );
        }

        // verify the required parameter 'group_view_share_id' is set
        if ($group_view_share_id === null || (is_array($group_view_share_id) && count($group_view_share_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_view_share_id when calling deleteGroupViewShare'
            );
        }
        if ($group_view_share_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$group_view_share_id" when calling SharingApi.deleteGroupViewShare, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/group-view-shares/{group_view_share_id}/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }
        // path params
        if ($group_view_share_id !== null) {
            $resourcePath = str_replace(
                '{' . 'group_view_share_id' . '}',
                ObjectSerializer::toPathValue($group_view_share_id),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteUserAllViewShare
     *
     * Delete User View Share
     *
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $view_id id of view, string (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteUserAllViewShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function deleteUserAllViewShare($table_id, $view_id, $workspace_id, $base_name, string $contentType = self::contentTypes['deleteUserAllViewShare'][0])
    {
        list($response) = $this->deleteUserAllViewShareWithHttpInfo($table_id, $view_id, $workspace_id, $base_name, $contentType);
        return $response;
    }

    /**
     * Operation deleteUserAllViewShareWithHttpInfo
     *
     * Delete User View Share
     *
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $view_id id of view, string (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteUserAllViewShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteUserAllViewShareWithHttpInfo($table_id, $view_id, $workspace_id, $base_name, string $contentType = self::contentTypes['deleteUserAllViewShare'][0])
    {
        $request = $this->deleteUserAllViewShareRequest($table_id, $view_id, $workspace_id, $base_name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteUserAllViewShareAsync
     *
     * Delete User View Share
     *
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $view_id id of view, string (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteUserAllViewShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteUserAllViewShareAsync($table_id, $view_id, $workspace_id, $base_name, string $contentType = self::contentTypes['deleteUserAllViewShare'][0])
    {
        return $this->deleteUserAllViewShareAsyncWithHttpInfo($table_id, $view_id, $workspace_id, $base_name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteUserAllViewShareAsyncWithHttpInfo
     *
     * Delete User View Share
     *
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $view_id id of view, string (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteUserAllViewShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteUserAllViewShareAsyncWithHttpInfo($table_id, $view_id, $workspace_id, $base_name, string $contentType = self::contentTypes['deleteUserAllViewShare'][0])
    {
        $returnType = 'object';
        $request = $this->deleteUserAllViewShareRequest($table_id, $view_id, $workspace_id, $base_name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteUserAllViewShare'
     *
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $view_id id of view, string (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteUserAllViewShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteUserAllViewShareRequest($table_id, $view_id, $workspace_id, $base_name, string $contentType = self::contentTypes['deleteUserAllViewShare'][0])
    {

        // verify the required parameter 'table_id' is set
        if ($table_id === null || (is_array($table_id) && count($table_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id when calling deleteUserAllViewShare'
            );
        }
        if (!preg_match("/^[A-Za-z0-9]{4}$/", $table_id)) {
            throw new \InvalidArgumentException("invalid value for \"table_id\" when calling SharingApi.deleteUserAllViewShare, must conform to the pattern /^[A-Za-z0-9]{4}$/.");
        }
        
        // verify the required parameter 'view_id' is set
        if ($view_id === null || (is_array($view_id) && count($view_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $view_id when calling deleteUserAllViewShare'
            );
        }

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling deleteUserAllViewShare'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling SharingApi.deleteUserAllViewShare, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling deleteUserAllViewShare'
            );
        }


        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/user-view-shares/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $table_id,
            'table_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $view_id,
            'view_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteUserShare
     *
     * Delete User Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteUserShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function deleteUserShare($workspace_id, $base_name, string $contentType = self::contentTypes['deleteUserShare'][0])
    {
        list($response) = $this->deleteUserShareWithHttpInfo($workspace_id, $base_name, $contentType);
        return $response;
    }

    /**
     * Operation deleteUserShareWithHttpInfo
     *
     * Delete User Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteUserShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteUserShareWithHttpInfo($workspace_id, $base_name, string $contentType = self::contentTypes['deleteUserShare'][0])
    {
        $request = $this->deleteUserShareRequest($workspace_id, $base_name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteUserShareAsync
     *
     * Delete User Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteUserShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteUserShareAsync($workspace_id, $base_name, string $contentType = self::contentTypes['deleteUserShare'][0])
    {
        return $this->deleteUserShareAsyncWithHttpInfo($workspace_id, $base_name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteUserShareAsyncWithHttpInfo
     *
     * Delete User Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteUserShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteUserShareAsyncWithHttpInfo($workspace_id, $base_name, string $contentType = self::contentTypes['deleteUserShare'][0])
    {
        $returnType = 'object';
        $request = $this->deleteUserShareRequest($workspace_id, $base_name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteUserShare'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteUserShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteUserShareRequest($workspace_id, $base_name, string $contentType = self::contentTypes['deleteUserShare'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling deleteUserShare'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling SharingApi.deleteUserShare, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling deleteUserShare'
            );
        }


        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/share/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteUserViewShare
     *
     * Delete User View Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $user_view_share_id user_view_share_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteUserViewShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function deleteUserViewShare($workspace_id, $base_name, $user_view_share_id, string $contentType = self::contentTypes['deleteUserViewShare'][0])
    {
        list($response) = $this->deleteUserViewShareWithHttpInfo($workspace_id, $base_name, $user_view_share_id, $contentType);
        return $response;
    }

    /**
     * Operation deleteUserViewShareWithHttpInfo
     *
     * Delete User View Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $user_view_share_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteUserViewShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteUserViewShareWithHttpInfo($workspace_id, $base_name, $user_view_share_id, string $contentType = self::contentTypes['deleteUserViewShare'][0])
    {
        $request = $this->deleteUserViewShareRequest($workspace_id, $base_name, $user_view_share_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteUserViewShareAsync
     *
     * Delete User View Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $user_view_share_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteUserViewShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteUserViewShareAsync($workspace_id, $base_name, $user_view_share_id, string $contentType = self::contentTypes['deleteUserViewShare'][0])
    {
        return $this->deleteUserViewShareAsyncWithHttpInfo($workspace_id, $base_name, $user_view_share_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteUserViewShareAsyncWithHttpInfo
     *
     * Delete User View Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $user_view_share_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteUserViewShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteUserViewShareAsyncWithHttpInfo($workspace_id, $base_name, $user_view_share_id, string $contentType = self::contentTypes['deleteUserViewShare'][0])
    {
        $returnType = 'object';
        $request = $this->deleteUserViewShareRequest($workspace_id, $base_name, $user_view_share_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteUserViewShare'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $user_view_share_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteUserViewShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteUserViewShareRequest($workspace_id, $base_name, $user_view_share_id, string $contentType = self::contentTypes['deleteUserViewShare'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling deleteUserViewShare'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling SharingApi.deleteUserViewShare, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling deleteUserViewShare'
            );
        }

        // verify the required parameter 'user_view_share_id' is set
        if ($user_view_share_id === null || (is_array($user_view_share_id) && count($user_view_share_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_view_share_id when calling deleteUserViewShare'
            );
        }
        if ($user_view_share_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$user_view_share_id" when calling SharingApi.deleteUserViewShare, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/user-view-shares/{user_view_share_id}/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }
        // path params
        if ($user_view_share_id !== null) {
            $resourcePath = str_replace(
                '{' . 'user_view_share_id' . '}',
                ObjectSerializer::toPathValue($user_view_share_id),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation leaveSharedView
     *
     * Leave Shared View
     *
     * @param  int $user_view_share_id user_view_share_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['leaveSharedView'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function leaveSharedView($user_view_share_id, string $contentType = self::contentTypes['leaveSharedView'][0])
    {
        list($response) = $this->leaveSharedViewWithHttpInfo($user_view_share_id, $contentType);
        return $response;
    }

    /**
     * Operation leaveSharedViewWithHttpInfo
     *
     * Leave Shared View
     *
     * @param  int $user_view_share_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['leaveSharedView'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function leaveSharedViewWithHttpInfo($user_view_share_id, string $contentType = self::contentTypes['leaveSharedView'][0])
    {
        $request = $this->leaveSharedViewRequest($user_view_share_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation leaveSharedViewAsync
     *
     * Leave Shared View
     *
     * @param  int $user_view_share_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['leaveSharedView'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function leaveSharedViewAsync($user_view_share_id, string $contentType = self::contentTypes['leaveSharedView'][0])
    {
        return $this->leaveSharedViewAsyncWithHttpInfo($user_view_share_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation leaveSharedViewAsyncWithHttpInfo
     *
     * Leave Shared View
     *
     * @param  int $user_view_share_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['leaveSharedView'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function leaveSharedViewAsyncWithHttpInfo($user_view_share_id, string $contentType = self::contentTypes['leaveSharedView'][0])
    {
        $returnType = 'object';
        $request = $this->leaveSharedViewRequest($user_view_share_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'leaveSharedView'
     *
     * @param  int $user_view_share_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['leaveSharedView'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function leaveSharedViewRequest($user_view_share_id, string $contentType = self::contentTypes['leaveSharedView'][0])
    {

        // verify the required parameter 'user_view_share_id' is set
        if ($user_view_share_id === null || (is_array($user_view_share_id) && count($user_view_share_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_view_share_id when calling leaveSharedView'
            );
        }
        if ($user_view_share_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$user_view_share_id" when calling SharingApi.leaveSharedView, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v2.1/dtables/view-shares-user-shared/{user_view_share_id}/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($user_view_share_id !== null) {
            $resourcePath = str_replace(
                '{' . 'user_view_share_id' . '}',
                ObjectSerializer::toPathValue($user_view_share_id),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listCollaboratorsAsUser
     *
     * List Collaborators
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listCollaboratorsAsUser'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function listCollaboratorsAsUser($workspace_id, $base_name, string $contentType = self::contentTypes['listCollaboratorsAsUser'][0])
    {
        list($response) = $this->listCollaboratorsAsUserWithHttpInfo($workspace_id, $base_name, $contentType);
        return $response;
    }

    /**
     * Operation listCollaboratorsAsUserWithHttpInfo
     *
     * List Collaborators
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listCollaboratorsAsUser'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function listCollaboratorsAsUserWithHttpInfo($workspace_id, $base_name, string $contentType = self::contentTypes['listCollaboratorsAsUser'][0])
    {
        $request = $this->listCollaboratorsAsUserRequest($workspace_id, $base_name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listCollaboratorsAsUserAsync
     *
     * List Collaborators
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listCollaboratorsAsUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listCollaboratorsAsUserAsync($workspace_id, $base_name, string $contentType = self::contentTypes['listCollaboratorsAsUser'][0])
    {
        return $this->listCollaboratorsAsUserAsyncWithHttpInfo($workspace_id, $base_name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listCollaboratorsAsUserAsyncWithHttpInfo
     *
     * List Collaborators
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listCollaboratorsAsUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listCollaboratorsAsUserAsyncWithHttpInfo($workspace_id, $base_name, string $contentType = self::contentTypes['listCollaboratorsAsUser'][0])
    {
        $returnType = 'object';
        $request = $this->listCollaboratorsAsUserRequest($workspace_id, $base_name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listCollaboratorsAsUser'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listCollaboratorsAsUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listCollaboratorsAsUserRequest($workspace_id, $base_name, string $contentType = self::contentTypes['listCollaboratorsAsUser'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling listCollaboratorsAsUser'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling SharingApi.listCollaboratorsAsUser, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling listCollaboratorsAsUser'
            );
        }


        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/related-users/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listGroupShares
     *
     * List Group Shares
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listGroupShares'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function listGroupShares($workspace_id, $base_name, string $contentType = self::contentTypes['listGroupShares'][0])
    {
        list($response) = $this->listGroupSharesWithHttpInfo($workspace_id, $base_name, $contentType);
        return $response;
    }

    /**
     * Operation listGroupSharesWithHttpInfo
     *
     * List Group Shares
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listGroupShares'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function listGroupSharesWithHttpInfo($workspace_id, $base_name, string $contentType = self::contentTypes['listGroupShares'][0])
    {
        $request = $this->listGroupSharesRequest($workspace_id, $base_name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listGroupSharesAsync
     *
     * List Group Shares
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listGroupShares'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listGroupSharesAsync($workspace_id, $base_name, string $contentType = self::contentTypes['listGroupShares'][0])
    {
        return $this->listGroupSharesAsyncWithHttpInfo($workspace_id, $base_name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listGroupSharesAsyncWithHttpInfo
     *
     * List Group Shares
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listGroupShares'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listGroupSharesAsyncWithHttpInfo($workspace_id, $base_name, string $contentType = self::contentTypes['listGroupShares'][0])
    {
        $returnType = 'object';
        $request = $this->listGroupSharesRequest($workspace_id, $base_name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listGroupShares'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listGroupShares'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listGroupSharesRequest($workspace_id, $base_name, string $contentType = self::contentTypes['listGroupShares'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling listGroupShares'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling SharingApi.listGroupShares, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling listGroupShares'
            );
        }


        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/group-shares/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listGroupViewShares
     *
     * List Group View Shares
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listGroupViewShares'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function listGroupViewShares($workspace_id, $base_name, string $contentType = self::contentTypes['listGroupViewShares'][0])
    {
        list($response) = $this->listGroupViewSharesWithHttpInfo($workspace_id, $base_name, $contentType);
        return $response;
    }

    /**
     * Operation listGroupViewSharesWithHttpInfo
     *
     * List Group View Shares
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listGroupViewShares'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function listGroupViewSharesWithHttpInfo($workspace_id, $base_name, string $contentType = self::contentTypes['listGroupViewShares'][0])
    {
        $request = $this->listGroupViewSharesRequest($workspace_id, $base_name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listGroupViewSharesAsync
     *
     * List Group View Shares
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listGroupViewShares'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listGroupViewSharesAsync($workspace_id, $base_name, string $contentType = self::contentTypes['listGroupViewShares'][0])
    {
        return $this->listGroupViewSharesAsyncWithHttpInfo($workspace_id, $base_name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listGroupViewSharesAsyncWithHttpInfo
     *
     * List Group View Shares
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listGroupViewShares'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listGroupViewSharesAsyncWithHttpInfo($workspace_id, $base_name, string $contentType = self::contentTypes['listGroupViewShares'][0])
    {
        $returnType = 'object';
        $request = $this->listGroupViewSharesRequest($workspace_id, $base_name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listGroupViewShares'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listGroupViewShares'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listGroupViewSharesRequest($workspace_id, $base_name, string $contentType = self::contentTypes['listGroupViewShares'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling listGroupViewShares'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling SharingApi.listGroupViewShares, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling listGroupViewShares'
            );
        }


        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/group-view-shares/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listMyGroupShares
     *
     * List My Group Shares
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listMyGroupShares'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function listMyGroupShares(string $contentType = self::contentTypes['listMyGroupShares'][0])
    {
        list($response) = $this->listMyGroupSharesWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation listMyGroupSharesWithHttpInfo
     *
     * List My Group Shares
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listMyGroupShares'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function listMyGroupSharesWithHttpInfo(string $contentType = self::contentTypes['listMyGroupShares'][0])
    {
        $request = $this->listMyGroupSharesRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listMyGroupSharesAsync
     *
     * List My Group Shares
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listMyGroupShares'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listMyGroupSharesAsync(string $contentType = self::contentTypes['listMyGroupShares'][0])
    {
        return $this->listMyGroupSharesAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listMyGroupSharesAsyncWithHttpInfo
     *
     * List My Group Shares
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listMyGroupShares'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listMyGroupSharesAsyncWithHttpInfo(string $contentType = self::contentTypes['listMyGroupShares'][0])
    {
        $returnType = 'object';
        $request = $this->listMyGroupSharesRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listMyGroupShares'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listMyGroupShares'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listMyGroupSharesRequest(string $contentType = self::contentTypes['listMyGroupShares'][0])
    {


        $resourcePath = '/api/v2.1/dtables/group-shared/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listMyGroupViewShares
     *
     * My Group View Shares
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listMyGroupViewShares'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function listMyGroupViewShares(string $contentType = self::contentTypes['listMyGroupViewShares'][0])
    {
        list($response) = $this->listMyGroupViewSharesWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation listMyGroupViewSharesWithHttpInfo
     *
     * My Group View Shares
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listMyGroupViewShares'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function listMyGroupViewSharesWithHttpInfo(string $contentType = self::contentTypes['listMyGroupViewShares'][0])
    {
        $request = $this->listMyGroupViewSharesRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listMyGroupViewSharesAsync
     *
     * My Group View Shares
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listMyGroupViewShares'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listMyGroupViewSharesAsync(string $contentType = self::contentTypes['listMyGroupViewShares'][0])
    {
        return $this->listMyGroupViewSharesAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listMyGroupViewSharesAsyncWithHttpInfo
     *
     * My Group View Shares
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listMyGroupViewShares'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listMyGroupViewSharesAsyncWithHttpInfo(string $contentType = self::contentTypes['listMyGroupViewShares'][0])
    {
        $returnType = 'object';
        $request = $this->listMyGroupViewSharesRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listMyGroupViewShares'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listMyGroupViewShares'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listMyGroupViewSharesRequest(string $contentType = self::contentTypes['listMyGroupViewShares'][0])
    {


        $resourcePath = '/api/v2.1/dtables/view-shares-group-shared/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listMyShares
     *
     * List My Shares
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listMyShares'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function listMyShares(string $contentType = self::contentTypes['listMyShares'][0])
    {
        list($response) = $this->listMySharesWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation listMySharesWithHttpInfo
     *
     * List My Shares
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listMyShares'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function listMySharesWithHttpInfo(string $contentType = self::contentTypes['listMyShares'][0])
    {
        $request = $this->listMySharesRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listMySharesAsync
     *
     * List My Shares
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listMyShares'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listMySharesAsync(string $contentType = self::contentTypes['listMyShares'][0])
    {
        return $this->listMySharesAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listMySharesAsyncWithHttpInfo
     *
     * List My Shares
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listMyShares'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listMySharesAsyncWithHttpInfo(string $contentType = self::contentTypes['listMyShares'][0])
    {
        $returnType = 'object';
        $request = $this->listMySharesRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listMyShares'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listMyShares'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listMySharesRequest(string $contentType = self::contentTypes['listMyShares'][0])
    {


        $resourcePath = '/api/v2.1/dtables/shared/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listMyUserViewShares
     *
     * List My User View Shares
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listMyUserViewShares'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function listMyUserViewShares(string $contentType = self::contentTypes['listMyUserViewShares'][0])
    {
        list($response) = $this->listMyUserViewSharesWithHttpInfo($contentType);
        return $response;
    }

    /**
     * Operation listMyUserViewSharesWithHttpInfo
     *
     * List My User View Shares
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listMyUserViewShares'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function listMyUserViewSharesWithHttpInfo(string $contentType = self::contentTypes['listMyUserViewShares'][0])
    {
        $request = $this->listMyUserViewSharesRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listMyUserViewSharesAsync
     *
     * List My User View Shares
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listMyUserViewShares'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listMyUserViewSharesAsync(string $contentType = self::contentTypes['listMyUserViewShares'][0])
    {
        return $this->listMyUserViewSharesAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listMyUserViewSharesAsyncWithHttpInfo
     *
     * List My User View Shares
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listMyUserViewShares'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listMyUserViewSharesAsyncWithHttpInfo(string $contentType = self::contentTypes['listMyUserViewShares'][0])
    {
        $returnType = 'object';
        $request = $this->listMyUserViewSharesRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listMyUserViewShares'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listMyUserViewShares'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listMyUserViewSharesRequest(string $contentType = self::contentTypes['listMyUserViewShares'][0])
    {


        $resourcePath = '/api/v2.1/dtables/view-shares-user-shared/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listUserShares
     *
     * List User Shares
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listUserShares'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function listUserShares($workspace_id, $base_name, string $contentType = self::contentTypes['listUserShares'][0])
    {
        list($response) = $this->listUserSharesWithHttpInfo($workspace_id, $base_name, $contentType);
        return $response;
    }

    /**
     * Operation listUserSharesWithHttpInfo
     *
     * List User Shares
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listUserShares'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function listUserSharesWithHttpInfo($workspace_id, $base_name, string $contentType = self::contentTypes['listUserShares'][0])
    {
        $request = $this->listUserSharesRequest($workspace_id, $base_name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listUserSharesAsync
     *
     * List User Shares
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listUserShares'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listUserSharesAsync($workspace_id, $base_name, string $contentType = self::contentTypes['listUserShares'][0])
    {
        return $this->listUserSharesAsyncWithHttpInfo($workspace_id, $base_name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listUserSharesAsyncWithHttpInfo
     *
     * List User Shares
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listUserShares'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listUserSharesAsyncWithHttpInfo($workspace_id, $base_name, string $contentType = self::contentTypes['listUserShares'][0])
    {
        $returnType = 'object';
        $request = $this->listUserSharesRequest($workspace_id, $base_name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listUserShares'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listUserShares'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listUserSharesRequest($workspace_id, $base_name, string $contentType = self::contentTypes['listUserShares'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling listUserShares'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling SharingApi.listUserShares, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling listUserShares'
            );
        }


        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/share/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listUserViewShares
     *
     * List User View Shares
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listUserViewShares'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function listUserViewShares($workspace_id, $base_name, string $contentType = self::contentTypes['listUserViewShares'][0])
    {
        list($response) = $this->listUserViewSharesWithHttpInfo($workspace_id, $base_name, $contentType);
        return $response;
    }

    /**
     * Operation listUserViewSharesWithHttpInfo
     *
     * List User View Shares
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listUserViewShares'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function listUserViewSharesWithHttpInfo($workspace_id, $base_name, string $contentType = self::contentTypes['listUserViewShares'][0])
    {
        $request = $this->listUserViewSharesRequest($workspace_id, $base_name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listUserViewSharesAsync
     *
     * List User View Shares
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listUserViewShares'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listUserViewSharesAsync($workspace_id, $base_name, string $contentType = self::contentTypes['listUserViewShares'][0])
    {
        return $this->listUserViewSharesAsyncWithHttpInfo($workspace_id, $base_name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listUserViewSharesAsyncWithHttpInfo
     *
     * List User View Shares
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listUserViewShares'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listUserViewSharesAsyncWithHttpInfo($workspace_id, $base_name, string $contentType = self::contentTypes['listUserViewShares'][0])
    {
        $returnType = 'object';
        $request = $this->listUserViewSharesRequest($workspace_id, $base_name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listUserViewShares'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listUserViewShares'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listUserViewSharesRequest($workspace_id, $base_name, string $contentType = self::contentTypes['listUserViewShares'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling listUserViewShares'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling SharingApi.listUserViewShares, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling listUserViewShares'
            );
        }


        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/user-view-shares/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateGroupShare
     *
     * Update Group Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $group_id group_id (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateGroupShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function updateGroupShare($workspace_id, $base_name, $group_id, $permission = null, string $contentType = self::contentTypes['updateGroupShare'][0])
    {
        list($response) = $this->updateGroupShareWithHttpInfo($workspace_id, $base_name, $group_id, $permission, $contentType);
        return $response;
    }

    /**
     * Operation updateGroupShareWithHttpInfo
     *
     * Update Group Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $group_id (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateGroupShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateGroupShareWithHttpInfo($workspace_id, $base_name, $group_id, $permission = null, string $contentType = self::contentTypes['updateGroupShare'][0])
    {
        $request = $this->updateGroupShareRequest($workspace_id, $base_name, $group_id, $permission, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateGroupShareAsync
     *
     * Update Group Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $group_id (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateGroupShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateGroupShareAsync($workspace_id, $base_name, $group_id, $permission = null, string $contentType = self::contentTypes['updateGroupShare'][0])
    {
        return $this->updateGroupShareAsyncWithHttpInfo($workspace_id, $base_name, $group_id, $permission, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateGroupShareAsyncWithHttpInfo
     *
     * Update Group Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $group_id (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateGroupShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateGroupShareAsyncWithHttpInfo($workspace_id, $base_name, $group_id, $permission = null, string $contentType = self::contentTypes['updateGroupShare'][0])
    {
        $returnType = 'object';
        $request = $this->updateGroupShareRequest($workspace_id, $base_name, $group_id, $permission, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateGroupShare'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $group_id (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateGroupShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateGroupShareRequest($workspace_id, $base_name, $group_id, $permission = null, string $contentType = self::contentTypes['updateGroupShare'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling updateGroupShare'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling SharingApi.updateGroupShare, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling updateGroupShare'
            );
        }

        // verify the required parameter 'group_id' is set
        if ($group_id === null || (is_array($group_id) && count($group_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_id when calling updateGroupShare'
            );
        }
        if ($group_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$group_id" when calling SharingApi.updateGroupShare, must be bigger than or equal to 1.');
        }
        


        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/group-shares/{group_id}/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }
        // path params
        if ($group_id !== null) {
            $resourcePath = str_replace(
                '{' . 'group_id' . '}',
                ObjectSerializer::toPathValue($group_id),
                $resourcePath
            );
        }

        // form params
        if ($permission !== null) {
            $formParams['permission'] = ObjectSerializer::toFormValue($permission);
        }

        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateGroupViewShare
     *
     * Update Group View Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $group_view_share_id group_view_share_id (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateGroupViewShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function updateGroupViewShare($workspace_id, $base_name, $group_view_share_id, $permission = null, string $contentType = self::contentTypes['updateGroupViewShare'][0])
    {
        list($response) = $this->updateGroupViewShareWithHttpInfo($workspace_id, $base_name, $group_view_share_id, $permission, $contentType);
        return $response;
    }

    /**
     * Operation updateGroupViewShareWithHttpInfo
     *
     * Update Group View Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $group_view_share_id (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateGroupViewShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateGroupViewShareWithHttpInfo($workspace_id, $base_name, $group_view_share_id, $permission = null, string $contentType = self::contentTypes['updateGroupViewShare'][0])
    {
        $request = $this->updateGroupViewShareRequest($workspace_id, $base_name, $group_view_share_id, $permission, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateGroupViewShareAsync
     *
     * Update Group View Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $group_view_share_id (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateGroupViewShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateGroupViewShareAsync($workspace_id, $base_name, $group_view_share_id, $permission = null, string $contentType = self::contentTypes['updateGroupViewShare'][0])
    {
        return $this->updateGroupViewShareAsyncWithHttpInfo($workspace_id, $base_name, $group_view_share_id, $permission, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateGroupViewShareAsyncWithHttpInfo
     *
     * Update Group View Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $group_view_share_id (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateGroupViewShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateGroupViewShareAsyncWithHttpInfo($workspace_id, $base_name, $group_view_share_id, $permission = null, string $contentType = self::contentTypes['updateGroupViewShare'][0])
    {
        $returnType = 'object';
        $request = $this->updateGroupViewShareRequest($workspace_id, $base_name, $group_view_share_id, $permission, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateGroupViewShare'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $group_view_share_id (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateGroupViewShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateGroupViewShareRequest($workspace_id, $base_name, $group_view_share_id, $permission = null, string $contentType = self::contentTypes['updateGroupViewShare'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling updateGroupViewShare'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling SharingApi.updateGroupViewShare, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling updateGroupViewShare'
            );
        }

        // verify the required parameter 'group_view_share_id' is set
        if ($group_view_share_id === null || (is_array($group_view_share_id) && count($group_view_share_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $group_view_share_id when calling updateGroupViewShare'
            );
        }
        if ($group_view_share_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$group_view_share_id" when calling SharingApi.updateGroupViewShare, must be bigger than or equal to 1.');
        }
        


        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/group-view-shares/{group_view_share_id}/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }
        // path params
        if ($group_view_share_id !== null) {
            $resourcePath = str_replace(
                '{' . 'group_view_share_id' . '}',
                ObjectSerializer::toPathValue($group_view_share_id),
                $resourcePath
            );
        }

        // form params
        if ($permission !== null) {
            $formParams['permission'] = ObjectSerializer::toFormValue($permission);
        }

        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateUserShare
     *
     * Update User Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $email The user ID ending with @auth.local (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateUserShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function updateUserShare($workspace_id, $base_name, $permission = null, $email = null, string $contentType = self::contentTypes['updateUserShare'][0])
    {
        list($response) = $this->updateUserShareWithHttpInfo($workspace_id, $base_name, $permission, $email, $contentType);
        return $response;
    }

    /**
     * Operation updateUserShareWithHttpInfo
     *
     * Update User Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $email The user ID ending with @auth.local (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateUserShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateUserShareWithHttpInfo($workspace_id, $base_name, $permission = null, $email = null, string $contentType = self::contentTypes['updateUserShare'][0])
    {
        $request = $this->updateUserShareRequest($workspace_id, $base_name, $permission, $email, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateUserShareAsync
     *
     * Update User Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $email The user ID ending with @auth.local (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateUserShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateUserShareAsync($workspace_id, $base_name, $permission = null, $email = null, string $contentType = self::contentTypes['updateUserShare'][0])
    {
        return $this->updateUserShareAsyncWithHttpInfo($workspace_id, $base_name, $permission, $email, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateUserShareAsyncWithHttpInfo
     *
     * Update User Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $email The user ID ending with @auth.local (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateUserShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateUserShareAsyncWithHttpInfo($workspace_id, $base_name, $permission = null, $email = null, string $contentType = self::contentTypes['updateUserShare'][0])
    {
        $returnType = 'object';
        $request = $this->updateUserShareRequest($workspace_id, $base_name, $permission, $email, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateUserShare'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $email The user ID ending with @auth.local (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateUserShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateUserShareRequest($workspace_id, $base_name, $permission = null, $email = null, string $contentType = self::contentTypes['updateUserShare'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling updateUserShare'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling SharingApi.updateUserShare, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling updateUserShare'
            );
        }




        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/share/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }

        // form params
        if ($permission !== null) {
            $formParams['permission'] = ObjectSerializer::toFormValue($permission);
        }
        // form params
        if ($email !== null) {
            $formParams['email'] = ObjectSerializer::toFormValue($email);
        }

        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateUserViewShare
     *
     * Update User View Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $user_view_share_id user_view_share_id (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateUserViewShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function updateUserViewShare($workspace_id, $base_name, $user_view_share_id, $permission = null, string $contentType = self::contentTypes['updateUserViewShare'][0])
    {
        list($response) = $this->updateUserViewShareWithHttpInfo($workspace_id, $base_name, $user_view_share_id, $permission, $contentType);
        return $response;
    }

    /**
     * Operation updateUserViewShareWithHttpInfo
     *
     * Update User View Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $user_view_share_id (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateUserViewShare'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateUserViewShareWithHttpInfo($workspace_id, $base_name, $user_view_share_id, $permission = null, string $contentType = self::contentTypes['updateUserViewShare'][0])
    {
        $request = $this->updateUserViewShareRequest($workspace_id, $base_name, $user_view_share_id, $permission, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateUserViewShareAsync
     *
     * Update User View Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $user_view_share_id (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateUserViewShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateUserViewShareAsync($workspace_id, $base_name, $user_view_share_id, $permission = null, string $contentType = self::contentTypes['updateUserViewShare'][0])
    {
        return $this->updateUserViewShareAsyncWithHttpInfo($workspace_id, $base_name, $user_view_share_id, $permission, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateUserViewShareAsyncWithHttpInfo
     *
     * Update User View Share
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $user_view_share_id (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateUserViewShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateUserViewShareAsyncWithHttpInfo($workspace_id, $base_name, $user_view_share_id, $permission = null, string $contentType = self::contentTypes['updateUserViewShare'][0])
    {
        $returnType = 'object';
        $request = $this->updateUserViewShareRequest($workspace_id, $base_name, $user_view_share_id, $permission, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateUserViewShare'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $user_view_share_id (required)
     * @param  string $permission &#x60;r&#x60; for read only or &#x60;rw&#x60; for read and write (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateUserViewShare'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateUserViewShareRequest($workspace_id, $base_name, $user_view_share_id, $permission = null, string $contentType = self::contentTypes['updateUserViewShare'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling updateUserViewShare'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling SharingApi.updateUserViewShare, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling updateUserViewShare'
            );
        }

        // verify the required parameter 'user_view_share_id' is set
        if ($user_view_share_id === null || (is_array($user_view_share_id) && count($user_view_share_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_view_share_id when calling updateUserViewShare'
            );
        }
        if ($user_view_share_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$user_view_share_id" when calling SharingApi.updateUserViewShare, must be bigger than or equal to 1.');
        }
        


        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/user-view-shares/{user_view_share_id}/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }
        // path params
        if ($user_view_share_id !== null) {
            $resourcePath = str_replace(
                '{' . 'user_view_share_id' . '}',
                ObjectSerializer::toPathValue($user_view_share_id),
                $resourcePath
            );
        }

        // form params
        if ($permission !== null) {
            $formParams['permission'] = ObjectSerializer::toFormValue($permission);
        }

        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
