<?php
/**
 * ImportExportApi
 * PHP version 7.4
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Account Operations - User
 *
 * The official SeaTable API Reference (OpenAPI 3.0).
 *
 * The version of the OpenAPI document: 5.0
 * Generated by: https://openapi-generator.tech
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SeaTable\Client\User;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use SeaTable\Client\ApiException;
use SeaTable\Client\Configuration;
use SeaTable\Client\HeaderSelector;
use SeaTable\Client\ObjectSerializer;

/**
 * ImportExportApi Class Doc Comment
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ImportExportApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'appendToTableFromFile' => [
            'multipart/form-data',
        ],
        'exportBase' => [
            'application/json',
        ],
        'exportBaseFromExternalLink' => [
            'application/json',
        ],
        'exportBigDataView' => [
            'application/json',
        ],
        'exportTable' => [
            'application/json',
        ],
        'exportView' => [
            'application/json',
        ],
        'importBasefromDTableFile' => [
            'multipart/form-data',
        ],
        'importBasefromFile' => [
            'multipart/form-data',
        ],
        'importTableFromFile' => [
            'multipart/form-data',
        ],
        'updateFromFile' => [
            'multipart/form-data',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation appendToTableFromFile
     *
     * Append Excel CSV
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  \SplFileObject $file file (optional)
     * @param  string $dtable_uuid The UUID of the base. (optional)
     * @param  string $table_name The name of the table. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['appendToTableFromFile'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function appendToTableFromFile($workspace_id, $file = null, $dtable_uuid = null, $table_name = null, string $contentType = self::contentTypes['appendToTableFromFile'][0])
    {
        list($response) = $this->appendToTableFromFileWithHttpInfo($workspace_id, $file, $dtable_uuid, $table_name, $contentType);
        return $response;
    }

    /**
     * Operation appendToTableFromFileWithHttpInfo
     *
     * Append Excel CSV
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  \SplFileObject $file (optional)
     * @param  string $dtable_uuid The UUID of the base. (optional)
     * @param  string $table_name The name of the table. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['appendToTableFromFile'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function appendToTableFromFileWithHttpInfo($workspace_id, $file = null, $dtable_uuid = null, $table_name = null, string $contentType = self::contentTypes['appendToTableFromFile'][0])
    {
        $request = $this->appendToTableFromFileRequest($workspace_id, $file, $dtable_uuid, $table_name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation appendToTableFromFileAsync
     *
     * Append Excel CSV
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  \SplFileObject $file (optional)
     * @param  string $dtable_uuid The UUID of the base. (optional)
     * @param  string $table_name The name of the table. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['appendToTableFromFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function appendToTableFromFileAsync($workspace_id, $file = null, $dtable_uuid = null, $table_name = null, string $contentType = self::contentTypes['appendToTableFromFile'][0])
    {
        return $this->appendToTableFromFileAsyncWithHttpInfo($workspace_id, $file, $dtable_uuid, $table_name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation appendToTableFromFileAsyncWithHttpInfo
     *
     * Append Excel CSV
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  \SplFileObject $file (optional)
     * @param  string $dtable_uuid The UUID of the base. (optional)
     * @param  string $table_name The name of the table. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['appendToTableFromFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function appendToTableFromFileAsyncWithHttpInfo($workspace_id, $file = null, $dtable_uuid = null, $table_name = null, string $contentType = self::contentTypes['appendToTableFromFile'][0])
    {
        $returnType = 'object';
        $request = $this->appendToTableFromFileRequest($workspace_id, $file, $dtable_uuid, $table_name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'appendToTableFromFile'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  \SplFileObject $file (optional)
     * @param  string $dtable_uuid The UUID of the base. (optional)
     * @param  string $table_name The name of the table. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['appendToTableFromFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function appendToTableFromFileRequest($workspace_id, $file = null, $dtable_uuid = null, $table_name = null, string $contentType = self::contentTypes['appendToTableFromFile'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling appendToTableFromFile'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling ImportExportApi.appendToTableFromFile, must be bigger than or equal to 1.');
        }
        




        $resourcePath = '/api/v2.1/workspace/{workspace_id}/synchronous-import/append-excel-csv-to-table/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }

        // form params
        if ($file !== null) {
            $multipart = true;
            $formParams['file'] = [];
            $paramFiles = is_array($file) ? $file : [$file];
            foreach ($paramFiles as $paramFile) {
                $formParams['file'][] = \GuzzleHttp\Psr7\Utils::tryFopen(
                    ObjectSerializer::toFormValue($paramFile),
                    'rb'
                );
            }
        }
        // form params
        if ($dtable_uuid !== null) {
            $formParams['dtable_uuid'] = ObjectSerializer::toFormValue($dtable_uuid);
        }
        // form params
        if ($table_name !== null) {
            $formParams['table_name'] = ObjectSerializer::toFormValue($table_name);
        }

        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation exportBase
     *
     * Export Base
     *
     * @param  string $dtable_name dtable_name (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $password The password of your Base. (optional)
     * @param  bool $ignore_asset Set this to &#x60;true&#x60; to export the base without assets. Default is &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportBase'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function exportBase($dtable_name, $workspace_id, $password = null, $ignore_asset = null, string $contentType = self::contentTypes['exportBase'][0])
    {
        $this->exportBaseWithHttpInfo($dtable_name, $workspace_id, $password, $ignore_asset, $contentType);
    }

    /**
     * Operation exportBaseWithHttpInfo
     *
     * Export Base
     *
     * @param  string $dtable_name (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $password The password of your Base. (optional)
     * @param  bool $ignore_asset Set this to &#x60;true&#x60; to export the base without assets. Default is &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportBase'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function exportBaseWithHttpInfo($dtable_name, $workspace_id, $password = null, $ignore_asset = null, string $contentType = self::contentTypes['exportBase'][0])
    {
        $request = $this->exportBaseRequest($dtable_name, $workspace_id, $password, $ignore_asset, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation exportBaseAsync
     *
     * Export Base
     *
     * @param  string $dtable_name (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $password The password of your Base. (optional)
     * @param  bool $ignore_asset Set this to &#x60;true&#x60; to export the base without assets. Default is &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportBase'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function exportBaseAsync($dtable_name, $workspace_id, $password = null, $ignore_asset = null, string $contentType = self::contentTypes['exportBase'][0])
    {
        return $this->exportBaseAsyncWithHttpInfo($dtable_name, $workspace_id, $password, $ignore_asset, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation exportBaseAsyncWithHttpInfo
     *
     * Export Base
     *
     * @param  string $dtable_name (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $password The password of your Base. (optional)
     * @param  bool $ignore_asset Set this to &#x60;true&#x60; to export the base without assets. Default is &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportBase'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function exportBaseAsyncWithHttpInfo($dtable_name, $workspace_id, $password = null, $ignore_asset = null, string $contentType = self::contentTypes['exportBase'][0])
    {
        $returnType = '';
        $request = $this->exportBaseRequest($dtable_name, $workspace_id, $password, $ignore_asset, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'exportBase'
     *
     * @param  string $dtable_name (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $password The password of your Base. (optional)
     * @param  bool $ignore_asset Set this to &#x60;true&#x60; to export the base without assets. Default is &#x60;false&#x60;. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportBase'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function exportBaseRequest($dtable_name, $workspace_id, $password = null, $ignore_asset = null, string $contentType = self::contentTypes['exportBase'][0])
    {

        // verify the required parameter 'dtable_name' is set
        if ($dtable_name === null || (is_array($dtable_name) && count($dtable_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dtable_name when calling exportBase'
            );
        }

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling exportBase'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling ImportExportApi.exportBase, must be bigger than or equal to 1.');
        }
        



        $resourcePath = '/api/v2.1/workspace/{workspace_id}/synchronous-export/export-dtable/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $dtable_name,
            'dtable_name', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $password,
            'password', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $ignore_asset,
            'ignore_asset', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation exportBaseFromExternalLink
     *
     * Export Base from External Link
     *
     * @param  string $external_link_token external_link_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportBaseFromExternalLink'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function exportBaseFromExternalLink($external_link_token, string $contentType = self::contentTypes['exportBaseFromExternalLink'][0])
    {
        $this->exportBaseFromExternalLinkWithHttpInfo($external_link_token, $contentType);
    }

    /**
     * Operation exportBaseFromExternalLinkWithHttpInfo
     *
     * Export Base from External Link
     *
     * @param  string $external_link_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportBaseFromExternalLink'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function exportBaseFromExternalLinkWithHttpInfo($external_link_token, string $contentType = self::contentTypes['exportBaseFromExternalLink'][0])
    {
        $request = $this->exportBaseFromExternalLinkRequest($external_link_token, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation exportBaseFromExternalLinkAsync
     *
     * Export Base from External Link
     *
     * @param  string $external_link_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportBaseFromExternalLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function exportBaseFromExternalLinkAsync($external_link_token, string $contentType = self::contentTypes['exportBaseFromExternalLink'][0])
    {
        return $this->exportBaseFromExternalLinkAsyncWithHttpInfo($external_link_token, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation exportBaseFromExternalLinkAsyncWithHttpInfo
     *
     * Export Base from External Link
     *
     * @param  string $external_link_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportBaseFromExternalLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function exportBaseFromExternalLinkAsyncWithHttpInfo($external_link_token, string $contentType = self::contentTypes['exportBaseFromExternalLink'][0])
    {
        $returnType = '';
        $request = $this->exportBaseFromExternalLinkRequest($external_link_token, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'exportBaseFromExternalLink'
     *
     * @param  string $external_link_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportBaseFromExternalLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function exportBaseFromExternalLinkRequest($external_link_token, string $contentType = self::contentTypes['exportBaseFromExternalLink'][0])
    {

        // verify the required parameter 'external_link_token' is set
        if ($external_link_token === null || (is_array($external_link_token) && count($external_link_token) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $external_link_token when calling exportBaseFromExternalLink'
            );
        }


        $resourcePath = '/dtable/external-links/{external_link_token}/download-zip/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($external_link_token !== null) {
            $resourcePath = str_replace(
                '{' . 'external_link_token' . '}',
                ObjectSerializer::toPathValue($external_link_token),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation exportBigDataView
     *
     * Export Big Data View to Excel
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $view_id id of view, string (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportBigDataView'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function exportBigDataView($workspace_id, $base_name, $table_id, $view_id, string $contentType = self::contentTypes['exportBigDataView'][0])
    {
        $this->exportBigDataViewWithHttpInfo($workspace_id, $base_name, $table_id, $view_id, $contentType);
    }

    /**
     * Operation exportBigDataViewWithHttpInfo
     *
     * Export Big Data View to Excel
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $view_id id of view, string (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportBigDataView'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function exportBigDataViewWithHttpInfo($workspace_id, $base_name, $table_id, $view_id, string $contentType = self::contentTypes['exportBigDataView'][0])
    {
        $request = $this->exportBigDataViewRequest($workspace_id, $base_name, $table_id, $view_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation exportBigDataViewAsync
     *
     * Export Big Data View to Excel
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $view_id id of view, string (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportBigDataView'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function exportBigDataViewAsync($workspace_id, $base_name, $table_id, $view_id, string $contentType = self::contentTypes['exportBigDataView'][0])
    {
        return $this->exportBigDataViewAsyncWithHttpInfo($workspace_id, $base_name, $table_id, $view_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation exportBigDataViewAsyncWithHttpInfo
     *
     * Export Big Data View to Excel
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $view_id id of view, string (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportBigDataView'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function exportBigDataViewAsyncWithHttpInfo($workspace_id, $base_name, $table_id, $view_id, string $contentType = self::contentTypes['exportBigDataView'][0])
    {
        $returnType = '';
        $request = $this->exportBigDataViewRequest($workspace_id, $base_name, $table_id, $view_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'exportBigDataView'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $view_id id of view, string (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportBigDataView'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function exportBigDataViewRequest($workspace_id, $base_name, $table_id, $view_id, string $contentType = self::contentTypes['exportBigDataView'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling exportBigDataView'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling ImportExportApi.exportBigDataView, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling exportBigDataView'
            );
        }

        // verify the required parameter 'table_id' is set
        if ($table_id === null || (is_array($table_id) && count($table_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id when calling exportBigDataView'
            );
        }
        if (!preg_match("/^[A-Za-z0-9]{4}$/", $table_id)) {
            throw new \InvalidArgumentException("invalid value for \"table_id\" when calling ImportExportApi.exportBigDataView, must conform to the pattern /^[A-Za-z0-9]{4}$/.");
        }
        
        // verify the required parameter 'view_id' is set
        if ($view_id === null || (is_array($view_id) && count($view_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $view_id when calling exportBigDataView'
            );
        }


        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/convert-big-data-view-to-excel/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $table_id,
            'table_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $view_id,
            'view_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation exportTable
     *
     * Export Table
     *
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $table_name The name of the table. (required)
     * @param  string $dtable_name dtable_name (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportTable'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function exportTable($table_id, $table_name, $dtable_name, $workspace_id, string $contentType = self::contentTypes['exportTable'][0])
    {
        $this->exportTableWithHttpInfo($table_id, $table_name, $dtable_name, $workspace_id, $contentType);
    }

    /**
     * Operation exportTableWithHttpInfo
     *
     * Export Table
     *
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $table_name The name of the table. (required)
     * @param  string $dtable_name (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportTable'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function exportTableWithHttpInfo($table_id, $table_name, $dtable_name, $workspace_id, string $contentType = self::contentTypes['exportTable'][0])
    {
        $request = $this->exportTableRequest($table_id, $table_name, $dtable_name, $workspace_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation exportTableAsync
     *
     * Export Table
     *
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $table_name The name of the table. (required)
     * @param  string $dtable_name (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function exportTableAsync($table_id, $table_name, $dtable_name, $workspace_id, string $contentType = self::contentTypes['exportTable'][0])
    {
        return $this->exportTableAsyncWithHttpInfo($table_id, $table_name, $dtable_name, $workspace_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation exportTableAsyncWithHttpInfo
     *
     * Export Table
     *
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $table_name The name of the table. (required)
     * @param  string $dtable_name (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function exportTableAsyncWithHttpInfo($table_id, $table_name, $dtable_name, $workspace_id, string $contentType = self::contentTypes['exportTable'][0])
    {
        $returnType = '';
        $request = $this->exportTableRequest($table_id, $table_name, $dtable_name, $workspace_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'exportTable'
     *
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $table_name The name of the table. (required)
     * @param  string $dtable_name (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportTable'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function exportTableRequest($table_id, $table_name, $dtable_name, $workspace_id, string $contentType = self::contentTypes['exportTable'][0])
    {

        // verify the required parameter 'table_id' is set
        if ($table_id === null || (is_array($table_id) && count($table_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id when calling exportTable'
            );
        }
        if (!preg_match("/^[A-Za-z0-9]{4}$/", $table_id)) {
            throw new \InvalidArgumentException("invalid value for \"table_id\" when calling ImportExportApi.exportTable, must conform to the pattern /^[A-Za-z0-9]{4}$/.");
        }
        
        // verify the required parameter 'table_name' is set
        if ($table_name === null || (is_array($table_name) && count($table_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_name when calling exportTable'
            );
        }

        // verify the required parameter 'dtable_name' is set
        if ($dtable_name === null || (is_array($dtable_name) && count($dtable_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dtable_name when calling exportTable'
            );
        }

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling exportTable'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling ImportExportApi.exportTable, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v2.1/workspace/{workspace_id}/synchronous-export/export-table-to-excel/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $table_id,
            'table_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $table_name,
            'table_name', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $dtable_name,
            'dtable_name', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation exportView
     *
     * Export View
     *
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $table_name The name of the table. (required)
     * @param  string $dtable_name dtable_name (required)
     * @param  string $view_id id of view, string (required)
     * @param  string $view_name name of view, required, string (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportView'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function exportView($table_id, $table_name, $dtable_name, $view_id, $view_name, $workspace_id, string $contentType = self::contentTypes['exportView'][0])
    {
        $this->exportViewWithHttpInfo($table_id, $table_name, $dtable_name, $view_id, $view_name, $workspace_id, $contentType);
    }

    /**
     * Operation exportViewWithHttpInfo
     *
     * Export View
     *
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $table_name The name of the table. (required)
     * @param  string $dtable_name (required)
     * @param  string $view_id id of view, string (required)
     * @param  string $view_name name of view, required, string (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportView'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function exportViewWithHttpInfo($table_id, $table_name, $dtable_name, $view_id, $view_name, $workspace_id, string $contentType = self::contentTypes['exportView'][0])
    {
        $request = $this->exportViewRequest($table_id, $table_name, $dtable_name, $view_id, $view_name, $workspace_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation exportViewAsync
     *
     * Export View
     *
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $table_name The name of the table. (required)
     * @param  string $dtable_name (required)
     * @param  string $view_id id of view, string (required)
     * @param  string $view_name name of view, required, string (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportView'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function exportViewAsync($table_id, $table_name, $dtable_name, $view_id, $view_name, $workspace_id, string $contentType = self::contentTypes['exportView'][0])
    {
        return $this->exportViewAsyncWithHttpInfo($table_id, $table_name, $dtable_name, $view_id, $view_name, $workspace_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation exportViewAsyncWithHttpInfo
     *
     * Export View
     *
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $table_name The name of the table. (required)
     * @param  string $dtable_name (required)
     * @param  string $view_id id of view, string (required)
     * @param  string $view_name name of view, required, string (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportView'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function exportViewAsyncWithHttpInfo($table_id, $table_name, $dtable_name, $view_id, $view_name, $workspace_id, string $contentType = self::contentTypes['exportView'][0])
    {
        $returnType = '';
        $request = $this->exportViewRequest($table_id, $table_name, $dtable_name, $view_id, $view_name, $workspace_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'exportView'
     *
     * @param  string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. **Important: the table_id is not the table_name**. (required)
     * @param  string $table_name The name of the table. (required)
     * @param  string $dtable_name (required)
     * @param  string $view_id id of view, string (required)
     * @param  string $view_name name of view, required, string (required)
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['exportView'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function exportViewRequest($table_id, $table_name, $dtable_name, $view_id, $view_name, $workspace_id, string $contentType = self::contentTypes['exportView'][0])
    {

        // verify the required parameter 'table_id' is set
        if ($table_id === null || (is_array($table_id) && count($table_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_id when calling exportView'
            );
        }
        if (!preg_match("/^[A-Za-z0-9]{4}$/", $table_id)) {
            throw new \InvalidArgumentException("invalid value for \"table_id\" when calling ImportExportApi.exportView, must conform to the pattern /^[A-Za-z0-9]{4}$/.");
        }
        
        // verify the required parameter 'table_name' is set
        if ($table_name === null || (is_array($table_name) && count($table_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $table_name when calling exportView'
            );
        }

        // verify the required parameter 'dtable_name' is set
        if ($dtable_name === null || (is_array($dtable_name) && count($dtable_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dtable_name when calling exportView'
            );
        }

        // verify the required parameter 'view_id' is set
        if ($view_id === null || (is_array($view_id) && count($view_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $view_id when calling exportView'
            );
        }

        // verify the required parameter 'view_name' is set
        if ($view_name === null || (is_array($view_name) && count($view_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $view_name when calling exportView'
            );
        }
        if (!preg_match("/^[a-z0-9]{4}$/", $view_name)) {
            throw new \InvalidArgumentException("invalid value for \"view_name\" when calling ImportExportApi.exportView, must conform to the pattern /^[a-z0-9]{4}$/.");
        }
        
        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling exportView'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling ImportExportApi.exportView, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v2.1/workspace/{workspace_id}/synchronous-export/export-view-to-excel/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $table_id,
            'table_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $table_name,
            'table_name', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $dtable_name,
            'dtable_name', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $view_id,
            'view_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $view_name,
            'view_name', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation importBasefromDTableFile
     *
     * Import Base from dtable file
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  \SplFileObject $dtable dtable (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importBasefromDTableFile'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \SeaTable\Client\User\ImportBasefromDTableFile200Response
     */
    public function importBasefromDTableFile($workspace_id, $dtable = null, string $contentType = self::contentTypes['importBasefromDTableFile'][0])
    {
        list($response) = $this->importBasefromDTableFileWithHttpInfo($workspace_id, $dtable, $contentType);
        return $response;
    }

    /**
     * Operation importBasefromDTableFileWithHttpInfo
     *
     * Import Base from dtable file
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  \SplFileObject $dtable (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importBasefromDTableFile'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \SeaTable\Client\User\ImportBasefromDTableFile200Response, HTTP status code, HTTP response headers (array of strings)
     */
    public function importBasefromDTableFileWithHttpInfo($workspace_id, $dtable = null, string $contentType = self::contentTypes['importBasefromDTableFile'][0])
    {
        $request = $this->importBasefromDTableFileRequest($workspace_id, $dtable, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\SeaTable\Client\User\ImportBasefromDTableFile200Response' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\SeaTable\Client\User\ImportBasefromDTableFile200Response' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\SeaTable\Client\User\ImportBasefromDTableFile200Response', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\SeaTable\Client\User\ImportBasefromDTableFile200Response';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\SeaTable\Client\User\ImportBasefromDTableFile200Response',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation importBasefromDTableFileAsync
     *
     * Import Base from dtable file
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  \SplFileObject $dtable (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importBasefromDTableFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function importBasefromDTableFileAsync($workspace_id, $dtable = null, string $contentType = self::contentTypes['importBasefromDTableFile'][0])
    {
        return $this->importBasefromDTableFileAsyncWithHttpInfo($workspace_id, $dtable, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation importBasefromDTableFileAsyncWithHttpInfo
     *
     * Import Base from dtable file
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  \SplFileObject $dtable (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importBasefromDTableFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function importBasefromDTableFileAsyncWithHttpInfo($workspace_id, $dtable = null, string $contentType = self::contentTypes['importBasefromDTableFile'][0])
    {
        $returnType = '\SeaTable\Client\User\ImportBasefromDTableFile200Response';
        $request = $this->importBasefromDTableFileRequest($workspace_id, $dtable, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'importBasefromDTableFile'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  \SplFileObject $dtable (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importBasefromDTableFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function importBasefromDTableFileRequest($workspace_id, $dtable = null, string $contentType = self::contentTypes['importBasefromDTableFile'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling importBasefromDTableFile'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling ImportExportApi.importBasefromDTableFile, must be bigger than or equal to 1.');
        }
        


        $resourcePath = '/api/v2.1/workspace/{workspace_id}/import-dtable/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }

        // form params
        if ($dtable !== null) {
            $multipart = true;
            $formParams['dtable'] = [];
            $paramFiles = is_array($dtable) ? $dtable : [$dtable];
            foreach ($paramFiles as $paramFile) {
                $formParams['dtable'][] = \GuzzleHttp\Psr7\Utils::tryFopen(
                    ObjectSerializer::toFormValue($paramFile),
                    'rb'
                );
            }
        }

        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation importBasefromFile
     *
     * Import Base from xlsx or csv
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  \SplFileObject $dtable dtable (optional)
     * @param  string $folder If you would like to create the base into a folder, give its &#x60;folder_id&#x60; here. A base is created in the root folder by default. Optional. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importBasefromFile'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function importBasefromFile($workspace_id, $dtable = null, $folder = null, string $contentType = self::contentTypes['importBasefromFile'][0])
    {
        list($response) = $this->importBasefromFileWithHttpInfo($workspace_id, $dtable, $folder, $contentType);
        return $response;
    }

    /**
     * Operation importBasefromFileWithHttpInfo
     *
     * Import Base from xlsx or csv
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  \SplFileObject $dtable (optional)
     * @param  string $folder If you would like to create the base into a folder, give its &#x60;folder_id&#x60; here. A base is created in the root folder by default. Optional. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importBasefromFile'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function importBasefromFileWithHttpInfo($workspace_id, $dtable = null, $folder = null, string $contentType = self::contentTypes['importBasefromFile'][0])
    {
        $request = $this->importBasefromFileRequest($workspace_id, $dtable, $folder, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation importBasefromFileAsync
     *
     * Import Base from xlsx or csv
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  \SplFileObject $dtable (optional)
     * @param  string $folder If you would like to create the base into a folder, give its &#x60;folder_id&#x60; here. A base is created in the root folder by default. Optional. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importBasefromFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function importBasefromFileAsync($workspace_id, $dtable = null, $folder = null, string $contentType = self::contentTypes['importBasefromFile'][0])
    {
        return $this->importBasefromFileAsyncWithHttpInfo($workspace_id, $dtable, $folder, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation importBasefromFileAsyncWithHttpInfo
     *
     * Import Base from xlsx or csv
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  \SplFileObject $dtable (optional)
     * @param  string $folder If you would like to create the base into a folder, give its &#x60;folder_id&#x60; here. A base is created in the root folder by default. Optional. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importBasefromFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function importBasefromFileAsyncWithHttpInfo($workspace_id, $dtable = null, $folder = null, string $contentType = self::contentTypes['importBasefromFile'][0])
    {
        $returnType = 'object';
        $request = $this->importBasefromFileRequest($workspace_id, $dtable, $folder, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'importBasefromFile'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  \SplFileObject $dtable (optional)
     * @param  string $folder If you would like to create the base into a folder, give its &#x60;folder_id&#x60; here. A base is created in the root folder by default. Optional. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importBasefromFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function importBasefromFileRequest($workspace_id, $dtable = null, $folder = null, string $contentType = self::contentTypes['importBasefromFile'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling importBasefromFile'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling ImportExportApi.importBasefromFile, must be bigger than or equal to 1.');
        }
        



        $resourcePath = '/api/v2.1/workspace/{workspace_id}/synchronous-import/import-excel-csv-to-base/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }

        // form params
        if ($dtable !== null) {
            $multipart = true;
            $formParams['dtable'] = [];
            $paramFiles = is_array($dtable) ? $dtable : [$dtable];
            foreach ($paramFiles as $paramFile) {
                $formParams['dtable'][] = \GuzzleHttp\Psr7\Utils::tryFopen(
                    ObjectSerializer::toFormValue($paramFile),
                    'rb'
                );
            }
        }
        // form params
        if ($folder !== null) {
            $formParams['folder'] = ObjectSerializer::toFormValue($folder);
        }

        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation importTableFromFile
     *
     * Import Table from xlsx or csv
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  \SplFileObject $file file (optional)
     * @param  string $dtable_uuid The UUID of the base. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importTableFromFile'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function importTableFromFile($workspace_id, $file = null, $dtable_uuid = null, string $contentType = self::contentTypes['importTableFromFile'][0])
    {
        list($response) = $this->importTableFromFileWithHttpInfo($workspace_id, $file, $dtable_uuid, $contentType);
        return $response;
    }

    /**
     * Operation importTableFromFileWithHttpInfo
     *
     * Import Table from xlsx or csv
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  \SplFileObject $file (optional)
     * @param  string $dtable_uuid The UUID of the base. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importTableFromFile'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function importTableFromFileWithHttpInfo($workspace_id, $file = null, $dtable_uuid = null, string $contentType = self::contentTypes['importTableFromFile'][0])
    {
        $request = $this->importTableFromFileRequest($workspace_id, $file, $dtable_uuid, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation importTableFromFileAsync
     *
     * Import Table from xlsx or csv
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  \SplFileObject $file (optional)
     * @param  string $dtable_uuid The UUID of the base. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importTableFromFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function importTableFromFileAsync($workspace_id, $file = null, $dtable_uuid = null, string $contentType = self::contentTypes['importTableFromFile'][0])
    {
        return $this->importTableFromFileAsyncWithHttpInfo($workspace_id, $file, $dtable_uuid, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation importTableFromFileAsyncWithHttpInfo
     *
     * Import Table from xlsx or csv
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  \SplFileObject $file (optional)
     * @param  string $dtable_uuid The UUID of the base. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importTableFromFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function importTableFromFileAsyncWithHttpInfo($workspace_id, $file = null, $dtable_uuid = null, string $contentType = self::contentTypes['importTableFromFile'][0])
    {
        $returnType = 'object';
        $request = $this->importTableFromFileRequest($workspace_id, $file, $dtable_uuid, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'importTableFromFile'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  \SplFileObject $file (optional)
     * @param  string $dtable_uuid The UUID of the base. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importTableFromFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function importTableFromFileRequest($workspace_id, $file = null, $dtable_uuid = null, string $contentType = self::contentTypes['importTableFromFile'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling importTableFromFile'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling ImportExportApi.importTableFromFile, must be bigger than or equal to 1.');
        }
        



        $resourcePath = '/api/v2.1/workspace/{workspace_id}/synchronous-import/import-excel-csv-to-table/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }

        // form params
        if ($file !== null) {
            $multipart = true;
            $formParams['file'] = [];
            $paramFiles = is_array($file) ? $file : [$file];
            foreach ($paramFiles as $paramFile) {
                $formParams['file'][] = \GuzzleHttp\Psr7\Utils::tryFopen(
                    ObjectSerializer::toFormValue($paramFile),
                    'rb'
                );
            }
        }
        // form params
        if ($dtable_uuid !== null) {
            $formParams['dtable_uuid'] = ObjectSerializer::toFormValue($dtable_uuid);
        }

        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateFromFile
     *
     * Update from xlsx or csv
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  \SplFileObject $file file (optional)
     * @param  string $dtable_uuid The UUID of the base. (optional)
     * @param  string $table_name The name of the table. (optional)
     * @param  string $selected_columns The columns to update. Use comma (,) to separate column names. Required. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateFromFile'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function updateFromFile($workspace_id, $file = null, $dtable_uuid = null, $table_name = null, $selected_columns = null, string $contentType = self::contentTypes['updateFromFile'][0])
    {
        list($response) = $this->updateFromFileWithHttpInfo($workspace_id, $file, $dtable_uuid, $table_name, $selected_columns, $contentType);
        return $response;
    }

    /**
     * Operation updateFromFileWithHttpInfo
     *
     * Update from xlsx or csv
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  \SplFileObject $file (optional)
     * @param  string $dtable_uuid The UUID of the base. (optional)
     * @param  string $table_name The name of the table. (optional)
     * @param  string $selected_columns The columns to update. Use comma (,) to separate column names. Required. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateFromFile'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateFromFileWithHttpInfo($workspace_id, $file = null, $dtable_uuid = null, $table_name = null, $selected_columns = null, string $contentType = self::contentTypes['updateFromFile'][0])
    {
        $request = $this->updateFromFileRequest($workspace_id, $file, $dtable_uuid, $table_name, $selected_columns, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateFromFileAsync
     *
     * Update from xlsx or csv
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  \SplFileObject $file (optional)
     * @param  string $dtable_uuid The UUID of the base. (optional)
     * @param  string $table_name The name of the table. (optional)
     * @param  string $selected_columns The columns to update. Use comma (,) to separate column names. Required. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateFromFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateFromFileAsync($workspace_id, $file = null, $dtable_uuid = null, $table_name = null, $selected_columns = null, string $contentType = self::contentTypes['updateFromFile'][0])
    {
        return $this->updateFromFileAsyncWithHttpInfo($workspace_id, $file, $dtable_uuid, $table_name, $selected_columns, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateFromFileAsyncWithHttpInfo
     *
     * Update from xlsx or csv
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  \SplFileObject $file (optional)
     * @param  string $dtable_uuid The UUID of the base. (optional)
     * @param  string $table_name The name of the table. (optional)
     * @param  string $selected_columns The columns to update. Use comma (,) to separate column names. Required. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateFromFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateFromFileAsyncWithHttpInfo($workspace_id, $file = null, $dtable_uuid = null, $table_name = null, $selected_columns = null, string $contentType = self::contentTypes['updateFromFile'][0])
    {
        $returnType = 'object';
        $request = $this->updateFromFileRequest($workspace_id, $file, $dtable_uuid, $table_name, $selected_columns, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateFromFile'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  \SplFileObject $file (optional)
     * @param  string $dtable_uuid The UUID of the base. (optional)
     * @param  string $table_name The name of the table. (optional)
     * @param  string $selected_columns The columns to update. Use comma (,) to separate column names. Required. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateFromFile'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateFromFileRequest($workspace_id, $file = null, $dtable_uuid = null, $table_name = null, $selected_columns = null, string $contentType = self::contentTypes['updateFromFile'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling updateFromFile'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling ImportExportApi.updateFromFile, must be bigger than or equal to 1.');
        }
        





        $resourcePath = '/api/v2.1/workspace/{workspace_id}/synchronous-import/update-table-via-excel-csv/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }

        // form params
        if ($file !== null) {
            $multipart = true;
            $formParams['file'] = [];
            $paramFiles = is_array($file) ? $file : [$file];
            foreach ($paramFiles as $paramFile) {
                $formParams['file'][] = \GuzzleHttp\Psr7\Utils::tryFopen(
                    ObjectSerializer::toFormValue($paramFile),
                    'rb'
                );
            }
        }
        // form params
        if ($dtable_uuid !== null) {
            $formParams['dtable_uuid'] = ObjectSerializer::toFormValue($dtable_uuid);
        }
        // form params
        if ($table_name !== null) {
            $formParams['table_name'] = ObjectSerializer::toFormValue($table_name);
        }
        // form params
        if ($selected_columns !== null) {
            $formParams['selected_columns'] = ObjectSerializer::toFormValue($selected_columns);
        }

        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
