<?php
/**
 * CommonDatasetApi
 * PHP version 7.4
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Account Operations - User
 *
 * The official SeaTable API Reference (OpenAPI 3.0).
 *
 * The version of the OpenAPI document: 5.0
 * Generated by: https://openapi-generator.tech
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SeaTable\Client\User;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use SeaTable\Client\ApiException;
use SeaTable\Client\Configuration;
use SeaTable\Client\HeaderSelector;
use SeaTable\Client\ObjectSerializer;

/**
 * CommonDatasetApi Class Doc Comment
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class CommonDatasetApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'deleteCommonDataset' => [
            'application/json',
        ],
        'getCommonDataset' => [
            'application/json',
        ],
        'getCommonDatasetInfo' => [
            'application/json',
        ],
        'importCommonDataset' => [
            'multipart/form-data',
        ],
        'listCommonDataset' => [
            'application/json',
        ],
        'listSyncHistory' => [
            'application/json',
        ],
        'publishCommonDataset' => [
            'application/x-www-form-urlencoded',
        ],
        'renameCommonDataset' => [
            'multipart/form-data',
        ],
        'syncCommonDataset' => [
            'multipart/form-data',
        ],
        'updateCommonDatasetSync' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation deleteCommonDataset
     *
     * Delete Common Dataset
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCommonDataset'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function deleteCommonDataset($dataset_id, string $contentType = self::contentTypes['deleteCommonDataset'][0])
    {
        list($response) = $this->deleteCommonDatasetWithHttpInfo($dataset_id, $contentType);
        return $response;
    }

    /**
     * Operation deleteCommonDatasetWithHttpInfo
     *
     * Delete Common Dataset
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCommonDataset'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCommonDatasetWithHttpInfo($dataset_id, string $contentType = self::contentTypes['deleteCommonDataset'][0])
    {
        $request = $this->deleteCommonDatasetRequest($dataset_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteCommonDatasetAsync
     *
     * Delete Common Dataset
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCommonDataset'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteCommonDatasetAsync($dataset_id, string $contentType = self::contentTypes['deleteCommonDataset'][0])
    {
        return $this->deleteCommonDatasetAsyncWithHttpInfo($dataset_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteCommonDatasetAsyncWithHttpInfo
     *
     * Delete Common Dataset
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCommonDataset'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteCommonDatasetAsyncWithHttpInfo($dataset_id, string $contentType = self::contentTypes['deleteCommonDataset'][0])
    {
        $returnType = 'object';
        $request = $this->deleteCommonDatasetRequest($dataset_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteCommonDataset'
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteCommonDataset'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteCommonDatasetRequest($dataset_id, string $contentType = self::contentTypes['deleteCommonDataset'][0])
    {

        // verify the required parameter 'dataset_id' is set
        if ($dataset_id === null || (is_array($dataset_id) && count($dataset_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dataset_id when calling deleteCommonDataset'
            );
        }
        if ($dataset_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$dataset_id" when calling CommonDatasetApi.deleteCommonDataset, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v2.1/dtable/common-datasets/{dataset_id}/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($dataset_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dataset_id' . '}',
                ObjectSerializer::toPathValue($dataset_id),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCommonDataset
     *
     * Get Common Dataset
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCommonDataset'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function getCommonDataset($dataset_id, string $contentType = self::contentTypes['getCommonDataset'][0])
    {
        list($response) = $this->getCommonDatasetWithHttpInfo($dataset_id, $contentType);
        return $response;
    }

    /**
     * Operation getCommonDatasetWithHttpInfo
     *
     * Get Common Dataset
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCommonDataset'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCommonDatasetWithHttpInfo($dataset_id, string $contentType = self::contentTypes['getCommonDataset'][0])
    {
        $request = $this->getCommonDatasetRequest($dataset_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getCommonDatasetAsync
     *
     * Get Common Dataset
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCommonDataset'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCommonDatasetAsync($dataset_id, string $contentType = self::contentTypes['getCommonDataset'][0])
    {
        return $this->getCommonDatasetAsyncWithHttpInfo($dataset_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCommonDatasetAsyncWithHttpInfo
     *
     * Get Common Dataset
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCommonDataset'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCommonDatasetAsyncWithHttpInfo($dataset_id, string $contentType = self::contentTypes['getCommonDataset'][0])
    {
        $returnType = 'object';
        $request = $this->getCommonDatasetRequest($dataset_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCommonDataset'
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCommonDataset'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCommonDatasetRequest($dataset_id, string $contentType = self::contentTypes['getCommonDataset'][0])
    {

        // verify the required parameter 'dataset_id' is set
        if ($dataset_id === null || (is_array($dataset_id) && count($dataset_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dataset_id when calling getCommonDataset'
            );
        }
        if ($dataset_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$dataset_id" when calling CommonDatasetApi.getCommonDataset, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v2.1/dtable/common-datasets/{dataset_id}/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($dataset_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dataset_id' . '}',
                ObjectSerializer::toPathValue($dataset_id),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getCommonDatasetInfo
     *
     * Get Common Dataset Info
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCommonDatasetInfo'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function getCommonDatasetInfo($dataset_id, string $contentType = self::contentTypes['getCommonDatasetInfo'][0])
    {
        list($response) = $this->getCommonDatasetInfoWithHttpInfo($dataset_id, $contentType);
        return $response;
    }

    /**
     * Operation getCommonDatasetInfoWithHttpInfo
     *
     * Get Common Dataset Info
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCommonDatasetInfo'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCommonDatasetInfoWithHttpInfo($dataset_id, string $contentType = self::contentTypes['getCommonDatasetInfo'][0])
    {
        $request = $this->getCommonDatasetInfoRequest($dataset_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getCommonDatasetInfoAsync
     *
     * Get Common Dataset Info
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCommonDatasetInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCommonDatasetInfoAsync($dataset_id, string $contentType = self::contentTypes['getCommonDatasetInfo'][0])
    {
        return $this->getCommonDatasetInfoAsyncWithHttpInfo($dataset_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCommonDatasetInfoAsyncWithHttpInfo
     *
     * Get Common Dataset Info
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCommonDatasetInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCommonDatasetInfoAsyncWithHttpInfo($dataset_id, string $contentType = self::contentTypes['getCommonDatasetInfo'][0])
    {
        $returnType = 'object';
        $request = $this->getCommonDatasetInfoRequest($dataset_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getCommonDatasetInfo'
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getCommonDatasetInfo'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCommonDatasetInfoRequest($dataset_id, string $contentType = self::contentTypes['getCommonDatasetInfo'][0])
    {

        // verify the required parameter 'dataset_id' is set
        if ($dataset_id === null || (is_array($dataset_id) && count($dataset_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dataset_id when calling getCommonDatasetInfo'
            );
        }
        if ($dataset_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$dataset_id" when calling CommonDatasetApi.getCommonDatasetInfo, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v2.1/dtable/common-datasets/{dataset_id}/info/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($dataset_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dataset_id' . '}',
                ObjectSerializer::toPathValue($dataset_id),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation importCommonDataset
     *
     * Import Common Dataset
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $dst_dtable_uuid The name of the base. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importCommonDataset'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function importCommonDataset($dataset_id, $dst_dtable_uuid = null, string $contentType = self::contentTypes['importCommonDataset'][0])
    {
        list($response) = $this->importCommonDatasetWithHttpInfo($dataset_id, $dst_dtable_uuid, $contentType);
        return $response;
    }

    /**
     * Operation importCommonDatasetWithHttpInfo
     *
     * Import Common Dataset
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $dst_dtable_uuid The name of the base. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importCommonDataset'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function importCommonDatasetWithHttpInfo($dataset_id, $dst_dtable_uuid = null, string $contentType = self::contentTypes['importCommonDataset'][0])
    {
        $request = $this->importCommonDatasetRequest($dataset_id, $dst_dtable_uuid, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation importCommonDatasetAsync
     *
     * Import Common Dataset
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $dst_dtable_uuid The name of the base. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importCommonDataset'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function importCommonDatasetAsync($dataset_id, $dst_dtable_uuid = null, string $contentType = self::contentTypes['importCommonDataset'][0])
    {
        return $this->importCommonDatasetAsyncWithHttpInfo($dataset_id, $dst_dtable_uuid, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation importCommonDatasetAsyncWithHttpInfo
     *
     * Import Common Dataset
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $dst_dtable_uuid The name of the base. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importCommonDataset'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function importCommonDatasetAsyncWithHttpInfo($dataset_id, $dst_dtable_uuid = null, string $contentType = self::contentTypes['importCommonDataset'][0])
    {
        $returnType = 'object';
        $request = $this->importCommonDatasetRequest($dataset_id, $dst_dtable_uuid, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'importCommonDataset'
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $dst_dtable_uuid The name of the base. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importCommonDataset'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function importCommonDatasetRequest($dataset_id, $dst_dtable_uuid = null, string $contentType = self::contentTypes['importCommonDataset'][0])
    {

        // verify the required parameter 'dataset_id' is set
        if ($dataset_id === null || (is_array($dataset_id) && count($dataset_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dataset_id when calling importCommonDataset'
            );
        }
        if ($dataset_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$dataset_id" when calling CommonDatasetApi.importCommonDataset, must be bigger than or equal to 1.');
        }
        


        $resourcePath = '/api/v2.1/dtable/common-datasets/{dataset_id}/import/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($dataset_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dataset_id' . '}',
                ObjectSerializer::toPathValue($dataset_id),
                $resourcePath
            );
        }

        // form params
        if ($dst_dtable_uuid !== null) {
            $formParams['dst_dtable_uuid'] = ObjectSerializer::toFormValue($dst_dtable_uuid);
        }

        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listCommonDataset
     *
     * List Common Datasets
     *
     * @param  string $dtable_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  bool $by_group Whether return the list of datasets by groups when dtable_uuid is not given, default false, optional (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listCommonDataset'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function listCommonDataset($dtable_uuid, $by_group = null, string $contentType = self::contentTypes['listCommonDataset'][0])
    {
        list($response) = $this->listCommonDatasetWithHttpInfo($dtable_uuid, $by_group, $contentType);
        return $response;
    }

    /**
     * Operation listCommonDatasetWithHttpInfo
     *
     * List Common Datasets
     *
     * @param  string $dtable_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  bool $by_group Whether return the list of datasets by groups when dtable_uuid is not given, default false, optional (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listCommonDataset'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function listCommonDatasetWithHttpInfo($dtable_uuid, $by_group = null, string $contentType = self::contentTypes['listCommonDataset'][0])
    {
        $request = $this->listCommonDatasetRequest($dtable_uuid, $by_group, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listCommonDatasetAsync
     *
     * List Common Datasets
     *
     * @param  string $dtable_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  bool $by_group Whether return the list of datasets by groups when dtable_uuid is not given, default false, optional (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listCommonDataset'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listCommonDatasetAsync($dtable_uuid, $by_group = null, string $contentType = self::contentTypes['listCommonDataset'][0])
    {
        return $this->listCommonDatasetAsyncWithHttpInfo($dtable_uuid, $by_group, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listCommonDatasetAsyncWithHttpInfo
     *
     * List Common Datasets
     *
     * @param  string $dtable_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  bool $by_group Whether return the list of datasets by groups when dtable_uuid is not given, default false, optional (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listCommonDataset'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listCommonDatasetAsyncWithHttpInfo($dtable_uuid, $by_group = null, string $contentType = self::contentTypes['listCommonDataset'][0])
    {
        $returnType = 'object';
        $request = $this->listCommonDatasetRequest($dtable_uuid, $by_group, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listCommonDataset'
     *
     * @param  string $dtable_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  bool $by_group Whether return the list of datasets by groups when dtable_uuid is not given, default false, optional (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listCommonDataset'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listCommonDatasetRequest($dtable_uuid, $by_group = null, string $contentType = self::contentTypes['listCommonDataset'][0])
    {

        // verify the required parameter 'dtable_uuid' is set
        if ($dtable_uuid === null || (is_array($dtable_uuid) && count($dtable_uuid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dtable_uuid when calling listCommonDataset'
            );
        }
        if (!preg_match("/^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/", $dtable_uuid)) {
            throw new \InvalidArgumentException("invalid value for \"dtable_uuid\" when calling CommonDatasetApi.listCommonDataset, must conform to the pattern /^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/.");
        }
        


        $resourcePath = '/api/v2.1/dtable/common-datasets/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $dtable_uuid,
            'dtable_uuid', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $by_group,
            'by_group', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listSyncHistory
     *
     * List Sync History
     *
     * @param  string $dtable_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listSyncHistory'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function listSyncHistory($dtable_uuid, string $contentType = self::contentTypes['listSyncHistory'][0])
    {
        list($response) = $this->listSyncHistoryWithHttpInfo($dtable_uuid, $contentType);
        return $response;
    }

    /**
     * Operation listSyncHistoryWithHttpInfo
     *
     * List Sync History
     *
     * @param  string $dtable_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listSyncHistory'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function listSyncHistoryWithHttpInfo($dtable_uuid, string $contentType = self::contentTypes['listSyncHistory'][0])
    {
        $request = $this->listSyncHistoryRequest($dtable_uuid, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listSyncHistoryAsync
     *
     * List Sync History
     *
     * @param  string $dtable_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listSyncHistory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listSyncHistoryAsync($dtable_uuid, string $contentType = self::contentTypes['listSyncHistory'][0])
    {
        return $this->listSyncHistoryAsyncWithHttpInfo($dtable_uuid, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listSyncHistoryAsyncWithHttpInfo
     *
     * List Sync History
     *
     * @param  string $dtable_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listSyncHistory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listSyncHistoryAsyncWithHttpInfo($dtable_uuid, string $contentType = self::contentTypes['listSyncHistory'][0])
    {
        $returnType = 'object';
        $request = $this->listSyncHistoryRequest($dtable_uuid, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listSyncHistory'
     *
     * @param  string $dtable_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listSyncHistory'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listSyncHistoryRequest($dtable_uuid, string $contentType = self::contentTypes['listSyncHistory'][0])
    {

        // verify the required parameter 'dtable_uuid' is set
        if ($dtable_uuid === null || (is_array($dtable_uuid) && count($dtable_uuid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dtable_uuid when calling listSyncHistory'
            );
        }
        if (!preg_match("/^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/", $dtable_uuid)) {
            throw new \InvalidArgumentException("invalid value for \"dtable_uuid\" when calling CommonDatasetApi.listSyncHistory, must conform to the pattern /^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/.");
        }
        

        $resourcePath = '/api/v2.1/dtable/common-datasets/syncs/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $dtable_uuid,
            'dtable_uuid', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);




        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation publishCommonDataset
     *
     * Publish Common Dataset
     *
     * @param  string $dataset_name The name of the common dataset. (optional)
     * @param  string $workspace_id The workspace ID where your base is. (optional)
     * @param  string $dtable_name The name of the base. (optional)
     * @param  string $table_name The name of the table. (optional)
     * @param  string $view_name The name of the view (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['publishCommonDataset'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function publishCommonDataset($dataset_name = null, $workspace_id = null, $dtable_name = null, $table_name = null, $view_name = null, string $contentType = self::contentTypes['publishCommonDataset'][0])
    {
        list($response) = $this->publishCommonDatasetWithHttpInfo($dataset_name, $workspace_id, $dtable_name, $table_name, $view_name, $contentType);
        return $response;
    }

    /**
     * Operation publishCommonDatasetWithHttpInfo
     *
     * Publish Common Dataset
     *
     * @param  string $dataset_name The name of the common dataset. (optional)
     * @param  string $workspace_id The workspace ID where your base is. (optional)
     * @param  string $dtable_name The name of the base. (optional)
     * @param  string $table_name The name of the table. (optional)
     * @param  string $view_name The name of the view (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['publishCommonDataset'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function publishCommonDatasetWithHttpInfo($dataset_name = null, $workspace_id = null, $dtable_name = null, $table_name = null, $view_name = null, string $contentType = self::contentTypes['publishCommonDataset'][0])
    {
        $request = $this->publishCommonDatasetRequest($dataset_name, $workspace_id, $dtable_name, $table_name, $view_name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation publishCommonDatasetAsync
     *
     * Publish Common Dataset
     *
     * @param  string $dataset_name The name of the common dataset. (optional)
     * @param  string $workspace_id The workspace ID where your base is. (optional)
     * @param  string $dtable_name The name of the base. (optional)
     * @param  string $table_name The name of the table. (optional)
     * @param  string $view_name The name of the view (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['publishCommonDataset'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function publishCommonDatasetAsync($dataset_name = null, $workspace_id = null, $dtable_name = null, $table_name = null, $view_name = null, string $contentType = self::contentTypes['publishCommonDataset'][0])
    {
        return $this->publishCommonDatasetAsyncWithHttpInfo($dataset_name, $workspace_id, $dtable_name, $table_name, $view_name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation publishCommonDatasetAsyncWithHttpInfo
     *
     * Publish Common Dataset
     *
     * @param  string $dataset_name The name of the common dataset. (optional)
     * @param  string $workspace_id The workspace ID where your base is. (optional)
     * @param  string $dtable_name The name of the base. (optional)
     * @param  string $table_name The name of the table. (optional)
     * @param  string $view_name The name of the view (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['publishCommonDataset'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function publishCommonDatasetAsyncWithHttpInfo($dataset_name = null, $workspace_id = null, $dtable_name = null, $table_name = null, $view_name = null, string $contentType = self::contentTypes['publishCommonDataset'][0])
    {
        $returnType = 'object';
        $request = $this->publishCommonDatasetRequest($dataset_name, $workspace_id, $dtable_name, $table_name, $view_name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'publishCommonDataset'
     *
     * @param  string $dataset_name The name of the common dataset. (optional)
     * @param  string $workspace_id The workspace ID where your base is. (optional)
     * @param  string $dtable_name The name of the base. (optional)
     * @param  string $table_name The name of the table. (optional)
     * @param  string $view_name The name of the view (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['publishCommonDataset'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function publishCommonDatasetRequest($dataset_name = null, $workspace_id = null, $dtable_name = null, $table_name = null, $view_name = null, string $contentType = self::contentTypes['publishCommonDataset'][0])
    {







        $resourcePath = '/api/v2.1/dtable/common-datasets/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;




        // form params
        if ($dataset_name !== null) {
            $formParams['dataset_name'] = ObjectSerializer::toFormValue($dataset_name);
        }
        // form params
        if ($workspace_id !== null) {
            $formParams['workspace_id'] = ObjectSerializer::toFormValue($workspace_id);
        }
        // form params
        if ($dtable_name !== null) {
            $formParams['dtable_name'] = ObjectSerializer::toFormValue($dtable_name);
        }
        // form params
        if ($table_name !== null) {
            $formParams['table_name'] = ObjectSerializer::toFormValue($table_name);
        }
        // form params
        if ($view_name !== null) {
            $formParams['view_name'] = ObjectSerializer::toFormValue($view_name);
        }

        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation renameCommonDataset
     *
     * Rename Common Dataset
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $dataset_name The name of the common dataset. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['renameCommonDataset'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function renameCommonDataset($dataset_id, $dataset_name = null, string $contentType = self::contentTypes['renameCommonDataset'][0])
    {
        list($response) = $this->renameCommonDatasetWithHttpInfo($dataset_id, $dataset_name, $contentType);
        return $response;
    }

    /**
     * Operation renameCommonDatasetWithHttpInfo
     *
     * Rename Common Dataset
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $dataset_name The name of the common dataset. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['renameCommonDataset'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function renameCommonDatasetWithHttpInfo($dataset_id, $dataset_name = null, string $contentType = self::contentTypes['renameCommonDataset'][0])
    {
        $request = $this->renameCommonDatasetRequest($dataset_id, $dataset_name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation renameCommonDatasetAsync
     *
     * Rename Common Dataset
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $dataset_name The name of the common dataset. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['renameCommonDataset'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function renameCommonDatasetAsync($dataset_id, $dataset_name = null, string $contentType = self::contentTypes['renameCommonDataset'][0])
    {
        return $this->renameCommonDatasetAsyncWithHttpInfo($dataset_id, $dataset_name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation renameCommonDatasetAsyncWithHttpInfo
     *
     * Rename Common Dataset
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $dataset_name The name of the common dataset. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['renameCommonDataset'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function renameCommonDatasetAsyncWithHttpInfo($dataset_id, $dataset_name = null, string $contentType = self::contentTypes['renameCommonDataset'][0])
    {
        $returnType = 'object';
        $request = $this->renameCommonDatasetRequest($dataset_id, $dataset_name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'renameCommonDataset'
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $dataset_name The name of the common dataset. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['renameCommonDataset'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function renameCommonDatasetRequest($dataset_id, $dataset_name = null, string $contentType = self::contentTypes['renameCommonDataset'][0])
    {

        // verify the required parameter 'dataset_id' is set
        if ($dataset_id === null || (is_array($dataset_id) && count($dataset_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dataset_id when calling renameCommonDataset'
            );
        }
        if ($dataset_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$dataset_id" when calling CommonDatasetApi.renameCommonDataset, must be bigger than or equal to 1.');
        }
        


        $resourcePath = '/api/v2.1/dtable/common-datasets/{dataset_id}/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($dataset_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dataset_id' . '}',
                ObjectSerializer::toPathValue($dataset_id),
                $resourcePath
            );
        }

        // form params
        if ($dataset_name !== null) {
            $formParams['dataset_name'] = ObjectSerializer::toFormValue($dataset_name);
        }

        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation syncCommonDataset
     *
     * Sync Common Dataset
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $dst_dtable_uuid The UUID of the destination base. (optional)
     * @param  bool $is_sync is_sync (optional)
     * @param  string $dst_table_id dst_table_id (optional)
     * @param  string $dst_view_id dst_view_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syncCommonDataset'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function syncCommonDataset($dataset_id, $dst_dtable_uuid = null, $is_sync = null, $dst_table_id = null, $dst_view_id = null, string $contentType = self::contentTypes['syncCommonDataset'][0])
    {
        $this->syncCommonDatasetWithHttpInfo($dataset_id, $dst_dtable_uuid, $is_sync, $dst_table_id, $dst_view_id, $contentType);
    }

    /**
     * Operation syncCommonDatasetWithHttpInfo
     *
     * Sync Common Dataset
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $dst_dtable_uuid The UUID of the destination base. (optional)
     * @param  bool $is_sync (optional)
     * @param  string $dst_table_id (optional)
     * @param  string $dst_view_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syncCommonDataset'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function syncCommonDatasetWithHttpInfo($dataset_id, $dst_dtable_uuid = null, $is_sync = null, $dst_table_id = null, $dst_view_id = null, string $contentType = self::contentTypes['syncCommonDataset'][0])
    {
        $request = $this->syncCommonDatasetRequest($dataset_id, $dst_dtable_uuid, $is_sync, $dst_table_id, $dst_view_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation syncCommonDatasetAsync
     *
     * Sync Common Dataset
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $dst_dtable_uuid The UUID of the destination base. (optional)
     * @param  bool $is_sync (optional)
     * @param  string $dst_table_id (optional)
     * @param  string $dst_view_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syncCommonDataset'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function syncCommonDatasetAsync($dataset_id, $dst_dtable_uuid = null, $is_sync = null, $dst_table_id = null, $dst_view_id = null, string $contentType = self::contentTypes['syncCommonDataset'][0])
    {
        return $this->syncCommonDatasetAsyncWithHttpInfo($dataset_id, $dst_dtable_uuid, $is_sync, $dst_table_id, $dst_view_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation syncCommonDatasetAsyncWithHttpInfo
     *
     * Sync Common Dataset
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $dst_dtable_uuid The UUID of the destination base. (optional)
     * @param  bool $is_sync (optional)
     * @param  string $dst_table_id (optional)
     * @param  string $dst_view_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syncCommonDataset'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function syncCommonDatasetAsyncWithHttpInfo($dataset_id, $dst_dtable_uuid = null, $is_sync = null, $dst_table_id = null, $dst_view_id = null, string $contentType = self::contentTypes['syncCommonDataset'][0])
    {
        $returnType = '';
        $request = $this->syncCommonDatasetRequest($dataset_id, $dst_dtable_uuid, $is_sync, $dst_table_id, $dst_view_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'syncCommonDataset'
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  string $dst_dtable_uuid The UUID of the destination base. (optional)
     * @param  bool $is_sync (optional)
     * @param  string $dst_table_id (optional)
     * @param  string $dst_view_id (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['syncCommonDataset'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function syncCommonDatasetRequest($dataset_id, $dst_dtable_uuid = null, $is_sync = null, $dst_table_id = null, $dst_view_id = null, string $contentType = self::contentTypes['syncCommonDataset'][0])
    {

        // verify the required parameter 'dataset_id' is set
        if ($dataset_id === null || (is_array($dataset_id) && count($dataset_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dataset_id when calling syncCommonDataset'
            );
        }
        if ($dataset_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$dataset_id" when calling CommonDatasetApi.syncCommonDataset, must be bigger than or equal to 1.');
        }
        





        $resourcePath = '/api/v2.1/dtable/common-datasets/{dataset_id}/sync/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($dataset_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dataset_id' . '}',
                ObjectSerializer::toPathValue($dataset_id),
                $resourcePath
            );
        }

        // form params
        if ($dst_dtable_uuid !== null) {
            $formParams['dst_dtable_uuid'] = ObjectSerializer::toFormValue($dst_dtable_uuid);
        }
        // form params
        if ($is_sync !== null) {
            $formParams['is_sync'] = ObjectSerializer::toFormValue($is_sync);
        }
        // form params
        if ($dst_table_id !== null) {
            $formParams['dst_table_id'] = ObjectSerializer::toFormValue($dst_table_id);
        }
        // form params
        if ($dst_view_id !== null) {
            $formParams['dst_view_id'] = ObjectSerializer::toFormValue($dst_view_id);
        }

        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateCommonDatasetSync
     *
     * Update Common Dataset Sync
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  \SeaTable\Client\User\UpdateCommonDatasetSyncRequest $update_common_dataset_sync_request update_common_dataset_sync_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCommonDatasetSync'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function updateCommonDatasetSync($dataset_id, $update_common_dataset_sync_request = null, string $contentType = self::contentTypes['updateCommonDatasetSync'][0])
    {
        list($response) = $this->updateCommonDatasetSyncWithHttpInfo($dataset_id, $update_common_dataset_sync_request, $contentType);
        return $response;
    }

    /**
     * Operation updateCommonDatasetSyncWithHttpInfo
     *
     * Update Common Dataset Sync
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  \SeaTable\Client\User\UpdateCommonDatasetSyncRequest $update_common_dataset_sync_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCommonDatasetSync'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateCommonDatasetSyncWithHttpInfo($dataset_id, $update_common_dataset_sync_request = null, string $contentType = self::contentTypes['updateCommonDatasetSync'][0])
    {
        $request = $this->updateCommonDatasetSyncRequest($dataset_id, $update_common_dataset_sync_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateCommonDatasetSyncAsync
     *
     * Update Common Dataset Sync
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  \SeaTable\Client\User\UpdateCommonDatasetSyncRequest $update_common_dataset_sync_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCommonDatasetSync'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateCommonDatasetSyncAsync($dataset_id, $update_common_dataset_sync_request = null, string $contentType = self::contentTypes['updateCommonDatasetSync'][0])
    {
        return $this->updateCommonDatasetSyncAsyncWithHttpInfo($dataset_id, $update_common_dataset_sync_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateCommonDatasetSyncAsyncWithHttpInfo
     *
     * Update Common Dataset Sync
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  \SeaTable\Client\User\UpdateCommonDatasetSyncRequest $update_common_dataset_sync_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCommonDatasetSync'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateCommonDatasetSyncAsyncWithHttpInfo($dataset_id, $update_common_dataset_sync_request = null, string $contentType = self::contentTypes['updateCommonDatasetSync'][0])
    {
        $returnType = 'object';
        $request = $this->updateCommonDatasetSyncRequest($dataset_id, $update_common_dataset_sync_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateCommonDatasetSync'
     *
     * @param  int $dataset_id The ID of the common dataset. When you e.g. publish a common dataset from a view, the returned &#x60;id&#x60; is what you need here. (required)
     * @param  \SeaTable\Client\User\UpdateCommonDatasetSyncRequest $update_common_dataset_sync_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateCommonDatasetSync'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateCommonDatasetSyncRequest($dataset_id, $update_common_dataset_sync_request = null, string $contentType = self::contentTypes['updateCommonDatasetSync'][0])
    {

        // verify the required parameter 'dataset_id' is set
        if ($dataset_id === null || (is_array($dataset_id) && count($dataset_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dataset_id when calling updateCommonDatasetSync'
            );
        }
        if ($dataset_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$dataset_id" when calling CommonDatasetApi.updateCommonDatasetSync, must be bigger than or equal to 1.');
        }
        


        $resourcePath = '/api/v2.1/dtable/common-datasets/{dataset_id}/sync/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($dataset_id !== null) {
            $resourcePath = str_replace(
                '{' . 'dataset_id' . '}',
                ObjectSerializer::toPathValue($dataset_id),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($update_common_dataset_sync_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($update_common_dataset_sync_request));
            } else {
                $httpBody = $update_common_dataset_sync_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
