<?php
/**
 * AutomationsApi
 * PHP version 7.4
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Account Operations - User
 *
 * The official SeaTable API Reference (OpenAPI 3.0).
 *
 * The version of the OpenAPI document: 5.0
 * Generated by: https://openapi-generator.tech
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SeaTable\Client\User;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use SeaTable\Client\ApiException;
use SeaTable\Client\Configuration;
use SeaTable\Client\HeaderSelector;
use SeaTable\Client\ObjectSerializer;

/**
 * AutomationsApi Class Doc Comment
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class AutomationsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createAutomationRule' => [
            'application/json',
        ],
        'deleteAutomationRule' => [
            'application/json',
        ],
        'listAutomationRules' => [
            'application/json',
        ],
        'updateAutomationRule' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createAutomationRule
     *
     * Create Automation Rule
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  \SeaTable\Client\User\CreateAutomationRuleRequest $create_automation_rule_request create_automation_rule_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createAutomationRule'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function createAutomationRule($workspace_id, $base_name, $create_automation_rule_request = null, string $contentType = self::contentTypes['createAutomationRule'][0])
    {
        list($response) = $this->createAutomationRuleWithHttpInfo($workspace_id, $base_name, $create_automation_rule_request, $contentType);
        return $response;
    }

    /**
     * Operation createAutomationRuleWithHttpInfo
     *
     * Create Automation Rule
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  \SeaTable\Client\User\CreateAutomationRuleRequest $create_automation_rule_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createAutomationRule'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function createAutomationRuleWithHttpInfo($workspace_id, $base_name, $create_automation_rule_request = null, string $contentType = self::contentTypes['createAutomationRule'][0])
    {
        $request = $this->createAutomationRuleRequest($workspace_id, $base_name, $create_automation_rule_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createAutomationRuleAsync
     *
     * Create Automation Rule
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  \SeaTable\Client\User\CreateAutomationRuleRequest $create_automation_rule_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createAutomationRule'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAutomationRuleAsync($workspace_id, $base_name, $create_automation_rule_request = null, string $contentType = self::contentTypes['createAutomationRule'][0])
    {
        return $this->createAutomationRuleAsyncWithHttpInfo($workspace_id, $base_name, $create_automation_rule_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createAutomationRuleAsyncWithHttpInfo
     *
     * Create Automation Rule
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  \SeaTable\Client\User\CreateAutomationRuleRequest $create_automation_rule_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createAutomationRule'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createAutomationRuleAsyncWithHttpInfo($workspace_id, $base_name, $create_automation_rule_request = null, string $contentType = self::contentTypes['createAutomationRule'][0])
    {
        $returnType = 'object';
        $request = $this->createAutomationRuleRequest($workspace_id, $base_name, $create_automation_rule_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createAutomationRule'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  \SeaTable\Client\User\CreateAutomationRuleRequest $create_automation_rule_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createAutomationRule'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createAutomationRuleRequest($workspace_id, $base_name, $create_automation_rule_request = null, string $contentType = self::contentTypes['createAutomationRule'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling createAutomationRule'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling AutomationsApi.createAutomationRule, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling createAutomationRule'
            );
        }



        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/automation-rules/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($create_automation_rule_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_automation_rule_request));
            } else {
                $httpBody = $create_automation_rule_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteAutomationRule
     *
     * Delete Automation Rule
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $automation_rule_id automation_rule_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAutomationRule'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function deleteAutomationRule($workspace_id, $base_name, $automation_rule_id, string $contentType = self::contentTypes['deleteAutomationRule'][0])
    {
        list($response) = $this->deleteAutomationRuleWithHttpInfo($workspace_id, $base_name, $automation_rule_id, $contentType);
        return $response;
    }

    /**
     * Operation deleteAutomationRuleWithHttpInfo
     *
     * Delete Automation Rule
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $automation_rule_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAutomationRule'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteAutomationRuleWithHttpInfo($workspace_id, $base_name, $automation_rule_id, string $contentType = self::contentTypes['deleteAutomationRule'][0])
    {
        $request = $this->deleteAutomationRuleRequest($workspace_id, $base_name, $automation_rule_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteAutomationRuleAsync
     *
     * Delete Automation Rule
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $automation_rule_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAutomationRule'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteAutomationRuleAsync($workspace_id, $base_name, $automation_rule_id, string $contentType = self::contentTypes['deleteAutomationRule'][0])
    {
        return $this->deleteAutomationRuleAsyncWithHttpInfo($workspace_id, $base_name, $automation_rule_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteAutomationRuleAsyncWithHttpInfo
     *
     * Delete Automation Rule
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $automation_rule_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAutomationRule'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteAutomationRuleAsyncWithHttpInfo($workspace_id, $base_name, $automation_rule_id, string $contentType = self::contentTypes['deleteAutomationRule'][0])
    {
        $returnType = 'object';
        $request = $this->deleteAutomationRuleRequest($workspace_id, $base_name, $automation_rule_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteAutomationRule'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $automation_rule_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteAutomationRule'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteAutomationRuleRequest($workspace_id, $base_name, $automation_rule_id, string $contentType = self::contentTypes['deleteAutomationRule'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling deleteAutomationRule'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling AutomationsApi.deleteAutomationRule, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling deleteAutomationRule'
            );
        }

        // verify the required parameter 'automation_rule_id' is set
        if ($automation_rule_id === null || (is_array($automation_rule_id) && count($automation_rule_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $automation_rule_id when calling deleteAutomationRule'
            );
        }
        if ($automation_rule_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$automation_rule_id" when calling AutomationsApi.deleteAutomationRule, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/automation-rules/{automation_rule_id}/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }
        // path params
        if ($automation_rule_id !== null) {
            $resourcePath = str_replace(
                '{' . 'automation_rule_id' . '}',
                ObjectSerializer::toPathValue($automation_rule_id),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listAutomationRules
     *
     * List Automation Rules
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listAutomationRules'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function listAutomationRules($workspace_id, $base_name, string $contentType = self::contentTypes['listAutomationRules'][0])
    {
        list($response) = $this->listAutomationRulesWithHttpInfo($workspace_id, $base_name, $contentType);
        return $response;
    }

    /**
     * Operation listAutomationRulesWithHttpInfo
     *
     * List Automation Rules
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listAutomationRules'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function listAutomationRulesWithHttpInfo($workspace_id, $base_name, string $contentType = self::contentTypes['listAutomationRules'][0])
    {
        $request = $this->listAutomationRulesRequest($workspace_id, $base_name, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listAutomationRulesAsync
     *
     * List Automation Rules
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listAutomationRules'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listAutomationRulesAsync($workspace_id, $base_name, string $contentType = self::contentTypes['listAutomationRules'][0])
    {
        return $this->listAutomationRulesAsyncWithHttpInfo($workspace_id, $base_name, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listAutomationRulesAsyncWithHttpInfo
     *
     * List Automation Rules
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listAutomationRules'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listAutomationRulesAsyncWithHttpInfo($workspace_id, $base_name, string $contentType = self::contentTypes['listAutomationRules'][0])
    {
        $returnType = 'object';
        $request = $this->listAutomationRulesRequest($workspace_id, $base_name, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listAutomationRules'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listAutomationRules'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listAutomationRulesRequest($workspace_id, $base_name, string $contentType = self::contentTypes['listAutomationRules'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling listAutomationRules'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling AutomationsApi.listAutomationRules, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling listAutomationRules'
            );
        }


        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/automation-rules/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateAutomationRule
     *
     * Update Automation Rule
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $automation_rule_id automation_rule_id (required)
     * @param  \SeaTable\Client\User\CreateAutomationRuleRequest $create_automation_rule_request create_automation_rule_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateAutomationRule'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function updateAutomationRule($workspace_id, $base_name, $automation_rule_id, $create_automation_rule_request = null, string $contentType = self::contentTypes['updateAutomationRule'][0])
    {
        list($response) = $this->updateAutomationRuleWithHttpInfo($workspace_id, $base_name, $automation_rule_id, $create_automation_rule_request, $contentType);
        return $response;
    }

    /**
     * Operation updateAutomationRuleWithHttpInfo
     *
     * Update Automation Rule
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $automation_rule_id (required)
     * @param  \SeaTable\Client\User\CreateAutomationRuleRequest $create_automation_rule_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateAutomationRule'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateAutomationRuleWithHttpInfo($workspace_id, $base_name, $automation_rule_id, $create_automation_rule_request = null, string $contentType = self::contentTypes['updateAutomationRule'][0])
    {
        $request = $this->updateAutomationRuleRequest($workspace_id, $base_name, $automation_rule_id, $create_automation_rule_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateAutomationRuleAsync
     *
     * Update Automation Rule
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $automation_rule_id (required)
     * @param  \SeaTable\Client\User\CreateAutomationRuleRequest $create_automation_rule_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateAutomationRule'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateAutomationRuleAsync($workspace_id, $base_name, $automation_rule_id, $create_automation_rule_request = null, string $contentType = self::contentTypes['updateAutomationRule'][0])
    {
        return $this->updateAutomationRuleAsyncWithHttpInfo($workspace_id, $base_name, $automation_rule_id, $create_automation_rule_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateAutomationRuleAsyncWithHttpInfo
     *
     * Update Automation Rule
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $automation_rule_id (required)
     * @param  \SeaTable\Client\User\CreateAutomationRuleRequest $create_automation_rule_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateAutomationRule'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateAutomationRuleAsyncWithHttpInfo($workspace_id, $base_name, $automation_rule_id, $create_automation_rule_request = null, string $contentType = self::contentTypes['updateAutomationRule'][0])
    {
        $returnType = 'object';
        $request = $this->updateAutomationRuleRequest($workspace_id, $base_name, $automation_rule_id, $create_automation_rule_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateAutomationRule'
     *
     * @param  int $workspace_id id of your workspace. (required)
     * @param  string $base_name name of your base. (required)
     * @param  int $automation_rule_id (required)
     * @param  \SeaTable\Client\User\CreateAutomationRuleRequest $create_automation_rule_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateAutomationRule'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateAutomationRuleRequest($workspace_id, $base_name, $automation_rule_id, $create_automation_rule_request = null, string $contentType = self::contentTypes['updateAutomationRule'][0])
    {

        // verify the required parameter 'workspace_id' is set
        if ($workspace_id === null || (is_array($workspace_id) && count($workspace_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $workspace_id when calling updateAutomationRule'
            );
        }
        if ($workspace_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$workspace_id" when calling AutomationsApi.updateAutomationRule, must be bigger than or equal to 1.');
        }
        
        // verify the required parameter 'base_name' is set
        if ($base_name === null || (is_array($base_name) && count($base_name) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_name when calling updateAutomationRule'
            );
        }

        // verify the required parameter 'automation_rule_id' is set
        if ($automation_rule_id === null || (is_array($automation_rule_id) && count($automation_rule_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $automation_rule_id when calling updateAutomationRule'
            );
        }
        if ($automation_rule_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$automation_rule_id" when calling AutomationsApi.updateAutomationRule, must be bigger than or equal to 1.');
        }
        


        $resourcePath = '/api/v2.1/workspace/{workspace_id}/dtable/{base_name}/automation-rules/{automation_rule_id}/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($workspace_id !== null) {
            $resourcePath = str_replace(
                '{' . 'workspace_id' . '}',
                ObjectSerializer::toPathValue($workspace_id),
                $resourcePath
            );
        }
        // path params
        if ($base_name !== null) {
            $resourcePath = str_replace(
                '{' . 'base_name' . '}',
                ObjectSerializer::toPathValue($base_name),
                $resourcePath
            );
        }
        // path params
        if ($automation_rule_id !== null) {
            $resourcePath = str_replace(
                '{' . 'automation_rule_id' . '}',
                ObjectSerializer::toPathValue($automation_rule_id),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($create_automation_rule_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($create_automation_rule_request));
            } else {
                $httpBody = $create_automation_rule_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
