<?php
/**
 * AppsApi
 * PHP version 7.4
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Account Operations - User
 *
 * The official SeaTable API Reference (OpenAPI 3.0).
 *
 * The version of the OpenAPI document: 5.0
 * Generated by: https://openapi-generator.tech
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SeaTable\Client\User;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use SeaTable\Client\ApiException;
use SeaTable\Client\Configuration;
use SeaTable\Client\HeaderSelector;
use SeaTable\Client\ObjectSerializer;

/**
 * AppsApi Class Doc Comment
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class AppsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'changeAppStatus' => [
            'application/json',
        ],
        'importUsersToApp' => [
            'application/json',
        ],
        'listAppInviteLinks' => [
            'application/json',
        ],
        'listApps' => [
            'application/json',
        ],
        'listUniversalAppUsers' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation changeAppStatus
     *
     * Change App Status
     *
     * @param  string $app_token app_token (required)
     * @param  \SeaTable\Client\User\IsInactive $is_inactive is_inactive (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['changeAppStatus'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function changeAppStatus($app_token, $is_inactive = null, string $contentType = self::contentTypes['changeAppStatus'][0])
    {
        $this->changeAppStatusWithHttpInfo($app_token, $is_inactive, $contentType);
    }

    /**
     * Operation changeAppStatusWithHttpInfo
     *
     * Change App Status
     *
     * @param  string $app_token (required)
     * @param  \SeaTable\Client\User\IsInactive $is_inactive (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['changeAppStatus'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function changeAppStatusWithHttpInfo($app_token, $is_inactive = null, string $contentType = self::contentTypes['changeAppStatus'][0])
    {
        $request = $this->changeAppStatusRequest($app_token, $is_inactive, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation changeAppStatusAsync
     *
     * Change App Status
     *
     * @param  string $app_token (required)
     * @param  \SeaTable\Client\User\IsInactive $is_inactive (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['changeAppStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function changeAppStatusAsync($app_token, $is_inactive = null, string $contentType = self::contentTypes['changeAppStatus'][0])
    {
        return $this->changeAppStatusAsyncWithHttpInfo($app_token, $is_inactive, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation changeAppStatusAsyncWithHttpInfo
     *
     * Change App Status
     *
     * @param  string $app_token (required)
     * @param  \SeaTable\Client\User\IsInactive $is_inactive (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['changeAppStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function changeAppStatusAsyncWithHttpInfo($app_token, $is_inactive = null, string $contentType = self::contentTypes['changeAppStatus'][0])
    {
        $returnType = '';
        $request = $this->changeAppStatusRequest($app_token, $is_inactive, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'changeAppStatus'
     *
     * @param  string $app_token (required)
     * @param  \SeaTable\Client\User\IsInactive $is_inactive (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['changeAppStatus'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function changeAppStatusRequest($app_token, $is_inactive = null, string $contentType = self::contentTypes['changeAppStatus'][0])
    {

        // verify the required parameter 'app_token' is set
        if ($app_token === null || (is_array($app_token) && count($app_token) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_token when calling changeAppStatus'
            );
        }
        if (!preg_match("/^[0-9a-f]{8}-([a-f1-9]{4}-){3}[a-f0-9]{12}$/", $app_token)) {
            throw new \InvalidArgumentException("invalid value for \"app_token\" when calling AppsApi.changeAppStatus, must conform to the pattern /^[0-9a-f]{8}-([a-f1-9]{4}-){3}[a-f0-9]{12}$/.");
        }
        


        $resourcePath = '/api/v2.1/external-apps/{app_token}/status/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_token !== null) {
            $resourcePath = str_replace(
                '{' . 'app_token' . '}',
                ObjectSerializer::toPathValue($app_token),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($is_inactive)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($is_inactive));
            } else {
                $httpBody = $is_inactive;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation importUsersToApp
     *
     * Import Users to App
     *
     * @param  string $app_token app_token (required)
     * @param  \SeaTable\Client\User\ImportUsersToAppRequest $import_users_to_app_request import_users_to_app_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importUsersToApp'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function importUsersToApp($app_token, $import_users_to_app_request = null, string $contentType = self::contentTypes['importUsersToApp'][0])
    {
        $this->importUsersToAppWithHttpInfo($app_token, $import_users_to_app_request, $contentType);
    }

    /**
     * Operation importUsersToAppWithHttpInfo
     *
     * Import Users to App
     *
     * @param  string $app_token (required)
     * @param  \SeaTable\Client\User\ImportUsersToAppRequest $import_users_to_app_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importUsersToApp'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function importUsersToAppWithHttpInfo($app_token, $import_users_to_app_request = null, string $contentType = self::contentTypes['importUsersToApp'][0])
    {
        $request = $this->importUsersToAppRequest($app_token, $import_users_to_app_request, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation importUsersToAppAsync
     *
     * Import Users to App
     *
     * @param  string $app_token (required)
     * @param  \SeaTable\Client\User\ImportUsersToAppRequest $import_users_to_app_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importUsersToApp'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function importUsersToAppAsync($app_token, $import_users_to_app_request = null, string $contentType = self::contentTypes['importUsersToApp'][0])
    {
        return $this->importUsersToAppAsyncWithHttpInfo($app_token, $import_users_to_app_request, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation importUsersToAppAsyncWithHttpInfo
     *
     * Import Users to App
     *
     * @param  string $app_token (required)
     * @param  \SeaTable\Client\User\ImportUsersToAppRequest $import_users_to_app_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importUsersToApp'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function importUsersToAppAsyncWithHttpInfo($app_token, $import_users_to_app_request = null, string $contentType = self::contentTypes['importUsersToApp'][0])
    {
        $returnType = '';
        $request = $this->importUsersToAppRequest($app_token, $import_users_to_app_request, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'importUsersToApp'
     *
     * @param  string $app_token (required)
     * @param  \SeaTable\Client\User\ImportUsersToAppRequest $import_users_to_app_request (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['importUsersToApp'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function importUsersToAppRequest($app_token, $import_users_to_app_request = null, string $contentType = self::contentTypes['importUsersToApp'][0])
    {

        // verify the required parameter 'app_token' is set
        if ($app_token === null || (is_array($app_token) && count($app_token) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_token when calling importUsersToApp'
            );
        }
        if (!preg_match("/^[0-9a-f]{8}-([a-f1-9]{4}-){3}[a-f0-9]{12}$/", $app_token)) {
            throw new \InvalidArgumentException("invalid value for \"app_token\" when calling AppsApi.importUsersToApp, must conform to the pattern /^[0-9a-f]{8}-([a-f1-9]{4}-){3}[a-f0-9]{12}$/.");
        }
        


        $resourcePath = '/api/v2.1/universal-apps/{app_token}/app-users/batch/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_token !== null) {
            $resourcePath = str_replace(
                '{' . 'app_token' . '}',
                ObjectSerializer::toPathValue($app_token),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($import_users_to_app_request)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($import_users_to_app_request));
            } else {
                $httpBody = $import_users_to_app_request;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listAppInviteLinks
     *
     * List App Invite Links
     *
     * @param  string $app_token app_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listAppInviteLinks'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function listAppInviteLinks($app_token, string $contentType = self::contentTypes['listAppInviteLinks'][0])
    {
        $this->listAppInviteLinksWithHttpInfo($app_token, $contentType);
    }

    /**
     * Operation listAppInviteLinksWithHttpInfo
     *
     * List App Invite Links
     *
     * @param  string $app_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listAppInviteLinks'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function listAppInviteLinksWithHttpInfo($app_token, string $contentType = self::contentTypes['listAppInviteLinks'][0])
    {
        $request = $this->listAppInviteLinksRequest($app_token, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation listAppInviteLinksAsync
     *
     * List App Invite Links
     *
     * @param  string $app_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listAppInviteLinks'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listAppInviteLinksAsync($app_token, string $contentType = self::contentTypes['listAppInviteLinks'][0])
    {
        return $this->listAppInviteLinksAsyncWithHttpInfo($app_token, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listAppInviteLinksAsyncWithHttpInfo
     *
     * List App Invite Links
     *
     * @param  string $app_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listAppInviteLinks'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listAppInviteLinksAsyncWithHttpInfo($app_token, string $contentType = self::contentTypes['listAppInviteLinks'][0])
    {
        $returnType = '';
        $request = $this->listAppInviteLinksRequest($app_token, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listAppInviteLinks'
     *
     * @param  string $app_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listAppInviteLinks'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listAppInviteLinksRequest($app_token, string $contentType = self::contentTypes['listAppInviteLinks'][0])
    {

        // verify the required parameter 'app_token' is set
        if ($app_token === null || (is_array($app_token) && count($app_token) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_token when calling listAppInviteLinks'
            );
        }
        if (!preg_match("/^[0-9a-f]{8}-([a-f1-9]{4}-){3}[a-f0-9]{12}$/", $app_token)) {
            throw new \InvalidArgumentException("invalid value for \"app_token\" when calling AppsApi.listAppInviteLinks, must conform to the pattern /^[0-9a-f]{8}-([a-f1-9]{4}-){3}[a-f0-9]{12}$/.");
        }
        

        $resourcePath = '/api/v2.1/universal-apps/{app_token}/invite-links/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_token !== null) {
            $resourcePath = str_replace(
                '{' . 'app_token' . '}',
                ObjectSerializer::toPathValue($app_token),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listApps
     *
     * List Apps
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listApps'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function listApps(string $contentType = self::contentTypes['listApps'][0])
    {
        $this->listAppsWithHttpInfo($contentType);
    }

    /**
     * Operation listAppsWithHttpInfo
     *
     * List Apps
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listApps'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function listAppsWithHttpInfo(string $contentType = self::contentTypes['listApps'][0])
    {
        $request = $this->listAppsRequest($contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation listAppsAsync
     *
     * List Apps
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listApps'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listAppsAsync(string $contentType = self::contentTypes['listApps'][0])
    {
        return $this->listAppsAsyncWithHttpInfo($contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listAppsAsyncWithHttpInfo
     *
     * List Apps
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listApps'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listAppsAsyncWithHttpInfo(string $contentType = self::contentTypes['listApps'][0])
    {
        $returnType = '';
        $request = $this->listAppsRequest($contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listApps'
     *
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listApps'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listAppsRequest(string $contentType = self::contentTypes['listApps'][0])
    {


        $resourcePath = '/api/v2.1/universal-apps/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listUniversalAppUsers
     *
     * List Universal App Users
     *
     * @param  string $app_token app_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listUniversalAppUsers'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function listUniversalAppUsers($app_token, string $contentType = self::contentTypes['listUniversalAppUsers'][0])
    {
        $this->listUniversalAppUsersWithHttpInfo($app_token, $contentType);
    }

    /**
     * Operation listUniversalAppUsersWithHttpInfo
     *
     * List Universal App Users
     *
     * @param  string $app_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listUniversalAppUsers'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function listUniversalAppUsersWithHttpInfo($app_token, string $contentType = self::contentTypes['listUniversalAppUsers'][0])
    {
        $request = $this->listUniversalAppUsersRequest($app_token, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation listUniversalAppUsersAsync
     *
     * List Universal App Users
     *
     * @param  string $app_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listUniversalAppUsers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listUniversalAppUsersAsync($app_token, string $contentType = self::contentTypes['listUniversalAppUsers'][0])
    {
        return $this->listUniversalAppUsersAsyncWithHttpInfo($app_token, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listUniversalAppUsersAsyncWithHttpInfo
     *
     * List Universal App Users
     *
     * @param  string $app_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listUniversalAppUsers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listUniversalAppUsersAsyncWithHttpInfo($app_token, string $contentType = self::contentTypes['listUniversalAppUsers'][0])
    {
        $returnType = '';
        $request = $this->listUniversalAppUsersRequest($app_token, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listUniversalAppUsers'
     *
     * @param  string $app_token (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listUniversalAppUsers'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listUniversalAppUsersRequest($app_token, string $contentType = self::contentTypes['listUniversalAppUsers'][0])
    {

        // verify the required parameter 'app_token' is set
        if ($app_token === null || (is_array($app_token) && count($app_token) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_token when calling listUniversalAppUsers'
            );
        }
        if (!preg_match("/^[0-9a-f]{8}-([a-f1-9]{4}-){3}[a-f0-9]{12}$/", $app_token)) {
            throw new \InvalidArgumentException("invalid value for \"app_token\" when calling AppsApi.listUniversalAppUsers, must conform to the pattern /^[0-9a-f]{8}-([a-f1-9]{4}-){3}[a-f0-9]{12}$/.");
        }
        

        $resourcePath = '/api/v2.1/universal-apps/{app_token}/app-users/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($app_token !== null) {
            $resourcePath = str_replace(
                '{' . 'app_token' . '}',
                ObjectSerializer::toPathValue($app_token),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
