<?php
/**
 * UpdateUserRequest
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Account Operations: System admin
 *
 * The official SeaTable API Reference (OpenAPI 3.0).
 *
 * The version of the OpenAPI document: 5.0
 * Generated by: https://openapi-generator.tech
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SeaTable\Client\SysAdmin;

use \ArrayAccess;
use \SeaTable\Client\ObjectSerializer;

/**
 * UpdateUserRequest Class Doc Comment
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class UpdateUserRequest implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'updateUser_request';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'is_staff' => 'bool',
        'is_active' => 'bool',
        'role' => 'string',
        'name' => 'string',
        'login_id' => 'string',
        'contact_email' => 'string',
        'id_in_org' => 'string',
        'unit' => 'string',
        'password' => 'string',
        'institution' => 'string',
        'row_limit' => 'int',
        'quota_total' => 'string',
        'asset_quota_mb' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'is_staff' => null,
        'is_active' => null,
        'role' => null,
        'name' => null,
        'login_id' => null,
        'contact_email' => null,
        'id_in_org' => null,
        'unit' => null,
        'password' => null,
        'institution' => null,
        'row_limit' => null,
        'quota_total' => null,
        'asset_quota_mb' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'is_staff' => false,
        'is_active' => false,
        'role' => false,
        'name' => false,
        'login_id' => false,
        'contact_email' => false,
        'id_in_org' => false,
        'unit' => false,
        'password' => false,
        'institution' => false,
        'row_limit' => false,
        'quota_total' => false,
        'asset_quota_mb' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'is_staff' => 'is_staff',
        'is_active' => 'is_active',
        'role' => 'role',
        'name' => 'name',
        'login_id' => 'login_id',
        'contact_email' => 'contact_email',
        'id_in_org' => 'id_in_org',
        'unit' => 'unit',
        'password' => 'password',
        'institution' => 'institution',
        'row_limit' => 'row_limit',
        'quota_total' => 'quota_total',
        'asset_quota_mb' => 'asset_quota_mb'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'is_staff' => 'setIsStaff',
        'is_active' => 'setIsActive',
        'role' => 'setRole',
        'name' => 'setName',
        'login_id' => 'setLoginId',
        'contact_email' => 'setContactEmail',
        'id_in_org' => 'setIdInOrg',
        'unit' => 'setUnit',
        'password' => 'setPassword',
        'institution' => 'setInstitution',
        'row_limit' => 'setRowLimit',
        'quota_total' => 'setQuotaTotal',
        'asset_quota_mb' => 'setAssetQuotaMb'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'is_staff' => 'getIsStaff',
        'is_active' => 'getIsActive',
        'role' => 'getRole',
        'name' => 'getName',
        'login_id' => 'getLoginId',
        'contact_email' => 'getContactEmail',
        'id_in_org' => 'getIdInOrg',
        'unit' => 'getUnit',
        'password' => 'getPassword',
        'institution' => 'getInstitution',
        'row_limit' => 'getRowLimit',
        'quota_total' => 'getQuotaTotal',
        'asset_quota_mb' => 'getAssetQuotaMb'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('is_staff', $data ?? [], false);
        $this->setIfExists('is_active', $data ?? [], true);
        $this->setIfExists('role', $data ?? [], null);
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('login_id', $data ?? [], null);
        $this->setIfExists('contact_email', $data ?? [], null);
        $this->setIfExists('id_in_org', $data ?? [], null);
        $this->setIfExists('unit', $data ?? [], null);
        $this->setIfExists('password', $data ?? [], null);
        $this->setIfExists('institution', $data ?? [], null);
        $this->setIfExists('row_limit', $data ?? [], null);
        $this->setIfExists('quota_total', $data ?? [], null);
        $this->setIfExists('asset_quota_mb', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets is_staff
     *
     * @return bool|null
     */
    public function getIsStaff()
    {
        return $this->container['is_staff'];
    }

    /**
     * Sets is_staff
     *
     * @param bool|null $is_staff `true` or `false` if the user will be an (system) admin. `false` by default.
     *
     * @return self
     */
    public function setIsStaff($is_staff)
    {
        if (is_null($is_staff)) {
            throw new \InvalidArgumentException('non-nullable is_staff cannot be null');
        }
        $this->container['is_staff'] = $is_staff;

        return $this;
    }

    /**
     * Gets is_active
     *
     * @return bool|null
     */
    public function getIsActive()
    {
        return $this->container['is_active'];
    }

    /**
     * Sets is_active
     *
     * @param bool|null $is_active `true` or `false` if the user could log in. `true` by default.
     *
     * @return self
     */
    public function setIsActive($is_active)
    {
        if (is_null($is_active)) {
            throw new \InvalidArgumentException('non-nullable is_active cannot be null');
        }
        $this->container['is_active'] = $is_active;

        return $this;
    }

    /**
     * Gets role
     *
     * @return string|null
     */
    public function getRole()
    {
        return $this->container['role'];
    }

    /**
     * Sets role
     *
     * @param string|null $role Update their role. For details about roles, refer to [SeaTable Roles and Permissions](https://manual.seatable.io/config/enterprise/roles_permissions/).
     *
     * @return self
     */
    public function setRole($role)
    {
        if (is_null($role)) {
            throw new \InvalidArgumentException('non-nullable role cannot be null');
        }
        $this->container['role'] = $role;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name Full name of the user.
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets login_id
     *
     * @return string|null
     */
    public function getLoginId()
    {
        return $this->container['login_id'];
    }

    /**
     * Sets login_id
     *
     * @param string|null $login_id Optional login ID. Valid only if the system configuration allows login ID.
     *
     * @return self
     */
    public function setLoginId($login_id)
    {
        if (is_null($login_id)) {
            throw new \InvalidArgumentException('non-nullable login_id cannot be null');
        }
        $this->container['login_id'] = $login_id;

        return $this;
    }

    /**
     * Gets contact_email
     *
     * @return string|null
     */
    public function getContactEmail()
    {
        return $this->container['contact_email'];
    }

    /**
     * Sets contact_email
     *
     * @param string|null $contact_email The contact email address of the user.
     *
     * @return self
     */
    public function setContactEmail($contact_email)
    {
        if (is_null($contact_email)) {
            throw new \InvalidArgumentException('non-nullable contact_email cannot be null');
        }
        $this->container['contact_email'] = $contact_email;

        return $this;
    }

    /**
     * Gets id_in_org
     *
     * @return string|null
     */
    public function getIdInOrg()
    {
        return $this->container['id_in_org'];
    }

    /**
     * Sets id_in_org
     *
     * @param string|null $id_in_org The team ID of the user, could be a student's ID or employee ID. String.
     *
     * @return self
     */
    public function setIdInOrg($id_in_org)
    {
        if (is_null($id_in_org)) {
            throw new \InvalidArgumentException('non-nullable id_in_org cannot be null');
        }
        $this->container['id_in_org'] = $id_in_org;

        return $this;
    }

    /**
     * Gets unit
     *
     * @return string|null
     */
    public function getUnit()
    {
        return $this->container['unit'];
    }

    /**
     * Sets unit
     *
     * @param string|null $unit Business unit. Only valid if the system configuration allows the feature.
     *
     * @return self
     */
    public function setUnit($unit)
    {
        if (is_null($unit)) {
            throw new \InvalidArgumentException('non-nullable unit cannot be null');
        }
        $this->container['unit'] = $unit;

        return $this;
    }

    /**
     * Gets password
     *
     * @return string|null
     */
    public function getPassword()
    {
        return $this->container['password'];
    }

    /**
     * Sets password
     *
     * @param string|null $password Login password of the user.
     *
     * @return self
     */
    public function setPassword($password)
    {
        if (is_null($password)) {
            throw new \InvalidArgumentException('non-nullable password cannot be null');
        }
        $this->container['password'] = $password;

        return $this;
    }

    /**
     * Gets institution
     *
     * @return string|null
     */
    public function getInstitution()
    {
        return $this->container['institution'];
    }

    /**
     * Sets institution
     *
     * @param string|null $institution Institution. Only valid if the system configuration allows the feature.
     *
     * @return self
     */
    public function setInstitution($institution)
    {
        if (is_null($institution)) {
            throw new \InvalidArgumentException('non-nullable institution cannot be null');
        }
        $this->container['institution'] = $institution;

        return $this;
    }

    /**
     * Gets row_limit
     *
     * @return int|null
     */
    public function getRowLimit()
    {
        return $this->container['row_limit'];
    }

    /**
     * Sets row_limit
     *
     * @param int|null $row_limit User's total row limit in number. For example 10000.
     *
     * @return self
     */
    public function setRowLimit($row_limit)
    {
        if (is_null($row_limit)) {
            throw new \InvalidArgumentException('non-nullable row_limit cannot be null');
        }
        $this->container['row_limit'] = $row_limit;

        return $this;
    }

    /**
     * Gets quota_total
     *
     * @return string|null
     */
    public function getQuotaTotal()
    {
        return $this->container['quota_total'];
    }

    /**
     * Sets quota_total
     *
     * @param string|null $quota_total Update their total quota in MB.
     *
     * @return self
     */
    public function setQuotaTotal($quota_total)
    {
        if (is_null($quota_total)) {
            throw new \InvalidArgumentException('non-nullable quota_total cannot be null');
        }
        $this->container['quota_total'] = $quota_total;

        return $this;
    }

    /**
     * Gets asset_quota_mb
     *
     * @return string|null
     */
    public function getAssetQuotaMb()
    {
        return $this->container['asset_quota_mb'];
    }

    /**
     * Sets asset_quota_mb
     *
     * @param string|null $asset_quota_mb The asset quota in MB.
     *
     * @return self
     */
    public function setAssetQuotaMb($asset_quota_mb)
    {
        if (is_null($asset_quota_mb)) {
            throw new \InvalidArgumentException('non-nullable asset_quota_mb cannot be null');
        }
        $this->container['asset_quota_mb'] = $asset_quota_mb;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


