<?php
/**
 * StatisticsApi
 * PHP version 7.4
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Account Operations: System admin
 *
 * The official SeaTable API Reference (OpenAPI 3.0).
 *
 * The version of the OpenAPI document: 5.0
 * Generated by: https://openapi-generator.tech
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SeaTable\Client\SysAdmin;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use SeaTable\Client\ApiException;
use SeaTable\Client\Configuration;
use SeaTable\Client\HeaderSelector;
use SeaTable\Client\ObjectSerializer;

/**
 * StatisticsApi Class Doc Comment
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class StatisticsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'getActiveUsersPerDay' => [
            'application/json',
        ],
        'getAutomationRules' => [
            'application/json',
        ],
        'getExternalApps' => [
            'application/json',
        ],
        'getScriptRunningCountByUser' => [
            'application/json',
        ],
        'listActiveUsersByDay' => [
            'application/json',
        ],
        'listScriptTasks' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation getActiveUsersPerDay
     *
     * Get Active Users (per Day)
     *
     * @param  string $start Starting time of the statistics in ISO format like in the example. Required. (optional)
     * @param  string $end Ending time of the statistics in ISO format like in the example. Required. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getActiveUsersPerDay'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function getActiveUsersPerDay($start = null, $end = null, string $contentType = self::contentTypes['getActiveUsersPerDay'][0])
    {
        list($response) = $this->getActiveUsersPerDayWithHttpInfo($start, $end, $contentType);
        return $response;
    }

    /**
     * Operation getActiveUsersPerDayWithHttpInfo
     *
     * Get Active Users (per Day)
     *
     * @param  string $start Starting time of the statistics in ISO format like in the example. Required. (optional)
     * @param  string $end Ending time of the statistics in ISO format like in the example. Required. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getActiveUsersPerDay'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function getActiveUsersPerDayWithHttpInfo($start = null, $end = null, string $contentType = self::contentTypes['getActiveUsersPerDay'][0])
    {
        $request = $this->getActiveUsersPerDayRequest($start, $end, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getActiveUsersPerDayAsync
     *
     * Get Active Users (per Day)
     *
     * @param  string $start Starting time of the statistics in ISO format like in the example. Required. (optional)
     * @param  string $end Ending time of the statistics in ISO format like in the example. Required. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getActiveUsersPerDay'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getActiveUsersPerDayAsync($start = null, $end = null, string $contentType = self::contentTypes['getActiveUsersPerDay'][0])
    {
        return $this->getActiveUsersPerDayAsyncWithHttpInfo($start, $end, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getActiveUsersPerDayAsyncWithHttpInfo
     *
     * Get Active Users (per Day)
     *
     * @param  string $start Starting time of the statistics in ISO format like in the example. Required. (optional)
     * @param  string $end Ending time of the statistics in ISO format like in the example. Required. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getActiveUsersPerDay'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getActiveUsersPerDayAsyncWithHttpInfo($start = null, $end = null, string $contentType = self::contentTypes['getActiveUsersPerDay'][0])
    {
        $returnType = 'object';
        $request = $this->getActiveUsersPerDayRequest($start, $end, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getActiveUsersPerDay'
     *
     * @param  string $start Starting time of the statistics in ISO format like in the example. Required. (optional)
     * @param  string $end Ending time of the statistics in ISO format like in the example. Required. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getActiveUsersPerDay'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getActiveUsersPerDayRequest($start = null, $end = null, string $contentType = self::contentTypes['getActiveUsersPerDay'][0])
    {

        if ($start !== null && !preg_match("/^[0-9]{4}-((0[1-9])|(1[0-2]))?-(([0-2][0-9])|(3[01]))?\\+(2[0-3]|[01]?[0-9])(:[0-5]?[0-9]){2}$/", $start)) {
            throw new \InvalidArgumentException("invalid value for \"start\" when calling StatisticsApi.getActiveUsersPerDay, must conform to the pattern /^[0-9]{4}-((0[1-9])|(1[0-2]))?-(([0-2][0-9])|(3[01]))?\\+(2[0-3]|[01]?[0-9])(:[0-5]?[0-9]){2}$/.");
        }
        
        if ($end !== null && !preg_match("/^[0-9]{4}-((0[1-9])|(1[0-2]))?-(([0-2][0-9])|(3[01]))?\\+(2[0-3]|[01]?[0-9])(:[0-5]?[0-9]){2}$/", $end)) {
            throw new \InvalidArgumentException("invalid value for \"end\" when calling StatisticsApi.getActiveUsersPerDay, must conform to the pattern /^[0-9]{4}-((0[1-9])|(1[0-2]))?-(([0-2][0-9])|(3[01]))?\\+(2[0-3]|[01]?[0-9])(:[0-5]?[0-9]){2}$/.");
        }
        

        $resourcePath = '/api/v2.1/admin/statistics/active-users/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $start,
            'start', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $end,
            'end', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getAutomationRules
     *
     * Get Automation Rules
     *
     * @param  bool $is_user Whether you&#39;d like to list automation rules triggered by single users who are not in any teams (&#x60;true&#x60;) or by teams (&#x60;false&#x60;).  The usage of &#x60;true&#x60; here is seldom meaningful for cloud.seatable.io as all the users in the SeaTable Cloud are team users. (required)
     * @param  string $month For which month you&#39;d like to list the statistics in the format of YYYYMM. Statistics of automation rules before 202109 are not correctly summarized. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAutomationRules'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function getAutomationRules($is_user, $month = null, string $contentType = self::contentTypes['getAutomationRules'][0])
    {
        list($response) = $this->getAutomationRulesWithHttpInfo($is_user, $month, $contentType);
        return $response;
    }

    /**
     * Operation getAutomationRulesWithHttpInfo
     *
     * Get Automation Rules
     *
     * @param  bool $is_user Whether you&#39;d like to list automation rules triggered by single users who are not in any teams (&#x60;true&#x60;) or by teams (&#x60;false&#x60;).  The usage of &#x60;true&#x60; here is seldom meaningful for cloud.seatable.io as all the users in the SeaTable Cloud are team users. (required)
     * @param  string $month For which month you&#39;d like to list the statistics in the format of YYYYMM. Statistics of automation rules before 202109 are not correctly summarized. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAutomationRules'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function getAutomationRulesWithHttpInfo($is_user, $month = null, string $contentType = self::contentTypes['getAutomationRules'][0])
    {
        $request = $this->getAutomationRulesRequest($is_user, $month, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getAutomationRulesAsync
     *
     * Get Automation Rules
     *
     * @param  bool $is_user Whether you&#39;d like to list automation rules triggered by single users who are not in any teams (&#x60;true&#x60;) or by teams (&#x60;false&#x60;).  The usage of &#x60;true&#x60; here is seldom meaningful for cloud.seatable.io as all the users in the SeaTable Cloud are team users. (required)
     * @param  string $month For which month you&#39;d like to list the statistics in the format of YYYYMM. Statistics of automation rules before 202109 are not correctly summarized. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAutomationRules'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAutomationRulesAsync($is_user, $month = null, string $contentType = self::contentTypes['getAutomationRules'][0])
    {
        return $this->getAutomationRulesAsyncWithHttpInfo($is_user, $month, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getAutomationRulesAsyncWithHttpInfo
     *
     * Get Automation Rules
     *
     * @param  bool $is_user Whether you&#39;d like to list automation rules triggered by single users who are not in any teams (&#x60;true&#x60;) or by teams (&#x60;false&#x60;).  The usage of &#x60;true&#x60; here is seldom meaningful for cloud.seatable.io as all the users in the SeaTable Cloud are team users. (required)
     * @param  string $month For which month you&#39;d like to list the statistics in the format of YYYYMM. Statistics of automation rules before 202109 are not correctly summarized. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAutomationRules'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getAutomationRulesAsyncWithHttpInfo($is_user, $month = null, string $contentType = self::contentTypes['getAutomationRules'][0])
    {
        $returnType = 'object';
        $request = $this->getAutomationRulesRequest($is_user, $month, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getAutomationRules'
     *
     * @param  bool $is_user Whether you&#39;d like to list automation rules triggered by single users who are not in any teams (&#x60;true&#x60;) or by teams (&#x60;false&#x60;).  The usage of &#x60;true&#x60; here is seldom meaningful for cloud.seatable.io as all the users in the SeaTable Cloud are team users. (required)
     * @param  string $month For which month you&#39;d like to list the statistics in the format of YYYYMM. Statistics of automation rules before 202109 are not correctly summarized. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getAutomationRules'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getAutomationRulesRequest($is_user, $month = null, string $contentType = self::contentTypes['getAutomationRules'][0])
    {

        // verify the required parameter 'is_user' is set
        if ($is_user === null || (is_array($is_user) && count($is_user) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $is_user when calling getAutomationRules'
            );
        }

        if ($month !== null && !preg_match("/^[0-9]{4}((0[1-9])|1[0-2])$/", $month)) {
            throw new \InvalidArgumentException("invalid value for \"month\" when calling StatisticsApi.getAutomationRules, must conform to the pattern /^[0-9]{4}((0[1-9])|1[0-2])$/.");
        }
        

        $resourcePath = '/api/v2.1/admin/statistics/auto-rules/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_user,
            'is_user', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $month,
            'month', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getExternalApps
     *
     * Get External Apps
     *
     * @param  bool $is_user Whether you&#39;d like to list automation rules triggered by single users who are not in any teams (&#x60;true&#x60;) or by teams (&#x60;false&#x60;).  The usage of &#x60;true&#x60; here is seldom meaningful for cloud.seatable.io as all the users in the SeaTable Cloud are team users. (required)
     * @param  string $month For which month you&#39;d like to list the statistics in the format of YYYYMM. Statistics of automation rules before 202109 are not correctly summarized. (optional)
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExternalApps'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function getExternalApps($is_user, $month = null, $page = null, $per_page = null, string $contentType = self::contentTypes['getExternalApps'][0])
    {
        list($response) = $this->getExternalAppsWithHttpInfo($is_user, $month, $page, $per_page, $contentType);
        return $response;
    }

    /**
     * Operation getExternalAppsWithHttpInfo
     *
     * Get External Apps
     *
     * @param  bool $is_user Whether you&#39;d like to list automation rules triggered by single users who are not in any teams (&#x60;true&#x60;) or by teams (&#x60;false&#x60;).  The usage of &#x60;true&#x60; here is seldom meaningful for cloud.seatable.io as all the users in the SeaTable Cloud are team users. (required)
     * @param  string $month For which month you&#39;d like to list the statistics in the format of YYYYMM. Statistics of automation rules before 202109 are not correctly summarized. (optional)
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExternalApps'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function getExternalAppsWithHttpInfo($is_user, $month = null, $page = null, $per_page = null, string $contentType = self::contentTypes['getExternalApps'][0])
    {
        $request = $this->getExternalAppsRequest($is_user, $month, $page, $per_page, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getExternalAppsAsync
     *
     * Get External Apps
     *
     * @param  bool $is_user Whether you&#39;d like to list automation rules triggered by single users who are not in any teams (&#x60;true&#x60;) or by teams (&#x60;false&#x60;).  The usage of &#x60;true&#x60; here is seldom meaningful for cloud.seatable.io as all the users in the SeaTable Cloud are team users. (required)
     * @param  string $month For which month you&#39;d like to list the statistics in the format of YYYYMM. Statistics of automation rules before 202109 are not correctly summarized. (optional)
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExternalApps'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getExternalAppsAsync($is_user, $month = null, $page = null, $per_page = null, string $contentType = self::contentTypes['getExternalApps'][0])
    {
        return $this->getExternalAppsAsyncWithHttpInfo($is_user, $month, $page, $per_page, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getExternalAppsAsyncWithHttpInfo
     *
     * Get External Apps
     *
     * @param  bool $is_user Whether you&#39;d like to list automation rules triggered by single users who are not in any teams (&#x60;true&#x60;) or by teams (&#x60;false&#x60;).  The usage of &#x60;true&#x60; here is seldom meaningful for cloud.seatable.io as all the users in the SeaTable Cloud are team users. (required)
     * @param  string $month For which month you&#39;d like to list the statistics in the format of YYYYMM. Statistics of automation rules before 202109 are not correctly summarized. (optional)
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExternalApps'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getExternalAppsAsyncWithHttpInfo($is_user, $month = null, $page = null, $per_page = null, string $contentType = self::contentTypes['getExternalApps'][0])
    {
        $returnType = 'object';
        $request = $this->getExternalAppsRequest($is_user, $month, $page, $per_page, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getExternalApps'
     *
     * @param  bool $is_user Whether you&#39;d like to list automation rules triggered by single users who are not in any teams (&#x60;true&#x60;) or by teams (&#x60;false&#x60;).  The usage of &#x60;true&#x60; here is seldom meaningful for cloud.seatable.io as all the users in the SeaTable Cloud are team users. (required)
     * @param  string $month For which month you&#39;d like to list the statistics in the format of YYYYMM. Statistics of automation rules before 202109 are not correctly summarized. (optional)
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getExternalApps'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getExternalAppsRequest($is_user, $month = null, $page = null, $per_page = null, string $contentType = self::contentTypes['getExternalApps'][0])
    {

        // verify the required parameter 'is_user' is set
        if ($is_user === null || (is_array($is_user) && count($is_user) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $is_user when calling getExternalApps'
            );
        }

        if ($month !== null && !preg_match("/^[0-9]{4}((0[1-9])|1[0-2])$/", $month)) {
            throw new \InvalidArgumentException("invalid value for \"month\" when calling StatisticsApi.getExternalApps, must conform to the pattern /^[0-9]{4}((0[1-9])|1[0-2])$/.");
        }
        
        if ($page !== null && $page < 1) {
            throw new \InvalidArgumentException('invalid value for "$page" when calling StatisticsApi.getExternalApps, must be bigger than or equal to 1.');
        }
        
        if ($per_page !== null && $per_page < 1) {
            throw new \InvalidArgumentException('invalid value for "$per_page" when calling StatisticsApi.getExternalApps, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v2.1/admin/statistics/external-apps/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_user,
            'is_user', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $month,
            'month', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $per_page,
            'per_page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getScriptRunningCountByUser
     *
     * Get Script Running Count by User
     *
     * @param  bool $is_user Whether you&#39;d like to list automation rules triggered by single users who are not in any teams (&#x60;true&#x60;) or by teams (&#x60;false&#x60;).  The usage of &#x60;true&#x60; here is seldom meaningful for cloud.seatable.io as all the users in the SeaTable Cloud are team users. (required)
     * @param  string $owner The ID of the user you are querying. Optional. If you don&#39;t define a user, all the users are queried. (optional)
     * @param  string $month For which month you&#39;d like to list the statistics in the format of YYYYMM. Statistics of automation rules before 202109 are not correctly summarized. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getScriptRunningCountByUser'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function getScriptRunningCountByUser($is_user, $owner = null, $month = null, string $contentType = self::contentTypes['getScriptRunningCountByUser'][0])
    {
        list($response) = $this->getScriptRunningCountByUserWithHttpInfo($is_user, $owner, $month, $contentType);
        return $response;
    }

    /**
     * Operation getScriptRunningCountByUserWithHttpInfo
     *
     * Get Script Running Count by User
     *
     * @param  bool $is_user Whether you&#39;d like to list automation rules triggered by single users who are not in any teams (&#x60;true&#x60;) or by teams (&#x60;false&#x60;).  The usage of &#x60;true&#x60; here is seldom meaningful for cloud.seatable.io as all the users in the SeaTable Cloud are team users. (required)
     * @param  string $owner The ID of the user you are querying. Optional. If you don&#39;t define a user, all the users are queried. (optional)
     * @param  string $month For which month you&#39;d like to list the statistics in the format of YYYYMM. Statistics of automation rules before 202109 are not correctly summarized. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getScriptRunningCountByUser'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function getScriptRunningCountByUserWithHttpInfo($is_user, $owner = null, $month = null, string $contentType = self::contentTypes['getScriptRunningCountByUser'][0])
    {
        $request = $this->getScriptRunningCountByUserRequest($is_user, $owner, $month, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getScriptRunningCountByUserAsync
     *
     * Get Script Running Count by User
     *
     * @param  bool $is_user Whether you&#39;d like to list automation rules triggered by single users who are not in any teams (&#x60;true&#x60;) or by teams (&#x60;false&#x60;).  The usage of &#x60;true&#x60; here is seldom meaningful for cloud.seatable.io as all the users in the SeaTable Cloud are team users. (required)
     * @param  string $owner The ID of the user you are querying. Optional. If you don&#39;t define a user, all the users are queried. (optional)
     * @param  string $month For which month you&#39;d like to list the statistics in the format of YYYYMM. Statistics of automation rules before 202109 are not correctly summarized. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getScriptRunningCountByUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getScriptRunningCountByUserAsync($is_user, $owner = null, $month = null, string $contentType = self::contentTypes['getScriptRunningCountByUser'][0])
    {
        return $this->getScriptRunningCountByUserAsyncWithHttpInfo($is_user, $owner, $month, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getScriptRunningCountByUserAsyncWithHttpInfo
     *
     * Get Script Running Count by User
     *
     * @param  bool $is_user Whether you&#39;d like to list automation rules triggered by single users who are not in any teams (&#x60;true&#x60;) or by teams (&#x60;false&#x60;).  The usage of &#x60;true&#x60; here is seldom meaningful for cloud.seatable.io as all the users in the SeaTable Cloud are team users. (required)
     * @param  string $owner The ID of the user you are querying. Optional. If you don&#39;t define a user, all the users are queried. (optional)
     * @param  string $month For which month you&#39;d like to list the statistics in the format of YYYYMM. Statistics of automation rules before 202109 are not correctly summarized. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getScriptRunningCountByUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getScriptRunningCountByUserAsyncWithHttpInfo($is_user, $owner = null, $month = null, string $contentType = self::contentTypes['getScriptRunningCountByUser'][0])
    {
        $returnType = 'object';
        $request = $this->getScriptRunningCountByUserRequest($is_user, $owner, $month, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getScriptRunningCountByUser'
     *
     * @param  bool $is_user Whether you&#39;d like to list automation rules triggered by single users who are not in any teams (&#x60;true&#x60;) or by teams (&#x60;false&#x60;).  The usage of &#x60;true&#x60; here is seldom meaningful for cloud.seatable.io as all the users in the SeaTable Cloud are team users. (required)
     * @param  string $owner The ID of the user you are querying. Optional. If you don&#39;t define a user, all the users are queried. (optional)
     * @param  string $month For which month you&#39;d like to list the statistics in the format of YYYYMM. Statistics of automation rules before 202109 are not correctly summarized. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getScriptRunningCountByUser'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getScriptRunningCountByUserRequest($is_user, $owner = null, $month = null, string $contentType = self::contentTypes['getScriptRunningCountByUser'][0])
    {

        // verify the required parameter 'is_user' is set
        if ($is_user === null || (is_array($is_user) && count($is_user) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $is_user when calling getScriptRunningCountByUser'
            );
        }

        if ($owner !== null && !preg_match("/^[a-f0-9]{32}(@auth.local)$/", $owner)) {
            throw new \InvalidArgumentException("invalid value for \"owner\" when calling StatisticsApi.getScriptRunningCountByUser, must conform to the pattern /^[a-f0-9]{32}(@auth.local)$/.");
        }
        
        if ($month !== null && !preg_match("/^[0-9]{4}((0[1-9])|1[0-2])$/", $month)) {
            throw new \InvalidArgumentException("invalid value for \"month\" when calling StatisticsApi.getScriptRunningCountByUser, must conform to the pattern /^[0-9]{4}((0[1-9])|1[0-2])$/.");
        }
        

        $resourcePath = '/api/v2.1/admin/statistics/scripts-running/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $is_user,
            'is_user', // param base name
            'boolean', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $owner,
            'owner', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $month,
            'month', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listActiveUsersByDay
     *
     * List Active Users (one Day)
     *
     * @param  string $date The date in ISO format. Required. (optional)
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listActiveUsersByDay'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function listActiveUsersByDay($date = null, $page = null, $per_page = null, string $contentType = self::contentTypes['listActiveUsersByDay'][0])
    {
        list($response) = $this->listActiveUsersByDayWithHttpInfo($date, $page, $per_page, $contentType);
        return $response;
    }

    /**
     * Operation listActiveUsersByDayWithHttpInfo
     *
     * List Active Users (one Day)
     *
     * @param  string $date The date in ISO format. Required. (optional)
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listActiveUsersByDay'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function listActiveUsersByDayWithHttpInfo($date = null, $page = null, $per_page = null, string $contentType = self::contentTypes['listActiveUsersByDay'][0])
    {
        $request = $this->listActiveUsersByDayRequest($date, $page, $per_page, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listActiveUsersByDayAsync
     *
     * List Active Users (one Day)
     *
     * @param  string $date The date in ISO format. Required. (optional)
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listActiveUsersByDay'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listActiveUsersByDayAsync($date = null, $page = null, $per_page = null, string $contentType = self::contentTypes['listActiveUsersByDay'][0])
    {
        return $this->listActiveUsersByDayAsyncWithHttpInfo($date, $page, $per_page, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listActiveUsersByDayAsyncWithHttpInfo
     *
     * List Active Users (one Day)
     *
     * @param  string $date The date in ISO format. Required. (optional)
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listActiveUsersByDay'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listActiveUsersByDayAsyncWithHttpInfo($date = null, $page = null, $per_page = null, string $contentType = self::contentTypes['listActiveUsersByDay'][0])
    {
        $returnType = 'object';
        $request = $this->listActiveUsersByDayRequest($date, $page, $per_page, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listActiveUsersByDay'
     *
     * @param  string $date The date in ISO format. Required. (optional)
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listActiveUsersByDay'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listActiveUsersByDayRequest($date = null, $page = null, $per_page = null, string $contentType = self::contentTypes['listActiveUsersByDay'][0])
    {

        if ($date !== null && !preg_match("/^[0-9]{4}-((0[1-9])|(1[0-2]))?-(([0-2][0-9])|(3[01]))?\\+(2[0-3]|[01]?[0-9])(:[0-5]?[0-9]){2}$/", $date)) {
            throw new \InvalidArgumentException("invalid value for \"date\" when calling StatisticsApi.listActiveUsersByDay, must conform to the pattern /^[0-9]{4}-((0[1-9])|(1[0-2]))?-(([0-2][0-9])|(3[01]))?\\+(2[0-3]|[01]?[0-9])(:[0-5]?[0-9]){2}$/.");
        }
        
        if ($page !== null && $page < 1) {
            throw new \InvalidArgumentException('invalid value for "$page" when calling StatisticsApi.listActiveUsersByDay, must be bigger than or equal to 1.');
        }
        
        if ($per_page !== null && $per_page < 1) {
            throw new \InvalidArgumentException('invalid value for "$per_page" when calling StatisticsApi.listActiveUsersByDay, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v2.1/admin/daily-active-users/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $date,
            'date', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $per_page,
            'per_page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listScriptTasks
     *
     * List Scripts Tasks
     *
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listScriptTasks'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function listScriptTasks($page = null, $per_page = null, string $contentType = self::contentTypes['listScriptTasks'][0])
    {
        list($response) = $this->listScriptTasksWithHttpInfo($page, $per_page, $contentType);
        return $response;
    }

    /**
     * Operation listScriptTasksWithHttpInfo
     *
     * List Scripts Tasks
     *
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listScriptTasks'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function listScriptTasksWithHttpInfo($page = null, $per_page = null, string $contentType = self::contentTypes['listScriptTasks'][0])
    {
        $request = $this->listScriptTasksRequest($page, $per_page, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listScriptTasksAsync
     *
     * List Scripts Tasks
     *
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listScriptTasks'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listScriptTasksAsync($page = null, $per_page = null, string $contentType = self::contentTypes['listScriptTasks'][0])
    {
        return $this->listScriptTasksAsyncWithHttpInfo($page, $per_page, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listScriptTasksAsyncWithHttpInfo
     *
     * List Scripts Tasks
     *
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listScriptTasks'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listScriptTasksAsyncWithHttpInfo($page = null, $per_page = null, string $contentType = self::contentTypes['listScriptTasks'][0])
    {
        $returnType = 'object';
        $request = $this->listScriptTasksRequest($page, $per_page, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listScriptTasks'
     *
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listScriptTasks'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listScriptTasksRequest($page = null, $per_page = null, string $contentType = self::contentTypes['listScriptTasks'][0])
    {

        if ($page !== null && $page < 1) {
            throw new \InvalidArgumentException('invalid value for "$page" when calling StatisticsApi.listScriptTasks, must be bigger than or equal to 1.');
        }
        
        if ($per_page !== null && $per_page < 1) {
            throw new \InvalidArgumentException('invalid value for "$per_page" when calling StatisticsApi.listScriptTasks, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v2.1/admin/scripts-tasks/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $per_page,
            'per_page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
