<?php
/**
 * BasesApi
 * PHP version 7.4
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Account Operations: System admin
 *
 * The official SeaTable API Reference (OpenAPI 3.0).
 *
 * The version of the OpenAPI document: 5.0
 * Generated by: https://openapi-generator.tech
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SeaTable\Client\SysAdmin;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use SeaTable\Client\ApiException;
use SeaTable\Client\Configuration;
use SeaTable\Client\HeaderSelector;
use SeaTable\Client\ObjectSerializer;

/**
 * BasesApi Class Doc Comment
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class BasesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'deleteBase' => [
            'application/json',
        ],
        'deleteBasePassword' => [
            'application/json',
        ],
        'listAllBases' => [
            'application/json',
        ],
        'listBaseNotifications' => [
            'application/json',
        ],
        'listTrashedBases' => [
            'application/json',
        ],
        'listUsersBases' => [
            'application/json',
        ],
        'restoreTrashedBase' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation deleteBase
     *
     * Delete Base
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBase'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function deleteBase($base_uuid, string $contentType = self::contentTypes['deleteBase'][0])
    {
        list($response) = $this->deleteBaseWithHttpInfo($base_uuid, $contentType);
        return $response;
    }

    /**
     * Operation deleteBaseWithHttpInfo
     *
     * Delete Base
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBase'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBaseWithHttpInfo($base_uuid, string $contentType = self::contentTypes['deleteBase'][0])
    {
        $request = $this->deleteBaseRequest($base_uuid, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteBaseAsync
     *
     * Delete Base
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBase'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteBaseAsync($base_uuid, string $contentType = self::contentTypes['deleteBase'][0])
    {
        return $this->deleteBaseAsyncWithHttpInfo($base_uuid, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteBaseAsyncWithHttpInfo
     *
     * Delete Base
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBase'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteBaseAsyncWithHttpInfo($base_uuid, string $contentType = self::contentTypes['deleteBase'][0])
    {
        $returnType = 'object';
        $request = $this->deleteBaseRequest($base_uuid, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteBase'
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBase'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteBaseRequest($base_uuid, string $contentType = self::contentTypes['deleteBase'][0])
    {

        // verify the required parameter 'base_uuid' is set
        if ($base_uuid === null || (is_array($base_uuid) && count($base_uuid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_uuid when calling deleteBase'
            );
        }
        if (!preg_match("/^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/", $base_uuid)) {
            throw new \InvalidArgumentException("invalid value for \"base_uuid\" when calling BasesApi.deleteBase, must conform to the pattern /^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/.");
        }
        

        $resourcePath = '/api/v2.1/admin/dtable/{base_uuid}/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($base_uuid !== null) {
            $resourcePath = str_replace(
                '{' . 'base_uuid' . '}',
                ObjectSerializer::toPathValue($base_uuid),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteBasePassword
     *
     * Delete Base Password
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBasePassword'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function deleteBasePassword($base_uuid, string $contentType = self::contentTypes['deleteBasePassword'][0])
    {
        list($response) = $this->deleteBasePasswordWithHttpInfo($base_uuid, $contentType);
        return $response;
    }

    /**
     * Operation deleteBasePasswordWithHttpInfo
     *
     * Delete Base Password
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBasePassword'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteBasePasswordWithHttpInfo($base_uuid, string $contentType = self::contentTypes['deleteBasePassword'][0])
    {
        $request = $this->deleteBasePasswordRequest($base_uuid, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteBasePasswordAsync
     *
     * Delete Base Password
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBasePassword'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteBasePasswordAsync($base_uuid, string $contentType = self::contentTypes['deleteBasePassword'][0])
    {
        return $this->deleteBasePasswordAsyncWithHttpInfo($base_uuid, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteBasePasswordAsyncWithHttpInfo
     *
     * Delete Base Password
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBasePassword'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteBasePasswordAsyncWithHttpInfo($base_uuid, string $contentType = self::contentTypes['deleteBasePassword'][0])
    {
        $returnType = 'object';
        $request = $this->deleteBasePasswordRequest($base_uuid, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteBasePassword'
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteBasePassword'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteBasePasswordRequest($base_uuid, string $contentType = self::contentTypes['deleteBasePassword'][0])
    {

        // verify the required parameter 'base_uuid' is set
        if ($base_uuid === null || (is_array($base_uuid) && count($base_uuid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_uuid when calling deleteBasePassword'
            );
        }
        if (!preg_match("/^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/", $base_uuid)) {
            throw new \InvalidArgumentException("invalid value for \"base_uuid\" when calling BasesApi.deleteBasePassword, must conform to the pattern /^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/.");
        }
        

        $resourcePath = '/api/v2.1/admin/dtable/{base_uuid}/unset-password/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($base_uuid !== null) {
            $resourcePath = str_replace(
                '{' . 'base_uuid' . '}',
                ObjectSerializer::toPathValue($base_uuid),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listAllBases
     *
     * List All Bases
     *
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listAllBases'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function listAllBases($per_page = null, $page = null, string $contentType = self::contentTypes['listAllBases'][0])
    {
        $this->listAllBasesWithHttpInfo($per_page, $page, $contentType);
    }

    /**
     * Operation listAllBasesWithHttpInfo
     *
     * List All Bases
     *
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listAllBases'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function listAllBasesWithHttpInfo($per_page = null, $page = null, string $contentType = self::contentTypes['listAllBases'][0])
    {
        $request = $this->listAllBasesRequest($per_page, $page, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation listAllBasesAsync
     *
     * List All Bases
     *
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listAllBases'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listAllBasesAsync($per_page = null, $page = null, string $contentType = self::contentTypes['listAllBases'][0])
    {
        return $this->listAllBasesAsyncWithHttpInfo($per_page, $page, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listAllBasesAsyncWithHttpInfo
     *
     * List All Bases
     *
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listAllBases'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listAllBasesAsyncWithHttpInfo($per_page = null, $page = null, string $contentType = self::contentTypes['listAllBases'][0])
    {
        $returnType = '';
        $request = $this->listAllBasesRequest($per_page, $page, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listAllBases'
     *
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listAllBases'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listAllBasesRequest($per_page = null, $page = null, string $contentType = self::contentTypes['listAllBases'][0])
    {

        if ($per_page !== null && $per_page < 1) {
            throw new \InvalidArgumentException('invalid value for "$per_page" when calling BasesApi.listAllBases, must be bigger than or equal to 1.');
        }
        
        if ($page !== null && $page < 1) {
            throw new \InvalidArgumentException('invalid value for "$page" when calling BasesApi.listAllBases, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v2.1/admin/dtables/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $per_page,
            'per_page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listBaseNotifications
     *
     * List Notifications
     *
     * @param  string $dtable_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $username Who you want to get the notifications of, optional (optional)
     * @param  string $contact_email The contact email of the user you&#39;re querying. Optional if &#x60;username&#x60; is defined. (optional)
     * @param  int $seen Seen status, whether seen or not, 0/1, optional (optional)
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listBaseNotifications'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function listBaseNotifications($dtable_uuid, $username = null, $contact_email = null, $seen = null, $page = null, $per_page = null, string $contentType = self::contentTypes['listBaseNotifications'][0])
    {
        list($response) = $this->listBaseNotificationsWithHttpInfo($dtable_uuid, $username, $contact_email, $seen, $page, $per_page, $contentType);
        return $response;
    }

    /**
     * Operation listBaseNotificationsWithHttpInfo
     *
     * List Notifications
     *
     * @param  string $dtable_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $username Who you want to get the notifications of, optional (optional)
     * @param  string $contact_email The contact email of the user you&#39;re querying. Optional if &#x60;username&#x60; is defined. (optional)
     * @param  int $seen Seen status, whether seen or not, 0/1, optional (optional)
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listBaseNotifications'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function listBaseNotificationsWithHttpInfo($dtable_uuid, $username = null, $contact_email = null, $seen = null, $page = null, $per_page = null, string $contentType = self::contentTypes['listBaseNotifications'][0])
    {
        $request = $this->listBaseNotificationsRequest($dtable_uuid, $username, $contact_email, $seen, $page, $per_page, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listBaseNotificationsAsync
     *
     * List Notifications
     *
     * @param  string $dtable_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $username Who you want to get the notifications of, optional (optional)
     * @param  string $contact_email The contact email of the user you&#39;re querying. Optional if &#x60;username&#x60; is defined. (optional)
     * @param  int $seen Seen status, whether seen or not, 0/1, optional (optional)
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listBaseNotifications'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listBaseNotificationsAsync($dtable_uuid, $username = null, $contact_email = null, $seen = null, $page = null, $per_page = null, string $contentType = self::contentTypes['listBaseNotifications'][0])
    {
        return $this->listBaseNotificationsAsyncWithHttpInfo($dtable_uuid, $username, $contact_email, $seen, $page, $per_page, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listBaseNotificationsAsyncWithHttpInfo
     *
     * List Notifications
     *
     * @param  string $dtable_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $username Who you want to get the notifications of, optional (optional)
     * @param  string $contact_email The contact email of the user you&#39;re querying. Optional if &#x60;username&#x60; is defined. (optional)
     * @param  int $seen Seen status, whether seen or not, 0/1, optional (optional)
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listBaseNotifications'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listBaseNotificationsAsyncWithHttpInfo($dtable_uuid, $username = null, $contact_email = null, $seen = null, $page = null, $per_page = null, string $contentType = self::contentTypes['listBaseNotifications'][0])
    {
        $returnType = 'object';
        $request = $this->listBaseNotificationsRequest($dtable_uuid, $username, $contact_email, $seen, $page, $per_page, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listBaseNotifications'
     *
     * @param  string $dtable_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $username Who you want to get the notifications of, optional (optional)
     * @param  string $contact_email The contact email of the user you&#39;re querying. Optional if &#x60;username&#x60; is defined. (optional)
     * @param  int $seen Seen status, whether seen or not, 0/1, optional (optional)
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listBaseNotifications'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listBaseNotificationsRequest($dtable_uuid, $username = null, $contact_email = null, $seen = null, $page = null, $per_page = null, string $contentType = self::contentTypes['listBaseNotifications'][0])
    {

        // verify the required parameter 'dtable_uuid' is set
        if ($dtable_uuid === null || (is_array($dtable_uuid) && count($dtable_uuid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $dtable_uuid when calling listBaseNotifications'
            );
        }
        if (!preg_match("/^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/", $dtable_uuid)) {
            throw new \InvalidArgumentException("invalid value for \"dtable_uuid\" when calling BasesApi.listBaseNotifications, must conform to the pattern /^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/.");
        }
        

        if ($contact_email !== null && !preg_match("/^.*@.*$/", $contact_email)) {
            throw new \InvalidArgumentException("invalid value for \"contact_email\" when calling BasesApi.listBaseNotifications, must conform to the pattern /^.*@.*$/.");
        }
        

        if ($page !== null && $page < 1) {
            throw new \InvalidArgumentException('invalid value for "$page" when calling BasesApi.listBaseNotifications, must be bigger than or equal to 1.');
        }
        
        if ($per_page !== null && $per_page < 1) {
            throw new \InvalidArgumentException('invalid value for "$per_page" when calling BasesApi.listBaseNotifications, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v2.1/admin/dtable-notifications/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $dtable_uuid,
            'dtable_uuid', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $username,
            'username', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $contact_email,
            'contact_email', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $seen,
            'seen', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $per_page,
            'per_page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listTrashedBases
     *
     * List Trashed Bases
     *
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listTrashedBases'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function listTrashedBases($page = null, $per_page = null, string $contentType = self::contentTypes['listTrashedBases'][0])
    {
        list($response) = $this->listTrashedBasesWithHttpInfo($page, $per_page, $contentType);
        return $response;
    }

    /**
     * Operation listTrashedBasesWithHttpInfo
     *
     * List Trashed Bases
     *
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listTrashedBases'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function listTrashedBasesWithHttpInfo($page = null, $per_page = null, string $contentType = self::contentTypes['listTrashedBases'][0])
    {
        $request = $this->listTrashedBasesRequest($page, $per_page, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listTrashedBasesAsync
     *
     * List Trashed Bases
     *
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listTrashedBases'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listTrashedBasesAsync($page = null, $per_page = null, string $contentType = self::contentTypes['listTrashedBases'][0])
    {
        return $this->listTrashedBasesAsyncWithHttpInfo($page, $per_page, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listTrashedBasesAsyncWithHttpInfo
     *
     * List Trashed Bases
     *
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listTrashedBases'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listTrashedBasesAsyncWithHttpInfo($page = null, $per_page = null, string $contentType = self::contentTypes['listTrashedBases'][0])
    {
        $returnType = 'object';
        $request = $this->listTrashedBasesRequest($page, $per_page, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listTrashedBases'
     *
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listTrashedBases'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listTrashedBasesRequest($page = null, $per_page = null, string $contentType = self::contentTypes['listTrashedBases'][0])
    {

        if ($page !== null && $page < 1) {
            throw new \InvalidArgumentException('invalid value for "$page" when calling BasesApi.listTrashedBases, must be bigger than or equal to 1.');
        }
        
        if ($per_page !== null && $per_page < 1) {
            throw new \InvalidArgumentException('invalid value for "$per_page" when calling BasesApi.listTrashedBases, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v2.1/admin/trash-dtables/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $per_page,
            'per_page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);




        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listUsersBases
     *
     * List User&#39;s Bases
     *
     * @param  string $user_id The unique user id in the form ...@auth.local. This is not the email address of the user. (required)
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listUsersBases'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function listUsersBases($user_id, $page = null, $per_page = null, string $contentType = self::contentTypes['listUsersBases'][0])
    {
        list($response) = $this->listUsersBasesWithHttpInfo($user_id, $page, $per_page, $contentType);
        return $response;
    }

    /**
     * Operation listUsersBasesWithHttpInfo
     *
     * List User&#39;s Bases
     *
     * @param  string $user_id The unique user id in the form ...@auth.local. This is not the email address of the user. (required)
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listUsersBases'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function listUsersBasesWithHttpInfo($user_id, $page = null, $per_page = null, string $contentType = self::contentTypes['listUsersBases'][0])
    {
        $request = $this->listUsersBasesRequest($user_id, $page, $per_page, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listUsersBasesAsync
     *
     * List User&#39;s Bases
     *
     * @param  string $user_id The unique user id in the form ...@auth.local. This is not the email address of the user. (required)
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listUsersBases'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listUsersBasesAsync($user_id, $page = null, $per_page = null, string $contentType = self::contentTypes['listUsersBases'][0])
    {
        return $this->listUsersBasesAsyncWithHttpInfo($user_id, $page, $per_page, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listUsersBasesAsyncWithHttpInfo
     *
     * List User&#39;s Bases
     *
     * @param  string $user_id The unique user id in the form ...@auth.local. This is not the email address of the user. (required)
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listUsersBases'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listUsersBasesAsyncWithHttpInfo($user_id, $page = null, $per_page = null, string $contentType = self::contentTypes['listUsersBases'][0])
    {
        $returnType = 'object';
        $request = $this->listUsersBasesRequest($user_id, $page, $per_page, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listUsersBases'
     *
     * @param  string $user_id The unique user id in the form ...@auth.local. This is not the email address of the user. (required)
     * @param  int $page The page number you want to start showing the entries. If no value is provided, 1 will be used. (optional)
     * @param  int $per_page The number of results that should be returned. If no value is provided, 25 results will be returned. (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listUsersBases'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listUsersBasesRequest($user_id, $page = null, $per_page = null, string $contentType = self::contentTypes['listUsersBases'][0])
    {

        // verify the required parameter 'user_id' is set
        if ($user_id === null || (is_array($user_id) && count($user_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $user_id when calling listUsersBases'
            );
        }
        if (!preg_match("/^[a-f0-9]{32}(@auth.local)$/", $user_id)) {
            throw new \InvalidArgumentException("invalid value for \"user_id\" when calling BasesApi.listUsersBases, must conform to the pattern /^[a-f0-9]{32}(@auth.local)$/.");
        }
        
        if ($page !== null && $page < 1) {
            throw new \InvalidArgumentException('invalid value for "$page" when calling BasesApi.listUsersBases, must be bigger than or equal to 1.');
        }
        
        if ($per_page !== null && $per_page < 1) {
            throw new \InvalidArgumentException('invalid value for "$per_page" when calling BasesApi.listUsersBases, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api/v2.1/admin/users/{user_id}/dtables/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $per_page,
            'per_page', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($user_id !== null) {
            $resourcePath = str_replace(
                '{' . 'user_id' . '}',
                ObjectSerializer::toPathValue($user_id),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation restoreTrashedBase
     *
     * Restore Trashed Base
     *
     * @param  string $base_id The id of the base. This is not the base_uuid. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['restoreTrashedBase'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function restoreTrashedBase($base_id, string $contentType = self::contentTypes['restoreTrashedBase'][0])
    {
        list($response) = $this->restoreTrashedBaseWithHttpInfo($base_id, $contentType);
        return $response;
    }

    /**
     * Operation restoreTrashedBaseWithHttpInfo
     *
     * Restore Trashed Base
     *
     * @param  string $base_id The id of the base. This is not the base_uuid. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['restoreTrashedBase'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function restoreTrashedBaseWithHttpInfo($base_id, string $contentType = self::contentTypes['restoreTrashedBase'][0])
    {
        $request = $this->restoreTrashedBaseRequest($base_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation restoreTrashedBaseAsync
     *
     * Restore Trashed Base
     *
     * @param  string $base_id The id of the base. This is not the base_uuid. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['restoreTrashedBase'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function restoreTrashedBaseAsync($base_id, string $contentType = self::contentTypes['restoreTrashedBase'][0])
    {
        return $this->restoreTrashedBaseAsyncWithHttpInfo($base_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation restoreTrashedBaseAsyncWithHttpInfo
     *
     * Restore Trashed Base
     *
     * @param  string $base_id The id of the base. This is not the base_uuid. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['restoreTrashedBase'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function restoreTrashedBaseAsyncWithHttpInfo($base_id, string $contentType = self::contentTypes['restoreTrashedBase'][0])
    {
        $returnType = 'object';
        $request = $this->restoreTrashedBaseRequest($base_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'restoreTrashedBase'
     *
     * @param  string $base_id The id of the base. This is not the base_uuid. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['restoreTrashedBase'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function restoreTrashedBaseRequest($base_id, string $contentType = self::contentTypes['restoreTrashedBase'][0])
    {

        // verify the required parameter 'base_id' is set
        if ($base_id === null || (is_array($base_id) && count($base_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_id when calling restoreTrashedBase'
            );
        }


        $resourcePath = '/api/v2.1/admin/trash-dtables/{base_id}/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($base_id !== null) {
            $resourcePath = str_replace(
                '{' . 'base_id' . '}',
                ObjectSerializer::toPathValue($base_id),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
