<?php
/**
 * UpdateView
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Base Operations (from 4.4)
 *
 * The official SeaTable API Reference (OpenAPI 3.0).
 *
 * The version of the OpenAPI document: 5.0
 * Generated by: https://openapi-generator.tech
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SeaTable\Client\Base;

use \ArrayAccess;
use \SeaTable\Client\ObjectSerializer;

/**
 * UpdateView Class Doc Comment
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class UpdateView implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'update_view';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'name' => 'string',
        'is_locked' => 'bool',
        'filters' => '\SeaTable\Client\Base\UpdateViewFiltersInner[]',
        'filter_conjunction' => '\SeaTable\Client\Base\FilterConjunction',
        'sorts' => '\SeaTable\Client\Base\SortsInner[]',
        'groupbys' => '\SeaTable\Client\Base\SortsInner[]',
        'hidden_columns' => 'string[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'name' => null,
        'is_locked' => null,
        'filters' => null,
        'filter_conjunction' => null,
        'sorts' => null,
        'groupbys' => null,
        'hidden_columns' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'name' => false,
        'is_locked' => false,
        'filters' => false,
        'filter_conjunction' => false,
        'sorts' => false,
        'groupbys' => false,
        'hidden_columns' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'name' => 'name',
        'is_locked' => 'is_locked',
        'filters' => 'filters',
        'filter_conjunction' => 'filter_conjunction',
        'sorts' => 'sorts',
        'groupbys' => 'groupbys',
        'hidden_columns' => 'hidden_columns'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'name' => 'setName',
        'is_locked' => 'setIsLocked',
        'filters' => 'setFilters',
        'filter_conjunction' => 'setFilterConjunction',
        'sorts' => 'setSorts',
        'groupbys' => 'setGroupbys',
        'hidden_columns' => 'setHiddenColumns'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'name' => 'getName',
        'is_locked' => 'getIsLocked',
        'filters' => 'getFilters',
        'filter_conjunction' => 'getFilterConjunction',
        'sorts' => 'getSorts',
        'groupbys' => 'getGroupbys',
        'hidden_columns' => 'getHiddenColumns'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('name', $data ?? [], null);
        $this->setIfExists('is_locked', $data ?? [], null);
        $this->setIfExists('filters', $data ?? [], null);
        $this->setIfExists('filter_conjunction', $data ?? [], null);
        $this->setIfExists('sorts', $data ?? [], null);
        $this->setIfExists('groupbys', $data ?? [], null);
        $this->setIfExists('hidden_columns', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name The new name of the view, if you want to give the view a new name.
     *
     * @return self
     */
    public function setName($name)
    {
        if (is_null($name)) {
            throw new \InvalidArgumentException('non-nullable name cannot be null');
        }
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets is_locked
     *
     * @return bool|null
     */
    public function getIsLocked()
    {
        return $this->container['is_locked'];
    }

    /**
     * Sets is_locked
     *
     * @param bool|null $is_locked is_locked
     *
     * @return self
     */
    public function setIsLocked($is_locked)
    {
        if (is_null($is_locked)) {
            throw new \InvalidArgumentException('non-nullable is_locked cannot be null');
        }
        $this->container['is_locked'] = $is_locked;

        return $this;
    }

    /**
     * Gets filters
     *
     * @return \SeaTable\Client\Base\UpdateViewFiltersInner[]|null
     */
    public function getFilters()
    {
        return $this->container['filters'];
    }

    /**
     * Sets filters
     *
     * @param \SeaTable\Client\Base\UpdateViewFiltersInner[]|null $filters filter of your view
     *
     * @return self
     */
    public function setFilters($filters)
    {
        if (is_null($filters)) {
            throw new \InvalidArgumentException('non-nullable filters cannot be null');
        }
        $this->container['filters'] = $filters;

        return $this;
    }

    /**
     * Gets filter_conjunction
     *
     * @return \SeaTable\Client\Base\FilterConjunction|null
     */
    public function getFilterConjunction()
    {
        return $this->container['filter_conjunction'];
    }

    /**
     * Sets filter_conjunction
     *
     * @param \SeaTable\Client\Base\FilterConjunction|null $filter_conjunction filter_conjunction
     *
     * @return self
     */
    public function setFilterConjunction($filter_conjunction)
    {
        if (is_null($filter_conjunction)) {
            throw new \InvalidArgumentException('non-nullable filter_conjunction cannot be null');
        }
        $this->container['filter_conjunction'] = $filter_conjunction;

        return $this;
    }

    /**
     * Gets sorts
     *
     * @return \SeaTable\Client\Base\SortsInner[]|null
     */
    public function getSorts()
    {
        return $this->container['sorts'];
    }

    /**
     * Sets sorts
     *
     * @param \SeaTable\Client\Base\SortsInner[]|null $sorts sorting of your view
     *
     * @return self
     */
    public function setSorts($sorts)
    {
        if (is_null($sorts)) {
            throw new \InvalidArgumentException('non-nullable sorts cannot be null');
        }
        $this->container['sorts'] = $sorts;

        return $this;
    }

    /**
     * Gets groupbys
     *
     * @return \SeaTable\Client\Base\SortsInner[]|null
     */
    public function getGroupbys()
    {
        return $this->container['groupbys'];
    }

    /**
     * Sets groupbys
     *
     * @param \SeaTable\Client\Base\SortsInner[]|null $groupbys grouping of your view
     *
     * @return self
     */
    public function setGroupbys($groupbys)
    {
        if (is_null($groupbys)) {
            throw new \InvalidArgumentException('non-nullable groupbys cannot be null');
        }
        $this->container['groupbys'] = $groupbys;

        return $this;
    }

    /**
     * Gets hidden_columns
     *
     * @return string[]|null
     */
    public function getHiddenColumns()
    {
        return $this->container['hidden_columns'];
    }

    /**
     * Sets hidden_columns
     *
     * @param string[]|null $hidden_columns IDs of the rows that should be hidden
     *
     * @return self
     */
    public function setHiddenColumns($hidden_columns)
    {
        if (is_null($hidden_columns)) {
            throw new \InvalidArgumentException('non-nullable hidden_columns cannot be null');
        }
        $this->container['hidden_columns'] = $hidden_columns;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


