<?php
/**
 * RowLinkCreateUpdateDelete
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Base Operations (from 4.4)
 *
 * The official SeaTable API Reference (OpenAPI 3.0).
 *
 * The version of the OpenAPI document: 5.0
 * Generated by: https://openapi-generator.tech
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SeaTable\Client\Base;

use \ArrayAccess;
use \SeaTable\Client\ObjectSerializer;

/**
 * RowLinkCreateUpdateDelete Class Doc Comment
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class RowLinkCreateUpdateDelete implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'row_link_create_update_delete';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'table_id' => 'string',
        'other_table_id' => 'string',
        'link_id' => 'string',
        'other_rows_ids_map' => 'array<string,string[]>'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'table_id' => null,
        'other_table_id' => null,
        'link_id' => null,
        'other_rows_ids_map' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'table_id' => false,
        'other_table_id' => false,
        'link_id' => false,
        'other_rows_ids_map' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'table_id' => 'table_id',
        'other_table_id' => 'other_table_id',
        'link_id' => 'link_id',
        'other_rows_ids_map' => 'other_rows_ids_map'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'table_id' => 'setTableId',
        'other_table_id' => 'setOtherTableId',
        'link_id' => 'setLinkId',
        'other_rows_ids_map' => 'setOtherRowsIdsMap'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'table_id' => 'getTableId',
        'other_table_id' => 'getOtherTableId',
        'link_id' => 'getLinkId',
        'other_rows_ids_map' => 'getOtherRowsIdsMap'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('table_id', $data ?? [], null);
        $this->setIfExists('other_table_id', $data ?? [], null);
        $this->setIfExists('link_id', $data ?? [], null);
        $this->setIfExists('other_rows_ids_map', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['table_id'] === null) {
            $invalidProperties[] = "'table_id' can't be null";
        }
        if (!preg_match("/^[a-zA-Z0-9]{4}$/", $this->container['table_id'])) {
            $invalidProperties[] = "invalid value for 'table_id', must be conform to the pattern /^[a-zA-Z0-9]{4}$/.";
        }

        if ($this->container['other_table_id'] === null) {
            $invalidProperties[] = "'other_table_id' can't be null";
        }
        if (!preg_match("/^[a-zA-Z0-9]{4}$/", $this->container['other_table_id'])) {
            $invalidProperties[] = "invalid value for 'other_table_id', must be conform to the pattern /^[a-zA-Z0-9]{4}$/.";
        }

        if ($this->container['link_id'] === null) {
            $invalidProperties[] = "'link_id' can't be null";
        }
        if ((mb_strlen($this->container['link_id']) > 4)) {
            $invalidProperties[] = "invalid value for 'link_id', the character length must be smaller than or equal to 4.";
        }

        if ((mb_strlen($this->container['link_id']) < 4)) {
            $invalidProperties[] = "invalid value for 'link_id', the character length must be bigger than or equal to 4.";
        }

        if ($this->container['other_rows_ids_map'] === null) {
            $invalidProperties[] = "'other_rows_ids_map' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets table_id
     *
     * @return string
     */
    public function getTableId()
    {
        return $this->container['table_id'];
    }

    /**
     * Sets table_id
     *
     * @param string $table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. In most calls it is possible to replace the `table_id` with the `table_name`.
     *
     * @return self
     */
    public function setTableId($table_id)
    {
        if (is_null($table_id)) {
            throw new \InvalidArgumentException('non-nullable table_id cannot be null');
        }

        if ((!preg_match("/^[a-zA-Z0-9]{4}$/", ObjectSerializer::toString($table_id)))) {
            throw new \InvalidArgumentException("invalid value for \$table_id when calling RowLinkCreateUpdateDelete., must conform to the pattern /^[a-zA-Z0-9]{4}$/.");
        }

        $this->container['table_id'] = $table_id;

        return $this;
    }

    /**
     * Gets other_table_id
     *
     * @return string
     */
    public function getOtherTableId()
    {
        return $this->container['other_table_id'];
    }

    /**
     * Sets other_table_id
     *
     * @param string $other_table_id The id of the table. The id of a table is unique inside a base and is often used to identify a table. In most calls it is possible to replace the `table_id` with the `table_name`.
     *
     * @return self
     */
    public function setOtherTableId($other_table_id)
    {
        if (is_null($other_table_id)) {
            throw new \InvalidArgumentException('non-nullable other_table_id cannot be null');
        }

        if ((!preg_match("/^[a-zA-Z0-9]{4}$/", ObjectSerializer::toString($other_table_id)))) {
            throw new \InvalidArgumentException("invalid value for \$other_table_id when calling RowLinkCreateUpdateDelete., must conform to the pattern /^[a-zA-Z0-9]{4}$/.");
        }

        $this->container['other_table_id'] = $other_table_id;

        return $this;
    }

    /**
     * Gets link_id
     *
     * @return string
     */
    public function getLinkId()
    {
        return $this->container['link_id'];
    }

    /**
     * Sets link_id
     *
     * @param string $link_id Every *link column* has a `key` and `link_id` in the column object. Use [Get Metadata](/reference/getmetadata) or [Get Base Info](/reference/getbaseinfo) to get this `link_id`. Don't use the `key` of the link column.
     *
     * @return self
     */
    public function setLinkId($link_id)
    {
        if (is_null($link_id)) {
            throw new \InvalidArgumentException('non-nullable link_id cannot be null');
        }
        if ((mb_strlen($link_id) > 4)) {
            throw new \InvalidArgumentException('invalid length for $link_id when calling RowLinkCreateUpdateDelete., must be smaller than or equal to 4.');
        }
        if ((mb_strlen($link_id) < 4)) {
            throw new \InvalidArgumentException('invalid length for $link_id when calling RowLinkCreateUpdateDelete., must be bigger than or equal to 4.');
        }

        $this->container['link_id'] = $link_id;

        return $this;
    }

    /**
     * Gets other_rows_ids_map
     *
     * @return array<string,string[]>
     */
    public function getOtherRowsIdsMap()
    {
        return $this->container['other_rows_ids_map'];
    }

    /**
     * Sets other_rows_ids_map
     *
     * @param array<string,string[]> $other_rows_ids_map Provide an object where each key is a `row_id` and each value is an array of other row_ids.
     *
     * @return self
     */
    public function setOtherRowsIdsMap($other_rows_ids_map)
    {
        if (is_null($other_rows_ids_map)) {
            throw new \InvalidArgumentException('non-nullable other_rows_ids_map cannot be null');
        }
        $this->container['other_rows_ids_map'] = $other_rows_ids_map;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


