<?php
/**
 * RowCommentsApi
 * PHP version 7.4
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Base Operations (from 4.4)
 *
 * The official SeaTable API Reference (OpenAPI 3.0).
 *
 * The version of the OpenAPI document: 5.0
 * Generated by: https://openapi-generator.tech
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SeaTable\Client\Base;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use SeaTable\Client\ApiException;
use SeaTable\Client\Configuration;
use SeaTable\Client\HeaderSelector;
use SeaTable\Client\ObjectSerializer;

/**
 * RowCommentsApi Class Doc Comment
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class RowCommentsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'deleteComment' => [
            'application/json',
        ],
        'getComment' => [
            'application/json',
        ],
        'getRowCommentsCount' => [
            'application/json',
        ],
        'listCommentsWithinDays' => [
            'application/json',
        ],
        'listRowComments' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation deleteComment
     *
     * Delete Comment
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  int $comment_id The id of the comment. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteComment'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function deleteComment($base_uuid, $comment_id, string $contentType = self::contentTypes['deleteComment'][0])
    {
        list($response) = $this->deleteCommentWithHttpInfo($base_uuid, $comment_id, $contentType);
        return $response;
    }

    /**
     * Operation deleteCommentWithHttpInfo
     *
     * Delete Comment
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  int $comment_id The id of the comment. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteComment'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteCommentWithHttpInfo($base_uuid, $comment_id, string $contentType = self::contentTypes['deleteComment'][0])
    {
        $request = $this->deleteCommentRequest($base_uuid, $comment_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteCommentAsync
     *
     * Delete Comment
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  int $comment_id The id of the comment. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteComment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteCommentAsync($base_uuid, $comment_id, string $contentType = self::contentTypes['deleteComment'][0])
    {
        return $this->deleteCommentAsyncWithHttpInfo($base_uuid, $comment_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteCommentAsyncWithHttpInfo
     *
     * Delete Comment
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  int $comment_id The id of the comment. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteComment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteCommentAsyncWithHttpInfo($base_uuid, $comment_id, string $contentType = self::contentTypes['deleteComment'][0])
    {
        $returnType = 'object';
        $request = $this->deleteCommentRequest($base_uuid, $comment_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteComment'
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  int $comment_id The id of the comment. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteComment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteCommentRequest($base_uuid, $comment_id, string $contentType = self::contentTypes['deleteComment'][0])
    {

        // verify the required parameter 'base_uuid' is set
        if ($base_uuid === null || (is_array($base_uuid) && count($base_uuid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_uuid when calling deleteComment'
            );
        }
        if (!preg_match("/^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/", $base_uuid)) {
            throw new \InvalidArgumentException("invalid value for \"base_uuid\" when calling RowCommentsApi.deleteComment, must conform to the pattern /^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/.");
        }
        
        // verify the required parameter 'comment_id' is set
        if ($comment_id === null || (is_array($comment_id) && count($comment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $comment_id when calling deleteComment'
            );
        }
        if ($comment_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$comment_id" when calling RowCommentsApi.deleteComment, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api-gateway/api/v2/dtables/{base_uuid}/comments/{comment_id}/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($base_uuid !== null) {
            $resourcePath = str_replace(
                '{' . 'base_uuid' . '}',
                ObjectSerializer::toPathValue($base_uuid),
                $resourcePath
            );
        }
        // path params
        if ($comment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'comment_id' . '}',
                ObjectSerializer::toPathValue($comment_id),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getComment
     *
     * Get Comment
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  int $comment_id The id of the comment. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getComment'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function getComment($base_uuid, $comment_id, string $contentType = self::contentTypes['getComment'][0])
    {
        list($response) = $this->getCommentWithHttpInfo($base_uuid, $comment_id, $contentType);
        return $response;
    }

    /**
     * Operation getCommentWithHttpInfo
     *
     * Get Comment
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  int $comment_id The id of the comment. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getComment'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function getCommentWithHttpInfo($base_uuid, $comment_id, string $contentType = self::contentTypes['getComment'][0])
    {
        $request = $this->getCommentRequest($base_uuid, $comment_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getCommentAsync
     *
     * Get Comment
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  int $comment_id The id of the comment. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getComment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCommentAsync($base_uuid, $comment_id, string $contentType = self::contentTypes['getComment'][0])
    {
        return $this->getCommentAsyncWithHttpInfo($base_uuid, $comment_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getCommentAsyncWithHttpInfo
     *
     * Get Comment
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  int $comment_id The id of the comment. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getComment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getCommentAsyncWithHttpInfo($base_uuid, $comment_id, string $contentType = self::contentTypes['getComment'][0])
    {
        $returnType = 'object';
        $request = $this->getCommentRequest($base_uuid, $comment_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getComment'
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  int $comment_id The id of the comment. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getComment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getCommentRequest($base_uuid, $comment_id, string $contentType = self::contentTypes['getComment'][0])
    {

        // verify the required parameter 'base_uuid' is set
        if ($base_uuid === null || (is_array($base_uuid) && count($base_uuid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_uuid when calling getComment'
            );
        }
        if (!preg_match("/^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/", $base_uuid)) {
            throw new \InvalidArgumentException("invalid value for \"base_uuid\" when calling RowCommentsApi.getComment, must conform to the pattern /^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/.");
        }
        
        // verify the required parameter 'comment_id' is set
        if ($comment_id === null || (is_array($comment_id) && count($comment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $comment_id when calling getComment'
            );
        }
        if ($comment_id < 1) {
            throw new \InvalidArgumentException('invalid value for "$comment_id" when calling RowCommentsApi.getComment, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api-gateway/api/v2/dtables/{base_uuid}/comments/{comment_id}/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($base_uuid !== null) {
            $resourcePath = str_replace(
                '{' . 'base_uuid' . '}',
                ObjectSerializer::toPathValue($base_uuid),
                $resourcePath
            );
        }
        // path params
        if ($comment_id !== null) {
            $resourcePath = str_replace(
                '{' . 'comment_id' . '}',
                ObjectSerializer::toPathValue($comment_id),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getRowCommentsCount
     *
     * Get Row Comments Count
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $row_id Unique id of a row. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRowCommentsCount'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function getRowCommentsCount($base_uuid, $row_id, string $contentType = self::contentTypes['getRowCommentsCount'][0])
    {
        list($response) = $this->getRowCommentsCountWithHttpInfo($base_uuid, $row_id, $contentType);
        return $response;
    }

    /**
     * Operation getRowCommentsCountWithHttpInfo
     *
     * Get Row Comments Count
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $row_id Unique id of a row. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRowCommentsCount'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function getRowCommentsCountWithHttpInfo($base_uuid, $row_id, string $contentType = self::contentTypes['getRowCommentsCount'][0])
    {
        $request = $this->getRowCommentsCountRequest($base_uuid, $row_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getRowCommentsCountAsync
     *
     * Get Row Comments Count
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $row_id Unique id of a row. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRowCommentsCount'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getRowCommentsCountAsync($base_uuid, $row_id, string $contentType = self::contentTypes['getRowCommentsCount'][0])
    {
        return $this->getRowCommentsCountAsyncWithHttpInfo($base_uuid, $row_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getRowCommentsCountAsyncWithHttpInfo
     *
     * Get Row Comments Count
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $row_id Unique id of a row. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRowCommentsCount'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getRowCommentsCountAsyncWithHttpInfo($base_uuid, $row_id, string $contentType = self::contentTypes['getRowCommentsCount'][0])
    {
        $returnType = 'object';
        $request = $this->getRowCommentsCountRequest($base_uuid, $row_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getRowCommentsCount'
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $row_id Unique id of a row. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getRowCommentsCount'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getRowCommentsCountRequest($base_uuid, $row_id, string $contentType = self::contentTypes['getRowCommentsCount'][0])
    {

        // verify the required parameter 'base_uuid' is set
        if ($base_uuid === null || (is_array($base_uuid) && count($base_uuid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_uuid when calling getRowCommentsCount'
            );
        }
        if (!preg_match("/^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/", $base_uuid)) {
            throw new \InvalidArgumentException("invalid value for \"base_uuid\" when calling RowCommentsApi.getRowCommentsCount, must conform to the pattern /^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/.");
        }
        
        // verify the required parameter 'row_id' is set
        if ($row_id === null || (is_array($row_id) && count($row_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $row_id when calling getRowCommentsCount'
            );
        }
        if (!preg_match("/^[A-Za-z0-9\\-\\_]{22}$/", $row_id)) {
            throw new \InvalidArgumentException("invalid value for \"row_id\" when calling RowCommentsApi.getRowCommentsCount, must conform to the pattern /^[A-Za-z0-9\\-\\_]{22}$/.");
        }
        

        $resourcePath = '/api-gateway/api/v2/dtables/{base_uuid}/comments-count/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $row_id,
            'row_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($base_uuid !== null) {
            $resourcePath = str_replace(
                '{' . 'base_uuid' . '}',
                ObjectSerializer::toPathValue($base_uuid),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listCommentsWithinDays
     *
     * List Comments within Days
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  int $days days (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listCommentsWithinDays'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function listCommentsWithinDays($base_uuid, $days = null, string $contentType = self::contentTypes['listCommentsWithinDays'][0])
    {
        list($response) = $this->listCommentsWithinDaysWithHttpInfo($base_uuid, $days, $contentType);
        return $response;
    }

    /**
     * Operation listCommentsWithinDaysWithHttpInfo
     *
     * List Comments within Days
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  int $days (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listCommentsWithinDays'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function listCommentsWithinDaysWithHttpInfo($base_uuid, $days = null, string $contentType = self::contentTypes['listCommentsWithinDays'][0])
    {
        $request = $this->listCommentsWithinDaysRequest($base_uuid, $days, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listCommentsWithinDaysAsync
     *
     * List Comments within Days
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  int $days (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listCommentsWithinDays'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listCommentsWithinDaysAsync($base_uuid, $days = null, string $contentType = self::contentTypes['listCommentsWithinDays'][0])
    {
        return $this->listCommentsWithinDaysAsyncWithHttpInfo($base_uuid, $days, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listCommentsWithinDaysAsyncWithHttpInfo
     *
     * List Comments within Days
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  int $days (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listCommentsWithinDays'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listCommentsWithinDaysAsyncWithHttpInfo($base_uuid, $days = null, string $contentType = self::contentTypes['listCommentsWithinDays'][0])
    {
        $returnType = 'object';
        $request = $this->listCommentsWithinDaysRequest($base_uuid, $days, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listCommentsWithinDays'
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  int $days (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listCommentsWithinDays'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listCommentsWithinDaysRequest($base_uuid, $days = null, string $contentType = self::contentTypes['listCommentsWithinDays'][0])
    {

        // verify the required parameter 'base_uuid' is set
        if ($base_uuid === null || (is_array($base_uuid) && count($base_uuid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_uuid when calling listCommentsWithinDays'
            );
        }
        if (!preg_match("/^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/", $base_uuid)) {
            throw new \InvalidArgumentException("invalid value for \"base_uuid\" when calling RowCommentsApi.listCommentsWithinDays, must conform to the pattern /^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/.");
        }
        
        if ($days !== null && $days < 1) {
            throw new \InvalidArgumentException('invalid value for "$days" when calling RowCommentsApi.listCommentsWithinDays, must be bigger than or equal to 1.');
        }
        

        $resourcePath = '/api-gateway/api/v2/dtables/{base_uuid}/comments-within-days/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $days,
            'days', // param base name
            'integer', // openApiType
            'form', // style
            true, // explode
            false // required
        ) ?? []);


        // path params
        if ($base_uuid !== null) {
            $resourcePath = str_replace(
                '{' . 'base_uuid' . '}',
                ObjectSerializer::toPathValue($base_uuid),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listRowComments
     *
     * List Row Comments
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $row_id Unique id of a row. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listRowComments'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function listRowComments($base_uuid, $row_id, string $contentType = self::contentTypes['listRowComments'][0])
    {
        list($response) = $this->listRowCommentsWithHttpInfo($base_uuid, $row_id, $contentType);
        return $response;
    }

    /**
     * Operation listRowCommentsWithHttpInfo
     *
     * List Row Comments
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $row_id Unique id of a row. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listRowComments'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function listRowCommentsWithHttpInfo($base_uuid, $row_id, string $contentType = self::contentTypes['listRowComments'][0])
    {
        $request = $this->listRowCommentsRequest($base_uuid, $row_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listRowCommentsAsync
     *
     * List Row Comments
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $row_id Unique id of a row. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listRowComments'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listRowCommentsAsync($base_uuid, $row_id, string $contentType = self::contentTypes['listRowComments'][0])
    {
        return $this->listRowCommentsAsyncWithHttpInfo($base_uuid, $row_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listRowCommentsAsyncWithHttpInfo
     *
     * List Row Comments
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $row_id Unique id of a row. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listRowComments'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listRowCommentsAsyncWithHttpInfo($base_uuid, $row_id, string $contentType = self::contentTypes['listRowComments'][0])
    {
        $returnType = 'object';
        $request = $this->listRowCommentsRequest($base_uuid, $row_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listRowComments'
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  string $row_id Unique id of a row. (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listRowComments'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listRowCommentsRequest($base_uuid, $row_id, string $contentType = self::contentTypes['listRowComments'][0])
    {

        // verify the required parameter 'base_uuid' is set
        if ($base_uuid === null || (is_array($base_uuid) && count($base_uuid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_uuid when calling listRowComments'
            );
        }
        if (!preg_match("/^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/", $base_uuid)) {
            throw new \InvalidArgumentException("invalid value for \"base_uuid\" when calling RowCommentsApi.listRowComments, must conform to the pattern /^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/.");
        }
        
        // verify the required parameter 'row_id' is set
        if ($row_id === null || (is_array($row_id) && count($row_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $row_id when calling listRowComments'
            );
        }
        if (!preg_match("/^[A-Za-z0-9\\-\\_]{22}$/", $row_id)) {
            throw new \InvalidArgumentException("invalid value for \"row_id\" when calling RowCommentsApi.listRowComments, must conform to the pattern /^[A-Za-z0-9\\-\\_]{22}$/.");
        }
        

        $resourcePath = '/api-gateway/api/v2/dtables/{base_uuid}/comments/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $row_id,
            'row_id', // param base name
            'string', // openApiType
            'form', // style
            true, // explode
            true // required
        ) ?? []);


        // path params
        if ($base_uuid !== null) {
            $resourcePath = str_replace(
                '{' . 'base_uuid' . '}',
                ObjectSerializer::toPathValue($base_uuid),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
