<?php
/**
 * RatingColumnFormat
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Base Operations (from 4.4)
 *
 * The official SeaTable API Reference (OpenAPI 3.0).
 *
 * The version of the OpenAPI document: 5.0
 * Generated by: https://openapi-generator.tech
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SeaTable\Client\Base;

use \ArrayAccess;
use \SeaTable\Client\ObjectSerializer;

/**
 * RatingColumnFormat Class Doc Comment
 *
 * @category Class
 * @description Specify the rating column.
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class RatingColumnFormat implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'rating_column_format';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'rate_max_number' => 'int',
        'rate_style_color' => 'string',
        'rate_style_type' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'rate_max_number' => null,
        'rate_style_color' => null,
        'rate_style_type' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'rate_max_number' => false,
        'rate_style_color' => false,
        'rate_style_type' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'rate_max_number' => 'rate_max_number',
        'rate_style_color' => 'rate_style_color',
        'rate_style_type' => 'rate_style_type'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'rate_max_number' => 'setRateMaxNumber',
        'rate_style_color' => 'setRateStyleColor',
        'rate_style_type' => 'setRateStyleType'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'rate_max_number' => 'getRateMaxNumber',
        'rate_style_color' => 'getRateStyleColor',
        'rate_style_type' => 'getRateStyleType'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const RATE_STYLE_TYPE_RATE = 'dtable-icon-rate';
    public const RATE_STYLE_TYPE_LIKE = 'dtable-icon-like';
    public const RATE_STYLE_TYPE_PRAISE = 'dtable-icon-praise';
    public const RATE_STYLE_TYPE_FLAG = 'dtable-icon-flag';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getRateStyleTypeAllowableValues()
    {
        return [
            self::RATE_STYLE_TYPE_RATE,
            self::RATE_STYLE_TYPE_LIKE,
            self::RATE_STYLE_TYPE_PRAISE,
            self::RATE_STYLE_TYPE_FLAG,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('rate_max_number', $data ?? [], null);
        $this->setIfExists('rate_style_color', $data ?? [], null);
        $this->setIfExists('rate_style_type', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['rate_max_number']) && ($this->container['rate_max_number'] > 10)) {
            $invalidProperties[] = "invalid value for 'rate_max_number', must be smaller than or equal to 10.";
        }

        if (!is_null($this->container['rate_max_number']) && ($this->container['rate_max_number'] < 0)) {
            $invalidProperties[] = "invalid value for 'rate_max_number', must be bigger than or equal to 0.";
        }

        if (!is_null($this->container['rate_style_color']) && !preg_match("/^#[A-Fa-f0-9]{6}$/", $this->container['rate_style_color'])) {
            $invalidProperties[] = "invalid value for 'rate_style_color', must be conform to the pattern /^#[A-Fa-f0-9]{6}$/.";
        }

        $allowedValues = $this->getRateStyleTypeAllowableValues();
        if (!is_null($this->container['rate_style_type']) && !in_array($this->container['rate_style_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'rate_style_type', must be one of '%s'",
                $this->container['rate_style_type'],
                implode("', '", $allowedValues)
            );
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets rate_max_number
     *
     * @return int|null
     */
    public function getRateMaxNumber()
    {
        return $this->container['rate_max_number'];
    }

    /**
     * Sets rate_max_number
     *
     * @param int|null $rate_max_number rate_max_number
     *
     * @return self
     */
    public function setRateMaxNumber($rate_max_number)
    {
        if (is_null($rate_max_number)) {
            throw new \InvalidArgumentException('non-nullable rate_max_number cannot be null');
        }

        if (($rate_max_number > 10)) {
            throw new \InvalidArgumentException('invalid value for $rate_max_number when calling RatingColumnFormat., must be smaller than or equal to 10.');
        }
        if (($rate_max_number < 0)) {
            throw new \InvalidArgumentException('invalid value for $rate_max_number when calling RatingColumnFormat., must be bigger than or equal to 0.');
        }

        $this->container['rate_max_number'] = $rate_max_number;

        return $this;
    }

    /**
     * Gets rate_style_color
     *
     * @return string|null
     */
    public function getRateStyleColor()
    {
        return $this->container['rate_style_color'];
    }

    /**
     * Sets rate_style_color
     *
     * @param string|null $rate_style_color rate_style_color
     *
     * @return self
     */
    public function setRateStyleColor($rate_style_color)
    {
        if (is_null($rate_style_color)) {
            throw new \InvalidArgumentException('non-nullable rate_style_color cannot be null');
        }

        if ((!preg_match("/^#[A-Fa-f0-9]{6}$/", ObjectSerializer::toString($rate_style_color)))) {
            throw new \InvalidArgumentException("invalid value for \$rate_style_color when calling RatingColumnFormat., must conform to the pattern /^#[A-Fa-f0-9]{6}$/.");
        }

        $this->container['rate_style_color'] = $rate_style_color;

        return $this;
    }

    /**
     * Gets rate_style_type
     *
     * @return string|null
     */
    public function getRateStyleType()
    {
        return $this->container['rate_style_type'];
    }

    /**
     * Sets rate_style_type
     *
     * @param string|null $rate_style_type rate_style_type
     *
     * @return self
     */
    public function setRateStyleType($rate_style_type)
    {
        if (is_null($rate_style_type)) {
            throw new \InvalidArgumentException('non-nullable rate_style_type cannot be null');
        }
        $allowedValues = $this->getRateStyleTypeAllowableValues();
        if (!in_array($rate_style_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'rate_style_type', must be one of '%s'",
                    $rate_style_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['rate_style_type'] = $rate_style_type;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


