<?php
/**
 * LinksApi
 * PHP version 7.4
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Base Operations (from 4.4)
 *
 * The official SeaTable API Reference (OpenAPI 3.0).
 *
 * The version of the OpenAPI document: 5.0
 * Generated by: https://openapi-generator.tech
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SeaTable\Client\Base;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use SeaTable\Client\ApiException;
use SeaTable\Client\Configuration;
use SeaTable\Client\HeaderSelector;
use SeaTable\Client\ObjectSerializer;

/**
 * LinksApi Class Doc Comment
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class LinksApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createRowLink' => [
            'application/json',
        ],
        'deleteRowLink' => [
            'application/json',
        ],
        'listRowLinks' => [
            'application/json',
        ],
        'updateRowLink' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createRowLink
     *
     * Create Row Link(s)
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  \SeaTable\Client\Base\RowLinkCreateUpdateDelete $row_link_create_update_delete row_link_create_update_delete (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createRowLink'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function createRowLink($base_uuid, $row_link_create_update_delete = null, string $contentType = self::contentTypes['createRowLink'][0])
    {
        list($response) = $this->createRowLinkWithHttpInfo($base_uuid, $row_link_create_update_delete, $contentType);
        return $response;
    }

    /**
     * Operation createRowLinkWithHttpInfo
     *
     * Create Row Link(s)
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  \SeaTable\Client\Base\RowLinkCreateUpdateDelete $row_link_create_update_delete (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createRowLink'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function createRowLinkWithHttpInfo($base_uuid, $row_link_create_update_delete = null, string $contentType = self::contentTypes['createRowLink'][0])
    {
        $request = $this->createRowLinkRequest($base_uuid, $row_link_create_update_delete, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createRowLinkAsync
     *
     * Create Row Link(s)
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  \SeaTable\Client\Base\RowLinkCreateUpdateDelete $row_link_create_update_delete (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createRowLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createRowLinkAsync($base_uuid, $row_link_create_update_delete = null, string $contentType = self::contentTypes['createRowLink'][0])
    {
        return $this->createRowLinkAsyncWithHttpInfo($base_uuid, $row_link_create_update_delete, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createRowLinkAsyncWithHttpInfo
     *
     * Create Row Link(s)
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  \SeaTable\Client\Base\RowLinkCreateUpdateDelete $row_link_create_update_delete (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createRowLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createRowLinkAsyncWithHttpInfo($base_uuid, $row_link_create_update_delete = null, string $contentType = self::contentTypes['createRowLink'][0])
    {
        $returnType = 'object';
        $request = $this->createRowLinkRequest($base_uuid, $row_link_create_update_delete, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createRowLink'
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  \SeaTable\Client\Base\RowLinkCreateUpdateDelete $row_link_create_update_delete (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createRowLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createRowLinkRequest($base_uuid, $row_link_create_update_delete = null, string $contentType = self::contentTypes['createRowLink'][0])
    {

        // verify the required parameter 'base_uuid' is set
        if ($base_uuid === null || (is_array($base_uuid) && count($base_uuid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_uuid when calling createRowLink'
            );
        }
        if (!preg_match("/^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/", $base_uuid)) {
            throw new \InvalidArgumentException("invalid value for \"base_uuid\" when calling LinksApi.createRowLink, must conform to the pattern /^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/.");
        }
        


        $resourcePath = '/api-gateway/api/v2/dtables/{base_uuid}/links/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($base_uuid !== null) {
            $resourcePath = str_replace(
                '{' . 'base_uuid' . '}',
                ObjectSerializer::toPathValue($base_uuid),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($row_link_create_update_delete)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($row_link_create_update_delete));
            } else {
                $httpBody = $row_link_create_update_delete;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteRowLink
     *
     * Delete Row Link(s)
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  \SeaTable\Client\Base\RowLinkCreateUpdateDelete $row_link_create_update_delete row_link_create_update_delete (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteRowLink'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function deleteRowLink($base_uuid, $row_link_create_update_delete = null, string $contentType = self::contentTypes['deleteRowLink'][0])
    {
        list($response) = $this->deleteRowLinkWithHttpInfo($base_uuid, $row_link_create_update_delete, $contentType);
        return $response;
    }

    /**
     * Operation deleteRowLinkWithHttpInfo
     *
     * Delete Row Link(s)
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  \SeaTable\Client\Base\RowLinkCreateUpdateDelete $row_link_create_update_delete (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteRowLink'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteRowLinkWithHttpInfo($base_uuid, $row_link_create_update_delete = null, string $contentType = self::contentTypes['deleteRowLink'][0])
    {
        $request = $this->deleteRowLinkRequest($base_uuid, $row_link_create_update_delete, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation deleteRowLinkAsync
     *
     * Delete Row Link(s)
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  \SeaTable\Client\Base\RowLinkCreateUpdateDelete $row_link_create_update_delete (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteRowLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteRowLinkAsync($base_uuid, $row_link_create_update_delete = null, string $contentType = self::contentTypes['deleteRowLink'][0])
    {
        return $this->deleteRowLinkAsyncWithHttpInfo($base_uuid, $row_link_create_update_delete, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteRowLinkAsyncWithHttpInfo
     *
     * Delete Row Link(s)
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  \SeaTable\Client\Base\RowLinkCreateUpdateDelete $row_link_create_update_delete (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteRowLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteRowLinkAsyncWithHttpInfo($base_uuid, $row_link_create_update_delete = null, string $contentType = self::contentTypes['deleteRowLink'][0])
    {
        $returnType = 'object';
        $request = $this->deleteRowLinkRequest($base_uuid, $row_link_create_update_delete, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteRowLink'
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  \SeaTable\Client\Base\RowLinkCreateUpdateDelete $row_link_create_update_delete (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteRowLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteRowLinkRequest($base_uuid, $row_link_create_update_delete = null, string $contentType = self::contentTypes['deleteRowLink'][0])
    {

        // verify the required parameter 'base_uuid' is set
        if ($base_uuid === null || (is_array($base_uuid) && count($base_uuid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_uuid when calling deleteRowLink'
            );
        }
        if (!preg_match("/^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/", $base_uuid)) {
            throw new \InvalidArgumentException("invalid value for \"base_uuid\" when calling LinksApi.deleteRowLink, must conform to the pattern /^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/.");
        }
        


        $resourcePath = '/api-gateway/api/v2/dtables/{base_uuid}/links/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($base_uuid !== null) {
            $resourcePath = str_replace(
                '{' . 'base_uuid' . '}',
                ObjectSerializer::toPathValue($base_uuid),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($row_link_create_update_delete)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($row_link_create_update_delete));
            } else {
                $httpBody = $row_link_create_update_delete;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listRowLinks
     *
     * List Row Links
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  \SeaTable\Client\Base\ListRowLinks $list_row_links list_row_links (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listRowLinks'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function listRowLinks($base_uuid, $list_row_links = null, string $contentType = self::contentTypes['listRowLinks'][0])
    {
        list($response) = $this->listRowLinksWithHttpInfo($base_uuid, $list_row_links, $contentType);
        return $response;
    }

    /**
     * Operation listRowLinksWithHttpInfo
     *
     * List Row Links
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  \SeaTable\Client\Base\ListRowLinks $list_row_links (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listRowLinks'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function listRowLinksWithHttpInfo($base_uuid, $list_row_links = null, string $contentType = self::contentTypes['listRowLinks'][0])
    {
        $request = $this->listRowLinksRequest($base_uuid, $list_row_links, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listRowLinksAsync
     *
     * List Row Links
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  \SeaTable\Client\Base\ListRowLinks $list_row_links (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listRowLinks'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listRowLinksAsync($base_uuid, $list_row_links = null, string $contentType = self::contentTypes['listRowLinks'][0])
    {
        return $this->listRowLinksAsyncWithHttpInfo($base_uuid, $list_row_links, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listRowLinksAsyncWithHttpInfo
     *
     * List Row Links
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  \SeaTable\Client\Base\ListRowLinks $list_row_links (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listRowLinks'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listRowLinksAsyncWithHttpInfo($base_uuid, $list_row_links = null, string $contentType = self::contentTypes['listRowLinks'][0])
    {
        $returnType = 'object';
        $request = $this->listRowLinksRequest($base_uuid, $list_row_links, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listRowLinks'
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  \SeaTable\Client\Base\ListRowLinks $list_row_links (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['listRowLinks'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listRowLinksRequest($base_uuid, $list_row_links = null, string $contentType = self::contentTypes['listRowLinks'][0])
    {

        // verify the required parameter 'base_uuid' is set
        if ($base_uuid === null || (is_array($base_uuid) && count($base_uuid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_uuid when calling listRowLinks'
            );
        }
        if (!preg_match("/^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/", $base_uuid)) {
            throw new \InvalidArgumentException("invalid value for \"base_uuid\" when calling LinksApi.listRowLinks, must conform to the pattern /^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/.");
        }
        


        $resourcePath = '/api-gateway/api/v2/dtables/{base_uuid}/query-links/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($base_uuid !== null) {
            $resourcePath = str_replace(
                '{' . 'base_uuid' . '}',
                ObjectSerializer::toPathValue($base_uuid),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($list_row_links)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($list_row_links));
            } else {
                $httpBody = $list_row_links;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateRowLink
     *
     * Update Row Link(s)
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  \SeaTable\Client\Base\RowLinkCreateUpdateDelete $row_link_create_update_delete row_link_create_update_delete (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateRowLink'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function updateRowLink($base_uuid, $row_link_create_update_delete = null, string $contentType = self::contentTypes['updateRowLink'][0])
    {
        list($response) = $this->updateRowLinkWithHttpInfo($base_uuid, $row_link_create_update_delete, $contentType);
        return $response;
    }

    /**
     * Operation updateRowLinkWithHttpInfo
     *
     * Update Row Link(s)
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  \SeaTable\Client\Base\RowLinkCreateUpdateDelete $row_link_create_update_delete (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateRowLink'] to see the possible values for this operation
     *
     * @throws \SeaTable\Client\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateRowLinkWithHttpInfo($base_uuid, $row_link_create_update_delete = null, string $contentType = self::contentTypes['updateRowLink'][0])
    {
        $request = $this->updateRowLinkRequest($base_uuid, $row_link_create_update_delete, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('object' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('object' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, 'object', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = 'object';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateRowLinkAsync
     *
     * Update Row Link(s)
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  \SeaTable\Client\Base\RowLinkCreateUpdateDelete $row_link_create_update_delete (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateRowLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateRowLinkAsync($base_uuid, $row_link_create_update_delete = null, string $contentType = self::contentTypes['updateRowLink'][0])
    {
        return $this->updateRowLinkAsyncWithHttpInfo($base_uuid, $row_link_create_update_delete, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateRowLinkAsyncWithHttpInfo
     *
     * Update Row Link(s)
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  \SeaTable\Client\Base\RowLinkCreateUpdateDelete $row_link_create_update_delete (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateRowLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateRowLinkAsyncWithHttpInfo($base_uuid, $row_link_create_update_delete = null, string $contentType = self::contentTypes['updateRowLink'][0])
    {
        $returnType = 'object';
        $request = $this->updateRowLinkRequest($base_uuid, $row_link_create_update_delete, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateRowLink'
     *
     * @param  string $base_uuid The unique identifier of a base. Sometimes also called dtable_uuid. (required)
     * @param  \SeaTable\Client\Base\RowLinkCreateUpdateDelete $row_link_create_update_delete (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateRowLink'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateRowLinkRequest($base_uuid, $row_link_create_update_delete = null, string $contentType = self::contentTypes['updateRowLink'][0])
    {

        // verify the required parameter 'base_uuid' is set
        if ($base_uuid === null || (is_array($base_uuid) && count($base_uuid) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $base_uuid when calling updateRowLink'
            );
        }
        if (!preg_match("/^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/", $base_uuid)) {
            throw new \InvalidArgumentException("invalid value for \"base_uuid\" when calling LinksApi.updateRowLink, must conform to the pattern /^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$/.");
        }
        


        $resourcePath = '/api-gateway/api/v2/dtables/{base_uuid}/links/';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($base_uuid !== null) {
            $resourcePath = str_replace(
                '{' . 'base_uuid' . '}',
                ObjectSerializer::toPathValue($base_uuid),
                $resourcePath
            );
        }


        if ($contentType === 'multipart/form-data') {
            $multipart = true;
        }

        $headers = $this->headerSelector->selectHeaders(
            ['application/json', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($row_link_create_update_delete)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($row_link_create_update_delete));
            } else {
                $httpBody = $row_link_create_update_delete;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires Bearer authentication (access token)
        if (!empty($this->config->getAccessToken())) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
