<?php
/**
 * InsertRow
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Base Operations (from 4.4)
 *
 * The official SeaTable API Reference (OpenAPI 3.0).
 *
 * The version of the OpenAPI document: 5.0
 * Generated by: https://openapi-generator.tech
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SeaTable\Client\Base;

use \ArrayAccess;
use \SeaTable\Client\ObjectSerializer;

/**
 * InsertRow Class Doc Comment
 *
 * @category Class
 * @description Insert a row below or above another row your specified by his row-ID.
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class InsertRow implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'insert_row';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'table_name' => 'string',
        'anchor_row_id' => 'string',
        'row_insert_position' => 'string',
        'row' => 'object',
        'apply_default' => 'bool'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'table_name' => null,
        'anchor_row_id' => null,
        'row_insert_position' => null,
        'row' => null,
        'apply_default' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'table_name' => false,
        'anchor_row_id' => false,
        'row_insert_position' => false,
        'row' => false,
        'apply_default' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'table_name' => 'table_name',
        'anchor_row_id' => 'anchor_row_id',
        'row_insert_position' => 'row_insert_position',
        'row' => 'row',
        'apply_default' => 'apply_default'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'table_name' => 'setTableName',
        'anchor_row_id' => 'setAnchorRowId',
        'row_insert_position' => 'setRowInsertPosition',
        'row' => 'setRow',
        'apply_default' => 'setApplyDefault'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'table_name' => 'getTableName',
        'anchor_row_id' => 'getAnchorRowId',
        'row_insert_position' => 'getRowInsertPosition',
        'row' => 'getRow',
        'apply_default' => 'getApplyDefault'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const ROW_INSERT_POSITION_EMPTY = '';
    public const ROW_INSERT_POSITION_INSERT_ABOVE = 'insert_above';
    public const ROW_INSERT_POSITION_INSERT_BELOW = 'insert_below';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getRowInsertPositionAllowableValues()
    {
        return [
            self::ROW_INSERT_POSITION_EMPTY,
            self::ROW_INSERT_POSITION_INSERT_ABOVE,
            self::ROW_INSERT_POSITION_INSERT_BELOW,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('table_name', $data ?? [], null);
        $this->setIfExists('anchor_row_id', $data ?? [], null);
        $this->setIfExists('row_insert_position', $data ?? [], null);
        $this->setIfExists('row', $data ?? [], null);
        $this->setIfExists('apply_default', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['table_name'] === null) {
            $invalidProperties[] = "'table_name' can't be null";
        }
        $allowedValues = $this->getRowInsertPositionAllowableValues();
        if (!is_null($this->container['row_insert_position']) && !in_array($this->container['row_insert_position'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'row_insert_position', must be one of '%s'",
                $this->container['row_insert_position'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['row'] === null) {
            $invalidProperties[] = "'row' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets table_name
     *
     * @return string
     */
    public function getTableName()
    {
        return $this->container['table_name'];
    }

    /**
     * Sets table_name
     *
     * @param string $table_name The name of the table to perform the operation on. Alternatively, you can use the `table_id` instead of `table_name`. If using `table_id`, ensure that the key in the request body is replaced accordingly.
     *
     * @return self
     */
    public function setTableName($table_name)
    {
        if (is_null($table_name)) {
            throw new \InvalidArgumentException('non-nullable table_name cannot be null');
        }
        $this->container['table_name'] = $table_name;

        return $this;
    }

    /**
     * Gets anchor_row_id
     *
     * @return string|null
     */
    public function getAnchorRowId()
    {
        return $this->container['anchor_row_id'];
    }

    /**
     * Sets anchor_row_id
     *
     * @param string|null $anchor_row_id Id of the row the new row should be added next to
     *
     * @return self
     */
    public function setAnchorRowId($anchor_row_id)
    {
        if (is_null($anchor_row_id)) {
            throw new \InvalidArgumentException('non-nullable anchor_row_id cannot be null');
        }
        $this->container['anchor_row_id'] = $anchor_row_id;

        return $this;
    }

    /**
     * Gets row_insert_position
     *
     * @return string|null
     */
    public function getRowInsertPosition()
    {
        return $this->container['row_insert_position'];
    }

    /**
     * Sets row_insert_position
     *
     * @param string|null $row_insert_position Defines if the new row is added below or above anchor row. If this parameter is left blank, `insert_below` is taken as default value.
     *
     * @return self
     */
    public function setRowInsertPosition($row_insert_position)
    {
        if (is_null($row_insert_position)) {
            throw new \InvalidArgumentException('non-nullable row_insert_position cannot be null');
        }
        $allowedValues = $this->getRowInsertPositionAllowableValues();
        if (!in_array($row_insert_position, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'row_insert_position', must be one of '%s'",
                    $row_insert_position,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['row_insert_position'] = $row_insert_position;

        return $this;
    }

    /**
     * Gets row
     *
     * @return object
     */
    public function getRow()
    {
        return $this->container['row'];
    }

    /**
     * Sets row
     *
     * @param object $row Pass the set of column names and their values. The column names must be present in your table. Different column types require different ways to input values. For eg: {\"Name\":\"Max\", \"Age\":\"21\", \"Birthday\":\"2023-02-18\", \"Checkbox\":\"true\"}
     *
     * @return self
     */
    public function setRow($row)
    {
        if (is_null($row)) {
            throw new \InvalidArgumentException('non-nullable row cannot be null');
        }
        $this->container['row'] = $row;

        return $this;
    }

    /**
     * Gets apply_default
     *
     * @return bool|null
     */
    public function getApplyDefault()
    {
        return $this->container['apply_default'];
    }

    /**
     * Sets apply_default
     *
     * @param bool|null $apply_default Use the column default values to populate new rows during creation. False by default.
     *
     * @return self
     */
    public function setApplyDefault($apply_default)
    {
        if (is_null($apply_default)) {
            throw new \InvalidArgumentException('non-nullable apply_default cannot be null');
        }
        $this->container['apply_default'] = $apply_default;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


