<?php
/**
 * ButtonColumnFormat
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Base Operations (from 4.4)
 *
 * The official SeaTable API Reference (OpenAPI 3.0).
 *
 * The version of the OpenAPI document: 5.0
 * Generated by: https://openapi-generator.tech
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SeaTable\Client\Base;

use \ArrayAccess;
use \SeaTable\Client\ObjectSerializer;

/**
 * ButtonColumnFormat Class Doc Comment
 *
 * @category Class
 * @description Specify the button column.
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class ButtonColumnFormat implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'button_column_format';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'button_type' => 'string',
        'button_name' => 'string',
        'button_color' => 'string',
        'table_id' => 'string',
        'script_id' => 'string',
        'selected_columns' => '\SeaTable\Client\Base\ButtonColumnFormatSelectedColumnsInner[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'button_type' => null,
        'button_name' => null,
        'button_color' => null,
        'table_id' => null,
        'script_id' => null,
        'selected_columns' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'button_type' => false,
        'button_name' => false,
        'button_color' => false,
        'table_id' => false,
        'script_id' => false,
        'selected_columns' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'button_type' => 'button_type',
        'button_name' => 'button_name',
        'button_color' => 'button_color',
        'table_id' => 'table_id',
        'script_id' => 'script_id',
        'selected_columns' => 'selected_columns'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'button_type' => 'setButtonType',
        'button_name' => 'setButtonName',
        'button_color' => 'setButtonColor',
        'table_id' => 'setTableId',
        'script_id' => 'setScriptId',
        'selected_columns' => 'setSelectedColumns'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'button_type' => 'getButtonType',
        'button_name' => 'getButtonName',
        'button_color' => 'getButtonColor',
        'table_id' => 'getTableId',
        'script_id' => 'getScriptId',
        'selected_columns' => 'getSelectedColumns'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const BUTTON_TYPE_EMPTY = '';
    public const BUTTON_TYPE_RUN_SCRIPT = 'run_script';
    public const BUTTON_TYPE_SEND_EMAIL = 'send_email';
    public const BUTTON_TYPE_COPY_ROW_TO_ANOTHER_TABLE = 'copy_row_to_another_table';
    public const BUTTON_TYPE_MODIFY_ROW = 'modify_row';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getButtonTypeAllowableValues()
    {
        return [
            self::BUTTON_TYPE_EMPTY,
            self::BUTTON_TYPE_RUN_SCRIPT,
            self::BUTTON_TYPE_SEND_EMAIL,
            self::BUTTON_TYPE_COPY_ROW_TO_ANOTHER_TABLE,
            self::BUTTON_TYPE_MODIFY_ROW,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('button_type', $data ?? [], null);
        $this->setIfExists('button_name', $data ?? [], null);
        $this->setIfExists('button_color', $data ?? [], null);
        $this->setIfExists('table_id', $data ?? [], null);
        $this->setIfExists('script_id', $data ?? [], null);
        $this->setIfExists('selected_columns', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['button_type'] === null) {
            $invalidProperties[] = "'button_type' can't be null";
        }
        $allowedValues = $this->getButtonTypeAllowableValues();
        if (!is_null($this->container['button_type']) && !in_array($this->container['button_type'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'button_type', must be one of '%s'",
                $this->container['button_type'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['button_name'] === null) {
            $invalidProperties[] = "'button_name' can't be null";
        }
        if ($this->container['button_color'] === null) {
            $invalidProperties[] = "'button_color' can't be null";
        }
        if (!preg_match("/^#[A-Fa-f0-9]{6}$/", $this->container['button_color'])) {
            $invalidProperties[] = "invalid value for 'button_color', must be conform to the pattern /^#[A-Fa-f0-9]{6}$/.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets button_type
     *
     * @return string
     */
    public function getButtonType()
    {
        return $this->container['button_type'];
    }

    /**
     * Sets button_type
     *
     * @param string $button_type button_type
     *
     * @return self
     */
    public function setButtonType($button_type)
    {
        if (is_null($button_type)) {
            throw new \InvalidArgumentException('non-nullable button_type cannot be null');
        }
        $allowedValues = $this->getButtonTypeAllowableValues();
        if (!in_array($button_type, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'button_type', must be one of '%s'",
                    $button_type,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['button_type'] = $button_type;

        return $this;
    }

    /**
     * Gets button_name
     *
     * @return string
     */
    public function getButtonName()
    {
        return $this->container['button_name'];
    }

    /**
     * Sets button_name
     *
     * @param string $button_name button_name
     *
     * @return self
     */
    public function setButtonName($button_name)
    {
        if (is_null($button_name)) {
            throw new \InvalidArgumentException('non-nullable button_name cannot be null');
        }
        $this->container['button_name'] = $button_name;

        return $this;
    }

    /**
     * Gets button_color
     *
     * @return string
     */
    public function getButtonColor()
    {
        return $this->container['button_color'];
    }

    /**
     * Sets button_color
     *
     * @param string $button_color button_color
     *
     * @return self
     */
    public function setButtonColor($button_color)
    {
        if (is_null($button_color)) {
            throw new \InvalidArgumentException('non-nullable button_color cannot be null');
        }

        if ((!preg_match("/^#[A-Fa-f0-9]{6}$/", ObjectSerializer::toString($button_color)))) {
            throw new \InvalidArgumentException("invalid value for \$button_color when calling ButtonColumnFormat., must conform to the pattern /^#[A-Fa-f0-9]{6}$/.");
        }

        $this->container['button_color'] = $button_color;

        return $this;
    }

    /**
     * Gets table_id
     *
     * @return string|null
     */
    public function getTableId()
    {
        return $this->container['table_id'];
    }

    /**
     * Sets table_id
     *
     * @param string|null $table_id id of the target table, if `copy_row_to_another_table` is selected.
     *
     * @return self
     */
    public function setTableId($table_id)
    {
        if (is_null($table_id)) {
            throw new \InvalidArgumentException('non-nullable table_id cannot be null');
        }
        $this->container['table_id'] = $table_id;

        return $this;
    }

    /**
     * Gets script_id
     *
     * @return string|null
     */
    public function getScriptId()
    {
        return $this->container['script_id'];
    }

    /**
     * Sets script_id
     *
     * @param string|null $script_id script_id
     *
     * @return self
     */
    public function setScriptId($script_id)
    {
        if (is_null($script_id)) {
            throw new \InvalidArgumentException('non-nullable script_id cannot be null');
        }
        $this->container['script_id'] = $script_id;

        return $this;
    }

    /**
     * Gets selected_columns
     *
     * @return \SeaTable\Client\Base\ButtonColumnFormatSelectedColumnsInner[]|null
     */
    public function getSelectedColumns()
    {
        return $this->container['selected_columns'];
    }

    /**
     * Sets selected_columns
     *
     * @param \SeaTable\Client\Base\ButtonColumnFormatSelectedColumnsInner[]|null $selected_columns selected_columns
     *
     * @return self
     */
    public function setSelectedColumns($selected_columns)
    {
        if (is_null($selected_columns)) {
            throw new \InvalidArgumentException('non-nullable selected_columns cannot be null');
        }
        $this->container['selected_columns'] = $selected_columns;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


