<?php
/**
 * AccessToken
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Authentication
 *
 * The official SeaTable API Reference (OpenAPI 3.0).
 *
 * The version of the OpenAPI document: 5.0
 * Generated by: https://openapi-generator.tech
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SeaTable\Client\Auth;

use \ArrayAccess;
use \SeaTable\Client\ObjectSerializer;

/**
 * AccessToken Class Doc Comment
 *
 * @category Class
 * @description blub
 * @package  SeaTable\Client
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class AccessToken implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'AccessToken';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'app_name' => 'string',
        'access_token' => 'string',
        'dtable_uuid' => 'string',
        'dtable_server' => 'string',
        'dtable_socket' => 'string',
        'workspace_id' => 'int',
        'dtable_name' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'app_name' => null,
        'access_token' => null,
        'dtable_uuid' => 'uuid',
        'dtable_server' => 'url',
        'dtable_socket' => 'url',
        'workspace_id' => null,
        'dtable_name' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'app_name' => false,
        'access_token' => false,
        'dtable_uuid' => false,
        'dtable_server' => false,
        'dtable_socket' => false,
        'workspace_id' => false,
        'dtable_name' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'app_name' => 'app_name',
        'access_token' => 'access_token',
        'dtable_uuid' => 'dtable_uuid',
        'dtable_server' => 'dtable_server',
        'dtable_socket' => 'dtable_socket',
        'workspace_id' => 'workspace_id',
        'dtable_name' => 'dtable_name'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'app_name' => 'setAppName',
        'access_token' => 'setAccessToken',
        'dtable_uuid' => 'setDtableUuid',
        'dtable_server' => 'setDtableServer',
        'dtable_socket' => 'setDtableSocket',
        'workspace_id' => 'setWorkspaceId',
        'dtable_name' => 'setDtableName'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'app_name' => 'getAppName',
        'access_token' => 'getAccessToken',
        'dtable_uuid' => 'getDtableUuid',
        'dtable_server' => 'getDtableServer',
        'dtable_socket' => 'getDtableSocket',
        'workspace_id' => 'getWorkspaceId',
        'dtable_name' => 'getDtableName'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('app_name', $data ?? [], null);
        $this->setIfExists('access_token', $data ?? [], null);
        $this->setIfExists('dtable_uuid', $data ?? [], null);
        $this->setIfExists('dtable_server', $data ?? [], null);
        $this->setIfExists('dtable_socket', $data ?? [], null);
        $this->setIfExists('workspace_id', $data ?? [], null);
        $this->setIfExists('dtable_name', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets app_name
     *
     * @return string|null
     */
    public function getAppName()
    {
        return $this->container['app_name'];
    }

    /**
     * Sets app_name
     *
     * @param string|null $app_name app_name
     *
     * @return self
     */
    public function setAppName($app_name)
    {
        if (is_null($app_name)) {
            throw new \InvalidArgumentException('non-nullable app_name cannot be null');
        }
        $this->container['app_name'] = $app_name;

        return $this;
    }

    /**
     * Gets access_token
     *
     * @return string|null
     */
    public function getAccessToken()
    {
        return $this->container['access_token'];
    }

    /**
     * Sets access_token
     *
     * @param string|null $access_token access_token
     *
     * @return self
     */
    public function setAccessToken($access_token)
    {
        if (is_null($access_token)) {
            throw new \InvalidArgumentException('non-nullable access_token cannot be null');
        }
        $this->container['access_token'] = $access_token;

        return $this;
    }

    /**
     * Gets dtable_uuid
     *
     * @return string|null
     */
    public function getDtableUuid()
    {
        return $this->container['dtable_uuid'];
    }

    /**
     * Sets dtable_uuid
     *
     * @param string|null $dtable_uuid dtable_uuid
     *
     * @return self
     */
    public function setDtableUuid($dtable_uuid)
    {
        if (is_null($dtable_uuid)) {
            throw new \InvalidArgumentException('non-nullable dtable_uuid cannot be null');
        }
        $this->container['dtable_uuid'] = $dtable_uuid;

        return $this;
    }

    /**
     * Gets dtable_server
     *
     * @return string|null
     */
    public function getDtableServer()
    {
        return $this->container['dtable_server'];
    }

    /**
     * Sets dtable_server
     *
     * @param string|null $dtable_server dtable_server
     *
     * @return self
     */
    public function setDtableServer($dtable_server)
    {
        if (is_null($dtable_server)) {
            throw new \InvalidArgumentException('non-nullable dtable_server cannot be null');
        }
        $this->container['dtable_server'] = $dtable_server;

        return $this;
    }

    /**
     * Gets dtable_socket
     *
     * @return string|null
     */
    public function getDtableSocket()
    {
        return $this->container['dtable_socket'];
    }

    /**
     * Sets dtable_socket
     *
     * @param string|null $dtable_socket dtable_socket
     *
     * @return self
     */
    public function setDtableSocket($dtable_socket)
    {
        if (is_null($dtable_socket)) {
            throw new \InvalidArgumentException('non-nullable dtable_socket cannot be null');
        }
        $this->container['dtable_socket'] = $dtable_socket;

        return $this;
    }

    /**
     * Gets workspace_id
     *
     * @return int|null
     */
    public function getWorkspaceId()
    {
        return $this->container['workspace_id'];
    }

    /**
     * Sets workspace_id
     *
     * @param int|null $workspace_id workspace_id
     *
     * @return self
     */
    public function setWorkspaceId($workspace_id)
    {
        if (is_null($workspace_id)) {
            throw new \InvalidArgumentException('non-nullable workspace_id cannot be null');
        }
        $this->container['workspace_id'] = $workspace_id;

        return $this;
    }

    /**
     * Gets dtable_name
     *
     * @return string|null
     */
    public function getDtableName()
    {
        return $this->container['dtable_name'];
    }

    /**
     * Sets dtable_name
     *
     * @param string|null $dtable_name dtable_name
     *
     * @return self
     */
    public function setDtableName($dtable_name)
    {
        if (is_null($dtable_name)) {
            throw new \InvalidArgumentException('non-nullable dtable_name cannot be null');
        }
        $this->container['dtable_name'] = $dtable_name;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


