<h1 align="center">
    <br>
    <img width="200" src="https://raw.githubusercontent.com/sindresorhus/awesome/main/media/logo.svg" alt="awesome">
    <br>
</h1>

[![Build Status](https://api.travis-ci.org/sdmg15/Best-websites-a-programmer-should-visit.svg?branch=master)](https://travis-ci.org/sdmg15/Best-websites-a-programmer-should-visit)

# Best-websites-a-programmer-should-visit
Some useful websites for programmers.

When learning CS, there are some useful sites you must know to get always informed to do your technologies even better and learn new things. Here is a non-exhaustive list of some sites you should visit. This list will get updated as soon as I can get another link, but you can also contribute by adding those you know :wink:

**Note** : [Chinese Version](https://github.com/tuteng/Best-websites-a-programmer-should-visit-zh)

## 📖 Index
<ul>
<li><a href="#when-you-get-stuck">When you get stuck</a></li>
<li><a href="#news">News</a></li>
<li><a href="#magazines">Magazines</a></li>
<li><a href="#coding-practice-for-beginners">Coding practice for beginners</a></li>
<li><a href="#cryptocurrency">Cryptocurrency</a></li>
<li><a href="#for-those-who-want-to-start-a-small-project-but-cant-find-the-ideas">For those who want to start a small project but can't find the ideas</a></li>
<li><a href="#general-coding-advice">General Coding advice</a></li>
<li><a href="#coding-style">Coding Style</a></li>
<li><a href="#general-tools">General Tools</a></li>
<li><a href="#interview-preparation">Interview Preparation</a></li>
<li><a href="#documentaries">Documentaries</a></li>
<li><a href="#moocs-for-learning-something-new">MOOCs for learning something new</a></li>
<li><a href="#sites-related-to-your-preferred-programming-language-for-me-c">Sites related to your preferred programming language (For me C++)</a></li>
<li><a href="#learn-ai">Artificial Intelligence And Machine Learning</a></li>
<li><a href="#seminar-research-writing-talks-etc">Seminar , research writing , talks etc</a></li>
<li><a href="#everything-in-one-place">Everything in one place</a></li>
<li><a href="#youtube-channels">YouTube Channels</a></li>
<li><a href="#good-articles">Good Articles</a></li>
<li><a href="#bash-and-shell-scripting">Bash and Shell scripting</a></li>
<li><a href="#podcasts">Podcasts</a></li>
<li><a href="#building-a-simple-compilerinterpreter">Building a Simple Compiler/Interpreter</a></li>
<li><a href="#watch-others-code">Watch others code</a></li>
<li><a href="#tutorials">Tutorials</a></li>
<li><a href="#what-should-a-programmer-know">What should a programmer know</a></li>
<li><a href="#competitive-programming">Competitive programming</a></li>
<li><a href="#computer-books">Computer Books</a></li>
<li><a href="#video-tutorials">Video Tutorials</a></li>
<li><a href="#online-compiler-and-sharing-code-snippets">Online Compiler and Sharing Code snippets</a></li>
<li><a href="#blogs-of-developers">Blogs of Developers</a></li>
<li><a href="#for-improving-your-english">For improving your English</a></li>
<li><a href="#when-you-get-bored-from-cs-related-stuff">When you get bored from CS related stuff</a></li>
<li><a href="#open-source-websites">Open Source Websites</a></li>
<li><a href="#internships">Internships</a></li>
<li><a href="#jobs">Jobs</a></li>
</ul>

## ❓ When you get stuck
- [Codementor](https://www.codementor.io) : A mentorship community to learn from fellow developers via live 1:1 help and more.
- [devRant](https://www.devrant.io) : Community where you can rant and release your stress
- [Google](https://www.google.com) : A search engine for anything you get stuck with.
- [Learn Anything](https://learn-anything.xyz) : Community curated knowledge graph of best paths for learning anything
- [Quora](https://www.quora.com) : A place to share knowledge and better understand the world
- [Stack Overflow](https://stackoverflow.com) : subscribe to their weekly newsletter and any other topic which you find interesting
- [Stack Exchange](https://stackexchange.com/) : Stack Exchange is the combination of Stack Overflow and 170+ sites where you can get any kinds of help
- [Coderanch](https://coderanch.com/) : A friendly place for programming greenhorns. Jump straight into any of our topics and light hearted discussions. Ranging from Java, Databases, Android, Programmer certification, Programming jobs and much more...

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 📰 News
- [ACM TechNews](http://technews.acm.org) : TechNews
- [Stratechery](https://stratechery.com) : Stratechery by Ben Thompson
- [AlternativeTo](https://alternativeto.net) : Crowdsourced software recommendations
- [Ars Technica](https://arstechnica.com) : Posts unique quality articles on technology, science, politics and society.
- [Better Dev Links](https://betterdev.link) : Weekly links to help you become a better developer
- [Better Programming](https://medium.com/better-programming) : Featured articles for modern developers available every day 
- [CNET](https://www.cnet.com/news/) : Your guide to a better future! An excellent source of up-to-date tech news.
- [Daily.Dev](https://daily.dev/) : A Great Chrome extension which provides recent and relevant tech articles and news
- [DevOpsLinks](http://devopslinks.com) : An online community of thousands of developers and IT experts interested in DevOps
- [Frontend Focus Newsletter](https://frontendfoc.us) : once-weekly roundup of the frontend news, articles and tutorials
- [GSMArena.com](http://www.gsmarena.com) : news related to the latest mobile phones and android.
- [Hacker News Digest](https://hndigest.com) : curated automatically, delivered as frequently as you want
- [Hacker News](https://news.ycombinator.com) : news aggregator for programmers where civility is king, try a newsletter to get top news to your inbox:
- [Hacker Newsletter](http://www.hackernewsletter.com) : curated by hand, delivered weekly
- [Hacker Noon](https://hackernoon.com) : How hackers start their afternoons.
- [High Scalability](http://highscalability.com) : Success stories of various companies on their apps, infra scaling.
- [Lobsters](https://lobste.rs) : Lobsters is a technology-focused community centered around link aggregation and discussion.
- [product hunt](https://www.producthunt.com) : Discover your next favorite thing
- [Recode](https://www.recode.net) : Tech news that focuses on the business of Silicon Valley
- [Reddit.com/r/programming](https://www.reddit.com/r/programming/) : Subreddit with aggregated tech news and articles
- [Slashdot](https://slashdot.org) : News, Social news (Originally "News for Nerds. Stuff that Matters")
- [StackShare](https://stackshare.io) : See what tools are popular with developers and companies and read about their technology decisions
- [TechCrunch](https://techcrunch.com) : dedicated to obsessively profiling startups, reviewing new Internet products, and breaking tech news
- [The DEV Community](https://dev.to) : Where programmers share ideas and help each other grow.
- [The Verge](https://www.theverge.com) : More product oriented tech news
- [WCCF Tech](https://wccftech.com) : curated news related to Computer Hardware, Software, and everything else in the Tech World. 
- [XDA](https://www.xda-developers.com) : Android Developers News
- [Hashnode](https://hashnode.com/) : Hashnode is a friendly and inclusive community for software developers
- [Rekt](https://rekt.news/) : A journalism related to Defi, Web3, Blockchain and security on them.
- [Hackaday](https://hackaday.com) : Hacking is an art form that uses something in a way in which it was not originally intended.

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 📚 Magazines
- [MIT Technology Review](https://www.technologyreview.com/magazine/) : MIT's tech review magazine.
- [Nautilus](http://nautil.us) : NewYorker for tech.
- [LWN](https://lwn.net) : Weekly news coverage of opensource technologies, programming, etc. ( Originally Linux Weekly News).

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 👶 Coding practice for beginners
- [Codedex - start your coding adventure](https://www.codedex.io) : Gamify your learning experience and have fun learning how to code!
- [freeCodeCamp](https://www.freecodecamp.com) : Learn to code and build projects for nonprofits. Build your full stack web development portfolio today
- [Blackbird School](https://blackbird.school) : Learn to code online with our beginner-friendly platform.
- [Glitch](https://glitch.com/) : Great place to play around with code in an easy-to-set-up environment.
- [Reddit.com/r/dailyprogrammer](https://www.reddit.com/r/dailyprogrammer/) : interesting programming challenges where you can learn from looking at other's code, even if you are not able to solve code you can look at how others solved.
- [Programming by Doing](http://programmingbydoing.com) : very good site for those who want to start with absolute basics
- [CodeAbbey - a place where everyone can master programming](http://www.codeabbey.com) : Best place to begin with problems that start at the easiest and gradually increase difficulty with each problem.
- [Exercism.io](http://exercism.io) : Download and solve practice problems in over 50 different languages, and share your solution with others.
- [InterviewBit/Coding Interview Questions](https://www.interviewbit.com) : Gamifies the experience of practicing for your interview and includes lots of sample problems to solve.
- [karan/Projects-Solutions](https://github.com/karan/Projects-Solutions) : Solutions to most of the problems in the link above
- [Lod - Cloud](http://lod-cloud.net) : The Linking Open Data cloud diagram
- [Cave of programming](https://caveofprogramming.com) : Learn to program, Upgrade your skills.
- [Vim adventures](https://vim-adventures.com/) : Learn VIM by playing
- [Learn Vimscript the Hard Way](http://learnvimscriptthehardway.stevelosh.com) : Learn Vim Script from beginning to expert.
- [Programming Tasks](http://rosettacode.org/wiki/Category:Programming_Tasks) : Large collection of small programs.
- [Pramp](https://www.pramp.com) : It's your turn to be the interviewer. when done, click on the swap roles button on the left
- [Paqmind](http://paqmind.com) : Guides and challenges to learn programming
- [Codecademy](https://www.codecademy.com) : Learn to code interactively, for free.
- [Codegym](https://codegym.cc/) : It contains a Java tutorial with 1200 Java practise tasks.
- [treehouse](https://teamtreehouse.com) : The fast, easy, and affordable way to build your skills.
- [GeeksforGeeks](https://practice.geeksforgeeks.org) : Learn to code, Study for placement, Do competitive coding.
- [edabit](https://edabit.com/challenges) : Practice coding via various small challenges.
- [Learn Git Branching](https://learngitbranching.js.org) : Learn and practice git commands in an interactive way
- [Oh Shit, Git!?!](https://ohshitgit.com/) : Cheat sheet to get yourself out of bad git situations
- [The Odin Project](https://www.theodinproject.com/home) : The Odin Project provides a free open source coding curriculum that can be taken entirely online.
- [Udemy](https://www.udemy.com/) : Whether you want to learn or to share what you know, you’ve come to the right place. As a global destination for online learning, we connect people through knowledge.
- [Scaler](https://www.scaler.com/topics/) : A curated interactive space for aspiring programmers to learn and master their coding skills. Also help in job interview.
- [SQL Zoo](https://sqlzoo.net/wiki/SQL_Tutorial) : Learn SQL interactively in stages, from basic queries to complex operations.
- [SQLTest.online](https://sqltest.online) : Boost Your SQL Proficiency with Challenging Problems.

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 💰 CryptoCurrency
- [Blockchain Basics](https://www.sitepen.com/blog/2017/09/21/blockchain-basics/) : Great introduction to blockchain
- [Blockchain demo](https://blockchaindemo.io/) : A visual demo of Blockchain technology
- [Build a blockchain in Python](https://hackernoon.com/learn-blockchains-by-building-one-117428612f46) : Learn Blockchains by Building One
- [Coin demo](https://coindemo.io/) : CryptoCurrency demo
- [GitCoin](https://gitcoin.co) : Gitcoin is the easiest way to monetize or incentivize work in Open Source Software.
- [Learn About Bitcoin and Lightning Protocol](https://chaincode.gitbook.io/seminars/): Complete 4 weeks seminar ciricullum for learning about Bitcoin.
- [Learn Me A Bitcoin](https://learnmeabitcoin.com/): Bitcoin, Cryptocurrencies and Blockchain explained in plain English
- [Learn Web3 DAO](https://learnweb3.io/): Learn to become a Web3 Developer for free. 
- [Lite Paper](https://litepaper.com/) : Cryptocurrencies & Blockchain made effortless
- [Lopp Bitcoin Resources](https://lopp.net/bitcoin.html) : Some Bitcoin Resources
- [Mastering Bitcoin](https://www.oreilly.com/library/view/mastering-bitcoin/9781491902639/): Introduction to Bitcoin and tutorials to operate a full node
- [Mempool](https://mempool.space): Bitcoin block explorer, mempool visualizer, transaction tracker, and fee estimator 

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 💡 For those who want to start a small project but can't find the ideas
- [freeCodeCamp/React project ideas](https://medium.freecodecamp.org/every-time-you-build-a-to-do-list-app-a-puppy-dies-505b54637a5d?gi=c786640fbd11) : 27 fun app ideas you can build while learning React.
- [karan/Projects](https://github.com/karan/Projects) : a large collection of small projects for beginners with
- [Wrong "big projects" for beginners](http://rodiongork.tumblr.com/post/108155476418/wrong-big-projects-for-beginners) : How to choose where to start
- [vicky002/1000-Projects](https://github.com/vicky002/1000_Projects) : Mega List of practical projects that one can solve in any programming language!
- [reddit.com/r/AppIdeas](https://www.reddit.com/r/AppIdeas/) : A place to discuss ideas for applications, for bored developers.
- [reddit.com/r/SomebodyMakeThis](https://www.reddit.com/r/SomebodyMakeThis/) : A home for ideas by people who lack time, money, or skills.
- [florinpop17/app-ideas](https://github.com/florinpop17/app-ideas) : A Collection of application ideas which can be used to improve your coding skills.

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 🗣️ General Coding advice
- [How to Begin With Competitive Programming](https://www.geeksforgeeks.org/how-to-begin-with-competitive-programming/)
- [10-ways-to-be-a-better-developer](https://stephenhaunts.files.wordpress.com/2014/04/10-ways-to-be-a-better-developer.png) : Ways to become a better dev!
- [Code Review Best Practices](https://www.kevinlondon.com/2015/05/05/code-review-best-practices.html) : Kevin London's blog
- [Design Patterns](https://sourcemaking.com/design_patterns) : Design Patterns explained in detail with examples.
- [Game Programming Patterns](http://gameprogrammingpatterns.com/) : Game Programming Patterns is a collection of patterns Robert Nystrom found in games that make code cleaner, easier to understand, and faster
- [How to become a programmer or the art of Googling well](https://okepi.wordpress.com/2014/08/21/how-to-become-a-programmer-or-the-art-of-googling-well/) : How to become a programmer or the art of Googling well
- [How to escape tutorial purgatory as a new developer — or at any time in your career](https://medium.freecodecamp.org/how-to-escape-tutorial-purgatory-as-a-new-developer-or-at-any-time-in-your-career-e3a4b2384a40) : How to escape tutorial purgatory
- [JS Project Guidelines](https://github.com/wearehive/project-guidelines) : A set of best practices for JavaScript projects.
- [Learn to Code With Me](https://learntocodewith.me) : A comprehensive site resource by Laurence Bradford for developers who aims to build a career in the tech world
- [Lessons From A Lifetime Of Being A Programmer](http://thecodist.com/article/lessons_from_a_lifetime_of_being_a_programmer) : The Codist Header Lessons From A Lifetime Of Being A Programmer  
- [MITRE - Top 25 Most Dangerous Software Weaknesses (2022)](https://cwe.mitre.org/top25/archive/2022/2022_cwe_top25.html) : The currently most common and impactful software weaknesses.
- [Software Architecture Guide](https://martinfowler.com/architecture/) : A site by Martin Fowler about Software Architecture patterns and best practices to help building software effectively.
- [Software design pattern](https://en.wikipedia.org/wiki/Software_design_pattern) : The entire collection of Design Patterns.
- [Things I Wish Someone Had Told Me When I Was Learning How to Code — Free Code Camp](https://medium.freecodecamp.com/things-i-wish-someone-had-told-me-when-i-was-learning-how-to-code-565fc9dcb329?gi=fc6d0a309be ) : What I’ve learned from teaching others
- [TeachYourselfCS](https://teachyourselfcs.com/) : If you’re a self-taught engineer or bootcamp grad, you owe it to yourself to learn computer science. Thankfully, you can give yourself a world-class CS education without investing years and a small fortune in a degree program
- [What every computer science major should know](http://matt.might.net/articles/what-cs-majors-should-know/) : The Principles of Good Programming
- [Working as a Software Developer](https://henrikwarne.com/2012/12/12/working-as-a-software-developer/) : Henrik Warne's blog
- [The Open Web Application Security Project (OWASP)](https://www.owasp.org) : OWASP is an open community dedicated to enabling organizations to conceive, develop, acquire, operate, and maintain applications that can be trusted.

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 🎨 Coding Style
- [Airbnb JS Style Guide](https://github.com/airbnb/javascript) : A mostly reasonable approach to JavaScript
- [Airbnb Ruby Style Guide](https://github.com/airbnb/ruby) : A Ruby style guide by Airbnb
- [Ruby coding style guide](https://github.com/bbatsov/ruby-style-guide) : A community-driven Ruby coding style guide
- [Angular 1 Style Guide](https://github.com/johnpapa/angular-styleguide/tree/master/a1) : Officially endorsed style guide by John Pappa
- [CS 106B Coding Style Guide](http://stanford.edu/class/archive/cs/cs106b/cs106b.1158/styleguide.shtml) : must see for those who create spaghetti
- [Debugging Faqs](http://www.umich.edu/~eecs381/generalFAQ/Debugging.html) : Check out how to debug your program
- [Directory of CS Courses (many with online lectures)](https://github.com/prakhar1989/awesome-courses) : Another online CS courses
- [Directory of Online CS Courses](https://github.com/ossu/computer-science) : Free online CS courses
- [Good C programming habits. • /r/C_Programming](https://www.reddit.com/r/C_Programming/comments/1vuubw/good_c_programming_habits/) : C programming habits to adopt
- [Google C++ Style Guide](https://google.github.io/styleguide/cppguide.html)
- [How to Report Bugs Effectively](https://www.chiark.greenend.org.uk/~sgtatham/bugs.html) : Want to report a bug but you don't know how? Check out this post
- [What are some bad coding habits you would recommend a beginner avoid getting into?](https://www.reddit.com/r/learnprogramming/comments/1i4ds4/what_are_some_bad_coding_habits_you_would/) : Bad habits to avoid when you get started
- [PEP8 - Style Guide for Python Code](https://www.python.org/dev/peps/pep-0008/) : Style Guide for Python Code
- [Standard JS Style Guide](https://standardjs.com) : JavaScript style guide, with linter & automatic code fixer
- [The Hitchhiker's Guide to Python](https://docs.python-guide.org/writing/style/) : Best Practices for Python Development
- [Google Python Style Guide](https://google.github.io/styleguide/pyguide.html) : Google Python Style Guide
- [Aurelia Style Guide](https://github.com/behzad888/Aurelia-styleguide) : An Aurelia style guide by Behzad Abbasi(Behzad888)
- [Source Making ](https://sourcemaking.com/): Design Patterns & Refactoring
- [Refactoring Guru](https://refactoring.guru/): Refactoring And Design Patterns
- [Google Java Style Guide](https://google.github.io/styleguide/javaguide.html): Google Java Style Guide
- [Rust Coding style](https://github.com/rust-dev-tools/fmt-rfcs): Rust code formatting RFCs and coding style guides
- [Google C# Style Guide](https://google.github.io/styleguide/csharp-style.html): Google C# Style Guide
- [Uber Go Style Guide](https://github.com/uber-go/guide): Uber Go Style Guide

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 🛠️ General Tools
- [CoderPad](https://coderpad.io) : Quickly Conduct Coding Interviews and Phone Screen Interviews.
- [CodePen](https://codepen.io) : Front End Developer Playground & Code Editor in the Browser
- [Crontab Guru](https://crontab.guru/) : Quick and simple editor for cron schedule expressions
- [Devicons](http://vorillaz.github.io/devicons/#/main) : Cheatsheet for devs icons
- [Diagrams.net](https://app.diagrams.net/) : Drawing tools to make design and uml easily. Old draw.io
- [FreeFor.Dev](https://free-for.dev/#/) : A huge list of free resources and tools
- [Hotkey Cheatsheet](https://hotkeycheatsheet.com) : A comprehensive hotkey cheatsheet for popular software and applications
- [Imgur](https://imgur.com/) : Online image sharing and image hosting service.
- [Kody Tools](https://www.kodytools.com/dev-tools): 100+ dev tools including code converters, formatters, and minifiers.
- [Pyrexp](https://pythonium.net/regex) : Online regex tester and visualizer for Python.
- [regex101](https://regex101.com) : Online regex tester and debugger: PHP, PCRE, Python, Golang and JavaScript
- [regexr](https://regexr.com) : Another online tool to learn, build & test Regular Expressions
- [Prodia AI Image API](https://prodia.com/) : API for open sourced image models
- [Wit AI](https://wit.ai) : Natural Language for Developers
- [SaaS Design](https://www.saasdesign.io/free-figma-templates) : Collection of open source Figma UI design templates for your next project.
- [Seymour](https://harc.github.io/seymour-live2017) : Live Programming for the Classroom
- [Code share](https://codeshare.io) : Share code in real-time with other developers
- [Solid Tools for Developers](https://soliddevtools.com) : Online debugging tools for developers and system administrators
- [OS Query](https://osquery.io) : Easily ask questions about your Linux, Windows, and macOS infrastructure
- [LaunchPad](https://launchpad.graphql.com) : Appollo launchepad for testing GraphQl queries
- [GraphOnline](https://graphonline.ru/en/) : Useful tool for visualizing Graphs
- [Data Structure Visualization](https://www.cs.usfca.edu/~galles/visualization/Algorithms.html) : Perfect website for visually learning Algorithms
- [IDE Onlang](https://ide.onelang.io) : Write in one language and get the same result in other languages.
- [JSON Crack](https://jsoncrack.com/) : An online open-source tool designed for visualizing data in various languages such as JSON, YAML, CSV, and more.
- [Pad.new](https://pad.new) : Free cloud-based IDE to run code and databases in almost any language
- [PullRequest](https://www.pullrequest.com/) : Code review as a service from vetted, professional reviewers
- [Python Visualizer](http://pythontutor.com/visualize.html) : Watch the execution of basic Python, Java, C++, etc. code step-by-step. Recommended for new programmers and the Canadian Computing Competition.  
- [Extends Class](https://extendsclass.com/) : Online developer tools: REST and SOAP clients, SQLite browser, testers (Regex, XPath, JSONPath) and other tools (Encoders, Converters and formatters)
- [Sourcegraph](https://sourcegraph.com/search) : Online tool for searching millions of open source repositories.
- [SVG Path Editor](https://yqnn.github.io/svg-path-editor/) : Online and open source SVG Path editor.
- [EmailDrop](https://www.emaildrop.io/): Emaildrop is a free disposable email provider.
- [Repl.it](https://repl.it): Accessible prototyping tool for various needs.
- [KeyBr (Typing Practice)](https://www.keybr.com/): Easy to use typing practice app.
- [Svgator](https://www.svgator.com/): Animate svg graphically. Its like a video editor but for svg. 
- [Webhook.site](https://webhook.site/): Useful tool for test and debug webhooks.
- [kandi](https://kandi.openweaver.com/): Jumpstart Application Development by finding the right Open Source resource
- [Svix Play](https://play.svix.com/): Webhook tester & debugger. Test webhooks directly from your test suite.
- [Typeracer](https://play.typeracer.com/): Increase your typing speed while racing against others.
- [Typerush](https://www.typerush.com/): Increase typing speed while racing.
- [IT-Tools](https://it-tools.tech/): Collection of handy online tools for developers.


<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 🐚 Bash and Shell scripting  
- [Advanced Bash-Scripting Guide](http://tldp.org/LDP/abs/html/) : An in-depth exploration of the art of shell scripting
- [Bash Guide for Beginners](http://www.tldp.org/LDP/Bash-Beginners-Guide/html/) : Bash Guide for Beginners Machtelt Garrels
- [Bash Programming](http://tldp.org/HOWTO/Bash-Prog-Intro-HOWTO.html) : by Mike G mikkey at dynamo.com.ar
- [Bash Reference Manual](https://www.gnu.org/software/bash/manual/bashref.html) : Bash Reference Manual
- [BashGuide](http://mywiki.wooledge.org/BashGuide) : BashGuide - Greg's Wiki
- [Conquering the Command Line](https://www.softcover.io/read/fc6c09de/unix_commands) : Unix and Linux Commands for Developers
- [Airborn OS](https://www.airborn.io) :  Private Google Docs Alternative
- [Commandlinefu](https://www.commandlinefu.com/commands/browse) : An extensive collection of Shell oneliners that can save your day on many occasions
- [Pure Bash Bible](https://github.com/dylanaraps/pure-bash-bible) : A collection of pure bash alternatives to external processes.
- [25 Common Linux Bash Script Examples To Get You Started](https://www.hostinger.in/tutorials/bash-script-example) 

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 🎤 Interview Preparation
- [10 Frequently asked SQL Query Interview Questions](http://www.java67.com/2013/04/10-frequently-asked-sql-query-interview-questions-answers-database.html)
- [A Collection of Quant Riddles With Answers](http://puzzles.nigelcoldwell.co.uk)
- [A Developer's Guide to Working with Recruiters](https://andreidobrinski.com/blog/a-developers-guide-to-working-with-recruiters/)
- [Algorithm design canvas](https://www.hiredintech.com/algorithm-design)
- [Aptitude Questions and Answers](http://www.indiabix.com) : Quant and aptitude preparation
- [A site for technical interview questions, brain teasers, puzzles, quizzles](https://www.techinterview.org) : whatever the heck those are) and other things that make you think!
- [Big collection of interview preparation links • /r/cscareerquestions](https://www.reddit.com/r/cscareerquestions/comments/2lzc4h/big_collection_of_interview_preparation_links/)
- [Big-O Algorithm Complexity Cheat Sheet](http://bigocheatsheet.com/#)
- [BIG O Misconceptions](http://ssp.impulsetrain.com/big-o.html)
- [Bitwise tricks](https://gist.github.com/dideler/2365607)
- [ChiperSoft/InterviewThis](https://github.com/Twipped/InterviewThis) : questions to ask during on a interview to know more about the company.
- [Code Project](https://www.codeproject.com) : For those who code!
- [Coderbytes](https://coderbyte.com/) : A platform for coding challenges and interview prep.
- [C PUZZLES, Some interesting C problems](http://www.gowrikumar.com/c/index.php)
- [Core Java Interview Questions](https://www.javatpoint.com/corejava-interview-questions)
- [CS9: Problem-Solving for the CS Technical Interview](http://web.stanford.edu/class/cs9/)
- [Delightful Puzzles](http://gurmeet.net/puzzles/)
- [Determining the big-O runtimes of these different loops?](https://stackoverflow.com/questions/11094330/determining-the-big-o-runtimes-of-these-different-loops) : really good stackoverflow question that covers basics of calculating runtime complexity.
- [FAANGPath Resume template](https://faangpath.com/template/) : Maximize your chances to get your resume in the hands on HR/HM.
- [five-essential-phone-screen-questions - steveyegge2](https://sites.google.com/site/steveyegge2/five-essential-phone-screen-questions)
- [Freshers Interviews](http://placementsindia.blogspot.com)
- [Gainlo](http://www.gainlo.co/#!/) : Mock interview from professionals 
- [GeeksforGeeks/A computer science portal for geeks](http://www.geeksforgeeks.org) : also subscribe to their feeds to get links to their new articles.
- [github.com/odino/interviews](https://github.com/odino/interviews) : list of important questions for interview
- [Give your résumé a face lift](https://motorsh.wordpress.com/2009/01/13/give-your-resume-a-face-lift-from-lifeclever/)
- [Google Interview Warmup](https://grow.google/certificates/interview-warmup/) : Google Interview Warmup is an AI-based tool that helps individuals practise for their interviews.
- [Here's How to Prepare for Tech Interviews • /r/cscareerquestions](https://www.reddit.com/r/cscareerquestions/comments/1jov24/heres_how_to_prepare_for_tech_interviews/)
- [How to Answer "Tell Me a Little About Yourself"/The Art of Manliness](http://www.artofmanliness.com/2016/01/05/tell-me-a-little-about-yourself/)
- [How to Break Into the Tech Industry - a Guide to Job Hunting and Tech Interviews](http://haseebq.com/how-to-break-into-tech-job-hunting-and-interviews)
- [How to interview](http://kelukelu.me/interview/index.html)
- [How to prepare for an interview - 1](http://se7so.blogspot.com/2014/01/how-to-prepare-for-interview-1.html)
- [IIT Delhi Placement Experience](http://placement-iit2013.blogspot.com)
- [samwincott/Internship-Guide](https://github.com/samwincott/Internship-Guide) : An aggregate of links related to internships.
- [Interviewing At Jane Street](https://blog.janestreet.com/interviewing-at-jane-street/) : Interviewing At Jane Street
- [Interview Archives - Java Honk](http://javahonk.com/category/interview/)
- [Interview Cake](https://www.interviewcake.com/) : Free and Paid course options offering high quality technical interview practice. 
- [Job Interview: How to Ace a Job Interview/The Art of Manliness](http://www.artofmanliness.com/2012/08/06/how-to-ace-a-job-interview/)
- [Job interviews News, Videos, Reviews and Gossip - Lifehacker](https://lifehacker.com/search?s=job%20interviews/)
- [Job Interview Questions and Best Answers](https://www.thebalance.com/job-interview-questions-and-answers-2061204)
- [kimberli/interviews](https://github.com/kimberli/interviews) : study sheet for Interview
- [LeetCode](https://leetcode.com/) : A new way to learn. Here you can prepare for your interview.
- [Learnersbucket](https://learnersbucket.com): Data Structures and Algorithms in Javascript.
- [Mission-peace/interview problems](https://github.com/mission-peace/interview/wiki) : A large collection of coding interview problems
- [NeetCode](https://neetcode.io): Prepare topic wise coding questions which are most frequently asked in MAANG companies. 
- [Pramp/A free on demand interview practice platform for Software Engineers](https://www.pramp.com/ref/gt1) : Practice coding interviews with real peers
- [Problems/LeetCode OJ](https://leetcode.com/problemset/algorithms/) : Coding practice for interviews
- [Programmer And Software Interview Questions Answers](http://www.programmerinterview.com)
- [Reddit.com/user/ashish2199/m/puzzles](https://www.reddit.com/user/ashish2199/m/puzzles/) : Logic Puzzles
- [SQL interview questions](https://www.jitbit.com/news/181-jitbits-sql-interview-questions/) : great SQL test
- [SQL Joins explained using venn diagram](http://stevestedman.com/wp-content/uploads/VennDiagram1.pdf)
- [svozniuk/java-interviews](https://github.com/svozniuk/java-interviews) : Java interview questions
- [Techie Delight](https://www.techiedelight.com) : Leading platform for technical interview preparation.
- [The 25 most difficult HR questions](http://www.datsi.fi.upm.es/~frosal/docs/25mdq.html)
- [Top 10 Algorithms for Coding Interview](https://www.programcreek.com/2012/11/top-10-algorithms-for-coding-interview/) : Algorithms for Coding Interview
- [Unix / Linux Commands Cheat Sheet](https://www.geeksforgeeks.org/linux-commands-cheat-sheet/)
- [Unsolicited_advice_for_job_seekers_and_employers](https://www.reddit.com/r/india/comments/1clgdj/unsolicited_advice_for_job_seekers_and_employers/)
- [Visualising Data Structures and Algorithms through Animation](https://visualgo.net/en)
- [We Help Coders Get Hired](https://www.hiredintech.com/) : website offering courses on system design, interview strategies, soft skills etc
- [what_are_your_goto_questions_for_the_do_you_have?](https://www.reddit.com/r/cscareerquestions/comments/209rkq/what_are_your_goto_questions_for_the_do_you_have/)
- [Why You Make Less Money • /r/cscareerquestions](https://www.reddit.com/r/cscareerquestions/comments/1b8wa3/why_you_make_less_money/)
- [wu :: riddles(hard)](https://www.ocf.berkeley.edu/~wwu/riddles/hard.shtml) : logic puzzles and riddles
- [What I Learned from Interviewing at multiple AI Companies and Start-Ups](https://blog.usejournal.com/what-i-learned-from-interviewing-at-multiple-ai-companies-and-start-ups-a9620415e4cc#fa32)
-[Tech Interview Handbook](https://techinterviewhandbook.org/introduction/): Guide on  cracking tech interviews


<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 🎬 Documentaries
- [Breaking the Code](https://ia801908.us.archive.org/27/items/youtube-S23yie-779k/) : Biography of Alan Turing
- [Cracking The Code Interview](https://www.youtube.com/watch?v=4NIb9l3imAo) : Cracking the Code Interview
- [Cracking the Coding Interview](https://www.youtube.com/watch?v=Eg5-tdAwclo) : Cracking the Coding Interview, Fullstack Speaker Series
- [Harvard CS50 - Asymptotic Notation (video)](https://www.youtube.com/watch?v=iOq5kSKqeR4) : Asymptotic Notation explained by Harvard
- [Machine Code Instructions (video)](https://www.youtube.com/watch?v=Mv2XQgpbTNE) : Code instructions
- Machine that Changed the World - a very good documentary about the history of computers
  - Part 1 is unavailable for free streaming due to widespread copyright claims.
  - [Part 2: Inventing the Future](https://www.youtube.com/watch?v=0iPiYxjsYKk)
  - [Part 3: The Paperback Computer](https://www.youtube.com/watch?v=d7DKVfOXr54)
  - [Part 4: The Thinking Machine](https://www.youtube.com/watch?v=enWWlx7-t0k)
  - [Part 5: The World at Your Fingertips](https://www.youtube.com/watch?v=fLLXiP7diEo)
- [Mechanical Computer (All Parts)](https://www.youtube.com/watch?v=s1i-dnAH9Y4) : a very good video from the 1950s explaining how mechanical computers used to work without all the modern-day electronics.
- [Teach Yourself Computer Science](https://teachyourselfcs.com) : Teach Yourself Computer Science
- [The Code](https://www.youtube.com/watch?v=XMm0HsmOTFI) : Story of Linux documentary
- [The Internet's Own Boy](https://www.youtube.com/watch?v=9vz06QO3UkQ) : The Story of Aaron Swartz

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 🎓 MOOCs for learning something new
- [Boot.dev](https://www.boot.dev/) : Interactive online course to learn modern backend programming in Python, Javascript, Go, and more.
- [Class Central](https://www.class-central.com) : a directory of 100,000+ student reviews of thousands of MOOCs.
- [Classpert](https://classpert.com) : a website that gathers MOOCs and online courses from several providers, focusing on computer science and data science courses.
- [Computer Science Resources](https://docs.google.com/spreadsheets/d/1BD8BJJUNaX63m2QmySWMGDp71nx4W4MyyiIBlfMoN3Q/htmlview?sle=true#) : list of MOOCs for autodidacts
- [Coursera.org](https://www.coursera.org) : Take the world's best courses, online.
- [CS50](https://www.youtube.com/user/cs50tv/videos) : A set of goods tutorials from cs50
- [edX](https://www.edx.org) : Free Online Courses, Advance Your Career, Improve Your Life.
- [Kadenze/Creative Programming](https://www.kadenze.com/courses?subjects%5B%5D=7) : Programming courses focused on art and creativity
- [MIT OCW Electrical Engineering and Computer Science](https://ocw.mit.edu/courses/electrical-engineering-and-computer-science/)
- [MOOC.fi](http://mooc.fi/english.html) : Free online courses from the University of Helsinki
- [NPTEL](http://nptel.ac.in) : Free online courses by IIT with certificates
- [prakhar1989/awesome-CS-courses](https://github.com/prakhar1989/awesome-courses/blob/master/README.md) : List containing large amount of CS courses
- [Pluralsight](https://www.pluralsight.com) : An online learning and workforce development platform that helps businesses and individuals adjust to changing technology.

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 🧑‍💻 Sites related to your preferred programming language (For me C++)
- [Best books for learning java must read](https://javahungry.blogspot.com/2014/02/best-books-for-learning-java-must-read.html) : Get basics of Java
- [Bjarne Stroustrup's C++ Style and Technique FAQ](http://www.stroustrup.com/bs_faq2.html) : The C++ FAQ
- [Bjarne Stroustrup's FAQ](http://www.stroustrup.com/bs_faq.html) : The C++ FAQ
- [C++11 - the new ISO C++ standard](http://www.stroustrup.com/C++11FAQ.html) : The C++11 FAQ
- [Compilers (video)](https://www.youtube.com/playlist?list=PLO9y7hOkmmSGTy5z6HZ-W4k2y8WXF7Bff) : A set of videos on how the GC works
- [Deep Dive Java](https://www.infoq.com/presentations/garbage-collection-benefits) : Garbage Collection is Good!
- [Free Online Chapters of Inside the Java Virtual Machine by Bill Venners](http://www.artima.com/insidejvm/ed2/index.html) : Java Corner
- [How Garbage Collection Works](https://www.dynatrace.com/resources/ebooks/javabook/how-garbage-collection-works/) : Java memory management
- [Implementation of Algorithms and Data Structures, Interview Questions and Answers](https://github.com/sherxon/AlgoDS)
- [IntelliJ Keyboard Shortcuts](https://www.jetbrains.com/help/idea/keyboard-shortcuts-you-cannot-miss.html) : Keyboard shortcuts to enhance your productivity when working in IntelliJ.
- [Java Corner at Artima.com](http://www.artima.com/java/index.html) : Java Corner at Artima.com
- [Java Lecture Notes](http://www.cafeaulait.org/course/) : Java Student's Resource
- [Java Off Heap](http://www.javaoffheap.com) : Java Off the Heap house
- [Java Revisited](http://javarevisited.blogspot.com) : good for learning about Java Language and interview preparation.
- [Java-source](http://www.java-source.net) : Java source
- [Java Visualizer](http://www.cs.princeton.edu/~cos126/java_visualize/) : helps visualize references, values of variables, etc
- [JournalDev - Java, Java EE, Android, Web Development Tutorials](https://www.journaldev.com) : Java, Java EE, Android, Web Development Tutorials
- [Learning Java](http://chimera.labs.oreilly.com/books/1234000001805/index.html) : a free online textbook for learning Java
- [Netbeans Keyboard Shortcuts](https://netbeans.org/project_downloads/usersguide/shortcuts-80.pdf) : Keyboard shortcuts to enhance your productivity when working in Netbeans.
- [Official Qt Documentation](https://doc.qt.io/) : Documentation for different Qt versions, languages, tools and platforms
- [Search Open Source Java API](http://www.docjar.com) : view source of java library and learn how things are implemented.
- [The C++ Programming Language](http://www.stroustrup.com/C++.html) : The C++ Programming Language.
- [The Java Memory Model](http://www.cs.umd.edu/~pugh/java/memoryModel/): The Java Memory Model
- [The Java™ Tutorials](https://docs.oracle.com/javase/tutorial/) : The best tutorials for Java.
- [Understanding JVM Internals](http://www.cubrid.org/blog/understanding-jvm-internals) : Understanding JVM Internals
- [what-is-garbage-collection](https://downloads.plumbr.io/Plumbr%20Handbook%20Java%20Garbage%20Collection.pdf) : Demystify the garbage collection
- [JavaWorld](https://www.javaworld.com) : Welcome to Javaworld
- [JavatPoint](https://www.javatpoint.com/java-tutorial) : Best website to get a basic Java programming tutorial
- [The Rust Programming Language Book](https://doc.rust-lang.org/book/title-page.html) : Explains the Rust programming language
- [Rust Cookbook](https://rust-lang-nursery.github.io/rust-cookbook/intro.html#cookin-with-rust) : Quickly get an overview of the capabilities of the Rust crate ecosystem

- [Getting start with python](https://riptutorial.com/ebook/python) : A-Z python programming concepts and methods.

- [Rust by Example](https://doc.rust-lang.org/rust-by-example/) : A collection of runnable examples that illustrate various Rust concepts and standard libraries


<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 🤖 Learn AI
- [aima](http://aima.cs.berkeley.edu) : The leading textbook in Artificial Intelligence (4th most cited publication of the century). Includes Github repositories and more AI resources!
- [fast.ai](http://course.fast.ai) : Free practical *deep learning* course for coders without grad-level maths!
- [TypeDB](https://vaticle.com) : A Strongly-typed Database
- [Robots that learn](https://openai.com/research/robots-that-learn) : Robots that Learn
- [Unsupervised Sentiment Neuron](https://openai.com/research/unsupervised-sentiment-neuron) : Unsupervised Sentiment Neuron
- [What's the difference between AI- DP and ML?](https://blogs.nvidia.com/blog/2016/07/29/whats-difference-artificial-intelligence-machine-learning-deep-learning-ai/) : Difference artificial intelligence, machine-learning, deep-learning-ai
- [TensorFlow](https://www.tensorflow.org) : An open-source software library for Machine Intelligence
- [Scikit-learn](http://scikit-learn.org) : A Python module for machine learning build on top of SciPy
- [DeepLearning.ai](https://www.deeplearning.ai) : Deep Learning course by Andrew Ng, Founder of Coursera
- [Coding the History of Deep Learning](http://blog.floydhub.com/coding-the-history-of-deep-learning/) : Coding the History of Deep Learning
- [Serpent AI](https://github.com/SerpentAI/SerpentAI) : Game Agent Framework. Helping you create AIs / Bots to play any game you own! BETA
- [Blog Floydhub](https://blog.floydhub.com/colorizing-b&w-photos-with-neural-networks/) : Colorizing B&W Photos with Neural Networks
- [MLCOURSE.AI](https://mlcourse.ai/) : Open Machine Learning course by OpenDataScience
- [Elements of AI](https://course.elementsofai.com/) : A free course for AI basics by Reaktor and University of Helsinki
- [Machine Learning Mastery](https://machinelearningmastery.com/) : A comprehensive blog that contains guidance, tutorials, and e-book for mastering ML
- [Machine Learning Crash Course](https://developers.google.com/machine-learning/crash-course) : A jumpstart AI course from Google
- [Machine Learning Tutorial: A Step-by-Step Guide for Beginners](https://www.simplilearn.com/tutorials/machine-learning-tutorial) : A one-stop playlist for all the basics of Machine Learning simplified, from Logistic Regression to Reinforcement Learning.
- [MLU-EXPLAIN](https://mlu-explain.github.io/) : Machine Learning University (MLU) is an education initiative from Amazon designed for visual explanations of core machine learning concepts.

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 📢 Seminar, research writing, talks, etc
- [Advice on Research and Writing](http://www.cs.cmu.edu/~mleone/how-to.html) : A collection of advice about how to do research and how to communicate effectively (primarily for computer scientists).
- [PHD MS Articles](http://www.cse.iitd.ac.in/~srsarangi/articles.html) : articles and views
- [Seminar and reports](https://www.cse.iitb.ac.in/~ranade/communicationskills.html) : Everyone must read this tiny book before writing the seminar report
- [Latex reference](http://latex.knobs-dials.com) : Arbitrary reference
- [Begin Latex in minutes](https://github.com/LewisVo/Begin-Latex-in-minutes) : Brief Intro to LaTeX for beginners that helps you use LaTeX with the ease
- [Lshort](https://tobi.oetiker.ch/lshort/lshort.pdf) : The Not So Short Introduction to LATEX2ε

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 📦 Everything in one place
- [API Documentation](http://devdocs.io) : A one-place well-known API Documentation with a searchable interface
- [Baeldung](https://www.baeldung.com) : Step-by-step guides for Spring, rest, Java, security, persistence, Jackson, HTTP client-side and Kotlin
- [BtechBasics](https://btechbasics.in/) : Fundamental concepts of Computer Science Engineering using hands-on exercises
- [Branition Colors](https://branition.com/colors) : Collection of hand-curated color palettes best fitted for branding.
- [cheat.sh](https://github.com/chubin/cheat.sh) : `curl cheat.sh` — the only cheat sheet you need — instant answers on programming questions with `curl`
- [Developer Roadmaps](https://roadmap.sh/) : Step by step guides and paths to learn different tools or technologies
- [DevURLs](https://devurls.com/) : Developer news aggregator
- [Kaggle](https://www.kaggle.com/) : All-in-one Machine Learning and Data Science Community – access free GPUs and a huge repository of community published data & code.
- [MDN Web Docs](https://developer.mozilla.org/en-US/) : A place with all the documentation of the web standards
- [Rico's cheatsheets](https://devhints.io) : A set of good cheatsheets
- [Programming Subreddits](https://www.reddit.com/user/ashish2199/m/cs_student_subs/) : a multisubreddit of all subreddits of topics related to computer science and programming.
- [Websites a programmer should visit](https://www.quora.com/What-are-the-best-websites-a-programmer-should-visit/answer/Ashish-Padalkar?srid=OH96) : Response on Quora by ashish2199
- [gitignore](https://www.gitignore.io/) : A collection of useful .gitignore templates for your project. Select from 442 Operating System, IDE, and Programming Language
- [Hidden Tools](https://hiddentools.dev/) : Discover a wide collection of tools made by the community - for you. ✨
- [Coolors](https://coolors.co/) : Create the perfect palette or get inspired by thousands of beautiful color schemes.
- [Tailwind CSS Page Builder](https://devdojo.com/tails/app) :  The perfect Tailwind CSS Page Builder
- [LottieFiles](https://lottiefiles.com/) : The world’s largest online platform for the world’s smallest animation format for designers, developers, and more. Access Lottie animation tools and plugins for Android, iOS, and Web.
- [UI Design Daily](https://www.uidesigndaily.com/) :Weekly FREE UI resources straight to your inbox
- [Iconscout](https://iconscout.com/) : Over 2.2 Million+ Design Assets,  Curated SVGs, Vector Icons, Illustrations, 3D graphics, and Lottie Animations.  Over 3000+ assets added every day. Integrated plugins, tools, editors, and more.
- [Json API App](https://www.jsonapi.co/) : Single repository for everything you need to build better products as a developer. API, DB, Queue, Server, Webhooks, Bin, Tools, Podcasts etc. Everything you need to build super apps that our world needs.
- [Library or micro code solutions](https://onelinerhub.com/) : Community library of micro code pieces for popular issues.

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 📺 YouTube Channels
- [C++Now (BoostCon)](https://www.youtube.com/channel/UC5e__RG9K3cHrPotPABnrwg) : C++Now (previously BoostCon) conference
- [code::dive conference](https://www.youtube.com/channel/UCU0Rt8VHO5-YNQXwIjkf-1g) : code::dive conference organized by NOKIA Wrocław Technology Center
- [Coding Blocks](https://www.youtube.com/user/codingblocks) : Tutorials, how to's, tips and tricks
- [Computerphile](https://www.youtube.com/user/Computerphile/videos) : Must watch for every CS student
- [ComputerHistory](https://www.youtube.com/user/ComputerHistory/videos) : for those who like to know how we reached where we are.
- [CppCon](https://www.youtube.com/user/CppCon/videos?shelf_id=0&view=0&sort=dd) : C++ Conference
- [Facebook Developers](https://www.youtube.com/user/FacebookDevelopers/videos)
- [Google Developers](https://www.youtube.com/user/GoogleDevelopers/videos)
- [GoogleTechTalks](https://www.youtube.com/user/GoogleTechTalks/videos) : videos on trending topics and cool stuff happening in the tech industry.
- [Gynvael Coldwin](https://www.youtube.com/user/GynvaelEN) : Awesome reverse engineering and hacking(CTF) videocasts. Every Wednesday is new live streams.
- [HowToBecomeTV](https://www.youtube.com/user/HowToBecomeTV/videos) : contains good interviews of developers and people related to the tech industry.
- [Java](https://www.youtube.com/user/java/videos) : talks related to java
- [JavaOne](https://www.youtube.com/channel/UCdDhYMT2USoLdh4SZIsu_1g/videos) : Java Conference
- [javidx9](https://www.youtube.com/channel/UC-yuWVUplUJZvieEligKBkA/videos) : Game and graphics tutorials
- [Meeting C++ YT Kanalseite](https://www.youtube.com/user/MeetingCPP/videos) : Talks on C++
- [MIT OpenCourseWare](https://www.youtube.com/user/MIT/) : MIT OpenCourseWare for learning in-depth algorithms, data structures, and computer engineering
- [Murtaza's OpenCV Robotics and AI](https://www.youtube.com/c/MurtazasWorkshopRoboticsandAI/): OpenCV, Self Driving, Robotics and AI tutorials.
- [Netflix UI Engineering](https://www.youtube.com/channel/UCGGRRqAjPm6sL3-WGBDnKJA/videos) : great videos to watch for web developers, mobile developers and those interested in some of Netflix's tech stack
- [O'Reilly](https://www.youtube.com/user/OreillyMedia/videos) : interviews and talks of the world's best technical writers.
- [Placement Grid](https://www.youtube.com/user/PlacementGrid/videos) : Interview and campus placement experience
- [Scott Meyers: Past Talks](http://www.aristeia.com/presentations.html)
- [Siraj Raval](https://www.youtube.com/channel/UCWN3xxRkmTPmbKwht9FuE5A) : Artificial Intelligence and deep learning tutorials videos
- [ThinMatrix](https://www.youtube.com/user/ThinMatrix/videos) : blogs and tutorials developer making a 3d game in Java using OpenGL
- [thoughtbot](https://www.youtube.com/user/ThoughtbotVideo/videos) : talks on various topics
- [Traversy Media](https://www.youtube.com/user/TechGuyWeb/videos) :Web development and programming
- [yegor256](https://www.youtube.com/user/technoparkcorp/videos)
- [GOTO Conference](https://www.youtube.com/user/GotoConferences) : tech talks from the GOTO Conference by Developers for Developers
- [freeCodeCamp](https://www.youtube.com/channel/UC8butISFwT-Wl7EV0hUK0BQ) : freecodecamp youtube channel
- [Bo Qian](https://www.youtube.com/channel/UCEOGtxYTB6vo6MQ-WQ9W_nQ) : Learn advanced c++
- [Geeksforgeeks](https://www.youtube.com/channel/UC0RhatS1pyxInC00YKjjBqQ/videos) : geeksforgeeks youtube
- [Hacker earth](https://www.youtube.com/channel/UCYU6nvKyRYnE5kiG9JXkXpA) : Hacker earth youtube
- [Hak5](https://www.youtube.com/user/Hak5Darren) : Put together by a band of IT ninjas, security professionals, and hardcore gamers, Hak5 isn't your typical tech show. We take on hacking in the old-school sense.
- [Khan Academy](https://www.youtube.com/channel/UC4a-Gbdw7vOaccHmFo40b9g) : Khan Academy youtube
- [LearnCode.academy](https://www.youtube.com/channel/UCVTlvUkGslCV_h-nSAId8Sw) : 100% FREE Web Development tutorials, web site design tutorials, and more. Including, but not limited to: HTML, CSS, JavaScript, CSS Layouts, Responsive Design, React.js, Node.js, Angular.js, Docker, Dev
- [Rachit Jain](https://www.youtube.com/channel/UC9fDC_eBh9e_bogw87DbGKQ/featured) : competitive programming
- [sentdex](https://www.youtube.com/channel/UCfzlCWGWYyIQ0aLC5w48gBQ) : Python Programming tutorials, going further than just the basics. Learn about machine learning, finance, data analysis, robotics, web development, game development, and more.
- [Steve Griffith](https://www.youtube.com/channel/UCTBGXCJHORQjivtgtMsmkAQ) : The videos on this channel are largely about web design & development with a good dose of mobile development thrown in just for fun. 
- [The Coding Train](https://www.youtube.com/channel/UCvjgXvBlbQiydffZU7m1_aw) : In this YouTube channel I publish "creative coding" video tutorials every week. Subjects covered range from the basics of programming languages like JavaScript (with p5.js) and Java (with Processing) to generative algorithms like physics simulation, computer vision, and data visualization.
- [TheHappieCat](https://www.youtube.com/channel/UCBsuOBu-dxj5bx1KMgmar5g) : Videos on technology, storytelling, and being happie.
- [Tutorials Point (India) Pvt. Ltd.](https://www.youtube.com/channel/UCVLbzhxVTiTLiVKeGV7WEBg) : Tutorials Point originated from the idea that there exists a class of readers who respond better to online content and prefer to learn new skills at their own pace from the comforts of their drawing rooms. We bring simple to understand Text and Video tutorials at zero cost and cover many subjects including IT, Engineering, MBA, MCA, Management, Various Exams Preparation, and Academic subjects. If you are not extravagant and willing to save your money and time then we recommend you to try our tutorials.experience
- [Udacity](https://www.youtube.com/channel/UCBVCi5JbYmfG3q5MEuoWdOw) : Udacity, a pioneer in online education, is building "University by Silicon Valley", a new type of online university
- [V. Anton Spraul](https://www.youtube.com/channel/UCLEMTlEe5RE04EoULMHWEEQ) : Videos for people who want to understand the software better, including explanations of how the software performs some of its most important jobs and tools programmers can use to solve programming problems.
- [xdadevelopers](https://www.youtube.com/channel/UCk1SpWNzOs4MYmr0uICEntg) : You have found the world-famous XDA-Developers.com YouTube Channel, known as XDA TV. We cover Android and Windows Mobile from HTC, Samsung, Motorola, Sony, and more. Learn about rooting your Android, how to build applications, and more.
- [KudVenkat](https://www.youtube.com/user/kudvenkat/) : Microsoft .NET technologies and SQL Server tutorials.
- [The Net Ninja](https://www.youtube.com/channel/UCW5YeuERMmlnqo4oq8vwUpg): Web development tutorials
- [Web Dev Simplified](https://www.youtube.com/channel/UCFbNIlppjAuEX4znoulh0Cw): Tutorials based on Web development from basic to advanced.
- [Take You Forward](https://www.youtube.com/c/takeUforward): Tutorials on Data structures and Algorithms in Java and C++.

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## ✍️ Good Articles
- [14 Things I Wish I’d Known When Starting with MongoDB](https://www.infoq.com/articles/Starting-With-MongoDB/)
- [40 Keys Computer Science Concepts Explained In Layman’s Terms](http://carlcheo.com/compsci)
- [A Gentle Introduction To Graph Theory](https://dev.to/vaidehijoshi/a-gentle-introduction-to-graph-theory)
- [A programmer-friendly language that compiles to Lua.](http://moonscript.org)
- [A Software Developer’s Reading List](https://stevewedig.com/2014/02/03/software-developers-reading-list/) : Some good books and links in there.
- [Code a TCP/IP stack](http://www.saminiir.com/lets-code-tcp-ip-stack-5-tcp-retransmission/) : Let's code a TCP/IP stack, 5: TCP Retransmission
- [Codewords.recurse](https://codewords.recurse.com/issues/four/the-language-of-choice) : The language of choice
- [Learn Data structure and Algorithms](https://www.freecodecamp.org/news/learn-data-structures-and-algorithms/) : List of some algorithms and data structures and learning resources.
- [Dive into the byte code](https://www.wikiwand.com/en/Java_bytecode)
- [Expectations of a Junior Developer](http://blog.thefirehoseproject.com/posts/expectations-of-a-junior-developer/)
- [Getting Started with MongoDB – An Introduction](https://studio3t.com/knowledge-base/articles/mongodb-getting-started/)
- [Linux Inside](https://0xax.gitbooks.io/linux-insides/content/Booting/linux-bootstrap-1.html)
- [List of algorithms](https://www.wikiwand.com/en/List_of_algorithms)
- [Step by Step Guide to Database Normalization](https://www.databasestar.com/normalization-in-dbms/): A guide to database normalization.
- [The Key To Accelerating Your Coding Skills](http://blog.thefirehoseproject.com/posts/learn-to-code-and-be-self-reliant/)
- [Unicode](https://www.joelonsoftware.com/2003/10/08/the-absolute-minimum-every-software-developer-absolutely-positively-must-know-about-unicode-and-character-sets-no-excuses/)
- [We are reinventing the retail industry through innovative technology](http://multithreaded.stitchfix.com)
- [What every programmer absolutely, positively needs to know about encodings and character sets to work with text](http://kunststube.net/encoding/)
- [What every programmer should know about memory - PDF](https://people.freebsd.org/~lstewart/articles/cpumemory.pdf)
- [qotoqot - improving-focus](https://qotoqot.com/blog/improving-focus/) : How I got to 200 productive hours a month
- [Pixel Beat - Unix](http://www.pixelbeat.org/docs/unix-parallel-tools.html) : Parallel processing with Unix tools
- [Learning Vim](https://hackernoon.com/learning-vim-what-i-wish-i-knew-b5dca186bef7) : What I Wish I Knew
- [Write a Kernel](http://arjunsreedharan.org/post/82710718100/kernel-101-lets-write-a-kernel) : Kernel 101 – Let’s write a Kernel
- [Learning JavaScript Design Patterns](https://addyosmani.com/resources/essentialjsdesignpatterns/book/) : the online version of the Learning JavaScript Design Patterns published by O'Reilly, released by the author Addy Osmani under CC BY-NC-ND 3.0
- [Working with Webhooks](https://requestbin.com/blog/working-with-webhooks/) : a comprehensive guide on webhooks
- [How I got TensorFlow Developer Certified](https://www.mrdbourke.com/how-i-got-tensorflow-developer-certified/) : Step By Step guide to pass Tensorflow Developer Certification

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 🎧 Podcasts
- [Coding Blocks](http://www.codingblocks.net) : A podcast covering topics such as best programming practices, design patterns, coding for performance, object-oriented coding, database design and implementation, tips, tricks and a whole lot of other things.
- [Developer On Fire](http://developeronfire.com/episodes) : A podcast that shares the humanity of developers and tells stories of some of the amazing people in software, hosted by Dave Rael.
- [Developer Tea](https://spec.fm/podcasts/developer-tea) : A podcast for developers designed to fit inside your tea break.
- [Front End Happy Hour](http://frontendhappyhour.com) : A podcast featuring a panel of Software Engineers from Netflix, Evernote, Atlassian & LinkedIn talking over drinks about all things Front End development.
- [Full Stack Radio](http://www.fullstackradio.com) : Everything from product design and user experience to unit testing and system administration.
- [Groovy Podcast](http://groovypodcast.podbean.com) : A podcast dedicated to the Groovy programming language and its ecosystem.
- [IPhreaks](https://devchat.tv/iphreaks) : A weekly group discussion about iOS development and related technology by development veterans. We discuss Apple, tools, practices, and code.
- [JavaScript Jabber](https://devchat.tv/js-jabber) : A weekly discussion about JavaScript, front-end development, community, careers, and frameworks.
- [Learn To Code With Me Podcast](https://learntocodewith.me/podcast/) : A Season by season of tech podcast episodes by Laurence Bradford with topics ranging from Career in Tech to lessons in doing tech business
- [LispCast](https://lispcast.com/category/podcast/) : A podcast by Eric Normand, a functional programming expert talking about FP concepts.
- [MS Dev Show](http://msdevshow.com) : Jason Young and Carl Schweitzer talk about the latest in developer news covering topics such as the Azure cloud, Windows, Windows Phone, Visual Studio, and cross-platform development using the Microsoft platform.
- [React Native Radio](https://devchat.tv/react-native-radio) : A weekly discussion of the tools, techniques, and technologies used to build mobile applications with JavaScript and React.
- [ShopTalk Show](https://shoptalkshow.com/) : A weekly podcast about just building websites from Dave Rupert and Chris Coyier.
- [Soft Skills Engineering](https://softskills.audio/) : A weekly advice podcast for software developers about non-technical topics.
- [Software Engineering Daily](https://softwareengineeringdaily.com) : A daily technical interview about software topics.
- [Software Engineering Radio](http://www.se-radio.net) : A podcast targeted at the professional software developer. The goal is to be a lasting educational resource, not a newscast.
- [Syntax](https://syntax.fm) : A Tasty Treats Podcast for Web Developers by Wes Bos & Scott Tolinski.
- [The Bike Shed](http://bikeshed.fm) : Guests discuss their development experience and challenges with Ruby, Rails, JavaScript, and others.
- [The Changelog](https://changelog.com/podcast) : A weekly conversation that gets to the heart of open source technologies and the people who create them.
- [The Cynical Developer](https://cynicaldeveloper.com) : A podcast that aims to help you to improve your development knowledge and career, through explaining the latest and greatest in development technology and providing you with what you need to succeed as a developer. Covering Desktop, web, and mobile development, mainly around the .Net Stack but often looking into other software and frameworks.
- [The Real Python Podcast](https://realpython.com/podcasts/rpp/) : A weekly Python podcast hosted by Christopher Bailey with interviews, coding tips, and conversation with guests from the Python community.
- [Blockchain Insider by 11:FS](blockchain.global/blockchain-innovation) : Podcast to learn about the Blockchain Technology
- [Unchained](unchainedpodcast.co) Podcast to learn about the Blockchain Technology
- [Talk python to me](https://talkpython.fm/) Podcast to learn about Python through interviews and discussions 
- [Python bytes](https://pythonbytes.fm) Podcast to learn about the latest happenings and trends in Python

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 🔄 Building a Simple Compiler/Interpreter
- [:snowman: Possibly the smallest compiler ever](https://github.com/thejameskyle/the-super-tiny-compiler) : This is an ultra-simplified example of all the major pieces of a modern compiler written in easy to read JavaScript.
- [Awesome Compilers](http://aalhour.com/awesome-compilers/) : Curated list of awesome resources on Compilers, Interpreters, and Runtimes.
- [Growing a compiler](http://www.cs.dartmouth.edu/~mckeeman/cs48/mxcom/gem/html/GrowingCompiler.html) : Learn how to grow a compiler
- [Let’s Build A Simple Interpreter. Part 1.](https://ruslanspivak.com/lsbasi-part1/) : Try to demystify compilers by building one
- [Resources for Amateur Compiler Writers](http://c9x.me/compile/bib/) : Resources for Amateur Compiler Writers
- [Structure and Interpretation of Computer Programs](https://sarabander.github.io/sicp/html/index.xhtml) : Structure and Interpretation of Computer Programs
- [Writing My First Compiler](https://dev.to/fcpauldiaz/writing-my-first-compiler) : Write out your first compiler
- [An Intro to Compilers](https://nicoleorchard.com/blog/compilers) : How to Speak to Computers, Pre-Siri
- [Write your own compiler](http://staff.polito.it/silvano.rivoira/HowToWriteYourOwnCompiler.htm) : How to write your compiler
- [Crafting Interpreters](http://craftinginterpreters.com/) A handbook for writing interpreters, first implementing a tree walking interpreter and later a bytecode virtual machine
- [Writing a C Compiler](https://norasandler.com/2017/11/29/Write-a-Compiler.html) : The first post in a series by Nora Sandler on writing your own C compiler

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 🧑‍🏫 Tutorials
- [A Hacker's Guide to Git](https://wildlyinaccurate.com/a-hackers-guide-to-git/) : for those wanting to learn git with a solid foundation
- [A Byte of Python](https://python.swaroopch.com) : a free beginner introduction to python
- [Best Of - Gustavo Duarte](http://duartes.org/gustavo/blog/best-of/) : contains articles on various topics
- [CMSI 281: Data Structures](http://cs.lmu.edu/~ray/classes/dsa/) : lightweight introduction to DS
- [Collecting all the cheat sheets](http://overapi.com) : cheat sheets for lots of programming languages
- [C Programming](http://users.cs.cf.ac.uk/Dave.Marshall/C/CE.html)
- [CryptoHack](https://cryptohack.org/) : Learn cryptography through challenges and tutorials. Has a leaderboard and new challenges are added every few months. 
- [Programming Community Curated C++ Resources](https://hackr.io/tutorials/learn-c-plus-plus) : resources recommended by developers
- [Deep C](https://www.slideshare.net/olvemaudal/deep-c) : very good presentation on C language
- [Design Patterns: Elements of Reusable Object-Oriented Software](https://www.amazon.com/Design-Patterns-Elements-Reusable-Object-Oriented/dp/0201633612) : aka the "Gang Of Four" book, or GOF
- [Dynamic programming - PrismoSkills](http://prismoskills.appspot.com/lessons/Dynamic_Programming/Chapter_01_-_Introduction.jsp) : very good resource if want to learn how to solve DP problems.
- [Flexbox Froggy](https://flexboxfroggy.com) : a game that teaches you how to use CSS flexbox properties
- [Git from the inside out](https://maryrosecook.com/blog/post/git-from-the-inside-out)
- [Head First Design Patterns](https://www.amazon.com/Head-First-Design-Patterns-Brain-Friendly/dp/0596007124)
- [How to Program in C++](http://cs.fit.edu/~mmahoney/cse2050/how2cpp.html) : Good resource for revising C++ topics and STL
- [http://www.mysqltutorial.org/](http://www.mysqltutorial.org)
- [indradhanush tutotials](https://indradhanush.github.io/blog/writing-a-unix-shell-part-3/) : Writing a Unix Shell
- [Introduction to C Programming](http://www.le.ac.uk/users/rjm1/cotter/index.htm)
- [Learn UNIX in 10 minutes](http://freeengineer.org/learnUNIXin10minutes.html)
- [Learning the shell.](http://linuxcommand.org)
- [Linux Journey](https://linuxjourney.com) : good site for learning Linux
- [Linux Tutorial](https://ryanstutorials.net/linuxtutorial/) : good resource for learning Linux
- [Missing Semester](https://missing.csail.mit.edu/) : The missing semester of your computer science education
- [More about Github-flavored markdown](https://guides.github.com/features/mastering-markdown/)
- [MySQL Essentials](http://www.techotopia.com/index.php/MySQL_Essentials)
- [Open Data Structures](http://opendatastructures.org) : Excellent resource for learning about DS and algos, provides code in various languages C++, Java, and pseudocode.
- [OS Course Notes](https://www2.cs.uic.edu/~jbell/CourseNotes/OperatingSystems/) : Chapter-wise course notes according to Galvin's book
- [Programming, Web Development, and DevOps news, tutorials, and tools for beginners to experts](https://dzone.com)
- [Prompt engineering](https://www.promptingguide.ai/) : Prompting Guide AI is an online resource that helps users learn and craft effective prompts for AI models to generate better and more relevant outputs.
- [Stanford Programming Course](https://see.stanford.edu/Course/CS106A) : Full, free CS course created by Stanford
- [SQL (Structured Query Language) in one page : SQL.SU](http://www.cheat-sheets.org/sites/sql.su/) : a very good SQL cheat sheet
- [Subtle/Poor Man's CI](https://www.subtle.press/course/poor-mans-ci) : Learn how continuous integration platforms work under the hood, by building one of your own on top of git with Node.js
- [TCP/IP Illustrated Series](https://en.wikipedia.org/wiki/TCP/IP_Illustrated)
- [The Bash Guide](http://guide.bash.academy) : a very good guide for learning the Bash Shell
- [The Descent to C](https://www.chiark.greenend.org.uk/~sgtatham/cdescent/) : for those moving to C from some higher programming language like java or python.
- [The Linux Command Line: A Complete Introduction](https://www.amazon.com/Linux-Command-Line-Complete-Introduction/dp/1593273894)
- [The Unix Programming Environment](http://product.half.ebay.com/The-UNIX-Programming-Environment-by-Brian-W-Kernighan-and-Rob-Pike-1983-Other/54385&tg=info)
- [TopCoder Tutorials](https://www.topcoder.com/community/data-science/data-science-tutorials/)
- [Tutorialspoint](https://www.tutorialspoint.com) : Text and Video Tutorials for UPSC, IAS, PCS, Civil Services, Banking, Aptitude, Questions, Answers, Explanation, Interview, Entrance, Exams, Solutions
- [UNIX and Linux System Administration Handbook, 4th Edition](https://www.amazon.com/UNIX-Linux-System-Administration-Handbook/dp/0131480057)
- [VimTutor+](https://vimtutorplus.herokuapp.com/exercise/1) : Learn VIM from the browser.
- [W3Schools Online Web Tutorials](https://www.w3schools.com)
- [Unix Shell](https://www.dartmouth.edu/~rc/classes/ksh/print_pages.shtml) : Unix shell scripting with ksh/bash
- [Snap SVG](http://snapsvg.io) : The JavaScript SVG library for the modern web
- [vim.rtorr](https://vim.rtorr.com) : Vim Cheat Sheet
- [Open Vim](http://www.openvim.com/tutorial.html) :  Interactive Vim tutorials
- [Algorithm Using Dynamic Programming and A](http://thume.ca/2017/06/17/tree-diffing/) : Designing a Tree Diff Algorithm Using Dynamic Programming and A*
- [Learn Python](https://www.learnpython.org) : Free Interactive Python Tutorial
- [C++17](https://www.viva64.com/en/b/0533/) : A guide of C++17
- [The Bash Academy](http://www.bash.academy) : The Bash Academy is an initiative to promote the bash shell language and educate people on its use.
- [Learn Shell Programming](http://learnshell.org) : This website is intended for everyone who wishes to learn programming with Unix/Linux shell interpreters.
- [Java tutorial](https://hackr.io/tutorials/learn-java) : A programming community & a great place to find the best online programming courses and tutorials.
- [Explain Shell](https://explainshell.com/): Match command-line arguments to their help text
- [Speaking io](https://speaking.io/) : Tips for public speaking
- [Javascript.info](https://javascript.info/) : The Modern JavaScript Tutorial

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 👀 Watch others code
- [Education Ecosystem](https://www.education-ecosystem.com) : screencast of people building applications, websites, games, etc.
- [Twitch.tv](https://www.twitch.tv/directory/game/Science%20%26%20Technology) : The programming community of twitch.

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 🧠 What should a programmer know
- [Can I use](https://caniuse.com/) : A website that provides up-to-date browser support tables for support of front-end web technologies on desktop and mobile web browsers.
- [GitHub.com Build software better, together](https://github.com) : Place to showcase your project and collaborate with others. (Must know Git to use it effectively)
- [GitLab](https://about.gitlab.com) : An alternative to GitHub that offers free unlimited (private) repositories and unlimited collaborators.
- [Programmer Competency Matrix](https://www.sijinjoseph.com/programmer-competency-matrix/) : article for knowing what our level as a programmer is.

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## ⚔️  Competitive programming
- [Topic Wise Problem For Competitive Programmer](https://a2oj.com/categories) : Topic wise Practise Problem
- [Advent of Code](https://adventofcode.com) : An Advent calendar of small programming puzzles
- [Archived Problems - Project Euler](https://projecteuler.net/archives) : Problems Archives
- [Art of Problem Solving](https://artofproblemsolving.com) : Is math class too easy for you? You've come to the right place!
- [AtCoder](https://atcoder.jp/) : One of the best places to build competitive programming skills for beginners to experts.
- [CodeChef](https://www.codechef.com) : The only programming contests Web 2.0 platform
- [CodeSignal](https://app.codesignal.com) : Test your coding skills
- [CodeEval](https://www.codeeval.dev/) : Notepad for notes and code snippets, stored locally in the browser
- [Codeforces](http://codeforces.com) : Programming Competition,Programming Contest,Online Computer Programming
- [Codewars](https://www.codewars.com) : Rank up by completing code kata
- [Codility](https://codility.com) : Verify and improve coding skills
- [Codingame](https://www.codingame.com/start) : Learn coding through games and challenges!
- [Facebook Hacker Cup](https://www.facebook.com/hackercup/) : Facebook's Programming Contest, past problems solutions and FAQ
- [Google Coding Competitions Archive](https://zibada.guru/gcj/) : past contest problems for practice
- [HackerEarth - Programming challenges and Developer jobs](https://www.hackerearth.com)
- [HackerRank](https://www.hackerrank.com) : Practice coding. Compete. Find jobs.
- [LightOJ](https://lightoj.com) : Practicing at lightoj is so good for beginners as it is categorized and have also chat room and forum which helps to communicate with others about any problem.
- [PKU ACM ICPC Practice problems](http://poj.org/problemlist) : Judge online for ACMACPC
- [Sphere Online Judge (SPOJ)](http://www.spoj.com) : Become a true programming master Learn how to code and build efficient algorithms
- [Topcoder](https://www.topcoder.com) : Deliver Faster through Crowdsourcing
- [URI Online Judge](https://www.urionlinejudge.com.br/judge/en/register) : Practice coding, Compete and be a better coder.
- [UVa Online Judge](https://uva.onlinejudge.org) : hundreds of problems supporting multiple languages.
- [WakaTime](https://wakatime.com) : leaderboards of coding metrics collected via editor plugins
- [PrepBytes](https://mycode.prepbytes.com/competitive-coding/practice) : Topic and level wise proper arrange problems 
- [A2OJ Ladders](https://a2oj.com/Ladders.html) : Practice codeforces problems based on your proficiency and difficulty

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 📖 Computer Books
- [Become a Programmer, Motherfucker (list of books)](http://programming-motherfucker.com/become.html) : Exhaustive list of books from Zed A. Shaw.
- [Best books for GATE CSE](http://gatecse.in/best-books-for-gatecse/)
- [cses.fi/book.html](https://cses.fi/book.html)
- [github.com/vhf/free-programming-books](https://github.com/EbookFoundation/free-programming-books/blob/master/README.md) : More than 500 free ebooks on almost any language you can think of
- [GitBook](https://www.gitbook.com) : GitBook helps your team write, collaborate, and publish content online.
- [Data Science course](https://jakevdp.github.io/PythonDataScienceHandbook/) : Python Data Science Handbook
- [Goal Kicker](https://goalkicker.com) : Programming Notes for Professionals books
- [The GraphQL Guide](https://graphql.guide) : The complete guide to GraphQL, the new REST ✨
- [Eloquent JavaScript](https://eloquentjavascript.net/) : A book about JavaScript, programming, and the wonders of the digital.
- [programmingbooks.dev](https://www.programmingbooks.dev) : An Ordered and Curated Reading List for Software Craftsmanship Growth.

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 🔴 Video Tutorials
- [Aditya Verma](https://www.youtube.com/channel/UC5WO7o71wvxMxEtLRkPhiQQ): Algorithm tutorials playlists by an Indian youtuber Aditya verma.
- [codedamn](https://www.youtube.com/channel/UCJUmE61LxhbhudzUugHL2wQ/videos) : front end web dev tutorials
- [Code School](https://www.codeschool.com) : A PluralSight Company and an Interactive learning destination for aspiring and experienced Developers
- [CodingMadeEasy](https://www.youtube.com/user/CodingMadeEasy/videos) : C++ tutorials
- [CS1: Higher Computing - Richard Buckland UNSW](https://www.youtube.com/playlist?list=PL6B940F08B9773B9F) : a very good introductory CS course
- [Derek Banas](https://www.youtube.com/user/derekbanas/videos) : good quality tutorials
- [Design and Analysis of Algorithms](http://openclassroom.stanford.edu/MainFolder/CoursePage.php?course=IntroToAlgorithms)
- [DevTips](https://www.youtube.com/user/DevTipsForDesigners/videos) : web dev tutorials
- [FreeCourses](https://freecourses.github.io) : Free courses about programming
- [Kathryn Hodge](https://www.youtube.com/channel/UC4DwZ2VXM2KWtzHjVk9M_xg/videos) : Has good videos for beginners
- [Kunal Kushwaha](https://www.youtube.com/watch?v=apGV9Kg7ics) : An amazing guide to Git and GitHub for beginners
- [mycodeschool](https://www.youtube.com/user/mycodeschool/videos) : Data structures and algorithms tutorials
- [Pluralsight](https://www.pluralsight.com) : Learn Software Development, DevOps and Data Science through multiple short courses
- [thenewboston](https://www.youtube.com/user/thenewboston/videos) : good but with too much talk as compared to actual content
- [Tushar Roy](https://www.youtube.com/user/tusharroy2525/videos) : Algorithm and Data structure tutorial by an Indian Youtuber.
- [Vim Tutorial Videos - Flarfnoogins](http://derekwyatt.org/vim/tutorials/index.html) : good video tutorial for learning vim
- [XDA-University - Helping You Learn Android Development](https://forum.xda-developers.com/general/xda-university)
- [Khan Academy](https://www.khanacademy.org/computing/computer-science) : learn about computer science for free
- [Functional programming](https://www.youtube.com/watch?v=1PhArSujR_A) : John Carmack on Functional Programming (2013)
- [Video about vims](https://vimeo.com/album/2838732) : A serie of tutorials about Vim
- [Mastering Next.js](https://masteringnextjs.com/) : A free serie of videos to learn Next.js

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 💻 Online Compiler and Sharing Code snippets
- [C9.io](https://c9.io) : Your development environment, in the cloud
- [Carbon](https://carbon.now.sh/) : Create pretty looking images of your code snippets.
- [Codeframe](https://codeframe.co/) : Online pastebin-like playground for building websites using HTML, CSS, and JavaScript 
- [CodePad](https://codepad.remoteinterview.io) : Code editor to try, test and run 25+ languages
- [Coder](https://coder.com) : A Web-based development environment using Visual Studio Code as a code editor
- [Codesandbox.io](https://codesandbox.io) : CodeSandbox makes it easier to create, share, and reuse React projects with others.
- [Github Codespaces](https://github.com/codespaces) : Integrated cloud-based IDE directly to your browser.
- [Github Gist](https://gist.github.com) : Instantly share code, notes, and snippets.
- [Godbolt.org](https://godbolt.org) : Excellent tool for exploring the assembly output of different compilers with and without optimization.
- [Ideone.com](https://ideone.com) : online compiler and debugging tool for more than 60 programming languages
- [JSFiddle](https://jsfiddle.net) : Test your JavaScript, CSS, HTML or CoffeeScript with online code editor
- [JSBin](https://jsbin.com/) : Front end playground, Output is not framed, so it allows you to share those snippets that will break inside an iframe.
- [Judge0 IDE](https://ide.judge0.com) : Online compiler with 40+ interpreters and compilers.
- [Pastebin.com](https://pastebin.com) : Pastebin can store texts like code, notes, and snippets online for a set time which can be shared instantly.
- [PlayCode](https://playcode.io/) : Online Javascript playground with a built-in console and support for npm packages.
- [RunJS](https://runjs.app/play) : Online JavaScript playground with instant live feedback
- [StackBlitz](https://stackblitz.com/) : Instant Dev environments with support of nodejs and npm packages.
- [Wandbox](https://wandbox.org/): Online compiler with bleeding edge C++ and 40 other languages.
- [PHPize.online](https://phpize.online/): Online PHP compiler with SQL support.

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 📝 Blogs of Developers
- [Algo-Geeks](http://algo-geeks.blogspot.com) : Programming Puzzles, Math Tricks, Algorithms, etc
- [Amit Merchant](https://www.amitmerchant.com) : Tutorials, tips & tricks, and rants about programming and design.
- [Andy Heathershaw](https://www.andyheathershaw.uk) : Personal website and blog of software developer Andy Heathershaw
- [Antonio081014's Algorithms Codes](http://code.antonio081014.com) : The world is under the RULE.  
- [Archives — Ask a Manager](http://www.askamanager.org/archives) : HR-related stuff
- [Armin Ronacher's Thoughts and Writings](http://lucumr.pocoo.org) : blog on Python and open source
- [blog.might.net](http://matt.might.net/articles/) : the blog of might dot net
- [Brendon Gregg - Linux Kernel Dev](http://www.brendangregg.com) : the blog of Brendon D. Gregg
- [Clean Coder Blog](http://blog.cleancoder.com) : a blog of the author of the book "Clean Code"
- [CodeAhoy](https://codeahoy.com) : Blog on software and human factors. 100% Tested on Humans.
- [CoderGears Blog Insights from](http://www.codergears.com/Blog/) : the CoderGears Team
- [Coding Geek - A blog about IT, programming and Java](http://coding-geek.com) : A blog about IT, programming and Java
- [Coding Horror](https://blog.codinghorror.com) : one the best coding blog
- [CSE Blog](http://www.cseblog.com) : quant, math, computer science puzzles
- [CSS Tricks](https://css-tricks.com/) : about building websites and all that entails, mostly from a front-end perspective
- [Daedtech.com](https://www.daedtech.com) : Stories about software
- [Dan Dreams of Coding](https://dandreamsofcoding.com)
- [Daniel Lemire's Blog](https://lemire.me/blog/) : Daniel Lemire's blog
- [Eli Bendersky](http://eli.thegreenplace.net) : everything from Python to LLVM
- [Geek Land](https://avidullu.wordpress.com) : My precious collectibles
- [HackerEarth Blog](http://blog.hackerearth.com) : The HackerEarth blog
- [IT Enthusiast](http://rodiongork.tumblr.com) : IT Enthusiast
- [Joel on Software](https://www.joelonsoftware.com) : The blog of the CEO of StackOverflow
- [Late Developer](https://latedev.wordpress.com) :  Random thoughts of an old C++ guy
- [Linux Forums](https://www.linux.org/forums) : A Friendly Linux Forum
- [1ucasvb's laboriginal math and physics visualization](http://1ucasvb.tumblr.com) : Lucas Vieira Barbosa's lab original math and physics visualization
- [Math ∩ Programming](https://jeremykun.com) : Math ∩ Programming
- [My Tech Interviews](http://www.mytechinterviews.com) : PREPARE FOR A TECHNICAL INTERVIEW
- [Paul Graham Essays](http://www.paulgraham.com/articles.html) : Paul Grahan Essays
- [Programming Blog](http://www.yegor256.com) : programming blog of Yegor Bugayenko
- [Programming in the 21st Century](http://prog21.dadgum.com) : programming in the twenty-first century
- [rudhakar Rayavaram](http://sudhakar.online) : Sudhakar Rayavaram Blog's
- [Runhe Tian Coding Practice](https://tianrunhe.wordpress.com) : Technical interview questions from Apple, Google, Facebook, Amazon, and Microsoft
- [Small Programming Challenges and Puzzles](https://www.nayuki.io/category/programming) : Project Nayuki
- [stevehanov.ca](http://stevehanov.ca/blog/) : I know how to make and sell software online, and I can share my tips with you.
- [Takipi Blog](http://blog.takipi.com) : mainly focuses on Java and JVM languages
- [The Pragmatic Engineer](https://blog.pragmaticengineer.com/) : Software. People. Problems. Ideas. Engineering.
- [XDA - Android Developer Forum](https://forum.xda-developers.com) : Android Open Source Developers Forum
- [The Net Ninja](https://www.thenetninja.co.uk/): Web development tutorials

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 🗣️ For improving your English
- [Englishclub.com/learn-english](https://www.englishclub.com/learn-english.htm)
- [Guide to Grammar and Writing](http://grammar.ccc.commnet.edu/grammar/) : for those who want to improve their English language skills
- [Punctuation and Capitalization Rules](http://www.grammarbook.com/english_rules.asp)
- [Purdue University Online Writing Lab (OWL)](https://owl.english.purdue.edu)
- [Quia - English](https://www.quia.com/shared/english/)
- [AntiMoon Immersion Approach](http://www.antimoon.com/how/howtolearn.htm): Immersion-based learning of English, can be used by people on different levels.

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 🧘‍♂️ When you get bored from CS related stuff
- [Barcroft TV](https://www.youtube.com/user/barcroftmedia/featured) : Daily short documentaries about the incredible variety of people that make up the world
- [Big Think](https://www.youtube.com/user/bigthink/videos) : Expert driven, actionable, educational content, featuring experts ranging from Bill Clinton to Bill Nye
- [ColdFusion](https://www.youtube.com/user/coldfustion/videos) : Past, present, and future of technology
- [CrashCourse](https://www.youtube.com/user/crashcourse/videos) : small courses on various subjects
- [Every Frame a Painting](https://www.youtube.com/user/everyframeapainting/videos) : High-quality analysis of films and filmmaking
- [National Geographic](https://www.youtube.com/user/NationalGeographic/videos) : High volume of high-quality content from all over the world
- [r/ProgrammerHumor](https://www.reddit.com/r/ProgrammerHumor/) : Subreddit dedicated to exactly what it sounds like
- [Reddit the front page of the internet](https://www.reddit.com) : Where free time goes to die
- [Ridddle](https://www.youtube.com/user/VineMontanaTV/videos) : A youtube channel about science, mainly, but not only, the universe and space.
- [Regex Crossword](https://regexcrossword.com) : A simple crossword game where clues are regex that must be matched.
- [SciShow](https://www.youtube.com/user/scishow/videos) : Answers to interesting questions that you've always wondered about
- [SmarterEveryDay](https://www.youtube.com/user/destinws2/videos) : Lots of amazing scientific information about the world around us, usually captured with a high-speed camera
- [TED](https://www.youtube.com/user/TEDtalksDirector/videos) : Great talks about technology, entertainment, and design
- [TestTube News](https://www.youtube.com/user/TestTubeNetwork/videos) : Interesting information about news from around the world
- [How to live for a long time ?](http://www.bbc.com/future/story/20170601-the-secret-to-a-long-and-healthy-life-eat-less) : The secret of longevity
- [Vsauce](https://www.youtube.com/user/Vsauce/videos) : The best youtube channel
- [Ox A cuk](http://www.ox.ac.uk/research/research-in-conversation/how-live-happy-life/dr-bronwyn-tarr#) : How to live a happy life
- [lonelyspeck](https://www.lonelyspeck.com/the-milky-way-in-los-angeles-light-pollution/) : Expose to the Right for Astrophotography in Light Pollution – Palos Verdes, Los Angeles, California

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 🔓 Open Source Websites
- [N-O-D-E](https://n-o-d-e.net/) : Everything open-source and hacker culture - news, zines, and projects
- [Open Hatch](https://openhatch.org) : OpenHatch is a non-profit dedicated to matching prospective free software contributors with communities, tools, and education.
- [Source Forge](https://sourceforge.net) : SourceForge hosts nearly 280,000 projects (at last count). It serves more than 2 million downloads a day and includes apps and tools in a wide variety of categories.
- [Google Code](https://code.google.com/projecthosting) : Google offers free hosting for open source projects using the Subversion or Mercurial version control systems. It offers 2 GB of storage, integrated code review tools, a wiki, and an issue tracker. The Google Code site also provides links to Google's many publicly available APIs and other developer tools.
- [Launch Pad](https://launchpad.net) : Maintained by Canonical, LaunchPad is particularly targeted at projects that run on Ubuntu. It provides hosting for more than 21,000 projects that use the Bazaar version control system.
- [Google Open Source](https://opensource.google.com) : Google Open Source
- [Red Hat Developer](https://developers.redhat.com) : The world's leading provider of open source solutions
- [Open Source](https://opensource.com) : Open Source
- [Google Summer of Code](https://summerofcode.withgoogle.com) : Google Summer of Code is a global program focused on bringing more student developers into open source software development. Students work with an open-source organization on a 3-month programming project during their break from school.
- [Open Source Web Design](http://www.oswd.org) : Open Source Web Design is a platform for sharing standards-compliant free web design templates. We give web publishers a voice through good design.
- [Mozilla Winter of Security](https://wiki.mozilla.org/Security/Automation/Winter_Of_Security_2016) : The Winter of Security (MWOS) is a program organized by Mozilla's Security teams to involve students with Security projects. Students who have to perform a semester project as part of their university curriculum can apply to one of the MWOS projects.
- [Bit Bucket](https://bitbucket.org) : Like GitHub, BitBucket hosts both public and private projects. On this site, open-source projects and private projects with fewer than five users are free. It hosts more than 48,000 repositories, many of which are searchable on the site.
- [Media Wiki](https://www.mediawiki.org/wiki/MediaWiki) : MediaWiki is a free software open source wiki package written in PHP, originally for use on Wikipedia. It is now also used by several other projects of the non-profit Wikimedia Foundation and by many other wikis, including this website, the home of MediaWiki.
- [Code Curiosity](https://codecuriosity.org) : CodeCuriosity is a platform that encourages contributions to open source. Everyone is rewarded for their efforts, no matter how big or small they are.
- [Code Triage](https://www.codetriage.com) : Help out your favorite open-source projects and become a better developer while doing it.
- [Issue Hub](http://issuehub.io) : Contribute to Open Source. Search issue labels to find the right project for you
- [Up for Grabs](http://up-for-grabs.net) : This is a list of projects which have curated tasks specifically for new contributors. These are a great way to get started with a project or to help share the load of working on open source projects.
- [First Timers Only](http://www.firsttimersonly.com) : Contributing to open source for the first time can be scary and a little overwhelming. Perhaps you’re a Code Newbie or maybe you’ve been coding for a while but haven’t found a project you felt comfortable contributing to.
- [Your First PR](http://yourfirstpr.github.io) : Your First PR helps you get started contributing to Open Source by showcasing great starter issues on GitHub and elsewhere.
- [Awesome First PR Opportunities](https://github.com/mungell/awesome-for-beginners) : An awesome repository for finding beginner-friendly projects in different programming languages.
- [EddieHub Open source community](https://github.com/EddieHubCommunity) : A Supportive community for people who are interested or already contributing in Open source.
- [MLH Fellowship prgramme](https://fellowship.mlh.io/):A fully remote, 12-week internship alternative where participants earn a stipend and learn to collaborate on real open source projects with peers and engineers from top companies.

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 🌱 Internships
- [Chegg](http://www.chegg.com) : It is an awesome resource for finding internships, scholarships, tutors, etc.
- [Internshala](https://internshala.com) : You can search for internships here according to your skill sets for your interested location. It also helps you in getting a good PPO offer from the company.
- [Letsintern](https://www.letsintern.com) : Get a smart and challenging internship for you from the LetsIntern.
- [PerfectIntern](https://www.perfectintern.com): Get help finding a paid internship, resume prep, interview prep, and more!

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

## 💼 Jobs
- [Wellfound](https://wellfound.com/) : Wellfound (formerly known as Angellist) is a 
    website for startups, angel investors, and job-seekers 
    looking to work at startups. 
- [CareerBuilder](https://hiring.careerbuilder.com) : CareerBuilder is one of the largest job boards, providing job listings, resume posting, and career advice and resources to job seekers.
- [Dice](https://www.dice.com) : Dice is the leading site for tech job seekers.
    You can search by company, job title, keyword, employment type, and location.
- [Devsnap](https://devsnap.io) : Devsnap is a job aggregator for developer jobs. 
- [DevITjobs UK](https://devitjobs.uk/) : Transparent job board for UK based developers 
- [Glassdoor](https://www.glassdoor.co.in) : Find the job that's right for you.
    Search all the open positions on the web. Get your own personalized salary estimate.
- [IAESTE](http://iaesteunitedstates.org) : Find more and amazing international internships and jobs.
- [Indeed](https://www.indeed.com) : Find international jobs on Indeed and get a market salary for your dedication and devotion.
- [Instahyre](https://www.instahyre.com) : Your dream job is here. Showcase yourself to a curated list of top companies. Complete privacy and no spam.
- [JobsCollider](https://jobscollider.com/remote-jobs) : Tens of thousands of remote jobs from over 10,000 companies and startups worldwide.
- [Mentat](https://thementat.com) : Get your dream job 10x faster. Never apply for a job ever again, talk directly to decision-makers and hiring managers.
- [The Muse](https://www.themuse.com) : Find everything you need to succeed from dream jobs to career advice. You can do a lot here on The Muse like exploring companies, browsing jobs, career advice,  discover careers,  career coaching. Try it.
- [Paysa](https://www.paysa.com) : Paysa helps you in finding new and interesting jobs according to your wish.
- [SimplyHired](https://www.simplyhired.com) : Simply Hired is a free job search engine (and mobile app) that takes the hassle out of getting hired and provides you with all the information you need to make a sound career move.
- [SwissDev Jobs](https://swissdevjobs.ch) : Tech job board for Software Engineers that want to work in Switzerland.
- [Undercover Recruiter](https://theundercoverrecruiter.com) : Become Recruiter,
  Candidate or Employer. You can get your job easily here.
- [Who is Hiring](https://whoishiring.io) : An awesome resource for searching,
  filtering, and finding new and attractive jobs according to your needs and interests.
- [ZipRecruiter](https://www.ziprecruiter.com) : The Smartest Way to Get Hired.
- [RemoteML](https://remoteml.com/) : Remote Machine Learning jobs.
- [Linkedin jobs](https://www.linkedin.com/jobs) : A very nice research tool for programming jobs
- [GermanTech Jobs](https://germantechjobs.de/) : Dedicated job board for tech roles in Germany - with salary brackets
- [We Work Remotely](https://weworkremotely.com/) : The largest remote work community in the world.
- [OkJob](https://okjob.io/) : 4 day week job board.

<div align="right">
  <b><a href="#index">↥ Back To Top</a></b>
</div>

### 🌟 Special Thanks
- Please consider a GitHub star if you find this useful and/or consider contributing.
- A special thanks to Ashish Padalkar (@ashish2199) for contributing a great amount of data and structure to the initial repository [Original Post](https://www.quora.com/How-to-Create-a-Blog-2/answer/Ashish-Padalkar?srid=OH96).
