# Contributing Guidelines

For contributions to be approved they should come in through Pull Requests (PR) that correspond to changes in the `README.md` file.

Each PR MUST respect the following guidelines:

- **Only one link** per PR is allowed.
- Verify that the link is not already in the list.
- The link can't correspond to a _YouTube channel or playlist_. These can vary over time and become difficult to review.
- You should add the link in the `README.md` file using this pattern:

  ```text
  [Site name OR A simple description](url) : a simple description of the site or slogan of the site.
  ```

- You should add the link to the right section. No new sections are allowed at the moment.
- You should also consider sorting your submission alphabetically whenever possible.

If your contribution corresponds to something different (not a new link to add) from a new link, please create an [issue](./issues) before to support the case.

Any Pull Request MUST adhere to the [Contributor Covenant Code of Conduct](./CODE_OF_CONDUCT.md).
