# Contributing Guidelines

[Scio Labs](https://scio.xyz) actively welcomes contributions from anyone to make this a community-driven effort. There are many ways to contribute, from writing tutorials or blog posts, improving the documentation, submitting bug reports and feature requests, or writing code.

Our ink! developer tooling initiative is made up of the following projects:

- `create-ink-app` CLI (_Coming soon_)
- [`ink!athon`](https://github.com/scio-labs/inkathon) Boilerplate
- [`useInkathon`](https://github.com/scio-labs/use-inkathon) Hooks & Utility Library
- [`zink!`](https://github.com/scio-labs/zink) Smart Contract Macros

_To ensure a smooth and efficient collaboration, please follow the guidelines below._

## Issues

- Before starting work, please check the existing issues for your planned feature or bug fix.
- If there isn't an existing issue, create one. This allows us to avoid duplicate work and discuss the implementation details upfront.
- If you want to work on an issue, please comment on it to let us know. This helps us keep track of who is working on what.

## Pull Requests

- All changes should be made through pull requests (PRs).
- Please ensure your PR is linked to the relevant issue.
- Include a clear and detailed description of the changes in your PR.
- Request a review once your PR is ready.

## Code Style

- Please follow the existing coding style.
- Make sure your changes pass the lint checks.

> [!IMPORTANT]
>
> - Please install all recommended VSCode extensions (see `.vscode/extensions.json`).
> - After installing dependencies, enable the `pre-commit` hook in your local repository via `pnpm simple-git-hooks`.
> - Make sure to always use the `inkathon.code-workspace` file when working on the project in VSCode.

## Communication

- Be respectful and considerate in all interactions.
- If you have questions or need help, don't hesitate to ask.
- For code, feature, or bug discussions, please use the relevant GitHub issue or PR.
- To chat with us or ask questions, join our [Telegram Group](https://t.me/inkathon). 💬

Thanks for your contributions! 🙏
