@extends('home.layout')

@section('content')

    <div class="container pt-4 mb-2" style="margin-top: 100px">
        <div class="mb-5">
            <div class="row">
                <div class="col-12 mx-auto mb-3 text-center">
                    <h1>PRIVACY POLICY</h1>
                </div>
            </div>
            <div class="row">
                <div class="col mx-auto">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col">
                                The present Privacy policy applies to all Users of the Platform (hereinafter referred to
                                as the <b>“Users”</b> or the <b>“User”</b> and <b>“Platform”</b> respectively) and forms
                                an integral part of the Platform's Website Terms and Conditions. The present Privacy
                                Policy provides the
                                User with general information regarding how the Data Controller uses your personal data
                                and other information required by data protection legislation. In case of future
                                amendment, the User will be provided with necessary updates and information through the
                                update of the present Privacy Policy, uploaded in the Platform.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">1. Who is the Data Controller?</h2>
                            </div>
                            <div class="col-12">
                                <b>1.1.</b> The Company with the company name “{{ config("app.installation_company_name") }}”, address:
                                {{ config("app.installation_company_address") }} ,
                                Telephone: {{ config("app.installation_company_phone") }}, email: {{ config("app.installation_company_email") }}, is the Data Controller for the processing of the User’s Personal
                                Data (herein after referred to as <b>"Data Controller"</b>).
                                <br><br>
                                <b>1.2. Data Controller's Contact details:</b> For any issue or concern with regards to
                                the present Privacy Policy and to the processing of User's personal data or data
                                uploaded by the User to use the Platform, the User can communicate with the
                                Data Controller, by using one of the following alternatives:
                                <br><br>
                                {{ config("app.installation_company_name") }}<br>
                                {{ config("app.installation_company_address") }}
                                {{ config("app.installation_company_email") }}<br>
                                {{ config("app.installation_company_phone") }}<br>
                                <br>

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">2. What is the purpose and the legal basis for User’s data processing?</h2>
                                <b>2.1.</b> Platform's operational purpose is to collect opinions of users via questionnaires. The opinions are processed in order to gain insights, gather and present valuable ideas and suggestions on the topics addressed in the questionnaires.
                                Users can respond anonymously (without providing any personal information) or can
                                voluntarily register
                                in order to submit eponymous answers.
                                User's answers are translated into English and are presented in Reports.
                                For the specific purpose of processing, the legal basis is User's prior consent.
                                <br><br>
                                <b>2.2.</b> To send User informative emails with the purpose to inform him about
                                new activities, projects and other issues of interest of the Platform. For this purpose
                                of processing the legal basis is the User's prior consent.
                                <br><br>
                                <b>2.3</b> Processing of data for reasons related to Data Controller's compliance with
                                legal obligations. In such cases processing of data takes place for only the necessary time period in order for Data Controller to comply with obligations imposed by various legal provisions.
                                <br><br>
                                <b>In case of the above provisions where the legal basis is User's prior consent, the
                                    User can always withdraw his consent at any time without affecting the legitimacy of
                                    the
                                    data based on consent prior to its withdrawal.</b>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">3. Types of data collected</h2>

                                <h3 class="mt-4 mb-4">3.1 Personal data</h3>
                                <b>3.1.1 Registration- account creation:</b><br>
                                In order for a User to voluntarily create an account in the Platform, the User should
                                fill in the necessary data: his nickname, email address, and password
                                <br><br>
                                <b>3.1.2 Submitted questionnaire responses</b><br>
                                The Platform collects user answers (that is opinions on various subjects) on questions
                                made via Platform's questionnaires.
                                These answers are analyzed and presented in a questionnaire results page.
                                The User is strictly advised to conform the platform's "code of conduct for successful
                                participation" and avoid
                                posting publicly any personal data that do not wish to be publicly available on the
                                Platform.
                                <br><br>
                                <b>3.1.3. Platform's communication for reasons related to User's permitted use of the
                                    Platform.</b>
                                <br>
                                In order for the Platform to communicate with the User for the above purposes, Data
                                Controller can process all data relating to User's account, uploaded content and data
                                related to the User's use of the Platform.

                                <h3 class="mt-4 mb-4">3.2 Usage data</h3>
                                We may also collect information how the webpage is accessed and used ("Usage Data").
                                This Usage Data may include information such as your computer's Internet Protocol address (e.g. IP address),
                                browser type, browser version, the pages of our webpage that you visit, the time and date of your visit,
                                the time spent on those pages, unique device identifiers and other diagnostic data.


                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4"> 4. How the Platform collects data</h2>
                                4.1 The information can be collected by the following ways: <br>
                                4.1.1 When the User registers and creates an account on the Platform. <br>
                                4.1.2 When the User submits answer's on the Platform's questionnaires <br>
                                4.1.3 When the User visits the Platform and agrees to the installation of cookies (as
                                per the Platform's Cookie Policy in article 11 below) and the collection of the User’s
                                personal data such as the IP address, operation system, type and browser edition
                                etc.
                                <br>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">5. How long are User's data stored and when are they deleted?</h2>
                                <b>5.1. User's account data:</b><br>
                                Without prejudice to User's deletion/erasure right mentioned below, the Data registered
                                and stored in the User's account will be stored as long as the User wishes to make use
                                of the Platform for the purpose mentioned above. In
                                case a User wishes to delete his account, he can delete his account through account's
                                settings or contact Data Controller at the above mentioned contact details.
                                <br><br>
                                <b>5.2. Platform's communication for reasons related to User's permitted use of the
                                    Platform.</b><br>
                                Data related to such communication will be stored only as long as the User wishes to use
                                the Platform and maintains his account. In case a User wishes to delete his account he
                                can delete his account through account's settings or contact Data Controller at the
                                above mentioned contact details.
                                <br><br>
                                <b>5.3. Statistical analysis for the optimization of the Website</b><br>
                                Regardless of the above mentioned provisions of article 5, Data Controller will store
                                and process only necessary data for the period required in order to comply with its
                                obligations imposed by law each time (compliance with fiscal obligations etc).
                                <br><br>
                                <b>5.4. Processing of personal data for the purposes of conducting statistical
                                    analysis.</b><br>
                                Please see cookies policy (article 11 ) below.
                                <br><br>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">6. What are User's rights ιn relation to the processing of his data and how can he exercise these rights?</h2>
                                <b>6.1</b> The Data Controller respects User's right in relation to data processing.
                                <br><br>
                                <b>6.2</b> The User can exercise his rights by contacting the Data Controller at the
                                following contact details: Telephone: {{ config("app.installation_company_phone") }}, email: {{ config("app.installation_company_email") }}
                                <br><br>
                                For User's facilitation, User's rights are included in the following table along with a
                                short explanation of each right (reference to articles corresponds to article of GDPR
                                2016/679):
                                <br><br>
                                <table class="table table-striped table-responsive table-bordered">
                                    <tr>
                                        <th>Right</th>
                                        <th>Explanation</th>
                                    </tr>
                                    <tr>
                                        <td>Access (article 15)</td>
                                        <td>
                                            The User can ask the Data Controller to:
                                            <ul>
                                                <li>confirm whether the Data Controller processes User's personal data
                                                </li>
                                                <li>give the User access to data that the User does not dispose</li>
                                                <li>give the User other information related to User's personal data such
                                                    as which are the data that the Data Controller disposes, what are
                                                    the purposes of processing, to whom are these data disclosed,
                                                    whether these data are transferred in foreign countries and how are
                                                    these data protected, how long are the data stored, what are the
                                                    User's rights, how can a complaint be lodged, where were the data
                                                    taken from to the extent this information is not included in the
                                                    present Privacy Policy.
                                                </li>
                                            </ul>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Rectification (article 16)</td>
                                        <td>
                                            The User can ask the Data Controller to rectify inaccurate personal
                                            data.<br><br>
                                            The Data Controller can seek to verify the accuracy of the data before
                                            rectifying them.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Erasure/deletion (article17)</td>
                                        <td>
                                            The User can ask the Data Controller to erase his personal data:<br><br>
                                            <ul>
                                                <li>whenever, when the personal data are no longer needed for the
                                                    purposes for
                                                    which they were collected
                                                </li>
                                                <li>when the User withdraws his consent</li>
                                                <li>the personal data have been unlawfully processed</li>
                                            </ul>
                                            <br><br>
                                            The Data Controller is not obliged to comply with User's request to erase
                                            his personal data, if the processing of User's personal data is necessary:
                                            <ul>
                                                <li>for compliance with a legal obligation</li>
                                                <li>for the fulfillment of another legitimate purpose or another
                                                    legitimate
                                                    legal basis
                                                </li>
                                                <li>for the establishment, exercise or defense of legal claims</li>
                                            </ul>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Restriction (article 18)</td>
                                        <td>

                                            The User can ask the Data Controller to restrict (store but not process)
                                            User's personal data when:<br><br>
                                            their accuracy is contested (see rectification), so that the Data Controller
                                            can verify the accuracy of the personal data or<br><br>
                                            the personal data have been unlawfully processed but the User opposes the
                                            erasure of the personal data or<br><br>
                                            they are no longer necessary for the purposes for which they were collected
                                            but the User still needs them for the establishment, exercise or defense of
                                            legal claims or there is another legitimate purpose of processing or other
                                            legal basis
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Data portability (article 20)
                                        </td>
                                        <td>
                                            When processing is based on consent and the processing is carried out by
                                            automated means, the User can ask the Data Controller to receive his
                                            personal data in a structured commonly used and machine readable format or
                                            ask the Data Controller to transmit them to another controller directly from
                                            the Data Controller. Nevertheless, according to the law, this right refers
                                            only to those data that have been given by the User himself and not to those
                                            data that are inferred by the Data Controller based on the data that the
                                            User has provided.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Objection (article 21)</td>
                                        <td>
                                            The User can object at any time to the processing of personal data
                                            concerning him or her which is based on legitimate interest or performance
                                            of a task carried out in the public interest.<br><br>
                                            When the User exercises his right to object, the Data Controller has the
                                            right to demonstrate that compelling legitimate grounds for the processing
                                            that override the interest, rights and freedom of the User or for the
                                            establishment, exercise or defense of legal claims.

                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Consent withdrawal (opt-out)
                                        </td>
                                        <td>
                                            The User has the right to withdraw his consent where consent is the basis of
                                            processing. Withdrawal is valid for the future.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Supervisory Authority
                                        </td>
                                        <td>
                                            The User has the right to lodge a complaint with the local supervisory
                                            authority related to data protection. <br><br>
                                            In Greece the supervisory authority for Data Protection is Data Protection
                                            Authority https://www.dpa.gr/

                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Identity</td>
                                        <td>The Data Controller takes seriously the confidentiality of all files that
                                            include personal data, thus he is entitled to ask the User proof of his
                                            identity if the User submits a request in relation to those files.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Cost</td>
                                        <td>The User will not have to pay for the exercise of his rights in relation to
                                            personal data unless as provided by law, the request to acquire access to
                                            information is unfounded or excessive. In that case the Data Controller can
                                            charge the User with a reasonable fee under the specific circumstances. The
                                            Data Controller will inform the User for any possible charge before he
                                            completes the request.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Timetable</td>
                                        <td>Data Controller aims at answering at User's valid requests the latest within
                                            one (1) month from their receipt, unless the request is extremely
                                            complicated or the User has submitted multiple requests, in which case the
                                            Data Controller aims at answering to them within three months. In case the
                                            Data Controller needs more than one month for the reasons above mentioned,
                                            he will inform the User. The Data Controller may ask the User if he wants to
                                            explain what exactly he wishes to receive or what is his concern. This will
                                            help Data Controller to act more quickly in relation to User's request. In
                                            any case the User should mention specific and true data and/or facts so that
                                            the Data Controller can answer and/or satisfy accurately to User's request.
                                            Otherwise, the Data Controller reserves his right for any faults that are
                                            outside of his control. Additionally the Data Controller can reject requests
                                            that are unfounded, excessive, abusive, made in bad faith or are
                                            illegitimate in the framework of the legal provisions.
                                        </td>
                                    </tr>
                                </table>

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">7.How is data security safeguarded?</h2>
                                <b>7.1</b> The Data Controller implements all appropriate security measures to ensure
                                protection and confidentiality of personal data among which the following are included:
                                <br>
                                <ol>
                                    <li>Strong password policies in all servers</li>
                                    <li>HTTPS protocol for interacting with APIs and Web clients</li>
                                    <li>SSH protocol for server connection</li>
                                    <li>Periodical server updates with latest security fixes</li>
                                </ol>

                                <br><br>
                                <b>7.2</b> Please note that only specifically authorized employees of the Data
                                Controller, acting under the authority of the Data Controller and only on his
                                instructions as well as recipients, where necessary, handle the data submitted by the
                                User. For the processing, the Data Controller chooses persons with appropriate
                                qualifications that have sufficient safeguards as to technical knowledge and personal
                                integrity to protect confidentiality. The Data Controller takes all necessary security
                                measures for the protection and safeguard of secrecy, confidentiality and integrity of
                                personal data also through relevant contractual commitments of his associates. In any
                                case the security of the Website may be infringed due to reasons that reside outside of
                                the Data Controller control sphere as well as due to technical or other problem of the
                                net or force majeure or accidental facts. In that case, the security of personal data
                                cannot be guaranteed.

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">8. Who are the recipients of data?</h2>
                                <b>8.1</b> The recipients of User's personal data are associate companies that provide
                                technical infrastructure for the operation of the Website, hosting provider as well as
                                the company that undertakes to send electronic communication related to the operation of
                                the Platform to Users. Where necessary as per applicable laws, the Data Controller will sign agreements with such
                                companies, which refer to the implementation and regular monitoring of security
                                measures. In case data are transferred outside ΕU all necessary guarantees are in place.
                                <br><br>
                                <b>8.2.</b> In case the Data Controller receives a request to notify or transfer data
                                following a request by the appropriate Administrative Authority, Attorney, Court or
                                other Authority, he may notify / transfer those data in order to fulfill his duty
                                executed in favor of the public interest towards these authorities (with or without
                                User's previous notification) in accordance with the appropriate legal provisions. If
                                the User should be previously notified in accordance with the legal provisions, then the
                                User has the right to object to this processing as provided in article 7 above.

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">9. Communication with the Data Controller</h2>
                                <b>9.1.</b> For any issue related to the present privacy policy, User's data processing
                                as
                                well as exercise of User's rights, the User can contact the Data Controller using one of
                                the following ways: <br>
                                Telephone: +32 (0) 2 548 04 90, <br>
                                Email: info@ecas.org
                                <br><br>
                                In case the User becomes aware of any data breach incident, he is kindly requested to
                                notify the Data Controller immediately.
                                <br><br>
                                <b>9.2.</b> The present terms are governed and supplemented by the Terms and Conditions
                                and consist along with them a uniform text.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">10. Connection to other Websites/social media</h2>
                                This Website connects with other websites through hyperlinks. These websites are not
                                related to Data Controller's Website and their content is neither checked nor
                                recommended by the Data Controller. Thus, the accuracy, legitimacy, completeness or
                                quality of their content and legitimacy of the processing of User’s personal data cannot
                                be checked and no guarantee is provided for them. The Data Controller cannot be held
                                liable for them or any damage that may be caused to the User due to or following their
                                use. The Data Controller cannot check the processing of the User's personal data by
                                those linked Websites and thus does not bear any liability. When the User accesses those
                                websites he should take under consideration that terms and conditions of each website
                                apply. For any issue that may occur as to the content or the use of the linked website,
                                the User should directly contact the operator or administrator of each website. The Data
                                Controller does not approve or embrace the Content or the services of the linked
                                websites, which the User accesses through the Website.<br><br>
                                The Website gives the User the possibility to connect and interact with social media
                                following his own initiative and will. In that case the Data Controller is not liable
                                for the processing of User's data taking place through or by the social media. The User
                                should directly address each specific social media in order to exercise his legitimate
                                rights.


                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">11. Cookies</h2>
                                11.1. The Platform uses cookies to be operational or more efficient in its operation, to
                                improve User's navigation, to provide User with the full potential of the Platform, to
                                ensure the correct display of the content as well as for analytical and statistical
                                purposes.
                                <br><br>
                                11.2. Cookies are small text files stored on User's computer when he visits a digital
                                platform, which are used as a means of identifying his computer.
                                <br><br>
                                11.3. Cookies apart from absolutely necessary cookies are only installed if the User
                                accepts their installation when he visits this Platform. By accepting cookies when
                                entering this Platform, the User expressly states that he has read and understood the
                                specific terms and conditions regarding the installation, function and purpose of the
                                cookies and that he provides his consent for their use.
                                <br><br>
                                11.4. Alternatively, the User may not accept cookies. In this case, only cookies that
                                are technically and functionally necessary for the operation of the Platform will be
                                installed.
                                <br><br>
                                11.5. The User can manage the use and installation of cookies at any time through a
                                panel, where he can choose which category of cookies he wants to accept and which ones
                                not (or request to install only the technically necessary cookies).
                                <br><br>
                                11.6. In particular, the cookies used by the Platform are the following:
                                <br><br>

                                <table class="table table-striped table-responsive table-bordered">
                                    <tr>
                                        <th>Type of cookies</th>
                                        <th>Explanation</th>
                                        <th>Examples of cookies</th>
                                        <th>Duration of each cookie installation</th>
                                        <th>Transfer of data to third parties</th>
                                    </tr>
                                    <tr>
                                        <td>Absolutely necessary Cookies</td>
                                        <td>The absolutely necessary cookies are essential for the proper operation of
                                            the Platform. These cookies allow User to browse and use Platform features
                                            such as access to secure areas. These cookies do not recognize User's
                                            individual identity and without them, the smooth operation of the Platform
                                            is not possible.
                                        </td>
                                        <td>CookieConsent (Stores the user's cookie consent state for the current domain
                                            )
                                            <br><br>
                                            XSRF-TOKEN (Ensures visitor browsing-security by preventing cross-site
                                            request forgery. This cookie is essential for the security of the website
                                            and visitor. )
                                            <br><br>
                                            ecas_lets_crowdsource_our_future_session (When the app needs to “remember” the logged in user while (s)he navigates to the Platform)

                                            <br><br>
                                            Crowdsourcing_anonymous_user_id (used to store anonymous answers on the questionnaires by assigning an integer number to user that is submitting the response)

                                        </td>
                                        <td>1 year
                                            <br><br>
                                            <br><br>
                                            1 day
                                            <br><br>
                                            <br><br>
                                            Session
                                            <br><br>
                                            <br><br>
                                            5 years
                                        </td>
                                        <td>No
                                            <br><br>
                                            <br><br>

                                            No
                                            <br><br>
                                            <br><br>

                                            No
                                            <br><br>
                                            <br><br>

                                            No
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Statistics/analytical Cookies</td>
                                        <td>These are cookies that evaluate the way visitors use the Platform (for
                                            example, which pages are visited more often and whether they receive error
                                            messages from webpages). These cookies are used for statistical purposes and
                                            to improve the performance of a Platform.
                                        </td>
                                        <td>_ga_4S9N5MK4VE, _gat,_ga, _gcl_au, _gid: Google Analytics cookies are used to measure traffic on the Platform.
                                            A unique textstring is saved to identify browser, timestamp for interactions and the browser/sourcepage that led the user to the Platform.
                                            No sensitive information is saved.

                                        </td>
                                        <td>_ga_4S9N5MK4VE: 2 years
                                            <br><br>
                                            _gat:1 minute
                                            <br><br>
                                            _ga:2 years
                                            <br><br>
                                            _gcl_au:3 months
                                            <br><br>
                                            _gid:24 hours
                                        </td>
                                        <td>Yes (Company that provides statistical and analytical services if considered
                                            as third party)
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">12. Children's Privacy  </h2>
                                Our project does not address anyone under the age of 18 ("Children").
                                We do not knowingly collect personally identifiable information from anyone under the age of 18.
                                If you are a parent or guardian and you are aware that your Children has provided us with Personal Data, please contact us.
                                If we become aware that we have collected Personal Data from children without verification of parental consent,
                                we take steps to remove that information from our servers.


                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">13. Amendments to this Privacy Policy </h2>
                                The Data Controller reserves the right to amend this present Privacy Policy, for example
                                when this is necessary to comply with new requirements imposed by applicable laws,
                                guidelines or technical requirements, or in the course of a revision of the Data
                                Controller's processes and practices. The User will be notified of any amendment to this
                                Privacy Policy through the Platform. The User should regularly check this Privacy Policy
                                for any amendments.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
