@extends('home.layout')

@section('content')

    <div class="container pt-4 mb-2" style="margin-top: 100px">
        <div class="mb-5">
            <div class="row">
                <div class="col-12 mx-auto mb-3 text-center">
                    <h1>POLITIKA PRIVATNOSTI</h1>
                </div>
            </div>
            <div class="row">
                <div class="col mx-auto">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col">
                                Ova Politika privatnosti primjenjuje se na sve korisnike Platforme (u daljem tekstu <b>“Korisnici”</b> ili <b>“Korisnik”</b> i <b>“Platforma”</b>) i čini sastavni dio Uslova i odredbi veb sajta Platforme. Ova Politika privatnosti pruža Korisniku opšte informacije o tome kako Kontrolor podataka koristi Vaše lične podatke i druge informacije koje se zahtijevaju zakonodavstvom o zaštiti podataka. U slučaju budućih izmjena, Korisnik će dobiti neophodna ažuriranja i informacije vezane za ažuriranje ove Politike privatnosti, postavljene na Platformi.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">1. Ko je kontrolor podataka?</h2>
                            </div>
                            <div class="col-12">
                                <b>1.1.</b> Kompanija pod nazivom „{{ config("app.installation_company_name") }}“, adresa: {{ config("app.installation_company_address") }}, telefon: {{ config("app.installation_company_phone") }}, email: {{ config("app.installation_company_email") }}, je Kontrolor podataka za obradu ličnih podataka korisnika (u daljem tekstu <b>"Kontrolor podataka"</b>).
                                <br><br>
                                <b>1.2. Kontakt podaci Kontrolora podataka:</b> Za bilo koje pitanje ili zabrinutost u vezi sa ovom Politikom privatnosti i obradom ličnih podataka Korisnika ili podataka koje je Korisnik postavio pri korišćenju Platforme, Korisnik može da komunicira sa Kontrolorom podataka, koristeći jednu od sljedećih opcija:
                                <br><br>
                                Pozivom na broj {{ config("app.installation_company_phone") }}, od ponedjeljka do petka od 10.00 do 18.00 po IEV (istočno-evropsko vrijeme)<br>
                                Slanjem mejla na sljedeću email adresu: {{ config("app.installation_company_email") }}<br>
                                Slanjem korespondencije na sljedeću adresu: {{ config("app.installation_company_address") }}<br>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">2. Koja je svrha i pravni osnov za obradu podataka korisnika?</h2>
                                <b>2.1.</b> Operativna svrha platforme je prikupljanje mišljenja korisnika putem upitnika. Mišljenja se obrađuju u cilju dobijanja uvida, prikupljanja i prezentovanja vrijednih ideja i sugestija o temama obrađenim u upitnicima. Korisnici mogu da odgovaraju anonimno (bez davanja bilo kakvih ličnih podataka) ili se mogu dobrovoljno registrovati kako bi dostavili iste odgovore, davanjem emaila i nickname-a. Odgovori korisnika se prevode na engleski jezik i predstavljeni su u izvještajima. Za konkretnu svrhu obrade, pravni osnov je prethodna saglasnost Korisnika.
                                <br><br>
                                <b>2.2.</b> Da bi se slali Korisniku informativni mejlovi s ciljem da se obavijesti o novim aktivnostima, projektima i drugim pitanjima od interesa za Platformu. Za ovu svrhu obrade, pravni osnov je prethodna saglasnost Korisnika.
                                <br><br>
                                <b>2.3</b> Obrada podataka iz razloga koji se odnose na poštovanje zakonskih obaveza od strane Kontrolora podataka. U takvim slučajevima, obrada podataka se odvija samo u periodu potrebnom da bi Kontrolor podataka ispunio obaveze koje nameću različite zakonske odredbe.
                                <br><br>
                                <b>U slučaju gorenavedenih odredbi gde je pravni osnov prethodna saglasnost Korisnika, Korisnik uvijek može da povuče svoju saglasnost u bilo kom trenutku bez uticaja na legitimnost podataka zasnovanih na saglasnosti prije njenog povlačenja.</b>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">3. Vrste prikupljenih podataka</h2>

                                <h3 class="mt-4 mb-4">3.1 Lični podaci</h3>
                                <b>3.1.1 Registracija – kreiranje naloga:</b><br>
                                Da bi Korisnik dobrovoljno kreirao nalog na Platformi, treba da popuni neophodne podatke: svoj nickname, email adresu i lozinku.
                                <br><br>
                                <b>3.1.2 Dostavljeni odgovori na upitnik</b><br>
                                Platforma prikuplja odgovore korisnika (odnosno mišljenja o različitim temama) na pitanja postavljena putem upitnika Platforme. Ovi odgovori se analiziraju i predstavljaju na stranici sa rezultatima upitnika. Korisniku se striktno savjetuje da se pridržava „kodeksa ponašanja za uspješno učešće“ Platforme i izbjegava javno objavljivanje ličnih podataka za koje ne želi da budu javno dostupni na Platformi.
                                <br><br>
                                <b>3.1.3. Komunikacija Platforme radi Korisnikovog dozvoljenog korišćenja Platforme</b>
                                <br>
                                Da bi Platforma komunicirala sa Korisnikom u gorenavedene svrhe, Kontrolor podataka može obraditi sve podatke koji se odnose na nalog Korisnika, unijeti sadržaj i podatke koji se odnose na korišćenje Platforme od strane Korisnika.

                                <h3 class="mt-4 mb-4">3.2 Korišćenje podataka</h3>
                                Takođe možemo da prikupljamo informacije o tome kako se pristupa veb stranici i kako se koristi („Podaci o korišćenju“). Ovi podaci o korišćenju mogu uključivati informacije kao što su adresa internet protokola vašeg računara (npr. IP adresa), tip pretraživača, verzija pretraživača, stranice našeg veb sajta koje posjećujete, vrijeme i datum vaše posjete, vrijeme provedeno na tim stranicama, jedinstvene identifikatore uređaja i druge dijagnostičke podatke.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4"> 4. Kako Platforma prikuplja podatke</h2>
                                4.1 Informacije se mogu prikupljati na sljedeće načine: <br>
                                4.1.1 Kada se Korisnik registruje i kreira nalog na Platformi. <br>
                                4.1.2 Kada Korisnik dostavlja odgovore na upitnike Platforme. <br>
                                4.1.3 Kada Korisnik posjeti Platformu i pristane na instalaciju kolačića (u skladu sa Politikom o kolačićima Platforme u članu 11 u nastavku) i prikupljanje ličnih podataka Korisnika kao što su IP adresa, operativni sistem, tip i izdanje pretraživača itd.
                                <br>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">5. Koliko dugo se čuvaju podaci Korisnika i kada se brišu?</h2>
                                <b>5.1. Podaci o korisničkom nalogu:</b><br>
                                Ne dovodeći u pitanje pravo Korisnika na brisanje pomenuto ispod, podaci registrovani i uskladišteni na korisničkom nalogu biće stornirani sve dok Korisnik želi da koristi Platformu u gorenavedenu svrhu. U slučaju da Korisnik želi da izbriše svoj nalog, to može uraditi preko podešavanja naloga ili kontaktiranjem Kontrolora podataka na gorenavedene kontakt podatke.
                                <br><br>
                                <b>5.2. Komunikacija Platforme zbog Korisnikovog dozvoljenog korišćenja Platforme.</b><br>
                                Podaci koji se odnose na ovu komunikaciju će se čuvati sve dok Korisnik želi da koristi Platformu i zadrži svoj nalog. U slučaju da Korisnik želi da izbriše svoj nalog, to može da uraditi preko podešavanja naloga ili kontaktiranjem Kontrolora podataka na gorenavedene kontakt podatke.
                                <br><br>
                                <b>5.3. Statistička analiza za optimizaciju veb stranice</b><br>
                                Bez obzira na gorenavedene odredbe člana 5, Kontrolor podataka će čuvati i obrađivati samo neophodne podatke u potrebnom periodu kako bi svaki put ispunio svoje obaveze koje nameće zakon (usklađenost sa fiskalnim obavezama itd.).
                                <br><br>
                                <b>5.4. Obrada ličnih podataka za potrebe sprovođenja statističke analize.</b><br>
                                Molimo pogledajte politiku kolačića (član 11) ispod.
                                <br><br>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">6. Koja su prava korisnika u vezi sa obradom njegovih podataka i kako može da ostvari ta prava?</h2>
                                <b>6.1</b> Kontrolor podataka poštuje prava Korisnika u vezi sa obradom podataka.
                                <br><br>
                                <b>6.2</b> Korisnik može ostvariti svoja prava kontaktiranjem Kontrolora podataka koristeći sljedeće kontakt podatke: Telefon: {{ config("app.installation_company_phone") }}, email: {{ config("app.installation_company_email") }}
                                <br><br>
                                Radi olakšavanja Korisniku, prava Korisnika su uključena u sljedeću tabelu zajedno sa kratkim objašnjenjem svakog prava (referenca na članove odgovara članu GDPR 2016/679):
                                <br><br>
                                <table class="table table-striped table-responsive table-bordered">
                                    <tr>
                                        <th>Pravo</th>
                                        <th>Objašnjenje</th>
                                    </tr>
                                    <tr>
                                        <td>Pristup (član 15)</td>
                                        <td>
                                            Korisnik može tražiti od Kontrola podataka da:
                                            <ul>
                                                <li>potvrdi da li Kontrolor podataka obrađuje lične podatke Korisnika
                                                </li>
                                                <li>omogući Korisniku pristup podacima kojima Korisnik ne raspolaže</li>
                                                <li>pruži Korisniku druge informacije vezane za lične podatke Korisnika kao na primjer koji su to podaci kojima raspolaže Kontrolor podataka, koje su svrhe obrade, kome se ovi podaci otkrivaju, da li se ovi podaci prenose u inostrane države i kako su ovi podaci zaštićeni, koliko dugo se podaci čuvaju, koja su prava Korisnika, kako se može uložiti žalba, odakle su podaci uzeti ako ti podaci nisu uključeni u ovu Politiku privatnosti.
                                                </li>
                                            </ul>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Ispravljanje grešaka (član 16)</td>
                                        <td>
                                            Korisnik može zatražiti od Kontrolora podataka da ispravi netačne lične podatke.<br><br>
                                            Kontrolor podataka može tražiti da provjeri tačnost podataka prije nego što ih ispravi.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Brisanje (član 17)</td>
                                        <td>
                                            Korisnik može zatražiti od Kontrolora podataka da izbriše njegove lične podatke:<br><br>
                                            <ul>
                                                <li>kad god, kada lični podaci više nisu potrebni za svrhe za koje su prikupljeni
                                                </li>
                                                <li>kada Korisnik povuče svoju saglasnost</li>
                                                <li>kada su lični podaci nezakonito obrađeni</li>
                                            </ul>
                                            <br><br>
                                            Kontrolor podataka nije dužan da postupi po zahtjevu Korisnika za brisanje njegovih ličnih podataka, ako je obrada ličnih podataka Korisnika neophodna:
                                            <ul>
                                                <li>radi poštovanja zakonske obaveze</li>
                                                <li>radi ispunjenja druge zakonske svrhe ili drugog legitimnog pravnog osnova
                                                </li>
                                                <li>radi utvrđivanja, ostvarivanja ili odbrane pravnih potraživanja</li>
                                            </ul>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Ograničenje (član 18)</td>
                                        <td>
                                            Korisnik može zatražiti od Kontrolora podataka da ograniči (čuva, ali ne i obrađuje) lične podatke Korisnika u sljedećim slučajevima:<br><br>
                                            njihova tačnost je osporena (pogledajte ispravljanje grešaka), tako da bi Kontrolor podataka mogao provjeriti tačnost ličnih podataka ili<br><br>
                                            lični podaci su nezakonito obrađeni, ali se Korisnik protivi brisanju ličnih podataka ili<br><br>
                                            više nisu potrebni za svrhe za koje su prikupljeni, ali su Korisniku i dalje potrebni za uspostavljanje, ostvarivanje ili odbranu pravnih potraživanja ili postoji druga zakonska svrha obrade ili drugi pravni osnov
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Prenosivost podataka (član 20)
                                        </td>
                                        <td>
                                            Kada se obrada zasniva na pristanku i vrši se automatizovanim sredstvima, Korisnik može da zatraži od Kontrolora podataka da dobije svoje lične podatke u uobičajeno korišćenoj strukturi i mašinski čitljivom formatu ili da zatraži od Kontrolora podataka da ih prenese drugom kontroloru direktno od Kontrolora podataka. U svakom slučaju, prema zakonu, ovo pravo se odnosi samo na one podatke koje je dao sam Korisnik, a ne na one podatke o kojima je Kontrolor podataka izveo zaključak na osnovu podataka koje je Korisnik pružio.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Odbijanje (član 21)</td>
                                        <td>
                                            Korisnik može u bilo kom trenutku uložiti prigovor na obradu ličnih podataka koji se odnose na njega ili nju, a koja je zasnovana na legitimnom interesu ili obavljanju zadatka koji se obavlja u javnom interesu.<br><br>
                                            Kada Korisnik iskoristi svoje pravo na prigovor, Kontrolor podataka ima pravo da dokaže da su ubjedljive legitimne osnove za obradu koje imaju prednost nad interesima, pravima i slobodama Korisnika ili za uspostavljanje, ostvarivanje ili odbranu pravnih zahtjeva.

                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Povlačenje saglasnosti (odustajanje)
                                        </td>
                                        <td>
                                            Korisnik ima pravo da povuče svoju saglasnost kada je saglasnost osnova za obradu. Povlačenje je važeće za budućnost.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Nadzorni organ
                                        </td>
                                        <td>
                                            Korisnik ima pravo da podnese prigovor lokalnom nadzornom organu u vezi sa zaštitom podataka. <br><br>
                                            U Grčkoj je nadzorni organ za zaštitu podataka Organ za zaštitu podataka https://www.dpa.gr/

                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Identitet</td>
                                        <td>Kontrolor podataka ozbiljno shvata povjerljivost svih fajlova koji sadrže lične podatke, tako da ima pravo da od Korisnika zatraži dokaz o njegovom identitetu ukoliko Korisnik podnese zahtjev u vezi sa tim fajlovima.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Troškovi</td>
                                        <td>Korisnik neće morati da plaća za ostvarivanje svojih prava u vezi sa ličnim podacima, osim ako je, kako je to predviđeno zakonom, zahtjev za pristup informacijama neosnovan ili suvišan. U tom slučaju, Kontrolor podataka može naplatiti Korisniku razumnu naknadu pod određenim okolnostima. Kontrolor podataka će obavijestiti Korisnika o svim mogućim troškovima prije nego što ispuni zahtjev.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Raspored</td>
                                        <td>Kontrolor podataka ima za cilj da odgovori na validne zahtjeve Korisnika najkasnije u roku od jednog (1) mjeseca od njihovog prijema, osim ako je zahtjev izuzetno komplikovan ili je Korisnik podnio više zahtjeva, u kom slučaju Kontrolor podataka ima za cilj da odgovori na njih u roku od tri mjeseca. U slučaju da je Kontroloru podataka potrebno više od mjesec dana iz gorenavedenih razloga, on će obavijestiti Korisnika. Kontrolor podataka može pitati Korisnika da li želi da objasni šta tačno želi da dobije ili šta ga zabrinjava. Ovo će pomoći Kontroloru podataka da brže reaguje u odnosu na zahtjev korisnika. U svakom slučaju, Korisnik treba da navede konkretne i istinite podatke i/ili činjenice kako bi Kontrolor podataka mogao tačno da odgovori i/ili udovolji zahtjevu Korisnika. U suprotnom, Kontrolor podataka zadržava pravo na sve greške koje su van njegove kontrole. Pored toga, Kontrolor podataka može da odbije zahtjeve koji su neosnovani, pretjerani, uvredljivi, učinjeni u lošoj namjeri ili su nelegitimni u okviru zakonskih odredbi.
                                        </td>
                                    </tr>
                                </table>

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">7. Kako se štiti sigurnost podataka?</h2>
                                <b>7.1</b> Kontrolor podataka sprovodi sve odgovarajuće mjere sigurnosti kako bi obezbijedio zaštitu i povjerljivost ličnih podataka među kojima su:
                                <br>
                                <ol>
                                    <li>Politike jakih lozinki na svim serverima</li>
                                    <li>HTTPS protokol za interakciju sa API-jima i veb klijentima</li>
                                    <li>SSH protokol za vezu sa serverom</li>
                                    <li>Periodična ažuriranja servera sa najnovijim sigurnosnim ispravkama</li>
                                </ol>

                                <br><br>
                                <b>7.2</b> Imajte na umu da samo posebno ovlašćeni zaposleni Kontrolora podataka, koji deluju pod ovlašćenjem Kontrolora podataka i samo po njegovim uputstvima, kao i primaoci, gde je to potrebno, rukuju podacima koje je Korisnik dostavio. Za obradu, Kontrolor podataka bira osobe sa odgovarajućim kvalifikacijama koje imaju dovoljne zaštitne mjere u pogledu tehničkog znanja i ličnog integriteta da zaštite povjerljivost. Kontrolor podataka preduzima sve neophodne mjere sigurnosti za zaštitu i čuvanje tajnosti, povjerljivosti i integriteta ličnih podataka takođe kroz relevantne ugovorne obaveze njegovih saradnika. U svakom slučaju, sigurnost veb stranice može biti narušena zbog razloga koji se nalaze izvan sfere kontrole Kontrolora podataka, kao i zbog tehničkog ili drugog problema na mreži ili više sile ili neočekivanih činjenica. U tom slučaju se ne može garantovati sigurnost ličnih podataka.

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">8. Ko su primaoci podataka?</h2>
                                <b>8.1</b> Primaoci ličnih podataka Korisnika su pridružene kompanije koje obezbjeđuju tehničku infrastrukturu za rad veb stranice, hosting provajder kao i kompanija koja se obavezuje da korisnicima šalje elektronsku komunikaciju u vezi sa funkcionisanjem Platforme. Kada je to potrebno prema važećim zakonima, Kontrolor podataka će potpisati ugovore sa takvim kompanijama, koji se odnose na sprovođenje i redovno praćenje sigurnosnih mjera. U slučaju da se podaci prenose van EU, postoje sve neophodne garancije.
                                <br><br>
                                <b>8.2.</b> U slučaju da Kontrolor podataka primi zahtjev da obavijesti ili prenese podatke na zahtjev nadležnog organa uprave, advokata, suda ili drugog organa, on može da obavijesti/prenese te podatke kako bi ispunio svoju dužnost u korist javnog interesa prema ovim organima (sa ili bez prethodnog obavještenja Korisnika) u skladu sa odgovarajućim zakonskim odredbama. Ako Korisnik treba da bude prethodno obaviješten u skladu sa zakonskim odredbama, onda Korisnik ima pravo da prigovori na ovu obradu kao što je predviđeno u gorenavedenom članu 7.
                                <br><br>
                                <b>8.3.</b> Što se tiče detalja o profesiji svakog Korisnika, oni su dostupni svim registrovanim korisnicima Platforme za gorenavedene svrhe.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">9. Komunikacija sa Kontrolorom podataka</h2>
                                <b>9.1.</b> Za bilo koje pitanje u vezi sa ovom politikom privatnosti, obradom podataka Korisnika kao i ostvarivanjem prava Korisnika, Korisnik može kontaktirati Kontrolora podataka na jedan od sljedećih načina: <br>
                                Telefon: {{ config("app.installation_company_phone") }}, <br>
                                Email: {{ config("app.installation_company_email") }}
                                <br><br>
                                U slučaju da Korisnik sazna za bilo kakav slučaj povrede podataka, ljubazno od njega tražimo da odmah obavijesti Kontrolora podataka.
                                <br><br>
                                <b>9.2.</b> Ovi uslovi su regulisani i dopunjeni Odredbama i uslovima i zajedno sa njima čine jedinstveni tekst.
                            </div>
                        </div>F
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">10. Konekcija  sa drugim veb stranicama/društvenim mrežama</h2>
                                Ova veb stranica je povezana sa drugim veb stranicama preko hiperlinkova. Ove veb stranice nisu povezane sa veb stranicom Kontrolora podataka i njihov sadržaji se ne provjeravaju niti preporučuju od strane Kontrolora podataka. Dakle, tačnost, legitimnost, potpunost ili kvalitet njihovog sadržaja i legitimnost obrade ličnih podataka Korisnika se ne mogu provjeriti i za njih se ne daje garancija. Kontrolor podataka se ne može držati odgovornim za njih ili bilo kakvu štetu koja može biti učinjena prema Korisniku usljed ili nakon njihovog korišćenja. Kontrolor podataka ne može da provjerava obradu ličnih podataka Korisnika od strane tih povezanih veb stranica i stoga ne snosi nikakvu odgovornost. Kada Korisnik pristupi tim veb stranicama, treba da uzme u obzir da se primjenjuju odredbe i uslovi svake veb stranice. Za bilo koji problem koji se može pojaviti u vezi sa sadržajem ili korišćenjem povezane veb stranice, Korisnik treba direktno da kontaktira operatera ili administratora svake veb stranice. Kontrolor podataka ne odobrava niti prihvata sadržaj ili usluge povezanih veb stranica, kojima Korisnik pristupa preko veb stranice.<br><br>
                                Veb-sajt daje Korisniku mogućnost da se na sopstvenu inicijativu i voljno poveže i komunicira sa društvenim mrežama. U tom slučaju Kontrolor podataka nije odgovoran za obradu podataka korisnika koja se odvija preko društvenih mreža ili putem društvenih mreža. Korisnik treba direktno da se obrati svakoj društvenoj mreži kako bi ostvario svoja legitimna prava.


                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">11. Kolačići</h2>
                                11.1. Platforma koristi kolačiće da bi bila operativna ili efikasnija u svom radu, da bi poboljšala navigaciju Korisnika, da bi Korisniku pružila puni potencijal Platforme, da bi obezbijedila ispravan prikaz sadržaja kao i u analitičke i statističke svrhe.
                                <br><br>
                                11.2. Kolačići su mali tekstualni fajlovi koje se čuvaju na računaru Korisnika kada posjeti digitalnu platformu, a koji se koriste kao sredstvo za identifikaciju njegovog računara.
                                <br><br>
                                11.3. Kolačići, osim apsolutno neophodnih kolačića, se instaliraju samo ako Korisnik prihvati njihovu instalaciju kada posjeti ovu Platformu. Prihvatanjem kolačića prilikom ulaska na ovu Platformu, Korisnik izričito izjavljuje da je pročitao i razumio posebne uslove u vezi sa instalacijom, funkcijom i svrhom kolačića i da daje saglasnost za njihovu upotrebu.
                                <br><br>
                                11.4. Opcionalno, Korisnik može da ne prihvati kolačiće. U ovom slučaju biće instalirani samo kolačići koji su tehnički i funkcionalno neophodni za rad Platforme.
                                <br><br>
                                11.5. Korisnik može upravljati korišćenjem i instaliranjem kolačića u bilo kom trenutku preko panela, gdje može da izabere koju kategoriju kolačića želi da prihvati, a koju ne (ili zahtijeva da se instaliraju samo tehnički neophodni kolačići).
                                <br><br>
                                11.6. Tačnije, kolačići koje koristi Platforma su sljedeći::
                                <br><br>

                                <table class="table table-striped table-responsive table-bordered">
                                    <tr>
                                        <th>Vrsta kolačića</th>
                                        <th>Objašnjenje</th>
                                        <th>Primjeri kolačića</th>
                                        <th>Trajanje instalacije svakog kolačića</th>
                                        <th>Prenos podataka trećim stranama</th>
                                    </tr>
                                    <tr>
                                        <td>Apsolutno neophodni kolačići</td>
                                        <td>Apsolutno neophodni kolačići su esencijalni za pravilan rad Platforme. Ovi kolačići omogućavaju Korisniku da pregleda i koristi funkcije Platforme kao što je pristup sigurnim oblastima. Ovi kolačići ne prepoznaju individualni identitet korisnika i bez njih, nesmetan rad Platforme nije moguć.
                                        </td>
                                        <td>crowdsourcing_app_cookies_consent_selection (Čuva status saglasnosti korisnika za kolačiće za trenutni domen)
                                            <br><br>
                                            crowdsourcing_app_cookies_consent_targeting (Čuva status saglasnosti korisnika za kolačiće za trenutni domen)
                                            <br><br>
                                            XSRF-TOKEN (Obezbjeđuje sigurnost pregledanja posjetilaca sprečavanjem falsifikovanja zahtjeva na više lokacija. Ovaj kolačić je neophodan za sigurnost veb stranice i posjetioca.)
                                            <br><br>
                                            ecas_lets_crowdsource_our_future_session (Kada aplikacija treba da „zapamti“ prijavljenog korisnika dok on(a) dolazi do Platforme)
                                            <br><br>
                                            Crowdsourcing_anonymous_user_id (koristi se za čuvanje anonimnih odgovora na upitnike dodjeljivanjem cijelog broja korisniku koji šalje odgovor)
                                        </td>
                                        <td>1 godina
                                            <br><br>
                                            <br><br>
                                            1 godina
                                            <br><br>
                                            <br><br>
                                            Sesija
                                            <br><br>
                                            <br><br>
                                            5 godina
                                        </td>
                                        <td>Ne
                                            <br><br>
                                            <br><br>

                                            Ne
                                            <br><br>
                                            <br><br>

                                            Ne
                                            <br><br>
                                            <br><br>

                                            Ne
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Statistika/analitčki kolačići</td>
                                        <td>Ovo su kolačići koji procjenjuju način na koji posjetioci koriste Platformu (na primer, koje stranice se češće posjećuju i da li dobijaju poruke o grešci sa veb stranica). Ovi kolačići se koriste u statističke svrhe i za poboljšanje performansi Platforme.
                                        </td>
                                        <td>_ga_4S9N5MK4VE, _gat,_ga, _gcl_au, _gid: Kolačići Google analitike se koriste za mjerenje saobraćaja na Platformi. Jedinstveni tekstualni string se čuva da identifikuje pretraživač, vremensku oznaku za interakcije i pretraživač/izvornu stranicu koja je dovela korisnika do Platforme. Nijedna osjetljiva informacija se ne čuva.

                                        </td>
                                        <td>_ga_4S9N5MK4VE: 2 godine
                                            <br><br>
                                            _gat:1 minut
                                            <br><br>
                                            _ga:2 godine
                                            <br><br>
                                            _gcl_au:3 mjeseca
                                            <br><br>
                                            _gid:24 sata
                                        </td>
                                        <td>Da (Kompanija koja pruža statističke i analitičke usluge ako se smatra trećom stranom)
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">12. Privatnost djece</h2>
                                Naš projekat se ne obraća nikome mlađem od 18 godina („Djeci“). Ne prikupljamo svjesno lične podatke od bilo koga mlađeg od 18 godina. Ako ste roditelj ili staratelj i svjesni ste da su nam vaša djeca dala lične podatke, kontaktirajte nas. Ako doznamo da smo prikupili lične podatke djece bez provjere saglasnosti roditelja, preduzimamo korake da uklonimo te informacije sa naših servera.


                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">13. Izmjene i dopune ove Politike privatnosti </h2>
                                Kontrolor podataka zadržava pravo da izmijeni ovu Politiku privatnosti, na primjer kada je to neophodno radi usklađivanja sa novim zahtjevima nametnutim važećim zakonima, smjernicama ili tehničkim zahtjevima, ili u toku revizije procesa i prakse Kontrolora podataka. Korisnik će biti obaviješten o svim izmjenama i dopunama ove Politike privatnosti preko Platforme. Korisnik treba redovno da provjerava ovu Politiku privatnosti radi bilo kakvih izmjena.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
