@extends('home.layout')

@section('content')

    <div class="container pt-4 mb-2" style="margin-top: 100px">
        <div class="mb-5">
            <div class="row">
                <div class="col-12 mx-auto mb-3 text-center">
                    <h1>Politique de confidentialité</h1>
                </div>
            </div>
            <div class="row">
                <div class="col mx-auto">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col">
                                La présente Politique de confidentialité s'applique à tous les Utilisateurs de la Plateforme (ci-après dénommés respectivement les <b>“Utilisateurs”</b> ou l <b>“Utilisateur”</b> et la <b>“Plateforme”</b>) et fait partie intégrante des Conditions générales du Site de la Plateforme. La présente Politique de confidentialité fournit à l'Utilisateur des informations générales concernant la manière dont le Responsable du traitement utilise vos données personnelles et d'autres informations requises par la législation sur la protection des données. En cas de modification future, l'Utilisateur recevra les mises à jour et les informations nécessaires par le biais de la mise à jour de la présente Politique de confidentialité, téléchargée sur la Plateforme.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">1. Qui est le responsable du traitement des données?</h2>
                            </div>
                            <div class="col-12">
                                <b>1.1.</b> La société dont la raison sociale est "{{ config("app.installation_company_name") }}", adresse : {{ config("app.installation_company_address") }},
                                Téléphone: {{ config("app.installation_company_phone") }}, email:
                                {{ config("app.installation_company_email") }}, est le responsable pour le traitement des données personnelles de l'utilisateur (ci-après dénommé <b>"Responsable du traitement des données"</b>).
                                <br><br>
                                <b>1.2. Coordonnées du Responsable du traitement des données:</b> Pour toute question ou préoccupation concernant la présente Politique de confidentialité et le traitement des données personnelles de l'Utilisateur ou des données téléchargées par l'Utilisateur pour utiliser la Plateforme, l'Utilisateur peut communiquer avec le Responsable du traitement en utilisant l'une des alternatives suivantes:
                                <br><br>
                                En appelant au {{ config("app.installation_company_phone") }}, du lundi au vendredi de 10h00 à 18.00 HNEE (Heure Normale d'Europe de l'Est).<br>
                                En envoyant un courriel à l’adresse suivante: {{ config("app.installation_company_email") }}<br>
                                En envoyant un courrier à l'adresse suivante: {{ config("app.installation_company_address") }}<br>

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">2. Quelle est la finalité et la base juridique du traitement des données de l'utilisateur?</h2>
                                <b>2.1.</b> La finalité opérationnelle de la plate-forme est de recueillir les opinions des utilisateurs par le biais de questionnaires. Les utilisateurs peuvent répondre de manière anonyme (sans fournir d'informations personnelles) ou s'inscrire volontairement afin de soumettre des réponses éponymes, en fournissant une adresse électronique et un pseudonyme. Les réponses des utilisateurs sont traduites en anglais et sont présentées dans des rapports. Pour la finalité spécifique du traitement, la base juridique est le consentement préalable de l'utilisateur.
                                <br><br>
                                <b>2.2.</b> Envoyer à l'Utilisateur des courriers électroniques d'information dans le but de l'informer sur les nouvelles activités, les projets et autres sujets d'intérêt de la Plateforme. Pour cette finalité de traitement, la base juridique est le consentement préalable de l'Utilisateur.
                                <br><br>
                                <b>2.3.</b> Traiter des données pour des raisons liées aux obligation légales du Responsable du traitement des données. Dans ces cas, le traitement des données n'a lieu que pendant la période nécessaire pour permettre au Responsable du traitement de se conformer aux obligations imposées par diverses dispositions légales.
                                <br><br>
                                <b>Dans le cas des dispositions ci-dessus où la base juridique est le consentement préalable de l'utilisateur, l'utilisateur peut toujours retirer son consentement à tout moment sans affecter la légitimité des données fondées sur le consentement avant son retrait.</b>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">3. Types de données collectées</h2>

                                <h3 class="mt-4 mb-4">3.1 Données personnelles</h3>
                                <b>3.1.1 Inscription-création de compte:</b><br>
                                Pour qu'un Utilisateur puisse créer volontairement un compte sur la Plateforme, l'Utilisateur doit renseigner les données nécessaires : son pseudonyme, son adresse électronique et un mot de passe.
                                <br><br>
                                <b>3.1.2 Réponses au questionnaire soumis</b><br>
                                La plate-forme recueille les réponses des utilisateurs (c'est-à-dire leurs opinions sur divers sujets) aux questions posées via les questionnaires de la plate-forme. Ces réponses sont analysées et présentées dans une page de résultats du questionnaire. Il est strictement conseillé à l'utilisateur de se conformer au "code de conduite pour une participation réussie" de la plate-forme et d'éviter de rendre publiques des données personnelles qu'il ne souhaite pas rendre publiques.
                                <br><br>
                                <b>3.1.3. Communication de la Plateforme pour des raisons liées à l'utilisation autorisée de la Plateforme par l'Utilisateur.</b>
                                <br>
                                Afin que la Plateforme puisse communiquer avec l'Utilisateur aux fins susmentionnées, le Responsable du traitement peut traiter toutes les données relatives au compte de l'Utilisateur, au contenu téléchargé et aux données liées à l'utilisation de la Plateforme par l'Utilisateur.

                                <h3 class="mt-4 mb-4">3.2 Données d'utilisation</h3>
                                Nous pouvons également recueillir des informations sur la manière dont la page Web est consultée et utilisée ("données d'utilisation"). Ces données d'utilisation peuvent inclure des informations telles que l'adresse de protocole Internet (par exemple, l'adresse IP) de votre ordinateur, le type de navigateur, la version du navigateur, les pages de notre page web que vous visitez, l'heure et la date de votre visite, le temps passé sur ces pages, les identifiants uniques des appareils et d'autres données de diagnostic.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4"> 4. Comment la plate-forme collecte les données</h2>
                                4.1 Les informations peuvent être collectées par les moyens suivants: <br>
                                4.1.1 Lorsque l'Utilisateur s'inscrit et crée un compte sur la Plateforme. <br>
                                4.1.2 Lorsque l'Utilisateur soumet des réponses aux questionnaires de la Plateforme <br>
                                4.1.3 Lorsque l'Utilisateur visite la Plateforme et accepte l'installation de cookies (conformément à la politique de cookies de la Plateforme à l'article 11 ci-dessous) et la collecte des données personnelles de l'Utilisateur telles que l'adresse IP, le système d'exploitation, le type et l'édition du navigateur, etc.
                                <br>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">5. Combien de temps les données de l'utilisateur sont-elles conservées et quand sont-elles supprimées?</h2>
                                <b>5.1. Les données du compte de l'utilisateur:</b><br>
                                Sans préjudice du droit de suppression/effacement de l'Utilisateur mentionné ci-dessous, les Données enregistrées et stockées dans le compte de l'Utilisateur seront conservées tant que l'Utilisateur souhaite utiliser la Plateforme dans le but mentionné ci-dessus. Dans le cas où un Utilisateur souhaite supprimer son compte, il peut le faire via les paramètres du compte ou contacter le Responsable du traitement aux coordonnées mentionnées ci-dessus.
                                <br><br>
                                <b>5.2. La communication de la plate-forme pour des raisons liées à l'utilisation autorisée de la plate-forme par l'utilisateur.</b><br>
                                Les données relatives à cette communication seront stockées uniquement tant que l'Utilisateur souhaite utiliser la Plateforme et maintient son compte. Dans le cas où un Utilisateur souhaite supprimer son compte, il peut le faire via les paramètres du compte ou contacter le responsable du traitement des données aux coordonnées mentionnées ci-dessus.
                                <br><br>
                                <b>5.3. Analyse statistique pour l'optimisation du site Internet</b><br>
                                Indépendamment des dispositions de l'article 5 susmentionné, le responsable du traitement des données ne conservera et ne traitera que les données nécessaires pour la période requise afin de respecter les obligations imposées par la loi à chaque fois (respect des obligations fiscales, etc.).
                                <br><br>
                                <b>5.4. Traitement des données à caractère personnel aux fins de la réalisation d'analyses statistiques.</b><br>
                                Veuillez consulter la politique relative aux cookies (article 11) ci-dessous.
                                <br><br>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">6. Quels sont les droits de l'Utilisateur concernant le traitement de ses données et comment peut-il exercer ces droits?</h2>
                                <b>6.1</b> Le responsable du traitement respecte le droit de l'utilisateur en matière de traitement des données.
                                <br><br>
                                <b>6.2</b> L'Utilisateur peut exercer ses droits en contactant le Responsable du traitement aux coordonnées suivantes: Téléphone: {{ config("app.installation_company_phone") }}, courriel: {{ config("app.installation_company_email") }}
                                <br><br>
                                Pour faciliter la tâche de l'Utilisateur, les droits de l'Utilisateur sont inclus dans le tableau suivant ainsi qu’une brève explication de chaque droit (la référence aux articles correspond à l'article du RGPD 2016/679):
                                <br><br>
                                <table class="table table-striped table-responsive table-bordered">
                                    <tr>
                                        <th>Droit</th>
                                        <th>Explication</th>
                                    </tr>
                                    <tr>
                                        <td>Accès (article 15)</td>
                                        <td>
                                            L'Utilisateur peut demander au Responsable du traitement des données de:
                                            <ul>
                                                <li>De confirmer si le Responsable du traitement traite les données personnelles de l'Utilisateur
                                                </li>
                                                <li>De donner à l'Utilisateur l'accès aux données dont l'Utilisateur ne dispose pas</li>
                                                <li>de fournir à l'Utilisateur d'autres informations relatives aux données personnelles de l'Utilisateur, telles que les données dont le Responsable du traitement dispose, les finalités du traitement, les personnes auxquelles ces données sont communiquées, si ces données sont transférées dans des pays étrangers et comment ces données sont protégées, la durée de conservation des données, les droits de l'Utilisateur, les modalités de réclamation, l'origine des données, dans la mesure où ces informations ne figurent pas dans la présente Politique de confidentialité.
                                                </li>
                                            </ul>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Rectification (article 16)</td>
                                        <td>
                                            L'Utilisateur peut demander au Responsable du traitement de rectifier des données personnelles inexactes.<br><br>
                                            Le Responsable du traitement peut chercher à vérifier l'exactitude des données avant de les rectifier.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Effacement/suppression (article17)</td>
                                        <td>
                                            L'Utilisateur peut demander au Responsable du traitement d'effacer ses données personnelles:<br><br>
                                            <ul>
                                                <li>À tout moment, lorsque les données personnelles ne sont plus nécessaires aux fins pour lesquelles elles ont été collectées
                                                </li>
                                                <li>Lorsque l'Utilisateur retire son consentement</li>
                                                <li>Les données personnelles ont été traitées de manière illégale</li>
                                            </ul>
                                            <br><br>
                                            Le Responsable du traitement n'est pas obligé de se conformer à la demande de l'Utilisateur d'effacer ses données personnelles, si le traitement des données personnelles de l'Utilisateur est nécessaire:
                                            <ul>
                                                <li>Pour le respect d'une obligation légale</li>
                                                <li>Pour la réalisation d'un autre objectif légitime ou d'une autre base juridique légitime
                                                </li>
                                                <li>Pour la constatation, l'exercice ou la défense de droits en justice</li>
                                            </ul>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Restriction (article 18)</td>
                                        <td>
                                            L'Utilisateur peut demander au Responsable du traitement de restreindre (stocker mais ne pas traiter) les données à caractère personnel de l'Utilisateur lorsque:<br><br>
                                            Leur exactitude est contestée (voir rectification), afin que le Responsable du traitement puisse vérifier l'exactitude des données à caractère personnel ; ou<br><br>
                                            Les données à caractère personnel ont été traitées illégalement mais l'Utilisateur s'oppose à l'effacement des données à caractère personnel ou<br><br>
                                            Elles ne sont plus nécessaires aux fins pour lesquelles elles ont été collectées mais l'Utilisateur en a encore besoin pour la constatation, l'exercice ou la défense de droits en justice ou il existe une autre finalité légitime du traitement ou une autre base juridique
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Transférabilité des données (article 20)
                                        </td>
                                        <td>
                                            Lorsque le traitement est fondé sur le consentement et que le traitement est effectué par des moyens automatisés, l'Utilisateur peut demander au Responsable du traitement de recevoir ses données à caractère personnel dans un format structuré, couramment utilisé et lisible par machine, ou demander au Responsable du traitement de les transmettre directement à un autre responsable du traitement. Néanmoins, selon la loi, ce droit ne se réfère qu'aux données qui ont été données par l'Utilisateur lui-même et non à celles qui sont déduites par le Responsable du traitement sur la base des données que l'Utilisateur a fournies.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Objection (article 21)</td>
                                        <td>
                                            L'Utilisateur peut s'opposer à tout moment au traitement des données personnelles le concernant qui est fondé sur l'intérêt légitime ou l'exécution d'une tâche effectuée dans l'intérêt public.<br><br>
                                            Lorsque l'Utilisateur exerce son droit d'opposition, le Responsable du traitement a le droit de démontrer qu'il existe des motifs légitimes impérieux pour le traitement qui prévalent sur l'intérêt, les droits et la liberté de l'Utilisateur ou pour la constatation, l'exercice ou la défense de droits en justice.

                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Retrait du consentement (opt-out)
                                        </td>
                                        <td>
                                            L'utilisateur a le droit de retirer son consentement lorsque le consentement est à la base du traitement. Le retrait est valable pour l'avenir.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Autorité de contrôle
                                        </td>
                                        <td>
                                            L'utilisateur a le droit de déposer une plainte auprès de l'autorité de contrôle locale relative à la protection des données. <br><br>
                                            En Grèce, l'autorité de contrôle pour la protection des données est l'Autorité de protection des données https://www.dpa.gr/.

                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Identité</td>
                                        <td>Le responsable du traitement prend au sérieux la confidentialité de tous les fichiers contenant des données personnelles, il est donc en droit de demander à l'utilisateur une preuve de son identité si l'utilisateur soumet une demande en relation avec ces fichiers.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Coût</td>
                                        <td>L'Utilisateur n'aura pas à payer pour l'exercice de ses droits en matière de données personnelles, sauf si, comme le prévoit la loi, la demande d'accès aux informations est infondée ou excessive. Dans ce cas, le responsable du traitement des données peut facturer à l'utilisateur des frais raisonnables compte tenu des circonstances particulières. Le responsable du traitement des données informera l'utilisateur de tout frais éventuel avant qu'il ne complète la demande.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Calendrier</td>
                                        <td>Le Responsable du traitement vise à répondre aux demandes valables de l'Utilisateur au plus tard dans un délai d'un (1) mois à compter de leur réception, sauf si la demande est extrêmement compliquée ou si l'Utilisateur a soumis plusieurs demandes, auquel cas le Responsable du traitement vise à y répondre dans un délai de trois mois. Si le responsable du traitement a besoin de plus d'un mois pour les raisons susmentionnées, il en informera l'utilisateur. Le responsable du traitement peut demander à l'utilisateur s'il souhaite expliquer exactement ce qu'il souhaite recevoir ou ce qui le préoccupe. Cela aidera le Responsable du traitement à agir plus rapidement par rapport à la demande de l'utilisateur. Dans tous les cas, l'utilisateur doit mentionner des données et/ou des faits précis et véridiques afin que le responsable du traitement puisse répondre et/ou satisfaire avec précision à la demande de l'utilisateur. Dans le cas contraire, le responsable du traitement se réserve le droit pour tout défaut qui échappe à son contrôle. En outre, le responsable du traitement peut rejeter les demandes non fondées, excessives, abusives, faites de mauvaise foi ou illégitimes dans le cadre des dispositions légales.
                                        </td>
                                    </tr>
                                </table>

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">7. Comment la sécurité des données est-elle garantie?</h2>
                                <b>7.1</b> Le responsable du traitement met en œuvre toutes les mesures de sécurité appropriées pour assurer la protection et la confidentialité des données personnelles parmi lesquelles figurent:
                                <br>
                                <ol>
                                    <li>Politiques de mots de passe solides sur tous les serveurs</li>
                                    <li>Protocole HTTPS pour interagir avec les API et les clients Web</li>
                                    <li>Protocole SSH pour la connexion au serveur</li>
                                    <li>Mises à jour périodiques du serveur avec les derniers correctifs de sécurité</li>
                                </ol>

                                <br><br>
                                <b>7.2</b> Veuillez noter que seuls les employés spécifiquement autorisés du Responsable du traitement des données, agissant sous l'autorité du Responsable du traitement et uniquement sur ses instructions ainsi que les destinataires, si nécessaire, traitent les données soumises par l'Utilisateur. Pour le traitement, le Responsable du traitement choisit des personnes ayant des qualifications appropriées qui présentent des garanties suffisantes en matière de connaissances techniques et d'intégrité personnelle pour protéger la confidentialité. Le Responsable du traitement prend toutes les mesures de sécurité nécessaires pour la protection et la sauvegarde du secret, de la confidentialité et de l'intégrité des données personnelles également par le biais d'engagements contractuels pertinents de ses associés. Il est possible que la sécurité du site Internet puisse être compromise pour des raisons qui échappent au contrôle du Responsable du traitement, ainsi que pour des problèmes techniques ou autres du réseau, des cas de force majeure ou des faits accidentels. Dans ce cas, la sécurité des données personnelles ne peut être garantie.

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">8. Qui sont les destinataires des données?</h2>
                                <b>8.1</b> Les destinataires des données personnelles de l'Utilisateur sont les sociétés associées qui fournissent l'infrastructure technique pour le fonctionnement du Site, le fournisseur d'hébergement ainsi que la société qui s'engage à envoyer aux Utilisateurs des communications électroniques liées au fonctionnement de la Plateforme. Si nécessaire, conformément aux lois applicables, le Responsable du traitement signera des accords avec ces sociétés, qui font référence à la mise en œuvre et au contrôle régulier des mesures de sécurité. En cas de transfert de données en dehors de ΕU, toutes les garanties nécessaires sont en place.
                                <br><br>
                                <b>8.2.</b> Dans le cas où le Responsable du traitement reçoit une demande de notification ou de transfert de données à la suite d’une demande de l'Autorité administrative, du Procureur, du Tribunal ou d'une autre Autorité appropriée, il peut notifier / transférer ces données afin de remplir son devoir exécuté en faveur de l'intérêt public envers ces autorités (avec ou sans notification préalable de l'Utilisateur) conformément aux dispositions légales appropriées. Si l'Utilisateur devait être préalablement informé conformément aux dispositions légales, alors l'Utilisateur a le droit de s'opposer à ce traitement dans les conditions prévues à l'article 7 ci-dessus.
                                <br><br>
                                <b>8.3.</b> Quant aux coordonnées professionnelles de chaque Utilisateur, elles sont à la disposition de tous les Utilisateurs inscrits sur la Plateforme aux fins mentionnées ci-dessus
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">9. Communication avec le Responsable du traitement des données</h2>
                                <b>9.1.</b> Pour toute question liée à la présente politique de confidentialité, au traitement des données de l'utilisateur ainsi qu'à l'exercice des droits de l'utilisateur, l'utilisateur peut contacter le responsable du traitement en utilisant l'un des moyens suivants: <br>
                                Téléphone: {{ config("app.installation_company_phone") }}, <br>
                                Courriel: {{ config("app.installation_company_email") }}
                                <br><br>
                                Si l'utilisateur prend connaissance d'un incident de violation de données, il est prié d'en informer immédiatement le responsable du traitement.
                                <br><br>
                                <b>9.2.</b> Les présentes conditions sont régies et complétées par les Conditions générales et constituent avec elles un texte uniforme.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">10. Connexion à d'autres sites Internet/réseaux sociaux</h2>
                                Ce site Internet se connecte à d'autres sites Internet par le biais d'hyperliens. Ces sites Internet ne sont pas liés au site Internet du contrôleur de données et leur contenu n'est ni vérifié ni recommandé par le Responsable du traitement. Ainsi, l'exactitude, la légitimité, l'exhaustivité ou la qualité de leur contenu et la légitimité du traitement des données personnelles de l'Utilisateur ne peuvent être vérifiées et aucune garantie n'est apportée à leur égard. Le Responsable du traitement ne peut être tenu pour responsable de ceux-ci ou de tout dommage qui pourrait être causé à l'Utilisateur du fait ou à la suite de leur utilisation. Le Responsable du traitement ne peut pas vérifier le traitement des données personnelles de l'Utilisateur par ces sites Internet liés et n'assume donc aucune responsabilité. Lorsque l'Utilisateur accède à ces sites Internet, il doit tenir compte du fait que les conditions générales de chaque site Internet s'appliquent. Pour toute question relative au contenu ou à l'utilisation du site internet lié, l'utilisateur doit contacter directement l'opérateur ou l'administrateur de chaque site Internet. Le Responsable du traitement n'approuve ni ne cautionne le contenu ou les services des sites Internet liés auxquels l'Utilisateur accède par le biais du Site.<br><br>
                                Le site Internet donne à l'utilisateur la possibilité de se connecter et d'interagir avec les médias sociaux de sa propre initiative et volonté. Dans ce cas, le Responsable du traitement des données n'est pas responsable du traitement des données de l'Utilisateur qui a lieu à travers ou par les réseaux sociaux. L'Utilisateur doit s'adresser directement à chaque média social spécifique afin d'exercer ses droits légitimes.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">11. Cookies</h2>
                                11.1. La Plateforme utilise des cookies pour être opérationnelle ou plus efficace dans son fonctionnement, pour améliorer la navigation de l'Utilisateur, pour fournir à l'Utilisateur le plein potentiel de la Plateforme, pour assurer l'affichage correct du contenu ainsi qu'à des fins analytiques et statistiques.
                                <br><br>
                                11.2. Les cookies sont de petits fichiers texte stockés sur l'ordinateur de l'Utilisateur lorsqu'il visite une plateforme numérique, qui sont utilisés comme moyen pour identifier son ordinateur.
                                <br><br>
                                11.3. Les cookies, hormis ceux qui sont absolument nécessaires, ne sont installés que si l'Utilisateur accepte leur installation lorsqu'il visite cette Plateforme. En acceptant les cookies lors de son entrée sur cette Plateforme, l'Utilisateur déclare expressément qu'il a lu et compris les conditions spécifiques concernant l'installation, la fonction et la finalité des cookies et qu'il donne son consentement à leur utilisation.
                                <br><br>
                                11.4. L'Utilisateur peut également ne pas accepter les cookies. Dans ce cas, seuls les cookies qui sont techniquement et fonctionnellement nécessaires au fonctionnement de la Plateforme seront installés.
                                <br><br>
                                11.5. L'Utilisateur peut gérer l'utilisation et l'installation des cookies à tout moment à travers un panneau, où il peut choisir la catégorie de cookies qu'il veut accepter et ceux qu'il ne veut pas (ou demander d'installer uniquement les cookies techniquement nécessaires).
                                <br><br>
                                11.6. En particulier, les cookies utilisés par la Plateforme sont les suivants:
                                <br><br>

                                <table class="table table-striped table-responsive table-bordered">
                                    <tr>
                                        <th>Type de cookies</th>
                                        <th>Explication</th>
                                        <th>Exemples de cookies</th>
                                        <th>Durée de chaque installation de cookie</th>
                                        <th>Transfert de données à des tiers</th>
                                    </tr>
                                    <tr>
                                        <td>Cookies absolument nécessaires</td>
                                        <td>Les cookies absolument nécessaires sont indispensables au bon fonctionnement de la Plateforme. Ces cookies permettent à l'Utilisateur de naviguer et d'utiliser les fonctionnalités de la Plateforme telles que l'accès à des zones sécurisées. Ces cookies ne reconnaissent pas l'identité individuelle de l'Utilisateur et sans eux, le bon fonctionnement de la Plateforme n'est pas possible.
                                        </td>
                                        <td>crowdsourcing_app_cookies_consent_selection (enregistre l'état de consentement des cookies de l'utilisateur pour le domaine actuel)
                                            <br><br>
                                            crowdsourcing_app_cookies_consent_targeting (enregistre l'état de consentement des cookies de l'utilisateur pour le domaine actuel)
                                            <br><br>
                                            XSRF-TOKEN (Assure la sécurité de la navigation des visiteurs en empêchant la falsification des requêtes intersites. Ce cookie est essentiel pour la sécurité du site Internet et du visiteur. )
                                            <br><br>
                                            ecas_lets_crowdsource_our_future_session (Lorsque l'application doit "se souvenir" de l'utilisateur connecté pendant qu'il navigue vers la plate-forme)
                                            <br><br>
                                            Crowdsourcing_anonymous_user_id (utilisé pour stocker les réponses anonymes sur les questionnaires en attribuant un nombre entier à l'utilisateur qui soumet la réponse)
                                        </td>
                                        <td>1 an
                                            <br><br>
                                            <br><br>
                                            1 jour
                                            <br><br>
                                            <br><br>
                                            La session
                                            <br><br>
                                            <br><br>
                                            5 ans
                                        </td>
                                        <td>Non
                                            <br><br>
                                            <br><br>

                                            Non
                                            <br><br>
                                            <br><br>

                                            Non
                                            <br><br>
                                            <br><br>

                                            Non
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Cookies statistiques/analytiques</td>
                                        <td>Il s'agit de cookies qui évaluent la manière dont les visiteurs utilisent la Plateforme (par exemple, quelles sont les pages les plus visitées et s'ils reçoivent des messages d'erreur des pages web). Ces cookies sont utilisés à des fins statistiques et pour améliorer les performances d'une Plateforme.
                                        </td>
                                        <td>_ga_4S9N5MK4VE, _gat,_ga, _gcl_au, _gid: Les cookies de Google Analytics sont utilisés pour mesurer le trafic sur la Plateforme. Une chaîne de texte unique est enregistrée pour identifier le navigateur, l'horodatage des interactions et le navigateur/la page source qui a conduit l'utilisateur à la Plateforme. Aucune information sensible n'est enregistrée.

                                        </td>
                                        <td>_ga_4S9N5MK4VE: 2 ans
                                            <br><br>
                                            _gat:1 minute
                                            <br><br>
                                            _ga:2 ans
                                            <br><br>
                                            _gcl_au:3 mois
                                            <br><br>
                                            _gid:24 heures
                                        </td>
                                        <td>Oui (la société qui fournit des services statistiques et analytiques est considérée comme un tiers).
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">12. Vie privée des enfants </h2>
                                Notre projet ne s'adresse pas aux personnes âgées de moins de 18 ans ("Enfants").
                                Nous ne collectons pas sciemment d'informations personnellement identifiables auprès de toute personne âgée de moins de 18 ans. Si vous êtes un parent ou un tuteur et que vous savez que vos enfants nous ont fourni des données personnelles, veuillez nous contacter. Si nous nous rendons compte que nous avons collecté des données personnelles d'enfants sans vérification du consentement parental, nous prenons des mesures pour supprimer ces informations de nos serveurs.
              
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">13. Modifications de la présente politique de confidentialité </h2>
                                Le responsable du traitement se réserve le droit de modifier la présente politique de confidentialité, par exemple lorsque cela est nécessaire pour se conformer aux nouvelles exigences imposées par les lois, directives ou exigences techniques applicables, ou dans le cadre d'une révision des processus et pratiques du responsable du traitement. L'Utilisateur sera informé de toute modification de la présente Politique de confidentialité via la Plateforme. L'utilisateur doit vérifier régulièrement cette politique de confidentialité pour toute modification.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
