@extends('home.layout')

@section('content')

    <div class="container pt-4 mb-2" style="margin-top: 100px">
        <div class="mb-5">
            <div class="row">
                <div class="col-12 mx-auto mb-3 text-center">
                    <h1>PRIVAATSUSPOLIITIKA</h1>
                </div>
            </div>
            <div class="row">
                <div class="col mx-auto">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col">
                                See privaatsuseeskiri kehtib kõikidele platvormi kasutajatele (edaspidi vastavalt <b>„kasutajad“</b> või <b>„kasutaja“</b> ja <b>„platvorm“</b>) ning moodustab platvormi veebilehe kasutustingimuste lahutamatu osa. See privaatsuseeskiri annab kasutajale üldist teavet, kuidas vastutav töötleja kasutab tema isikuandmeid ning muud andmekaitseseadustega nõutavat teavet. Edaspidiste muudatuste korral teavitatakse kasutajat vajalikest uuendustest ning antakse lisateavet, laadides platvormile privaatsuseeskirja uuendatud versiooni.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">1. Kes on vastutav töötleja?</h2>
                            </div>
                            <div class="col-12">
                                <b>1.1.</b> Kasutaja isikuandmete vastutav töötleja (edaspidi „vastutav töötleja“) on ettevõte "{{ config("app.installation_company_name") }}", aadress: {{ config("app.installation_company_address") }}, tel {{ config("app.installation_company_phone") }}, e-post: {{ config("app.installation_company_email") }}.
                                <br><br>
                                <b>1.2. Vastutava töötleja kontaktandmed:</b> Kõigi käesoleva privaatsuseeskirjaga, kasutaja isikuandmete töötlemisega või kasutaja poolt platvormi kasutamiseks üles laaditud andmete töötlemisega seotud küsimuste või probleemide korral võib kasutaja ühendust võtta vastutava töötlejaga, kasutades ühte järgmistest võimalustest:
                                <br><br>
                                helistades {{ config("app.installation_company_phone") }}, esmaspäevast reedeni kella 10.00–18.00 EET (Ida-Euroopa aeg);<br>
                                saates kirja e-posti aadressile {{ config("app.installation_company_email") }}; <br>
                                saates kirja postiaadressile {{ config("app.installation_company_address") }}.<br>

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">2. Mis on kasutaja andmete töötlemise eesmärk ja õiguslik alus?</h2>
                                <b>2.1.</b> Platvormi tegutsemise eesmärk on koguda kasutajate arvamusi küsimustike vahendusel. Arvamusi töödeldakse, et saada ülevaadet, koguda ja esitada väärtuslikke ideid ja ettepanekuid küsimustikes käsitletud teemadel. Kasutajad saavad vastata anonüümselt (isikuandmeid esitamata) või vabatahtlikult registreerudes, esitades e-posti aadressi ja oma valitud kasutajanime. Kasutajate vastused tõlgitakse inglise keelde ja esitatakse aruannetes. Sellel eesmärgil töötlemise õiguslik alus on kasutaja eelnev nõusolek.
                                <br><br>
                                <b>2.2.</b> Kasutajale informatiivsete e-kirjade saatmine eesmärgiga teavitada teda uutest tegevustest, projektidest ja muudest huvipakkuvatest küsimustest seoses platvormiga. Sellel eesmärgil töötlemise õiguslik alus on kasutaja eelnev nõusolek.
                                <br><br>
                                <b>2.3</b> Andmete töötlemine, mis on seotud töötleja seadusjärgsete kohustuste täitmisega. Sellistel juhtudel toimub andmete töötlemine vaid nii kaua, kui see on vajalik, et töötleja saaks täita erinevatest õigusnormidest tulenevaid kohustusi.
                                <br><br>
                                <b>Nende ülaltoodud sätete puhul, mille õiguslikuks aluseks on kasutaja eelnev nõusolek, saab kasutaja oma nõusoleku igal ajal tagasi võtta, ilma et see mõjutaks enne nõusoleku tagasivõtmist toimunud andmete töötlemise legitiimsust varem antud nõusoleku alusel.</b>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">3. Kogutavate andmete liigid</h2>

                                <h3 class="mt-4 mb-4">3.1 Isikuandmed</h3>
                                <b>3.1.1 Registreerimine – konto loomine:</b><br>
                                Selleks, et kasutaja saaks platvormil vabatahtlikult konto luua, peab kasutaja sisestama vajalikud andmed: oma kasutajanime, e-posti aadressi ja salasõna.
                                <br><br>
                                <b>3.1.2 Küsimustikele antud vastused</b><br>
                                Platvorm kogub kasutajate vastuseid (st arvamusi erinevatel teemadel) platvormil esitatud küsimustike küsimustele. Neid vastuseid analüüsitakse ja esitatakse küsimustiku tulemuste lehel. Kasutajalt eeldatakse, et nad järgivad „eduka osalemise käitumisjuhendit“ ning väldivad selliste isikuandmete avalikustamist, mida nad ei soovi platvormil avalikult kättesaadavaks teha.
                                <br><br>
                                <b>3.1.3. Kasutaja ja platvormi omavaheline suhtlus seoses platvormi lubatud viisil kasutamisega kasutaja poolt</b>
                                <br>
                                Selleks, et platvorm saaks ülalnimetatud eesmärkidel kasutajaga suhelda, saab töötleja töödelda kõiki kasutaja kontoga seotud andmeid, üleslaaditud sisu, ning andmeid, mis on seotud platvormi kasutamisega kasutaja poolt.

                                <h3 class="mt-4 mb-4">3.2 Kasutusandmed</h3>
                                Samuti võime koguda teavet selle kohta, kuidas veebilehele ligi pääseb ja kuidas seda kasutatakse („kasutusandmed“). Need kasutusandmed võivad sisaldada sellist teavet nagu sinu arvuti internetiprotokolli aadress (IP-aadress), brauseri tüüp, brauseri versioon, meie veebisaidi lehed, mida sa külastad, sinu külastuse kuupäev ja kellaaeg, nendel lehtedel veedetud aeg, unikaalse seadme identifikaatorid ja muud diagnostikaandmed.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4"> 4. Kuidas platvorm andmeid kogub</h2>
                                4.1 Andmeid kogutakse järgmistel viisidel: <br>
                                4.1.1 Kui kasutaja registreerub ja loob platvormil konto. <br>
                                4.1.2 Kui kasutaja esitab platvormi küsimustikele vastused <br>
                                4.1.3 Kui kasutaja külastab platvormi ja nõustub küpsiste installimisega (vastavalt platvormi küpsiste eeskirjale allpool artiklis 11) ning kasutaja isikuandmete, nagu IP-aadress, operatsioonisüsteem, tüüp ja brauseri versioon jms kogumisega.
                                <br>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">5. Kui kaua kasutaja andmeid säilitatakse ja millal need kustutatakse?</h2>
                                <b>5.1. Kasutaja konto andmed:</b><br>
                                Ilma et see piiraks kasutaja allpool nimetatud andmete jäädava või ajutise kustutamise õigust, säilitatakse kasutaja kontol registreeritud ja salvestatud andmeid seni, kuni kasutaja soovib platvormi ülalnimetatud eesmärgil kasutada. Kui kasutaja soovib oma konto kustutada, saab ta seda teha oma konto seadete kaudu või võttes ühendust vastutava töötlejaga ülaltoodud kontaktandmete kaudu.
                                <br><br>
                                <b>5.2. Kasutaja ja platvormi omavaheline suhtlus seoses platvormi lubatud viisil kasutamisega kasutaja poolt.</b><br>
                                Sellise suhtluse andmeid säilitatakse ainult seni, kuni kasutaja soovib platvormi kasutada ja omab seal kontot.  Kui kasutaja soovib oma konto kustutada, saab ta seda teha oma konto seadete kaudu või võttes ühendust vastutava töötlejaga ülaltoodud kontaktandmete kaudu.
                                <br><br>
                                <b>5.3. Statistiline analüüs veebisaidi optimeerimiseks</b><br>
                                Olenemata ülalmainitud artikli 5 sätetest, säilitab ja töötleb vastutav töötleja ainult vajalikke andmeid nii kaua, kui see on vajalik tema seadusest tulenevate kohustuste (finantskohustused jms) täitmiseks.
                                <br><br>
                                <b>5.4. Isikuandmete töötlemine statistilise analüüsi eesmärgil.</b><br>
                                Vaata allpool küpsiste eeskirja (artikkel 11).
                                <br><br>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">6. Millised on kasutaja õigused seoses tema andmete töötlemisega ja kuidas ta saab neid õigusi kasutada?</h2>
                                <b>6.1</b> Vastutav töötleja austab kasutaja õigusi seoses andmetöötlusega.
                                <br><br>
                                <b>6.2</b> Kasutaja saab oma õigusi teostada võttes ühendust vastutava töötlejaga järgmiste kontaktandmete kaudu: tel {{ config("app.installation_company_phone") }}, e-post: {{ config("app.installation_company_email") }}
                                <br><br>
                                Kasutaja jaoks asja lihtsustamiseks on kasutaja õigused koondatud järgnevasse tabelisse koos iga õiguse lühikese selgitusega (viide artiklile vastab GDPR 2016/679 artiklile):
                                <br><br>
                                <table class="table table-striped table-responsive table-bordered">
                                    <tr>
                                        <th>Õigus</th>
                                        <th>Selgitus</th>
                                    </tr>
                                    <tr>
                                        <td>Ligipääs (artikkel 15)</td>
                                        <td>
                                            Kasutaja võib paluda vastutaval töötlejal:
                                            <ul>
                                                <li>kinnitada, kas vastutav töötleja töötleb kasutaja isikuandmeid
                                                </li>
                                                <li>anda kasutajale ligipääsu andmetele, mida kasutaja ei käsuta</li>
                                                <li>anda kasutajale muud teavet, mis on seotud kasutaja isikuandmetega, näiteks milliseid andmeid vastutav töötleja kasutab, millised on töötlemise eesmärgid, kellele neid andmeid avaldatakse, kas neid andmeid edastatakse välisriikidesse ja kuidas neid andmeid kaitstakse, kui kaua andmeid säilitatakse, millised on kasutaja õigused, kuidas saab esitada kaebust ning kust on andmed võetud, kuivõrd see teave ei sisaldu käesolevas privaatsuseeskirjas.
                                                </li>
                                            </ul>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Parandamine (artikkel 16)</td>
                                        <td>Kasutaja võib paluda vastutaval töötlejal ebatäpsed isikuandmed parandada.<br><br>
                                            Vastutav töötleja võib kontrollida andmete õigsust enne nende parandamist.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Kustutamine ajutiselt/jäädavalt (artikkel 17)</td>
                                        <td>
                                            Kasutaja saab paluda töötlejal oma isikuandmed jäädavalt kustutada, kui:<br><br>
                                            <ul>
                                                <li>isikuandmeid ei ole enam vaja eesmärkidel, milleks need koguti;
                                                </li>
                                                <li>kasutaja oma nõusoleku tagasi võtab;</li>
                                                <li>isikuandmeid on töödeldud ebaseaduslikult.</li>
                                            </ul>
                                            <br><br>
                                            Vastutav töötleja ei ole kohustatud täitma kasutaja taotlust oma isikuandmete kustutamiseks, kui kasutaja isikuandmete töötlemine on vajalik:
                                            <ul>
                                                <li>seadusjärgse kohustuse täitmiseks;</li>
                                                <li>mistahes muul seaduslikul eesmärgil või muul õiguslikul alusel;
                                                </li>
                                                <li> seadusjärgsete nõuete esitamiseks, teostamiseks või kaitsmiseks.</li>
                                            </ul>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Piiramine (artikkel 18)</td>
                                        <td>
                                            Kasutaja võib paluda vastutaval töötlejal piirata kasutaja isikuandmete kasutamist (salvestada, kuid mitte töödelda), kui:<br><br>
                                            nende õigsus on vaidlustatud (vt „Parandamine“), et töötleja saaks kontrollida isikuandmete õigsust;<br><br>
                                            isikuandmeid on töödeldud ebaseaduslikult, kuid kasutaja on vastu isikuandmete kustutamisele;<br><br>
                                            need ei ole enam vajalikud eesmärkidel, milleks need koguti, kuid kasutajal on neid endiselt vaja seadusjärgsete nõuete esitamiseks, teostamiseks või kaitsmiseks või on olemas mingi muu seadusjärgse töötlemise eesmärk või muu õiguslik alus.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Andmete teisaldatavus (artikkel 20)
                                        </td>
                                        <td>
                                            Kui töötlemine põhineb nõusolekul ja toimub automatiseeritud vahenditega, võib kasutaja paluda vastutaval töötlejal anda talle tema isikuandmed struktureeritud üldkasutatavas ja masinloetavas vormingus või paluda need edastada otse teisele töötlejale. Sellegipoolest kehtib see õigus seaduse kohaselt ainult neile andmetele, mille on kasutaja ise esitanud, mitte aga andmetele, mida vastutav töötleja on tuletanud kasutaja esitatud andmete põhjal.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Vaidlustamine (artikkel 21)</td>
                                        <td>
                                            Kasutaja võib igal ajal vaidlustada teda puudutavate isikuandmete töötlemise, mis põhineb õigustatud huvil või avalikes huvides täidetava ülesande eesmärgil.<br><br>
                                            Kui kasutaja kasutab oma vaidlustamisõigust, on vastutaval töötlejal õigus näidata, et andmete töötlemiseks on kaalukad õigustatud põhjused, mis kaaluvad üles kasutaja huvid, õigused ja vabaduse õigusnõuete esitamiseks, teostamiseks või kaitsmiseks.

                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Nõusoleku tagasivõtmine
                                        </td>
                                        <td>
                                            Kasutajal on õigus oma nõusolek tagasi võtta, kui nõusolek on töötlemise aluseks. Tagasivõtmine kehtib edasiulatuvalt.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Järelevalveasutus
                                        </td>
                                        <td>
                                            Kasutajal on õigus esitada andmekaitsega seotud kaebus kohalikule järelevalveasutusele. <br><br>
                                            Kreekas on andmekaitse järelevalveasutus Andmekaitseamet https://www.dpa.gr/

                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Identiteet</td>
                                        <td>Vastutav töötleja suhtub tõsiselt kõigi isikuandmeid sisaldavate failide konfidentsiaalsusesse, mistõttu on tal õigus nõuda kasutajalt tema isikut tõendavat dokumenti, kui kasutaja esitab nende failide kohta taotluse.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Kulud</td>
                                        <td>Kasutaja ei pea maksma oma isikuandmetega seotud õiguste kasutamise eest, välja arvatud juhul, kui seadusest tulenevalt on tema teabele ligipääsu taotlus põhjendamatu või ülemäärane. Sellisel juhul võib töötleja nõuda kasutajalt konkreetsetel asjaoludel mõistlikku tasu. Vastutav töötleja teavitab kasutajat võimalikest tasudest enne päringu täitmist.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Ajakava</td>
                                        <td>Vastutava töötleja eesmärk on vastata kasutaja päringutele hiljemalt ühe (1) kuu jooksul alates nende saamisest, välja arvatud juhul, kui päring on äärmiselt keeruline või kasutaja on esitanud mitu päringut, mis puhul püüab vastutav töötleja vastata neile kolme kuu jooksul. Kui vastutav töötleja vajab ülaltoodud põhjustel rohkem aega kui üks kuu, teavitab ta sellest kasutajat. Vastutav töötleja võib kasutajalt küsida, kas ta soovib oma taotlust lähemalt selgitada või mis on täpsemalt tema mure. See aitab vastutaval töötlejal seoses kasutaja päringuga kiiremini tegutseda. Igal juhul peab kasutaja mainima konkreetseid ja tõeseid andmeid ja/või fakte, et vastutav töötleja saaks kasutaja taotlusele korrektselt vastata ja/või see rahuldada. Vastasel juhul jätab vastutav töötleja endale õiguse mitte vastutada vigade eest, mis ei ole tema kontrolli all. Lisaks võib vastutav töötleja tagasi lükata taotlused, mis on põhjendamatud, ülemäärased, kuritarvitavad, pahasoovlikud või õigusnormide mõttes ebaseaduslikud.
                                        </td>
                                    </tr>
                                </table>

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">7. Kuidas on tagatud andmete turvalisus?</h2>
                                <b>7.1</b> Vastutav töötleja rakendab isikuandmete kaitse ja konfidentsiaalsuse tagamiseks kõiki asjakohaseid turvameetmeid, mille hulka kuuluvad:
                                <br>
                                <ol>
                                    <li>tugevate salasõnade nõudmine kõigis serverites</li>
                                    <li>HTTPS-protokoll APIde ja veebiklientidega suhtlemiseks</li>
                                    <li>SSH-protokoll serveriga ühenduse loomiseks</li>
                                    <li>korralised serveriuuendused koos uusimate turvaparandustega</li>
                                </ol>

                                <br><br>
                                <b>7.2</b> Juhime tähelepanu, et kasutaja esitatud andmeid töötlevad ainult selleks konkreetselt volitatud töötajad, kes tegutsevad vastutava töötleja alluvuses ja ainult tema korraldusel, ning vajadusel andmete saajad. Vastutav töötleja valib töötlemiseks vastava kvalifikatsiooniga isikud, kellel on konfidentsiaalsuse tagamiseks piisav tehniline pädevus ja vajalikud isikuomadused.  Vastutav töötleja rakendab kõiki vajalikke turvameetmeid isikuandmete saladuse, konfidentsiaalsuse ja terviklikkuse kaitsmiseks, seda ka oma koostööpartneritele asjakohaseid lepingulisi kohustusi seades. Veebilehe turvalisus võib siiski saada kahjustatud põhjustel, mis ei ole vastutava töötleja kontrolli all, samuti tehnilise või muu võrguprobleemi, vääramatu jõu või juhuslike asjaolude tõttu.  Sel juhul ei saa tagada isikuandmete turvalisust.

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">8. Kes on andmete saajad?</h2>
                                <b>8.1</b> Kasutaja isikuandmete saajad on sidusettevõtted, kes pakuvad veebilehe toimimiseks tehnilist infrastruktuuri, hostingu pakkuja, ning ettevõte, kes kohustub edastama kasutajatele platvormi toimimisega seotud elektroonilist sidet.  Vajadusel ning vastavalt kehtivatele seadustele sõlmib vastutav töötleja selliste ettevõtetega lepingud turvameetmete rakendamiseks ja regulaarseks jälgimiseks. Kui andmeid edastatakse väljapoole ELi, peavad olema tagatud kõik vajalikud garantiid.
                                <br><br>
                                <b>8.2.</b> Kui vastutav töötleja saab taotluse andmed esitada või edastada seoses asjakohase haldusasutuse, advokaadi, kohtu või muu asutuse nõudmisega, võib ta need andmed esitada, et täita oma kohustust seoses avaliku huviga vastavalt asjakohastele õigussätetele (kasutajat eelnevalt teavitades või teavitamata jättes).  Kui kasutajat tuleb vastavalt seaduse sätetele eelnevalt teavitada, on kasutajal õigus selline andmete töötlemine vaidlustada, nagu on ära toodud artiklis 7.
                                <br><br>
                                <b>8.3.</b> Iga kasutaja ametialased andmed on ülalnimetatud eesmärkidel kättesaadavad kõigile platvormi registreeritud kasutajatele.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">9. Suhtlemine vastutava töötlejaga</h2>
                                <b>9.1.</b> Mistahes küsimuste korral seoses selle privaatsuseeskirjaga, kasutaja andmete töötlemisega või oma õiguste teostamisega, võib kasutaja ühendust võtta vastutava töötlejaga ühel järgmistest viisidest: <br>
                                tel: {{ config("app.installation_company_phone") }},<br>
                                e-post: {{ config("app.installation_company_email") }}
                                <br><br>
                                Kui kasutaja saab teada mistahes andmete rikkumise juhtumist, palutakse tal sellest viivitamatult vastutavat töötlejat teavitada.
                                <br><br>
                                <b>9.2.</b> Käesolevaid tingimusi reguleerivad ja täiendavad kasutustingimused ning need moodustavad koos ühtse teksti.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">10. Seosed teiste veebisaitidega/sotsiaalmeediaga</h2>
                                See veebisait loob hüperlinkide kaudu ühendusi teiste veebisaitidega. Need veebisaidid ei ole seotud töötleja veebisaidiga ning nende sisu ei ole vastutava töötleja poolt kontrollitud ega soovitatud.  Seega ei saa kontrollida nende sisu ja kasutaja isikuandmete töötlemise täpsust, õiguspärasust, täielikkust või kvaliteeti ning selle kohta ei anta mingit garantiid. Vastutav töötleja ei vastuta selle eest ega kahju eest, mis võib kasutajale tekkida nende veebisaitide külastamise tõttu või pärast seda.  Vastutav töötleja ei saa kontrollida kasutaja isikuandmete töötlemist nende lingitud veebisaitide poolt ja seega ei kanna ta mingit vastutust. Kui kasutaja neile veebisaitidele siseneb, peab ta arvestama, et igal veebisaidil kehtivad selle enda tingimused. Lingitud veebisaidi sisu või kasutamisega seotud probleemide korral peab kasutaja võtma otse ühendust selle veebisaidi operaatori või administraatoriga. Vastutav töötleja ei kiida heaks ega võta omaks lingitud veebisaitide sisu ega teenuseid, millele kasutaja veebisaidi kaudu ligi pääseb.
                                <br><br>
                                Veebisait annab kasutajale võimaluse omal algatusel ja tahtel sotsiaalmeediaga ühendusi luua ja seal suhelda. Sellisel juhul ei vastuta vastutav töötleja kasutaja andmete töötlemise eest sotsiaalmeedias või sotsiaalmeedia kaudu. Kasutaja peab oma seaduslike õiguste teostamiseks pöörduma otse iga konkreetse sotsiaalmeedia kanali poole.


                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">11. Küpsised</h2>
                                11.1. Platvorm kasutab küpsiseid selleks, et olla töökorras ja tõhusam, kasutaja navigeerimise parandamiseks, kasutajale platvormi võimaluste täielikumaks pakkumiseks, sisu õige kuvamise tagamiseks ning samuti analüütilistel ja statistilistel eesmärkidel.
                                <br><br>
                                11.2. Küpsised on väikesed tekstifailid, mis salvestatakse kasutaja arvutisse, kui ta külastab digitaalset platvormi, ja mida kasutatakse tema arvuti tuvastamise vahendina.
                                <br><br>
                                11.3. Küpsised, välja arvatud hädavajalikud küpsised, installitakse ainult juhul, kui kasutaja nõustub nende installimisega seda platvormi külastades. Platvormile sisenemisel küpsistega nõustudes kinnitab kasutaja sõnaselgelt, et ta on küpsiste installimise, funktsiooni ja eesmärgi kohta käivad konkreetsed tingimused läbi lugenud ja neist aru saanud ning annab nende kasutamiseks nõusoleku.
                                <br><br>
                                11.4. Teise võimalusena ei pruugi kasutaja küpsiseid lubada. Sellisel juhul paigaldatakse ainult platvormi tööks tehniliselt ja funktsionaalselt vajalikud küpsised.
                                <br><br>
                                11.5. Kasutaja saab igal ajal hallata küpsiste kasutamist ja paigaldamist paneeli kaudu, kus ta saab valida, millise kategooria küpsiseid ta lubab ja milliseid mitte (või taotleda ainult tehniliselt vajalike küpsiste paigaldamist).
                                <br><br>
                                11.6. Eelkõige kasutab platvorm järgmisi küpsiseid:
                                <br><br>

                                <table class="table table-striped table-responsive table-bordered">
                                    <tr>
                                        <th>Küpsiste liik</th>
                                        <th>Selgitus</th>
                                        <th>Küpsiste näited</th>
                                        <th>Küpsise paigaldamise kestus</th>
                                        <th>Andmete edastamine kolmandatele isikutele</th>
                                    </tr>
                                    <tr>
                                        <td>Hädavajalikud küpsised</td>
                                        <td>Hädavajalikud küpsised on platvormi nõuetekohaseks toimimiseks vältimatud. Need võimaldavad kasutajal sirvida ja kasutada platvormi funktsioone, nagu näiteks ligipääs turvalistele aladele. Need küpsised ei tunne ära kasutaja individuaalset identiteeti ja ilma nendeta ei ole platvormi tõrgeteta toimimine võimalik.
                                        </td>
                                        <td>crowdsourcing_app_cookies_consent_selection (salvestab kasutaja küpsistega nõustumise oleku praeguse domeeni jaoks)
                                            <br><br>
                                            crowdsourcing_app_cookies_consent_targeting (salvestab kasutaja küpsistega nõustumise oleku praeguse domeeni jaoks)
                                            <br><br>
                                            XSRF-TOKEN (tagab külastajatele sirvimise turvalisuse, takistades saidiüleste päringute võltsimist. See küpsis on oluline veebisaidi ja külastaja turvalisuse tagamiseks)
                                            <br><br>
                                            ecas_lets_crowdsource_our_future_session (Kui rakendus peab platvormil navigeerimise ajal sisselogitud kasutajat „mäletama“)

                                            <br><br>
                                            Crowdsourcing_anonymous_user_id (kasutatakse anonüümsete vastuste salvestamiseks küsimustikesse, määrates vastust esitavale kasutajale numbri)

                                        </td>
                                        <td>1 aasta
                                            <br><br>
                                            <br><br>
                                            1 päev
                                            <br><br>
                                            <br><br>
                                            Sessioon
                                            <br><br>
                                            <br><br>
                                            5 aastat
                                        </td>
                                        <td>Ei
                                            <br><br>
                                            <br><br>

                                            Ei
                                            <br><br>
                                            <br><br>

                                            Ei
                                            <br><br>
                                            <br><br>

                                            Ei
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Statistika/
                                            analüütilised küpsised
                                            </td>
                                        <td>Need on küpsised, mis hindavad, kuidas külastajad platvormi kasutavad (näiteks milliseid lehti külastatakse sagedamini ja kas nad saavad veebilehtedelt veateateid). Neid küpsiseid kasutatakse statistilistel eesmärkidel ja platvormi jõudluse parandamiseks.
                                        </td>
                                        <td>_ga_4S9N5MK4VE, _gat,_ga, _gcl_au, _gid: Google Analyticsi küpsiseid kasutatakse platvormil toimuva liikluse mõõtmiseks. Ainulaadne tekstistring salvestatakse, et tuvastada brauser, toimingute ajatempel ja kasutaja platvormile viinud brauser/lähteleht. Tundlikku teavet ei salvestata.

                                        </td>
                                        <td>_ga_4S9N5MK4VE: 2 aastat
                                            <br><br>
                                            _gat:1 minut
                                            <br><br>
                                            _ga:2 aastat
                                            <br><br>
                                            _gcl_au:3 kuud
                                            <br><br>
                                            _gid:24 tundi
                                        </td>
                                        <td>Jah (ettevõte, mis pakub statistika- ja analüüsiteenuseid, kui seda peetakse kolmandaks osapooleks)
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">12. Laste privaatsus  </h2>
                                Meie projekt ei ole suunatud alla 18-aastastele (edaspidi „lapsed“).  Me ei kogu teadlikult isikutuvastust võimaldavat teavet alla 18-aastastelt isikutelt. Kui oled lapsevanem või eestkostja ja tead, et sinu lapsed on meile isikuandmeid edastanud, võta meiega ühendust. Kui saame teada, et oleme kogunud lastelt isikuandmeid ilma vanema nõusolekuta, teeme kõik, et see teave oma serveritest eemaldada
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">13. Käesoleva privaatsuseeskirja muudatused </h2>
                                Vastutav töötleja jätab endale õiguse käesolevat privaatsuseeskirja muuta, näiteks kui see on vajalik kehtivate seaduste, juhiste või tehniliste nõudmistega kehtestatud uute nõuete täitmiseks, või kui vajadus tekib vastutava töötleja protsesside ja tavade ülevaatamise käigus. Kasutajat teavitatakse kõigist käesoleva privaatsuseeskirja muudatustest platvormi kaudu. Kasutaja peaks regulaarselt kontrollima, kas privaatsuseeskirjas on muudatusi tehtud.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
