@extends('home.layout')

@section('content')

    <div class="container pt-4 mb-2" style="margin-top: 100px">
        <div class="mb-5">
            <div class="row">
                <div class="col-12 mx-auto mb-3 text-center">
                    <h1>ΠΟΛΙΤΙΚΗ ΑΠΟΡΡΗΤΟΥ</h1>
                </div>
            </div>
            <div class="row">
                <div class="col mx-auto">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col">
                                Η παρούσα Πολιτική Απορρήτου ισχύει για όλους τους Χρήστες της Πλατφόρμας (στο εξης θα αναφέρονται σαν ο <b>“Χρήστης”</b> ή οι <b>“Χρήστες”</b> και <b>“Πλατφόρμα”</b> αντίστοιχα) και αποτελεί αναπόσπαστο μέρος των Όρων και Προϋποθέσεων του Ιστοτόπου της Πλατφόρμας. Η παρούσα Πολιτική Απορρήτου παρέχει στο Χρήστη γενικές πληροφορίες σχετικά με το πως ο Υπεύθυνος Επεξεργασίας Δεδομένων χρησιμοποιεί τα προσωπικά δεδομένα σας και άλλες πληροφορίες που απαιτούνται από τη νομοθεσία για την προστασία δεδομένων. Σε περίπτωση μελλοντικής τροποποίησης, οι απαραίτητες ενημερώσεις και πληροφορίες θα παρέχονται στο Χρήστη μέσω της ενημέρωσης της παρούσας Πολιτικής Απορρήτου, που θα βρίσκεται ανεβασμένη στην Πλατφόρμα.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">1. Ποιός είναι ο Υπεύθυνος Επεξεργασίας Δεδομένων;</h2>
                            </div>
                            <div class="col-12">
                                <b>1.1.</b> Η εταιρεία με την επωνυμία «{{ config("app.installation_company_name") }}», διεύθυνση: {{ config("app.installation_company_address") }}, Τηλέφωνο: {{ config("app.installation_company_phone") }}, email: {{ config("app.installation_company_email") }}, είναι ο Υπεύθυνος Επεξεργασίας Δεδομένων για τα Προσωπικά Δεδομένα του Χρήστη (στο εξης θα αναφέρεται <b>"Υπεύθυνος Επεξεργασίας Δεδομένων"</b>).
                                <br><br>
                                <b>1.2. Στοιχεία επικοινωνίας του Υπεύθυνου Επεξεργασίας Δεδομένων:</b> Για οποιοδήποτε πρόβλημα ή ανησυχία σχετικά με την παρούσα Πολιτική Απορρήτου και την επεξεργασία προσωπικών δεδομένων του Χρήστη ή δεδομένων που ανεβάστηκαν από το Χρήστη για να χρησιμοποιήσει την Πλατφόρμα, ο Χρήστης μπορεί να επικοινωνήσει με τον Υπεύθυνο Επεξεργασίας Δεδομένων, χρησιμοποιώντας ένα από τους ακόλουθους τρόπους:
                                <br><br>
                                Καλώντας στο {{ config("app.installation_company_phone") }}, από Δευτέρα εως Παρασκευή από τις 10:00 π.μ. εως τις 18:00 μ.μ. ΕΕΤ (Ώρα Ανατολικής Ευρώπης)<br>
                                Στέλνοντας ένα email στην ακόλουθη ηλεκτρονική διεύθυνση: {{ config("app.installation_company_email") }}<br>
                                Στέλνοντας αλληλογραφία στην ακόλουθη διεύθυνση: {{ config("app.installation_company_address") }}<br>

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">2. Ποιός είναι ο σκοπός και η νομική βάση για την επεξεργασία δεδομένων του Χρήστη;</h2>
                                <b>2.1.</b> Ο λειτουργικός σκοπός της Πλατφόρμας είναι να συλλέγει γνώμες Χρηστών μέσω ερωτηματολογίων. Οι γνώμες επεξεργάζονται ώστε να αποκτηθούν γνώσεις, να μαζευτούν και να παρουσιαστούν πολύτιμες ιδέες και προτάσεις πάνω στα θέματα που αναφέρονται στα ερωτηματολόγια. Οι Χρήστες μπορούν να απαντήσουν ανώνυμα (χωρίς να παρέχουν προσωπικές πληροφορίες) ή μπορούν να εγγραφούν εθελοντικά ώστε να υποβάλλουν επώνυμες απαντήσεις, δίνοντας μια ηλεκτρονική διεύθυνση και ένα ψευδώνυμο. Οι απαντήσεις των Χρηστών μεταφράζονται στα Αγγλικά και παρουσιάζονται σε Αναφορές. Για το συγκεκριμένο σκοπό της επεξεργασίας, η νομική βάση είναι η προηγούμενη συγκατάθεση του Χρήστη.
                                <br><br>
                                <b>2.2.</b> Για να στέλνονται στο Χρήστη ενημερωτικά email με σκοπό να τον ενημερώσουν σχετικά με νέες δραστηριότητες, έργα και άλλα θέματα ενδιαφέροντος στην Πλατφόρμα. Για αυτόν το σκοπό της επεξεργασίας, η νομική βάση είναι η προηγούμενη συγκατάθεση του Χρήστη.
                                <br><br>
                                <b>2.3</b> Επεξεργασία δεδομένων για λόγους που έχουν να κάνουν με συμμόρφωση με τις νομικές υποχρεώσεις του Υπεύθυνου Επεξεργασίας Δεδομένων. Σε τέτοιες περιπτώσεις η επεξεργασία δεδομένων λαμβάνει χώρα μόνο για την απαραίτητη χρονική περίοδο ώστε ο Υπεύθυνος Επεξεργασίας Δεδομένων να συμμορφωθεί στις υποχρεώσεις που επιβάλλονται από διάφορες νομικές διατάξεις.
                                <br><br>
                                <b>Σε περίπτωση των παραπάνω διατάξεων όπου η νομική βάση είναι η προηγούμενη συναίνεση του Χρήστη, ο Χρήστης μπορεί πάντα να πάρει πίσω τη συγκατάθεσή του οποιαδήποτε στιγμή χωρίς να επηρεάζεται η νομιμότητα των δεδομένων που βασίζονται στη συναίνεση πριν από την απόσυρσή τους.</b>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">3. Τύποι δεδομένων που συλλέγονται</h2>

                                <h3 class="mt-4 mb-4">3.1 Προσωπικά δεδομένα</h3>
                                <b>3.1.1 Εγγραφή – δημιουργία λογαριασμού:</b><br>
                                Για να δημιουργήσει ένας Χρήστης εθελοντικά λογαριασμό στην Πλατφόρμα, ο Χρήστης πρέπει να συμπληρώσει τα απαραίτητα στοιχεία: το ψευδώνυμό και την ηλεκτρονική διεύθυνση του κι έναν κωδικό πρόσβασης.
                                <br><br>
                                <b>3.1.2 Υποβεβλημένες απαντήσεις ερωτηματολογίου</b><br>
                                Η Πλατφόρμα συλλέγει απαντήσεις χρηστών (δηλαδή απόψεις πάνω σε διάφορα θέματα) σε ερωτήσεις οι οποίες τίθενται μέσω ερωτηματολογίων της Πλατφόρμας. Αυτές οι απαντήσεις αναλύονται και παρουσιάζονται στη σελίδα με τα αποτελέσματα του ερωτηματολογίου. Συστήνεται αυστηρά στο Χρήστη να συμμορφώνεται με τον «Κώδικα Δεοντολογίας για επιτυχή συμμετοχή» της Πλατφόρμας και να αποφύγει να αναρτήσει δημοσίως οποιαδήποτε προσωπικά δεδομένα τα οποία δεν επιθυμεί να είναι δημοσίως διαθέσιμα στην Πλατφόρμα.
                                <br><br>
                                <b>3.1.3. Επικοινωνία της Πλατφόρμας για λόγους σχετικούς με την επιτρεπτή χρήση της Πλατφόρμας από το Χρήστη</b>
                                <br>
                                Για να επικοινωνήσει η Πλατφόρμα με το Χρήστη για τους παραπάνω σκοπούς, ο Υπεύθυνος Επεξεργασίας Δεδομένων μπορεί να επεξεργαστεί όλα τα δεδομένα που έχουν σχέση με το λογαριασμό του Χρήστη, το ανεβασμένο περιεχόμενο και δεδομένα που έχουν σχέση με τη χρήση της Πλατφόρμας από το Χρήστη.

                                <h3 class="mt-4 mb-4">3.2 Δεδομένα χρήσης</h3>
                                Μπορεί επισης να συλλέξουμε πληροφορίες σχετικές με το πως γίνεται η πρόσβαση και η χρήση της ιστοσελίδας («Δεδομένα Χρήσης»). Αυτά τα Δεδομένα Χρήσης μπορεί να περιλαμβάνουν πληροφορίες όπως τη διεύθυνση πρωτοκόλλου Internet του υπολογιστή σας (IP address), τον τύπο φυλλομετρητή, τις σελίδες της ιστοσελίδας μας που επισκέπτεστε, την ώρα και ημερομηνία της επίσκεψής σας, το χρόνο που περνάτε σε αυτές τις σελίδες, μοναδικά αναγνωριστικά συσκευής και άλλα διαγνωστικά δεδομένα.


                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4"> 4. Πώς συλλέγει δεδομένα η Πλατφόρμα</h2>
                                4.1 Οι πληροφορίες μπορεί να συλλεχθούν με τους ακόλουθους τρόπους: <br>
                                4.1.1 Όταν ο Χρήστης κάνει εγγραφή και δημιουργεί λογαριασμό στην Πλατφόρμα. <br>
                                4.1.2 Όταν ο Χρήστης υποβάλλει απαντήσεις στα ερωτηματολόγια της Πλατφόρμας. <br>
                                4.1.3 Όταν ο Χρήστης επισκέπτεται την Πλατφόρμα και συμφωνεί στην εγκατάσταση cookies (σύμφωνα με την Πολιτική των Cookies της Πλατφόρμας στο άρθρο 11 παρακάτω) και η συλλογή των προσωπικών δεδομένων του Χρήστη όπως η διεύθυνση IP, το λειτουργικό σύστημα, τύπος και έκδοση φυλλομετρητή κλπ.
                                <br>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">5. Για πόσο αποθηκεύονται τα δεδομένα του Χρήστη και πότε διαγράφονται;</h2>
                                <b>5.1. Δεδομένα λογαριασμού του Χρήστη:</b><br>
                                Με την επιφύλαξη του δικαιώματος διαγραφής/κατάργησης του Χρήστη που αναφέρεται παρακάτω, τα δεδομένα που δίνονται και αποθηκεύονται στο λογαριασμό του Χρήστη θα αποθηκεύονται για όσο ο Χρήστης επιθυμεί να κάνει χρήση της Πλατφόρμας για το σκοπό που αναφέρεται παραπάνω. Σε περίπτωση που ένας Χρήσης θελήσει να διαγράψει το λογαριασμό του, μπορεί να τον διαγράψει μέσω των ρυθμίσεων του λογαριασμού ή επικοινωνώντας με τον Υπεύθυνο Επεξεργασίας Δεδομένων στα στοιχεία επικοινωνίας που αναφέρονται παραπάνω.
                                <br><br>
                                <b>5.2. Επικοινωνία της Πλατφόρμας για λόγους σχετικούς με την επιτρεπτή χρήση της Πλατφόρμας από το Χρήστη.</b><br>
                                Δεδομένα σχετικά με τέτοια επικοινωνία θα αποθηκεύονται μόνο για όσο ο Χρήστης επιθυμεί να κάνει χρήση της Πλατφόρμας και διατηρεί το λογαριασμό του. Σε περίπτωση που ένας Χρήστης θελήσει να διαγράψει το λογαριασμό του, μπορεί να τον διαγράψει μέσω των ρυθμίσεων του λογαριασμού ή επικοινωνώντας με τον Υπεύθυνο Επεξεργασίας Δεδομένων στα στοιχεία επικοινωνίας που αναφέρονται παραπάνω.
                                <br><br>
                                <b>5.3. Στατιστική ανάλυση για τη βελτιστοποίηση του Ιστοτόπου</b><br>
                                Ανεξάρτητα με τις παραπάνω διατάξεις που αναφέρονται στο άρθρο 5, ο Υπεύθυνος Επεξεργασίας Δεδομένων θα αποθηκεύει και θα επεξεργάζεται μόνο απαραίτητα δεδομένα για την περίοδο που απαιτείται για τη συμμόρφωσή του με τις υποχρεώσεις που επιβάλλει κάθε φορά ο νόμος (συμμόρφωση με φορολογικές υποχρεώσεις κλπ).
                                <br><br>
                                <b>5.4. Επεξεργασία προσωπικών δεδομένων για σκοπούς διεξαγωγής στατιστικής ανάλυσης.</b><br>
                                Παρακαλούμε δείτε την πολιτική cookies (άρθρο 11) παρακάτω.
                                <br><br>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">6. Ποιά είναι τα δικαιώματα του Χρήστη σχετικά με την επεξεργασία των δεδομένων του και πως μπορεί να ασκήσει αυτά τα δικαιώματα;</h2>
                                <b>6.1</b> Ο Υπεύθυνος Επεξεργασίας Δεδομένων σέβεται τα δικαιώματα του Χρήστη σχετικά με την επεξεργασία δεδομένων.
                                <br><br>
                                <b>6.2</b> Ο Χρήστης μπορεί να ασκήσει τα δικαιώματά του επικοινωνώντας με τον Υπεύθυνο Επεξεργασίας Δεδομένων στα ακόλουθα στοιχεία επικοινωνίας: Τηλέφωνο: {{ config("app.installation_company_phone") }}, Ηλ. διεύθυνση: {{ config("app.installation_company_email") }}
                                <br><br>
                                Για τη διευκόλυνση του Χρήστη, τα δικαιώματα του Χρήστη περιλαμβάνονται στον ακόλουθο πίνακα μαζί με μια σύντομη εξήγηση του κάθε δικαιώματος (η αναφορά σε άρθρα αντιστοιχεί στο άρθρο του GDPR 2016/679):
                                <br><br>
                                <table class="table table-striped table-responsive table-bordered">
                                    <tr>
                                        <th>Δικαίωμα </th>
                                        <th>Εξήγηση</th>
                                    </tr>
                                    <tr>
                                        <td>Πρόσβαση (άρθρο 15)</td>
                                        <td>
                                            Ο Χρήστης μπορεί να ζητήσει από τον Υπεύθυνο Επεξεργασίας Δεδομένων να:
                                            <ul>
                                                <li>επιβεβαιώσει αν ο Υπεύθυνος Επεξεργασίας Δεδομένων επεξεργάζεται προσωπικά δεδομένα                                                </li>
                                                <li>δώσει στο Χρήστη πρόσβαση σε δεδομένα που ο Χρήστης δεν διαθέτει</li>
                                                <li>δώσει στο Χρήστη άλλες πληροφορίες σχετικά με τα προσωπικά δεδομένα του Χρήστη όπως το ποια δεδομένα διαθέτει ο Υπεύθυνος Επεξεργασίας Δεδομένων, ποιοι είναι οι σκοποί της επεξεργασίας, σε ποιον διατίθενται αυτά τα δεδομένα, αν αυτά τα δεδομένα μεταφέρονται σε ξένες χώρες και πως προστατεύονται αυτά τα δεδομένα, για πόσο αποθηκεύονται τα δεδομένα, ποια είναι τα δικαιώματα του Χρήστη, πως μπορεί να υποβληθεί μια καταγγελία, από που πήραν αυτά τα δεδομένα στον βαθμό που αυτές οι πληροφορίες δεν περιλαμβάνονται στην παρούσα Πολιτική Απορρήτου.
                                                </li>
                                            </ul>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Διόρθωση (άρθρο 16)</td>
                                        <td>
                                            Ο Χρήστης μπορεί να ζητήσει τον Υπεύθυνο Επεξεργασίας Δεδομένων να διορθώσει ανακριβή προσωπικά δεδομένα.<br><br>
                                            Ο Υπεύθυνος Επεξεργασίας Δεδομένων μπορεί να επιδιώξει να επαληθεύσει την ακρίβεια των δεδομένων πριν τα διορθώσει.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Διαγραφή/κατάργηση (άρθρο 17)</td>
                                        <td>
                                            Ο Χρήστης μπορεί να ζητήσει από τον Υπεύθυνο Επεξεργασίας Δεδομένων να διαγράψει τα προσωπικά του δεδομένα:<br><br>
                                            <ul>
                                                <li>οποιαδήποτε στιγμή, όταν τα προσωπικά δεδομένα δεν είναι πια απαραίτητα για τους σκοπούς για τους οποίους είχαν συλλεχθεί
                                                </li>
                                                <li>όταν ο Χρήστης πάρει πίσω τη συναίνεσή του</li>
                                                <li>τα προσωπικά δεδομένα έχουν υποστεί παράνομη επεξεργασία</li>
                                            </ul>
                                            <br><br>
                                            Ο Υπεύθυνος Επεξεργασίας Δεδομένων δεν είναι αναγκασμένος να συμμορφωθεί με το αίτημα του Χρήστη να διαγράψει τα προσωπικά του δεδομένα, αν η επεξεργασία των προσωπικών δεδομένων του Χρήστη είναι απαραίτητη:
                                            <ul>
                                                <li>για συμμόρφωση σε κάποια νομική υποχρέωση</li>
                                                <li>για την εκπλήρωση άλλου θεμιτού σκοπού ή άλλης θεμιτής νομικής βάσης
                                                </li>
                                                <li>για τη θεμελίωση, άσκηση ή υπεράσπιση νομικών αξιώσεων</li>
                                            </ul>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Περιορισμός (άρθρο 18)</td>
                                        <td>

                                            Ο Χρήστης μπορεί να ζητήσει από τον Υπεύθυνο Επεξεργασίας Δεδομένων να περιορίσει (αποθήκευση, αλλά όχι επεξεργασία) τα προσωπικά δεδομένα του Χρήστη όταν:<br><br>
                                            η ακρίβειά τους αμφισβητείται (βλ. Διόρθωση), έτσι ώστε ο Υπεύθυνος Επεξεργασίας Δεδομένων να μπορέσει να επιβεβαιώσει την ακρίβεια των προσωπικών δεδομένων ή<br><br>
                                            τα προσωπικά δεδομένα έχουν επεξεργαστεί παράνομα, αλλά ο Χρήστης αντιτίθεται στη διαγραφή προσωπικών δεδομένων ή<br><br>
                                            δεν είναι πια απαραίτητα για τους σκοπούς που είχαν συλλεχθεί, αλλά ο Χρήστης τα χρειάζεται για τη θεμελίωση, άσκηση ή υπεράσπιση νομικών αξιώσεων ή αν υπάρχει κάποιος άλλος θεμιτός σκοπός για την επεξεργασία ή άλλη νομική βάση
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Φορητότητα δεδομένων (άρθρο 20)
                                        </td>
                                        <td>
                                            Όταν η επεξεργασία βασίζεται στη συναίνεση και η επεξεργασία διεξάγεται με αυτοματοποιημένα μέσα, ο Χρήστης μπορεί να ζητήσει από τον Υπεύθυνο Επεξεργασίας Δεδομένων να παραλάβει τα προσωπικά του δεδομένα σε μια δομημένη, ευρέως χρησιμοποιούμενη και αναγνώσιμη από μηχανή μορφή ή να ζητήσει από τον Υπεύθυνο Επεξεργασίας Δεδομένων να τα μεταβιβάσει σε κάποιον άλλο χειριστή κατευθείαν από τον Υπεύθυνο Επεξεργασίας Δεδομένων. Παρ 'όλα αυτά, σύμφωνα με το νόμο, αυτό το δικαίωμα αναφέρεται μόνο σε εκείνα τα δεδομένα που δώθηκαν απ’ τον ίδιο το Χρήστη και όχι σε εκείνα τα δεδομένα που συμπεραίνονται απο τον Υπεύθυνο Επεξεργασίας Δεδομένων βάση τον δεδομένων που παρέχονται από το Χρήστη.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Ένσταση (άρθρο 21)</td>
                                        <td>
                                            Ο Χρήστης μπορεί να κάνει ένσταση στην επεξεργασία προσωπικών δεδομένων που τον/την αφορουν τα οποία βασίζονται στο έννομο συμφέρον ή την εκτέλεση καθήκοντος που εκτελείται προς το δημόσιο συμφέρον.<br><br>
                                            Όταν ο Χρήστης ασκεί το δικαίωμά του να κάνει ένσταση, ο Υπεύθυνος Επεξεργασίας Δεδομένων έχει το δικαίωμα να επιδείξει επιτακτικούς νόμιμους λόγους για την επεξεργασία που υπερισχύουν των συμφερόντων, των δικαιωμάτων και της ελευθερίας του Χρήστη ή για τη θεμελίωση, άσκηση ή υπεράσπιση νομικών αξιώσεων.

                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Απόσυρση συναίνεσης (εξαίρεση)
                                        </td>
                                        <td>
                                            Ο Χρήστης έχει το δικαίωμα να αποσύρει τη συναίνεσή του εκεί που η συναίνεση αποτελεί βάση της επεξεργασίας. Η απόσυρση ισχύει για το μέλλον.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Εποπτική Αρχή
                                        </td>
                                        <td>
                                            Ο Χρήστης έχει το δικαίωμα να υποβάλλει καταγγελία στην τοπική εποπτική αρχή σχετική με την προστασία δεδομένων. <br><br>
                                            Στην Ελλάδα η εποπτική αρχή για την Προστασία δεδομένων είναι η Αρχή Προστασίας Δεδομένων https://www.dpa.gr/

                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Ταυτότητα</td>
                                        <td>Ο Υπεύθυνος Επεξεργασίας Δεδομένων παίρνει σοβαρά την εμπιστευτικότητα των εγγράφων που περιέχουν προσωπικά δεδομένα, γι’ αυτό κι έχει το δικαίωμα να ζητήσει από το Χρήστη απόδειξη της ταυτότητάς του αν ο Χρήστης υποβάλλει αίτημα σχετικά με αυτά τα έγγραφα.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Κόστος</td>
                                        <td>Ο Χρήστης δεν θα χρειαστεί να πληρώσει για την άσκηση των δικαιωμάτων του σχετικά με τα προσωπικά δεδομένα εκτός αν όπως προβλέπεται από το νόμο, το αίτημα να αποκτήσει πρόσβαση στις πληροφορίες είναι αβάσιμο ή υπερβολικό. Σε αυτή την περίπτωση ο Υπεύθυνος Επεξεργασίας Δεδομένων μπορεί να χρεώσει το Χρήστη μια λογική αμοιβή κάτω από τις συγκεκριμένες συνθήκες. Ο Υπεύθυνος Επεξεργασίας Δεδομένων θα ενημερώσει το Χρήστη για οποιαδήποτε τυχόν χρέωση πριν ολοκληρώσει το αίτημα.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Χρονοδιάγραμμα</td>
                                        <td>Ο Υπεύθυνος Επεξεργασίας Δεδομένων στοχεύει στο να απαντήσει στα βάσιμα αιτήματα του Χρήστη το αργότερο ένα (1) μήνα από τη στιγμή που τα δέχεται, εκτός αν το αίτημα είναι εξαιρετικά περίπλοκο ή ο Χρήστης έχει υποβάλλει πολλαπλά αιτήματα, στην οποία περίπτωση ο Υπεύθυνος Επεξεργασίας Δεδομένων στοχεύει στο να τα απαντήσει μέσα σε τρεις (3) μήνες. Σε περίπτωση που ο Υπεύθυνος Επεξεργασίας Δεδομένων χρειάζεται πάνω από ένα μήνα για τους προαναφερθέντες λόγους, θα ενημερώσει το Χρήστη. Ο Υπεύθυνος Επεξεργασίας Δεδομένων μπορεί να ρωτήσει το Χρήστη να θέλει να εξηγήσει τι ακριβώς θέλει να παραλάβει ή ποια είναι η ανησυχία του. Αυτό θα βοηθήσει τον Υπεύθυνο Επεξεργασίας Δεδομένων να δράσει πιο γρήγορα σε σχέση με το αίτημα του Χρήστη. Σε κάθε περίπτωση, ο Χρήστης θα έπρεπε να αναφέρει συγκεκριμένα και αληθή δεδομένα ή/και γεγονότα έτσι ώστε ο Υπεύθυνος Επεξεργασίας Δεδομένων να μπορέσει να απαντήσει ή/και να ικανοποιήσει το αίτημα του Χρήστη με ακρίβεια. Διαφορετικά, ο Υπεύθυνος Επεξεργασίας Δεδομένων επιφυλάσσεται του δικαιώματός του για τυχόν λάθη που είναι πέραν του ελέγχου του. Επιπλέον ο Υπεύθυνος Επεξεργασίας Δεδομένων μπορεί να απορρίψει αιτήματα που είναι αβάσιμα, υπερβολικά, καταχρηστικά, κακοπροαίρετα ή παράνομα στο πλαίσιο των νομοθετικών διατάξεων.
                                        </td>
                                    </tr>
                                </table>

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">7. Πώς προστατεύεται η ασφάλεια δεδομένων;</h2>
                                <b>7.1</b> Ο Υπεύθυνος Επεξεργασίας Δεδομένων εφαρμώζει όλα τα κατάλληλα μέτρα ασφάλειας για να εξασφαλίσει την προστασία και την εμπιστευτικότητα των προσωπικών δεδομένων ανάμεσα στα οποία περιλαμβάνονται και τα ακόλουθα:
                                <br>
                                <ol>
                                    <li>Ισχυρές πολιτικές κωδικών ασφαλείας σε όλους τους σέρβερ</li>
                                    <li>Πρωτόκολλα HTTPS για αλληλεπίδραση με API και πελάτες Ιστού</li>
                                    <li>Πρωτόκολλα SSH για σύνδεση διακομιστή</li>
                                    <li>Περιοδικές ενημερώσεις του σέρβερ με τις τελευταίες διορθώσεις ασφαλείας</li>
                                </ol>

                                <br><br>
                                <b>7.2</b> Επισημαίνεται πως μόνο ειδικά εξουσιοδοτημένοι υπάλληλοι του Υπεύθυνου Επεξεργασίας Δεδομένων, ενεργώντας υπό την εξουσία του Υπεύθυνου Επεξεργασίας Δεδομένων και μόνο καθ’ υπόδειξή του καθώς και αποδέκτες, όπου είναι απαραίτητο, χειρίζονται τα δεδομένα που υποβάλλει ο Χρήστης. Για την επεξεργασία, ο Υπεύθυνος Επεξεργασίας Δεδομένων επιλέγει άτομα με τις κατάλληλες πιστοποιήσεις που διαθέτουν επαρκείς διασφαλίσεις ως προς τις τεχνικές γνώσεις και προσωπική ακεραιότητα για να προστατεύσουν την εμπιστευτικότητα. Ο Υπεύθυνος Επεξεργασίας Δεδομένων επίσης παίρνει όλα τα απαραίτητα προστατευτικά μέτρα για την προστασία και τη διαφύλαξη της μυστικότητας, εμπιστευτικότητας και ακεραιότητας των προσωπικών δεδομένων μέσω σχετικών συμβατικών δεσμεύσεων των συνεργατών του. Σε οποιαδήποτε περίπτωση, η ασφάλεια της Ιστοσελίδας μπορεί να παραβιαστεί για λόγους που βρίσκονται εκτός της σφαίρας ελέγχου του Υπεύθυνου Επεξεργασίας Δεδομένων όπως και εξαιτίας τεχνικών ή άλλων προβλημάτων του δικτύου ή λόγω ανωτέρας βίας ή τυχαίων γεγονότων. Σε αυτή την περίπτωση, η ασφάλεια των προσωπικών δεδομένων δε μπορεί να εγγυηθεί.

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">8. Ποιοί είναι οι αποδέκτες των δεδομένων;</h2>
                                <b>8.1</b> Οι αποδέκτες των προσωπικών δεδομένων των Χρηστών είναι συνεργαζόμενες εταιρείες που παρέχουν τεχνική υποδομή για τη λειτουργία του Ιστοτόπου, ο πάροχος φιλοξενίας καθώς και η εταιρεία που αναλαμβάνει να στέλνει ηλεκτρονική επικοινωνία σχετικά με τη λειτουργία της Πλατφόρμας στους Χρήστες. Όπου είναι απαραίτητο σύμφωνα με τους ισχύοντες νόμους, ο Υπεύθυνος Επεξεργασίας Δεδομένων θα υπογράψει συμφωνίες με τέτοιες εταιρείες, οι οποίες αναφέρονται στην εφαρμογή και το συχνό έλεγχο των μέτρων ασφαλείας. Σε περίπτωση μεταφοράς δεδομένων εκτός ΕΕ υπάρχουν όλες οι απαραίτητες εγγυήσεις.
                                <br><br>
                                <b>8.2.</b> Σε περίπτωση που ο Υπεύθυνος Επεξεργασίας Δεδομένων λάβει αίτηση να κοινοποιήσει ή να μεταφέρει δεδομένα μετά από αίτημα της αρμόδιας Διοικητικής Αρχής, Εισαγγελέα, Δικαστηρίου ή άλλης Αρχής, μπορεί να κοινοποιήσει/μεταφέρει αυτά τα δεδομένα ώστε να εκπληρώσει το καθήκον του που εκτελείται υπέρ του δημοσίου συμφέροντος έναντι των αρχών αυτών (με ή χωρίς να ειδοποιήσει προηγουμένως το Χρήστη) σύμφωνα με τις κατάλληλες νομικές διατάξεις. Αν ο Χρήστης θα έπρεπε να ειδοποιηθεί προηγουμένως σύμφωνα με τις νομικές διατάξεις, τότε ο Χρήστης έχει το δικαίωμα να ενσταθεί σε αυτή την επεξεργασία όπως προβλέπεται στο άρθρο 7 παραπάνω.
                                <br><br>
                                <b>8.3.</b> Όσων αφορά τις επαγγελματικές λεπτομέρειες του κάθε Χρήστη, είναι διαθέσιμες σε όλους τους εγγεγραμμένους Χρήστες της Πλατφόρμας για τους σκοπούς που αναφέρθηκαν παραπάνω.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">9. Επικοινωνία με τον Υπεύθυνο Επεξεργασίας Δεδομένων</h2>
                                <b>9.1.</b> Για τυχόν θέματα σχετικά με την παρούσα πολιτική απορρήτου, την επεξεργασία των δεδομένων των Χρηστών όπως και για την άσκηση των δικαιωμάτων του Χρήστη, ο Χρήστης μπορεί να επικοινωνήσει με τον Υπεύθυνο Επεξεργασίας Δεδομένων με έναν από τους ακόλουθους τρόπους: <br>
                                Τηλέφωνο: {{ config("app.installation_company_phone") }}, <br>
                                Ηλ. Διεύθυνση: {{ config("app.installation_company_email") }}
                                <br><br>
                                Σε περίπτωση που ο Χρήστης αντιληφθεί οποιοδήποτε περιστατικό παραβίασης δεδομένων, παρακαλείται ευγενικά να ειδοποιήσει αμέσως τον Υπεύθυνο Επεξεργασίας Δεδομένων.
                                <br><br>
                                <b>9.2.</b> Αυτοί οι όροι διέπονται και συμπληρώνονται από τους Όρους και Προϋποθέσεις και μαζί τους αποτελούν ένα ενιαίο κείμενο.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">10. Σύνδεση με άλλους Ιστότοπους/κοινωνικά δίκτυα</h2>
                                Αυτός ο Ιστότοπος συνδέεται με άλλες ιστότοπους μέσω υπερσυνδέσμων. Αυτοί οι ιστότοποι δε σχετίζονται με τον Ιστότοπο του Υπεύθυνου Επεξεργασίας Δεδομένων και το περιεχόμενό τους δεν ελέγχεται ούτε συστήνεται από τον Υπεύθυνο Επεξεργασίας Δεδομένων. Έτσι, η ακρίβεια, νομιμότητα, πληρότητα ή ποιότητα του περιεχομένου τους και η νομιμότητα της επεξεργασίας των προσωπικών δεδομένων του Χρήστη δε μπορεί να ελεγχθεί και δεν τους παρέχεται καμία εγγύηση. Ο Υπεύθυνος Επεξεργασίας Δεδομένων δε μπορεί να θεωρηθεί υπεύθυνος για αυτούς ή για τυχόν ζημιές που μπορεί να προκληθούν στο Χρήστη λόγω ή μετά τη χρήση τους. Ο Υπεύθυνος Επεξεργασίας Δεδομένων δε μπορεί να ελέγξει την επεξεργασία των προσωπικών δεδομένων του Χρήστη από αυτούς τους συνδεδεμένους ιστότοπους και συνεπώς δε φέρει καμία ευθύνη. Όταν ο Χρήστης έχει πρόσβαση σε αυτούς τους ιστοτόπους, θα πρέπει να λαμβάνει υπόψη του ότι ισχύουν οι όροι και προϋποθέσεις κάθε ιστοτόπου. Για το όποιο θέμα που μπορεί να προκύψει ως προς το περιεχόμενο ή τη χρήση του συνδεδεμένου ιστότοπου, ο Χρήστης θα έπρεπε να επικοινωνήσει κατευθείαν με το χειριστή ή το διαχειριστή του κάθε ιστοτόπου. Ο Υπεύθυνος Επεξεργασίας Δεδομένων δεν εγκρίνει ούτε ενστερνίζεται το Περιεχόμενο ή τις υπηρεσίες των συνδεδεμένων ιστότοπων, στους οποίους έχει πρόσβαση ο Χρήστης μέσα από τον Ιστότοπο.<br><br>
                                Ο Ιστότοπος δίνει στο Χρήστη τη δυνατότητα να συνδεθεί και να αλληλεπιδράσει με τα κοινωνικά δίκτυα μετά από δική του πρωτοβουλία και θέληση. Σε αυτή την περίπτωση, ο Υπεύθυνος Επεξεργασίας Δεδομένων δεν είναι υπεύθυνος για την επεξεργασία των δεδομένων του Χρήστη που λαμβάνει χώρα μέσα ή από τα κοινωνικά δίκτυα. Ο Χρήστης θα πρέπει να έχει πρόσβαση κατευθείαν σε κάθε κοινωνικό δίκτυο για να ασκήσει τα νομικά του δικαιώματα.


                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">11. Cookies</h2>
                                11.1. Η Πλατφόρμα χρησιμοποιεί cookies για να είναι λειτουργική ή πιο αποτελεσματική στη λειτουργία της, για να βελτιώσει την πλοήγηση του Χρήστη, για να παρέχει στο Χρήστη το πλήρες δυναμικό της Πλατφόρμας, για να εξασφαλίσει τη σωστή προβολή του περιεχομένου καθώς και για αναλυτικούς και στατιστικούς σκοπούς.
                                <br><br>
                                11.2. Τα cookies είναι μικρά αρχεία κειμένου που αποθηκεύονται στον υπολογιστή του Χρήστη όταν εκείνος επισκέπτεται μια ψηφιακή πλατφόρμα, που χρησιμοποιούνται σαν ένας τρόπος αναγνώρισης του υπολογιστή του.
                                <br><br>
                                11.3. Τα cookies, εκτός από απολύτως απαραίτητα cookies, εγκαθίστανται μόνο αν ο Χρήστης αποδεχτεί την εγκατάστασή τους όταν επισκέπτεται αυτή την Πλατφόρμα. Αποδεχόμενος τα cookies όταν μπαίνει σε αυτή την Πλατφόρμα, ο Χρήστης αναφέρει ρητά πως έχει διαβάσει και καταλάβει τους συγκεκριμένους όρους και προϋποθέσεις σχετικά με την εγκατάσταση, λειτουργία και σκοπό των cookies και πως παρέχει τη συναίνεσή του για τη χρήση τους.
                                <br><br>
                                11.4. Εναλλακτικά, ο Χρήστης μπορεί να μη δεχθεί τα cookies. Σε αυτή την περίπτωση, θα εγκαθίστανται μόνο cookies που είναι τεχνικά και λειτουργικά απαραίτητα για τη λειτουργία της Πλατφόρμας.
                                <br><br>
                                11.5. Ο Χρήστης μπορεί να διαχειρίζεται τη χρήση και την εγκατάσταση των cookies οποιαδήποτε στιγμή μέσω ενός πίνακα, όπου μπορεί να επιλέξει ποια κατηγορία cookies θέλει να αποδεχτεί και ποιες όχι (ή να αιτηθεί να εγκατασταθούν μόνο τα τεχνικώς απαραίτητα cookies).
                                <br><br>
                                11.6. Συγκεκριμένα, τα cookies που χρησιμοποιούνται από την Πλατφόρμα είναι τα ακόλουθα:
                                <br><br>

                                <table class="table table-striped table-responsive table-bordered">
                                    <tr>
                                        <th>Τύπος cookies</th>
                                        <th>Εξήγηση</th>
                                        <th>Παραδείγματα cookies</th>
                                        <th>Διάρκεια εγκατάστασης κάθε cookie</th>
                                        <th>Μεταφορά δεδομένων σε τρίτα πρόσωπα</th>
                                    </tr>
                                    <tr>
                                        <td>Απολύτως απαραίτητα Cookies</td>
                                        <td>Τα απολύτως απαραίτητα cookies είναι καθοριστικής σημασίας για τη λειτουργία της Πλατφόρμας. Αυτά τα cookies επιτρέπουν στο Χρήστη να περιηγείται και να χρησιμοποιήσει λειτουργίες της Πλατφόρμας όπως η πρόσβαση σε ασφαλείς περιοχές. Αυτά τα cookies δεν αναγνωρίζουν την ατομική ταυτότητα του Χρήστη και χωρίς αυτά, δε θα ήταν δυνατή η ομαλή λειτουργία της Πλατφόρμας.
                                            Αυτά είναι cookies που αξιολογούν τον τρόπο με τον οποίο χρησιμοποιούν την Πλατφόρμα οι επισκέπτες (π.χ. ποιες σελίδες επισκέπτονται πιο συχνά οι χρήστες και αν λαμβάνουν μηνύματα σφάλματος από τις ιστοσελίδες). Αυτά τα cookies χρησιμοποιούνται για στατιστικούς σκοπούς και για να βελτιωθεί η επίδοση μιας πλατφόρμας.
                                        </td>
                                        <td>crowdsourcing_app_cookies_consent_selection (Αποθηκεύει την κατάσταση συναίνεσης cookie του χρήστη για το συγκεκριμένο τομέα)
                                            <br><br>
                                            crowdsourcing_app_cookies_consent_targeting (Αποθηκεύει την κατάσταση συναίνεσης cookie του χρήστη για το συγκεκριμένο τομέα)
                                            <br><br>
                                            XSRF-TOKEN (Εξασφαλίζει την ασφάλεια περιήγησης του επισκέπτη αποτρέποντας την πλαστογραφία αιτήματος μεταξύ ιστοτόπων. Αυτό το cookie είναι καθοριστικό για την ασφάλεια του ιστοτόπου και του επισκέπτη)
                                            <br><br>
                                            ecas_lets_crowdsource_our_future_session (Όταν η εφαρμογή πρέπει να ‘θυμάται’ τους συνδεδεμένους χρήστες όσο αυτοί περιηγούνται στην Πλατφόρμα)
                                            <br><br>
                                            Crowdsourcing_anonymous_user_id (χρησιμοποιήται για να αποθηκεύσει ανώνυμες απαντήσεις στα ερωτηματολόγια αναθέτοντας έναν ακέραιο αριθμό στο χρήστη που υποβάλλει την απάντηση)
                                        </td>
                                        <td>1 χρόνο
                                            <br><br>
                                            <br><br>
                                            1 μέρα
                                            <br><br>
                                            <br><br>
                                            Συνεδρία
                                            <br><br>
                                            <br><br>
                                            5 χρόνια
                                        </td>
                                        <td>Όχι
                                            <br><br>
                                            <br><br>

                                            Όχι
                                            <br><br>
                                            <br><br>

                                            Όχι
                                            <br><br>
                                            <br><br>

                                            Όχι
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Στατιστικά / αναλυτικά Cookies</td>
                                        <td>Αυτά είναι cookies που αξιολογούν τον τρόπο με τον οποίο χρησιμοποιούν την Πλατφόρμα οι επισκέπτες (π.χ. ποιες σελίδες επισκέπτονται πιο συχνά οι χρήστες και αν λαμβάνουν μηνύματα σφάλματος από τις ιστοσελίδες). Αυτά τα cookies χρησιμοποιούνται για στατιστικούς σκοπούς και για να βελτιωθεί η επίδοση μιας πλατφόρμας.
                                        </td>
                                        <td>_ga_4S9N5MK4VE, _gat,_ga, _gcl_au, _gid: Τα cookies της Google Analytics χρησιμοποιούνται για να μετρηθεί η κυκλοφορία στην Πλατφόρμα. Αποθηκεύεται μια μοναδική συμβολοσειρά κειμένου  για να αναγνωρίσει το φυλλομετρητή, τη χρονική σήμανση για αλληλεπιδράσεις και το φυλλομετρητή/σελίδα-πηγή που οδήγησε το χρήστη στην Πλατφόρμα. Δεν αποθηκεύεται καμία ευαίσθητη πληροφορία.

                                        </td>
                                        <td>_ga_4S9N5MK4VE:	 2 χρόνια
                                            <br><br>
                                            _gat: 1 λεπτό
                                            <br><br>
                                            _ga: 2 χρόνια
                                            <br><br>
                                            _gcl_au: 3 μήνες
                                            <br><br>
                                            _gid: 24 ώρες
                                        </td>
                                        <td>Ναι (Εταιρεία που παρέχει στατιστικές και αναλυτικές υπηρεσίες αν θεωρηθεί τρίτο πρόσωπο)
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">12. Παιδικό απόρρητο</h2>
                                Το έργο μας δεν απευθύνεται σε κανέναν κάτω της ηλικίας των 18 ετών (‘Παιδιά’). Δεν συλλέγουμε εν γνώση μας στοιχεία προσωπικής ταυτοποίησης από κανέναν κάτω της ηλικίας των 18. Αν είστε γονέας ή κηδεμόνας και γνωρίζετε πως τα Παιδιά σας μας έχουν προμηθεύσει με Προσωπικά Δεδομένα, παρακαλούμε επικοινωνήστε μαζί μας. Αν αντιληφθούμε πως έχουμε συλλέξει Προσωπικά Δεδομένα από παιδιά χωρίς επιβεβαίωση γονικής συναίνεσης, προβαίνουμε σε ενέργειες για να αφαιρέσουμε αυτά τα στοιχεία από τους σέρβερ μας.


                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">13. Τροποποιήσεις στην παρούσα Πολιτική Απορρήτου</h2>
                                Ο Υπεύθυνος Επεξεργασίας Δεδομένων διατηρεί το δικαίωμα να τροποποιήσει την παρούσα Πολιτική Απορρήτου, για παράδειγμα όταν αυτό είναι απαραίτητο για τη συμμόρφωση με νέες απαιτήσεις που επιβάλλονται από την ισχύουσα νομοθεσία, τις κατευθυντήριες γραμμές ή τις τεχνικές απαιτήσεις, ή κατά τη διάρκεια αναθεώρησης των διαδικασιών και πρακτικών του Υπεύθυνου Επεξεργασίας Δεδομένων. Ο Χρήστης θα ειδοποιηθεί για οποιαδήποτε τροποποίηση σε αυτή την Πολιτική Απορρήτου μέσω της Πλατφόρμας. Ο Χρήστης θα πρέπει να ελέγχει συχνά αυτή την Πολιτική Απορρήτου για τυχόν τροποποιήσεις.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
