@extends('home.layout')

@section('content')

    <div class="container pt-4 mb-2" style="margin-top: 100px">
        <div class="mb-5">
            <div class="row">
                <div class="col-12 mx-auto mb-3 text-center">
                    <h1>DATENSCHUTZRICHTLINIE</h1>
                </div>
            </div>
            <div class="row">
                <div class="col mx-auto">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col">
                                Die vorliegende Datenschutzerklärung gilt für alle Nutzer*innen der Plattform (im Folgenden als <b>“Nutzer*innen”</b> oder <b>“Nutzer*in”</b> bzw. <b>“Plattform”</b> bezeichnet) und ist integraler Bestandteil der Allgemeinen Geschäftsbedingungen für die Website der Plattform. Die vorliegende Datenschutzerklärung bietet Nutzer*innen allgemeine Informationen darüber, wie Datenverantwortliche Ihre personenbezogenen Daten verwenden, sowie weitere Informationen, die von der Datenschutzgesetzgebung gefordert werden. Im Falle künftiger Änderungen werden Nutzer*innen die erforderlichen Aktualisierungen und Informationen durch die Aktualisierung der vorliegenden Datenschutzrichtlinie, die auf der Plattform hochgeladen wird, zur Verfügung gestellt.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">1. Wer ist für die Datenverarbeitung verantwortlich?</h2>
                            </div>
                            <div class="col-12">
                                <b>1.1.</b> Die Gesellschaft mit dem Firmennamen "{{ config("app.installation_company_name") }}", Adresse: {{ config("app.installation_company_address") }} , Telefon: {{ config("app.installation_company_phone") }}, E-Mail:
                                {{ config("app.installation_company_email") }}, ist die für die Verarbeitung der personenbezogenen Daten der Nutzer*innen verantwortliche Stelle (im Folgenden als <b>"für die Datenverarbeitung verantwortliche Stelle"</b> bezeichnet).
                                <br><br>
                                <b>1.2. Kontaktinformationen der für die Datenverarbeitung verantwortlichen Stelle:</b> Bei Fragen oder Bedenken in Bezug auf die vorliegende Datenschutzrichtlinie und die Verarbeitung der personenbezogenen Daten der Nutzer*innen oder von den Nutzer*innen zur Nutzung der Plattform hochgeladenen Daten kann mit der für die Datenverarbeitung verantwortlichen Stelle auf eine der folgenden Arten Kontakt aufgenommen werden:
                                <br><br>
                                Per Telefon unter {{ config("app.installation_company_phone") }}, von Montag bis Freitag von 10.00 Uhr bis 18.00 Uhr EET (Osteuropäische Zeit)<br>
                                Per E-Mail an die folgende Adresse: {{ config("app.installation_company_email") }}<br>
                                Per Post an die folgende Adresse: {{ config("app.installation_company_address") }}<br>

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">2. Was ist der Zweck und die Rechtsgrundlage für die Datenverarbeitung der Nutzer*innen?</h2>
                                <b>2.1.</b> Der Zweck der Plattform besteht darin, die Meinungen der Nutzer*innen über Fragebögen zu sammeln. Die Meinungen werden ausgewertet, um Erkenntnisse zu gewinnen, wertvolle Ideen und Vorschläge zu den in den Fragebögen angesprochenen Themen zu sammeln und zu präsentieren. Die Nutzer*innen können anonym antworten (ohne Angabe personenbezogener Daten) oder sich freiwillig registrieren, um unter Angabe einer E-Mail-Adresse und eines Spitznamens anonym zu antworten. Die Antworten der Nutzer*innen werden ins Englische übersetzt und in Form von Berichten präsentiert. Die Rechtsgrundlage für den spezifischen Zweck der Verarbeitung ist die vorherige Zustimmung der Nutzer*innen.
                                <br><br>
                                <b>2.2.</b> Versand von Informations-E-Mails an die Nutzer*innen mit dem Ziel, diese über neue Aktivitäten, Projekte und andere Themen von Interesse für die Plattform zu informieren. Die Rechtsgrundlage für diesen Zweck der Verarbeitung ist die vorherige Zustimmung der Nutzer*innen.
                                <br><br>
                                <b>2.3</b> Verarbeitung von Daten aus Gründen, die mit der Erfüllung rechtlicher Verpflichtungen der für die Datenverarbeitung verantwortlichen Stelle zusammenhängen. In solchen Fällen erfolgt die Verarbeitung der Daten nur für den Zeitraum, der erforderlich ist, damit die für die Datenverarbeitung verantwortliche Stelle ihren durch verschiedene Rechtsvorschriften auferlegten Verpflichtungen nachkommen kann.
                                <br><br>
                                <b>Im Falle der oben genannten Bestimmungen, deren Rechtsgrundlage die vorherige Einwilligung der Nutzer*innen ist, können die Nutzer*innen die jeweilige Einwilligung jederzeit widerrufen, ohne dass die Rechtmäßigkeit der auf der Einwilligung beruhenden Daten vor ihrem Widerruf berührt wird.</b>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">3. Arten der erhobenen Daten</h2>

                                <h3 class="mt-4 mb-4">3.1 Personenbezogene Daten</h3>
                                <b>3.1.1 Registrierung - Erstellung eines Kontos:</b><br>
                                Damit die Nutzer*innen freiwillig ein Konto auf der Plattform erstellen können, müssen sie die erforderlichen Daten eingeben: ihren Nickname, ihre E-Mail-Adresse und ein Passwort.
                                <br><br>
                                <b>3.1.2 Antworten auf Fragebögen</b><br>
                                Die Plattform sammelt die Antworten der Nutzer*innen (d.h. Meinungen zu verschiedenen Themen) auf Fragen, die über die Fragebögen der Plattform gestellt werden. Diese Antworten werden analysiert und auf einer Ergebnisseite des Fragebogens dargestellt. Den Nutzer*innen wird dringend empfohlen, sich an den "Verhaltenskodex für eine erfolgreiche Teilnahme" der Plattform zu halten und keine persönlichen Daten zu veröffentlichen, die nicht auf der Plattform öffentlich zugänglich sein sollen.
                                <br><br>
                                <b>3.1.3. Kommunikation der Plattform aus Gründen, die mit der erlaubten Nutzung der Plattform durch die Nutzer*innen zusammenhängen.</b>
                                <br>
                                Damit die Plattform mit den Nutzer*innen zu den oben genannten Zwecken kommunizieren kann, kann die für die Datenverarbeitung verantwortliche Stelle alle Daten verarbeiten, die sich auf das Konto der Nutzer*innen, die hochgeladenen Inhalte und die Daten im Zusammenhang mit der Nutzung der Plattform durch die Nutzer*innen beziehen.

                                <h3 class="mt-4 mb-4">3.2 Nutzungsdaten</h3>
                                Wir können auch Informationen darüber sammeln, wie auf die Webseite zugegriffen und sie genutzt wird ("Nutzungsdaten"). Diese Nutzungsdaten können Informationen wie die Internetprotokolladresse Ihres Computers (z. B. IP-Adresse), den Browsertyp, die Browserversion, die von Ihnen besuchten Seiten unserer Website, die Uhrzeit und das Datum Ihres Besuchs, die auf diesen Seiten verbrachte Zeit, eindeutige Gerätekennungen und andere Diagnosedaten umfassen.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4"> 4. Wie die Plattform Daten sammelt</h2>
                                4.1 Die Informationen können auf die folgenden Arten gesammelt werden: <br>
                                4.1.1 Wenn die Nutzer*innen sich auf der Plattform registrieren und ein Konto erstellen. <br>
                                4.1.2 Wenn die Nutzer*innen Antworten auf die Fragebögen der Plattform übermitteln. <br>
                                4.1.3 Wenn die Nutzer*innen die Plattform besuchen und der Installation von Cookies (gemäß der Cookie-Richtlinie der Plattform in Artikel 11 unten) und der Erfassung der persönlichen Daten der Nutzer wie IP-Adresse, Betriebssystem, Browsertyp und -version usw. zustimmen
                                <br>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">5. Wie lange werden die Daten der Nutzer*innen gespeichert und wann werden sie gelöscht?</h2>
                                <b>5.1. Kontodaten der Nutzer*innen:</b><br>
                                Ungeachtet des unten erwähnten Rechts der Nutzer*innen auf Löschung/Löschung werden die im Nutzer*innenkonto registrierten und gespeicherten Daten so lange gespeichert, wie der/die Nutzer*in die Plattform für den oben genannten Zweck nutzen möchte. Möchten Nutzer*innen ihr Konto löschen, können sie dies über die Kontoeinstellungen tun oder sich an die oben genannten Kontaktdaten der für die Datenverarbeitung verantwortlichen Stelle wenden.
                                <br><br>
                                <b>5.2.</b> Kommunikation der Plattform aus Gründen, die mit der erlaubten Nutzung der Plattform durch die Nutzer*innen zusammenhängen.</b><br>
                                Daten im Zusammenhang mit solchen Mitteilungen werden nur so lange gespeichert, wie die Nutzer*innen die Plattform nutzen möchten und ihr Konto aufrechterhalten. Falls Nutzer*innen ihr Konto löschen möchte, können sie dies über die Kontoeinstellungen tun oder sich an die oben genannten Kontaktdaten der für die Datenverarbeitung verantwortlichen Stelle wenden.
                                <br><br>
                                <b>5.3.</b> Statistische Analyse zur Optimierung der Website Ungeachtet der oben genannten Bestimmungen von Artikel 5 speichert und verarbeitet die verantwortliche Stelle nur die notwendigen Daten für den Zeitraum, der erforderlich ist, um ihren jeweiligen gesetzlichen Verpflichtungen nachzukommen (Erfüllung der steuerlichen Pflichten usw.).
                                <br><br>
                                <b>5.4. Verarbeitung personenbezogener Daten zum Zweck der Durchführung statistischer Analysen.</b><br>
                                Siehe die Cookie-Richtlinie (Artikel 11) unten.
                                <br><br>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">6. Welche Rechte haben die Nutzer*innen in Bezug auf die Verarbeitung ihrer Daten und wie können sie diese Rechte ausüben?</h2>
                                <b>6.1</b> Die für die Datenverarbeitung verantwortliche Stelle respektiert die Rechte der Nutzer*innen in Bezug auf die Datenverarbeitung.
                                <br><br>
                                <b>6.2</b> Die Nutzer*innen können ihre Rechte ausüben, indem sie sich an die für die Datenverarbeitung verantwortliche Stelle unter den folgenden Kontaktdaten wenden: Telefon: {{ config("app.installation_company_phone") }}, E-Mail: {{ config("app.installation_company_email") }}
                                <br><br>
                                Zur Erleichterung für die Nutzer*innen sind ihre Rechte in der folgenden Tabelle zusammen mit einer kurzen Erläuterung der einzelnen Rechte aufgeführt (die Verweise auf die Artikel entsprechen den Artikeln der DSGVO 2016/679):
                                <br><br>
                                <table class="table table-striped table-responsive table-bordered">
                                    <tr>
                                        <th>Recht</th>
                                        <th>Erläuterung</th>
                                    </tr>
                                    <tr>
                                        <td>Zugang (Artikel 15)</td>
                                        <td>
                                            Die Nutzer*innen können den Datenverantwortlichen um Folgendes bitten:
                                            <ul>
                                                <li>zu bestätigen, dass die verantwortliche Stelle die personenbezogenen Daten der Nutzer*innen verarbeitet diesen Zugang zu den Daten zu gewähren, über die die Nutzer*innen nicht verfügen
                                                </li>
                                                <li>den Nutzer*innen andere Informationen über die personenbezogenen Daten der Nutzer*innen zu geben, wie z.B. über welche Daten die verantwortliche Stelle verfügt, zu welchen Zwecken diese verarbeitet werden, an wen diese Daten weitergegeben werden, ob diese Daten ins Ausland übermittelt werden und wie diese Daten geschützt werden, wie lange die Daten gespeichert werden, welche Rechte die Nutzer*innen haben, wie eine Beschwerde eingereicht werden kann, woher die Daten stammen, soweit diese Informationen nicht in der vorliegenden Datenschutzerklärung enthalten sind.
                                                </li>
                                            </ul>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Berichtigung (Artikel 16)</td>
                                        <td>
                                            Die Nutzer*innen können die für die Datenverarbeitung verantwortliche Stelle auffordern, unrichtige personenbezogene Daten zu berichtigen.<br><br>
                                            Die für die Datenverarbeitung verantwortliche Stelle kann versuchen, die Richtigkeit der Daten zu überprüfen, bevor sie sie berichtigt.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Entfernung/Löschung (Artikel 17)</td>
                                        <td>
                                            Die Nutzer*innen können die für die Datenverarbeitung verantwortliche Stelle auffordern, ihre personenbezogenen Daten zu löschen:<br><br>
                                            <ul>
                                                <li>immer dann, wenn die personenbezogenen Daten für die Zwecke, für die sie erhoben wurden, nicht mehr benötigt werden
                                                </li>
                                                <li>wenn die Nutzer*innen ihre Einwilligung widerrufen</li>
                                                <li>wenn die personenbezogenen Daten unrechtmäßig verarbeitet worden sind</li>
                                            </ul>
                                            <br><br>
                                            Die verantwortliche Stelle ist nicht verpflichtet, dem Antrag der Nutzer*innen auf Löschung ihrer personenbezogenen Daten nachzukommen, wenn die Verarbeitung der personenbezogenen Daten der Nutzer*innen erforderlich ist:
                                            <ul>
                                                <li>zur Erfüllung einer rechtlichen Verpflichtung</li>
                                                <li>zur Erfüllung eines anderen legitimen Zwecks oder einer anderen legitimen Rechtsgrundlage
                                                </li>
                                                <li>zur Begründung, Ausübung oder Verteidigung von Rechtsansprüchen</li>
                                            </ul>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Beschränkung (Artikel 18)</td>
                                        <td>
                                            Die Nutzer*innen können die für die Datenverarbeitung verantwortliche Stelle bitten, die personenbezogenen Daten der Nutzer*innen einzuschränken (zu speichern, aber nicht zu verarbeiten), wenn:<br><br>
                                            ihre Richtigkeit bestritten wird (siehe Berichtigung), so dass die für die Datenverarbeitung verantwortliche Stelle die Richtigkeit der personenbezogenen Daten überprüfen kann, oder<br><br>
                                            die personenbezogenen Daten unrechtmäßig verarbeitet wurden, aber die Nutzer*innen die Löschung der personenbezogenen Daten ablehnen oder<br><br>
                                            die Daten für die Zwecke, für die sie erhoben wurden, nicht mehr erforderlich sind, die Nutzer*innen sie aber noch zur Geltendmachung, Ausübung oder Verteidigung von Rechtsansprüchen benötigen oder ein anderer legitimer Zweck für die Verarbeitung oder eine andere Rechtsgrundlage vorliegt
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Datenübertragbarkeit (Artikel 20)
                                        </td>
                                        <td>
                                            Wenn die Verarbeitung auf der Grundlage einer Einwilligung erfolgt und die Verarbeitung mit automatisierten Mitteln durchgeführt wird, können die Nutzer*innen von der für die Datenverarbeitung verantwortlichen Stelle verlangen, dass sie ihre personenbezogenen Daten in einem strukturierten, gängigen und maschinenlesbaren Format erhalten oder dass die für die Datenverarbeitung verantwortliche Stelle sie direkt von der für die Datenverarbeitung verantwortlichen Stelle an eine andere Stelle übermittelt. Nach dem Gesetz bezieht sich dieses Recht jedoch nur auf die Daten, die durch die Nutzer*innen selbst angegeben wurden, und nicht auf die Daten, die von der für die Datenverarbeitung verantwortlichen Stelle auf der Grundlage der von den Nutzer*innen angegebenen Daten abgeleitet werden.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Widerspruch (Artikel 21)</td>
                                        <td>
                                            Die Nutzer*innen können jederzeit Widerspruch gegen die Verarbeitung sie betreffender personenbezogener Daten einlegen, die auf einem berechtigten Interesse oder der Wahrnehmung einer Aufgabe im öffentlichen Interesse beruht.<br><br>
                                            Machen die Nutzer*innen von ihrem Widerspruchsrecht Gebrauch, hat die für die Datenverarbeitung verantwortliche Stelle das Recht, zwingende schutzwürdige Gründe für die Verarbeitung nachzuweisen, die die Interessen, Rechte und Freiheiten der Nutzer*innen oder die Geltendmachung, Ausübung oder Verteidigung von Rechtsansprüchen überwiegen.

                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Widerruf der Zustimmung (Opt-out)
                                        </td>
                                        <td>
                                            Die Nutzer*innen haben das Recht, ihre Einwilligung zu widerrufen, wenn die Einwilligung die Grundlage für die Verarbeitung ist. Der Widerruf gilt für die Zukunft.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Kontrollbehörde
                                        </td>
                                        <td>
                                            Die Nutzer*innen haben das Recht, eine Beschwerde bei der örtlichen Kontrollbehörde für den Datenschutz einzureichen. <br><br>
                                            In Griechenland ist die Kontrollbehörde für den Datenschutz die Datenschutzbehörde https://www.dpa.gr/

                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Identität</td>
                                        <td>Die für die Datenverarbeitung verantwortliche Stelle nimmt die Vertraulichkeit aller Dateien, die personenbezogene Daten enthalten, sehr ernst und ist daher berechtigt, die Nutzer*innen um einen Identitätsnachweis zu bitten, wenn diese eine Anfrage in Bezug auf ihre Dateien einreichen.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Kosten</td>
                                        <td>Die Nutzer*innen müssen für die Ausübung ihrer Rechte in Bezug auf personenbezogene Daten nichts bezahlen, es sei denn, der Antrag auf Zugang zu den Informationen ist unbegründet oder überzogen, wie im Gesetz vorgesehen. In diesem Fall kann die für die Datenverarbeitung verantwortliche Stelle den Nutzer*innen eine unter den jeweiligen Umständen angemessene Gebühr in Rechnung stellen. Die für die Datenverarbeitung verantwortliche Stelle informiert die Nutzer*innen über etwaige Gebühren, bevor sie den Antrag ausfüllt.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Zeitplan</td>
                                        <td>Die für die Datenverarbeitung verantwortliche Stelle ist bestrebt, gültige Anfragen der Nutzer*innen spätestens innerhalb eines (1) Monats nach deren Eingang zu beantworten, es sei denn, die Anfrage ist äußerst kompliziert oder die Nutzer*innen haben mehrere Anfragen eingereicht; in diesem Fall ist die für die Datenverarbeitung verantwortliche Stelle bestrebt, die Anfragen innerhalb von drei Monaten zu beantworten. Sollte die für die Datenverarbeitung verantwortliche Stelle aus den oben genannten Gründen mehr als einen Monat benötigen, wird sie die Nutzer*innen informieren. Die verantwortliche Stelle für die Datenverarbeitung kann die Nutzer*innen bitten, zu erläutern, was genau sie zu erhalten wünschen oder was ihr Anliegen ist. Auf diese Weise kann die für die Datenverarbeitung zuständige Stelle schneller auf die Anfrage der Nutzer*innen reagieren. Die Nutzer*innen sollten in jedem Fall konkrete und wahrheitsgemäße Daten und/oder Fakten angeben, damit die für die Datenverarbeitung verantwortliche Stelle die Anfrage der Nutzer*innen genau beantworten und/oder erfüllen kann. Andernfalls behält sich die für die Datenverarbeitung verantwortliche Stelle das Recht auf Fehler vor, die außerhalb ihrer Kontrolle liegen. Darüber hinaus kann die für die Datenverarbeitung verantwortliche Stelle Anfragen ablehnen, die unbegründet, übertrieben, missbräuchlich, in bösem Glauben gestellt oder im Rahmen der gesetzlichen Bestimmungen unrechtmäßig sind.
                                        </td>
                                    </tr>
                                </table>

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">7. Wie wird die Datensicherheit gewährleistet?</h2>
                                <b>7.1</b> Die für die Datenverarbeitung verantwortliche Stelle ergreift alle geeigneten Sicherheitsmaßnahmen, um den Schutz und die Vertraulichkeit personenbezogener Daten zu gewährleisten, darunter die folgenden:
                                <br>
                                <ol>
                                    <li>Starke Passwortrichtlinien auf allen Servern</li>
                                    <li>HTTPS-Protokoll für die Interaktion mit APIs und Webclients</li>
                                    <li>SSH-Protokoll für die Serververbindung</li>
                                    <li>Regelmäßige Server-Updates mit den neuesten Sicherheitskorrekturen</li>
                                </ol>

                                <br><br>
                                <b>7.2</b> Bitte beachten Sie, dass nur speziell autorisierte Mitarbeiter*innen der verantwortlichen Stelle, die unter der Autorität der verantwortlichen Stelle und nur auf deren Anweisung handeln, sowie ggf. Empfänger*innen die von den Nutzer*innen übermittelten Daten verarbeiten. Für die Verarbeitung wählt die für die Datenverarbeitung verantwortliche Stelle Personen mit entsprechender Qualifikation aus, die über ausreichende Garantien in Bezug auf technische Kenntnisse und persönliche Integrität verfügen, um die Vertraulichkeit zu wahren. Die für die Datenverarbeitung verantwortliche Stelle ergreift alle erforderlichen Sicherheitsmaßnahmen zum Schutz und zur Wahrung der Geheimhaltung, Vertraulichkeit und Integrität personenbezogener Daten auch durch entsprechende vertragliche Verpflichtungen ihrer Mitarbeiter*innen. In jedem Fall kann die Sicherheit der Website aus Gründen, die außerhalb der Kontrollsphäre des für die Verarbeitung Verantwortlichen liegen, sowie aufgrund von technischen oder anderen Problemen des Netzes oder höherer Gewalt oder zufälligen Ereignissen verletzt werden. In diesem Fall kann die Sicherheit der personenbezogenen Daten nicht garantiert werden.

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">8. Von wem werden die Daten empfangen?</h2>
                                <b>8.1</b> Die Daten der Nutzer*innen werden an Unternehmen weitergegeben, die die technische Infrastruktur für den Betrieb der Website bereitstellen, an den Hosting-Provider sowie an das Unternehmen, das die elektronische Kommunikation im Zusammenhang mit dem Betrieb der Plattform an die Nutzer*innen versendet. Soweit nach geltendem Recht erforderlich, schließt die für die Datenverarbeitung verantwortliche Stelle mit diesen Unternehmen Vereinbarungen ab, die sich auf die Umsetzung und regelmäßige Überwachung von Sicherheitsmaßnahmen beziehen. Für den Fall, dass Daten außerhalb von ΕU übertragen werden, sind alle erforderlichen Garantien vorhanden.
                                <br><br>
                                <b>8.2.</b> Erhält die für die Datenverarbeitung verantwortliche Stelle eine Aufforderung zur Mitteilung oder Übermittlung von Daten aufgrund eines Ersuchens der zuständigen Verwaltungsbehörde, Anwält*in, Gerichts oder einer anderen Behörde, kann sie diese Daten mitteilen/übermitteln, um ihre im öffentlichen Interesse ausgeübte Pflicht gegenüber diesen Behörden zu erfüllen (mit oder ohne vorherige Mitteilung der Nutzer*innen), in Übereinstimmung mit den entsprechenden gesetzlichen Bestimmungen. Die Nutzer*innen haben das Recht, dieser Verarbeitung gemäß Artikel 7 zu widersprechen, wenn sie zuvor gemäß den gesetzlichen Bestimmungen benachrichtigt wurden.
                                <br><br>
                                <b>8.3.</b> Die beruflichen Daten der Nutzer*innen stehen allen anderen registrierten Nutzer*innen der Plattform zu den oben genannten Zwecken zur Verfügung.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">9. Kommunikation mit der für die Datenverarbeitung verantwortlichen Stelle</h2>
                                <b>9.1.</b> Die Nutzer*innen können sich bei allen Fragen im Zusammenhang mit der vorliegenden Datenschutzpolitik, der Datenverarbeitung durch die Nutzer*innen sowie der Ausübung der Rechte der Nutzer*innen auf einem der folgenden Wege an den Datenverantwortlichen wenden
                                Telefon: {{ config("app.installation_company_phone") }}, <br>
                                Email: {{ config("app.installation_company_email") }}<br>
                                Die Nutzer*innen werden gebeten, die für die Datenverarbeitung verantwortliche Stelle unverzüglich zu benachrichtigen, wenn sie von einer Datenverletzung erfahren.
                                <br><br>
                                <b>9.2.</b> Die vorliegenden Bedingungen werden durch die Allgemeinen Geschäftsbedingungen geregelt und ergänzt und bilden zusammen mit diesen einen einheitlichen Text.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">10. Verbindung zu anderen Websites/Sozialen Medien</h2>
                                Diese Website ist durch Hyperlinks mit anderen Websites verbunden. Diese Websites stehen in keinem Zusammenhang mit der Website der für die Datenverarbeitung verantwortlichen Stelle und ihr Inhalt wird von der für die Datenverarbeitung verantwortlichen Stelle weder geprüft noch empfohlen. Die Richtigkeit, Rechtmäßigkeit, Vollständigkeit oder Qualität ihres Inhalts und die Rechtmäßigkeit der Verarbeitung der personenbezogenen Daten der Nutzer*innen können daher nicht überprüft werden, und es wird keine Garantie für sie übernommen. Die für die Datenverarbeitung verantwortliche Stelle kann nicht für sie oder für Schäden haftbar gemacht werden, die den Nutzer*innen aufgrund oder infolge ihrer Nutzung entstehen können. Die für die Datenverarbeitung verantwortliche Stelle kann die Verarbeitung der personenbezogenen Daten der Nutzer*innen durch diese verlinkten Websites nicht kontrollieren und übernimmt daher keine Haftung. Wenn die Nutzer*innen auf diese Websites zugreifen, sollten sie bedenken, dass die Geschäftsbedingungen der jeweiligen Website gelten. Die Nutzer*innen sollten sich bei Fragen zum Inhalt oder zur Nutzung der verlinkten Website direkt an die Betreibenden oder Administrator*innen der jeweiligen Website wenden. Die für die Datenverarbeitung verantwortliche Stelle billigt weder den Inhalt noch die Dienstleistungen der verlinkten Websites, auf die die Nutzer*innen über die Website zugreifen, und macht sich diese auch nicht zu eigen.<br><br>
                                Die Website gibt den Nutzer*innen die Möglichkeit, sich auf eigene Initiative und nach eigenem Willen mit sozialen Medien zu verbinden und mit ihnen zu interagieren. In diesem Fall haftet die für die Datenverarbeitung verantwortliche Stelle nicht für die Verarbeitung der Daten der Nutzer*innen, die über oder durch die sozialen Medien erfolgt. Die Nutzer*innen sollten sich direkt an die einzelnen sozialen Medien wenden, um ihre legitimen Rechte geltend zu machen.


                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">11. Cookies</h2>
                                11.1. Die Plattform verwendet Cookies, um ihren Betrieb zu ermöglichen oder effizienter zu gestalten, die Navigation der Nutzer*innen zu verbessern, den Nutzer*innen das volle Potenzial der Plattform zur Verfügung zu stellen, die korrekte Darstellung der Inhalte zu gewährleisten sowie für analytische und statistische Zwecke.
                                <br><br>
                                11.2. Cookies sind kleine Textdateien, die auf dem Computer der Nutzer*innen gespeichert werden, wenn diese eine digitale Plattform besuchen, und die dazu dienen, ihren Computer zu identifizieren.
                                <br><br>
                                11.3. Cookies werden, abgesehen von absolut notwendigen Cookies, nur dann installiert, wenn die Nutzer*innen deren Installation beim Besuch dieser Plattform akzeptieren. Die Nutzer*innen erklären durch die Annahme von Cookies beim Besuch dieser Plattform ausdrücklich, dass sie die besonderen Bedingungen für die Installation, die Funktion und den Zweck der Cookies gelesen und verstanden haben und dass sie ihre Zustimmung zu deren Verwendung geben.
                                <br><br>
                                11.4. Alternativ können die Nutzer*innen auch keine Cookies akzeptieren. In diesem Fall werden nur Cookies installiert, die für den Betrieb der Plattform technisch und funktional notwendig sind.
                                <br><br>
                                11.5. Die Nutzer*innen können die Verwendung und Installation von Cookies jederzeit über ein Panel verwalten, in dem sie wählen können, welche Kategorie von Cookies sie akzeptieren wollen und welche nicht (oder beantragen, nur die technisch notwendigen Cookies zu installieren).
                                <br><br>
                                11.6. Die von der Plattform verwendeten Cookies sind insbesondere die folgenden:
                                <br><br>

                                <table class="table table-striped table-responsive table-bordered">
                                    <tr>
                                        <th>Art der Cookies</th>
                                        <th>Erläuterung</th>
                                        <th>Beispiel der Cookies</th>
                                        <th>Dauer der Installation jedes Cookies</th>
                                        <th>Weitergabe von Daten an Dritte</th>
                                    </tr>
                                    <tr>
                                        <td>Absolut notwendige Cookies</td>
                                        <td>Die absolut notwendigen Cookies sind für den ordnungsgemäßen Betrieb der Plattform unerlässlich. Die Nutzer*innen können mit diesen Cookies auf der Plattform surfen und deren Funktionen nutzen, z. B. den Zugang zu geschützten Bereichen. Diese Cookies erkennen nicht die individuelle Identität der Nutzer*innen und ohne sie ist der reibungslose Betrieb der Plattform nicht möglich.
                                        </td>
                                        <td>crowdsourcing_app_cookies_consent_selection (Speichert den Cookie-Zustimmungsstatus der Nutzer*innen für die aktuelle Domain )
                                            <br><br>
                                            crowdsourcing_app_cookies_consent_targeting (Speichert den Cookie-Zustimmungsstatus der Nutzer*innen für die aktuelle Domain )
                                            <br><br>
                                            XSRF-TOKEN (Sorgt für die Sicherheit der Besuchenden beim Surfen, indem es Cross-Site Request Forgery verhindert. Dieses Cookie ist für die Sicherheit der Website und der Besuchenden unerlässlich. )
                                            <br><br>
                                            ecas_lets_crowdsource_our_future_session (Wenn sich die App an die angemeldeten Nutzer*innen "erinnern" muss, während sie auf der Plattform navigieren)
                                            <br><br>
                                            Crowdsourcing_anonymous_user_id (zur Speicherung anonymer Antworten auf den Fragebögen durch Zuweisung einer ganzzahligen Nummer an die Nutzer*innen, die die Antwort abgeben)
                                        </td>
                                        <td>1 Jahr
                                            <br><br>
                                            <br><br>
                                            1 Tag
                                            <br><br>
                                            <br><br>
                                            Dauer der Sitzung
                                            <br><br>
                                            <br><br>
                                            5 Jahre
                                        </td>
                                        <td>Nein
                                            <br><br>
                                            <br><br>
                                            Nein
                                            <br><br>
                                            <br><br>
                                            Nein
                                            <br><br>
                                            <br><br>
                                            Nein
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Statistische/analytische Cookies</td>
                                        <td>Dies sind Cookies, die auswerten, wie Besuchende die Plattform nutzen (z. B. welche Seiten häufiger besucht werden und ob sie Fehlermeldungen von Webseiten erhalten). Diese Cookies werden zu statistischen Zwecken und zur Verbesserung der Leistung einer Plattform verwendet.
                                        </td>
                                        <td>_ga_4S9N5MK4VE, _gat,_ga, _gcl_au, _gid: Google Analytics-Cookies werden verwendet, um den Datenverkehr auf der Plattform zu messen. Es wird eine eindeutige Zeichenfolge zur Identifizierung des Browsers, des Zeitstempels für Interaktionen und des Browsers/der Quellseite, über die die Nutzer*innen auf die Plattform gelangt sind, gespeichert. Es werden keine sensiblen Informationen gespeichert.

                                        </td>
                                        <td>_ga_4S9N5MK4VE: 2 Jahre
                                            <br><br>
                                            _gat:1 Minute
                                            <br><br>
                                            _ga:2 Jahre
                                            <br><br>
                                            _gcl_au:3 Monate
                                            <br><br>
                                            _gid:24 Stunden
                                        </td>
                                        <td>Ja (Unternehmen, das statistische und analytische Dienstleistungen erbringt, wenn es als Drittpartei betrachtet wird)
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">12. Privatsphäre von Kindern</h2>
                                Unser Projekt richtet sich nicht an Personen unter 18 Jahren ("Kinder"). Wir sammeln nicht wissentlich personenbezogene Daten von Personen unter 18 Jahren. Wenn Sie ein Elternteil oder eine erziehungsberechtigte Person sind und wissen, dass Ihre Kinder uns personenbezogene Daten zur Verfügung gestellt haben, kontaktieren Sie uns bitte. Wenn wir erfahren, dass wir personenbezogene Daten von Kindern ohne Überprüfung der elterlichen Zustimmung erfasst haben, ergreifen wir Maßnahmen, um diese Daten von unseren Servern zu entfernen.


                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">13. Änderungen der vorliegenden Datenschutzrichtlinie</h2>
                                Die für die Datenverarbeitung verantwortliche Stelle behält sich das Recht vor, die vorliegende Datenschutzerklärung zu ändern, beispielsweise wenn dies erforderlich ist, um neuen Anforderungen durch geltende Gesetze, Richtlinien oder technische Anforderungen zu entsprechen, oder im Zuge einer Überarbeitung der Prozesse und Praktiken der für die Datenverarbeitung verantwortlichen Stelle. Die Nutzer*innen werden über die Plattform über jede Änderung dieser Datenschutzrichtlinie informiert. Die Nutzer*innen sollten diese Datenschutzrichtlinie regelmäßig auf Änderungen hin überprüfen.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
