@extends('home.layout')

@section('content')

    <div class="container pt-4 mb-2" style="margin-top: 100px">
        <div class="mb-5">
            <div class="row">
                <div class="col-12 mx-auto mb-3 text-center">
                    <h1>ПОЛИТИКА ЗА ПОВЕРИТЕЛНОСТ</h1>
                </div>
            </div>
            <div class="row">
                <div class="col mx-auto">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col">
                                Настоящата Политика за поверителност се прилага за всички потребители на Платформата (наричани по-долу <b>“Потребители”</b> или <b>“Потребител”</b> и <b>“Платформа”</b> съответно) и представлява неразделна част от Общите условия на уебсайта на Платформата. Настоящата Политика за поверителност предоставя на Потребителя обща информация относно това как Администраторът на лични данни използва вашите лични данни и друга информация, изисквана от законодателството за защита на данните. В случай на бъдещо изменение, Потребителят ще получи необходимите актуализации и информация чрез актуализацията на настоящата Политика за поверителност, качена в Платформата.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">1. Кой е Администраторът на данни?</h2>
                            </div>
                            <div class="col-12">
                                <b>1.1.</b> Фирмата с фирмено наименование “{{ config("app.installation_company_name") }}”, адрес: {{ config("app.installation_company_address") }}, Телефон: {{ config("app.installation_company_phone") }}, имейл: {{ config("app.installation_company_email") }}, е администраторът на данни за обработката на личните данни на потребителя (наричан по-долу <b>"Администратор на данни"</b>).
                                <br><br>
                                <b>1.2.</b> Данни за контакт на администратора на данни: За всеки проблем или притеснение по отношение на настоящата Политика за поверителност и обработката на лични данни на потребителя или данни, качени от Потребителя за използване на Платформата, Потребителят може да се свърже с Администратора на данни, като използва един от следните начини:
                                <br><br>
                                {{ config("app.installation_company_name") }}<br>
                                {{ config("app.installation_company_address") }}<br>
                                {{ config("app.installation_company_email") }}<br>
                                {{ config("app.installation_company_phone") }}<br>
                                <br>

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">2. Каква е целта и правното основание за обработката на данните на Потребителя?</h2>
                                <b>2.1.</b> Оперативната цел на Платформата е да събира мнения на потребителите чрез въпросници. Мненията се обработват с цел получаване на познания, събиране и представяне на ценни идеи и предложения по темите, разглеждани във въпросниците. Потребителите могат да отговарят анонимно (без да предоставят лична информация) или могат доброволно да се регистрират, за да подават персонално идентифицирани отговори, като предоставят имейл и псевдоним. Отговорите на Потребителя се превеждат на английски и могат да бъдат включени в отчети. За конкретната цел на обработването, правното основание е предварителното съгласие на Потребителя.
                                <br><br>
                                <b>2.2.</b> Да изпраща информативни имейли на Потребителя с цел да го информира за нови дейности, проекти и други въпроси от интерес за Платформата. Предварителното съгласие на Потребителя е правното основание за тази цел на обработката на данните.
                                <br><br>
                                <b>2.3</b> Обработка на данни по причини, свързани със спазването на законовите задължения от страна на Администратора на данни. В такива случаи обработването на данни се извършва само за необходимия период от време, за да може Администраторът на данни да изпълни задълженията, наложени от различни законови разпоредби.
                                <br><br>
                                <b>В горните случаи, когато правното основание е предварителното съгласие на Потребителя, Потребителят има право да оттегли това съгласието си по всяко време, без да засяга легитимността на данните, основани на съгласието преди неговото оттегляне.</b>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">3. Видове събирани данни</h2>

                                <h3 class="mt-4 mb-4">3.1 Лични данни</h3>
                                <b>3.1.1 Регистрация - създаване на акаунт:</b><br>
                                За да може Потребителят да създаде доброволно акаунт в Платформата, Потребителят трябва да попълни необходимите данни: псевдоним, имейл адрес и парола
                                <br><br>
                                <b>3.1.2 Подадени отговори на въпросника</b><br>
                                Платформата събира потребителски отговори (тоест мнения по различни теми) на въпроси, направени чрез въпросниците на Платформата. Тези отговори се анализират и представят на страница с резултати от въпросника. Призоваваме Потребителя да спазва стриктно Кодекса за поведение за успешно участие на Платформата и да избягва публикуването на всякакви лични данни, които не желаят да бъдат публично достъпни в Платформата.
                                <br><br>
                                <b>3.1.3. Свързване на Платформата с Потребителя по причини, свързани с разрешеното от Потребителя използване на Платформата.</b>
                                <br>
                                За да може Платформата да комуникира с Потребителя за горните цели, Администраторът на данни може да обработва всички данни, свързани с акаунта на Потребителя, каченото съдържание и данните, свързани с използването на Платформата от Потребителя.

                                <h3 class="mt-4 mb-4">3.2 Данни за употреба</h3>
                                Можем също така да събираме информация как се осъществява достъп и как се използва уеб страницата („Данни за използване“). Тези данни за използване може да включват информация като адреса на интернет протокола на вашия компютър (напр. IP адрес), тип браузър, версия на браузъра, страниците на нашата уеб страница, които посещавате, часа и датата на вашето посещение, времето, прекарано на тези страници, уникални идентификатори на устройства и други диагностични данни.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4"> 4. Как Платформата събира данни</h2>
                                4.1 Информацията може да бъде събрана по следните начини: <br>
                                4.1.1 Когато Потребителят се регистрира и създаде акаунт в Платформата. <br>
                                4.1.2 Когато Потребителят подаде отговори на въпросниците на Платформата <br>
                                4.1.3 Когато Потребителят посети Платформата и се съгласи с инсталирането на бисквитки (съгласно Политиката за бисквитки на Платформата в член 11 по-долу) и с събирането на лични данни на Потребителя, като IP адрес, операционна система, тип и издание на браузъра и т.н.
                                <br>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">5. Колко време се съхраняват данните на потребителя и кога се изтриват?</h2>
                                <b>5.1. Данни за акаунта на потребителя:</b><br>
                                Без да се засяга посоченото по-долу право на изтриване/премахване на Потребителя, данните, регистрирани и съхранени в акаунта на Потребителя, ще бъдат съхранявани, докато Потребителят желае да използва Платформата за целта, посочена по-горе. В случай, че Потребител желае да изтрие акаунта си, той може да изтрие акаунта си чрез настройките на акаунта или да се свърже с Администратора на данни на посочените по-горе данни за контакт.
                                <br><br>
                                <b>5.2. Свързване на Платформата с Потребителя по причини, свързани с разрешеното от Потребителя използване на Платформата.</b><br>
                                Данните, свързани с такава комуникация, ще се съхраняват само докато Потребителят желае да използва Платформата и поддържа своя акаунт. В случай, че Потребител желае да изтрие акаунта си, той може да изтрие акаунта си чрез настройките на акаунта или да се свърже с Администратора на данни на посочените по-горе данни за контакт.
                                <br><br>
                                <b>5.3. Статистически анализ за оптимизация на Уебсайта</b><br>
                                Независимо от гореспоменатите разпоредби на член 5, Администраторът на данни ще съхранява и обработва само необходимите данни и само за периода, който е необходим, за да изпълни своите задължения, наложени от закона (спазване на фискални задължения и т.н.).
                                <br><br>
                                <b>5.4. Обработка на лични данни за целите на провеждане на статистически анализ.</b><br>
                                Моля, вижте политиката за бисквитки (член 11) по-долу.
                                <br><br>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">6. Какви са правата на Потребителя във връзка с обработката на неговите данни и как може да упражни тези права?</h2>
                                <b>6.1</b> Администраторът на данни зачита правото на потребителя във връзка с обработката на данни.
                                <br><br>
                                <b>6.2</b> Потребителят може да упражни правата си, като се свърже с Администратора на данни на следните данни за контакт: Телефон: {{ config("app.installation_company_phone") }}, имейл: {{ config("app.installation_company_email") }}
                                <br><br>
                                За улеснение на Потребителя, правата на потребителя са включени в следващата таблица заедно с кратко обяснение на всяко право (позоваването на членове съответства на член от GDPR 2016/679):
                                <br><br>
                                <table class="table table-striped table-responsive table-bordered">
                                    <tr>
                                        <th>Право</th>
                                        <th>Обяснение</th>
                                    </tr>
                                    <tr>
                                        <td>Достъп (чл. 15)</td>
                                        <td>
                                            Потребителят може да поиска от Администратора на данни:
                                            <ul>
                                                <li>да потвърди дали Администраторът на данни обработва личните данни на Потребителя
                                                </li>
                                                <li>да предостави на Потребителя достъп до данни, с които Потребителят не разполага</li>
                                                <li>да предостави на Потребителя друга информация, свързана с личните данни на Потребителя, като например кои са данните, с които Администраторът на данни разполага, какви са целите на обработването, на кого се разкриват тези данни, дали тези данни се прехвърлят в чужди държави и как са тези данни защитени, колко време се съхраняват данните, какви са правата на Потребителя, как може да се подаде жалба, откъде са взети данните, доколкото тази информация не е включена в настоящата Политика за поверителност.
                                                </li>
                                            </ul>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Коригиране (чл. 16)</td>
                                        <td>
                                            Потребителят може да поиска от Администратора на лични данни да коригира неточни лични данни.<br><br>
                                            Администраторът на данни има право да провери точността на данните, преди да ги коригира.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Премахване/изтриване (чл.17)
                                            </td>
                                        <td>
                                            Потребителят може да поиска от Администратора на лични данни да изтрие личните му данни:<br><br>
                                            <ul>
                                                <li>винаги, когато личните данни вече не са необходими за целите, за които са били събрани
                                                </li>
                                                <li>когато Потребителят оттегли съгласието си</li>
                                                <li>когато личните данни са били обработвани неправомерно</li>
                                            </ul>
                                            <br><br>
                                            Администраторът на лични данни не е длъжен да изпълни искането на Потребителя за изтриване на личните му данни, ако обработката на личните данни на Потребителя е необходима:
                                            <ul>
                                                <li>за спазване на законово задължение</li>
                                                <li>за изпълнение на друга легитимна цел или друго легитимно правно основание
                                                </li>
                                                <li>за установяване, упражняване или защита на правни искове.</li>
                                            </ul>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Ограничаване (чл. 18)</td>
                                        <td>

                                            Потребителят може да поиска от Администратора на данни да ограничи (т.е. да съхранява, но не да обработва) личните му данни, когато:<br><br>
                                            тяхната точност се оспорва (виж Коригиране), така, че Администраторът на данни да може да провери точността на личните данни или<br><br>
                                            личните данни са били неправомерно използвани, но Потребителят се противопоставя на изтриването им или<br><br>
                                            те вече не са необходими за целите, за които са събрани, но Потребителят все още се нуждае от тях за установяване, упражняване или защита на правни искове или има друга легитимна цел на обработване или друго правно основание.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Преносимост на данните (чл. 20)
                                        </td>
                                        <td>
                                            Когато обработването се основава на съгласие и обработването се извършва по автоматизирани средства, Потребителят може да поиска от Администратора на данни да получи личните си данни в структуриран, често използван и машинно четим формат или да поиска от Администратора на данни да ги предаде директно към друг администратор. Въпреки това, съгласно закона, това право се отнася само до тези данни, които са предоставени от самия Потребител, а не до тези данни, които са изведени от Администратора на лични данни въз основа на данните, които Потребителят е предоставил.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Възражение (чл. 21)</td>
                                        <td>
                                            Потребителят може по всяко време да възрази срещу обработването на лични данни, отнасящи се до него или нея, което се основава на легитимен интерес или изпълнение на задача, извършена в обществен интерес.<br><br>
                                            Когато Потребителят упражни правото си на възражение, Администраторът на данни има право да докаже, че са налични неоспорими законни основания за обработването на данни, които имат предимство над интереса, правата и свободите на Потребителя или над установяването, упражняването или защитата на правни искове.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Оттегляне на съгласие
                                        </td>
                                        <td>
                                            Когато съгласието  на Потребителя е в основата на обработката на данните, Потребителят има право да го оттегли. Оттеглянето е валидно само за бъдещо обработване на данните.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            Надзорен орган
                                        </td>
                                        <td>
                                            Потребителят има право да подаде жалба до местния надзорен орган, свързан със защитата на данните. <br><br>
                                            В Гърция надзорният орган за защита на данните е Органът за защита на данните, https://www.dpa.gr/

                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Самоличност</td>
                                        <td>Администраторът на данни се отнася сериозно към поверителността на всички файлове, които включват лични данни, поради което той има право да поиска от Потребителя доказателство за неговата самоличност, ако Потребителят подаде искане във връзка с тези файлове.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Разходи</td>
                                        <td>Потребителят няма да плаща за упражняването на правата си във връзка с лични данни, освен ако, съгласно предвиденото в закона, искането за достъп до информация е неоснователно или прекомерно. В този случай Администраторът на данни може да начисли на Потребителя разумна такса съобразена с конкретните обстоятелства. Администраторът на данни ще информира Потребителя за евентуално таксуване, преди да завърши заявката.
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Срокове</td>
                                        <td>Администраторът на данни ще се стреми да отговори на валидни искания на Потребителя най-късно в рамките на един (1) месец от получаването им, освен ако заявката е изключително сложна или Потребителят е подал множество искания, в който случай Администраторът на данни ще се стреми да отговори на тях в рамките на три месеца . В случай, че Администраторът на данни се нуждае от повече от един месец поради горепосочените причини, той ще информира Потребителя. Администраторът на данни има право да попита Потребителя да обясни какво точно желае да получи или какво го интересува. Това ще помогне на администратора на данни да действа по-бързо във връзка с искането на потребителя. Във всеки случай, Потребителят трябва да посочи конкретни и верни данни и/или факти, за да може Администраторът да отговори и/или да удовлетвори точно искането на Потребителя. В противен случай Администраторът на данни не може да носи отговорност за всякакви грешки, които са извън неговия контрол. Освен това, Администраторът на данни може да отхвърли искания, които са неоснователни, прекомерни, злоупотребяващи, направени недобросъвестно или са извън рамките на законовите разпоредби.
                                        </td>
                                    </tr>
                                </table>

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">7. Как се гарантира сигурността на данните?</h2>
                                <b>7.1</b> Администраторът на лични данни прилага всички подходящи мерки за сигурност, за да гарантира защитата и поверителността на личните данни, което включени следното:
                                <br>
                                <ol>
                                    <li>Силни политики за пароли във всички сървъри</li>
                                    <li>HTTPS протокол за взаимодействие с API и уеб клиенти</li>
                                    <li>SSH протокол за връзка със сървъра</li>
                                    <li>Периодични актуализации на сървъра с най-новите корекции на сигурността</li>
                                </ol>

                                <br><br>
                                <b>7.2</b> Моля, имайте предвид, че само специално упълномощени служители на Администратора на данни, действащи под ръководството на Администратора на данни и само по негови инструкции, както и получателите, където е необходимо, обработват данните, предоставени от Потребителя. За обработката Администраторът на данни избира лица с подходяща квалификация, които имат достатъчни гаранции по отношение на техническите познания и личен интегритет, за да защитят поверителността на данните. Администраторът на лични данни предприема всички необходими мерки за сигурност за защита и защита на поверителността, поверителността и целостта на личните данни, в това число чрез съответните договорни ангажименти със своите сътрудници. Във всеки случай сигурността на Уебсайта може да бъде нарушена поради причини, които са извън сферата на контрола на Администратора на данни, както и поради технически или друг проблем в мрежата или форсмажорни обстоятелства или случайни факти. В този случай сигурността на личните данни не може да бъде гарантирана.

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">8. Кои са получателите на данни?</h2>
                                <b>8.1</b> Получатели на лични данни на Потребителя са асоциирани фирми, които предоставят техническа инфраструктура за функционирането на Уебсайта, доставчик на хостинг, както и дружеството, което се задължава да изпраща електронни съобщения, свързани с функционирането на Платформата, до Потребителите. Когато е необходимо съгласно приложимите закони, Администраторът на данни ще подписва споразумения с такива компании, които се отнасят до прилагането и редовното наблюдение на мерките за сигурност. В случай, че данните се прехвърлят извън ΕU, налице са всички необходими гаранции.
                                <br><br>
                                <b>8.2.</b> В случай, че Администраторът на лични данни получи искане за уведомяване или прехвърляне на данни след получаване на искане от съответния административен орган, адвокат, съд или друг орган, той има право да уведоми/прехвърли тези данни, за да изпълни задължението си, изпълнено в полза на обществения интерес спрямо тези органи (със или без предварително уведомление на Потребителя) в съответствие със съответните законови разпоредби. Ако Потребителят трябва да бъде предварително уведомен в съответствие със законовите разпоредби, тогава Потребителят има право да възрази срещу тази обработка, както е предвидено в член 7 по-горе.
                                <br><br>
                                <b>8.3.</b> Относно професионалните данни на всеки Потребител, те са достъпни за всички регистрирани Потребители на платформата за целите, посочени по-горе.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">9. Комуникация с администратора на данни</h2>
                                <b>9.1.</b> За всеки проблем, свързан с настоящата политика за поверителност, обработката на данни на Потребителя, както и упражняването на правата на Потребителя, Потребителят може да се свърже с Администратора на лични данни по един от следните начини: <br>
                                Телефон: {{ config("app.installation_company_phone") }}, <br>
                                Имейл: {{ config("app.installation_company_email") }}<br>
                                <br><br>
                                В случай, че Потребителят узнае за случай с нарушаване на данните, молим го любезно да уведоми незабавно Администратора на лични данни.
                                <br><br>
                                <b>9.2.</b> Настоящите условия се уреждат и допълват от Общите условия и заедно с тях представляват единен текст.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">10. Връзка с други уебсайтове/социални медии</h2>
                                Този уебсайт се свързва с други уебсайтове чрез хипервръзки. Тези уебсайтове не са свързани с уебсайта на Администратора на данни и тяхното съдържание нито се проверява, нито препоръчва от Администратора на данни. Точността, легитимността, пълнотата или качеството на тяхното съдържание и легитимността на обработката на личните данни на потребителя не се проверяват и не се гарантират от Администратора. Администраторът на данни не може да носи отговорност за тях или каквито и да било щети, които могат да бъдат причинени на Потребителя поради или след тяхното използване. Администраторът на данни не може да проверява обработването на личните данни на Потребителя от тези свързани уебсайтове и не носи никаква отговорност за това. Когато Потребителят осъществява достъп до тези уебсайтове, той трябва да има предвид, че се прилагат правилата и условията на всеки уебсайт. За всеки проблем, който може да възникне по отношение на съдържанието или използването на свързания уебсайт, Потребителят трябва директно да се свърже с оператора или администратора на съответния уебсайт. Администраторът на данни не дава съгласие или одобрение за съдържанието или услугите на свързаните уебсайтове, до които Потребителят осъществява достъп чрез Уебсайта..<br><br>
                                Уебсайтът дава на Потребителя възможност да се свързва и да взаимодейства със социалните медии по своя собствена инициатива и воля. В този случай, Администраторът на данни не носи отговорност за обработката на данните на Потребителя, извършвана чрез или от социалните медии. Потребителят трябва директно да се обърне към всяка конкретна социална медия, за да упражни своите законни права.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">11. Бисквитки</h2>
                                11.1. Платформата използва бисквитки, с цел да бъде оперативна или по-ефективна в работата си, да подобри навигацията на Потребителя, да предостави на Потребителя пълния потенциал на Платформата, да осигури правилното показване на съдържанието, както и за аналитични и статистически цели.
                                <br><br>
                                11.2. Бисквитките са малки текстови файлове, съхранявани на компютъра на Потребителя, когато той посещава цифрова платформа, които се използват като средство за идентифициране на неговия компютър.
                                <br><br>
                                11.3. Бисквитките, освен абсолютно тези, които са необходими, се инсталират само ако Потребителят приеме инсталирането им, когато посети тази Платформа. С приемането на бисквитки при влизане в тази Платформа, Потребителят изрично заявява, че е прочел и разбрал специфичните правила и условия относно инсталирането, функцията и предназначението на бисквитките и че дава своето съгласие за използването им.
                                <br><br>
                                11.4. Като алтернатива, Потребителят може да не приема бисквитки. В този случай ще бъдат инсталирани само бисквитките, които са технически и функционално необходими за функционирането на Платформата.
                                <br><br>
                                11.5. Потребителят може да управлява използването и инсталирането на бисквитки по всяко време чрез панел, където може да избере коя категория бисквитки желае да приеме и кои не (или да поиска да инсталира само технически необходимите бисквитки).
                                <br><br>
                                11.6. По-специално бисквитките, използвани от Платформата, са следните:
                                <br><br>

                                <table class="table table-striped table-responsive table-bordered">
                                    <tr>
                                        <th>Тип бисквитка</th>
                                        <th>Обяснение</th>
                                        <th>Пример на бисквитка</th>
                                        <th>Продължителност на бисквитката</th>
                                        <th>Прехвърляне на данни към трети страни</th>
                                    </tr>
                                    <tr>
                                        <td>Абсолютно необходими</td>
                                        <td>Абсолютно необходимите бисквитки са от съществено значение за правилното функциониране на Платформата. Тези бисквитки позволяват на потребителя да разглежда и използва функции на платформата, като достъп до защитени зони. Тези бисквитки не разпознават индивидуалната самоличност на потребителя и без тях гладкото функциониране на Платформата не е възможно.
                                        </td>
                                        <td>crowdsourcing_app_cookies_consent_selection (Съхранява състоянието на съгласие за бисквитки на потребителя за текущия домейн)
                                            <br><br>
                                            crowdsourcing_app_cookies_consent_targeting (Съхранява състоянието на съгласие за бисквитки на потребителя за текущия домейн)
                                            <br><br>
                                            XSRF-TOKEN (Гарантира сигурността при сърфиране на посетителите, като предотвратява фалшифициране на заявки между сайтове. Тази бисквитка е от съществено значение за сигурността на уебсайта и посетителя.)
                                            <br><br>
                                            ecas_lets_crowdsource_our_future_session (Когато приложението трябва да „запомни“ влезлия потребител, докато той ползва Платформата)
                                            <br><br>
                                            Crowdsourcing_anonymous_user_id (използва се за съхраняване на анонимни отговори във въпросниците чрез присвояване на цяло число на потребителя, който изпраща отговора)
                                        </td>
                                        <td>1 година
                                            <br><br>
                                            <br><br>
                                            1 година
                                            <br><br>
                                            <br><br>
                                            По време на сесията
                                            <br><br>
                                            <br><br>
                                            5 години
                                        </td>
                                        <td>Не
                                            <br><br>
                                            <br><br>

                                            Не
                                            <br><br>
                                            <br><br>

                                            Не
                                            <br><br>
                                            <br><br>

                                            Не
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>Статистически и аналитични бисквитки</td>
                                        <td>Това са бисквитки, които оценяват начина, по който посетителите използват Платформата (например кои страници се посещават по-често и дали получават съобщения за грешка от уеб страници). Тези бисквитки се използват за статистически цели и за подобряване на производителността на една платформа.
                                        </td>
                                        <td>_ga_4S9N5MK4VE, _gat,_ga, _gcl_au, _gid: Бисквитките на Google Analytics се използват за измерване на трафика в Платформата. Записва се уникален текстов низ за идентифициране на браузъра, времевата марка за взаимодействия и браузъра/изходната страница, която е довела потребителя до Платформата. Не се запазва чувствителна информация.

                                        </td>
                                        <td>_ga_4S9N5MK4VE: 2 години
                                            <br><br>
                                            _gat:1 минута
                                            <br><br>
                                            _ga:2 години
                                            <br><br>
                                            _gcl_au:3 месеца
                                            <br><br>
                                            _gid:24 часа
                                        </td>
                                        <td>Да (компанията, която предоставя статистически и аналитични услуги, ако се счита за трета страна)
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">12. Политика на поверителността за децата  </h2>
                                Нашият проект не е насочен към никого на възраст под 18 години („Деца“). Ние не събираме с наше знание лична информация от лица под 18-годишна възраст. Ако сте родител или настойник и знаете, че вашите деца са ни предоставили лични данни, моля, свържете се с нас. Ако разберем, че сме събрали лични данни от деца без проверка на съгласието на родителите, ние предприемаме стъпки, за да премахнем тази информация от нашите сървъри.


                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">13. Изменения в тази Политика за поверителност </h2>
                                Администраторът на данни си запазва правото да изменя настоящата Политика за поверителност, например когато това е необходимо, за да се съобразят с нови изисквания, наложени от приложими закони, насоки или технически изисквания, или в хода на преразглеждане на процесите и практиките на Администратора на лични данни. Потребителят ще бъде уведомен за всяко изменение на тази Политика за поверителност чрез Платформата. Потребителят трябва редовно да проверява тази Политика за поверителност за евентуални изменения.
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
