@extends('home.layout')

@section('content')

    <div class="container pt-4 mb-2" style="margin-top: 100px">
        <div class="mb-5">
            <div class="row">
                <div class="col-12 mx-auto mb-3 text-center">
                    <h1>CODE OF CONDUCT</h1>
                </div>
            </div>
            <div class="row">
                <div class="col mx-auto">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col">
                                <p>As a crowdsourcing platform we welcome everyone, and encourage a friendly and
                                    positive environment.
                                    This code of conduct outlines our expectations from participants to ascertain
                                    successful participation, as well as steps to reporting unacceptable behavior. We
                                    are committed to providing a welcoming and inspiring environment for all and expect
                                    our code of conduct to be honored. Anyone who violates this code of conduct may be
                                    banned from the Platform or their responses can be deleted.
                                    During your participation in crowdsourcing projects:
                                </p>
                                <ul>
                                    <li>
                                        <strong>Be clear and relevant to the topic:</strong> Try to be precise and
                                        explain your thoughts and arguments with clarity. All answers must be relevant
                                        to the topic of the questionnaire. This will facilitate the platform’s
                                        moderators work, where they will have to analyze all given answers, categorize
                                        them and produce valuable insights that can have a positive impact οn the
                                        society.
                                    </li>
                                    <li><strong>Be respectful and kind:</strong> Not all of us will agree all the time,
                                        but disagreement is no excuse for poor behavior and poor manners. It’s important
                                        to remember that even though the answers you provide are anonymous, an
                                        environment where people feel uncomfortable or threatened is not a productive
                                        one. Of course harassment, insults, posting (or threatening to post) other
                                        people’s personally identifying information (“doxing”), racist or sexist terms,
                                        and other exclusionary behavior aren’t acceptable.
                                        If you just keep “respectful and kind” in mind, you can't go wrong.
                                    </li>
                                    <li><strong>Remember that your contribution is public:</strong> Your email and any
                                        personal information is not revealed by the platform. Though the textual answers
                                        you provide in the questionnaires, the answers to open-ended questions, may be
                                        publicly available. Do not include any personal information in your responses
                                        that you do not wish to be publicly available.
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">Diversity Statement
                                </h2>
                            </div>
                            <div class="col-12">
                                We encourage everyone to participate and are committed to building a community for all.
                                Although this list cannot be exhaustive, we explicitly honor diversity in age, gender,
                                gender identity or expression, culture, ethnicity, language, national origin, political
                                beliefs, profession, race, religion, sexual orientation, socioeconomic status, and
                                technical ability. We will not tolerate discrimination based on any of the protected
                                characteristics above, including participants with disabilities.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">Excluding inappropriate content
                                </h2>
                            </div>
                            <div class="col-12">
                                Platform facilitators will periodically review contributions posted by participants.
                                Facilitators can exclude inappropriate content from the platform, and explain reasons
                                for exclusion to the author of the excluded content.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">Reporting Issues
                                </h2>
                            </div>
                            <div class="col-12">
                                If you experience or witness unacceptable behavior, or have any other concerns, please
                                report it by contacting the organisers at {{ config("app.installation_company_email") }}
                                <br><br>
                                All reports will be handled with discretion. In your report please include:<br>
                                - Your contact information.<br>
                                - The questionnaire response that you wish to report. Provide the name of the project,
                                the question and the answer’s text that you want to report.
                                <br><br>
                                After filing a report, a representative will contact you personally, review the
                                incident, follow up with any additional questions, and make a decision as to how to
                                respond.

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">Attribution & Acknowledgements</h2>
                            </div>
                            <div class="col-12">
                                This code of conduct has used elements of the Code of Conduct from the <a
                                        href="https://openlifesci.org/code-of-conduct"> Open Life Science </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            @if ($goBackUrl)
                <div class=" mt-5 col-md-4 col-sm-12 mx-auto">
                    <a href="{{$goBackUrl}}" class="btn call-to-action go-back"><i
                                class="fas fa-long-arrow-alt-left"></i> Go Back</a>
                </div>
            @endif
        </div>
    </div>
@endsection
