@extends('home.layout')

@section('content')

    <div class="container pt-4 mb-2" style="margin-top: 100px">
        <div class="mb-5">
            <div class="row">
                <div class="col-12 mx-auto mb-3 text-center">
                    <h1>Кодекс за поведение</h1>
                </div>
            </div>
            <div class="row">
                <div class="col mx-auto">
                    <div class="container-fluid">
                        <div class="row">
                            <div class="col">
                                <p>Като краудсорсинг платформа, която събира мъдростта на множеството, ние приветстваме всеки и се стремим да поддържаме приятелска и позитивна среда. 
                                    Този кодекс за поведение очертава очакванията ни от участниците за да осигурим успешно участие, както и стъпките за докладване на неприемливо поведение. Ние се ангажираме да осигурим приветлива и вдъхновяваща среда за всички и очакваме нашия кодекс за поведение да бъде спазен. Достъпът до платформата на всеки, който нарушава този кодекс за поведение, може да бъде прекратен, или отговорите му могат да бъдат изтрити.
                                    По време на вашето участие в краудсорсинг проекти:                                    
                                </p>
                                <ul>
                                    <li>
                                        <strong>Бъдете ясни и изказвайте мнения само по темата:</strong> Опитайте се да бъдете точни и да обясните ясно мислите и аргументите си. Всички отговори трябва да са по темата на въпросника. Това ще улесни работата на модераторите на платформата, където те ще трябва да анализират всички дадени отговори, да ги категоризират и да направят важни заключения, които могат да имат положително въздействие върху обществото.
                                    </li>
                                    <li><strong>Бъдете уважителни и любезни:</strong> Не всички ще се съгласяваме постоянно един с друг, но несъгласието не е извинение за лошо поведение и лошо отношение. Важно е да запомните, че въпреки, че отговорите, които предоставяте са анонимни, среда, в която хората се чувстват неудобно или застрашени, не е продуктивна. Разбира се, тормоз, обиди, публикуване (или заплахи за публикуване) на лична идентифицираща информация на други хора, расистки или сексистки термини и друго дискриминационно поведение са неприемливи. Ако се държите уважително и любезно, няма как да сгрешите.
                                    </li>
                                    <li><strong>Не забравяйте, че Вашият принос е публичен:</strong> Вашият имейл и лична информация не се разкриват от платформата, въпреки че текстовите отговори, които предоставяте във въпросниците, и отговорите на отворените въпроси са публично достъпни. Не включвайте лична информация в отговорите си, която не желаете да бъде публично достъпна.
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">Декларация за разнообразието
                                </h2>
                            </div>
                            <div class="col-12">
                                Ние насърчаваме всички да участват и се ангажираме да изградим общност приемлива за всеки. Въпреки че този списък не може да бъде изчерпателен, ние изрично почитаме разнообразието във възраст, род, полова идентичност или изразяване, култура, етническа принадлежност, език, национален произход, политически убеждения, професия, раса, религия, сексуална ориентация, социално-икономически статус и технически способности. Ние няма да толерираме дискриминация въз основа на някоя от характеристиките включени по-горе, както и такава насочена към участници с увреждания.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">Премахване на съдържание, което не отговаря на този кодекс за поведение
                                </h2>
                            </div>
                            <div class="col-12">
                                Фасилитаторите на платформата периодично ще преглеждат идеите, публикувани от участниците. Фасилитаторите имат право да премахват съдържание, което не отговаря на този кодекс за поведение от Платформата и да обяснят на автора причините за премахването на това съдържание.
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">Докладване на проблеми
                                </h2>
                            </div>
                            <div class="col-12">
                                Ако бъдете подложен/а или станете свидетел на неприемливо поведение, или имате някакви други притеснения, моля, съобщете за това, като се свържете с организаторите на {{ config("app.installation_company_email") }}
                                <br><br>
                                Всички подобни сигнали ще се обработват при пълна конфиденциалност. Във Вашия сигнал, моля, включете:<br>
                                - Вашата информация за контакт.<br>
                                - Отговорът на въпросника, който желаете да докладвате. Посочете името на проекта, въпроса и текста на отговора, за който искате да докладвате.
                                <br><br>
                                След подаване на сигнал, наш представител ще се свърже с Вас лично, ще прегледа случая, ще разгледа възможни допълнителни въпроси и ще вземе решение как да отговори.

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <h2 class="mt-4 mb-4">Позоваване и благодарности</h2>
                            </div>
                            <div class="col-12">
                                Този кодекс използва елементи от Кодекса на поведение на <a href="https://openlifesci.org/code-of-conduct"> Open Life Science </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @if ($goBackUrl)
                <div class=" mt-5 col-md-4 col-sm-12 mx-auto">
                    <a href="{{$goBackUrl}}" class="btn call-to-action go-back"><i
                                class="fas fa-long-arrow-alt-left"></i> Назад към въпросника</a>
                </div>
            @endif
        </div>
    </div>
@endsection
