import 'package:jaspr/server.dart';
import 'package:jaspr_serverpod/jaspr_serverpod.dart';

import '../../src/services/quotes_service.dart';
import '../components/quote_like_button.dart';

class QuotePage extends AsyncStatelessComponent {
  const QuotePage({required this.id, super.key});

  final int id;

  @override
  Stream<Component> build(BuildContext context) async* {
    yield nav([
      a(href: "/", [text('Home')]),
    ]);

    var quote = await QuotesService.getQuoteById(context.session, id);
    if (quote == null) {
      yield div(classes: "center", [text("Not Found")]);
      return;
    }

    yield Document.head(
      title: quote.quote,
      meta: {"description": '"${quote.quote}" - ${quote.author}'},
      children: [
        script(src: "https://cdn.jsdelivr.net/npm/js-confetti@latest/dist/js-confetti.browser.js", defer: true, []),
      ],
    );

    yield div(classes: "center", [
      div(classes: "quote-container", [
        img(classes: "quotes-start", src: 'images/quote.jpg', alt: "Starting quote symbol", width: 100),
        h1([text(quote.quote)]),
        p([text(quote.author)]),
        QuoteLikeButton(id: id, initialCount: quote.likes.length),
        img(classes: "quotes-end", src: 'images/quote.jpg', alt: "Ending quote symbol", width: 100),
      ])
    ]);
  }

  @css
  static final styles = [
    css('nav').text(align: TextAlign.center).box(padding: EdgeInsets.all(20.px)),
    css('.center').box(height: 100.vh).flexbox(justifyContent: JustifyContent.center, alignItems: AlignItems.center),
    css('.quote-container', [
      css('&').box(position: Position.relative()).text(align: TextAlign.center),
      css('.quotes-start')
          .box(position: Position.absolute(top: (-100).px, left: (-10).px), transform: Transform.rotate(180.deg)),
      css('.quotes-end').box(position: Position.absolute(right: (-10).px, bottom: (-50).px)),
      css('h1').text(fontSize: 40.px),
      css('p').text(fontStyle: FontStyle.italic, fontWeight: FontWeight.normal),
    ]),
  ];
}
